/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.FetchedTimestampAndOffset$;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.LogFlushStats$;
import kafka.log.LogSegment$;
import kafka.log.SegmentStats$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LazyIndex;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import org.apache.kafka.storage.internals.log.TxnIndexSearchResult;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dd\u0001B1c\u0001\u001dD\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001e\u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\nUD!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011)\t\u0019\u0003\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003K\u0001!Q1A\u0005\u0002\u0005\u001d\u0002BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u0002*!Q\u00111\u0007\u0001\u0003\u0006\u0004%\t!!\u000e\t\u0015\u0005u\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002@\u0001\u0011)\u0019!C\u0001\u0003\u0003B!\"!\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA\"\u0011)\tY\u0005\u0001BC\u0002\u0013\u0005\u0011Q\n\u0005\u000b\u0003+\u0002!\u0011!Q\u0001\n\u0005=\u0003BCA,\u0001\t\u0015\r\u0011\"\u0001\u0002B!Q\u0011\u0011\f\u0001\u0003\u0002\u0003\u0006I!a\u0011\t\u0015\u0005m\u0003A!b\u0001\n\u0003\ti\u0006\u0003\u0006\u0002j\u0001\u0011\t\u0011)A\u0005\u0003?B\u0001\"a\u001b\u0001\t\u0003\u0011\u0017Q\u000e\u0005\b\u0003\u0007\u0003A\u0011AAC\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013Cq!a#\u0001\t\u0003\ti\tC\u0004\u0002 \u0002!\t!!)\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"I\u0011Q\u0017\u0001A\u0002\u0013%\u0011\u0011\t\u0005\n\u0003o\u0003\u0001\u0019!C\u0005\u0003sC\u0001\"a0\u0001A\u0003&\u00111\t\u0005\n\u0003\u0003\u0004\u0001\u0019!C\u0005\u0003\u001bB\u0011\"a1\u0001\u0001\u0004%I!!2\t\u0011\u0005%\u0007\u0001)Q\u0005\u0003\u001fB\u0011\"a3\u0001\u0001\u0004%I!!4\t\u0013\u0005U\u0007\u00011A\u0005\n\u0005]\u0007\u0002CAn\u0001\u0001\u0006K!a4\t\u0013\u0005\u0015\b\u00011A\u0005\u0002\u00055\u0007\"CAt\u0001\u0001\u0007I\u0011AAu\u0011!\ti\u000f\u0001Q!\n\u0005=\u0007\"CAy\u0001\u0001\u0007I\u0011BAz\u0011%\tY\u0010\u0001a\u0001\n\u0013\ti\u0010\u0003\u0005\u0003\u0002\u0001\u0001\u000b\u0015BA{\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqA!\u0004\u0001\t\u0003\t\u0019\u0010C\u0004\u0003\u0010\u0001!\t!!\u0011\t\u000f\tE\u0001\u0001\"\u0001\u0002B!9\u00111\u0016\u0001\u0005\u0002\u00055\u0003b\u0002B\n\u0001\u0011\u0005!Q\u0003\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0011\u001d\u0011)\u0004\u0001C\u0005\u0005oAqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003P\u0001!IA!\u0015\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!9!1\u000e\u0001\u0005\u0002\t5\u0004b\u0002B@\u0001\u0011%!\u0011\u0011\u0005\t\u0005'\u0003A\u0011\u00012\u0003\u0016\"Q!Q\u001a\u0001\u0012\u0002\u0013\u0005!Ma4\t\u000f\t\u0015\b\u0001\"\u0001\u0003h\"I1\u0011\u0001\u0001\u0012\u0002\u0013\u000511\u0001\u0005\n\u0007\u000f\u0001\u0011\u0013!C\u0001\u0007\u0013Aqa!\u0004\u0001\t\u0003\u0019y\u0001C\u0004\u00040\u0001!\ta!\r\t\u0013\r%\u0003!%A\u0005\u0002\r-\u0003bBB(\u0001\u0011%1\u0011\u000b\u0005\b\u0007'\u0002A\u0011AB+\u0011\u001d\u00199\u0006\u0001C\u0001\u00073Bqa!\u001b\u0001\t\u0003\u001aY\u0007C\u0004\u0004~\u0001!\taa \t\u000f\r\u0015\u0005\u0001\"\u0001\u0004\b\"A1\u0011\u0012\u0001!\u0002\u0013\u0019Y\tC\u0004\u0004\u001c\u0002!\t!!\u0011\t\u000f\r}\u0005\u0001\"\u0001\u0004R!911\u0015\u0001\u0005\u0002\r\u0015\u0006bBB\\\u0001\u0011\u00051\u0011\u0018\u0005\b\u0007\u0007\u0004A\u0011ABc\u0011\u001d\u0019Y\r\u0001C\u0001\u0007#Bqa!4\u0001\t\u0013\u0019\t\u0006C\u0004\u0004P\u0002!\ta!5\t\u000f\rm\u0007\u0001\"\u0001\u0004\b\"91Q\u001c\u0001\u0005\u0002\r}\u0007\"CB{\u0001E\u0005I\u0011AB\u0002\u0011\u001d\u00199\u0010\u0001C\u0001\u0007#Bqa!?\u0001\t\u0003\u0019\t\u0006C\u0004\u0004|\u0002!\ta!\u0015\t\u000f\ru\b\u0001\"\u0001\u0004\u0000\"9A\u0011\u0001\u0001\u0005\u0002\u0005\u0005\u0003b\u0002C\u0002\u0001\u0011\u0005\u0011Q\u001a\u0005\b\t\u000b\u0001A\u0011AA!\u0011\u001d!9\u0001\u0001C\u0001\t\u00139q\u0001\"\tc\u0011\u0003!\u0019C\u0002\u0004bE\"\u0005AQ\u0005\u0005\b\u0003W2F\u0011\u0001C\u0014\u0011%!IC\u0016b\u0001\n\u0013\t\t\u0005\u0003\u0005\u0005,Y\u0003\u000b\u0011BA\"\u0011\u001d!iC\u0016C\u0001\t_A\u0011\u0002\"\u0015W#\u0003%\ta!\u0003\t\u0013\u0011Mc+%A\u0005\u0002\t=\u0007\"\u0003C+-F\u0005I\u0011AB\u0005\u0011%!9FVI\u0001\n\u0003!I\u0006C\u0004\u0004|Z#\t\u0001\"\u0018\t\u0013\u0011\u0015d+%A\u0005\u0002\u0011e#A\u0003'pON+w-\\3oi*\u00111\rZ\u0001\u0004Y><'\"A3\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u001b8\u0011\u0005%dW\"\u00016\u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0003\r\u0005s\u0017PU3g!\ty'/D\u0001q\u0015\t\tH-A\u0003vi&d7/\u0003\u0002ta\n9Aj\\4hS:<W#A;\u0011\u0007Y\f\t!D\u0001x\u0015\tA\u00180\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0003un\faaY8n[>t'BA3}\u0015\tih0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0006\u0019qN]4\n\u0007\u0005\rqOA\u0006GS2,'+Z2pe\u0012\u001c\u0018\u0001\u00027pO\u0002\nq\u0002\\1{s>3gm]3u\u0013:$W\r_\u000b\u0003\u0003\u0017\u0001b!!\u0004\u0002\u001a\u0005uQBAA\b\u0015\r\u0019\u0017\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0005j]R,'O\\1mg*\u0019\u0011qC>\u0002\u000fM$xN]1hK&!\u00111DA\b\u0005%a\u0015M_=J]\u0012,\u0007\u0010\u0005\u0003\u0002\u000e\u0005}\u0011\u0002BA\u0011\u0003\u001f\u00111b\u00144gg\u0016$\u0018J\u001c3fq\u0006\u0001B.\u0019>z\u001f\u001a47/\u001a;J]\u0012,\u0007\u0010I\u0001\u000eY\u0006T\u0018\u0010V5nK&sG-\u001a=\u0016\u0005\u0005%\u0002CBA\u0007\u00033\tY\u0003\u0005\u0003\u0002\u000e\u00055\u0012\u0002BA\u0018\u0003\u001f\u0011\u0011\u0002V5nK&sG-\u001a=\u0002\u001d1\f'0\u001f+j[\u0016Le\u000eZ3yA\u0005AA\u000f\u001f8J]\u0012,\u00070\u0006\u0002\u00028A!\u0011QBA\u001d\u0013\u0011\tY$a\u0004\u0003!Q\u0013\u0018M\\:bGRLwN\\%oI\u0016D\u0018!\u0003;y]&sG-\u001a=!\u0003)\u0011\u0017m]3PM\u001a\u001cX\r^\u000b\u0003\u0003\u0007\u00022![A#\u0013\r\t9E\u001b\u0002\u0005\u0019>tw-A\u0006cCN,wJ\u001a4tKR\u0004\u0013AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKN,\"!a\u0014\u0011\u0007%\f\t&C\u0002\u0002T)\u00141!\u00138u\u0003MIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:!\u00031\u0011x\u000e\u001c7KSR$XM]'t\u00035\u0011x\u000e\u001c7KSR$XM]'tA\u0005!A/[7f+\t\ty\u0006\u0005\u0003\u0002b\u0005\u0015TBAA2\u0015\t\t\u00180\u0003\u0003\u0002h\u0005\r$\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\na\u0001P5oSRtDCEA8\u0003g\n)(a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u00032!!\u001d\u0001\u001b\u0005\u0011\u0007\"B2\u0012\u0001\u0004)\bbBA\u0004#\u0001\u0007\u00111\u0002\u0005\b\u0003K\t\u0002\u0019AA\u0015\u0011\u001d\t\u0019$\u0005a\u0001\u0003oAq!a\u0010\u0012\u0001\u0004\t\u0019\u0005C\u0004\u0002LE\u0001\r!a\u0014\t\u000f\u0005]\u0013\u00031\u0001\u0002D!9\u00111L\tA\u0002\u0005}\u0013aC8gMN,G/\u00138eKb,\"!!\b\u0002\u0013QLW.Z%oI\u0016DXCAA\u0016\u0003)\u0019\bn\\;mIJ{G\u000e\u001c\u000b\u0005\u0003\u001f\u000b)\nE\u0002j\u0003#K1!a%k\u0005\u001d\u0011un\u001c7fC:Dq!a&\u0015\u0001\u0004\tI*\u0001\u0006s_2d\u0007+\u0019:b[N\u0004B!!\u0004\u0002\u001c&!\u0011QTA\b\u0005)\u0011v\u000e\u001c7QCJ\fWn]\u0001\u000ee\u0016\u001c\u0018N_3J]\u0012,\u00070Z:\u0015\t\u0005\r\u0016\u0011\u0016\t\u0004S\u0006\u0015\u0016bAATU\n!QK\\5u\u0011\u001d\tY+\u0006a\u0001\u0003\u001f\nAa]5{K\u0006Y1/\u00198jif\u001c\u0005.Z2l)\u0011\t\u0019+!-\t\u000f\u0005Mf\u00031\u0001\u0002\u0010\u0006IB/[7f\u0013:$W\r\u001f$jY\u0016tUm\u001e7z\u0007J,\u0017\r^3e\u0003\u001d\u0019'/Z1uK\u0012\f1b\u0019:fCR,Gm\u0018\u0013fcR!\u00111UA^\u0011%\ti\fGA\u0001\u0002\u0004\t\u0019%A\u0002yIE\n\u0001b\u0019:fCR,G\rI\u0001\u0019Ef$Xm]*j]\u000e,G*Y:u\u0013:$W\r_#oiJL\u0018\u0001\b2zi\u0016\u001c8+\u001b8dK2\u000b7\u000f^%oI\u0016DXI\u001c;ss~#S-\u001d\u000b\u0005\u0003G\u000b9\rC\u0005\u0002>n\t\t\u00111\u0001\u0002P\u0005I\"-\u001f;fgNKgnY3MCN$\u0018J\u001c3fq\u0016sGO]=!\u0003U\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B,\"!a4\u0011\u000b%\f\t.a\u0011\n\u0007\u0005M'N\u0001\u0004PaRLwN\\\u0001\u001ae>dG.\u001b8h\u0005\u0006\u001cX\r\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0006e\u0007\"CA_=\u0005\u0005\t\u0019AAh\u0003Y\u0011x\u000e\u001c7j]\u001e\u0014\u0015m]3e)&lWm\u001d;b[B\u0004\u0003fA\u0010\u0002`B\u0019\u0011.!9\n\u0007\u0005\r(N\u0001\u0005w_2\fG/\u001b7f\u0003Ea\u0017m\u001d;GYV\u001c\b.\u001a3US6,Wj]\u0001\u0016Y\u0006\u001cHO\u00127vg\",G\rV5nK6\u001bx\fJ3r)\u0011\t\u0019+a;\t\u0013\u0005u\u0016%!AA\u0002\u0005=\u0017A\u00057bgR4E.^:iK\u0012$\u0016.\\3Ng\u0002B3AIAp\u0003myV.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$beV\u0011\u0011Q\u001f\t\u0005\u0003\u001b\t90\u0003\u0003\u0002z\u0006=!a\u0004+j[\u0016\u001cH/Y7q\u001f\u001a47/\u001a;\u0002?}k\u0017\r\u001f+j[\u0016\u001cH/Y7q\u0003:$wJ\u001a4tKR\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0006}\b\"CA_I\u0005\u0005\t\u0019AA{\u0003qyV.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be\u0002B3!JAp\u0003yi\u0017\r\u001f+j[\u0016\u001cH/Y7q\u0003:$wJ\u001a4tKR\u001cvNR1s?\u0012*\u0017\u000f\u0006\u0003\u0002$\n%\u0001b\u0002B\u0006M\u0001\u0007\u0011Q_\u0001\u0010i&lWm\u001d;b[B|eMZ:fi\u0006QR.\u0019=US6,7\u000f^1na\u0006sGm\u00144gg\u0016$8k\u001c$be\u0006\tR.\u0019=US6,7\u000f^1naN{g)\u0019:\u00023=4gm]3u\u001f\u001al\u0015\r\u001f+j[\u0016\u001cH/Y7q'>4\u0015M]\u0001\u001bG\u0006t7i\u001c8wKJ$Hk\u001c*fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003\u001f\u00139\u0002C\u0004\u0003\u001a-\u0002\r!a\u0011\u0002\r=4gm]3u\u0003\u0019\t\u0007\u000f]3oIR1\u00111\u0015B\u0010\u0005GAqA!\t-\u0001\u0004\t\u0019%\u0001\u0006mCN$xJ\u001a4tKRDqA!\n-\u0001\u0004\u00119#A\u0004sK\u000e|'\u000fZ:\u0011\u0007Y\u0014I#C\u0002\u0003,]\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\bf\u0001\u0017\u00030A\u0019qN!\r\n\u0007\tM\u0002OA\u0007o_:$\bN]3bIN\fg-Z\u0001\u0014K:\u001cXO]3PM\u001a\u001cX\r^%o%\u0006tw-\u001a\u000b\u0005\u0003G\u0013I\u0004C\u0004\u0003\u001a5\u0002\r!a\u0011\u0002+U\u0004H-\u0019;f'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uCR1\u00111\u0015B \u0005\u0007BqA!\u0011/\u0001\u0004\ty%\u0001\u0005q_NLG/[8o\u0011\u001d\u0011)E\fa\u0001\u0005\u000f\nQAY1uG\"\u00042A\u001eB%\u0013\r\u0011Ye\u001e\u0002\f%\u0016\u001cwN\u001d3CCR\u001c\u0007\u000eK\u0002/\u0005_\t1#\u00199qK:$7\t[;oW\u001a\u0013x.\u001c$jY\u0016$\u0002\"a\u0014\u0003T\tU#q\u000b\u0005\u0007\u0005Ky\u0003\u0019A;\t\u000f\t\u0005s\u00061\u0001\u0002P!9!\u0011L\u0018A\u0002\tm\u0013A\u00042vM\u001a,'oU;qa2LWM\u001d\t\u0005\u0003C\u0012i&\u0003\u0003\u0003`\u0005\r$A\u0004\"vM\u001a,'oU;qa2LWM]\u0001\u000fCB\u0004XM\u001c3Ge>lg)\u001b7f)\u0019\tyE!\u001a\u0003h!1!Q\u0005\u0019A\u0002UDqA!\u001b1\u0001\u0004\ty%A\u0003ti\u0006\u0014H/\u0001\bva\u0012\fG/\u001a+y]&sG-\u001a=\u0015\r\u0005\r&q\u000eB=\u0011\u001d\u0011\t(\ra\u0001\u0005g\nAbY8na2,G/\u001a3Uq:\u0004B!!\u0004\u0003v%!!qOA\b\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0011\u001d\u0011Y(\ra\u0001\u0003\u0007\n\u0001\u0003\\1tiN#\u0018M\u00197f\u001f\u001a47/\u001a;)\u0007E\u0012y#A\nva\u0012\fG/\u001a)s_\u0012,8-\u001a:Ti\u0006$X\r\u0006\u0005\u0002$\n\r%Q\u0012BH\u0011\u001d\u0011)I\ra\u0001\u0005\u000f\u000bA\u0003\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\b\u0003BA\u0007\u0005\u0013KAAa#\u0002\u0010\t!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJDqA!\u00123\u0001\u0004\u00119\u0005C\u0004\u0003\u0012J\u0002\r!a\u0011\u0002\u001b\r,(O]3oiRKW.Z't\u0003=!(/\u00198tY\u0006$Xm\u00144gg\u0016$HC\u0002BL\u0005\u007f\u0013\t\r\u0005\u0003\u0003\u001a\nef\u0002\u0002BN\u0005ksAA!(\u00034:!!q\u0014BY\u001d\u0011\u0011\tKa,\u000f\t\t\r&Q\u0016\b\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*\u0019!\u0011\u00164\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0018BA?\u007f\u0013\t)G0\u0003\u0002{w&\u0011\u00010_\u0005\u0004\u0005o;\u0018a\u0003$jY\u0016\u0014VmY8sINLAAa/\u0003>\n\tBj\\4PM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\u000b\u0007\t]v\u000fC\u0004\u0003\u001aM\u0002\r!a\u0011\t\u0013\t\r7\u0007%AA\u0002\u0005=\u0013\u0001F:uCJ$\u0018N\\4GS2,\u0007k\\:ji&|g\u000eK\u00024\u0005\u000f\u00042a\u001cBe\u0013\r\u0011Y\r\u001d\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0017!\u0007;sC:\u001cH.\u0019;f\u001f\u001a47/\u001a;%I\u00164\u0017-\u001e7uII*\"A!5+\t\u0005=#1[\u0016\u0003\u0005+\u0004BAa6\u0003b6\u0011!\u0011\u001c\u0006\u0005\u00057\u0014i.A\u0005v]\u000eDWmY6fI*\u0019!q\u001c6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003d\ne'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!!/Z1e))\u0011IOa<\u0003t\n](1 \t\u0005\u0003\u001b\u0011Y/\u0003\u0003\u0003n\u0006=!!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000eC\u0004\u0003rV\u0002\r!a\u0011\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\b\u0005k,\u0004\u0019AA(\u0003\u001di\u0017\r_*ju\u0016D\u0011B!?6!\u0003\u0005\r!a\u0011\u0002\u00175\f\u0007\u0010U8tSRLwN\u001c\u0005\n\u0005{,\u0004\u0013!a\u0001\u0003\u001f\u000bQ\"\\5o\u001f:,W*Z:tC\u001e,\u0007fA\u001b\u0003H\u0006q!/Z1eI\u0011,g-Y;mi\u0012\u001aTCAB\u0003U\u0011\t\u0019Ea5\u0002\u001dI,\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u001111\u0002\u0016\u0005\u0003\u001f\u0013\u0019.A\u000bgKR\u001c\u0007.\u00169qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0015\r\rE1\u0011EB\u0016!\u0019\u0019\u0019b!\b\u0002D5\u00111Q\u0003\u0006\u0005\u0007/\u0019I\"\u0001\u0003vi&d'BAB\u000e\u0003\u0011Q\u0017M^1\n\t\r}1Q\u0003\u0002\t\u001fB$\u0018n\u001c8bY\"911\u0005\u001dA\u0002\r\u0015\u0012aE:uCJ$xJ\u001a4tKR\u0004vn]5uS>t\u0007\u0003BA\u0007\u0007OIAa!\u000b\u0002\u0010\tqqJ\u001a4tKR\u0004vn]5uS>t\u0007bBB\u0017q\u0001\u0007\u0011qJ\u0001\nM\u0016$8\r[*ju\u0016\fqA]3d_Z,'\u000f\u0006\u0004\u0002P\rM2Q\u0007\u0005\b\u0005\u000bK\u0004\u0019\u0001BD\u0011%\u00199$\u000fI\u0001\u0002\u0004\u0019I$\u0001\tmK\u0006$WM]#q_\u000eD7)Y2iKB)\u0011.!5\u0004<A!1QHB\"\u001b\t\u0019yD\u0003\u0003\u0004B\u0005E\u0011!B3q_\u000eD\u0017\u0002BB#\u0007\u007f\u0011A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",\u0007fA\u001d\u00030\u0005\t\"/Z2pm\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r5#\u0006BB\u001d\u0005'\fA\u0003\\8bI2\u000b'oZ3tiRKW.Z:uC6\u0004HCAAR\u0003-A\u0017m](wKJ4Gn\\<\u0016\u0005\u0005=\u0015AE2pY2,7\r^!c_J$X\r\u001a+y]N$baa\u0017\u0004b\r\u0015\u0004\u0003BA\u0007\u0007;JAaa\u0018\u0002\u0010\t!B\u000b\u001f8J]\u0012,\u0007pU3be\u000eD'+Z:vYRDqaa\u0019>\u0001\u0004\t\u0019%A\u0006gKR\u001c\u0007n\u00144gg\u0016$\bbBB4{\u0001\u0007\u00111I\u0001\u0011kB\u0004XM\u001d\"pk:$wJ\u001a4tKR\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0007[\u0002Baa\u001c\u0004x9!1\u0011OB:!\r\u0011)K[\u0005\u0004\u0007kR\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0004z\rm$AB*ue&twMC\u0002\u0004v)\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\u0011\tye!!\t\u000f\teq\b1\u0001\u0002D!\u001aqHa\f\u0002\u001dM\u001c\u0017M\u001c(fqR|eMZ:fiR\u0011\u00111I\u0001\u0012Y\u0006\u001cHoU3h[\u0016tGo\u00144gg\u0016$\b\u0003BBG\u0007/k!aa$\u000b\t\rE51S\u0001\u0007CR|W.[2\u000b\t\rU5QC\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BBM\u0007\u001f\u0013!\"\u0011;p[&\u001cGj\u001c8h\u00039\u0011X-\u00193OKb$xJ\u001a4tKRD3A\u0011Bd\u0003\u00151G.^:iQ\r\u0019%qY\u0001\u0010kB$\u0017\r^3QCJ,g\u000e\u001e#jeR!\u00111UBT\u0011\u001d\u0019I\u000b\u0012a\u0001\u0007W\u000b1\u0001Z5s!\u0011\u0019ika-\u000e\u0005\r=&\u0002BBY\u00073\t!![8\n\t\rU6q\u0016\u0002\u0005\r&dW-\u0001\ndQ\u0006tw-\u001a$jY\u0016\u001cVO\u001a4jq\u0016\u001cHCBAR\u0007w\u001by\fC\u0004\u0004>\u0016\u0003\ra!\u001c\u0002\u0013=dGmU;gM&D\bbBBa\u000b\u0002\u00071QN\u0001\n]\u0016<8+\u001e4gSb\f\u0011\u0002[1t'V4g-\u001b=\u0015\t\u0005=5q\u0019\u0005\b\u0007\u00134\u0005\u0019AB7\u0003\u0019\u0019XO\u001a4jq\u00069rN\u001c\"fG>lW-\u00138bGRLg/Z*fO6,g\u000e^\u0001\u0018Y>\fGMR5sgR\u0014\u0015\r^2i)&lWm\u001d;b[B\f\u0011\u0003^5nK^\u000b\u0017\u000e^3e\r>\u0014(k\u001c7m)\u0019\t\u0019ea5\u0004X\"91Q[%A\u0002\u0005\r\u0013a\u00018po\"91\u0011\\%A\u0002\u0005\r\u0013\u0001E7fgN\fw-\u001a+j[\u0016\u001cH/Y7q\u0003Y9W\r\u001e$jeN$()\u0019;dQRKW.Z:uC6\u0004\u0018!\u00064j]\u0012|eMZ:fi\nKH+[7fgR\fW\u000e\u001d\u000b\u0007\u0007C\u001cio!=\u0011\u000b%\f\tna9\u0011\t\r\u00158\u0011^\u0007\u0003\u0007OT!A\u001f3\n\t\r-8q\u001d\u0002\u001a\r\u0016$8\r[3e)&lWm\u001d;b[B\fe\u000eZ(gMN,G\u000fC\u0004\u0004p.\u0003\r!a\u0011\u0002\u0013QLW.Z:uC6\u0004\b\"CBz\u0017B\u0005\t\u0019AA\"\u00039\u0019H/\u0019:uS:<wJ\u001a4tKR\fqDZ5oI>3gm]3u\u0005f$\u0016.\\3ti\u0006l\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003\u0015\u0019Gn\\:f\u00035\u0019Gn\\:f\u0011\u0006tG\r\\3sg\u0006qA-\u001a7fi\u0016Le-\u0012=jgR\u001c\u0018a\u00023fY\u0016$X\r\u001a\u000b\u0003\u0003\u001f\u000bA\u0002\\1ti6{G-\u001b4jK\u0012\fa\u0003\\1sO\u0016\u001cHOU3d_J$G+[7fgR\fW\u000e]\u0001\u0011Y\u0006\u0014x-Z:u)&lWm\u001d;b[B\f\u0001\u0003\\1ti6{G-\u001b4jK\u0012|F%Z9\u0015\t\u0011-A1\u0004\t\u0005\t\u001b!9\"\u0004\u0002\u0005\u0010)!A\u0011\u0003C\n\u0003\u00111\u0017\u000e\\3\u000b\t\u0011U1\u0011D\u0001\u0004]&|\u0017\u0002\u0002C\r\t\u001f\u0011A\u0001U1uQ\"9AQ\u0004+A\u0002\u0005\r\u0013AA7tQ\r\u0001!qF\u0001\u000b\u0019><7+Z4nK:$\bcAA9-N\u0011a\u000b\u001b\u000b\u0003\tG\t\u0011#\u00168l]><h\u000eT1ti>3gm]3u\u0003I)fn\u001b8po:d\u0015m\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\t=\u0004XM\u001c\u000b\u0013\u0003_\"\t\u0004b\r\u00056\u0011}B\u0011\tC#\t\u0013\"i\u0005C\u0004\u0004*j\u0003\raa+\t\u000f\u0005}\"\f1\u0001\u0002D!9Aq\u0007.A\u0002\u0011e\u0012AB2p]\u001aLw\r\u0005\u0003\u0002\u000e\u0011m\u0012\u0002\u0002C\u001f\u0003\u001f\u0011\u0011\u0002T8h\u0007>tg-[4\t\u000f\u0005m#\f1\u0001\u0002`!IA1\t.\u0011\u0002\u0003\u0007\u0011qR\u0001\u0012M&dW-\u00117sK\u0006$\u00170\u0012=jgR\u001c\b\"\u0003C$5B\u0005\t\u0019AA(\u00031Ig.\u001b;GS2,7+\u001b>f\u0011%!YE\u0017I\u0001\u0002\u0004\ty)A\u0006qe\u0016\fG\u000e\\8dCR,\u0007\"\u0003C(5B\u0005\t\u0019AB7\u0003)1\u0017\u000e\\3Tk\u001a4\u0017\u000e_\u0001\u000f_B,g\u000e\n3fM\u0006,H\u000e\u001e\u00136\u00039y\u0007/\u001a8%I\u00164\u0017-\u001e7uIY\nab\u001c9f]\u0012\"WMZ1vYR$s'\u0001\bpa\u0016tG\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0011m#\u0006BB7\u0005'$\u0002\"a)\u0005`\u0011\u0005D1\r\u0005\b\u0007S{\u0006\u0019ABV\u0011\u001d\tyd\u0018a\u0001\u0003\u0007B\u0011\u0002b\u0014`!\u0003\u0005\ra!\u001c\u00021\u0011,G.\u001a;f\u0013\u001a,\u00050[:ug\u0012\"WMZ1vYR$3\u0007")
public class LogSegment
implements Logging {
    private final FileRecords log;
    private final LazyIndex<OffsetIndex> lazyOffsetIndex;
    private final LazyIndex<TimeIndex> lazyTimeIndex;
    private final TransactionIndex txnIndex;
    private final long baseOffset;
    private final int indexIntervalBytes;
    private final long rollJitterMs;
    private final Time time;
    private long created;
    private int bytesSinceLastIndexEntry;
    private volatile Option<Object> rollingBasedTimestamp;
    private volatile Option<Object> lastFlushedTimeMs;
    private volatile TimestampOffset _maxTimestampAndOffsetSoFar;
    private final AtomicLong lastSegmentOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String deleteIfExists$default$3() {
        return LogSegment$.MODULE$.deleteIfExists$default$3();
    }

    public static String open$default$8() {
        return LogSegment$.MODULE$.open$default$8();
    }

    public static boolean open$default$7() {
        return LogSegment$.MODULE$.open$default$7();
    }

    public static int open$default$6() {
        return LogSegment$.MODULE$.open$default$6();
    }

    public static boolean open$default$5() {
        return LogSegment$.MODULE$.open$default$5();
    }

    public static LogSegment open(File file, long l, LogConfig logConfig, Time time, boolean bl, int n, boolean bl2, String string) {
        return LogSegment$.MODULE$.open(file, l, logConfig, time, bl, n, bl2, string);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FileRecords log() {
        return this.log;
    }

    public LazyIndex<OffsetIndex> lazyOffsetIndex() {
        return this.lazyOffsetIndex;
    }

    public LazyIndex<TimeIndex> lazyTimeIndex() {
        return this.lazyTimeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    public long rollJitterMs() {
        return this.rollJitterMs;
    }

    public Time time() {
        return this.time;
    }

    public OffsetIndex offsetIndex() {
        return (OffsetIndex)this.lazyOffsetIndex().get();
    }

    public TimeIndex timeIndex() {
        return (TimeIndex)this.lazyTimeIndex().get();
    }

    public boolean shouldRoll(RollParams rollParams) {
        boolean reachedRollMs;
        boolean bl = reachedRollMs = this.timeWaitedForRoll(rollParams.now, rollParams.maxTimestampInMessages) > rollParams.maxSegmentMs - this.rollJitterMs();
        return this.size() > rollParams.maxSegmentBytes - rollParams.messagesSize || this.size() > 0 && reachedRollMs || this.offsetIndex().isFull() || this.timeIndex().isFull() || !this.canConvertToRelativeOffset(rollParams.maxOffsetInMessages);
    }

    public void resizeIndexes(int size) {
        ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToBoolean((boolean)LogSegment.$anonfun$resizeIndexes$1(this, size)));
    }

    public void sanityCheck(boolean timeIndexFileNewlyCreated) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$sanityCheck$1(this, timeIndexFileNewlyCreated);
            return BoxedUnit.UNIT;
        });
    }

    private long created() {
        return this.created;
    }

    private void created_$eq(long x$1) {
        this.created = x$1;
    }

    private int bytesSinceLastIndexEntry() {
        return this.bytesSinceLastIndexEntry;
    }

    private void bytesSinceLastIndexEntry_$eq(int x$1) {
        this.bytesSinceLastIndexEntry = x$1;
    }

    private Option<Object> rollingBasedTimestamp() {
        return this.rollingBasedTimestamp;
    }

    private void rollingBasedTimestamp_$eq(Option<Object> x$1) {
        this.rollingBasedTimestamp = x$1;
    }

    public Option<Object> lastFlushedTimeMs() {
        return this.lastFlushedTimeMs;
    }

    public void lastFlushedTimeMs_$eq(Option<Object> x$1) {
        this.lastFlushedTimeMs = x$1;
    }

    private TimestampOffset _maxTimestampAndOffsetSoFar() {
        return this._maxTimestampAndOffsetSoFar;
    }

    private void _maxTimestampAndOffsetSoFar_$eq(TimestampOffset x$1) {
        this._maxTimestampAndOffsetSoFar = x$1;
    }

    public void maxTimestampAndOffsetSoFar_$eq(TimestampOffset timestampOffset) {
        this._maxTimestampAndOffsetSoFar_$eq(timestampOffset);
    }

    public TimestampOffset maxTimestampAndOffsetSoFar() {
        TimestampOffset timestampOffset = this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset.UNKNOWN;
        if (!(timestampOffset != null ? !timestampOffset.equals(timestampOffset2) : timestampOffset2 != null)) {
            this._maxTimestampAndOffsetSoFar_$eq(this.timeIndex().lastEntry());
        }
        return this._maxTimestampAndOffsetSoFar();
    }

    public long maxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().timestamp;
    }

    public long offsetOfMaxTimestampSoFar() {
        return this.maxTimestampAndOffsetSoFar().offset;
    }

    public int size() {
        return this.log().sizeInBytes();
    }

    public boolean canConvertToRelativeOffset(long offset) {
        return this.offsetIndex().canAppendOffset(offset);
    }

    public void append(long lastOffset, MemoryRecords records) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$append$1(this, records, lastOffset);
            return BoxedUnit.UNIT;
        });
    }

    private void ensureOffsetInRange(long offset) {
        if (!this.canConvertToRelativeOffset(offset)) {
            throw new LogSegmentOffsetOverflowException(this, offset);
        }
    }

    private void updateSegmentMetadata(int position, RecordBatch batch) {
        long lastOffset = batch.lastOffset();
        long batchMaxTimestamp = batch.maxTimestamp();
        this.lastSegmentOffset.set(lastOffset);
        this.ensureOffsetInRange(lastOffset);
        if (position == 0) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)batchMaxTimestamp)));
        }
        if (batchMaxTimestamp > this.maxTimestampSoFar()) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(batchMaxTimestamp, lastOffset));
        }
        if (this.bytesSinceLastIndexEntry() > this.indexIntervalBytes()) {
            if (!this.offsetIndex().isFull()) {
                SegmentStats$.MODULE$.offsetIndexAppendTimeMs().time(() -> {
                    LogSegment.$anonfun$updateSegmentMetadata$1(this, lastOffset, position);
                    return BoxedUnit.UNIT;
                });
            }
            if (!this.timeIndex().isFull()) {
                SegmentStats$.MODULE$.timestampIndexAppendTimeMs().time(() -> {
                    LogSegment.$anonfun$updateSegmentMetadata$2(this);
                    return BoxedUnit.UNIT;
                });
            }
            this.bytesSinceLastIndexEntry_$eq(0);
        }
        this.bytesSinceLastIndexEntry_$eq(this.bytesSinceLastIndexEntry() + batch.sizeInBytes());
    }

    private int appendChunkFromFile(FileRecords records, int position, BufferSupplier bufferSupplier) {
        IntRef bytesToAppend = IntRef.create((int)0);
        LongRef maxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)Long.MIN_VALUE);
        LongRef maxOffset = LongRef.create((long)Long.MIN_VALUE);
        ObjectRef readBuffer = ObjectRef.create((Object)bufferSupplier.get(0x100000));
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batchesFrom(position)).asScala()).iterator().takeWhile((Function1 & Serializable & scala.Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)this.canAppend$1(batch, bytesToAppend, readBuffer))).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogSegment.$anonfun$appendChunkFromFile$2(maxTimestamp, offsetOfMaxTimestamp, maxOffset, bytesToAppend, batch);
            return BoxedUnit.UNIT;
        });
        if (bytesToAppend.elem > 0) {
            if (((ByteBuffer)readBuffer.elem).capacity() < bytesToAppend.elem) {
                readBuffer.elem = bufferSupplier.get(bytesToAppend.elem);
            }
            ((ByteBuffer)readBuffer.elem).limit(bytesToAppend.elem);
            records.readInto((ByteBuffer)readBuffer.elem, position);
            this.append(maxOffset.elem, MemoryRecords.readableRecords((ByteBuffer)((ByteBuffer)readBuffer.elem)));
        }
        bufferSupplier.release((ByteBuffer)readBuffer.elem);
        return bytesToAppend.elem;
    }

    public int appendFromFile(FileRecords records, int start) {
        Object object = new Object();
        try {
            return BoxesRunTime.unboxToInt((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$appendFromFile$1(this, start, records, object))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcI$sp();
            }
            throw ex;
        }
    }

    public void updateTxnIndex(CompletedTxn completedTxn, long lastStableOffset) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$updateTxnIndex$1(this, completedTxn, lastStableOffset);
            return BoxedUnit.UNIT;
        });
    }

    private void updateProducerState(ProducerStateManager producerStateManager, RecordBatch batch, long currentTimeMs) {
        if (batch.hasProducerId()) {
            long producerId = batch.producerId();
            ProducerAppendInfo appendInfo = producerStateManager.prepareUpdate(producerId, AppendOrigin.REPLICATION, currentTimeMs);
            Optional maybeCompletedTxn = appendInfo.append(batch, Optional.empty());
            producerStateManager.update(appendInfo);
            maybeCompletedTxn.ifPresent(completedTxn -> {
                long lastStableOffset = producerStateManager.proposedLastStableOffset(completedTxn);
                this.updateTxnIndex((CompletedTxn)completedTxn, lastStableOffset);
                producerStateManager.completeTxn(completedTxn);
            });
        }
        producerStateManager.updateMapEndOffset(batch.lastOffset() + 1L);
    }

    public FileRecords.LogOffsetPosition translateOffset(long offset, int startingFilePosition) {
        OffsetPosition mapping = this.offsetIndex().lookup(offset);
        return this.log().searchForOffsetWithSize(offset, package$.MODULE$.max(mapping.position, startingFilePosition));
    }

    public int translateOffset$default$2() {
        return 0;
    }

    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
        Object object = new Object();
        try {
            return (FetchDataInfo)ThreadCountersManager.wrapIO(() -> {
                int adjustedMaxSize;
                if (maxSize < 0) {
                    throw new IllegalArgumentException(new StringBuilder(44).append("Invalid max size ").append(maxSize).append(" for log read from segment ").append(this.log()).toString());
                }
                FileRecords.LogOffsetPosition startOffsetAndSize = this.translateOffset(startOffset, this.translateOffset$default$2());
                if (startOffsetAndSize == null) {
                    throw new NonLocalReturnControl(object, null);
                }
                int startPosition = startOffsetAndSize.position;
                LogOffsetMetadata offsetMetadata = new LogOffsetMetadata(startOffset, this.baseOffset(), startPosition);
                int n = adjustedMaxSize = minOneMessage ? package$.MODULE$.max(maxSize, startOffsetAndSize.size) : maxSize;
                if (adjustedMaxSize == 0) {
                    throw new NonLocalReturnControl(object, (Object)new FetchDataInfo(offsetMetadata, (Records)MemoryRecords.EMPTY));
                }
                int fetchSize = package$.MODULE$.min((int)(maxPosition - (long)startPosition), adjustedMaxSize);
                return new FetchDataInfo(offsetMetadata, (Records)this.log().slice(startPosition, fetchSize), adjustedMaxSize < startOffsetAndSize.size, Optional.empty());
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (FetchDataInfo)ex.value();
            }
            throw ex;
        }
    }

    public long read$default$3() {
        return this.size();
    }

    public boolean read$default$4() {
        return false;
    }

    public Optional<Object> fetchUpperBoundOffset(OffsetPosition startOffsetPosition, int fetchSize) {
        return (Optional)ThreadCountersManager.wrapIO(() -> this.offsetIndex().fetchUpperBoundOffset(startOffsetPosition, fetchSize).map(x$1 -> BoxesRunTime.boxToLong((long)x$1.offset)));
    }

    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
        return BoxesRunTime.unboxToInt((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$recover$1(this, leaderEpochCache, producerStateManager))));
    }

    public Option<LeaderEpochFileCache> recover$default$2() {
        return None$.MODULE$;
    }

    private void loadLargestTimestamp() {
        TimestampOffset lastTimeIndexEntry = this.timeIndex().lastEntry();
        this.maxTimestampAndOffsetSoFar_$eq(lastTimeIndexEntry);
        OffsetPosition offsetPosition = this.offsetIndex().lookup(lastTimeIndexEntry.offset);
        FileRecords.FileTimestampAndOffset maxTimestampOffsetAfterLastEntry = this.log().largestTimestampAfter(offsetPosition.position);
        if (maxTimestampOffsetAfterLastEntry.timestamp > lastTimeIndexEntry.timestamp) {
            this.maxTimestampAndOffsetSoFar_$eq(new TimestampOffset(maxTimestampOffsetAfterLastEntry.timestamp, maxTimestampOffsetAfterLastEntry.offset));
        }
    }

    public boolean hasOverflow() {
        long nextOffset = this.readNextOffset();
        return nextOffset > this.baseOffset() && !this.canConvertToRelativeOffset(nextOffset - 1L);
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        return (TxnIndexSearchResult)ThreadCountersManager.wrapIO(() -> this.txnIndex().collectAbortedTxns(fetchOffset, upperBoundOffset));
    }

    public String toString() {
        return new StringBuilder(74).append("LogSegment(baseOffset=").append(this.baseOffset()).append(", size=").append(this.size()).append(", lastModifiedTime=").append(this.lastModified()).append(", largestRecordTimestamp=").append(this.largestRecordTimestamp()).append(")").toString();
    }

    public int truncateTo(long offset) {
        return BoxesRunTime.unboxToInt((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$truncateTo$1(this, offset))));
    }

    public long scanNextOffset() {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$scanNextOffset$1(this))));
    }

    public long readNextOffset() {
        Object object = new Object();
        try {
            return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$readNextOffset$1(this, object))));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcJ$sp();
            }
            throw ex;
        }
    }

    public void flush() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$flush$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void updateParentDir(File dir) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$updateParentDir$1(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    public void changeFileSuffixes(String oldSuffix, String newSuffix) {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$changeFileSuffixes$1(this, oldSuffix, newSuffix);
            return BoxedUnit.UNIT;
        });
    }

    public boolean hasSuffix(String suffix) {
        return this.log().file().getName().endsWith(suffix) && this.lazyOffsetIndex().file().getName().endsWith(suffix) && this.lazyTimeIndex().file().getName().endsWith(suffix) && this.txnIndex().file().getName().endsWith(suffix);
    }

    public void onBecomeInactiveSegment() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$onBecomeInactiveSegment$1(this);
            return BoxedUnit.UNIT;
        });
    }

    private void loadFirstBatchTimestamp() {
        Iterator iter;
        if (this.rollingBasedTimestamp().isEmpty() && (iter = this.log().batches().iterator()).hasNext()) {
            this.rollingBasedTimestamp_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)((FileLogInputStream.FileChannelRecordBatch)iter.next()).maxTimestamp())));
            return;
        }
    }

    public long timeWaitedForRoll(long now, long messageTimestamp) {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$timeWaitedForRoll$1(this, messageTimestamp, now))));
    }

    public long getFirstBatchTimestamp() {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$getFirstBatchTimestamp$1(this))));
    }

    public Option<FetchedTimestampAndOffset> findOffsetByTimestamp(long timestamp, long startingOffset) {
        return (Option)ThreadCountersManager.wrapIO(() -> {
            TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
            int position = $this.offsetIndex().lookup((long)package$.MODULE$.max((long)timestampOffset.offset, (long)startingOffset$1)).position;
            return Option$.MODULE$.apply((Object)this.log().searchForTimestamp(timestamp, position, startingOffset)).map((Function1 & Serializable & scala.Serializable)found -> {
                if (found.exception == null) {
                    return FetchedTimestampAndOffset$.MODULE$.apply(found.timestamp, found.offset, (Option<Object>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(found.leaderEpoch)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$4))));
                }
                return FetchedTimestampAndOffset$.MODULE$.apply(found.exception);
            });
        });
    }

    public long findOffsetByTimestamp$default$2() {
        return this.baseOffset();
    }

    public void close() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$close$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void closeHandlers() {
        ThreadCountersManager.wrapIO(() -> {
            LogSegment.$anonfun$closeHandlers$1(this);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteIfExists() {
        ThreadCountersManager.wrapIO(() -> {
            CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                boolean bl = true;
                File delete$1_file = $this.log().file();
                String delete$1_fileType = "log";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$5($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                boolean bl = true;
                File delete$1_file = $this.lazyOffsetIndex().file();
                String delete$1_fileType = "offset index";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$7($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                boolean bl = true;
                File delete$1_file = $this.lazyTimeIndex().file();
                String delete$1_fileType = "time index";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$9($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                boolean bl = false;
                File delete$1_file = $this.txnIndex().file();
                String delete$1_fileType = "transaction index";
                try {
                    void delete$1_logIfMissing;
                    if (LogSegment.$anonfun$deleteIfExists$11($this)) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
                    } else if (delete$1_logIfMissing != false) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
                    }
                }
                catch (IOException delete$1_e) {
                    throw new IOException(new StringBuilder(19).append("Delete of ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" failed.").toString(), delete$1_e);
                }
            }, (List)Nil$.MODULE$)))));
            return BoxedUnit.UNIT;
        });
        this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public boolean deleted() {
        return BoxesRunTime.unboxToBoolean((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToBoolean((boolean)LogSegment.$anonfun$deleted$1(this))));
    }

    public long lastModified() {
        return BoxesRunTime.unboxToLong((Object)ThreadCountersManager.wrapIO(() -> BoxesRunTime.boxToLong((long)LogSegment.$anonfun$lastModified$1(this))));
    }

    public Option<Object> largestRecordTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return new Some((Object)BoxesRunTime.boxToLong((long)this.maxTimestampSoFar()));
        }
        return None$.MODULE$;
    }

    public long largestTimestamp() {
        if (this.maxTimestampSoFar() >= 0L) {
            return this.maxTimestampSoFar();
        }
        return this.lastModified();
    }

    public Path lastModified_$eq(long ms) {
        FileTime fileTime = FileTime.fromMillis(ms);
        FilesWrapper.setLastModifiedTime((Path)this.log().file().toPath(), (FileTime)fileTime);
        FilesWrapper.setLastModifiedTime((Path)this.lazyOffsetIndex().file().toPath(), (FileTime)fileTime);
        return FilesWrapper.setLastModifiedTime((Path)this.lazyTimeIndex().file().toPath(), (FileTime)fileTime);
    }

    public static final /* synthetic */ boolean $anonfun$resizeIndexes$1(LogSegment $this, int size$1) {
        $this.offsetIndex().resize(size$1);
        return $this.timeIndex().resize(size$1);
    }

    public static final /* synthetic */ void $anonfun$sanityCheck$1(LogSegment $this, boolean timeIndexFileNewlyCreated$1) {
        if ($this.lazyOffsetIndex().file().exists()) {
            if (timeIndexFileNewlyCreated$1) {
                $this.timeIndex().resize(0);
            }
            $this.txnIndex().sanityCheck();
            return;
        }
        throw new NoSuchFileException(new StringBuilder(33).append("Offset index file ").append($this.lazyOffsetIndex().file().getAbsolutePath()).append(" does not exist").toString());
    }

    public static final /* synthetic */ int $anonfun$append$3(LogSegment $this, MemoryRecords records$1) {
        return $this.log().append(records$1);
    }

    public static final /* synthetic */ void $anonfun$append$1(LogSegment $this, MemoryRecords records$1, long lastOffset$1) {
        if (records$1.sizeInBytes() > 0) {
            IntRef position = IntRef.create((int)$this.log().sizeInBytes());
            boolean traceEnabled = $this.isTraceEnabled();
            if (traceEnabled) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Inserting ").append(records$1.sizeInBytes()).append(" bytes at end offset ").append(lastOffset$1).append(" at position ").append($this.log().sizeInBytes()).toString());
            }
            $this.ensureOffsetInRange(lastOffset$1);
            int appendedBytes = BoxesRunTime.unboxToInt((Object)SegmentStats$.MODULE$.segmentAppendTimeMs().time(() -> BoxesRunTime.boxToInteger((int)LogSegment.$anonfun$append$3($this, records$1))));
            if (traceEnabled) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Appended ").append(appendedBytes).append(" to ").append($this.log().file()).append(" at end offset ").append(lastOffset$1).toString());
            }
            records$1.batches().forEach(batch -> {
                $this.updateSegmentMetadata(position$1.elem, (RecordBatch)batch);
                position$1.elem += batch.sizeInBytes();
            });
        }
    }

    public static final /* synthetic */ void $anonfun$updateSegmentMetadata$1(LogSegment $this, long lastOffset$2, int position$2) {
        $this.offsetIndex().append(lastOffset$2, position$2);
    }

    public static final /* synthetic */ void $anonfun$updateSegmentMetadata$2(LogSegment $this) {
        $this.timeIndex().maybeAppend($this.maxTimestampAndOffsetSoFar().timestamp, $this.maxTimestampAndOffsetSoFar().offset);
    }

    private final boolean canAppend$1(RecordBatch batch, IntRef bytesToAppend$1, ObjectRef readBuffer$1) {
        return this.canConvertToRelativeOffset(batch.lastOffset()) && (bytesToAppend$1.elem == 0 || bytesToAppend$1.elem + batch.sizeInBytes() < ((ByteBuffer)readBuffer$1.elem).capacity());
    }

    public static final /* synthetic */ void $anonfun$appendChunkFromFile$2(LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, LongRef maxOffset$1, IntRef bytesToAppend$1, FileLogInputStream.FileChannelRecordBatch batch) {
        if (batch.maxTimestamp() > maxTimestamp$1.elem) {
            maxTimestamp$1.elem = batch.maxTimestamp();
            offsetOfMaxTimestamp$1.elem = batch.lastOffset();
        }
        maxOffset$1.elem = batch.lastOffset();
        bytesToAppend$1.elem += batch.sizeInBytes();
    }

    public static final /* synthetic */ int $anonfun$appendFromFile$1(LogSegment $this, int start$1, FileRecords records$2, Object nonLocalReturnKey1$1) {
        int position;
        int bytesAppended;
        BufferSupplier.GrowableBufferSupplier bufferSupplier = new BufferSupplier.GrowableBufferSupplier();
        for (position = start$1; position < start$1 + records$2.sizeInBytes(); position += bytesAppended) {
            bytesAppended = $this.appendChunkFromFile(records$2, position, (BufferSupplier)bufferSupplier);
            if (bytesAppended != 0) continue;
            throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, position - start$1);
        }
        return position - start$1;
    }

    public static final /* synthetic */ void $anonfun$updateTxnIndex$1(LogSegment $this, CompletedTxn completedTxn$1, long lastStableOffset$1) {
        if (completedTxn$1.isAborted) {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Writing aborted transaction ").append(completedTxn$1).append(" to transaction index, last stable offset is ").append(lastStableOffset$1).toString());
            $this.txnIndex().append(new AbortedTxn(completedTxn$1, lastStableOffset$1));
        }
    }

    public static final /* synthetic */ void $anonfun$recover$3(FileLogInputStream.FileChannelRecordBatch batch$1, LeaderEpochFileCache cache) {
        if (batch$1.partitionLeaderEpoch() >= 0 && OptionConverters.RichOptionalInt$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalInt(cache.latestEpoch())).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> batch$1.partitionLeaderEpoch() > x$2)) {
            cache.assign(batch$1.partitionLeaderEpoch(), batch$1.baseOffset());
        }
    }

    public static final /* synthetic */ void $anonfun$recover$2(LogSegment $this, IntRef validBytes$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2, long currentTimeMs$1, FileLogInputStream.FileChannelRecordBatch batch) {
        batch.ensureValid();
        $this.updateSegmentMetadata(validBytes$1.elem, (RecordBatch)batch);
        validBytes$1.elem += batch.sizeInBytes();
        if (batch.magic() >= 2) {
            leaderEpochCache$1.foreach((Function1 & Serializable & scala.Serializable)cache -> {
                LogSegment.$anonfun$recover$3(batch, cache);
                return BoxedUnit.UNIT;
            });
            $this.updateProducerState(producerStateManager$2, (RecordBatch)batch, currentTimeMs$1);
        }
    }

    public static final /* synthetic */ int $anonfun$recover$1(LogSegment $this, Option leaderEpochCache$1, ProducerStateManager producerStateManager$2) {
        $this.offsetIndex().reset();
        $this.timeIndex().reset();
        $this.txnIndex().reset();
        IntRef validBytes = IntRef.create((int)0);
        $this.maxTimestampAndOffsetSoFar_$eq(TimestampOffset.UNKNOWN);
        try {
            long currentTimeMs = $this.time().milliseconds();
            ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter($this.log().batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                LogSegment.$anonfun$recover$2($this, validBytes, leaderEpochCache$1, producerStateManager$2, currentTimeMs, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof CorruptRecordException ? true : throwable instanceof InvalidRecordException;
            if (bl) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Found invalid messages in log segment %s at byte offset %d: %s. %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.log().file().getAbsolutePath(), BoxesRunTime.boxToInteger((int)validBytes$1.elem), throwable.getMessage(), throwable.getCause()})));
            }
            throw throwable;
        }
        int truncated = $this.log().sizeInBytes() - validBytes.elem;
        if (truncated > 0) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Truncated ").append(truncated).append(" invalid bytes at the end of segment ").append($this.log().file().getAbsoluteFile()).append(" during recovery").toString());
        }
        $this.log().truncateTo(validBytes.elem);
        $this.offsetIndex().trimToValidSize();
        $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar(), true);
        $this.timeIndex().trimToValidSize();
        return truncated;
    }

    public static final /* synthetic */ int $anonfun$truncateTo$1(LogSegment $this, long offset$1) {
        int bytesTruncated;
        FileRecords.LogOffsetPosition mapping = $this.translateOffset(offset$1, $this.translateOffset$default$2());
        $this.offsetIndex().truncateTo(offset$1);
        $this.timeIndex().truncateTo(offset$1);
        $this.txnIndex().truncateTo(offset$1);
        $this.offsetIndex().resize($this.offsetIndex().maxIndexSize());
        $this.timeIndex().resize($this.timeIndex().maxIndexSize());
        int n = bytesTruncated = mapping == null ? 0 : $this.log().truncateTo(mapping.position);
        if ($this.log().sizeInBytes() == 0) {
            $this.created_$eq($this.time().milliseconds());
            $this.rollingBasedTimestamp_$eq((Option<Object>)None$.MODULE$);
        }
        $this.bytesSinceLastIndexEntry_$eq(0);
        if ($this.maxTimestampSoFar() >= 0L) {
            $this.loadLargestTimestamp();
        }
        $this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
        return bytesTruncated;
    }

    public static final /* synthetic */ long $anonfun$scanNextOffset$1(LogSegment $this) {
        FetchDataInfo fetchData = $this.read($this.offsetIndex().lastOffset(), $this.log().sizeInBytes(), $this.read$default$3(), $this.read$default$4());
        if (fetchData == null) {
            return $this.baseOffset();
        }
        return BoxesRunTime.unboxToLong((Object)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records.batches()).asScala()).lastOption().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.nextOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.baseOffset()));
    }

    public static final /* synthetic */ long $anonfun$readNextOffset$1(LogSegment $this, Object nonLocalReturnKey3$1) {
        long scannedNextOffset;
        $this.lastSegmentOffset.get();
        do {
            long cachedLastSegmentOffset;
            if ((cachedLastSegmentOffset = $this.lastSegmentOffset.get()) != LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset()) {
                throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey3$1, cachedLastSegmentOffset + 1L);
            }
            scannedNextOffset = $this.scanNextOffset();
        } while (!$this.lastSegmentOffset.compareAndSet(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset(), scannedNextOffset - 1L));
        return scannedNextOffset;
    }

    public static final /* synthetic */ void $anonfun$flush$2(LogSegment $this) {
        $this.log().flush();
        $this.offsetIndex().flush();
        $this.timeIndex().flush();
        $this.txnIndex().flush();
        $this.lastFlushedTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)$this.time().milliseconds())));
    }

    public static final /* synthetic */ void $anonfun$flush$1(LogSegment $this) {
        LogFlushStats$.MODULE$.logFlushTimer().time(() -> {
            LogSegment.$anonfun$flush$2($this);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateParentDir$1(LogSegment $this, File dir$1) {
        $this.log().updateParentDir(dir$1);
        $this.lazyOffsetIndex().updateParentDir(dir$1);
        $this.lazyTimeIndex().updateParentDir(dir$1);
        $this.txnIndex().updateParentDir(dir$1);
    }

    public static final /* synthetic */ void $anonfun$changeFileSuffixes$1(LogSegment $this, String oldSuffix$1, String newSuffix$1) {
        $this.log().renameTo(new File(Utils.replaceSuffix((String)$this.log().file().getPath(), (String)oldSuffix$1, (String)newSuffix$1)));
        $this.lazyOffsetIndex().renameTo(new File(Utils.replaceSuffix((String)$this.lazyOffsetIndex().file().getPath(), (String)oldSuffix$1, (String)newSuffix$1)));
        $this.lazyTimeIndex().renameTo(new File(Utils.replaceSuffix((String)$this.lazyTimeIndex().file().getPath(), (String)oldSuffix$1, (String)newSuffix$1)));
        $this.txnIndex().renameTo(new File(Utils.replaceSuffix((String)$this.txnIndex().file().getPath(), (String)oldSuffix$1, (String)newSuffix$1)));
    }

    public static final /* synthetic */ void $anonfun$onBecomeInactiveSegment$1(LogSegment $this) {
        $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar(), true);
        $this.offsetIndex().trimToValidSize();
        $this.timeIndex().trimToValidSize();
        $this.log().trim();
    }

    public static final /* synthetic */ long $anonfun$timeWaitedForRoll$1(LogSegment $this, long messageTimestamp$1, long now$1) {
        long t;
        $this.loadFirstBatchTimestamp();
        Option<Object> option = $this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? messageTimestamp$1 - t : now$1 - $this.created();
        return l;
    }

    public static final /* synthetic */ long $anonfun$getFirstBatchTimestamp$1(LogSegment $this) {
        long t;
        $this.loadFirstBatchTimestamp();
        Option<Object> option = $this.rollingBasedTimestamp();
        long l = option instanceof Some && (t = BoxesRunTime.unboxToLong((Object)((Some)option).value())) >= 0L ? t : Long.MAX_VALUE;
        return l;
    }

    public static final /* synthetic */ void $anonfun$close$1(LogSegment $this) {
        TimestampOffset timestampOffset = $this._maxTimestampAndOffsetSoFar();
        TimestampOffset timestampOffset2 = TimestampOffset.UNKNOWN;
        if (timestampOffset == null ? timestampOffset2 != null : !timestampOffset.equals(timestampOffset2)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.timeIndex().maybeAppend($this.maxTimestampSoFar(), $this.offsetOfMaxTimestampSoFar(), true), $this, CoreUtils$.MODULE$.swallow$default$3());
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.lazyOffsetIndex().close(), $this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.lazyTimeIndex().close(), $this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.log().close(), $this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.txnIndex().close(), $this, CoreUtils$.MODULE$.swallow$default$3());
        $this.lastSegmentOffset.set(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }

    public static final /* synthetic */ void $anonfun$closeHandlers$1(LogSegment $this) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.lazyOffsetIndex().closeHandler(), $this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.lazyTimeIndex().closeHandler(), $this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.log().closeHandlers(), $this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.txnIndex().close(), $this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private final void delete$1(Function0 delete, String fileType, File file, boolean logIfMissing) {
        try {
            if (delete.apply$mcZ$sp()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Deleted ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(".").toString());
            } else if (logIfMissing) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Failed to delete ").append(delete$1_fileType).append(" ").append(delete$1_file.getAbsolutePath()).append(" because it does not exist.").toString());
            }
        }
        catch (IOException e) {
            throw new IOException(new StringBuilder(19).append("Delete of ").append(fileType).append(" ").append(file.getAbsolutePath()).append(" failed.").toString(), e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$5(LogSegment $this) {
        return $this.log().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$7(LogSegment $this) {
        return $this.lazyOffsetIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$9(LogSegment $this) {
        return $this.lazyTimeIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleteIfExists$11(LogSegment $this) {
        return $this.txnIndex().deleteIfExists();
    }

    public static final /* synthetic */ boolean $anonfun$deleted$1(LogSegment $this) {
        return !$this.log().file().exists() && !$this.lazyOffsetIndex().file().exists() && !$this.lazyTimeIndex().file().exists() && !$this.txnIndex().file().exists();
    }

    public static final /* synthetic */ long $anonfun$lastModified$1(LogSegment $this) {
        return $this.log().file().lastModified();
    }

    public LogSegment(FileRecords log, LazyIndex<OffsetIndex> lazyOffsetIndex, LazyIndex<TimeIndex> lazyTimeIndex, TransactionIndex txnIndex, long baseOffset, int indexIntervalBytes, long rollJitterMs, Time time) {
        this.log = log;
        this.lazyOffsetIndex = lazyOffsetIndex;
        this.lazyTimeIndex = lazyTimeIndex;
        this.txnIndex = txnIndex;
        this.baseOffset = baseOffset;
        this.indexIntervalBytes = indexIntervalBytes;
        this.rollJitterMs = rollJitterMs;
        this.time = time;
        Logging.$init$(this);
        this.created = time.milliseconds();
        this.bytesSinceLastIndexEntry = 0;
        this.rollingBasedTimestamp = None$.MODULE$;
        this.lastFlushedTimeMs = None$.MODULE$;
        this._maxTimestampAndOffsetSoFar = TimestampOffset.UNKNOWN;
        this.lastSegmentOffset = new AtomicLong(LogSegment$.MODULE$.kafka$log$LogSegment$$UnknownLastOffset());
    }
}

