/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.FilesWrapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.regex.Pattern;
import kafka.log.InterceptorStats;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogLoader;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogSegments$;
import kafka.log.MergedLog;
import kafka.log.SplitSegmentResult;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicMetrics;
import kafka.server.BrokerTopicStats;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.topic.TierTopic;
import kafka.utils.Logging;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.CompletedTxn;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogValidator;
import org.apache.kafka.storage.internals.log.ProducerAppendInfo;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MergedLog$
implements Logging {
    public static MergedLog$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String TxnIndexFileSuffix;
    private final String CleanedFileSuffix;
    private final String TierCleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String DeleteDirSuffix;
    private final String FutureDirSuffix;
    private final String StrayDirSuffix;
    private final String TierStateSuffix;
    private final Pattern DeleteDirPattern;
    private final Pattern FutureDirPattern;
    private final Pattern StrayDirPattern;
    private final long UnknownOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new MergedLog$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<Histogram> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public MergedLog apply(File dir, LogConfig config, LogSegments segments, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int producerIdExpirationCheckIntervalMs, TopicPartition topicPartition, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean hadCleanShutdown, Option<Uuid> topicId, boolean keepPartitionMetadataFile, LogOffsetsListener logOffsetsListener, Option<Histogram> messageBatchSizeHistogram, ConcurrentMap<String, Object> numRemainingSegments) {
        TierPartitionState tierPartitionState = this.initTierPartitionState(dir, topicPartition, tierLogComponents.partitionStateFactory(), config, logDirFailureChannel, scheduler, time);
        LoadedLogOffsets offsets = new LogLoader(dir, topicPartition, config, scheduler, time, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, recoveryPoint, leaderEpochCache, producerStateManager, numRemainingSegments).load();
        LocalLog localLog = new LocalLog(dir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel, brokerTopicStats, logOffsetsListener);
        return new MergedLog(localLog, logStartOffset, hadCleanShutdown, metrics, leaderEpochCache, producerIdExpirationCheckIntervalMs, producerStateManager, topicId, keepPartitionMetadataFile, tierPartitionState, tierLogComponents, messageBatchSizeHistogram);
    }

    public MergedLog apply(File dir, LogConfig config, long logStartOffset, long recoveryPoint, Scheduler scheduler, BrokerTopicStats brokerTopicStats, Metrics metrics, Time time, int maxTransactionTimeoutMs, ProducerStateManagerConfig producerStateManagerConfig, int producerIdExpirationCheckIntervalMs, Option<ProducerIdQuotaRecorder> producerIdQuotaManager, LogDirFailureChannel logDirFailureChannel, TierLogComponents tierLogComponents, boolean lastShutdownClean, Option<Uuid> topicId, boolean keepPartitionMetadataFile, LogOffsetsListener logOffsetsListener, Option<Histogram> messageBatchSizeHistogram, ConcurrentMap<String, Object> numRemainingSegments) {
        FilesWrapper.createDirectories((Path)dir.toPath(), (FileAttribute[])new FileAttribute[0]);
        TopicPartition topicPartition = this.parseTopicPartitionName(dir);
        LogSegments segments = new LogSegments(topicPartition);
        Option<LeaderEpochFileCache> leaderEpochCache = this.maybeCreateLeaderEpochCache(dir, topicPartition, logDirFailureChannel, config.messageFormatVersion.highestSupportedRecordVersion(), new StringBuilder(29).append("[MergedLog partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, dir, maxTransactionTimeoutMs, producerStateManagerConfig, time, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(producerIdQuotaManager)));
        return this.apply(dir, config, segments, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, metrics, time, producerIdExpirationCheckIntervalMs, topicPartition, leaderEpochCache, producerStateManager, logDirFailureChannel, tierLogComponents, lastShutdownClean, topicId, keepPartitionMetadataFile, logOffsetsListener, messageBatchSizeHistogram, numRemainingSegments);
    }

    public Time apply$default$8() {
        return Time.SYSTEM;
    }

    public Option<ProducerIdQuotaRecorder> apply$default$12() {
        return None$.MODULE$;
    }

    public LogOffsetsListener apply$default$18() {
        return LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
    }

    public Option<Histogram> apply$default$19() {
        return None$.MODULE$;
    }

    public ConcurrentMap<String, Object> apply$default$20() {
        return new ConcurrentHashMap<String, Object>();
    }

    private TierPartitionState initTierPartitionState(File dir, TopicPartition topicPartition, TierPartitionStateFactory tierPartitionStateFactory, LogConfig config, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler, Time time) {
        return tierPartitionStateFactory.initState(dir, topicPartition, config, logDirFailureChannel, scheduler, time);
    }

    public boolean kafka$log$MergedLog$$isConfigValid(TopicPartition topicPartition, LogConfig config) {
        if (topicPartition.topic().startsWith("_confluent-tier-state")) {
            return TierTopic.isConfigValid(this.logger().underlying(), topicPartition.topic(), config);
        }
        return true;
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String TxnIndexFileSuffix() {
        return this.TxnIndexFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String TierCleanedFileSuffix() {
        return this.TierCleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String FutureDirSuffix() {
        return this.FutureDirSuffix;
    }

    public String StrayDirSuffix() {
        return this.StrayDirSuffix;
    }

    public String TierStateSuffix() {
        return this.TierStateSuffix;
    }

    public Pattern DeleteDirPattern() {
        return this.DeleteDirPattern;
    }

    public Pattern FutureDirPattern() {
        return this.FutureDirPattern;
    }

    public Pattern StrayDirPattern() {
        return this.StrayDirPattern;
    }

    public long UnknownOffset() {
        return this.UnknownOffset;
    }

    public String filenamePrefixFromOffset(long offset) {
        return LocalLog$.MODULE$.filenamePrefixFromOffset(offset);
    }

    public File logFile(File dir, long offset, String suffix) {
        return LogFileUtils.logFile((File)dir, (long)offset, (String)suffix);
    }

    public String logFile$default$3() {
        return "";
    }

    public String logDeleteDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDeleteDirName(topicPartition);
    }

    public String logFutureDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logFutureDirName(topicPartition);
    }

    public String logStrayDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logStrayDirName(topicPartition);
    }

    public String logDirName(TopicPartition topicPartition) {
        return LocalLog$.MODULE$.logDirName(topicPartition);
    }

    public File offsetIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.offsetIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String offsetIndexFile$default$3() {
        return "";
    }

    public File timeIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.timeIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String timeIndexFile$default$3() {
        return "";
    }

    public void deleteFileIfExists(File file, String suffix) {
        FilesWrapper.deleteIfExists((Path)new File(new StringBuilder(0).append(file.getPath()).append(suffix).toString()).toPath());
    }

    public String deleteFileIfExists$default$2() {
        return "";
    }

    public File transactionIndexFile(File dir, long offset, String suffix) {
        return LogFileUtils.transactionIndexFile((File)dir, (long)offset, (String)suffix);
    }

    public String transactionIndexFile$default$3() {
        return "";
    }

    public File tierStateFile(File dir, long offset, String suffix) {
        return new File(dir, this.tierStateFileName(offset, suffix));
    }

    public String tierStateFile$default$3() {
        return "";
    }

    public String tierStateFileName(long offset, String suffix) {
        return new StringBuilder(0).append(LocalLog$.MODULE$.filenamePrefixFromOffset(offset)).append(this.TierStateSuffix()).append(suffix).toString();
    }

    public String tierStateFileName$default$2() {
        return "";
    }

    public long offsetFromFile(File file) {
        return Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
    }

    public long sizeInBytes(Iterable<LogSegment> segments) {
        return LogSegments$.MODULE$.sizeInBytes(segments);
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        return LocalLog$.MODULE$.parseTopicPartitionName(dir);
    }

    public boolean isIndexFile(File file) {
        return LocalLog$.MODULE$.isIndexFile(file);
    }

    public boolean isLogFile(File file) {
        return LocalLog$.MODULE$.isLogFile(file);
    }

    public boolean isTierStateFile(File file) {
        Path path = file.toPath();
        String expSuffix = this.TierStateSuffix();
        if (CheckedFileIO.isValidPath(Algorithm.ADLER, path)) {
            expSuffix = new StringBuilder(0).append(this.TierStateSuffix()).append(Algorithm.ADLER.suffix).toString();
        }
        return ((Object)path).toString().endsWith(expSuffix);
    }

    public <A> ConcurrentNavigableMap<Long, A> logSegments(ConcurrentNavigableMap<Long, A> segments, long from, long to) {
        return (ConcurrentNavigableMap)Option$.MODULE$.apply((Object)segments.floorKey(Predef$.MODULE$.long2Long(from))).map((Function1 & Serializable & scala.Serializable)floor -> segments.subMap(floor, Predef$.MODULE$.long2Long(to))).getOrElse((Function0 & Serializable & scala.Serializable)() -> segments.headMap(Predef$.MODULE$.long2Long(to)));
    }

    private void loadProducersFromRecords(ProducerStateManager producerStateManager, Records records, long currentTimeMs) {
        Map loadedProducers = Map$.MODULE$.empty();
        ListBuffer completedTxns = (ListBuffer)ListBuffer$.MODULE$.empty();
        records.batches().forEach(batch -> {
            if (batch.hasProducerId()) {
                MODULE$.kafka$log$MergedLog$$updateProducers(producerStateManager, (RecordBatch)batch, (Map<Object, ProducerAppendInfo>)loadedProducers, (Option<LogOffsetMetadata>)None$.MODULE$, AppendOrigin.REPLICATION, currentTimeMs).foreach((Function1 & Serializable & scala.Serializable)x$59 -> completedTxns.$plus$eq(x$59));
            }
        });
        loadedProducers.values().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            producerStateManager.update(x$1);
            return BoxedUnit.UNIT;
        });
        completedTxns.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            producerStateManager.completeTxn(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CompletedTxn> kafka$log$MergedLog$$updateProducers(ProducerStateManager producerStateManager, RecordBatch batch, Map<Object, ProducerAppendInfo> producers, Option<LogOffsetMetadata> firstOffsetMetadata, AppendOrigin origin, long currentTimeMs) {
        long producerId = batch.producerId();
        ProducerAppendInfo appendInfo = (ProducerAppendInfo)producers.getOrElseUpdate((Object)BoxesRunTime.boxToLong((long)producerId), (Function0 & Serializable & scala.Serializable)() -> producerStateManager.prepareUpdate(producerId, origin, currentTimeMs));
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(appendInfo.append(batch, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(firstOffsetMetadata)))));
    }

    public Option<LeaderEpochFileCache> maybeCreateLeaderEpochCache(File dir, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel, RecordVersion recordVersion, String logPrefix) {
        File leaderEpochFile = LeaderEpochCheckpointFile.newFile((File)dir);
        if (recordVersion.precedes(RecordVersion.V2)) {
            if ((leaderEpochFile.exists() ? new Some((Object)MergedLog$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition)) : None$.MODULE$).exists((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToBoolean((boolean)x$60.nonEmpty())) && this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(MergedLog$.$anonfun$maybeCreateLeaderEpochCache$2(logPrefix, recordVersion)));
            }
            FilesWrapper.deleteIfExists((Path)leaderEpochFile.toPath());
            return None$.MODULE$;
        }
        return new Some((Object)MergedLog$.newLeaderEpochFileCache$1(leaderEpochFile, logDirFailureChannel, topicPartition));
    }

    public Iterable<LogSegment> replaceSegments(LogSegments existingSegments, Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix, boolean isRecoveredSwapFile) {
        return LocalLog$.MODULE$.replaceSegments(existingSegments, newSegments, oldSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix, isRecoveredSwapFile);
    }

    public boolean replaceSegments$default$10() {
        return false;
    }

    public void deleteSegmentFiles(scala.collection.immutable.Iterable<LogSegment> segmentsToDelete, boolean asyncDelete, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        LocalLog$.MODULE$.deleteSegmentFiles(segmentsToDelete, asyncDelete, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public long kafka$log$MergedLog$$firstUntieredOffset(TierPartitionState tierPartitionState) {
        return tierPartitionState.endOffset() + 1L;
    }

    public void rebuildProducerState(ProducerStateManager producerStateManager, LogSegments segments, long logStartOffset, long lastOffset, RecordVersion recordVersion, Time time, boolean reloadFromCleanShutdown, String logPrefix) {
        .colon.colon offsetsToSnapshot;
        .colon.colon colon2;
        if (segments.nonEmpty()) {
            long lastSegmentBaseOffset = ((LogSegment)segments.lastSegment().get()).baseOffset();
            Option nextLatestSegmentBaseOffset = segments.lowerSegment(lastSegmentBaseOffset).map((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToLong((long)x$61.baseOffset()));
            colon2 = new .colon.colon((Object)nextLatestSegmentBaseOffset, (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastSegmentBaseOffset)), (List)new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$)));
        } else {
            colon2 = offsetsToSnapshot = new .colon.colon((Object)new Some((Object)BoxesRunTime.boxToLong((long)lastOffset)), (List)Nil$.MODULE$);
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(MergedLog$.$anonfun$rebuildProducerState$2(logPrefix, lastOffset, recordVersion)));
        }
        if (recordVersion.value < 2 || !producerStateManager.latestSnapshotOffset().isPresent() && reloadFromCleanShutdown) {
            ((IterableLike)offsetsToSnapshot.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> {
                producerStateManager.updateMapEndOffset(offset);
                producerStateManager.takeSnapshot();
            });
            return;
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(MergedLog$.$anonfun$rebuildProducerState$5(logPrefix, lastOffset)));
        }
        boolean isEmptyBeforeTruncation = producerStateManager.isEmpty() && producerStateManager.mapEndOffset() >= lastOffset;
        long producerStateLoadStart = time.milliseconds();
        producerStateManager.truncateAndReload(logStartOffset, lastOffset, time.milliseconds());
        long segmentRecoveryStart = time.milliseconds();
        if (lastOffset > producerStateManager.mapEndOffset() && !isEmptyBeforeTruncation) {
            Option<LogSegment> segmentOfLastOffset = segments.floorSegment(lastOffset);
            segments.values(producerStateManager.mapEndOffset(), lastOffset).foreach(arg_0 -> MergedLog$.$anonfun$rebuildProducerState$6$adapted(producerStateManager, logStartOffset, (Seq)offsetsToSnapshot, segmentOfLastOffset, lastOffset, segmentRecoveryStart, arg_0));
        }
        producerStateManager.updateMapEndOffset(lastOffset);
        producerStateManager.takeSnapshot();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(MergedLog$.$anonfun$rebuildProducerState$9(logPrefix, segmentRecoveryStart, producerStateLoadStart, time, lastOffset)));
            return;
        }
    }

    public SplitSegmentResult splitOverflowedSegment(LogSegment segment, LogSegments existingSegments, File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, LogDirFailureChannel logDirFailureChannel, String logPrefix) {
        return LocalLog$.MODULE$.splitOverflowedSegment(segment, existingSegments, dir, topicPartition, config, scheduler, logDirFailureChannel, logPrefix);
    }

    public void deleteProducerSnapshots(Iterable<LogSegment> segments, ProducerStateManager producerStateManager, boolean asyncDelete, Scheduler scheduler, LogConfig config, LogDirFailureChannel logDirFailureChannel, String parentDir, TopicPartition topicPartition) {
        Iterable snapshotsToDelete = (Iterable)segments.flatMap((Function1 & Serializable & scala.Serializable)segment -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(producerStateManager.removeAndMarkSnapshotForDeletion(segment.baseOffset())))), Iterable$.MODULE$.canBuildFrom());
        if (asyncDelete) {
            scheduler.scheduleOnce("delete-producer-snapshot", () -> MergedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete), config.fileDeleteDelayMs);
            return;
        }
        MergedLog$.deleteProducerSnapshots$1(logDirFailureChannel, parentDir, topicPartition, snapshotsToDelete);
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset) {
        return LocalLog$.MODULE$.createNewCleanedSegment(dir, logConfig, baseOffset, this.CleanedFileSuffix());
    }

    public LogSegment createNewCleanedSegment(File dir, LogConfig logConfig, long baseOffset, String fileSuffix) {
        return LocalLog$.MODULE$.createNewCleanedSegment(dir, logConfig, baseOffset, fileSuffix);
    }

    public LogValidator.MetricsRecorder newValidatorMetricsRecorder(BrokerTopicMetrics allTopicsStats, InterceptorStats interceptorStats) {
        return new LogValidator.MetricsRecorder(allTopicsStats, interceptorStats){
            private final BrokerTopicMetrics allTopicsStats$1;
            private final InterceptorStats interceptorStats$1;

            public void recordInvalidMagic() {
                this.allTopicsStats$1.invalidMagicNumberRecordsPerSec().mark();
            }

            public void recordInvalidOffset() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidSequence() {
                this.allTopicsStats$1.invalidOffsetOrSequenceRecordsPerSec().mark();
            }

            public void recordInvalidChecksums() {
                this.allTopicsStats$1.invalidMessageCrcRecordsPerSec().mark();
            }

            public void recordNoKeyCompactedTopic() {
                this.allTopicsStats$1.noKeyCompactedTopicRecordsPerSec().mark();
            }

            public void recordPastTimeDiffMoreThanOneHour() {
                ((Meter)this.allTopicsStats$1.pastMessagesWithTimeDiffMoreThanOneHourPerSec().get()).mark();
            }

            public void recordPastTimeDiffMoreThanOneDay() {
                ((Meter)this.allTopicsStats$1.pastMessagesWithTimeDiffMoreThanOneDayPerSec().get()).mark();
            }

            public void recordPastTimeDiffMoreThanOneYear() {
                ((Meter)this.allTopicsStats$1.pastMessagesWithTimeDiffMoreThanOneYearPerSec().get()).mark();
            }

            public void recordFutureTimeDiffMoreThanOneHour() {
                ((Meter)this.allTopicsStats$1.futureMessagesWithTimeDiffMoreThanOneHourPerSec().get()).mark();
            }

            public void recordFutureTimeDiffMoreThanOneDay() {
                ((Meter)this.allTopicsStats$1.futureMessagesWithTimeDiffMoreThanOneDayPerSec().get()).mark();
            }

            public void recordFutureTimeDiffMoreThanOneYear() {
                ((Meter)this.allTopicsStats$1.futureMessagesWithTimeDiffMoreThanOneYearPerSec().get()).mark();
            }

            public void recordRejectedRecords(String topicName, String interceptorClassName) {
                this.interceptorStats$1.logRejectedRecords(topicName, interceptorClassName);
            }
            {
                this.allTopicsStats$1 = allTopicsStats$1;
                this.interceptorStats$1 = interceptorStats$1;
            }
        };
    }

    private static final LeaderEpochFileCache newLeaderEpochFileCache$1(File leaderEpochFile$1, LogDirFailureChannel logDirFailureChannel$1, TopicPartition topicPartition$1) {
        LeaderEpochCheckpointFile checkpointFile = new LeaderEpochCheckpointFile(leaderEpochFile$1, logDirFailureChannel$1);
        return new LeaderEpochFileCache(topicPartition$1, (LeaderEpochCheckpoint)checkpointFile);
    }

    public static final /* synthetic */ String $anonfun$maybeCreateLeaderEpochCache$2(String logPrefix$1, RecordVersion recordVersion$1) {
        return new StringBuilder(73).append(logPrefix$1).append("Deleting non-empty leader epoch cache due to incompatible message format ").append(recordVersion$1).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$2(String logPrefix$2, long lastOffset$2, RecordVersion recordVersion$2) {
        return new StringBuilder(64).append(logPrefix$2).append("Loading producer state till offset ").append(lastOffset$2).append(" with message format version ").append(recordVersion$2.value).toString();
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$5(String logPrefix$2, long lastOffset$2) {
        return new StringBuilder(75).append(logPrefix$2).append("Reloading from producer snapshot and rebuilding producer state from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ void $anonfun$rebuildProducerState$6(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, long segmentRecoveryStart$1, LogSegment segment) {
        int maxPosition;
        FetchDataInfo fetchDataInfo;
        long startOffset = Utils.max((long)segment.baseOffset(), (long[])new long[]{producerStateManager$3.mapEndOffset(), logStartOffset$1});
        producerStateManager$3.updateMapEndOffset(startOffset);
        if (offsetsToSnapshot$1.contains((Object)new Some((Object)BoxesRunTime.boxToLong((long)segment.baseOffset())))) {
            producerStateManager$3.takeSnapshot();
        }
        if ((fetchDataInfo = segment.read(startOffset, Integer.MAX_VALUE, maxPosition = segmentOfLastOffset$1.contains((Object)segment) ? BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)segment.translateOffset(lastOffset$2, segment.translateOffset$default$2())).map((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToInteger((int)x$62.position)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> segment.size())) : segment.size(), segment.read$default$4())) != null) {
            MODULE$.loadProducersFromRecords(producerStateManager$3, fetchDataInfo.records, segmentRecoveryStart$1);
        }
    }

    public static final /* synthetic */ String $anonfun$rebuildProducerState$9(String logPrefix$2, long segmentRecoveryStart$1, long producerStateLoadStart$1, Time time$1, long lastOffset$2) {
        return new StringBuilder(90).append(logPrefix$2).append("Producer state recovery took ").append(segmentRecoveryStart$1 - producerStateLoadStart$1).append("ms for snapshot load ").append("and ").append(time$1.milliseconds() - segmentRecoveryStart$1).append("ms for segment recovery from offset ").append(lastOffset$2).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteProducerSnapshots$2(TopicPartition topicPartition$2, String parentDir$1) {
        return new StringBuilder(58).append("Error while deleting producer state snapshots for ").append(topicPartition$2).append(" in dir ").append(parentDir$1).toString();
    }

    private static final void deleteProducerSnapshots$1(LogDirFailureChannel logDirFailureChannel$2, String parentDir$1, TopicPartition topicPartition$2, Iterable snapshotsToDelete$1) {
        if (LocalLog$.MODULE$ == null) {
            throw null;
        }
        if (logDirFailureChannel$2.hasOfflineLogDir(parentDir$1)) {
            throw new KafkaStorageException(new StringBuilder(63).append("The log dir ").append(parentDir$1).append(" is already offline due to a previous IO exception.").toString());
        }
        try {
            snapshotsToDelete$1.foreach((Function1 & Serializable & scala.Serializable)snapshot -> BoxesRunTime.boxToBoolean((boolean)snapshot.deleteIfExists()));
            return;
        }
        catch (IOException maybeHandleIOException_e) {
            logDirFailureChannel$2.maybeAddOfflineLogDir(parentDir$1, MergedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), maybeHandleIOException_e);
            throw new KafkaStorageException(MergedLog$.$anonfun$deleteProducerSnapshots$2(topicPartition$2, parentDir$1), (Throwable)maybeHandleIOException_e);
        }
    }

    private MergedLog$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.TxnIndexFileSuffix = ".txnindex";
        this.CleanedFileSuffix = LocalLog$.MODULE$.CleanedFileSuffix();
        this.TierCleanedFileSuffix = ".tiercleaned";
        this.SwapFileSuffix = LocalLog$.MODULE$.SwapFileSuffix();
        this.DeleteDirSuffix = LocalLog$.MODULE$.DeleteDirSuffix();
        this.FutureDirSuffix = LocalLog$.MODULE$.FutureDirSuffix();
        this.StrayDirSuffix = LocalLog$.MODULE$.StrayDirSuffix();
        this.TierStateSuffix = ".tierstate";
        this.DeleteDirPattern = LocalLog$.MODULE$.DeleteDirPattern();
        this.FutureDirPattern = LocalLog$.MODULE$.FutureDirPattern();
        this.StrayDirPattern = LocalLog$.MODULE$.StrayDirPattern();
        this.UnknownOffset = LocalLog$.MODULE$.UnknownOffset();
    }

    public static final /* synthetic */ Object $anonfun$rebuildProducerState$6$adapted(ProducerStateManager producerStateManager$3, long logStartOffset$1, Seq offsetsToSnapshot$1, Option segmentOfLastOffset$1, long lastOffset$2, long segmentRecoveryStart$1, LogSegment segment) {
        MergedLog$.$anonfun$rebuildProducerState$6(producerStateManager$3, logStartOffset$1, offsetsToSnapshot$1, segmentOfLastOffset$1, lastOffset$2, segmentRecoveryStart$1, segment);
        return BoxedUnit.UNIT;
    }
}

