/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.storage.internals.log.TransactionIndex;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001U4AAE\n\u00015!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u00052\u0001\t\u0005\t\u0015!\u0003$\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u0011a\u0002!Q1A\u0005\u0002eB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006}\u0001!\ta\u0010\u0005\b\u000b\u0002\u0001\r\u0011\"\u0003G\u0011\u001dQ\u0005\u00011A\u0005\n-Ca!\u0015\u0001!B\u00139\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007A\u0002\u0001\u000b\u0011\u0002+\t\u000b\u0005\u0004A\u0011\u00012\t\u000b-\u0004A\u0011\u00017\t\u000bE\u0004A\u0011\u0001:\t\u000bM\u0004A\u0011\u0001:\t\u000bQ\u0004A\u0011\u0001:\u0003\u000b\u0015sGO]=\u000b\u0005Q)\u0012A\u0002:f[>$XM\u0003\u0002\u0017/\u0005\u0019An\\4\u000b\u0003a\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\f1b\u001c4gg\u0016$\u0018J\u001c3fqV\t1\u0005\u0005\u0002%_5\tQE\u0003\u0002\u0017M)\u0011q\u0005K\u0001\nS:$XM\u001d8bYNT!!\u000b\u0016\u0002\u000fM$xN]1hK*\u0011\u0001d\u000b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021K\tYqJ\u001a4tKRLe\u000eZ3y\u00031ygMZ:fi&sG-\u001a=!\u0003%!\u0018.\\3J]\u0012,\u00070F\u00015!\t!S'\u0003\u00027K\tIA+[7f\u0013:$W\r_\u0001\u000bi&lW-\u00138eKb\u0004\u0013\u0001\u0003;y]&sG-\u001a=\u0016\u0003i\u0002\"\u0001J\u001e\n\u0005q*#\u0001\u0005+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3y\u0003%!\bP\\%oI\u0016D\b%\u0001\u0004=S:LGO\u0010\u000b\u0005\u0001\n\u001bE\t\u0005\u0002B\u00015\t1\u0003C\u0003\"\u000f\u0001\u00071\u0005C\u00033\u000f\u0001\u0007A\u0007C\u00039\u000f\u0001\u0007!(\u0001\tnCJ\\W\r\u001a$pe\u000ecW-\u00198vaV\tq\t\u0005\u0002\u001d\u0011&\u0011\u0011*\b\u0002\b\u0005>|G.Z1o\u0003Qi\u0017M]6fI\u001a{'o\u00117fC:,\bo\u0018\u0013fcR\u0011Aj\u0014\t\u000395K!AT\u000f\u0003\tUs\u0017\u000e\u001e\u0005\b!&\t\t\u00111\u0001H\u0003\rAH%M\u0001\u0012[\u0006\u00148.\u001a3G_J\u001cE.Z1okB\u0004\u0013\u0001\u00027pG.,\u0012\u0001\u0016\t\u0003+zk\u0011A\u0016\u0006\u0003/b\u000bQ\u0001\\8dWNT!!\u0017.\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\\9\u0006!Q\u000f^5m\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018,\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fQ\u0001\\8dW\u0002\nA\u0002\\8pWV\u0004xJ\u001a4tKR$\"a\u00194\u0011\u0005\u0011\"\u0017BA3&\u00059yeMZ:fiB{7/\u001b;j_:DQaZ\u0007A\u0002!\fA\u0002^1sO\u0016$xJ\u001a4tKR\u0004\"\u0001H5\n\u0005)l\"\u0001\u0002'p]\u001e\fq\u0002\\8pWV\u0004H+[7fgR\fW\u000e\u001d\u000b\u0004G6|\u0007\"\u00028\u000f\u0001\u0004A\u0017!\u0003;j[\u0016\u001cH/Y7q\u0011\u0015\u0001h\u00021\u0001i\u00039\u0019H/\u0019:uS:<wJ\u001a4tKR\fa\"\\1sW\u001a{'o\u00117fC:,\b\u000fF\u0001M\u0003\u001d\u0019G.Z1okB\fQa\u00197pg\u0016\u0004")
public class Entry {
    private final OffsetIndex offsetIndex;
    private final TimeIndex timeIndex;
    private final TransactionIndex txnIndex;
    private boolean markedForCleanup;
    private final ReentrantReadWriteLock lock;

    public OffsetIndex offsetIndex() {
        return this.offsetIndex;
    }

    public TimeIndex timeIndex() {
        return this.timeIndex;
    }

    public TransactionIndex txnIndex() {
        return this.txnIndex;
    }

    private boolean markedForCleanup() {
        return this.markedForCleanup;
    }

    private void markedForCleanup_$eq(boolean x$1) {
        this.markedForCleanup = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    public OffsetPosition lookupOffset(long targetOffset) {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock().readLock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (this.markedForCleanup()) {
                throw new IllegalStateException("This entry is marked for cleanup");
            }
            return this.offsetIndex().lookup(targetOffset);
        });
    }

    public OffsetPosition lookupTimestamp(long timestamp, long startingOffset) {
        return (OffsetPosition)CoreUtils$.MODULE$.inLock(this.lock().readLock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (this.markedForCleanup()) {
                throw new IllegalStateException("This entry is marked for cleanup");
            }
            TimestampOffset timestampOffset = this.timeIndex().lookup(timestamp);
            return this.offsetIndex().lookup(package$.MODULE$.max(startingOffset, timestampOffset.offset));
        });
    }

    public void markForCleanup() {
        CoreUtils$.MODULE$.inLock(this.lock().writeLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (!this.markedForCleanup()) {
                this.markedForCleanup_$eq(true);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new AbstractIndex[]{this.offsetIndex(), this.timeIndex()})).foreach((Function1 & Serializable & scala.Serializable)index -> {
                    index.renameTo(new File(Utils.replaceSuffix((String)index.file().getPath(), (String)"", (String)".deleted")));
                    return BoxedUnit.UNIT;
                });
                this.txnIndex().renameTo(new File(Utils.replaceSuffix((String)this.txnIndex().file().getPath(), (String)"", (String)".deleted")));
            }
        });
    }

    public void cleanup() {
        this.markForCleanup();
        CoreUtils$.MODULE$.tryAll((Seq<Function0<BoxedUnit>>)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.offsetIndex().deleteIfExists(), (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.timeIndex().deleteIfExists(), (List)new .colon.colon((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.txnIndex().deleteIfExists(), (List)Nil$.MODULE$))));
    }

    public void close() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new AbstractIndex[]{this.offsetIndex(), this.timeIndex()})).foreach((Function1 & Serializable & scala.Serializable)index -> {
            Entry.$anonfun$close$1(index);
            return BoxedUnit.UNIT;
        });
        Utils.closeQuietly((AutoCloseable)this.txnIndex(), (String)"Closing the transaction index.");
    }

    public static final /* synthetic */ void $anonfun$close$1(AbstractIndex index) {
        try {
            index.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Entry(OffsetIndex offsetIndex, TimeIndex timeIndex, TransactionIndex txnIndex) {
        this.offsetIndex = offsetIndex;
        this.timeIndex = timeIndex;
        this.txnIndex = txnIndex;
        this.markedForCleanup = false;
        this.lock = new ReentrantReadWriteLock();
    }
}

