/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.metrics.LinuxCpuMetricsCollector$;
import kafka.metrics.LinuxCpuMetricsCollector$SystemCpuTime$;
import net.jcip.annotations.GuardedBy;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.BufferLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005baBA\u0002\u0003\u000b\u0001\u0011q\u0002\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005}\u0001BCA\u001b\u0001\t\u0015\r\u0011\"\u0001\u00028!Q\u00111\u000b\u0001\u0003\u0002\u0003\u0006I!!\u000f\t\u0015\u0005U\u0003A!b\u0001\n\u0003\t9\u0006\u0003\u0006\u0002f\u0001\u0011\t\u0011)A\u0005\u00033B!\"a\u001a\u0001\u0005\u000b\u0007I\u0011AA5\u0011)\t9\b\u0001B\u0001B\u0003%\u00111\u000e\u0005\u000b\u0003s\u0002!Q1A\u0005\u0002\u0005m\u0004BCAB\u0001\t\u0005\t\u0015!\u0003\u0002~!Q\u0011Q\u0011\u0001\u0003\u0006\u0004%\t!a\u001f\t\u0015\u0005\u001d\u0005A!A!\u0002\u0013\ti\bC\u0004\u0002\n\u0002!\t!a#\t\u0013\u0005u\u0005A1A\u0005\n\u0005}\u0005\u0002CA[\u0001\u0001\u0006I!!)\t\u0013\u0005]\u0006A1A\u0005\n\u0005}\u0005\u0002CA]\u0001\u0001\u0006I!!)\t\u0013\u0005m\u0006A1A\u0005\n\u0005u\u0006\u0002CAj\u0001\u0001\u0006I!a0\t\u0013\u0005U\u0007\u00011A\u0005\n\u0005]\u0007\"CAm\u0001\u0001\u0007I\u0011BAn\u0011!\t9\u000f\u0001Q!\n\u0005}\u0003\"\u0003B\u0002\u0001\u0001\u0007I\u0011\u0002B\u0003\u0011%\u0011i\u0001\u0001a\u0001\n\u0013\u0011y\u0001\u0003\u0005\u0003\u0014\u0001\u0001\u000b\u0015\u0002B\u0004\u0011%\u00119\u0002\u0001a\u0001\n\u0013\u0011)\u0001C\u0005\u0003\u001a\u0001\u0001\r\u0011\"\u0003\u0003\u001c!A!q\u0004\u0001!B\u0013\u00119\u0001C\u0005\u0003$\u0001\u0001\r\u0011\"\u0003\u0003\u0006!I!Q\u0005\u0001A\u0002\u0013%!q\u0005\u0005\t\u0005W\u0001\u0001\u0015)\u0003\u0003\b!I!q\u0006\u0001C\u0002\u0013%\u0011Q\u0018\u0005\t\u0005c\u0001\u0001\u0015!\u0003\u0002@\"I!1\u0007\u0001A\u0002\u0013%\u0011q\u001b\u0005\n\u0005k\u0001\u0001\u0019!C\u0005\u0005oA\u0001Ba\u000f\u0001A\u0003&\u0011q\f\u0005\n\u0005\u0003\u0002\u0001\u0019!C\u0005\u0003/D\u0011Ba\u0011\u0001\u0001\u0004%IA!\u0012\t\u0011\t%\u0003\u0001)Q\u0005\u0003?B\u0011B!\u0014\u0001\u0005\u0004%I!!0\t\u0011\t=\u0003\u0001)A\u0005\u0003\u007fC\u0011B!\u0015\u0001\u0001\u0004%I!a6\t\u0013\tM\u0003\u00011A\u0005\n\tU\u0003\u0002\u0003B-\u0001\u0001\u0006K!a\u0018\t\u0013\t}\u0003\u00011A\u0005\n\u0005]\u0007\"\u0003B1\u0001\u0001\u0007I\u0011\u0002B2\u0011!\u00119\u0007\u0001Q!\n\u0005}\u0003\"\u0003B6\u0001\u0001\u0007I\u0011\u0002B\u0003\u0011%\u0011i\u0007\u0001a\u0001\n\u0013\u0011y\u0007\u0003\u0005\u0003t\u0001\u0001\u000b\u0015\u0002B\u0004\u0011%\u00119\b\u0001b\u0001\n\u0013\u0011I\b\u0003\u0005\u0003\b\u0002\u0001\u000b\u0011\u0002B>\u0011%\u0011I\t\u0001b\u0001\n\u0013\u0011I\b\u0003\u0005\u0003\f\u0002\u0001\u000b\u0011\u0002B>\u0011%\u0011i\t\u0001b\u0001\n\u0013\u0011y\t\u0003\u0005\u0003\u0014\u0002\u0001\u000b\u0011\u0002BI\u0011%\u0011)\n\u0001b\u0001\n\u0013\ti\f\u0003\u0005\u0003\u0018\u0002\u0001\u000b\u0011BA`\u0011%\u0011I\n\u0001a\u0001\n\u0013\t9\u000eC\u0005\u0003\u001c\u0002\u0001\r\u0011\"\u0003\u0003\u001e\"A!\u0011\u0015\u0001!B\u0013\ty\u0006C\u0005\u0003(\u0002\u0001\r\u0011\"\u0003\u0002X\"I!\u0011\u0016\u0001A\u0002\u0013%!1\u0016\u0005\t\u0005_\u0003\u0001\u0015)\u0003\u0002`\u00191!1\u0017\u0001A\u0005kC!Ba1A\u0005+\u0007I\u0011AAl\u0011)\u0011)\r\u0011B\tB\u0003%\u0011q\f\u0005\u000b\u0005\u000f\u0004%Q3A\u0005\u0002\u0005]\u0007B\u0003Be\u0001\nE\t\u0015!\u0003\u0002`!Q!1\u001a!\u0003\u0016\u0004%\t!a6\t\u0015\t5\u0007I!E!\u0002\u0013\ty\u0006\u0003\u0006\u0003P\u0002\u0013)\u001a!C\u0001\u0003/D!B!5A\u0005#\u0005\u000b\u0011BA0\u0011)\u0011\u0019\u000e\u0011BK\u0002\u0013\u0005\u0011q\u001b\u0005\u000b\u0005+\u0004%\u0011#Q\u0001\n\u0005}\u0003B\u0003Bl\u0001\nU\r\u0011\"\u0001\u0002X\"Q!\u0011\u001c!\u0003\u0012\u0003\u0006I!a\u0018\t\u0015\tm\u0007I!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0003^\u0002\u0013\t\u0012)A\u0005\u0003?B!Ba8A\u0005+\u0007I\u0011AAl\u0011)\u0011\t\u000f\u0011B\tB\u0003%\u0011q\f\u0005\u000b\u0005G\u0004%Q3A\u0005\u0002\u0005]\u0007B\u0003Bs\u0001\nE\t\u0015!\u0003\u0002`!Q!q\u001d!\u0003\u0016\u0004%\t!a6\t\u0015\t%\bI!E!\u0002\u0013\ty\u0006C\u0004\u0002\n\u0002#\tAa;\t\u0013\r\u0015\u0001I1A\u0005\u0002\u0005]\u0007\u0002CB\u0004\u0001\u0002\u0006I!a\u0018\t\u0013\r%\u0001)!A\u0005\u0002\r-\u0001\"CB\u0011\u0001F\u0005I\u0011AB\u0012\u0011%\u0019I\u0004QI\u0001\n\u0003\u0019\u0019\u0003C\u0005\u0004<\u0001\u000b\n\u0011\"\u0001\u0004$!I1Q\b!\u0012\u0002\u0013\u000511\u0005\u0005\n\u0007\u007f\u0001\u0015\u0013!C\u0001\u0007GA\u0011b!\u0011A#\u0003%\taa\t\t\u0013\r\r\u0003)%A\u0005\u0002\r\r\u0002\"CB#\u0001F\u0005I\u0011AB\u0012\u0011%\u00199\u0005QI\u0001\n\u0003\u0019\u0019\u0003C\u0005\u0004J\u0001\u000b\n\u0011\"\u0001\u0004$!I11\n!\u0002\u0002\u0013\u00053Q\n\u0005\n\u00073\u0002\u0015\u0011!C\u0001\u0003wB\u0011ba\u0017A\u0003\u0003%\ta!\u0018\t\u0013\r\u001d\u0004)!A\u0005B\r%\u0004\"CB<\u0001\u0006\u0005I\u0011AB=\u0011%\u0019\u0019\tQA\u0001\n\u0003\u001a)\tC\u0005\u0004\b\u0002\u000b\t\u0011\"\u0011\u0004\n\"I11\u0012!\u0002\u0002\u0013\u00053QR\u0004\n\u0007#\u0003\u0011\u0011!E\u0001\u0007'3\u0011Ba-\u0001\u0003\u0003E\ta!&\t\u000f\u0005%E\u000e\"\u0001\u0004$\"I1q\u00117\u0002\u0002\u0013\u00153\u0011\u0012\u0005\n\u0007Kc\u0017\u0011!CA\u0007OC\u0011b!0m\u0003\u0003%\tia0\t\u000f\r5\u0007\u0001\"\u0001\u0004P\"91\u0011\u001b\u0001\u0005\u0002\r=\u0007bBBj\u0001\u0011\u00051q\u001a\u0005\b\u0007+\u0004A\u0011BBl\u0011%\u0019i\u000e\u0001C\u0001\u0003\u000b\u0019y\u000eC\u0004\u0004b\u0002!\taa4\t\u000f\r\r\b\u0001\"\u0001\u0004P\"91Q\u001d\u0001\u0005\u0002\r=\u0007bBBt\u0001\u0011%1\u0011\u001e\u0005\b\u0007_\u0004A\u0011ABy\u0011\u001d\u0019\u0019\u0010\u0001C\u0001\u0007k<!\u0002\"\u0005\u0002\u0006\u0005\u0005\t\u0012\u0001C\n\r)\t\u0019!!\u0002\u0002\u0002#\u0005AQ\u0003\u0005\b\u0003\u0013kH\u0011\u0001C\f\u0011%!I\"`I\u0001\n\u0003!Y\u0002C\u0005\u0005 u\f\n\u0011\"\u0001\u0005\u001c\tAB*\u001b8vq\u000e\u0003X/T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u000b\t\u0005\u001d\u0011\u0011B\u0001\b[\u0016$(/[2t\u0015\t\tY!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\t\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\t\t9\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u001c\u0005U!AB!osJ+g-\u0001\u0005qe>\u001c'k\\8u!\u0011\t\t#a\f\u000f\t\u0005\r\u00121\u0006\t\u0005\u0003K\t)\"\u0004\u0002\u0002()!\u0011\u0011FA\u0007\u0003\u0019a$o\\8u}%!\u0011QFA\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011GA\u001a\u0005\u0019\u0019FO]5oO*!\u0011QFA\u000b\u0003\u0011!\u0018.\\3\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u001fj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0006kRLGn\u001d\u0006\u0005\u0003\u0007\n)%\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003\u0017\t9E\u0003\u0003\u0002J\u0005-\u0013AB1qC\u000eDWM\u0003\u0002\u0002N\u0005\u0019qN]4\n\t\u0005E\u0013Q\b\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0007qe>\u001cWm]:JI>\u0003H/\u0006\u0002\u0002ZA1\u00111CA.\u0003?JA!!\u0018\u0002\u0016\t1q\n\u001d;j_:\u0004B!a\u0005\u0002b%!\u00111MA\u000b\u0005\u0011auN\\4\u0002\u001bA\u0014xnY3tg&#w\n\u001d;!\u0003\u0019awnZ4feV\u0011\u00111\u000e\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)!\u0011\u0011OA&\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\t)(a\u001c\u0003\r1{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0001&\u001a=q_:,g\u000e^5bY2LH)Z2bs&twmV5oI><8+\u001b>f\u0013:\u001cVmY8oIN,\"!! \u0011\t\u0005M\u0011qP\u0005\u0005\u0003\u0003\u000b)BA\u0002J]R\f\u0011&\u001a=q_:,g\u000e^5bY2LH)Z2bs&twmV5oI><8+\u001b>f\u0013:\u001cVmY8oIN\u0004\u0013\u0001\u00056jM\u001aLWm\u001d)feN+7m\u001c8e\u0003EQ\u0017N\u001a4jKN\u0004VM]*fG>tG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u00055\u0015\u0011SAJ\u0003+\u000b9*!'\u0002\u001cB\u0019\u0011q\u0012\u0001\u000e\u0005\u0005\u0015\u0001bBA\u000f\u0019\u0001\u0007\u0011q\u0004\u0005\b\u0003ka\u0001\u0019AA\u001d\u0011\u001d\t)\u0006\u0004a\u0001\u00033Bq!a\u001a\r\u0001\u0004\tY\u0007C\u0005\u0002z1\u0001\n\u00111\u0001\u0002~!I\u0011Q\u0011\u0007\u0011\u0002\u0003\u0007\u0011QP\u0001\fY>\fG-\u0011<h!\u0006$\b.\u0006\u0002\u0002\"B!\u00111UAY\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016\u0001\u00024jY\u0016TA!a+\u0002.\u0006\u0019a.[8\u000b\u0005\u0005=\u0016\u0001\u00026bm\u0006LA!a-\u0002&\n!\u0001+\u0019;i\u00031aw.\u00193Bm\u001e\u0004\u0016\r\u001e5!\u0003!\u0019H/\u0019;QCRD\u0017!C:uCR\u0004\u0016\r\u001e5!\u0003-aw.\u00193Bm\u001edunY6\u0016\u0005\u0005}\u0006\u0003BAa\u0003\u001fl!!a1\u000b\t\u0005\u0015\u0017qY\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u0013\fY-\u0001\u0006d_:\u001cWO\u001d:f]RTA!!4\u0002.\u0006!Q\u000f^5m\u0013\u0011\t\t.a1\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u00031aw.\u00193Bm\u001edunY6!\u0003Ma\u0017m\u001d;M_\u0006$\u0017I^4Va\u0012\fG/Z't+\t\ty&A\fmCN$Hj\\1e\u0003Z<W\u000b\u001d3bi\u0016l5o\u0018\u0013fcR!\u0011Q\\Ar!\u0011\t\u0019\"a8\n\t\u0005\u0005\u0018Q\u0003\u0002\u0005+:LG\u000fC\u0005\u0002fR\t\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010J\u0019\u0002)1\f7\u000f\u001e'pC\u0012\feoZ+qI\u0006$X-T:!Q\u001d)\u00121^A\u0000\u0005\u0003\u0001B!!<\u0002|6\u0011\u0011q\u001e\u0006\u0005\u0003c\f\u00190A\u0006b]:|G/\u0019;j_:\u001c(\u0002BA{\u0003o\fAA[2ja*\u0011\u0011\u0011`\u0001\u0004]\u0016$\u0018\u0002BA\u007f\u0003_\u0014\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0005\u0005m\u0016!\u00047pC\u0012\feoZ(oK6Kg.\u0006\u0002\u0003\bA!\u00111\u0003B\u0005\u0013\u0011\u0011Y!!\u0006\u0003\r\u0011{WO\u00197f\u0003Eaw.\u00193Bm\u001e|e.Z'j]~#S-\u001d\u000b\u0005\u0003;\u0014\t\u0002C\u0005\u0002f^\t\t\u00111\u0001\u0003\b\u0005qAn\\1e\u0003Z<wJ\\3NS:\u0004\u0003f\u0002\r\u0002l\u0006}(\u0011A\u0001\u000fY>\fG-\u0011<h\r&4X-T5o\u0003Iaw.\u00193Bm\u001e4\u0015N^3NS:|F%Z9\u0015\t\u0005u'Q\u0004\u0005\n\u0003KT\u0012\u0011!a\u0001\u0005\u000f\tq\u0002\\8bI\u00063xMR5wK6Kg\u000e\t\u0015\b7\u0005-\u0018q B\u0001\u0003Eaw.\u00193Bm\u001e4\u0015N\u001a;fK:l\u0015N\\\u0001\u0016Y>\fG-\u0011<h\r&4G/Z3o\u001b&tw\fJ3r)\u0011\tiN!\u000b\t\u0013\u0005\u0015X$!AA\u0002\t\u001d\u0011A\u00057pC\u0012\feo\u001a$jMR,WM\\'j]\u0002BsAHAv\u0003\u007f\u0014\t!A\u0007tsN$X-\\\"qk2{7m[\u0001\u000fgf\u001cH/Z7DaVdunY6!\u00031!x\u000e^1m\u0007B,H+[7f\u0003A!x\u000e^1m\u0007B,H+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002^\ne\u0002\"CAsE\u0005\u0005\t\u0019AA0\u00035!x\u000e^1m\u0007B,H+[7fA!:1%a;\u0002\u0000\n}\u0012E\u0001B\u0018\u00035!x\u000e^1m\u0013\u0012dW\rV5nK\u0006\tBo\u001c;bY&#G.\u001a+j[\u0016|F%Z9\u0015\t\u0005u'q\t\u0005\n\u0003K,\u0013\u0011!a\u0001\u0003?\na\u0002^8uC2LE\r\\3US6,\u0007\u0005K\u0004'\u0003W\fyPa\u0010\u0002\u001f\u0015$7+_:uK6\u001c\u0005+\u0016'pG.\f\u0001#\u001a3TsN$X-\\\"Q+2{7m\u001b\u0011\u0002\u001b%$G.\u001b8h\u0015&4g-[3t\u0003EIG\r\\5oO*KgMZ5fg~#S-\u001d\u000b\u0005\u0003;\u00149\u0006C\u0005\u0002f*\n\t\u00111\u0001\u0002`\u0005q\u0011\u000e\u001a7j]\u001eT\u0015N\u001a4jKN\u0004\u0003fB\u0016\u0002l\u0006}(QL\u0011\u0003\u0005\u001b\nA\u0002^8uC2T\u0015N\u001a4jKN\f\u0001\u0003^8uC2T\u0015N\u001a4jKN|F%Z9\u0015\t\u0005u'Q\r\u0005\n\u0003Kl\u0013\u0011!a\u0001\u0003?\nQ\u0002^8uC2T\u0015N\u001a4jKN\u0004\u0003f\u0002\u0018\u0002l\u0006}(QL\u0001\u001fY\u0006\u001cH/\u00133mKNK8\u000f^3n+RLG.\u001b>bi&|gNV1mk\u0016\f!\u0005\\1ti&#G.Z*zgR,W.\u0016;jY&T\u0018\r^5p]Z\u000bG.^3`I\u0015\fH\u0003BAo\u0005cB\u0011\"!:1\u0003\u0003\u0005\rAa\u0002\u0002?1\f7\u000f^%eY\u0016\u001c\u0016p\u001d;f[V#\u0018\u000e\\5{CRLwN\u001c,bYV,\u0007\u0005K\u00042\u0003W\fyP!\u0018\u0002\u0019M\u0004\u0018mY3QCR$XM\u001d8\u0016\u0005\tm\u0004\u0003\u0002B?\u0005\u0007k!Aa \u000b\t\t\u0005\u00151Z\u0001\u0006e\u0016<W\r_\u0005\u0005\u0005\u000b\u0013yHA\u0004QCR$XM\u001d8\u0002\u001bM\u0004\u0018mY3QCR$XM\u001d8!\u0003i\u0001\u0018M]3oi\",7/[:F]\u000edwn]3e!\u0006$H/\u001a:o\u0003m\u0001\u0018M]3oi\",7/[:F]\u000edwn]3e!\u0006$H/\u001a:oA\u0005\u0011\u0002O]8dKN\u001c8\u000b^1u!\u0006$\bn\u00149u+\t\u0011\t\n\u0005\u0004\u0002\u0014\u0005m\u0013\u0011U\u0001\u0014aJ|7-Z:t'R\fG\u000fU1uQ>\u0003H\u000fI\u0001\u000faJ|7-Z:t\u0007B,Hj\\2l\u0003=\u0001(o\\2fgN\u001c\u0005/\u001e'pG.\u0004\u0013!\u00057bgR\u001c\u0016p\u001d;f[*KgMZ5fg\u0006)B.Y:u'f\u001cH/Z7KS\u001a4\u0017.Z:`I\u0015\fH\u0003BAo\u0005?C\u0011\"!:<\u0003\u0003\u0005\r!a\u0018\u0002%1\f7\u000f^*zgR,WNS5gM&,7\u000f\t\u0015\by\u0005-\u0018q BSC\t\u0011)*\u0001\nmCN$\bK]8dKN\u001c(*\u001b4gS\u0016\u001c\u0018A\u00067bgR\u0004&o\\2fgNT\u0015N\u001a4jKN|F%Z9\u0015\t\u0005u'Q\u0016\u0005\n\u0003Kt\u0014\u0011!a\u0001\u0003?\n1\u0003\\1tiB\u0013xnY3tg*KgMZ5fg\u0002BsaPAv\u0003\u007f\u0014)KA\u0007TsN$X-\\\"qkRKW.Z\n\b\u0001\u0006E!q\u0017B_!\u0011\t\u0019B!/\n\t\tm\u0016Q\u0003\u0002\b!J|G-^2u!\u0011\t\u0019Ba0\n\t\t\u0005\u0017Q\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005kN,'/A\u0003vg\u0016\u0014\b%\u0001\u0003oS\u000e,\u0017!\u00028jG\u0016\u0004\u0013AB:zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\t%$G.Z\u0001\u0006S\u0012dW\rI\u0001\u0007S><\u0016-\u001b;\u0002\u000f%|w+Y5uA\u0005\u0019\u0011N]9\u0002\t%\u0014\u0018\u000fI\u0001\bg>4G/\u0013:r\u0003!\u0019xN\u001a;JeF\u0004\u0013!B:uK\u0006d\u0017AB:uK\u0006d\u0007%A\u0003hk\u0016\u001cH/\u0001\u0004hk\u0016\u001cH\u000fI\u0001\nOV,7\u000f\u001e(jG\u0016\f!bZ;fgRt\u0015nY3!)Y\u0011iO!=\u0003t\nU(q\u001fB}\u0005w\u0014iPa@\u0004\u0002\r\r\u0001c\u0001Bx\u00016\t\u0001\u0001C\u0004\u0003DV\u0003\r!a\u0018\t\u000f\t\u001dW\u000b1\u0001\u0002`!9!1Z+A\u0002\u0005}\u0003b\u0002Bh+\u0002\u0007\u0011q\f\u0005\b\u0005',\u0006\u0019AA0\u0011\u001d\u00119.\u0016a\u0001\u0003?BqAa7V\u0001\u0004\ty\u0006C\u0004\u0003`V\u0003\r!a\u0018\t\u000f\t\rX\u000b1\u0001\u0002`!9!q]+A\u0002\u0005}\u0013!\u0002;pi\u0006d\u0017A\u0002;pi\u0006d\u0007%\u0001\u0003d_BLHC\u0006Bw\u0007\u001b\u0019ya!\u0005\u0004\u0014\rU1qCB\r\u00077\u0019iba\b\t\u0013\t\r\u0007\f%AA\u0002\u0005}\u0003\"\u0003Bd1B\u0005\t\u0019AA0\u0011%\u0011Y\r\u0017I\u0001\u0002\u0004\ty\u0006C\u0005\u0003Pb\u0003\n\u00111\u0001\u0002`!I!1\u001b-\u0011\u0002\u0003\u0007\u0011q\f\u0005\n\u0005/D\u0006\u0013!a\u0001\u0003?B\u0011Ba7Y!\u0003\u0005\r!a\u0018\t\u0013\t}\u0007\f%AA\u0002\u0005}\u0003\"\u0003Br1B\u0005\t\u0019AA0\u0011%\u00119\u000f\u0017I\u0001\u0002\u0004\ty&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r\u0015\"\u0006BA0\u0007OY#a!\u000b\u0011\t\r-2QG\u0007\u0003\u0007[QAaa\f\u00042\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u0007g\t)\"\u0001\u0006b]:|G/\u0019;j_:LAaa\u000e\u0004.\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%s\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\n\u0004'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007\u001f\u0002Ba!\u0015\u0004X5\u001111\u000b\u0006\u0005\u0007+\ni+\u0001\u0003mC:<\u0017\u0002BA\u0019\u0007'\nA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004`\r\u0015\u0004\u0003BA\n\u0007CJAaa\u0019\u0002\u0016\t\u0019\u0011I\\=\t\u0013\u0005\u0015X-!AA\u0002\u0005u\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\r-\u0004CBB7\u0007g\u001ay&\u0004\u0002\u0004p)!1\u0011OA\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007k\u001ayG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BB>\u0007\u0003\u0003B!a\u0005\u0004~%!1qPA\u000b\u0005\u001d\u0011un\u001c7fC:D\u0011\"!:h\u0003\u0003\u0005\raa\u0018\u0002\u0011!\f7\u000f[\"pI\u0016$\"!! \u0002\u0011Q|7\u000b\u001e:j]\u001e$\"aa\u0014\u0002\r\u0015\fX/\u00197t)\u0011\u0019Yha$\t\u0013\u0005\u0015(.!AA\u0002\r}\u0013!D*zgR,Wn\u00119v)&lW\rE\u0002\u0003p2\u001cR\u0001\\BL\u0005{\u0003\"d!'\u0004 \u0006}\u0013qLA0\u0003?\ny&a\u0018\u0002`\u0005}\u0013qLA0\u0005[l!aa'\u000b\t\ru\u0015QC\u0001\beVtG/[7f\u0013\u0011\u0019\tka'\u0003%\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\r\u000b\u0003\u0007'\u000bQ!\u00199qYf$bC!<\u0004*\u000e-6QVBX\u0007c\u001b\u0019l!.\u00048\u000ee61\u0018\u0005\b\u0005\u0007|\u0007\u0019AA0\u0011\u001d\u00119m\u001ca\u0001\u0003?BqAa3p\u0001\u0004\ty\u0006C\u0004\u0003P>\u0004\r!a\u0018\t\u000f\tMw\u000e1\u0001\u0002`!9!q[8A\u0002\u0005}\u0003b\u0002Bn_\u0002\u0007\u0011q\f\u0005\b\u0005?|\u0007\u0019AA0\u0011\u001d\u0011\u0019o\u001ca\u0001\u0003?BqAa:p\u0001\u0004\ty&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u00057\u0011\u001a\t\u0007\u0003'\tYfa1\u00111\u0005M1QYA0\u0003?\ny&a\u0018\u0002`\u0005}\u0013qLA0\u0003?\ny&\u0003\u0003\u0004H\u0006U!a\u0002+va2,\u0017\u0007\r\u0005\n\u0007\u0017\u0004\u0018\u0011!a\u0001\u0005[\f1\u0001\u001f\u00131\u0003Q\u0019\u0018p\u001d;f[\u000e\u0003X/\u0016;jY&T\u0018\r^5p]R\u0011!qA\u00011Kb\u0004xN\\3oi&\fG\u000e\\=EK\u000e\f\u00170\u001b8h'f\u001cH/Z7DaV,F/\u001b7ju\u0006$\u0018n\u001c8Bm\u0016\u0014\u0018mZ3\u0002+A\u0014xnY3tg\u000e\u0003X/\u0016;jY&T\u0018\r^5p]\u0006)2-\u001e:sK:$\bK]8dKN\u001c(*\u001b4gS\u0016\u001cH\u0003BA0\u00073Dqaa7u\u0001\u0004\t\t+\u0001\u0003qCRD\u0017\u0001F2veJ,g\u000e^*zgR,WNS5gM&,7\u000f\u0006\u0002\u0003n\u0006iqN\\3NS:du.\u00193Bm\u001e\faBZ5wK6Kg\u000eT8bI\u00063x-A\tgS\u001a$X-\u001a8NS:du.\u00193Bm\u001e\fQ\"\u001e9eCR,Gj\\1e\u0003Z<G\u0003BB>\u0007WDqa!<z\u0001\u0004\ty&A\u0002o_^\fa!^:bE2,GCAB>\u0003Qi\u0017-\u001f2f%\u0016<\u0017n\u001d;fe6+GO]5dgR!\u0011Q\\B|\u0011\u001d\u0019Ip\u001fa\u0001\u0007w\f\u0001B]3hSN$(/\u001f\t\u0005\u0007{$i!\u0004\u0002\u0004\u0000*!A\u0011\u0001C\u0002\u0003\u0011\u0019wN]3\u000b\t\u0005\u001dAQ\u0001\u0006\u0005\t\u000f!I!\u0001\u0004zC6lWM\u001d\u0006\u0003\t\u0017\t1aY8n\u0013\u0011!yaa@\u0003\u001f5+GO]5dgJ+w-[:uef\f\u0001\u0004T5okb\u001c\u0005/^'fiJL7m]\"pY2,7\r^8s!\r\ty)`\n\u0004{\u0006EAC\u0001C\n\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011AQ\u0004\u0016\u0005\u0003{\u001a9#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\u000e")
public class LinuxCpuMetricsCollector {
    private volatile LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime$module;
    private final String procRoot;
    private final Time time;
    private final Option<Object> processIdOpt;
    private final Logger logger;
    private final int exponentiallyDecayingWindowSizeInSeconds;
    private final int jiffiesPerSecond;
    private final Path loadAvgPath;
    private final Path statPath;
    private final ReentrantLock loadAvgLock;
    @GuardedBy(value="loadAvgLock")
    private long lastLoadAvgUpdateMs;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgOneMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFiveMin;
    @GuardedBy(value="loadAvgLock")
    private double loadAvgFifteenMin;
    private final ReentrantLock systemCpuLock;
    @GuardedBy(value="systemCpuLock")
    private long totalCpuTime;
    @GuardedBy(value="systemCpuLock")
    private long totalIdleTime;
    private final ReentrantLock edSystemCPULock;
    @GuardedBy(value="edSystemCPULock")
    private long idlingJiffies;
    @GuardedBy(value="edSystemCPULock")
    private long totalJiffies;
    @GuardedBy(value="edSystemCPULock")
    private double lastIdleSystemUtilizationValue;
    private final Pattern spacePattern;
    private final Pattern parenthesisEnclosedPattern;
    private final Option<Path> processStatPathOpt;
    private final ReentrantLock processCpuLock;
    @GuardedBy(value="processCpuLock")
    private long lastSystemJiffies;
    @GuardedBy(value="processCpuLock")
    private long lastProcessJiffies;

    public static int $lessinit$greater$default$6() {
        return LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$6();
    }

    public static int $lessinit$greater$default$5() {
        return LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$5();
    }

    public LinuxCpuMetricsCollector$SystemCpuTime$ SystemCpuTime() {
        if (this.SystemCpuTime$module == null) {
            this.SystemCpuTime$lzycompute$1();
        }
        return this.SystemCpuTime$module;
    }

    public Time time() {
        return this.time;
    }

    public Option<Object> processIdOpt() {
        return this.processIdOpt;
    }

    public Logger logger() {
        return this.logger;
    }

    public int exponentiallyDecayingWindowSizeInSeconds() {
        return this.exponentiallyDecayingWindowSizeInSeconds;
    }

    public int jiffiesPerSecond() {
        return this.jiffiesPerSecond;
    }

    private Path loadAvgPath() {
        return this.loadAvgPath;
    }

    private Path statPath() {
        return this.statPath;
    }

    private ReentrantLock loadAvgLock() {
        return this.loadAvgLock;
    }

    private long lastLoadAvgUpdateMs() {
        return this.lastLoadAvgUpdateMs;
    }

    private void lastLoadAvgUpdateMs_$eq(long x$1) {
        this.lastLoadAvgUpdateMs = x$1;
    }

    private double loadAvgOneMin() {
        return this.loadAvgOneMin;
    }

    private void loadAvgOneMin_$eq(double x$1) {
        this.loadAvgOneMin = x$1;
    }

    private double loadAvgFiveMin() {
        return this.loadAvgFiveMin;
    }

    private void loadAvgFiveMin_$eq(double x$1) {
        this.loadAvgFiveMin = x$1;
    }

    private double loadAvgFifteenMin() {
        return this.loadAvgFifteenMin;
    }

    private void loadAvgFifteenMin_$eq(double x$1) {
        this.loadAvgFifteenMin = x$1;
    }

    private ReentrantLock systemCpuLock() {
        return this.systemCpuLock;
    }

    private long totalCpuTime() {
        return this.totalCpuTime;
    }

    private void totalCpuTime_$eq(long x$1) {
        this.totalCpuTime = x$1;
    }

    private long totalIdleTime() {
        return this.totalIdleTime;
    }

    private void totalIdleTime_$eq(long x$1) {
        this.totalIdleTime = x$1;
    }

    private ReentrantLock edSystemCPULock() {
        return this.edSystemCPULock;
    }

    private long idlingJiffies() {
        return this.idlingJiffies;
    }

    private void idlingJiffies_$eq(long x$1) {
        this.idlingJiffies = x$1;
    }

    private long totalJiffies() {
        return this.totalJiffies;
    }

    private void totalJiffies_$eq(long x$1) {
        this.totalJiffies = x$1;
    }

    private double lastIdleSystemUtilizationValue() {
        return this.lastIdleSystemUtilizationValue;
    }

    private void lastIdleSystemUtilizationValue_$eq(double x$1) {
        this.lastIdleSystemUtilizationValue = x$1;
    }

    private Pattern spacePattern() {
        return this.spacePattern;
    }

    private Pattern parenthesisEnclosedPattern() {
        return this.parenthesisEnclosedPattern;
    }

    private Option<Path> processStatPathOpt() {
        return this.processStatPathOpt;
    }

    private ReentrantLock processCpuLock() {
        return this.processCpuLock;
    }

    private long lastSystemJiffies() {
        return this.lastSystemJiffies;
    }

    private void lastSystemJiffies_$eq(long x$1) {
        this.lastSystemJiffies = x$1;
    }

    private long lastProcessJiffies() {
        return this.lastProcessJiffies;
    }

    private void lastProcessJiffies_$eq(long x$1) {
        this.lastProcessJiffies = x$1;
    }

    public double systemCpuUtilization() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.systemCpuLock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idleTime = systemJiffies.idle() + systemJiffies.ioWait();
                        if (this.totalCpuTime() == 0L) {
                            this.totalCpuTime_$eq(total);
                            this.totalIdleTime_$eq(idleTime);
                            d2 = 0.0;
                            break block6;
                        }
                        long currWindowCpuTime = total - this.totalCpuTime();
                        long currWindowIdleTime = idleTime - this.totalIdleTime();
                        this.totalCpuTime_$eq(total);
                        this.totalIdleTime_$eq(idleTime);
                        double idlePercentage = (double)currWindowIdleTime * 100.0 / (double)currWindowCpuTime;
                        d = 100.0 - idlePercentage;
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.systemCpuLock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double exponentiallyDecayingSystemCpuUtilizationAverage() {
        double d;
        block7: {
            double d2;
            block6: {
                try {
                    try {
                        this.edSystemCPULock().lock();
                        SystemCpuTime systemJiffies = this.currentSystemJiffies();
                        long total = systemJiffies.total();
                        long idle = systemJiffies.idle() + systemJiffies.ioWait();
                        long totalJiffiesElapsed = total - this.totalJiffies();
                        if (totalJiffiesElapsed == 0L) {
                            d2 = 100.0 - this.lastIdleSystemUtilizationValue();
                            break block6;
                        }
                        long idlingJiffiesElapsed = idle - this.idlingJiffies();
                        double elapsedTime = (double)totalJiffiesElapsed / (double)this.jiffiesPerSecond();
                        double correction = 1.0 - Math.exp(-elapsedTime / (double)this.exponentiallyDecayingWindowSizeInSeconds());
                        double currentIdleSystemUtilisationAverage = (double)idlingJiffiesElapsed * 100.0 / (double)totalJiffiesElapsed;
                        this.lastIdleSystemUtilizationValue_$eq(this.lastIdleSystemUtilizationValue() + correction * (currentIdleSystemUtilisationAverage - this.lastIdleSystemUtilizationValue()));
                        this.idlingJiffies_$eq(idle);
                        this.totalJiffies_$eq(total);
                        d = 100.0 - this.lastIdleSystemUtilizationValue();
                    }
                    catch (Throwable t) {
                        this.logger().warn("Unable to update CPU metrics", t);
                        d = -1.0;
                    }
                    break block7;
                }
                finally {
                    this.edSystemCPULock().unlock();
                }
            }
            return d2;
        }
        return d;
    }

    public double processCpuUtilization() {
        double d;
        Option<Path> option = this.processStatPathOpt();
        if (option instanceof Some) {
            double d2;
            block12: {
                double d3;
                block11: {
                    Path path = (Path)((Some)option).value();
                    try {
                        try {
                            this.processCpuLock().lock();
                            SystemCpuTime systemJiffies = this.currentSystemJiffies();
                            long processJiffies = this.currentProcessJiffies(path);
                            if (this.lastProcessJiffies() == 0L || this.lastSystemJiffies() == 0L) {
                                this.lastSystemJiffies_$eq(systemJiffies.total());
                                this.lastProcessJiffies_$eq(processJiffies);
                                d3 = 0.0;
                                break block11;
                            }
                            long currentWindowSystemJiffies = systemJiffies.total() - this.lastSystemJiffies();
                            long currentWindowProcessJiffies = processJiffies - this.lastProcessJiffies();
                            this.lastSystemJiffies_$eq(systemJiffies.total());
                            this.lastProcessJiffies_$eq(processJiffies);
                            if (currentWindowSystemJiffies == 0L) {
                                d3 = 0.0;
                                break block11;
                            }
                            d2 = (double)currentWindowProcessJiffies * 100.0 / (double)currentWindowSystemJiffies;
                        }
                        catch (Throwable t) {
                            this.logger().warn("Unable to update CPU metrics for the process", t);
                            d2 = -1.0;
                        }
                        break block12;
                    }
                    finally {
                        this.processCpuLock().unlock();
                    }
                }
                return d3;
            }
            d = d2;
        } else if (None$.MODULE$.equals(option)) {
            d = -1.0;
        } else {
            throw new MatchError(option);
        }
        return d;
    }

    private long currentProcessJiffies(Path path) {
        String line = (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path)).asScala()).head();
        line = this.parenthesisEnclosedPattern().matcher(line).replaceFirst("process_name");
        String[] cpu = this.spacePattern().split(line);
        return new StringOps(Predef$.MODULE$.augmentString(cpu[13])).toLong() + new StringOps(Predef$.MODULE$.augmentString(cpu[14])).toLong();
    }

    public SystemCpuTime currentSystemJiffies() {
        String line = (String)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.statPath())).asScala()).head();
        String[] cpu = this.spacePattern().split(line);
        return new SystemCpuTime(this, new StringOps(Predef$.MODULE$.augmentString(cpu[1])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[2])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[3])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[4])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[5])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[6])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[7])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[8])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[9])).toLong(), new StringOps(Predef$.MODULE$.augmentString(cpu[10])).toLong());
    }

    public double oneMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgOneMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fiveMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFiveMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    public double fifteenMinLoadAvg() {
        double d;
        try {
            this.loadAvgLock().lock();
            long curMs = this.time().milliseconds();
            if (curMs != this.lastLoadAvgUpdateMs()) {
                this.updateLoadAvg(curMs);
            }
            d = this.loadAvgFifteenMin();
        }
        finally {
            this.loadAvgLock().unlock();
        }
        return d;
    }

    private boolean updateLoadAvg(long now) {
        try {
            this.loadAvgOneMin_$eq(-1.0);
            this.loadAvgFiveMin_$eq(-1.0);
            this.loadAvgFifteenMin_$eq(-1.0);
            String[] loadAvgArr = ((String)((BufferLike)CollectionConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.loadAvgPath())).asScala()).apply(0)).split("\\s+");
            this.loadAvgOneMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[0])).toDouble());
            this.loadAvgFiveMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[1])).toDouble());
            this.loadAvgFifteenMin_$eq(new StringOps(Predef$.MODULE$.augmentString(loadAvgArr[2])).toDouble());
            this.lastLoadAvgUpdateMs_$eq(now);
            return true;
        }
        catch (Throwable t) {
            this.logger().warn("Unable to update CPU metrics", t);
            return false;
        }
    }

    public boolean usable() {
        return this.loadAvgPath().toFile().exists() && this.statPath().toFile().exists();
    }

    public void maybeRegisterMetrics(MetricsRegistry registry) {
        if (this.usable()) {
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-1m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-5m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-load-avg-15m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-system-cpu-utilization-1m", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
            LinuxCpuMetricsCollector.registerGauge$1("linux-process-cpu-utilization", (Gauge)new Gauge<Object>(this){
                private final /* synthetic */ LinuxCpuMetricsCollector $outer;

                public final double value() {
                    return this.$outer.kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$11();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, registry);
        }
    }

    private final void SystemCpuTime$lzycompute$1() {
        synchronized (this) {
            if (this.SystemCpuTime$module == null) {
                this.SystemCpuTime$module = new LinuxCpuMetricsCollector$SystemCpuTime$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Path $anonfun$processStatPathOpt$1(LinuxCpuMetricsCollector $this, long pid) {
        return Paths.get($this.procRoot, Long.toString(pid), "stat");
    }

    private static final void registerGauge$1(String name, Gauge gauge, MetricsRegistry registry$1) {
        MetricName metricName = KafkaYammerMetrics.getMetricName((String)"kafka.server", (String)"KafkaServer", (String)name);
        registry$1.newGauge(metricName, gauge);
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$1() {
        return this.oneMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$3() {
        return this.fiveMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$5() {
        return this.fifteenMinLoadAvg();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$7() {
        return this.systemCpuUtilization();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$9() {
        return this.exponentiallyDecayingSystemCpuUtilizationAverage();
    }

    public final /* synthetic */ double kafka$metrics$LinuxCpuMetricsCollector$$$anonfun$maybeRegisterMetrics$11() {
        return this.processCpuUtilization();
    }

    public LinuxCpuMetricsCollector(String procRoot, Time time, Option<Object> processIdOpt, Logger logger, int exponentiallyDecayingWindowSizeInSeconds, int jiffiesPerSecond) {
        this.procRoot = procRoot;
        this.time = time;
        this.processIdOpt = processIdOpt;
        this.logger = logger;
        this.exponentiallyDecayingWindowSizeInSeconds = exponentiallyDecayingWindowSizeInSeconds;
        this.jiffiesPerSecond = jiffiesPerSecond;
        this.loadAvgPath = Paths.get(procRoot, "loadavg");
        this.statPath = Paths.get(procRoot, "stat");
        this.loadAvgLock = new ReentrantLock();
        this.lastLoadAvgUpdateMs = -1L;
        this.loadAvgOneMin = -1.0;
        this.loadAvgFiveMin = -1.0;
        this.loadAvgFifteenMin = -1.0;
        this.systemCpuLock = new ReentrantLock();
        this.totalCpuTime = 0L;
        this.totalIdleTime = 0L;
        this.edSystemCPULock = new ReentrantLock();
        this.idlingJiffies = 0L;
        this.totalJiffies = 0L;
        this.lastIdleSystemUtilizationValue = 0.0;
        this.spacePattern = Pattern.compile("\\s+");
        this.parenthesisEnclosedPattern = Pattern.compile("\\(.*?\\)");
        this.processStatPathOpt = processIdOpt.map((Function1 & Serializable & scala.Serializable)pid -> LinuxCpuMetricsCollector.$anonfun$processStatPathOpt$1(this, BoxesRunTime.unboxToLong((Object)pid)));
        this.processCpuLock = new ReentrantLock();
        this.lastSystemJiffies = 0L;
        this.lastProcessJiffies = 0L;
    }

    public class SystemCpuTime
    implements Product,
    scala.Serializable {
        private final long user;
        private final long nice;
        private final long system;
        private final long idle;
        private final long ioWait;
        private final long irq;
        private final long softIrq;
        private final long steal;
        private final long guest;
        private final long guestNice;
        private final long total;
        public final /* synthetic */ LinuxCpuMetricsCollector $outer;

        public long user() {
            return this.user;
        }

        public long nice() {
            return this.nice;
        }

        public long system() {
            return this.system;
        }

        public long idle() {
            return this.idle;
        }

        public long ioWait() {
            return this.ioWait;
        }

        public long irq() {
            return this.irq;
        }

        public long softIrq() {
            return this.softIrq;
        }

        public long steal() {
            return this.steal;
        }

        public long guest() {
            return this.guest;
        }

        public long guestNice() {
            return this.guestNice;
        }

        public long total() {
            return this.total;
        }

        public SystemCpuTime copy(long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            return new SystemCpuTime(this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer(), user, nice, system, idle, ioWait, irq, softIrq, steal, guest, guestNice);
        }

        public long copy$default$1() {
            return this.user();
        }

        public long copy$default$10() {
            return this.guestNice();
        }

        public long copy$default$2() {
            return this.nice();
        }

        public long copy$default$3() {
            return this.system();
        }

        public long copy$default$4() {
            return this.idle();
        }

        public long copy$default$5() {
            return this.ioWait();
        }

        public long copy$default$6() {
            return this.irq();
        }

        public long copy$default$7() {
            return this.softIrq();
        }

        public long copy$default$8() {
            return this.steal();
        }

        public long copy$default$9() {
            return this.guest();
        }

        public String productPrefix() {
            return "SystemCpuTime";
        }

        public int productArity() {
            return 10;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.user());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.nice());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.system());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.idle());
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this.ioWait());
                }
                case 5: {
                    return BoxesRunTime.boxToLong((long)this.irq());
                }
                case 6: {
                    return BoxesRunTime.boxToLong((long)this.softIrq());
                }
                case 7: {
                    return BoxesRunTime.boxToLong((long)this.steal());
                }
                case 8: {
                    return BoxesRunTime.boxToLong((long)this.guest());
                }
                case 9: {
                    return BoxesRunTime.boxToLong((long)this.guestNice());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SystemCpuTime;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.user())), (int)Statics.longHash((long)this.nice())), (int)Statics.longHash((long)this.system())), (int)Statics.longHash((long)this.idle())), (int)Statics.longHash((long)this.ioWait())), (int)Statics.longHash((long)this.irq())), (int)Statics.longHash((long)this.softIrq())), (int)Statics.longHash((long)this.steal())), (int)Statics.longHash((long)this.guest())), (int)Statics.longHash((long)this.guestNice())), (int)10);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof SystemCpuTime && ((SystemCpuTime)x$1).kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() == this.kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer();
                    if (!bl) break block3;
                    SystemCpuTime systemCpuTime = (SystemCpuTime)x$1;
                    if (!(this.user() == systemCpuTime.user() && this.nice() == systemCpuTime.nice() && this.system() == systemCpuTime.system() && this.idle() == systemCpuTime.idle() && this.ioWait() == systemCpuTime.ioWait() && this.irq() == systemCpuTime.irq() && this.softIrq() == systemCpuTime.softIrq() && this.steal() == systemCpuTime.steal() && this.guest() == systemCpuTime.guest() && this.guestNice() == systemCpuTime.guestNice() && systemCpuTime.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LinuxCpuMetricsCollector kafka$metrics$LinuxCpuMetricsCollector$SystemCpuTime$$$outer() {
            return this.$outer;
        }

        public SystemCpuTime(LinuxCpuMetricsCollector $outer, long user, long nice, long system, long idle, long ioWait, long irq, long softIrq, long steal, long guest, long guestNice) {
            this.user = user;
            this.nice = nice;
            this.system = system;
            this.idle = idle;
            this.ioWait = ioWait;
            this.irq = irq;
            this.softIrq = softIrq;
            this.steal = steal;
            this.guest = guest;
            this.guestNice = guestNice;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
            this.total = user + nice + system + idle + ioWait + irq + softIrq + steal;
        }
    }
}

