/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kafka.restore.operators.FtpsSegmentView;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.CompactStats;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierUtils;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicPartition;

public class ResetPartitionOperator {
    private FtpsSegmentView ftpsSegmentView;

    public ResetPartitionOperator(TopicPartition topicPartition, String stateFileName) throws Exception {
        this.ftpsSegmentView = new FtpsSegmentView(topicPartition, new File(stateFileName), -1L);
    }

    public Map<UUID, String> execute() throws Exception {
        HashMap<UUID, String> segmentPathMap = new HashMap<UUID, String>();
        for (int index = 0; index < this.ftpsSegmentView.segmentStateList().size(); ++index) {
            SegmentState segmentState = this.ftpsSegmentView.segmentStateList().get(index);
            if (segmentState.state() != TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE && segmentState.state() != TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE && segmentState.state() != TierObjectMetadata.State.SEGMENT_DELETE_INITIATE) continue;
            TierUtils.updateSegmentState(this.ftpsSegmentView.topicIdPartition(), segmentState, TierObjectMetadata.State.SEGMENT_FENCED, this.ftpsSegmentView.stateFileChannel(), false, Long.MAX_VALUE);
            TierObjectStore.ObjectMetadata objectMetadata = new TierObjectStore.ObjectMetadata(this.ftpsSegmentView.topicIdPartition(), segmentState.objectId(), segmentState.tierEpoch(), segmentState.baseOffset(), segmentState.hasAbortedTxns(), segmentState.hasProducerState(), segmentState.hasEpochState(), segmentState.opaqueData());
            segmentPathMap.put(segmentState.objectId(), objectMetadata.toPath("", TierObjectStore.FileType.SEGMENT));
        }
        Header oldHeader = this.ftpsSegmentView.header();
        Header newHeader = new Header(oldHeader.topicId(), (byte)oldHeader.version(), oldHeader.tierEpoch(), oldHeader.status(), -1L, -1L, oldHeader.globalMaterializedOffsetAndEpoch(), oldHeader.localMaterializedOffsetAndEpoch(), OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, oldHeader.hasCompactDirtyStartOffset(), -1L, CompactStats.EMPTY, CompactStats.EMPTY, oldHeader.hasStateChangeTimestamp(), oldHeader.hasSnapshotInfo(), oldHeader.lastSnapshotTimestampMs(), oldHeader.lastSnapshotId());
        this.ftpsSegmentView.updateFtpsHeader(newHeader);
        this.ftpsSegmentView.close();
        return segmentPathMap;
    }

    public FtpsSegmentView operatorContext() {
        return this.ftpsSegmentView;
    }
}

