/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.operators;

import kafka.tier.TopicIdPartition;
import kafka.tier.state.SegmentState;
import kafka.tier.store.TierObjectStore;

public class SegmentStateAndPath {
    private final SegmentState segmentState;
    private final String path;
    private final TopicIdPartition topicIdPartition;

    public SegmentStateAndPath(TopicIdPartition topicIdPartition, SegmentState segmentState) {
        this(topicIdPartition, segmentState, null);
    }

    public SegmentStateAndPath(TopicIdPartition topicIdPartition, SegmentState segmentState, String path) {
        this.topicIdPartition = topicIdPartition;
        this.segmentState = segmentState;
        if (path == null) {
            TierObjectStore.ObjectMetadata objectMetadata = new TierObjectStore.ObjectMetadata(topicIdPartition, segmentState.objectId(), segmentState.tierEpoch(), segmentState.baseOffset(), segmentState.hasAbortedTxns(), segmentState.hasProducerState(), segmentState.hasEpochState(), segmentState.opaqueData());
            this.path = objectMetadata.toPath("", TierObjectStore.FileType.SEGMENT);
        } else {
            this.path = path;
        }
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public SegmentState segmentState() {
        return this.segmentState;
    }

    public String path() {
        return this.path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path).append(" (").append(this.segmentState).append(")");
        return sb.toString();
    }
}

