/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.statemachine.transitions;

import kafka.restore.MessageEmitter;
import kafka.restore.configmap.NodeConfig;
import kafka.restore.messages.KafkaFetchFtpsRequest;
import kafka.restore.messages.KafkaTierPartitionStatusResponse;
import kafka.restore.messages.MessageRequest;
import kafka.restore.messages.RestoreFtpsFromSnapshotRequest;
import kafka.restore.snapshot.FtpsStateForRestore;
import kafka.restore.statemachine.api.Event;
import kafka.restore.statemachine.api.FiniteStateMachine;
import kafka.restore.statemachine.api.State;
import kafka.restore.statemachine.transitions.AbstractTransition;

public class FenceEventSentToPartitionFencedTransition
extends AbstractTransition {
    public FenceEventSentToPartitionFencedTransition(MessageEmitter messageEmitter) {
        super(messageEmitter);
    }

    @Override
    public State getSourceState() {
        return State.FENCE_EVENT_SENT;
    }

    @Override
    public State getTargetState() {
        return State.PARTITION_FENCED;
    }

    public boolean handleEvent(FiniteStateMachine fsm, Event event) {
        Object responseObject = event.getData("message_response");
        if (!(responseObject instanceof KafkaTierPartitionStatusResponse)) {
            return false;
        }
        String topic = (String)fsm.getMetadata("topic");
        int partition = (Integer)fsm.getMetadata("partition");
        NodeConfig broker = (NodeConfig)fsm.getMetadata("partition_leader");
        MessageRequest request = null;
        if (this.shouldRestoreFromFtpsSnapshot(fsm)) {
            FtpsStateForRestore ftpsForRestore = (FtpsStateForRestore)fsm.getMetadata("ftps_for_restore");
            request = new RestoreFtpsFromSnapshotRequest(0, topic, partition, null, ftpsForRestore);
        } else {
            request = new KafkaFetchFtpsRequest(0, topic, partition, broker);
        }
        LOGGER.debug(String.format("[%s-%d]: %s handled the event, %s in queue", topic, partition, this.getName(), request.name()));
        this.messageEmitter.submitRequest(request);
        return true;
    }
}

