/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tUe!B\u00181\u0003\u0003)\u0004\u0002C\"\u0001\u0005\u000b\u0007I\u0011\u0001#\t\u0011A\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\u000b\u0001B\u0001B\u0003%q\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011!Y\u0007A!A!\u0002\u0013a\u0007\"\u0002:\u0001\t\u0003\u0019\b\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\ti\u0002\u0001Q\u0001\n\u0005E\u0001BCA\u0010\u0001\t\u0007I\u0011\u0001\u0019\u0002\"!A\u0011Q\u0007\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0005\u0002:!A\u00111\n\u0001!\u0002\u0013\tY\u0004C\u0005\u0002N\u0001\u0001\r\u0011\"\u0003\u0002P!I\u0011\u0011\u000b\u0001A\u0002\u0013%\u00111\u000b\u0005\b\u0003?\u0002\u0001\u0015)\u0003T\u0011%\t\t\u0007\u0001b\u0001\n#\t\u0019\u0007C\u0004\u0002f\u0001\u0001\u000b\u0011B,\t\u0013\u0005\u001d\u0004A1A\u0005\u0002\u0005%\u0004\u0002CA9\u0001\u0001\u0006I!a\u001b\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CA?\u0001\u0001\u0006I!a\u001e\t\u0011\u0005}\u0004\u0001\"\u00011\u0003\u0003Cq!a!\u0001\t\u0013\t)\t\u0003\u0005\u0002\u0014\u0002!\t\u0001MA(\u0011\u001d\t)\n\u0001C\u0001\u0003/C\u0001\"!(\u0001\t\u0003\u0001\u0014q\u0014\u0005\t\u0003g\u0003A\u0011\u0001\u0019\u00026\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0006bBAg\u0001\u0019\u0005\u0011q\u001a\u0005\b\u0003_\u0004A\u0011AAy\u0011%\u0011Y\u0001AI\u0001\n\u0003\u0011i\u0001C\u0004\u0003$\u0001!\tA!\n\t\u000f\t%\u0002\u0001\"\u0005\u0003,!9!Q\u0007\u0001\u0005\u0002\u0005\u0005\u0005b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005\u0017\u0002A\u0011\u0001B'\u0011\u001d\u00119\u0007\u0001C\u0001\u0005SBqA!\u001e\u0001\t\u0003\t\t\tC\u0004\u0003x\u0001!\t!!!\b\u0013\te\u0004'!A\t\u0002\tmd\u0001C\u00181\u0003\u0003E\tA! \t\rI\\C\u0011\u0001B@\u0011%\u0011\tiKI\u0001\n\u0003\u0011\u0019\tC\u0005\u0003\f.\n\n\u0011\"\u0001\u0003\u000e\n1\u0012IY:ue\u0006\u001cGOR3uG\",'/T1oC\u001e,'O\u0003\u00022e\u000511/\u001a:wKJT\u0011aM\u0001\u0006W\u000647.Y\u0002\u0001+\t1toE\u0002\u0001ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001 B\u001b\u0005y$B\u0001!3\u0003\u0015)H/\u001b7t\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\t9\fW.Z\u000b\u0002\u000bB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u001d\u000e\u0003%S!A\u0013\u001b\u0002\rq\u0012xn\u001c;?\u0013\ta\u0015(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001':\u0003\u0015q\u0017-\\3!\u0003!\u0019G.[3oi&#\u0017a\u00038v[\u001a+Go\u00195feN\u0004\"\u0001\u000f+\n\u0005UK$aA%oi\u0006Ia-\u001a;dQ6{G-\u001a\t\u00031fk\u0011\u0001M\u0005\u00035B\u0012ACR3uG\"\u001cuN\u001c8fGRLwN\\:N_\u0012,\u0017!C:dQ\u0016$W\u000f\\3s!\rATlX\u0005\u0003=f\u0012aa\u00149uS>t\u0007C\u00011j\u001b\u0005\t'B\u00012d\u0003\u0011)H/\u001b7\u000b\u0005E\"'BA\u001af\u0015\t1w-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0006\u0019qN]4\n\u0005)\f'!C*dQ\u0016$W\u000f\\3s\u0003=)\u0007\u0010\u001e:b\u001b\u0016$(/[2UC\u001e\u001c\b\u0003B7q\u000b\u0016k\u0011A\u001c\u0006\u0003_f\n!bY8mY\u0016\u001cG/[8o\u0013\t\thNA\u0002NCB\fa\u0001P5oSRtD#\u0004;\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY\u0001E\u0002Y\u0001U\u0004\"A^<\r\u0001\u0011)\u0001\u0010\u0001b\u0001s\n\tA+\u0005\u0002{{B\u0011\u0001h_\u0005\u0003yf\u0012qAT8uQ&tw\r\u0005\u0002Y}&\u0011q\u0010\r\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011\u0015\u0019\u0005\u00021\u0001F\u0011\u0015\t\u0006\u00021\u0001F\u0011\u0015\u0011\u0006\u00021\u0001T\u0011\u00151\u0006\u00021\u0001X\u0011\u001dY\u0006\u0002%AA\u0002qCqa\u001b\u0005\u0011\u0002\u0003\u0007A.\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u0018\r\fq!\\3ue&\u001c7/\u0003\u0003\u0002\u001c\u0005U!!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0001CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199\u0016\u0005\u0005\r\u0002cBA\u0013\u0003W\ty#^\u0007\u0003\u0003OQ1!!\u000bo\u0003\u001diW\u000f^1cY\u0016LA!!\f\u0002(\t9\u0001*Y:i\u001b\u0006\u0004\bc\u0001-\u00022%\u0019\u00111\u0007\u0019\u0003\u0015\u0019+Go\u00195feR\u000bw-A\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'ba\u0002\nA\u0001\\8dWV\u0011\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0013\u0001\u00026bm\u0006LA!!\u0013\u0002@\t1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nAC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014X#A*\u000219,XNR3uG\",'o\u001d)fe\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0003\u0002V\u0005m\u0003c\u0001\u001d\u0002X%\u0019\u0011\u0011L\u001d\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003;\u0002\u0012\u0011!a\u0001'\u0006\u0019\u0001\u0010J\u0019\u0002+9,XNR3uG\",'o\u001d)fe\n\u0013xn[3sA\u0005Y\"/\u001a9mS\u000e\fg)\u001a;dQ\u000e{gN\\3di&|gn]'pI\u0016,\u0012aV\u0001\u001de\u0016\u0004H.[2b\r\u0016$8\r[\"p]:,7\r^5p]Nlu\u000eZ3!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002lA\u0019\u0001,!\u001c\n\u0007\u0005=\u0004G\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\tb-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\tQ\fwm]\u000b\u0003\u0003o\u0002R!\u001c9\u0002z\u0015\u0003B!!\u0010\u0002|%\u0019a*a\u0010\u0002\u000bQ\fwm\u001d\u0011\u00029\r\u0014X-\u0019;f'\u0016\u0004\u0018M]1uK\u001a+Go\u00195fe6+GO]5dgR\u0011\u0011QK\u0001\r[&tg)\u001a;dQJ\u000bG/\u001a\u000b\u0005\u0003\u000f\u000bi\tE\u00029\u0003\u0013K1!a#:\u0005\u0019!u.\u001e2mK\"9\u0011qR\rA\u0002\u0005E\u0015A\u00034fi\u000eDWM]'baB)Q\u000e]A\u0018k\u0006yA-Z1e)\"\u0014X-\u00193D_VtG/\u0001\tsKNL'0\u001a+ie\u0016\fG\rU8pYR!\u0011QKAM\u0011\u0019\tYj\u0007a\u0001'\u00069a.Z<TSj,\u0017AC4fi\u001a+Go\u00195feR!\u0011\u0011UAR!\rAT,\u001e\u0005\b\u0003Kc\u0002\u0019AAT\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[#\u0017AB2p[6|g.\u0003\u0003\u00022\u0006-&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\rO\u0016$h)\u001a;dQ\u0016\u0014\u0018\n\u001a\u000b\u0004'\u0006]\u0006bBAS;\u0001\u0007\u0011qU\u0001\u001c[\u0006\u00148\u000eU1si&$\u0018n\u001c8t\r>\u0014HK];oG\u0006$\u0018n\u001c8\u0015\u0011\u0005U\u0013QXAa\u0003\u0007Da!a0\u001f\u0001\u0004\u0019\u0016\u0001\u00032s_.,'/\u00133\t\u000f\u0005\u0015f\u00041\u0001\u0002(\"9\u0011Q\u0019\u0010A\u0002\u0005\u001d\u0017\u0001\u0005;sk:\u001c\u0017\r^5p]>3gm]3u!\rA\u0014\u0011Z\u0005\u0004\u0003\u0017L$\u0001\u0002'p]\u001e\f1c\u0019:fCR,g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$r!^Ai\u0003+\f)\u000f\u0003\u0004\u0002T~\u0001\raU\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!a6 \u0001\u0004\tI.\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\r\tyNM\u0001\bG2,8\u000f^3s\u0013\u0011\t\u0019/!8\u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\"9\u0011q]\u0010A\u0002\u0005%\u0018a\u00034fi\u000eDWM\u001d)p_2\u00042\u0001WAv\u0013\r\ti\u000f\r\u0002\f\r\u0016$8\r[3s!>|G.A\fbI\u00124U\r^2iKJ4uN\u001d)beRLG/[8ogRA\u0011QKAz\u0003\u007f\u0014\t\u0001C\u0004\u0002v\u0002\u0002\r!a>\u0002'A\f'\u000f^5uS>t\u0017I\u001c3PM\u001a\u001cX\r^:\u0011\r5\u0004\u0018qUA}!\rA\u00161`\u0005\u0004\u0003{\u0004$!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"9\u0011q\u001d\u0011A\u0002\u0005%\b\"\u0003B\u0002AA\u0005\t\u0019\u0001B\u0003\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003\u0003\u001d\u0003\b\u0005\u001dV/!\u0016\n\u0007\t%\u0011HA\u0005Gk:\u001cG/[8oe\u0005\t\u0013\r\u001a3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0002\u0016\u0005\u0005\u000b\u0011\tb\u000b\u0002\u0003\u0014A!!Q\u0003B\u0010\u001b\t\u00119B\u0003\u0003\u0003\u001a\tm\u0011!C;oG\",7m[3e\u0015\r\u0011i\"O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0011\u0005/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003I\tG\r\u001a$bS2,G\rU1si&$\u0018n\u001c8\u0015\t\u0005U#q\u0005\u0005\b\u0003K\u0013\u0003\u0019AAT\u0003q\tG\r\u001a)beRLG/[8ogR{g)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012$b!!\u0016\u0003.\tE\u0002B\u0002B\u0018G\u0001\u0007Q/A\u0007gKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0005g\u0019\u0003\u0019AA|\u0003YIg.\u001b;jC2|eMZ:fi\u0006sG-\u00129pG\"\u001c\u0018\u0001H7bs\n,W*[4sCR,\u0017J\\*z]\u000e\u0004\u0016M\u001d;ji&|gn]\u0001\u0014i>Le.\u001b;jC24U\r^2i'R\fG/\u001a\u000b\u0007\u0003o\u0014YDa\u0010\t\r\tuR\u00051\u0001~\u0003\u001d1W\r^2iKJDqA!\u0011&\u0001\u0004\u0011\u0019%A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t!\u0019i\u0007/a*\u0003FA\u0019\u0001La\u0012\n\u0007\t%\u0003GA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-A\nnCf\u0014W-\u00169eCR,Gk\u001c9jG&#7\u000f\u0006\u0004\u0002V\t=#Q\u000b\u0005\b\u0005#2\u0003\u0019\u0001B*\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p+B$\u0017\r^3\u0011\u000b5\u0004\u0018qU*\t\u000f\t]c\u00051\u0001\u0003Z\u0005AAo\u001c9jG&#7\u000f\u0005\u00049\u00057*%qL\u0005\u0004\u0005;J$!\u0003$v]\u000e$\u0018n\u001c82!\u0011ATL!\u0019\u0011\t\u0005%&1M\u0005\u0005\u0005K\nYK\u0001\u0003Vk&$\u0017A\u0007:f[>4XMR3uG\",'OR8s!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u0002B\"\u0005WBqA!\u001c(\u0001\u0004\u0011y'\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!\u001cB9\u0003OK1Aa\u001do\u0005\r\u0019V\r^\u0001\u001bg\",H\u000fZ8x]&#G.\u001a$fi\u000eDWM\u001d+ie\u0016\fGm]\u0001\u0011G2|7/Z!mY\u001a+Go\u00195feN\fa#\u00112tiJ\f7\r\u001e$fi\u000eDWM]'b]\u0006<WM\u001d\t\u00031.\u001a\"aK\u001c\u0015\u0005\tm\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0003\u0006\n%UC\u0001BDU\ra&\u0011\u0003\u0003\u0006q6\u0012\r!_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\t\t=%1S\u000b\u0003\u0005#S3\u0001\u001cB\t\t\u0015AhF1\u0001z\u0001")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return AbstractFetcherManager$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)fetcherPool -> this.metricsGroup().newGauge("MinFetchRate", (Gauge)new Gauge<Object>(this, fetcherPool){
            private final /* synthetic */ AbstractFetcherManager $outer;
            private final FetcherPool fetcherPool$1;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(this.fetcherPool$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetcherPool$1 = fetcherPool$1;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags().$plus$plus((GenTraversableOnce)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FetcherPool"), (Object)fetcherPool.name())})))).asJava()));
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble((Object)fetcherMap.values().headOption().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$minFetchRate$1(x$4))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)fetcherMap.values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            FetcherPool$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, brokerId, fetcherId, topicPartition, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool, Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach(arg_0 -> AbstractFetcherManager.$anonfun$addFetcherForPartitions$3$adapted(this, fetcherPool, callback, arg_0));
            return;
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> addFetcherForPartitions$default$3() {
        return (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> {
            AbstractFetcherManager.$anonfun$addFetcherForPartitions$default$3$1(x$6, x$7);
            return BoxedUnit.UNIT;
        };
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Added fetcher ").append(fetcherThread.getName()).append(" to broker ").append(fetcherThread.leader().brokerEndPoint().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeMigrateInSyncPartitions() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$2(this, x$9);
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    private Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new InitialFetchState(fetchState.topicId(), fetcher.leader().brokerEndPoint(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset()));
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                int leaderId = x0$1._2$mcI$sp();
                List list = (List)FetcherPool$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)poolType -> new FetcherTag(leaderId, this.getFetcherId(topicPartition), (FetcherPool)poolType), List$.MODULE$.canBuildFrom());
                return list;
            }).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                List brokerAndFetcherId = (List)x0$2._1();
                Map partitionsToUpdate = (Map)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                return tuple2;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                if (x$11 == null) {
                    throw new MatchError(null);
                }
                List $anonfun$maybeUpdateTopicIds$5_fetcherTags = (List)x$11._1();
                Set $anonfun$maybeUpdateTopicIds$5_partitions = (Set)x$11._2();
                $anonfun$maybeUpdateTopicIds$5_fetcherTags.foreach((Function1 & Serializable & scala.Serializable)fetcherTag -> {
                    this.fetcherThreadMap().get(fetcherTag).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                        x$10.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        void var2_2;
        scala.collection.mutable.Map fetchStates = Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return var2_2;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                BoxedUnit boxedUnit;
                if (x$12 != null) {
                    FetcherTag key = (FetcherTag)x$12._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$12._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$5 != null))).foreach((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$13)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$6 != null))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$14);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return scala.math.package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ long $anonfun$new$5(AbstractFetcherThread x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.fetcherLagStats().stats().values().iterator().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lag())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$5(x$1))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$7() {
        return this.minFetchRate((Map<FetcherTag, T>)this.fetcherThreadMap());
    }

    public static final /* synthetic */ double $anonfun$new$9(AbstractFetcherThread x$3) {
        return x$3.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$9(x$3))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$10() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$new$12(AbstractFetcherManager $this, Scheduler s) {
        s.schedule("migrate-in-sync-partitions-thread", () -> $this.maybeMigrateInSyncPartitions(), 0L, 1000L);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        FetcherPool fetcherPool = ((FetcherTag)x0$1._1()).fetcherPool();
        boolean bl = !(fetcherPool != null ? !fetcherPool.equals(fetcherPool$1) : fetcherPool$1 != null);
        return bl;
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(FetcherPool fetcherPool$1) {
        return this.minFetchRate((Map)this.fetcherThreadMap().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))));
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$4) {
        return x$4.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$2(AbstractFetcherThread thread$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id$1, TopicPartition topicPartition, PartitionFetchState currentFetchState) {
        InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread$1.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset());
        ((scala.collection.mutable.Map)allRemovedPartitionsMapByFetcherPool$1.getOrElseUpdate((Object)id$1.fetcherPool(), (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).update((Object)topicPartition, (Object)initialFetchState);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(int newSize$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id, AbstractFetcherThread thread) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, currentFetchState) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$2(thread, allRemovedPartitionsMapByFetcherPool$1, id, topicPartition, currentFetchState);
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitionStates);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void migratePartitions$1(int newSize) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        void forKeyValue$extension_f2;
        void forKeyValue$extension_$this2;
        scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(newSize, allRemovedPartitionsMapByFetcherPool, id, thread);
            return BoxedUnit.UNIT;
        };
        Map<FetcherTag, T> map = Implicits$.MODULE$.MapExtensionMethods(this.fetcherThreadMap());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this2), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f2, arg_0, arg_1));
        Function2 & Serializable & scala.Serializable intersect2 = (Function2 & Serializable & scala.Serializable)(fetcherPool, allRemovedPartitionsMap) -> {
            this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)allRemovedPartitionsMap, fetcherPool, this.addFetcherForPartitions$default$3());
            return BoxedUnit.UNIT;
        };
        Map map2 = Implicits$.MODULE$.MapExtensionMethods(allRemovedPartitionsMapByFetcherPool);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, int brokerId$1, int fetcherId$1, TopicPartition topicPartition$2, long truncationOffset$1, FetcherPool fetcherPool) {
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId$1, fetcherPool);
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable & scala.Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put((Object)fetcherTag, fetcherThread);
        fetcherThread.start();
        return var3_3;
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$4(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply((Object)tp, (Object)fetcherThread$1);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$2, Function2 callback$1, Tuple2 x$8) {
        block6: {
            if (x$8 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$8._1();
            initialFetchOffsets = (Map)x$8._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$2);
            var8_7 = false;
            var9_8 = null;
            var10_9 = $this.fetcherThreadMap().get((Object)fetcherTag);
            if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
            var8_7 = true;
            var9_8 = (Some)var10_9;
            currentFetcherThread = (AbstractFetcherThread)var9_8.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var12_11 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) {
                var4_12 = currentFetcherThread;
            } else if (var8_7) {
                ((AbstractFetcherThread)var9_8.value()).shutdown();
                var4_12 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var10_9)) {
                var4_12 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError((Object)var10_9);
            }
            $this.addPartitionsToFetcherThread(var4_12, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            initialFetchOffsets.keys().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)var4_12));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$default$3$1(TopicPartition x$6, AbstractFetcherThread x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        if (x0$1 == null || (lagMetrics = (FetcherLagMetrics)x0$1._2()) == null) {
            throw new MatchError((Object)x0$1);
        }
        boolean bl = lagMetrics.lag() == 0L;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Tuple2 x$9) {
        block7: {
            block4: {
                AbstractFetcherThread fetcher;
                FetcherTag tag;
                block6: {
                    FetcherPool$Default$ fetcherPool$Default$;
                    FetcherPool fetcherPool;
                    block5: {
                        if (x$9 == null) break block4;
                        tag = (FetcherTag)x$9._1();
                        fetcher = (AbstractFetcherThread)x$9._2();
                        fetcherPool = tag.fetcherPool();
                        fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
                        if (fetcherPool != null) break block5;
                        if (fetcherPool$Default$ != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!fetcherPool.equals(fetcherPool$Default$)) break block7;
                }
                scala.collection.immutable.Set inSyncPartitions = ((TraversableOnce)((TraversableLike)fetcher.fetcherLagStats().stats().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    void var1_1;
                    if (x0$2 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition topicPartition = (TopicPartition)x0$2._1();
                    return var1_1;
                }, Iterable$.MODULE$.canBuildFrom())).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions((Set<TopicPartition>)inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$, $this.addFetcherForPartitions$default$3());
                if (partitionStates.nonEmpty()) {
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Moved ").append(partitionStates.keys()).append(" partitions from ").append(FetcherPool$Default$.MODULE$).append(" to ").append(FetcherPool$InSync$.MODULE$).append(" for ").append(tag).toString());
                    return;
                }
                break block7;
            }
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$7(Set partitions$1, Function1 topicIds$1, AbstractFetcherThread x$10) {
        x$10.maybeUpdateTopicIds((Set<TopicPartition>)partitions$1, (Function1<String, Option<Uuid>>)topicIds$1);
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$6(AbstractFetcherManager $this, Set partitions$1, Function1 topicIds$1, FetcherTag fetcherTag) {
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$11) {
        if (x$11 != null) {
            List fetcherTags = (List)x$11._1();
            Set partitions = (Set)x$11._2();
            fetcherTags.foreach((Function1 & Serializable & scala.Serializable)fetcherTag -> {
                this.fetcherThreadMap().get(fetcherTag).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                    x$10.maybeUpdateTopicIds((Set<TopicPartition>)partitions, topicIds);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$13) {
        if (x$13 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$13._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$14) {
        if (x$14 != null) {
            ((AbstractFetcherThread)x$14._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags) {
        BoxedUnit boxedUnit;
        this.name = name;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = ((MapLike)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).$plus$plus(extraMetricTags);
        this.metricsGroup().newGauge("MaxLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("TotalLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("MinFetchRate", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("TotalFetchRate", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("FailedPartitionsCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$10();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        this.metricsGroup().newGauge("DeadThreadCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (!(fetchConnectionsMode != null ? !fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$) : fetchConnectionsMode$Isolated$ != null)) {
            scheduler.foreach((Function1 & Serializable & scala.Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$12(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$3$adapted(AbstractFetcherManager $this, FetcherPool fetcherPool$2, Function2 callback$1, Tuple2 x$8) {
        if (x$8 == null) ** GOTO lbl25
        $anonfun$addFetcherForPartitions$3_brokerAndFetcherId = (BrokerAndFetcherId)x$8._1();
        $anonfun$addFetcherForPartitions$3_initialFetchOffsets = (Map)x$8._2();
        $anonfun$addFetcherForPartitions$3_fetcherTag = new FetcherTag($anonfun$addFetcherForPartitions$3_brokerAndFetcherId.broker().id(), $anonfun$addFetcherForPartitions$3_brokerAndFetcherId.fetcherId(), fetcherPool$2);
        var8_7 = false;
        var9_8 = null;
        var10_9 = $this.fetcherThreadMap().get((Object)$anonfun$addFetcherForPartitions$3_fetcherTag);
        if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
        var8_7 = true;
        var9_8 = (Some)var10_9;
        $anonfun$addFetcherForPartitions$3_currentFetcherThread = (AbstractFetcherThread)var9_8.value();
        v0 = $anonfun$addFetcherForPartitions$3_currentFetcherThread.leader().brokerEndPoint();
        var12_11 = $anonfun$addFetcherForPartitions$3_brokerAndFetcherId.broker();
        if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) {
            var4_12 = $anonfun$addFetcherForPartitions$3_currentFetcherThread;
        } else if (var8_7) {
            ((AbstractFetcherThread)var9_8.value()).shutdown();
            var4_12 = $this.addAndStartFetcherThread$1($anonfun$addFetcherForPartitions$3_brokerAndFetcherId, $anonfun$addFetcherForPartitions$3_fetcherTag);
        } else if (None$.MODULE$.equals(var10_9)) {
            var4_12 = $this.addAndStartFetcherThread$1($anonfun$addFetcherForPartitions$3_brokerAndFetcherId, $anonfun$addFetcherForPartitions$3_fetcherTag);
        } else {
            throw new MatchError((Object)var10_9);
lbl25:
            // 1 sources

            throw new MatchError(null);
        }
        $this.addPartitionsToFetcherThread(var4_12, (Map<TopicPartition, InitialFetchState>)$anonfun$addFetcherForPartitions$3_initialFetchOffsets);
        $anonfun$addFetcherForPartitions$3_initialFetchOffsets.keys().foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)var4_12));
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$4$adapted(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply((Object)tp, (Object)fetcherThread$1);
        return BoxedUnit.UNIT;
    }
}

