/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import kafka.common.InterBrokerSendThread;
import kafka.common.InterBrokerSendThread$;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.server.KafkaConfig;
import kafka.server.PerNodeQueue;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.KafkaScheduler;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.concurrent.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dd!B\u0014)\u0003\u0003i\u0003\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A1\f\u0001B\u0001B\u0003%A\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003c\u0011\u0015y\u0007\u0001\"\u0001q\u0011%\tI\u0001\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0007\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0003\u0003\u0005\u00028\u0001\u0001\u000b\u0011BA\u0019\u0011-\tI\u0004\u0001a\u0001\u0002\u0004%\t!a\u000f\t\u0017\u00055\u0003\u00011AA\u0002\u0013\u0005\u0011q\n\u0005\f\u00037\u0002\u0001\u0019!A!B\u0013\ti\u0004C\u0005\u0002f\u0001\u0001\r\u0011\"\u0001\u0002h!I\u0011q\u000e\u0001A\u0002\u0013\u0005\u0011\u0011\u000f\u0005\t\u0003k\u0002\u0001\u0015)\u0003\u0002j!I\u0011\u0011\u0010\u0001C\u0002\u0013\u0005\u00111\u0010\u0005\b\u0003{\u0002\u0001\u0015!\u0003c\u0011%\ty\b\u0001b\u0001\n\u0003\tY\bC\u0004\u0002\u0002\u0002\u0001\u000b\u0011\u00022\t\u0013\u0005\r\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAG\u0001\u0001\u0006I!a\"\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAI\u0001\u0001\u0006I!a\"\t\u0013\u0005M\u0005A1A\u0005\u0002\u0005\u0015\u0005\u0002CAK\u0001\u0001\u0006I!a\"\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!7\u0001\t\u0003\t\t\u000fC\u0004\u0002p\u0002!I!!=\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016!9!1\u0004\u0001\u0007\u0002\tu\u0001b\u0002B$\u0001\u0019\u0005!\u0011\n\u0005\n\u0005\u001f\u0002\u0011\u0013!C\u0001\u0005#\u0012Q#\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e+ie\u0016\fGM\u0003\u0002*U\u000511/\u001a:wKJT\u0011aK\u0001\u0006W\u000647.Y\u0002\u0001+\tqCoE\u0002\u0001_U\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0016\u0002\r\r|W.\\8o\u0013\t!\u0014GA\u000bJ]R,'O\u0011:pW\u0016\u00148+\u001a8e)\"\u0014X-\u00193\u0011\u0005YJT\"A\u001c\u000b\u0005aR\u0013!B;uS2\u001c\u0018B\u0001\u001e8\u0005\u001daunZ4j]\u001e\faaY8oM&<\u0007CA\u001f?\u001b\u0005A\u0013BA )\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u000f5,GO]5dgB\u0011!IS\u0007\u0002\u0007*\u0011\u0001\t\u0012\u0006\u0003e\u0015S!a\u000b$\u000b\u0005\u001dC\u0015AB1qC\u000eDWMC\u0001J\u0003\ry'oZ\u0005\u0003\u0017\u000e\u0013q!T3ue&\u001c7/\u0001\b`]\u0016$xo\u001c:l\u00072LWM\u001c;\u0011\u00059\u000bV\"A(\u000b\u0005A+\u0015aB2mS\u0016tGo]\u0005\u0003%>\u0013QBT3uo>\u00148n\u00117jK:$\u0018AD6bM.\f7k\u00195fIVdWM\u001d\t\u0003+fk\u0011A\u0016\u0006\u0003/b\u000bA!\u001e;jY*\u0011\u0011&R\u0005\u00035Z\u0013abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0003uS6,\u0007CA/`\u001b\u0005q&B\u0001\u001dE\u0013\t\u0001gL\u0001\u0003US6,\u0017a\u0003:fcV,7\u000f\u001e(b[\u0016\u0004\"a\u00197\u000f\u0005\u0011T\u0007CA3i\u001b\u00051'BA4-\u0003\u0019a$o\\8u})\t\u0011.A\u0003tG\u0006d\u0017-\u0003\u0002lQ\u00061\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY\u0007.\u0001\u0004=S:LGO\u0010\u000b\fcz|\u0018\u0011AA\u0002\u0003\u000b\t9\u0001E\u0002>\u0001I\u0004\"a\u001d;\r\u0001\u0011)Q\u000f\u0001b\u0001m\n\tA+\u0005\u0002xwB\u0011\u00010_\u0007\u0002Q&\u0011!\u0010\u001b\u0002\b\u001d>$\b.\u001b8h!\tAH0\u0003\u0002~Q\n\u0019\u0011I\\=\t\u000bm:\u0001\u0019\u0001\u001f\t\u000b\u0001;\u0001\u0019A!\t\u000b1;\u0001\u0019A'\t\u000bM;\u0001\u0019\u0001+\t\u000bm;\u0001\u0019\u0001/\t\u000b\u0005<\u0001\u0019\u00012\u0002\u0019E,X-^3QKJtu\u000eZ3\u0016\u0005\u00055\u0001\u0003CA\b\u00033\ti\"!\n\u000e\u0005\u0005E!\u0002BA\n\u0003+\t!bY8oGV\u0014(/\u001a8u\u0015\r\t9\u0002[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000e\u0003#\u00111!T1q!\u0011\ty\"!\t\u000e\u0003\u0011K1!a\tE\u0005\u0011qu\u000eZ3\u0011\tu\n9C]\u0005\u0004\u0003SA#\u0001\u0004)fe:{G-Z)vKV,\u0017!D9vKV,\u0007+\u001a:O_\u0012,\u0007%\u0001\tsKF,Xm\u001d;US6,w.\u001e;NgV\u0011\u0011\u0011\u0007\t\u0004q\u0006M\u0012bAA\u001bQ\n\u0019\u0011J\u001c;\u0002#I,\u0017/^3tiRKW.Z8vi6\u001b\b%\u0001\trk>$\u0018mQ8pe\u0012Lg.\u0019;peV\u0011\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003\u0015\tXo\u001c;b\u0015\r\t9EK\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0003\u0002L\u0005\u0005#\u0001E)v_R\f7i\\8sI&t\u0017\r^8s\u0003Q\tXo\u001c;b\u0007>|'\u000fZ5oCR|'o\u0018\u0013fcR!\u0011\u0011KA,!\rA\u00181K\u0005\u0004\u0003+B'\u0001B+oSRD\u0011\"!\u0017\u000e\u0003\u0003\u0005\r!!\u0010\u0002\u0007a$\u0013'A\trk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u0002B3ADA0!\rA\u0018\u0011M\u0005\u0004\u0003GB'\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u000fM$\u0018M\u001d;fIV\u0011\u0011\u0011\u000e\t\u0004q\u0006-\u0014bAA7Q\n9!i\\8mK\u0006t\u0017aC:uCJ$X\rZ0%KF$B!!\u0015\u0002t!I\u0011\u0011\f\t\u0002\u0002\u0003\u0007\u0011\u0011N\u0001\tgR\f'\u000f^3eA!\u001a\u0011#a\u0018\u0002%I,\u0017/^3ti:\u000bW.\u001a(p'B\f7-Z\u000b\u0002E\u0006\u0019\"/Z9vKN$h*Y7f\u001d>\u001c\u0006/Y2fA\u0005aQ.\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0011C\\8eK2{wn[;q\r\u0006LG.\u001e:f+\t\t9\tE\u0002C\u0003\u0013K1!a#D\u0005\u0019\u0019VM\\:pe\u0006\u0011bn\u001c3f\u0019>|7.\u001e9GC&dWO]3!\u0003)\u0011\bo\u0019$bS2,(/Z\u0001\feB\u001cg)Y5mkJ,\u0007%\u0001\u0005sa\u000e\u0014V\r\u001e:z\u0003%\u0011\bo\u0019*fiJL\b%A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002R\u0005m\u0005bBA$9\u0001\u0007\u0011QH\u0001\tg\",H\u000fZ8x]R\u0011\u0011\u0011K\u0001\tg\u000eDW\rZ;mKRA\u0011\u0011KAS\u0003S\u000b\u0019\f\u0003\u0004\u0002(z\u0001\rAY\u0001\u0005]\u0006lW\rC\u0004\u0002,z\u0001\r!!,\u0002\u0007\u0019,h\u000eE\u0003y\u0003_\u000b\t&C\u0002\u00022\"\u0014\u0011BR;oGRLwN\u001c\u0019\t\u000f\u0005Uf\u00041\u0001\u00028\u0006A\u0001/\u001a:j_\u0012l5\u000fE\u0002y\u0003sK1!a/i\u0005\u0011auN\\4\u0002!\u001d,g.\u001a:bi\u0016\u0014V-];fgR\u001cHCAAa!\u0019\t\u0019-!4\u0002T:!\u0011QYAe\u001d\r)\u0017qY\u0005\u0002S&\u0019\u00111\u001a5\u0002\u000fA\f7m[1hK&!\u0011qZAi\u0005!IE/\u001a:bE2,'bAAfQB\u0019\u0001'!6\n\u0007\u0005]\u0017GA\u000eSKF,Xm\u001d;B]\u0012\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM]\u0001\u0010C\u0012$WI\u001c;ss\u001a{'OT8eKR!\u0011\u0011KAo\u0011\u0019\ty\u000e\ta\u0001e\u0006)QM\u001c;ssR1\u0011\u0011KAr\u0003KDa!a8\"\u0001\u0004\u0011\bbBAtC\u0001\u0007\u0011\u0011^\u0001\u0005]>$W\rE\u0003y\u0003W\fi\"C\u0002\u0002n\"\u0014aa\u00149uS>t\u0017A\u00045b]\u0012dWMU3ta>t7/\u001a\u000b\u0007\u0003g\fyP!\u0001\u0015\t\u0005E\u0013Q\u001f\u0005\b\u0003o\u0014\u0003\u0019AA}\u0003!\u0011Xm\u001d9p]N,\u0007c\u0001(\u0002|&\u0019\u0011Q`(\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\"9\u0011q\t\u0012A\u0002\u0005u\u0001b\u0002B\u0002E\u0001\u0007!QA\u0001\bK:$(/[3t!\u0015\u00119Aa\u0004s\u001b\t\u0011IAC\u0002X\u0005\u0017Q!A!\u0004\u0002\t)\fg/Y\u0005\u0005\u0005#\u0011IAA\u0005BeJ\f\u0017\u0010T5ti\u0006i!/\u001a;ss\u001a{'/\u00128uef$b!!\u0015\u0003\u0018\te\u0001b\u0002B\u0002G\u0001\u0007!Q\u0001\u0005\b\u0003O\u001c\u0003\u0019AAu\u00035\u0019'/Z1uKJ+\u0017/^3tiR1!q\u0004B\"\u0005\u000b\u0002DA!\t\u00038A1!1\u0005B\u0018\u0005kqAA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S!\u0015\u0001\u0003:fcV,7\u000f^:\n\t\t5\"qE\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!!\u0011\u0007B\u001a\u0005\u001d\u0011U/\u001b7eKJTAA!\f\u0003(A\u00191Oa\u000e\u0005\u0017\teB%!A\u0001\u0002\u000b\u0005!1\b\u0002\u0004?\u0012\n\u0014cA<\u0003>A!!Q\u0005B \u0013\u0011\u0011\tEa\n\u0003\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRDq!a:%\u0001\u0004\ti\u0002C\u0004\u0003\u0004\u0011\u0002\rA!\u0002\u0002\u000f\u001d,GOT8eKR1\u0011\u0011\u001eB&\u0005\u001bBa!a8&\u0001\u0004\u0011\b\"CAtKA\u0005\t\u0019AAu\u0003E9W\r\u001e(pI\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0005'RC!!;\u0003V-\u0012!q\u000b\t\u0005\u00053\u0012\u0019'\u0004\u0002\u0003\\)!!Q\fB0\u0003%)hn\u00195fG.,GMC\u0002\u0003b!\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ga\u0017\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class AbstractRequestThread<T>
extends InterBrokerSendThread {
    private final Metrics metrics;
    private final KafkaScheduler kafkaScheduler;
    private final Time time;
    private final String requestName;
    private final Map<Node, PerNodeQueue<T>> queuePerNode;
    private final int requestTimeoutMs;
    private volatile QuotaCoordinator quotaCoordinator;
    private volatile boolean started;
    private final String requestNameNoSpace;
    private final String metricsGroup;
    private final Sensor nodeLookupFailure;
    private final Sensor rpcFailure;
    private final Sensor rpcRetry;

    public Map<Node, PerNodeQueue<T>> queuePerNode() {
        return this.queuePerNode;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public QuotaCoordinator quotaCoordinator() {
        return this.quotaCoordinator;
    }

    public void quotaCoordinator_$eq(QuotaCoordinator x$1) {
        this.quotaCoordinator = x$1;
    }

    public boolean started() {
        return this.started;
    }

    public void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    public String requestNameNoSpace() {
        return this.requestNameNoSpace;
    }

    public String metricsGroup() {
        return this.metricsGroup;
    }

    public Sensor nodeLookupFailure() {
        return this.nodeLookupFailure;
    }

    public Sensor rpcFailure() {
        return this.rpcFailure;
    }

    public Sensor rpcRetry() {
        return this.rpcRetry;
    }

    public void start(QuotaCoordinator coordinator) {
        super.start();
        this.quotaCoordinator_$eq(coordinator);
        this.started_$eq(true);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.queuePerNode().clear();
        this.metrics.removeSensor(this.nodeLookupFailure().name());
        this.metrics.removeSensor(this.rpcFailure().name());
        this.metrics.removeSensor(this.rpcRetry().name());
        this.quotaCoordinator_$eq(null);
        this.started_$eq(false);
    }

    public void schedule(String name, Function0<BoxedUnit> fun, long periodMs) {
        this.kafkaScheduler.schedule(name, () -> fun.apply$mcV$sp(), 0L, periodMs);
    }

    @Override
    public Iterable<RequestAndCompletionHandler> generateRequests() {
        long currentTimeMs = this.time.milliseconds();
        return (Iterable)((TraversableLike)((TraversableLike)this.queuePerNode().values().map((Function1 & Serializable & scala.Serializable)queue -> {
            ArrayList entryData = new ArrayList();
            queue.queue().drainTo(entryData);
            return new Tuple2((Object)queue.destination(), entryData);
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractRequestThread.$anonfun$generateRequests$2(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Node node = (Node)x0$2._1();
            ArrayList entries = (ArrayList)x0$2._2();
            RequestAndCompletionHandler requestAndCompletionHandler = new RequestAndCompletionHandler(currentTimeMs, node, this.createRequest(node, entries), response -> this.handleResponse(node, entries, response));
            return requestAndCompletionHandler;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public void addEntryForNode(T entry) {
        this.addEntryForNode(entry, (Option<Node>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    public void addEntryForNode(T entry, Option<Node> node) {
        if (this.started()) {
            Option<Node> option = this.getNode(entry, node);
            if (option instanceof Some) {
                Object object;
                void atomicGetOrUpdate_map;
                Node node2 = (Node)((Some)option).value();
                Map<Node, PerNodeQueue<T>> map = this.queuePerNode();
                if (CoreUtils$.MODULE$ == null) {
                    throw null;
                }
                Option option2 = atomicGetOrUpdate_map.get((Object)node2);
                if (option2 instanceof Some) {
                    object = ((Some)option2).value();
                } else if (None$.MODULE$.equals(option2)) {
                    PerNodeQueue atomicGetOrUpdate_value = AbstractRequestThread.$anonfun$addEntryForNode$1(node2);
                    object = atomicGetOrUpdate_map.putIfAbsent((Object)node2, (Object)atomicGetOrUpdate_value).getOrElse(() -> CoreUtils$.$anonfun$atomicGetOrUpdate$1(atomicGetOrUpdate_value));
                } else {
                    throw new MatchError((Object)option2);
                }
                ((PerNodeQueue)object).addEntry(entry);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append($this.requestName).append(" Request's destination node is unavailable, skipping ").append($this.requestName).append(" for entry ").append(entry).append(".").toString());
                this.nodeLookupFailure().record();
                return;
            }
            throw new MatchError(option);
        }
    }

    private void handleResponse(Node coordinator, ArrayList<T> entries, ClientResponse response) {
        if (response.authenticationException() != null) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append($this.requestName).append(" Request ").append(entries).append(" failed due to authentication error with coordinator").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> response.authenticationException());
            this.rpcFailure().record();
            return;
        }
        if (response.wasDisconnected()) {
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        if (response.responseBody().errorCounts().containsKey(Errors.NOT_COORDINATOR)) {
            this.networkClient().disconnect(coordinator.idString());
            this.retryForEntry(entries, (Option<Node>)new Some((Object)coordinator));
            return;
        }
        BooleanRef rpcFailed = BooleanRef.create((boolean)false);
        response.responseBody().errorCounts().keySet().forEach(error -> {
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                rpcFailed$1.elem = true;
            }
        });
        if (rpcFailed.elem) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append($this.requestName).append(" Request failed with Response ").append(response).toString());
            this.rpcFailure().record();
        }
    }

    private void retryForEntry(ArrayList<T> entries, Option<Node> node) {
        entries.forEach(entry -> this.addEntryForNode(entry, node));
        this.rpcRetry().record();
    }

    public abstract AbstractRequest.Builder<? extends AbstractRequest> createRequest(Node var1, ArrayList<T> var2);

    public abstract Option<Node> getNode(T var1, Option<Node> var2);

    public Option<Node> getNode$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$generateRequests$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Node node = (Node)x0$1._1();
        boolean bl = !((ArrayList)x0$1._2()).isEmpty() && !node.isEmpty();
        return bl;
    }

    public static final /* synthetic */ PerNodeQueue $anonfun$addEntryForNode$1(Node node$2) {
        return new PerNodeQueue(node$2);
    }

    public AbstractRequestThread(KafkaConfig config, Metrics metrics, NetworkClient _networkClient, KafkaScheduler kafkaScheduler, Time time, String requestName) {
        this.metrics = metrics;
        this.kafkaScheduler = kafkaScheduler;
        this.time = time;
        this.requestName = requestName;
        super(new StringBuilder(25).append("DynamicQuotaSenderThread-").append(config.brokerId()).toString(), (KafkaClient)_networkClient, Predef$.MODULE$.Integer2int(config.requestTimeoutMs()), time, InterBrokerSendThread$.MODULE$.$lessinit$greater$default$5());
        this.logIdent_$eq(new StringBuilder(34).append("[Dynamic Quota Channel Manager ").append(config.brokerId()).append("]: ").toString());
        this.queuePerNode = (Map)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.requestTimeoutMs = 30000;
        this.started = false;
        this.requestNameNoSpace = requestName.replace(" ", "-");
        this.metricsGroup = new StringBuilder(8).append(this.requestNameNoSpace().toLowerCase()).append("-metrics").toString();
        this.nodeLookupFailure = metrics.sensor(new StringBuilder(17).append(this.requestNameNoSpace()).append("NodeLookupFailure").toString());
        this.nodeLookupFailure().add(metrics.metricName("node-lookup-failure", this.metricsGroup(), "The rate of node lookup failure"), (MeasurableStat)new Rate());
        this.rpcFailure = metrics.sensor(new StringBuilder(10).append(this.requestNameNoSpace()).append("RPCFailure").toString());
        this.rpcFailure().add(metrics.metricName("rpc-failure", this.metricsGroup(), new StringBuilder(24).append("The rate of ").append(requestName).append(" RPC failure").toString()), (MeasurableStat)new Rate());
        this.rpcRetry = metrics.sensor(new StringBuilder(8).append(this.requestNameNoSpace()).append("RPCRetry").toString());
        this.rpcRetry().add(metrics.metricName("rpc-retry", this.metricsGroup(), new StringBuilder(22).append("The rate of ").append(requestName).append(" RPC retry").toString()), (MeasurableStat)new Rate());
    }
}

