/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001\u0002\f\u0018\u0001qA\u0001b\t\u0001\u0003\u0006\u0004%I\u0001\n\u0005\tc\u0001\u0011\t\u0011)A\u0005K!A!\u0007\u0001BC\u0002\u0013%1\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00035\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000f!\u0003!\u0019!C\u0005\u0013\"1!\r\u0001Q\u0001\n)Cqa\u0019\u0001A\u0002\u0013%A\bC\u0004e\u0001\u0001\u0007I\u0011B3\t\r-\u0004\u0001\u0015)\u0003>\u0011\u001da\u0007A1A\u0005\n5Da!\u001d\u0001!\u0002\u0013q\u0007\"\u0002:\u0001\t\u0003\u0019\b\"\u0002:\u0001\t\u0003A\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\u0005\u0001\t\u0003\t)\u0003C\u0004\u0002*\u0001!I!a\u000b\u0003)\u0005\u001bG/\u001b<f)\u0016t\u0017M\u001c;t\u001b\u0006t\u0017mZ3s\u0015\tA\u0012$\u0001\u0004tKJ4XM\u001d\u0006\u00025\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00069Q.\u001a;sS\u000e\u001cX#A\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005\rB#BA\u0015+\u0003\u0019\u0019w.\\7p]*\u0011!d\u000b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021O\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\tQLW.Z\u000b\u0002iA\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007K\u0001\u0006kRLGn]\u0005\u0003sY\u0012A\u0001V5nK\u0006)A/[7fA\u0005\u0011\u0012m\u0019;jm\u0016$\u0016.\\3XS:$wn^'t+\u0005i\u0004C\u0001\u0010?\u0013\tytD\u0001\u0003M_:<\u0017aE1di&4X\rV5nK^Kg\u000eZ8x\u001bN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003D\u000b\u001a;\u0005C\u0001#\u0001\u001b\u00059\u0002\"B\u0012\b\u0001\u0004)\u0003\"\u0002\u001a\b\u0001\u0004!\u0004\"B\u001e\b\u0001\u0004i\u0014\u0001D1di&4XmV5oI><X#\u0001&\u0011\t-\u0013F+P\u0007\u0002\u0019*\u0011QJT\u0001\u000bG>t7-\u001e:sK:$(BA(Q\u0003\u0011)H/\u001b7\u000b\u0003E\u000bAA[1wC&\u00111\u000b\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003B+]?~s!A\u0016.\u0011\u0005]{R\"\u0001-\u000b\u0005e[\u0012A\u0002\u001fs_>$h(\u0003\u0002\\?\u00051\u0001K]3eK\u001aL!!\u00180\u0003\u00075\u000b\u0007O\u0003\u0002\\?A\u0011Q\u000bY\u0005\u0003Cz\u0013aa\u0015;sS:<\u0017!D1di&4XmV5oI><\b%\u0001\tmCN$(+Z2pe\u0012$\u0016.\\3Ng\u0006!B.Y:u%\u0016\u001cwN\u001d3US6,Wj]0%KF$\"AZ5\u0011\u0005y9\u0017B\u00015 \u0005\u0011)f.\u001b;\t\u000f)\\\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010J\u0019\u0002#1\f7\u000f\u001e*fG>\u0014H\rV5nK6\u001b\b%A\nbGRLg/\u001a+f]\u0006tGo]*f]N|'/F\u0001o!\t1s.\u0003\u0002qO\t11+\u001a8t_J\fA#Y2uSZ,G+\u001a8b]R\u001c8+\u001a8t_J\u0004\u0013!\u0005;sC\u000e\\\u0017i\u0019;jm\u0016$VM\\1oiR\u0019a\r\u001e<\t\u000bU|\u0001\u0019\u0001+\u0002\u00155,GO]5d)\u0006<7\u000fC\u0003x\u001f\u0001\u0007Q(\u0001\u0004uS6,Wj\u001d\u000b\u0005MfT8\u0010C\u0003v!\u0001\u0007A\u000bC\u0003x!\u0001\u0007Q\bC\u0003}!\u0001\u0007Q0\u0001\nsKN,G/U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u0002\u0010\u007f)\u001aL!a`\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0014aG7bs\n,'+Z2pe\u0012tU/\\!di&4X\rV3oC:$8\u000fF\u0003g\u0003\u000b\t9\u0001C\u0003x#\u0001\u0007Q\bC\u0003}#\u0001\u0007Q0\u0001\fsK\u000e|'\u000f\u001a(v[\u0006\u001bG/\u001b<f)\u0016t\u0017M\u001c;t)\u00151\u0017QBA\b\u0011\u00159(\u00031\u0001>\u0011\u0015a(\u00031\u0001~\u0003A9W\r^!di&4X\rV3oC:$8\u000f\u0006\u0002\u0002\u0016A)\u0011qCA\u0011)6\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"A\u0004nkR\f'\r\\3\u000b\u0007\u0005}q$\u0001\u0006d_2dWm\u0019;j_:LA!a\t\u0002\u001a\t\u00191+Z9\u0015\t\u0005U\u0011q\u0005\u0005\u0006yR\u0001\r!`\u0001\u0015aJ,h.Z%oC\u000e$\u0018N^3UK:\fg\u000e^:\u0015\u000b\u0019\fi#a\f\t\u000b],\u0002\u0019A\u001f\t\u000bq,\u0002\u0019A?")
public class ActiveTenantsManager {
    private final Metrics metrics;
    private final Time time;
    private final long activeTimeWindowMs;
    private final ConcurrentHashMap<Map<String, String>, Object> activeWindow;
    private long lastRecordTimeMs;
    private final Sensor activeTenantsSensor;

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long activeTimeWindowMs() {
        return this.activeTimeWindowMs;
    }

    private ConcurrentHashMap<Map<String, String>, Object> activeWindow() {
        return this.activeWindow;
    }

    private long lastRecordTimeMs() {
        return this.lastRecordTimeMs;
    }

    private void lastRecordTimeMs_$eq(long x$1) {
        this.lastRecordTimeMs = x$1;
    }

    private Sensor activeTenantsSensor() {
        return this.activeTenantsSensor;
    }

    public void trackActiveTenant(Map<String, String> metricTags, long timeMs) {
        this.trackActiveTenant(metricTags, timeMs, (Function1<Map<String, String>, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$1 -> {
            ActiveTenantsManager.$anonfun$trackActiveTenant$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void trackActiveTenant(Map<String, String> metricTags, long timeMs, Function1<Map<String, String>, BoxedUnit> resetQuotaCallback) {
        this.activeWindow().put(metricTags, BoxesRunTime.boxToLong((long)timeMs));
        if (this.lastRecordTimeMs() + this.activeTimeWindowMs() < timeMs) {
            this.activeWindow().forEach((tenantTags, timestamp) -> {
                long $anonfun$pruneInactiveTenants$1_timestamp = BoxesRunTime.unboxToLong((Object)timestamp);
                if ($anonfun$pruneInactiveTenants$1_timestamp + this.activeTimeWindowMs() < timeMs) {
                    resetQuotaCallback.apply(tenantTags);
                    this.activeWindow().remove(tenantTags, BoxesRunTime.boxToLong((long)$anonfun$pruneInactiveTenants$1_timestamp));
                    return;
                }
            });
            this.activeTenantsSensor().record((double)this.activeWindow().size(), timeMs);
            this.lastRecordTimeMs_$eq(timeMs);
            return;
        }
    }

    private void maybeRecordNumActiveTenants(long timeMs, Function1<Map<String, String>, BoxedUnit> resetQuotaCallback) {
        if (this.lastRecordTimeMs() + this.activeTimeWindowMs() < timeMs) {
            this.activeWindow().forEach((tenantTags, timestamp) -> {
                long $anonfun$pruneInactiveTenants$1_timestamp = BoxesRunTime.unboxToLong((Object)timestamp);
                if ($anonfun$pruneInactiveTenants$1_timestamp + this.activeTimeWindowMs() < timeMs) {
                    resetQuotaCallback.apply(tenantTags);
                    this.activeWindow().remove(tenantTags, BoxesRunTime.boxToLong((long)$anonfun$pruneInactiveTenants$1_timestamp));
                    return;
                }
            });
            this.activeTenantsSensor().record((double)this.activeWindow().size(), timeMs);
            this.lastRecordTimeMs_$eq(timeMs);
        }
    }

    private void recordNumActiveTenants(long timeMs, Function1<Map<String, String>, BoxedUnit> resetQuotaCallback) {
        this.activeWindow().forEach((tenantTags, timestamp) -> {
            long $anonfun$pruneInactiveTenants$1_timestamp = BoxesRunTime.unboxToLong((Object)timestamp);
            if ($anonfun$pruneInactiveTenants$1_timestamp + this.activeTimeWindowMs() < timeMs) {
                resetQuotaCallback.apply(tenantTags);
                this.activeWindow().remove(tenantTags, BoxesRunTime.boxToLong((long)$anonfun$pruneInactiveTenants$1_timestamp));
                return;
            }
        });
        this.activeTenantsSensor().record((double)this.activeWindow().size(), timeMs);
    }

    public Seq<Map<String, String>> getActiveTenants() {
        return this.getActiveTenants((Function1<Map<String, String>, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)x$2 -> {
            ActiveTenantsManager.$anonfun$getActiveTenants$1(x$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Map<String, String>> getActiveTenants(Function1<Map<String, String>, BoxedUnit> resetQuotaCallback) {
        void var2_3;
        long pruneInactiveTenants_timeMs = this.time().milliseconds();
        this.activeWindow().forEach((tenantTags, timestamp) -> {
            long $anonfun$pruneInactiveTenants$1_timestamp = BoxesRunTime.unboxToLong((Object)timestamp);
            if ($anonfun$pruneInactiveTenants$1_timestamp + this.activeTimeWindowMs() < timeMs) {
                resetQuotaCallback.apply(tenantTags);
                this.activeWindow().remove(tenantTags, BoxesRunTime.boxToLong((long)$anonfun$pruneInactiveTenants$1_timestamp));
                return;
            }
        });
        ArrayBuffer tenants = new ArrayBuffer(this.activeWindow().size());
        this.activeWindow().forEach((tenantTags, x$3) -> tenants.$plus$eq((Object)tenantTags));
        return var2_3;
    }

    private void pruneInactiveTenants(long timeMs, Function1<Map<String, String>, BoxedUnit> resetQuotaCallback) {
        this.activeWindow().forEach((tenantTags, timestamp) -> {
            long $anonfun$pruneInactiveTenants$1_timestamp = BoxesRunTime.unboxToLong((Object)timestamp);
            if ($anonfun$pruneInactiveTenants$1_timestamp + this.activeTimeWindowMs() < timeMs) {
                resetQuotaCallback.apply(tenantTags);
                this.activeWindow().remove(tenantTags, BoxesRunTime.boxToLong((long)$anonfun$pruneInactiveTenants$1_timestamp));
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$trackActiveTenant$1(Map x$1) {
    }

    public static final /* synthetic */ void $anonfun$getActiveTenants$1(Map x$2) {
    }

    public static final /* synthetic */ void $anonfun$pruneInactiveTenants$1(ActiveTenantsManager $this, long timeMs$1, Function1 resetQuotaCallback$1, Map tenantTags, long timestamp) {
        if (timestamp + $this.activeTimeWindowMs() < timeMs$1) {
            resetQuotaCallback$1.apply((Object)tenantTags);
            $this.activeWindow().remove(tenantTags, BoxesRunTime.boxToLong((long)timestamp));
        }
    }

    public ActiveTenantsManager(Metrics metrics, Time time, long activeTimeWindowMs) {
        this.metrics = metrics;
        this.time = time;
        this.activeTimeWindowMs = activeTimeWindowMs;
        this.activeWindow = new ConcurrentHashMap();
        this.lastRecordTimeMs = time.milliseconds();
        this.activeTenantsSensor = metrics.sensor("ActiveTenants");
        this.activeTenantsSensor().add(metrics.metricName("active-tenants-count", "multi-tenant-metrics", new StringBuilder(43).append("The number of active tenants over a ").append(activeTimeWindowMs).append(" window").toString()), (MeasurableStat)new Value());
    }
}

