/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.CheckReadyControllerStatus;
import kafka.server.ControllerStatusHandleAdapter$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0004\b\u0001'!A!\u0006\u0001BC\u0002\u0013\u00051\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u0003-\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011}\u0002!Q1A\u0005\u0002\u0001C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006\u001d\u0002!\t\u0001\u0016\u0005\b/\u0002\u0011\r\u0011\"\u0001A\u0011\u0019A\u0006\u0001)A\u0005\u0003\")\u0011\f\u0001C!5\")a\f\u0001C!?\n\t3\t[3dWJ+\u0017\rZ=D_:$(o\u001c7mKJD\u0015M\u001c3mK\u0006#\u0017\r\u001d;fe*\u0011q\u0002E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001)i\u0001\u0003CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e!\u0005)Q\u000f^5mg&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h!\t\t\u0003&D\u0001#\u0015\t\u0019C%\u0001\u0003sKN$(BA\u0013'\u0003%\u0019wN\u001c4mk\u0016tGOC\u0001(\u0003\tIw.\u0003\u0002*E\tQ2\t[3dWJ+\u0017\rZ=D_:$(o\u001c7mKJD\u0015M\u001c3mK\u0006\u0001\"m\\8ugR\u0014\u0018\r]*feZ,'o]\u000b\u0002YA\u0011Q\u0006\u000e\b\u0003]I\u0002\"a\f\f\u000e\u0003AR!!\r\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0019d#\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u0017\u0003E\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000fI\u0001\u0007G>tg-[4\u0016\u0003i\u0002\"a\u000f\u001f\u000e\u00039I!!\u0010\b\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u0015\tG-\\5o+\u0005\t\u0005C\u0001\"L\u001b\u0005\u0019%BA E\u0015\t)e)A\u0004dY&,g\u000e^:\u000b\u0005E9%B\u0001%J\u0003\u0019\t\u0007/Y2iK*\t!*A\u0002pe\u001eL!\u0001T\"\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u00061\u0011\rZ7j]\u0002\na\u0001P5oSRtD\u0003\u0002)R%N\u0003\"a\u000f\u0001\t\u000b):\u0001\u0019\u0001\u0017\t\u000ba:\u0001\u0019\u0001\u001e\t\u000b}:\u0001\u0019A!\u0015\u0007A+f\u000bC\u0003+\u0011\u0001\u0007A\u0006C\u00039\u0011\u0001\u0007!(A\u0007j]R,'O\\1m\u0003\u0012l\u0017N\\\u0001\u000fS:$XM\u001d8bY\u0006#W.\u001b8!\u0003]9WM\\3sCR,'+Z1eS:,7o]*uCR,8\u000fF\u0001\\!\t\tC,\u0003\u0002^E\tQ2\t[3dWJ+\u0017\rZ=D_:$(o\u001c7mKJ\u001cF/\u0019;vg\u0006)1\r\\8tKR\t\u0001\r\u0005\u0002\u0016C&\u0011!M\u0006\u0002\u0005+:LG\u000f")
public class CheckReadyControllerHandleAdapter
implements Logging,
CheckReadyControllerHandle {
    private final String bootstrapServers;
    private final KafkaConfig config;
    private final ConfluentAdmin admin;
    private final ConfluentAdmin internalAdmin;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public ConfluentAdmin admin() {
        return this.admin;
    }

    public ConfluentAdmin internalAdmin() {
        return this.internalAdmin;
    }

    public CheckReadyControllerStatus generateReadinessStatus() {
        CheckReadyControllerStatus checkReadyControllerStatus;
        Option<String> option = ControllerStatusHandleAdapter$.MODULE$.checkReady(this.internalAdmin(), Predef$.MODULE$.Integer2int(this.config().requestTimeoutMs()), this, this.config().nodeId());
        if (option instanceof Some) {
            String reason = (String)((Some)option).value();
            checkReadyControllerStatus = new CheckReadyControllerStatus(false, reason);
        } else {
            checkReadyControllerStatus = new CheckReadyControllerStatus(true, "");
        }
        return checkReadyControllerStatus;
    }

    public void close() {
        this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> "Shutting down");
        this.internalAdmin().close();
    }

    public CheckReadyControllerHandleAdapter(String bootstrapServers, KafkaConfig config, ConfluentAdmin admin) {
        this.bootstrapServers = bootstrapServers;
        this.config = config;
        this.admin = admin;
        Logging.$init$(this);
        this.internalAdmin = admin != null ? admin : ControllerStatusHandleAdapter$.MODULE$.createAdmin(bootstrapServers, "kraft-controller-local-readiness-admin", config);
    }

    public CheckReadyControllerHandleAdapter(String bootstrapServers, KafkaConfig config) {
        this(bootstrapServers, config, null);
    }
}

