/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeConfigsRequestData;
import org.apache.kafka.common.message.DescribeConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001\u0002\u000b\u0016\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u000bQ\u0003A\u0011A+\t\u000bq\u0003A\u0011A/\t\u000be\u0004A\u0011\u0001>\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003{\u0004A\u0011BA\u0000\u0011\u001d\u0011y\u0001\u0001C\u0005\u0005#AqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u00038\u0001!IA!\u000f\t\u000f\tu\u0002\u0001\"\u0003\u0003@!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B8\u0001\u0011%!\u0011\u000f\u0002\r\u0007>tg-[4IK2\u0004XM\u001d\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011S%D\u0001$\u0015\t!s#A\u0003vi&d7/\u0003\u0002'G\t9Aj\\4hS:<\u0017!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002*U5\tQ#\u0003\u0002,+\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faaY8oM&<\u0007CA\u0015/\u0013\tySCA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001E2p]\u001aLwMU3q_NLGo\u001c:z!\t\u0011T'D\u00014\u0015\t!T#\u0001\u0005nKR\fG-\u0019;b\u0013\t14G\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006\t\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0011\u0007qI4(\u0003\u0002;;\t1q\n\u001d;j_:\u0004\"\u0001P#\u000e\u0003uR!AP \u0002\rA|G.[2z\u0015\t1\u0002I\u0003\u0002\u0019\u0003*\u0011!iQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\u000b1a\u001c:h\u0013\t1UHA\tBYR,'oQ8oM&<\u0007k\u001c7jGf\f!c\u00197vgR,'\u000fT5oW6\u000bg.Y4feV\t\u0011\n\u0005\u0002K!:\u00111JT\u0007\u0002\u0019*\u0011Q*F\u0001\u0005Y&t7.\u0003\u0002P\u0019\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\t\t&KA\u0006MS:\\W*\u00198bO\u0016\u0014(BA(M\u0003M\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q1ak\u0016-Z5n\u0003\"!\u000b\u0001\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000b1:\u0001\u0019A\u0017\t\u000bA:\u0001\u0019A\u0019\t\u000b]:\u0001\u0019\u0001\u001d\t\u000b\u001d;\u0001\u0019A%\u0002\u0015\u0005dGnQ8oM&<7\u000f\u0006\u0002_cB!q\f\u001a4o\u001b\u0005\u0001'BA1c\u0003\u001diW\u000f^1cY\u0016T!aY\u000f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002fA\n\u0019Q*\u00199\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017\u0001\u00027b]\u001eT\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nQ\n11\u000b\u001e:j]\u001e\u0004\"\u0001H8\n\u0005Al\"aA!os\")A\u0006\u0003a\u0001eB\u00111o^\u0007\u0002i*\u0011A&\u001e\u0006\u0003m\u0002\u000baaY8n[>t\u0017B\u0001=u\u00059\t%m\u001d;sC\u000e$8i\u001c8gS\u001e\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\nw\u0006\r\u00121JA+\u0003S\u0002R\u0001`A\u0005\u0003\u001fq1!`A\u0003\u001d\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\r\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0012bAA\u0004;\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0006\u0003\u001b\u0011A\u0001T5ti*\u0019\u0011qA\u000f\u0011\t\u0005E\u0011Q\u0004\b\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC;\u0002\u000f5,7o]1hK&!\u00111DA\u000b\u0003m!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:q_:\u001cX\rR1uC&!\u0011qDA\u0011\u0005U!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:vYRTA!a\u0007\u0002\u0016!9\u0011QE\u0005A\u0002\u0005\u001d\u0012!\u0006:fg>,(oY3U_\u000e{gNZ5h\u001d\u0006lWm\u001d\t\u0006y\u0006%\u0011\u0011\u0006\t\u0005\u0003W\t)E\u0004\u0003\u0002.\u0005\u0005c\u0002BA\u0018\u0003\u007fqA!!\r\u0002>9!\u00111GA\u001e\u001d\u0011\t)$!\u000f\u000f\u0007y\f9$C\u0001E\u0013\t\u00115)\u0003\u0002\u0019\u0003&\u0011a\u000fQ\u0005\u0004\u0003/)\u0018\u0002BA\"\u0003+\t!\u0004R3tGJL'-Z\"p]\u001aLwm\u001d*fcV,7\u000f\u001e#bi\u0006LA!a\u0012\u0002J\t9B)Z:de&\u0014WmQ8oM&<7OU3t_V\u00148-\u001a\u0006\u0005\u0003\u0007\n)\u0002C\u0004\u0002N%\u0001\r!a\u0014\u0002\u001f%t7\r\\;eKNKhn\u001c8z[N\u00042\u0001HA)\u0013\r\t\u0019&\b\u0002\b\u0005>|G.Z1o\u0011\u001d\t9&\u0003a\u0001\u00033\n\u0011\u0002\u001d:j]\u000eL\u0007/\u00197\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005!\u0011-\u001e;i\u0015\r\t\u0019'^\u0001\tg\u0016\u001cWO]5us&!\u0011qMA/\u00059Y\u0015MZ6b!JLgnY5qC2Dq!a\u001b\n\u0001\u0004\ty%\u0001\u000bj]\u000edW\u000fZ3E_\u000e,X.\u001a8uCRLwN\\\u0001\u0017GJ,\u0017\r^3U_BL7mQ8oM&<WI\u001c;ssRQ\u0011\u0011OAH\u0003O\u000b9,!/\u0015\r\u0005M\u0014\u0011PAF!\u0011\t\t\"!\u001e\n\t\u0005]\u0014\u0011\u0005\u0002\u001e\t\u0016\u001c8M]5cK\u000e{gNZ5hgJ+7o\\;sG\u0016\u0014Vm];mi\"9\u00111\u0010\u0006A\u0002\u0005u\u0014\u0001\u00028b[\u0016\u0004B!a \u0002\b:!\u0011\u0011QAB!\tqX$C\u0002\u0002\u0006v\ta\u0001\u0015:fI\u00164\u0017bA7\u0002\n*\u0019\u0011QQ\u000f\t\r\u00055%\u00021\u0001o\u0003\u00151\u0018\r\\;f\u0011\u001d\t\tJ\u0003a\u0001\u0003'\u000b\u0011\u0002\\8h\u0007>tg-[4\u0011\t\u0005U\u00151U\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006\u0019An\\4\u000b\t\u0005u\u0015qT\u0001\nS:$XM\u001d8bYNT1!!)A\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!*\u0002\u0018\nIAj\\4D_:4\u0017n\u001a\u0005\b\u0003SS\u0001\u0019AAV\u0003)!x\u000e]5d!J|\u0007o\u001d\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011\u00176\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\u000byK\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\u0014\u000b\u0001\u0004\ty\u0005C\u0004\u0002l)\u0001\r!a\u0014\u0002%\u0019LG\u000e^3s)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0007\u0003\u007f\u000bY-!6\u0011\u000b}\u000b\t-!2\n\u0007\u0005\r\u0007M\u0001\u0004Ck\u001a4WM\u001d\t\u00079\u0005\u001d\u0017Q\u00108\n\u0007\u0005%WD\u0001\u0004UkBdWM\r\u0005\b\u0003\u001b\\\u0001\u0019AAh\u0003\u001d\u0019wN\u001c4jON\u0004r!!5\u0002T\u0006ud.D\u0001c\u0013\t)'\rC\u0004\u0002X.\u0001\r!!7\u0002\u0017\r|gNZ5h\u001d\u0006lWm\u001d\t\u00059e\nY\u000e\u0005\u0004\u0002R\u0006u\u0017QP\u0005\u0004\u0003?\u0014'aA*fi\u0006!b/\u00197jI\u0006$XmQ8oM&<\u0007k\u001c7jGf$\u0002\"!:\u0002l\u0006U\u00181 \t\u00049\u0005\u001d\u0018bAAu;\t!QK\\5u\u0011\u001d\ti\u000f\u0004a\u0001\u0003_\f\u0001B]3t_V\u00148-\u001a\t\u0004g\u0006E\u0018bAAzi\nq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007bBA|\u0019\u0001\u0007\u0011\u0011`\u0001\u0011G>tg-[4F]R\u0014\u0018.Z:NCB\u0004\u0002\"!5\u0002T\u0006u\u0014Q\u0010\u0005\b\u0003/b\u0001\u0019AA-\u0003]\u0019'/Z1uK\n\u0013xn[3s\u0007>tg-[4F]R\u0014\u0018\u0010\u0006\u0005\u0003\u0002\t\u001d!1\u0002B\u0007)\u0019\t\u0019Ha\u0001\u0003\u0006!9\u00111P\u0007A\u0002\u0005u\u0004BBAG\u001b\u0001\u0007a\u000eC\u0004\u0003\n5\u0001\r!a\u0014\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eDq!!\u0014\u000e\u0001\u0004\ty\u0005C\u0004\u0002l5\u0001\r!a\u0014\u00029\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7nQ8oM&<WI\u001c;ssR1!1\u0003B\r\u0005;!b!a\u001d\u0003\u0016\t]\u0001bBA>\u001d\u0001\u0007\u0011Q\u0010\u0005\u0007\u0003\u001bs\u0001\u0019\u00018\t\u000f\tma\u00021\u0001\u0002\\\u00069R\r\u001f9mS\u000eLG\u000f\\=TKR\u001cuN\u001c4jO.+\u0017p\u001d\u0005\u0006Y9\u0001\rA]\u0001\u000fG>tg-[4Ts:|g._7t)!\u0011\u0019Ca\u000b\u0003.\tM\u0002#\u0002?\u0002\n\t\u0015\u0002\u0003BA\t\u0005OIAA!\u000b\u0002\"\t1B)Z:de&\u0014WmQ8oM&<7oU=o_:LX\u000eC\u0004\u0002|=\u0001\r!! \t\u000f\t=r\u00021\u0001\u00032\u0005A1/\u001f8p]fl7\u000fE\u0003}\u0003\u0013\ti\bC\u0004\u00036=\u0001\r!a\u0014\u0002\u0017%\u001c8+\u001a8tSRLg/Z\u0001\u000fEJ|7.\u001a:Ts:|g._7t)\u0011\u0011\tDa\u000f\t\u000f\u0005m\u0004\u00031\u0001\u0002~\u0005\u0019\"M]8lKJ$unY;nK:$\u0018\r^5p]R!\u0011Q\u0010B!\u0011\u001d\tY(\u0005a\u0001\u0003{\n!cY8oM&<'+Z:q_:\u001cX\rV=qKR!!q\tB.!\u0011\u0011IE!\u0016\u000f\t\t-#\u0011K\u0007\u0003\u0005\u001bR1Aa\u0014v\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B*\u0005\u001b\nq\u0003R3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3\n\t\t]#\u0011\f\u0002\u000b\u0007>tg-[4UsB,'\u0002\u0002B*\u0005\u001bBqA!\u0018\u0013\u0001\u0004\u0011y&\u0001\u0006d_:4\u0017n\u001a+za\u0016\u0004B\u0001H\u001d\u0003bA!!1\rB5\u001d\r\u0019(QM\u0005\u0004\u0005O\"\u0018!C\"p]\u001aLw\rR3g\u0013\u0011\u0011YG!\u001c\u0003\tQK\b/\u001a\u0006\u0004\u0005O\"\u0018A\u0006:fg>,(oY3OC6,Gk\u001c\"s_.,'/\u00133\u0015\t\tM$\u0011\u0010\t\u00049\tU\u0014b\u0001B<;\t\u0019\u0011J\u001c;\t\u000f\tm4\u00031\u0001\u0002~\u0005a!/Z:pkJ\u001cWMT1nK\u0002")
public class ConfigHelper
implements Logging {
    private final MetadataCache metadataCache;
    private final KafkaConfig config;
    private final ConfigRepository configRepository;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public scala.collection.mutable.Map<String, Object> allConfigs(AbstractConfig config) {
        return ((scala.collection.mutable.MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$allConfigs$1(x$1)))).$plus$plus((GenTraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(config.nonInternalValues()).asScala());
    }

    public List<DescribeConfigsResponseData.DescribeConfigsResult> describeConfigs(List<DescribeConfigsRequestData.DescribeConfigsResource> resourceToConfigNames, boolean includeSynonyms, KafkaPrincipal principal, boolean includeDocumentation) {
        return (List)resourceToConfigNames.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            try {
                DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult;
                ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
                if (ConfigResource.Type.TOPIC.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult2;
                    String topic = x0$1.resourceName();
                    Topic.validate((String)topic);
                    if ($this.metadataCache.contains(topic)) {
                        void createResponseConfig$1_createConfigEntry;
                        Properties topicProps = $this.configRepository.topicConfig(topic);
                        LogConfig logConfig = LogConfig.fromProps($this.config.extractLogConfigMap(), (Properties)topicProps);
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs((AbstractConfig)logConfig);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        describeConfigsResult2 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setConfigs(Collections.emptyList());
                    }
                    describeConfigsResult = describeConfigsResult2;
                } else if (ConfigResource.Type.BROKER.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult3;
                    if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, includeDocumentation, (String)name, value);
                        Map<String, String> createResponseConfig$1_configs = $this.config.dynamicConfig().currentDynamicDefaultConfigs();
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs(createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult3 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else if (this.resourceNameToBrokerId(x0$1.resourceName()) == $this.config.brokerId()) {
                        void createResponseConfig$1_createConfigEntry;
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, includeDocumentation, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs($this.config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult3 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    } else {
                        throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" or empty string, but received ").append(x0$1.resourceName()).toString());
                    }
                    describeConfigsResult = describeConfigsResult3;
                } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                    void createResponseConfig$1_createConfigEntry;
                    if (x0$1.resourceName() == null || x0$1.resourceName().isEmpty()) {
                        throw new InvalidRequestException("Broker id must not be empty");
                    }
                    if (this.resourceNameToBrokerId(x0$1.resourceName()) != $this.config.brokerId()) {
                        throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append($this.config.brokerId()).append(" but received ").append(x0$1.resourceName()).toString());
                    }
                    ConfigResource configResource = new ConfigResource(ConfigResource.Type.forId((byte)x0$1.resourceType()), x0$1.resourceName());
                    this.validateConfigPolicy(configResource, (Map<String, String>)Map$.MODULE$.empty(), principal);
                    Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(value.toString()).setConfigSource(DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG.id()).setIsSensitive(false).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
                    scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                    Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                    describeConfigsResult = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                } else if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                    DescribeConfigsResponseData.DescribeConfigsResult describeConfigsResult4;
                    Properties properties;
                    String linkName = x0$1.resourceName();
                    if (linkName == null || linkName.isEmpty()) {
                        throw new InvalidRequestException("Cluster link name must not be empty");
                    }
                    Uuid linkId = this.clusterLinkManager().resolveLinkIdOrThrow(linkName);
                    this.clusterLinkManager().ensureClusterLinkExists(linkId);
                    ConfigRepository configRepository = $this.configRepository;
                    if (configRepository instanceof ZkConfigRepository) {
                        properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, CoreUtils$.MODULE$.toJavaUUID(linkId).toString()));
                    } else if (configRepository instanceof KRaftMetadataCache) {
                        properties = $this.configRepository.config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
                    } else {
                        throw new IllegalStateException("Unsupported config repository type");
                    }
                    try {
                        void createResponseConfig$1_createConfigEntry;
                        Set explicitlySetConfigKeys = (Set)CollectionConverters$.MODULE$.asScalaSetConverter(properties.keySet()).asScala();
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Explicitly set config keys ").append(explicitlySetConfigKeys).append(".").toString());
                        ClusterLinkConfig config = this.clusterLinkManager().configEncoder().clusterLinkConfig(properties);
                        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(name, value) -> this.createClusterLinkConfigEntry((Set<String>)explicitlySetConfigKeys, config, (String)name, value);
                        scala.collection.mutable.Map<String, Object> createResponseConfig$1_configs = this.allConfigs(config);
                        Buffer createResponseConfig$1_configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)createResponseConfig$1_configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x0$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map(arg_0 -> ConfigHelper.$anonfun$describeConfigs$4((Function2)createResponseConfig$1_createConfigEntry, arg_0), Buffer$.MODULE$.canBuildFrom());
                        describeConfigsResult4 = new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                    }
                    catch (ConfigException configException) {
                        throw new InvalidConfigurationException(new StringBuilder(202).append("Cluster link configs could not be decoded for link '").append(linkName).append("', '").append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append("' ").append("may be misconfigured on some brokers. Configure all brokers with the same encoder secret and reconfigure link by providing the full link config.").toString());
                    }
                    describeConfigsResult = describeConfigsResult4;
                } else {
                    throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                }
                return describeConfigsResult.setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType());
            }
            catch (Throwable e) {
                String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(x0$1).toString();
                if (e instanceof ApiException) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                } else {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
                ApiError err = ApiError.fromThrowable((Throwable)e);
                return new DescribeConfigsResponseData.DescribeConfigsResult().setResourceName(x0$1.resourceName()).setResourceType(x0$1.resourceType()).setErrorMessage(err.message()).setErrorCode(err.error().code()).setConfigs(Collections.emptyList());
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public DescribeConfigsResponseData.DescribeConfigsResourceResult createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        List list;
        Option configEntryType = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(LogConfig.configType((String)name)));
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)configEntryType);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull(Predef$.MODULE$.$conforms())));
        List list2 = (List)Option$.MODULE$.apply(ServerTopicConfigSynonyms.TOPIC_CONFIG_SYNONYMS.get(name)).map((Function1 & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponseData.DescribeConfigsSynonym describeConfigsSynonym = new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(valueAsString).setSource(DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG.id());
            list = (List)list2.$plus$colon((Object)describeConfigsSynonym, List$.MODULE$.canBuildFrom());
        }
        List allSynonyms = list;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType((Option<ConfigDef.Type>)configEntryType);
        String configDocumentation = includeDocumentation ? logConfig.documentationOf(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    public Buffer<Tuple2<String, Object>> filterTopicConfigs(Map<String, Object> configs, Option<Set<String>> configNames) {
        return ((MapLike)configs.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$filterTopicConfigs$1(configNames, x0$1)))).toBuffer();
    }

    public void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap, KafkaPrincipal principal) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy;
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava(), principal));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, boolean includeDocumentation, String name, Object value) {
        String string;
        List<String> allNames = this.brokerSynonyms(name);
        Option<ConfigDef.Type> configEntryType = KafkaConfig$.MODULE$.configType(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive(configEntryType);
        if (isSensitive) {
            string = null;
        } else {
            String string2 = value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)((ConfigDef.Type)configEntryType.orNull(Predef$.MODULE$.$conforms())));
            string = string2;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$6)));
        List synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        byte source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id() : ((DescribeConfigsResponseData.DescribeConfigsSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        DescribeConfigsResponse.ConfigType dataType = this.configResponseType(configEntryType);
        String configDocumentation = includeDocumentation ? this.brokerDocumentation(name) : null;
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(source).setIsSensitive(isSensitive).setReadOnly(readOnly).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava()).setDocumentation(configDocumentation).setConfigType(dataType.id());
    }

    private DescribeConfigsResponseData.DescribeConfigsResourceResult createClusterLinkConfigEntry(Set<String> explicitlySetConfigKeys, AbstractConfig config, String name, Object value) {
        ConfigDef.Type configEntryType = config.typeOf(name);
        boolean isSensitive = KafkaConfig$.MODULE$.maybeSensitive((Option<ConfigDef.Type>)Option$.MODULE$.apply((Object)configEntryType));
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        return new DescribeConfigsResponseData.DescribeConfigsResourceResult().setName(name).setValue(valueAsString).setConfigSource(explicitlySetConfigKeys.contains((Object)name) ? DescribeConfigsResponse.ConfigSource.CLUSTER_LINK_CONFIG.id() : DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG.id()).setIsSensitive(isSensitive).setReadOnly(false).setSynonyms((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava());
    }

    private List<DescribeConfigsResponseData.DescribeConfigsSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config.dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$2$adapted(dynamicConfig.currentDynamicBrokerConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach(arg_0 -> ConfigHelper.$anonfun$configSynonyms$3$adapted(dynamicConfig.currentDynamicDefaultConfigs(), isSensitive, allSynonyms, arg_0));
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1 & Serializable & scala.Serializable)name -> {
            ConfigHelper.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ConfigHelper.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private String brokerDocumentation(String name) {
        return this.config.documentationOf(name);
    }

    private DescribeConfigsResponse.ConfigType configResponseType(Option<ConfigDef.Type> configType) {
        if (configType.isEmpty()) {
            return DescribeConfigsResponse.ConfigType.UNKNOWN;
        }
        ConfigDef.Type type = (ConfigDef.Type)configType.get();
        DescribeConfigsResponse.ConfigType configType2 = ConfigDef.Type.BOOLEAN.equals(type) ? DescribeConfigsResponse.ConfigType.BOOLEAN : (ConfigDef.Type.STRING.equals(type) ? DescribeConfigsResponse.ConfigType.STRING : (ConfigDef.Type.INT.equals(type) ? DescribeConfigsResponse.ConfigType.INT : (ConfigDef.Type.SHORT.equals(type) ? DescribeConfigsResponse.ConfigType.SHORT : (ConfigDef.Type.LONG.equals(type) ? DescribeConfigsResponse.ConfigType.LONG : (ConfigDef.Type.DOUBLE.equals(type) ? DescribeConfigsResponse.ConfigType.DOUBLE : (ConfigDef.Type.LIST.equals(type) ? DescribeConfigsResponse.ConfigType.LIST : (ConfigDef.Type.CLASS.equals(type) ? DescribeConfigsResponse.ConfigType.CLASS : (ConfigDef.Type.PASSWORD.equals(type) ? DescribeConfigsResponse.ConfigType.PASSWORD : DescribeConfigsResponse.ConfigType.UNKNOWN))))))));
        return configType2;
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$allConfigs$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    private final DescribeConfigsResponseData.DescribeConfigsResult createResponseConfig$1(Map configs, Function2 createConfigEntry, DescribeConfigsRequestData.DescribeConfigsResource x1$1) {
        Buffer configEntries = (Buffer)this.filterTopicConfigs((Map<String, Object>)configs, (Option<Set<String>>)Option$.MODULE$.apply((Object)x1$1.configurationKeys()).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEmpty())).map((Function1 & Serializable & scala.Serializable)x$3 -> ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).toSet())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Object value = x0$1._2();
            DescribeConfigsResponseData.DescribeConfigsResourceResult describeConfigsResourceResult = (DescribeConfigsResponseData.DescribeConfigsResourceResult)createConfigEntry.apply((Object)name, value);
            return describeConfigsResourceResult;
        }, Buffer$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponseData.DescribeConfigsResult().setErrorCode(Errors.NONE.code()).setConfigs((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$filterTopicConfigs$1(Option configNames$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String configName = (String)x0$1._1();
        boolean recordInterceptorCheck = !configName.equals("confluent.append.record.interceptor.classes");
        boolean schemaRegistryUrlCheck = !configName.equals("confluent.schema.registry.url");
        boolean schemaValidatorSamplesPerMinCheck = !configName.equals("confluent.schema.validator.samples.per.min");
        boolean schemaValidatorInterceptorClassCheck = !configName.equals("confluent.schema.validator.interceptor.class");
        boolean multitenantSchemaValidationEnabledCheck = !configName.equals("confluent.schema.validator.multitenant.enable");
        boolean basicAuthCredentialsSourceCheck = !configName.equals("confluent.basic.auth.credentials.source");
        boolean userInfoCheck = !configName.equals("confluent.basic.auth.user.info");
        boolean bearerAuthCredentialsCheck = !configName.equals("confluent.bearer.auth.credentials.source");
        boolean bearerAuthTokenCheck = !configName.equals("confluent.bearer.auth.token");
        boolean bearerAuthIssuerEndpoint = !configName.equals("confluent.bearer.auth.issuer.endpoint.url");
        boolean bearerAuthClientId = !configName.equals("confluent.bearer.auth.client.id");
        boolean bearerAuthClientSecret = !configName.equals("confluent.bearer.auth.client.secret");
        boolean bearerAuthClientScope = !configName.equals("confluent.bearer.auth.scope");
        boolean bearerAuthClientScopeClaim = !configName.equals("confluent.bearer.auth.scope.claim.name");
        boolean bearerAuthClientSubClaim = !configName.equals("confluent.bearer.auth.sub.claim.name");
        boolean bearerAuthLogicalCluster = !configName.equals("confluent.bearer.auth.logical.cluster");
        boolean bearerAuthIdentityPool = !configName.equals("confluent.bearer.auth.identity.pool.id");
        boolean bearerAuthBufferExpirySecond = !configName.equals("confluent.bearer.auth.cache.expiry.buffer.seconds");
        boolean sslProtocolCheck = !configName.equals("confluent.ssl.protocol");
        boolean sslKeystoreTypeCheck = !configName.equals("confluent.ssl.keystore.type");
        boolean sslKeystoreLocationCheck = !configName.equals("confluent.ssl.keystore.location");
        boolean sslKeystorePasswordCheck = !configName.equals("confluent.ssl.keystore.password");
        boolean sslKeyPasswordCheck = !configName.equals("confluent.ssl.key.password");
        boolean sslTruststoreTypeCheck = !configName.equals("confluent.ssl.truststore.type");
        boolean sslTruststoreLocationCheck = !configName.equals("confluent.ssl.truststore.location");
        boolean sslTruststorePasswordCheck = !configName.equals("confluent.ssl.truststore.password");
        boolean bl = basicAuthCredentialsSourceCheck && userInfoCheck && bearerAuthCredentialsCheck && bearerAuthTokenCheck && bearerAuthIssuerEndpoint && bearerAuthClientId && bearerAuthClientSecret && bearerAuthClientScope && bearerAuthClientScopeClaim && bearerAuthClientSubClaim && bearerAuthLogicalCluster && bearerAuthIdentityPool && bearerAuthBufferExpirySecond && recordInterceptorCheck && schemaRegistryUrlCheck && schemaValidatorSamplesPerMinCheck && schemaValidatorInterceptorClassCheck && multitenantSchemaValidationEnabledCheck && sslProtocolCheck && sslKeystoreTypeCheck && sslKeystoreLocationCheck && sslKeystorePasswordCheck && sslKeyPasswordCheck && sslTruststoreTypeCheck && sslTruststoreLocationCheck && sslTruststorePasswordCheck && configNames$1.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((Object)configName)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponseData.DescribeConfigsSynonym x$6) {
        return perBrokerConfig$1 || x$6.source() == DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG.id();
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$2, Buffer allSynonyms$1) {
        map.get((Object)name).map((Function1 & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$2 ? null : value;
            return allSynonyms$1.$plus$eq((Object)new DescribeConfigsResponseData.DescribeConfigsSynonym().setName(name).setValue(configValue).setSource(source.id()));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponseData.DescribeConfigsSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public ConfigHelper(MetadataCache metadataCache, KafkaConfig config, ConfigRepository configRepository, Option<AlterConfigPolicy> alterConfigPolicy, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.metadataCache = metadataCache;
        this.config = config;
        this.configRepository = configRepository;
        this.alterConfigPolicy = alterConfigPolicy;
        this.clusterLinkManager = clusterLinkManager;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$2, Buffer allSynonyms$1, String name) {
        ConfigHelper.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$2, allSynonyms$1);
        return BoxedUnit.UNIT;
    }
}

