/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.config.ConfigUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class ControllerStatusHandleAdapter$ {
    public static ControllerStatusHandleAdapter$ MODULE$;
    private final int MaxAllowedOffsetLag;
    private final String UnreachableQuorumMemberMsg;

    static {
        new ControllerStatusHandleAdapter$();
    }

    public int MaxAllowedOffsetLag() {
        return this.MaxAllowedOffsetLag;
    }

    public String UnreachableQuorumMemberMsg() {
        return this.UnreachableQuorumMemberMsg;
    }

    public Option<String> checkRollable(ConfluentAdmin adminClient, int timeoutMs, Logging errorLogger) {
        try {
            QuorumInfo info = this.getDescribeQuorumInfo(adminClient, timeoutMs);
            ObjectRef reason = ObjectRef.create((Object)None$.MODULE$);
            ListBuffer logEndOffsets = new ListBuffer();
            info.voters().forEach(v -> {
                if (v.logEndOffset() < 0L) {
                    reason$1.elem = new Some((Object)MODULE$.UnreachableQuorumMemberMsg());
                }
                logEndOffsets.$plus$eq((Object)BoxesRunTime.boxToLong((long)v.logEndOffset()));
            });
            if (((Option)reason.elem).isEmpty()) {
                long maxOffset = BoxesRunTime.unboxToLong((Object)logEndOffsets.max((Ordering)Ordering.Long$.MODULE$));
                logEndOffsets.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)o -> {
                    if (o < maxOffset - (long)MODULE$.MaxAllowedOffsetLag()) {
                        reason$1.elem = new Some((Object)MODULE$.reasonFrom(o, maxOffset));
                    }
                });
            }
            return (Option)reason.elem;
        }
        catch (Throwable e) {
            return new Some((Object)this.reasonFrom(e, errorLogger));
        }
    }

    public Option<String> checkReady(ConfluentAdmin adminClient, int timeoutMs, Logging errorLogger, int nodeId) {
        try {
            QuorumInfo info = this.getDescribeQuorumInfo(adminClient, timeoutMs);
            LongRef logEndOffsetForSpecifiedNode = LongRef.create((long)-1L);
            LongRef maxLogEndOffset = LongRef.create((long)0L);
            info.voters().forEach(v -> {
                if (v.replicaId() == nodeId) {
                    logEndOffsetForSpecifiedNode$1.elem = v.logEndOffset();
                }
                if (v.logEndOffset() > maxLogEndOffset$1.elem) {
                    maxLogEndOffset$1.elem = v.logEndOffset();
                }
            });
            None$ reason = None$.MODULE$;
            if (logEndOffsetForSpecifiedNode.elem < 0L) {
                reason = new Some((Object)this.UnreachableQuorumMemberMsg());
            } else if (logEndOffsetForSpecifiedNode.elem < maxLogEndOffset.elem - (long)this.MaxAllowedOffsetLag()) {
                reason = new Some((Object)this.reasonFrom(logEndOffsetForSpecifiedNode.elem, maxLogEndOffset.elem));
            }
            return reason;
        }
        catch (Throwable e) {
            return new Some((Object)this.reasonFrom(e, errorLogger));
        }
    }

    public ConfluentAdmin createAdmin(String bootstrapServers, String clientId, KafkaConfig config) {
        Properties clientConfig = new Properties();
        clientConfig.put("bootstrap.servers", bootstrapServers);
        clientConfig.put("client.id", clientId);
        clientConfig.put("confluent.use.controller.listener", "true");
        ListenerName controllerListenerName = new ListenerName((String)config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()));
        clientConfig.putAll((Map<?, ?>)ConfigUtils.clientConfigsForListener(config.originals(), Collections.emptyMap(), (ListenerName)controllerListenerName, (SecurityProtocol)controllerSecurityProtocol));
        return ConfluentAdmin.create((Properties)clientConfig);
    }

    private QuorumInfo getDescribeQuorumInfo(ConfluentAdmin adminClient, int timeoutMs) {
        return (QuorumInfo)adminClient.describeMetadataQuorum((DescribeMetadataQuorumOptions)new DescribeMetadataQuorumOptions().timeoutMs(Predef$.MODULE$.int2Integer(timeoutMs))).quorumInfo().get();
    }

    /*
     * WARNING - void declaration
     */
    private String reasonFrom(Throwable e, Logging errorLogger) {
        void var3_3;
        String reason = new StringBuilder(70).append("There was an exception of type ").append(e.getClass()).append(" while querying the state of the quorum").toString();
        errorLogger.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> reason, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        return var3_3;
    }

    private String reasonFrom(long laggingOffset, long maxOffset) {
        return new StringBuilder(109).append("Found at least one quorum voter with an offset ").append(laggingOffset).append(" while the highest offset was ").append(maxOffset).append(". The max allowed offset lag is ").append(this.MaxAllowedOffsetLag()).toString();
    }

    private ControllerStatusHandleAdapter$() {
        MODULE$ = this;
        this.MaxAllowedOffsetLag = 1000;
        this.UnreachableQuorumMemberMsg = "At least one member of the Quorum is unreachable";
    }
}

