/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.server.AutoTopicCreationManager;
import kafka.server.AutoTopicCreationManager$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.ForwardingManager$;
import kafka.server.KafkaConfig;
import kafka.server.ZkAdminManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\t\u0013\u0001]A\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000bU\u0003A\u0011\u0001,\t\u000fy\u0003!\u0019!C\u0005?\"11\u000f\u0001Q\u0001\n\u0001DQ\u0001\u001e\u0001\u0005BUDq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAB\u0001\u0011%\u0011Q\u0011\u0005\b\u0003\u001f\u0003A\u0011BAI\u0005}!UMZ1vYR\fU\u000f^8U_BL7m\u0011:fCRLwN\\'b]\u0006<WM\u001d\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0007\u0010#!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fMB\u0011q\u0004I\u0007\u0002%%\u0011\u0011E\u0005\u0002\u0019\u0003V$x\u000eV8qS\u000e\u001c%/Z1uS>tW*\u00198bO\u0016\u0014\bCA\u0012'\u001b\u0005!#BA\u0013\u0015\u0003\u0015)H/\u001b7t\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\ty\"&\u0003\u0002,%\tY1*\u00194lC\u000e{gNZ5h\u00039\u0019\u0007.\u00198oK2l\u0015M\\1hKJ\u00042!\u0007\u00181\u0013\ty#D\u0001\u0004PaRLwN\u001c\t\u0003?EJ!A\r\n\u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\rC\u0012l\u0017N\\'b]\u0006<WM\u001d\t\u000439*\u0004CA\u00107\u0013\t9$C\u0001\b[W\u0006#W.\u001b8NC:\fw-\u001a:\u0002\u0015\r|g\u000e\u001e:pY2,'\u000fE\u0002\u001a]i\u0002\"aO\u001f\u000e\u0003qR!\u0001\u000f\u000b\n\u0005yb$aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002!\u001d\u0014x.\u001e9D_>\u0014H-\u001b8bi>\u0014\bCA!L\u001b\u0005\u0011%BA\"E\u0003\u00159'o\\;q\u0015\t)e)A\u0006d_>\u0014H-\u001b8bi>\u0014(BA\u000bH\u0015\tA\u0015*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051\u0013%\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u00039!\bP\\\"p_J$\u0017N\\1u_J\u0004\"aT*\u000e\u0003AS!!\u0015*\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u000bRI!\u0001\u0016)\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fa\u0001P5oSRtDcB,Y3j[F,\u0018\t\u0003?\u0001AQ\u0001K\u0004A\u0002%BQ\u0001L\u0004A\u00025BQaM\u0004A\u0002QBQ\u0001O\u0004A\u0002eBQaP\u0004A\u0002\u0001CQ!T\u0004A\u00029\u000ba\"\u001b8gY&<\u0007\u000e\u001e+pa&\u001c7/F\u0001a!\r\tg\r[\u0007\u0002E*\u00111\rZ\u0001\u0005kRLGNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'aA*fiB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a\u001b\u000e\u000e\u00031T!!\u001c\f\u0002\rq\u0012xn\u001c;?\u0013\ty'$\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8\u001b\u0003=IgN\u001a7jO\"$Hk\u001c9jGN\u0004\u0013\u0001D2sK\u0006$X\rV8qS\u000e\u001cHc\u0002<\u0002$\u0005-\u0012Q\u0007\t\u0004ojdX\"\u0001=\u000b\u0005eT\u0012AC2pY2,7\r^5p]&\u00111\u0010\u001f\u0002\u0004'\u0016\f\bcA?\u0002\u001e9\u0019a0a\u0006\u000f\u0007}\f\tB\u0004\u0003\u0002\u0002\u00055a\u0002BA\u0002\u0003\u0017qA!!\u0002\u0002\n9\u00191.a\u0002\n\u0003)K!\u0001S%\n\u0005U9\u0015bAA\b\r\u000611m\\7n_:LA!a\u0005\u0002\u0016\u00059Q.Z:tC\u001e,'bAA\b\r&!\u0011\u0011DA\u000e\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u00111CA\u000b\u0013\u0011\ty\"!\t\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG*!\u0011\u0011DA\u000e\u0011\u001d\t)C\u0003a\u0001\u0003O\ta\u0001^8qS\u000e\u001c\b\u0003B<\u0002*!L!a\u001a=\t\u000f\u00055\"\u00021\u0001\u00020\u000592m\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\t\u0004?\u0005E\u0012bAA\u001a%\t92i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\u0005\b\u0003oQ\u0001\u0019AA\u001d\u0003YiW\r^1eCR\f'+Z9vKN$8i\u001c8uKb$\b\u0003B\r/\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n)\"\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t)%a\u0010\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\u0006\u00012M]3bi\u0016$v\u000e]5dg&s'l\u001b\u000b\bm\u0006-\u00131MA3\u0011\u001d\tie\u0003a\u0001\u0003\u001f\nqb\u0019:fCR\f'\r\\3U_BL7m\u001d\t\u0007o\u0006E\u0003.!\u0016\n\u0007\u0005M\u0003PA\u0002NCB\u0004B!a\u0016\u0002^9\u0019a0!\u0017\n\t\u0005m\u00131D\u0001\u0018\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e#bi\u0006LA!a\u0018\u0002b\tq1I]3bi\u0006\u0014G.\u001a+pa&\u001c'\u0002BA.\u00037Aq!!\f\f\u0001\u0004\ty\u0003C\u0004\u00028-\u0001\r!!\u000f\u0002-M,g\u000eZ\"sK\u0006$X\rV8qS\u000e\u0014V-];fgR$RA^A6\u0003[Bq!!\u0014\r\u0001\u0004\ty\u0005C\u0004\u000281\u0001\r!!\u000f\u0002+\rdW-\u0019:J]\u001ad\u0017n\u001a5u%\u0016\fX/Z:ugR!\u00111OA=!\rI\u0012QO\u0005\u0004\u0003oR\"\u0001B+oSRDq!!\u0014\u000e\u0001\u0004\ty%\u0001\bde\u0016\fG/\u00192mKR{\u0007/[2\u0015\t\u0005U\u0013q\u0010\u0005\u0007\u0003\u0003s\u0001\u0019\u00015\u0002\u000bQ|\u0007/[2\u0002!%\u001ch+\u00197jIR{\u0007/[2OC6,G\u0003BAD\u0003\u001b\u00032!GAE\u0013\r\tYI\u0007\u0002\b\u0005>|G.Z1o\u0011\u0019\t\ti\u0004a\u0001Q\u0006)b-\u001b7uKJ\u001c%/Z1uC\ndW\rV8qS\u000e\u001cH\u0003BAJ\u00033\u0003b!GAK\u0003\u001f2\u0018bAAL5\t1A+\u001e9mKJBq!!\n\u0011\u0001\u0004\t9\u0003")
public class DefaultAutoTopicCreationManager
implements AutoTopicCreationManager,
Logging {
    private final KafkaConfig config;
    private final Option<BrokerToControllerChannelManager> channelManager;
    private final Option<ZkAdminManager> adminManager;
    private final Option<KafkaController> controller;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private final java.util.Set<String> inflightTopics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private java.util.Set<String> inflightTopics() {
        return this.inflightTopics;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> createTopics(Set<String> topics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        void var6_6;
        void var5_5;
        Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> tuple2 = this.filterCreatableTopics(topics);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map creatableTopics = (Map)tuple2._1();
        Seq uncreatableTopicResponses = (Seq)tuple2._2();
        void creatableTopics2 = var5_5;
        void uncreatableTopicResponses2 = var6_6;
        Seq<MetadataResponseData.MetadataResponseTopic> creatableTopicResponses = creatableTopics2.isEmpty() ? Nil$.MODULE$ : (this.controller.isEmpty() || !((KafkaController)this.controller.get()).isActive() && this.channelManager.isDefined() ? this.sendCreateTopicRequest((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, metadataRequestContext) : this.createTopicsInZk((Map<String, CreateTopicsRequestData.CreatableTopic>)creatableTopics2, controllerMutationQuota, metadataRequestContext));
        return (Seq)uncreatableTopicResponses2.$plus$plus((GenTraversableOnce)creatableTopicResponses, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> createTopicsInZk(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, ControllerMutationQuota controllerMutationQuota, Option<RequestContext> metadataRequestContext) {
        Seq seq;
        AtomicReference topicErrors = new AtomicReference();
        try {
            Seq seq2;
            ((ZkAdminManager)this.adminManager.get()).createTopics(0, false, creatableTopics, (Map<String, CreateTopicsResponseData.CreatableTopicResult>)scala.collection.Map$.MODULE$.empty(), controllerMutationQuota, (Option<KafkaPrincipal>)metadataRequestContext.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.principal), (Function1<Map<String, ApiError>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x$1 -> {
                topicErrors.set(x$1);
                return BoxedUnit.UNIT;
            });
            Option option = Option$.MODULE$.apply(topicErrors.get());
            if (option instanceof Some) {
                seq2 = (Seq)((Map)((Some)option).value()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    String topic = (String)x0$1._1();
                    Errors errors = ((ApiError)x0$1._2()).error();
                    boolean bl = Errors.TOPIC_ALREADY_EXISTS.equals(errors) ? true : Errors.REQUEST_TIMED_OUT.equals(errors);
                    Errors errors2 = bl ? Errors.LEADER_NOT_AVAILABLE : (Errors.POLICY_VIOLATION.equals(errors) ? Errors.TOPIC_AUTHORIZATION_FAILED : errors);
                    MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic().setErrorCode(errors2.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic));
                    return metadataResponseTopic;
                }, Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option)) {
                seq2 = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError((Object)option);
            }
            seq = seq2;
        }
        finally {
            this.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(creatableTopics);
        }
        return seq;
    }

    private Seq<MetadataResponseData.MetadataResponseTopic> sendCreateTopicRequest(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics, Option<RequestContext> metadataRequestContext) {
        CreateTopicsRequestData.CreatableTopicCollection topicsToCreate = new CreateTopicsRequestData.CreatableTopicCollection(creatableTopics.size());
        topicsToCreate.addAll(CollectionConverters$.MODULE$.asJavaCollectionConverter(creatableTopics.values()).asJavaCollection());
        CreateTopicsRequest.Builder createTopicsRequest = new CreateTopicsRequest.Builder(new CreateTopicsRequestData().setTimeoutMs(Predef$.MODULE$.Integer2int(this.config.requestTimeoutMs())).setTopics(topicsToCreate));
        ControllerRequestCompletionHandler requestCompletionHandler = new ControllerRequestCompletionHandler(this, creatableTopics){
            private final /* synthetic */ DefaultAutoTopicCreationManager $outer;
            private final Map creatableTopics$1;

            public void onTimeout() {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Auto topic creation timed out for ").append($this.creatableTopics$1.keys()).append(".").toString());
            }

            public void onComplete(ClientResponse response) {
                this.$outer.kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests((Map<String, CreateTopicsRequestData.CreatableTopic>)this.creatableTopics$1);
                if (response.authenticationException() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with authentication exception").toString());
                    return;
                }
                if (response.versionMismatch() != null) {
                    this.$outer.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Auto topic creation failed for ").append($this.creatableTopics$1.keys()).append(" with invalid version exception").toString());
                    return;
                }
                this.$outer.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Auto topic creation completed for ").append($this.creatableTopics$1.keys()).append(" with response ").append(response.responseBody()).append(".").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.creatableTopics$1 = creatableTopics$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onTimeout$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$1(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$2(kafka.server.DefaultAutoTopicCreationManager$$anon$1 ), $anonfun$onComplete$3(kafka.server.DefaultAutoTopicCreationManager$$anon$1 org.apache.kafka.clients.ClientResponse )}, serializedLambda);
            }
        };
        BrokerToControllerChannelManager channelManager = (BrokerToControllerChannelManager)this.channelManager.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Channel manager must be defined in order to send CreateTopic requests.");
        });
        AbstractRequest.Builder request = (AbstractRequest.Builder)metadataRequestContext.map((Function1 & Serializable & scala.Serializable)context -> {
            short s;
            Option<NodeApiVersions> option = channelManager.controllerApiVersions();
            if (None$.MODULE$.equals(option)) {
                s = ApiKeys.CREATE_TOPICS.latestVersion();
            } else if (option instanceof Some) {
                s = ((NodeApiVersions)((Some)option).value()).latestUsableVersion(ApiKeys.CREATE_TOPICS);
            } else {
                throw new MatchError(option);
            }
            RequestHeader requestHeader = new RequestHeader(ApiKeys.CREATE_TOPICS, s, context.clientId(), context.correlationId());
            return ForwardingManager$.MODULE$.buildEnvelopeRequest((RequestContext)context, createTopicsRequest.build(s).serializeWithHeader(requestHeader));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> createTopicsRequest);
        channelManager.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, requestCompletionHandler);
        Seq creatableTopicResponses = (Seq)creatableTopics.keySet().toSeq().map((Function1 & Serializable & scala.Serializable)topic -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)), Seq$.MODULE$.canBuildFrom());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Sent auto-creation request for ").append(creatableTopics.keys()).append(" to the active controller.").toString());
        return creatableTopicResponses;
    }

    public void kafka$server$DefaultAutoTopicCreationManager$$clearInflightRequests(Map<String, CreateTopicsRequestData.CreatableTopic> creatableTopics) {
        creatableTopics.keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultAutoTopicCreationManager.$anonfun$clearInflightRequests$1(this, x$1)));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Cleared inflight topic creation state for ").append(creatableTopics).toString());
    }

    private CreateTopicsRequestData.CreatableTopic creatableTopic(String topic) {
        CreateTopicsRequestData.CreatableTopic creatableTopic;
        if ("__consumer_offsets".equals(topic)) {
            Properties groupMetadataTopicConfigs = this.groupCoordinator.groupMetadataTopicConfigs();
            short replicationFactor = groupMetadataTopicConfigs.getProperty("confluent.placement.constraints", "").isEmpty() ? (short)Predef$.MODULE$.Short2short(this.config.offsetsTopicReplicationFactor()) : (short)-1;
            creatableTopic = new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.offsetsTopicPartitions())).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(groupMetadataTopicConfigs));
        } else if ("__transaction_state".equals(topic)) {
            short replicationFactor = this.txnCoordinator.placementConstraints().isEmpty() ? (short)Predef$.MODULE$.Short2short(this.config.transactionTopicReplicationFactor()) : (short)-1;
            creatableTopic = new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.transactionTopicPartitions())).setReplicationFactor(replicationFactor).setConfigs(AutoTopicCreationManager$.MODULE$.convertToTopicConfigCollections(this.txnCoordinator.transactionTopicConfigs()));
        } else {
            creatableTopic = new CreateTopicsRequestData.CreatableTopic().setName(topic).setNumPartitions(Predef$.MODULE$.Integer2int(this.config.numPartitions())).setReplicationFactor((short)this.config.defaultReplicationFactor());
        }
        return creatableTopic;
    }

    private boolean isValidTopicName(String topic) {
        try {
            Topic.validate((String)topic);
            return true;
        }
        catch (InvalidTopicException invalidTopicException) {
            return false;
        }
    }

    private Tuple2<Map<String, CreateTopicsRequestData.CreatableTopic>, Seq<MetadataResponseData.MetadataResponseTopic>> filterCreatableTopics(Set<String> topics) {
        scala.collection.mutable.Map creatableTopics = Map$.MODULE$.empty();
        Buffer uncreatableTopics = (Buffer)Buffer$.MODULE$.empty();
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            Option option;
            Some validationError;
            Object object = !this.isValidTopicName((String)topic) ? new Some((Object)Errors.INVALID_TOPIC_EXCEPTION) : (validationError = !this.inflightTopics().add((String)topic) ? new Some((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION) : None$.MODULE$);
            if (validationError instanceof Some) {
                Errors error = (Errors)validationError.value();
                option = uncreatableTopics.$plus$eq((Object)new MetadataResponseData.MetadataResponseTopic().setErrorCode(error.code()).setName(topic).setIsInternal(Topic.isInternal((String)topic)));
            } else if (None$.MODULE$.equals(validationError)) {
                option = creatableTopics.put(topic, (Object)this.creatableTopic((String)topic));
            } else {
                throw new MatchError((Object)validationError);
            }
            return option;
        });
        return new Tuple2((Object)creatableTopics, (Object)uncreatableTopics);
    }

    public static final /* synthetic */ boolean $anonfun$clearInflightRequests$1(DefaultAutoTopicCreationManager $this, Object x$1) {
        return $this.inflightTopics().remove(x$1);
    }

    public DefaultAutoTopicCreationManager(KafkaConfig config, Option<BrokerToControllerChannelManager> channelManager, Option<ZkAdminManager> adminManager, Option<KafkaController> controller, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator) {
        this.config = config;
        this.channelManager = channelManager;
        this.adminManager = adminManager;
        this.controller = controller;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        Logging.$init$(this);
        if (controller.isEmpty() && channelManager.isEmpty()) {
            throw new IllegalArgumentException("Must supply a channel manager if not supplying a controller");
        }
        this.inflightTopics = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

