/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.server.AbstractLogReadResult;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch$;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchLag$;
import kafka.server.LogReadResult;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierLogReadResult;
import kafka.tier.fetcher.PendingFetch;
import kafka.tier.fetcher.TierFetchResult;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.FetchParams;
import org.apache.kafka.storage.internals.log.FetchPartitionData;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogOffsetSnapshot;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\f\u0018\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tc\u0001\u0011\t\u0011)A\u0005e!Aq\t\u0001B\u0001B\u0003%\u0001\n\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!y\u0005A!A!\u0002\u0013\u0001\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011}\u0003!\u0011!Q\u0001\n\u0001D\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\t_\u0002\u0011\t\u0011)A\u0005a\")\u0011\u0010\u0001C\u0001u\"9\u00111\u0002\u0001\u0005B\u00055\u0001bBA\u0013\u0001\u0011%\u0011q\u0005\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u000bBq!!\u0013\u0001\t\u0003\nY\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005m\u0003\u0001\"\u0011\u0002L\u001dI\u0011QL\f\u0002\u0002#\u0005\u0011q\f\u0004\t-]\t\t\u0011#\u0001\u0002b!1\u0011p\u0005C\u0001\u0003SB\u0011\"a\u001b\u0014#\u0003%\t!!\u001c\u0003\u0019\u0011+G.Y=fI\u001a+Go\u00195\u000b\u0005aI\u0012AB:feZ,'OC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005yyR\"A\f\n\u0005\u0001:\"\u0001\u0005#fY\u0006LX\rZ(qKJ\fG/[8o\u0003\u0019\u0001\u0018M]1ngB\u00111eL\u0007\u0002I)\u0011QEJ\u0001\u0004Y><'BA\u0014)\u0003%Ig\u000e^3s]\u0006d7O\u0003\u0002*U\u000591\u000f^8sC\u001e,'B\u0001\u000e,\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\n\u0005A\"#a\u0003$fi\u000eD\u0007+\u0019:b[N\fqBZ3uG\"\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004gaRT\"\u0001\u001b\u000b\u0005U2\u0014AC2pY2,7\r^5p]*\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:i\t\u00191+Z9\u0011\tmbd\bR\u0007\u0002m%\u0011QH\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0013AB2p[6|g.\u0003\u0002D\u0001\n\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003=\u0015K!AR\f\u0003-A\u000b'\u000f^5uS>tg)\u001a;dQ6+G/\u00193bi\u0006\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\u001f\u0013&\u0011!j\u0006\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\tqR*\u0003\u0002O/\ta!+\u001a9mS\u000e\f\u0017+^8uC\u0006aA/[3s\r\u0016$8\r[(qiB\u00191(U*\n\u0005I3$AB(qi&|g\u000e\u0005\u0002U36\tQK\u0003\u0002W/\u00069a-\u001a;dQ\u0016\u0014(B\u0001-\u001a\u0003\u0011!\u0018.\u001a:\n\u0005i+&\u0001\u0004)f]\u0012Lgn\u001a$fi\u000eD\u0017\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\tqR,\u0003\u0002_/\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004BaO1dQ&\u0011!M\u000e\u0002\n\rVt7\r^5p]F\u00022a\r\u001de!\u0011YDHP3\u0011\u0005\r2\u0017BA4%\u0005I1U\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\u0005mJ\u0017B\u000167\u0005\u0011)f.\u001b;\u00029\u0019,Go\u00195QCJ$\u0018\u000e^5p]B\u0013XO\\5oO\u0016s\u0017M\u00197fIB\u00111(\\\u0005\u0003]Z\u0012qAQ8pY\u0016\fg.\u0001\u000ebG\u000e,X.\u001e7bi\u0016$g)\u001a;dQ2\u000bG/\u001a8ds6\u000b\u0007\u000f\u0005\u0003riz2X\"\u0001:\u000b\u0005M$\u0014aB7vi\u0006\u0014G.Z\u0005\u0003kJ\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002<o&\u0011\u0001P\u000e\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0010wrlhp`A\u0001\u0003\u0007\t)!a\u0002\u0002\nA\u0011a\u0004\u0001\u0005\u0006C)\u0001\rA\t\u0005\u0006c)\u0001\rA\r\u0005\u0006\u000f*\u0001\r\u0001\u0013\u0005\u0006\u0017*\u0001\r\u0001\u0014\u0005\u0006\u001f*\u0001\r\u0001\u0015\u0005\u00067*\u0001\r\u0001\u0018\u0005\u0006?*\u0001\r\u0001\u0019\u0005\u0006W*\u0001\r\u0001\u001c\u0005\b_*\u0001\n\u00111\u0001q\u0003!!xn\u0015;sS:<GCAA\b!\u0011\t\t\"a\b\u000f\t\u0005M\u00111\u0004\t\u0004\u0003+1TBAA\f\u0015\r\tIbG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ua'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\t\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;1\u0014a\u00054fi\u000eDwJ\u001a4tKRlU\r^1eCR\fGCBA\u0015\u0003_\t\u0019\u0004E\u0002$\u0003WI1!!\f%\u0005EaunZ(gMN,G/T3uC\u0012\fG/\u0019\u0005\u0007\u0003ca\u0001\u0019\u0001#\u0002\u001b\u0019,Go\u00195NKR\fG-\u0019;b\u0011\u001d\t)\u0004\u0004a\u0001\u0003o\t\u0011\u0002]1si&$\u0018n\u001c8\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u001a\u0003\u001d\u0019G.^:uKJLA!!\u0011\u0002<\tI\u0001+\u0019:uSRLwN\\\u0001\fiJL8i\\7qY\u0016$X\rF\u0001m\u0003eI7OT8o)&,'OR3uG\"\u001cu.\u001c9mKR\f'\r\\3\u0002\u0019=tW\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0003!\fQcY8mY\u0016\u001cG\u000fT8h%\u0016\fGMU3tk2$8\u000f\u0006\u0002\u0002RA!1\u0007OA*!\u0015YDHPA+!\rq\u0012qK\u0005\u0004\u00033:\"!F!cgR\u0014\u0018m\u0019;M_\u001e\u0014V-\u00193SKN,H\u000e^\u0001\u000b_:\u001cu.\u001c9mKR,\u0017\u0001\u0004#fY\u0006LX\r\u001a$fi\u000eD\u0007C\u0001\u0010\u0014'\r\u0019\u00121\r\t\u0004w\u0005\u0015\u0014bAA4m\t1\u0011I\\=SK\u001a$\"!a\u0018\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\tyGK\u0002q\u0003cZ#!a\u001d\u0011\t\u0005U\u0014qP\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003{2\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011QA<\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class DelayedFetch
extends DelayedOperation {
    private final FetchParams params;
    private final Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchPartitions;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Option<PendingFetch> tierFetchOpt;
    private final BrokerTopicStats brokerTopicStats;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;
    private final boolean fetchPartitionPruningEnabled;
    private final HashMap<TopicIdPartition, Object> accumulatedFetchLatencyMap;

    public static HashMap<TopicIdPartition, Object> $lessinit$greater$default$9() {
        return DelayedFetch$.MODULE$.$lessinit$greater$default$9();
    }

    public String toString() {
        return new StringBuilder(37).append("DelayedFetch(params=").append(this.params).append(", numPartitions=").append(this.fetchPartitions.size()).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    private LogOffsetMetadata fetchOffsetMetadata(PartitionFetchMetadata fetchMetadata, Partition partition) {
        void var3_3;
        LogOffsetMetadata fetchOffsetMetadata;
        LogOffsetMetadata logOffsetMetadata = fetchOffsetMetadata = fetchMetadata.fetchOffsetMetadata();
        LogOffsetMetadata logOffsetMetadata2 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
        if ((logOffsetMetadata == null ? logOffsetMetadata2 != null : !logOffsetMetadata.equals(logOffsetMetadata2)) && fetchOffsetMetadata.messageOffsetOnly()) {
            long fetchOffset = fetchMetadata.fetchOffset();
            fetchOffsetMetadata = (LogOffsetMetadata)partition.convertToLocalOffsetMetadata(fetchOffset).getOrElse((Function0 & Serializable & scala.Serializable)() -> LogOffsetMetadata.UNKNOWN_OFFSET_METADATA);
            fetchMetadata.setFetchOffsetMetadata(fetchOffsetMetadata);
        }
        return var3_3;
    }

    @Override
    public boolean tryComplete() {
        boolean bl;
        Option<PendingFetch> option = this.tierFetchOpt;
        if (option instanceof Some) {
            bl = ((PendingFetch)((Some)option).value()).isComplete() ? this.forceComplete() : false;
        } else if (None$.MODULE$.equals(option)) {
            bl = this.isNonTierFetchCompletable() ? this.forceComplete() : false;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    private boolean isNonTierFetchCompletable() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchPartitions.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$isNonTierFetchCompletable$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (accumulatedSize.elem < this.params.minBytes) {
                return false;
            }
            bl = true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        this.tierFetchOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.markFetchExpired();
            return BoxedUnit.UNIT;
        });
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    private Seq<Tuple2<TopicIdPartition, AbstractLogReadResult>> collectLogReadResults() {
        return this.replicaManager.readFromLocalLog(this.params, this.fetchPartitions, this.quota, true);
    }

    @Override
    public void onComplete() {
        Option tierFetcherReadResults = this.tierFetchOpt.map((Function1 & Serializable & scala.Serializable)x$2 -> (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$2.finish()).asScala());
        Seq fetchPartitionData = (Seq)this.collectLogReadResults().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            LogReadResult logReadResult;
            if (x0$1 == null) throw new MatchError(null);
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            AbstractLogReadResult logReadResult2 = (AbstractLogReadResult)x0$1._2();
            long tierFetchTime = 0L;
            if (logReadResult2 instanceof TierLogReadResult) {
                TierLogReadResult tierLogReadResult = (TierLogReadResult)logReadResult2;
                TierFetchResult tierFetchResult = (TierFetchResult)tierFetcherReadResults.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)tp.topicPartition())).getOrElse((Function0 & Serializable & scala.Serializable)() -> TierFetchResult.emptyFetchResult());
                tierFetchTime = tierFetchResult.fetchTotalTimeNanos;
                logReadResult = tierLogReadResult.intoLogReadResult(tierFetchResult, !tierFetchResult.isEmpty());
            } else {
                if (!(logReadResult2 instanceof LogReadResult)) throw new MatchError((Object)logReadResult2);
                logReadResult = (LogReadResult)logReadResult2;
            }
            FetchLag$.MODULE$.maybeRecordConsumerFetchTimeLag(!$this.params.isFromFollower(), logReadResult, $this.brokerTopicStats);
            boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)logReadResult.toFetchPartitionData(isReassignmentFetch, BoxesRunTime.unboxToLong((Object)$this.accumulatedFetchLatencyMap.getOrElse((Object)tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), tierFetchTime));
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final /* synthetic */ void $anonfun$isNonTierFetchCompletable$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition topicIdPartition = (TopicIdPartition)x0$1._1();
            PartitionFetchMetadata fetchPartition = (PartitionFetchMetadata)x0$1._2();
            if (!$this.fetchPartitionPruningEnabled || !fetchPartition.isCaughtUp()) {
                Optional<Integer> fetchLeaderEpoch = fetchPartition.currentLeaderEpoch();
                try {
                    LogOffsetMetadata logOffsetMetadata;
                    LogOffsetMetadata fetchOffset;
                    Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
                    LogOffsetMetadata logOffsetMetadata2 = fetchOffset = $this.fetchOffsetMetadata(fetchPartition, partition);
                    LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata.UNKNOWN_OFFSET_METADATA;
                    if (logOffsetMetadata2 == null) {
                        if (logOffsetMetadata3 == null) return;
                    } else if (logOffsetMetadata2.equals(logOffsetMetadata3)) return;
                    LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader(fetchLeaderEpoch));
                    FetchIsolation fetchIsolation = $this.params.isolation;
                    if (FetchIsolation.LOG_END.equals(fetchIsolation)) {
                        logOffsetMetadata = offsetSnapshot.logEndOffset;
                    } else if (FetchIsolation.HIGH_WATERMARK.equals(fetchIsolation)) {
                        logOffsetMetadata = offsetSnapshot.highWatermark;
                    } else {
                        if (!FetchIsolation.TXN_COMMITTED.equals(fetchIsolation)) throw new MatchError((Object)fetchIsolation);
                        logOffsetMetadata = offsetSnapshot.lastStableOffset;
                    }
                    if (logOffsetMetadata.messageOffset != fetchOffset.messageOffset) {
                        if (logOffsetMetadata.onOlderSegment(fetchOffset)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this).append(" since it is fetching later segments of partition ").append(topicIdPartition).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                        }
                        if (fetchOffset.onOlderSegment(logOffsetMetadata)) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Satisfying fetch ").append($this).append(" immediately since it is fetching older segments of partition ").append(topicIdPartition).append(".").toString());
                            if (!$this.params.isFromFollower()) throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                            if (!$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                            }
                        } else if (fetchOffset.messageOffset < logOffsetMetadata.messageOffset) {
                            int bytesAvailable = package$.MODULE$.min(logOffsetMetadata.positionDiff(fetchOffset), fetchPartition.maxBytes());
                            if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId)) {
                                accumulatedSize$1.elem += bytesAvailable;
                                if (accumulatedSize$1.elem >= $this.params.minBytes) {
                                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                                }
                            }
                        }
                    }
                    fetchPartition.lastFetchedEpoch().ifPresent(fetchEpoch -> {
                        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                        if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Could not obtain last offset for leader epoch for partition ").append(topicIdPartition).append(", epochEndOffset=").append(epochEndOffset).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                        }
                        if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchPartition.fetchOffset()) {
                            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Satisfying fetch ").append($this).append(" since it has diverging epoch requiring truncation for partition ").append(topicIdPartition).append(" epochEndOffset=").append(epochEndOffset).append(" fetchEpoch=").append(fetchEpoch).append(" fetchOffset=").append(fetchPartition.fetchOffset()).append(".").toString());
                            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                        }
                    });
                    return;
                }
                catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Broker is no longer the leader or follower of ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
                catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
                catch (KafkaStorageException kafkaStorageException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicIdPartition).append(" is in an offline log directory, satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
                catch (FencedLeaderEpochException fencedLeaderEpochException) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicIdPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this).append(" immediately").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
                }
            }
        }
        if (x0$1 == null) return;
        TopicIdPartition topicPartition = (TopicIdPartition)x0$1._1();
        PartitionFetchMetadata fetchInfo = (PartitionFetchMetadata)x0$1._2();
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Ignored caught-up partition ").append(topicPartition).append(" with ").append(fetchInfo).append(" for replica ").append($this.params.replicaId).append(".").toString());
    }

    public DelayedFetch(FetchParams params, Seq<Tuple2<TopicIdPartition, PartitionFetchMetadata>> fetchPartitions, ReplicaManager replicaManager, ReplicaQuota quota, Option<PendingFetch> tierFetchOpt, BrokerTopicStats brokerTopicStats, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback, boolean fetchPartitionPruningEnabled, HashMap<TopicIdPartition, Object> accumulatedFetchLatencyMap) {
        this.params = params;
        this.fetchPartitions = fetchPartitions;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.tierFetchOpt = tierFetchOpt;
        this.brokerTopicStats = brokerTopicStats;
        this.responseCallback = responseCallback;
        this.fetchPartitionPruningEnabled = fetchPartitionPruningEnabled;
        this.accumulatedFetchLatencyMap = accumulatedFetchLatencyMap;
        super(params.maxWaitMs, DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

