/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchContext$;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.PartitionFetchMetadata;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001E4A\u0001C\u0005\u0001\u001d!A1\u0004\u0001BC\u0002\u0013%A\u0004\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003\u001e\u0011!Q\u0003A!b\u0001\n\u0013Y\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000bE\u0002A\u0011\u0001\u001a\t\u000bY\u0002A\u0011A\u001c\t\u000bY\u0003A\u0011A,\u0003\u0019\u0019+Go\u00195NC:\fw-\u001a:\u000b\u0005)Y\u0011AB:feZ,'OC\u0001\r\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011a#G\u0007\u0002/)\u0011\u0001dC\u0001\u0006kRLGn]\u0005\u00035]\u0011q\u0001T8hO&tw-\u0001\u0003uS6,W#A\u000f\u0011\u0005y9S\"A\u0010\u000b\u0005a\u0001#BA\u0011#\u0003\u0019\u0019w.\\7p]*\u0011Ab\t\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014x-\u0003\u0002)?\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u0015\u0019\u0017m\u00195f+\u0005a\u0003CA\u0017/\u001b\u0005I\u0011BA\u0018\n\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.Z\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\rqJg.\u001b;?)\r\u0019D'\u000e\t\u0003[\u0001AQaG\u0003A\u0002uAQAK\u0003A\u00021\n!B\\3x\u0007>tG/\u001a=u)\u0015A4\b\u0011%N!\ti\u0013(\u0003\u0002;\u0013\taa)\u001a;dQ\u000e{g\u000e^3yi\")AH\u0002a\u0001{\u0005\u0019b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]B\u0011\u0001CP\u0005\u0003\u007fE\u0011Qa\u00155peRDQ!\u0011\u0004A\u0002\t\u000bABZ3uG\"\u0014V-];fgR\u0004\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0011\u0002\u000f5,7o]1hK&\u0011q\t\u0012\u0002\u0011\r\u0016$8\r\u001b*fcV,7\u000f\u001e#bi\u0006DQ!\u0013\u0004A\u0002)\u000b!\"[:G_2dwn^3s!\t\u00012*\u0003\u0002M#\t9!i\\8mK\u0006t\u0007\"\u0002(\u0007\u0001\u0004y\u0015A\u0003;pa&\u001cg*Y7fgB\u0011\u0001k\u0015\b\u0003[EK!AU\u0005\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\u0005Q+&A\u0004+P!&\u001buLT!N\u000b~k\u0015\t\u0015\u0006\u0003%&\tQ\u0003]1si&$\u0018n\u001c8t)>dunZ*ue&tw\r\u0006\u0002YGB\u0011\u0011\f\u0019\b\u00035z\u0003\"aW\t\u000e\u0003qS!!X\u0007\u0002\rq\u0012xn\u001c;?\u0013\ty\u0016#\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0\u0012\u0011\u0015!w\u00011\u0001f\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004M.lW\"A4\u000b\u0005!L\u0017\u0001B;uS2T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\nQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u00059|W\"\u0001\u0011\n\u0005A\u0004#\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o\u0001")
public class FetchManager
implements Logging {
    private final Time time;
    private final FetchSessionCache cache;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    /*
     * WARNING - void declaration
     */
    public FetchContext newContext(short fetchRequestVersion, FetchRequestData fetchRequest, boolean isFollower, Map<Uuid, String> topicNames) {
        boolean fetchRequestUsesTopicIds;
        int sessionId = fetchRequest.sessionId();
        int sessionEpoch = fetchRequest.sessionEpoch();
        boolean bl = fetchRequestUsesTopicIds = fetchRequestVersion >= 13;
        if (sessionEpoch == 0 || sessionEpoch == -1) {
            FetchContext fetchContext;
            ObjectRef removedFetchSessionStr = ObjectRef.create((Object)"");
            if (sessionId != 0 && this.cache().remove(sessionId).isDefined()) {
                removedFetchSessionStr.elem = new StringBuilder(24).append(" Removed fetch session ").append(sessionId).append(".").toString();
            }
            Map<TopicIdPartition, PartitionFetchMetadata> fetchPartitions = FetchContext$.MODULE$.createFetchPartitions(fetchRequestUsesTopicIds, fetchRequest, topicNames);
            ObjectRef suffix = ObjectRef.create((Object)"");
            if (sessionEpoch == -1) {
                suffix.elem = " Will not try to create a new session.";
                fetchContext = new SessionlessFetchContext(fetchPartitions);
            } else {
                fetchContext = new FullFetchContext(this.time(), this.cache(), fetchPartitions, fetchRequestUsesTopicIds, isFollower);
            }
            FetchContext context = fetchContext;
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Created a new full FetchContext with ").append(this.partitionsToLogString(fetchPartitions.keySet())).append(".").append((String)removedFetchSessionStr$1.elem).append((String)suffix$1.elem).toString());
            return context;
        }
        FetchSessionCache fetchSessionCache = this.cache();
        synchronized (fetchSessionCache) {
            SessionErrorContext sessionErrorContext;
            Option<FetchSession> option = this.cache().get(sessionId);
            if (None$.MODULE$.equals(option)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Session error for ").append(sessionId).append(": no such session ID found.").toString());
                sessionErrorContext = new SessionErrorContext(Errors.FETCH_SESSION_ID_NOT_FOUND);
            } else if (option instanceof Some) {
                SessionErrorContext sessionErrorContext2;
                FetchSession session = (FetchSession)((Some)option).value();
                synchronized (session) {
                    FetchContext fetchContext;
                    if (session.epoch() != sessionEpoch) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Session error for ").append(sessionId).append(": expected epoch ").append(session.epoch()).append(", but got ").append(sessionEpoch).append(" instead.").toString());
                        fetchContext = new SessionErrorContext(Errors.INVALID_FETCH_SESSION_EPOCH);
                    } else if (session.usesTopicIds() && !fetchRequestUsesTopicIds || !session.usesTopicIds() && fetchRequestUsesTopicIds) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Session error for ").append(sessionId).append(": expected  ").append((Object)(session.usesTopicIds() ? "to use topic IDs" : "to not use topic IDs")).append(", but request version ").append(fetchRequestVersion).append(" means that we can not.").toString());
                        fetchContext = new SessionErrorContext(Errors.FETCH_SESSION_TOPIC_ID_ERROR);
                    } else {
                        void var20_19;
                        void var19_18;
                        void var18_17;
                        Tuple3<ArrayList<TopicIdPartition>, ArrayList<TopicIdPartition>, ArrayList<TopicIdPartition>> tuple3 = session.update(fetchRequestUsesTopicIds, fetchRequest, topicNames);
                        if (tuple3 == null) {
                            throw new MatchError(null);
                        }
                        ArrayList added = (ArrayList)tuple3._1();
                        ArrayList updated = (ArrayList)tuple3._2();
                        ArrayList removed = (ArrayList)tuple3._3();
                        void added2 = var18_17;
                        void updated2 = var19_18;
                        void removed2 = var20_19;
                        if (session.isEmpty()) {
                            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> FetchManager.$anonfun$newContext$5(this, session, (ArrayList)removed2)));
                            this.cache().remove(session);
                            Map<TopicIdPartition, PartitionFetchMetadata> fetchData = FetchContext$.MODULE$.createFetchPartitions(fetchRequestUsesTopicIds, fetchRequest, topicNames);
                            fetchContext = new SessionlessFetchContext(fetchData);
                        } else {
                            this.cache().touch(session, this.time().milliseconds());
                            session.epoch_$eq(FetchMetadata.nextEpoch((int)session.epoch()));
                            this.debug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> FetchManager.$anonfun$newContext$6(this, session, (ArrayList)added2, (ArrayList)updated2, (ArrayList)removed2)));
                            fetchContext = new IncrementalFetchContext(this.time(), sessionEpoch, session, topicNames);
                        }
                    }
                    sessionErrorContext2 = fetchContext;
                }
                sessionErrorContext = sessionErrorContext2;
            } else {
                throw new MatchError(option);
            }
            return sessionErrorContext;
        }
    }

    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchSession$.MODULE$.partitionsToLogString(partitions, this.isTraceEnabled());
    }

    public static final /* synthetic */ String $anonfun$newContext$5(FetchManager $this, FetchSession session$2, ArrayList removed$2) {
        return new StringBuilder(123).append("Created a new sessionless FetchContext and closing session id ").append(session$2.id()).append(", ").append("epoch ").append(session$2.epoch()).append(": after removing ").append($this.partitionsToLogString(removed$2)).append(", ").append("there are no more partitions left.").toString();
    }

    public static final /* synthetic */ String $anonfun$newContext$6(FetchManager $this, FetchSession session$2, ArrayList added$2, ArrayList updated$2, ArrayList removed$2) {
        return new StringBuilder(90).append("Created a new incremental FetchContext for session id ").append(session$2.id()).append(", ").append("epoch ").append(session$2.epoch()).append(": added ").append($this.partitionsToLogString(added$2)).append(", ").append("updated ").append($this.partitionsToLogString(updated$2)).append(", ").append("removed ").append($this.partitionsToLogString(removed$2)).toString();
    }

    public FetchManager(Time time, FetchSessionCache cache) {
        this.time = time;
        this.cache = cache;
        Logging.$init$(this);
    }
}

