/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kafka.server.EvictableKey;
import kafka.server.FetchSession;
import kafka.server.FetchSession$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0011#\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0006\u0004%I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013%1\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d1\u0005A1A\u0005\n\u001dCa\u0001\u0016\u0001!\u0002\u0013A\u0005bB+\u0001\u0001\u0004%Ia\u000f\u0005\b-\u0002\u0001\r\u0011\"\u0003X\u0011\u0019i\u0006\u0001)Q\u0005y!9!\r\u0001b\u0001\n\u0013\u0019\u0007BB8\u0001A\u0003%A\rC\u0004q\u0001\u0001\u0007I\u0011A\u001b\t\u000fE\u0004\u0001\u0019!C\u0001e\"1A\u000f\u0001Q!\nYBqA\u001e\u0001C\u0002\u0013%q\u000f\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u001f\u0005\b\u007f\u0002\u0011\r\u0011\"\u0003x\u0011\u001d\t\t\u0001\u0001Q\u0001\naD!\"a\u0001\u0001\u0005\u0004%\tAIA\u0003\u0011!\ti\u0002\u0001Q\u0001\n\u0005\u001d\u0001BCA\u0010\u0001\t\u0007I\u0011\u0001\u0012\u0002\u0006!A\u0011\u0011\u0005\u0001!\u0002\u0013\t9\u0001C\u0004\u0002$\u0001!\t!!\n\t\r\u0005E\u0002\u0001\"\u00016\u0011\u0019\t\u0019\u0004\u0001C\u0001w!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\u001d\u0001\u0011\u0005\u00111\b\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!!\u001e\u0001\t\u0003\tY\bC\u0004\u0002\u0002\u0002!\t!a!\u0003#\u0019+Go\u00195TKN\u001c\u0018n\u001c8DC\u000eDWM\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E\"\u0013!B;uS2\u001c\u0018BA\u001a1\u0005\u001daunZ4j]\u001e\f!\"\\1y\u000b:$(/[3t+\u00051\u0004CA\u00158\u0013\tA$FA\u0002J]R\f1\"\\1y\u000b:$(/[3tA\u0005QQM^5di&|g.T:\u0016\u0003q\u0002\"!K\u001f\n\u0005yR#\u0001\u0002'p]\u001e\f1\"\u001a<jGRLwN\\'tA\u00051A(\u001b8jiz\"2A\u0011#F!\t\u0019\u0005!D\u0001#\u0011\u0015!T\u00011\u00017\u0011\u0015QT\u00011\u0001=\u00031iW\r\u001e:jGN<%o\\;q+\u0005A\u0005CA%S\u001b\u0005Q%BA&M\u0003\u001diW\r\u001e:jGNT!aI'\u000b\u0005\u0015r%BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001eL!a\u0015&\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002#9,X\u000eU1si&$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002Y7B\u0011\u0011&W\u0005\u00035*\u0012A!\u00168ji\"9A,CA\u0001\u0002\u0004a\u0014a\u0001=%c\u0005qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0003F\u0001\u0006`!\tI\u0003-\u0003\u0002bU\tAao\u001c7bi&dW-\u0001\u0005tKN\u001c\u0018n\u001c8t+\u0005!\u0007\u0003B3km1l\u0011A\u001a\u0006\u0003O\"\fA!\u001e;jY*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u00055a\u0015N\\6fI\"\u000b7\u000f['baB\u00111)\\\u0005\u0003]\n\u0012ABR3uG\"\u001cVm]:j_:\f\u0011b]3tg&|gn\u001d\u0011\u0002\u0019M,7o]5p]N\u001c\u0016N_3\u0002!M,7o]5p]N\u001c\u0016N_3`I\u0015\fHC\u0001-t\u0011\u001daf\"!AA\u0002Y\nQb]3tg&|gn]*ju\u0016\u0004\u0003FA\b`\u00039)g/[2uC\ndWMQ=BY2,\u0012\u0001\u001f\t\u0005Kf\\H.\u0003\u0002{M\n9AK]3f\u001b\u0006\u0004\bCA\"}\u0013\ti(E\u0001\u0007Fm&\u001cG/\u00192mK.+\u00170A\bfm&\u001cG/\u00192mK\nK\u0018\t\u001c7!\u0003U)g/[2uC\ndWMQ=Qe&4\u0018\u000e\\3hK\u0012\fa#\u001a<jGR\f'\r\\3CsB\u0013\u0018N^5mK\u001e,G\rI\u0001\u000fKZL7\r^5p]NlU\r^3s+\t\t9\u0001\u0005\u0003\u0002\n\u0005eQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\t\r|'/\u001a\u0006\u0004\u0017\u0006E!\u0002BA\n\u0003+\ta!_1n[\u0016\u0014(BAA\f\u0003\r\u0019w.\\\u0005\u0005\u00037\tYAA\u0003NKR,'/A\bfm&\u001cG/[8og6+G/\u001a:!\u0003m\t7\r^5wKN+7o]5p]\u00163\u0018n\u0019;j_:\u001cX*\u001a;fe\u0006a\u0012m\u0019;jm\u0016\u001cVm]:j_:,e/[2uS>t7/T3uKJ\u0004\u0013aA4fiR!\u0011qEA\u0017!\u0011I\u0013\u0011\u00067\n\u0007\u0005-\"F\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003_A\u0002\u0019\u0001\u001c\u0002\u0013M,7o]5p]&#\u0017\u0001B:ju\u0016\fq\u0002^8uC2\u0004\u0016M\u001d;ji&|gn]\u0001\r]\u0016<8+Z:tS>t\u0017\n\u001a\u000b\u0002m\u0005\u0011R.Y=cK\u000e\u0013X-\u0019;f'\u0016\u001c8/[8o)-1\u0014QHA!\u0003\u0017\ni%!\u0015\t\r\u0005}B\u00041\u0001=\u0003\rqwn\u001e\u0005\b\u0003\u0007b\u0002\u0019AA#\u0003)\u0001(/\u001b<jY\u0016<W\r\u001a\t\u0004S\u0005\u001d\u0013bAA%U\t9!i\\8mK\u0006t\u0007BBA\u00199\u0001\u0007a\u0007C\u0004\u0002Pq\u0001\r!!\u0012\u0002\u0019U\u001cXm\u001d+pa&\u001c\u0017\nZ:\t\u000f\u0005MC\u00041\u0001\u0002V\u0005\u00012M]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\t\u0006S\u0005]\u00131L\u0005\u0004\u00033R#!\u0003$v]\u000e$\u0018n\u001c81!\u0011\ti&a\u0019\u000f\u0007\r\u000by&C\u0002\u0002b\t\nABR3uG\"\u001cVm]:j_:LA!!\u001a\u0002h\tI1)Q\"I\u000b~k\u0015\t\u0015\u0006\u0004\u0003C\u0012\u0013\u0001\u0003;ss\u00163\u0018n\u0019;\u0015\u0011\u0005\u0015\u0013QNA8\u0003gBq!a\u0011\u001e\u0001\u0004\t)\u0005\u0003\u0004\u0002ru\u0001\ra_\u0001\u0004W\u0016L\bBBA ;\u0001\u0007A(\u0001\u0004sK6|g/\u001a\u000b\u0005\u0003O\tI\b\u0003\u0004\u00020y\u0001\rA\u000e\u000b\u0005\u0003O\ti\b\u0003\u0004\u0002\u0000}\u0001\r\u0001\\\u0001\bg\u0016\u001c8/[8o\u0003\u0015!x.^2i)\u0015A\u0016QQAD\u0011\u0019\ty\b\ta\u0001Y\"1\u0011q\b\u0011A\u0002q\u0002")
public class FetchSessionCache
implements Logging {
    private final int maxEntries;
    private final long evictionMs;
    private final KafkaMetricsGroup metricsGroup;
    private volatile long numPartitions;
    private final LinkedHashMap<Object, FetchSession> sessions;
    private volatile int sessionsSize;
    private final TreeMap<EvictableKey, FetchSession> evictableByAll;
    private final TreeMap<EvictableKey, FetchSession> evictableByPrivileged;
    private final Meter evictionsMeter;
    private final Meter activeSessionEvictionsMeter;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int maxEntries() {
        return this.maxEntries;
    }

    private long evictionMs() {
        return this.evictionMs;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private long numPartitions() {
        return this.numPartitions;
    }

    private void numPartitions_$eq(long x$1) {
        this.numPartitions = x$1;
    }

    private LinkedHashMap<Object, FetchSession> sessions() {
        return this.sessions;
    }

    public int sessionsSize() {
        return this.sessionsSize;
    }

    public void sessionsSize_$eq(int x$1) {
        this.sessionsSize = x$1;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByAll() {
        return this.evictableByAll;
    }

    private TreeMap<EvictableKey, FetchSession> evictableByPrivileged() {
        return this.evictableByPrivileged;
    }

    public Meter evictionsMeter() {
        return this.evictionsMeter;
    }

    public Meter activeSessionEvictionsMeter() {
        return this.activeSessionEvictionsMeter;
    }

    public synchronized Option<FetchSession> get(int sessionId) {
        return Option$.MODULE$.apply((Object)this.sessions().get(BoxesRunTime.boxToInteger((int)sessionId)));
    }

    public int size() {
        return this.sessionsSize();
    }

    public long totalPartitions() {
        return this.numPartitions();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int newSessionId() {
        void var1_1;
        int id;
        do {
            id = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        } while (this.sessions().containsKey(BoxesRunTime.boxToInteger((int)id)) || id == 0);
        return (int)var1_1;
    }

    public synchronized int maybeCreateSession(long now, boolean privileged, int size, boolean usesTopicIds, Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>> createPartitions) {
        if (this.sessionsSize() < this.maxEntries() || this.tryEvict(privileged, new EvictableKey(privileged, size, 0), now)) {
            ImplicitLinkedHashCollection partitionMap = (ImplicitLinkedHashCollection)createPartitions.apply();
            FetchSession session = new FetchSession(this.newSessionId(), privileged, (ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>)partitionMap, usesTopicIds, now, now, FetchMetadata.nextEpoch((int)0));
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Created fetch session ").append(session.toString()).toString());
            this.touch(session, now);
            return session.id();
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("No fetch session created for privileged=").append(privileged).append(", size=").append(size).append(".").toString());
        return 0;
    }

    public synchronized boolean tryEvict(boolean privileged, EvictableKey key, long now) {
        Iterator<Map.Entry<Object, FetchSession>> sessionIterator = this.sessions().entrySet().iterator();
        if (!sessionIterator.hasNext()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "There are no cache entries to evict.");
            return false;
        }
        FetchSession lastUsedSession = sessionIterator.next().getValue();
        if (now - lastUsedSession.lastUsedMs() > this.evictionMs()) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Evicting stale FetchSession ").append(lastUsedSession.id()).append(".").toString());
            this.remove(lastUsedSession);
            this.evictionsMeter().mark();
            return true;
        }
        if (privileged) {
            return this.evictEntry$1(key, this.evictableByPrivileged());
        }
        return this.evictEntry$1(key, this.evictableByAll());
    }

    public synchronized Option<FetchSession> remove(int sessionId) {
        Option<FetchSession> option;
        Option<FetchSession> option2 = this.get(sessionId);
        if (None$.MODULE$.equals(option2)) {
            option = None$.MODULE$;
        } else if (option2 instanceof Some) {
            FetchSession session = (FetchSession)((Some)option2).value();
            option = this.remove(session);
        } else {
            throw new MatchError(option2);
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized Option<FetchSession> remove(FetchSession session) {
        void var2_3;
        synchronized (session) {
            EvictableKey evictableKey = session.evictableKey();
            if (!session.privileged()) {
                this.evictableByAll().remove(evictableKey);
            }
            this.evictableByPrivileged().remove(evictableKey);
            Option result = Option$.MODULE$.apply(this.sessions().remove(BoxesRunTime.boxToInteger((int)session.id())));
            if (result.isDefined()) {
                session.close();
                this.numPartitions_$eq(this.numPartitions() - (long)session.cachedSize());
            }
        }
        this.sessionsSize_$eq(this.sessions().size());
        return var2_3;
    }

    public synchronized void touch(FetchSession session, long now) {
        synchronized (session) {
            this.sessions().remove(BoxesRunTime.boxToInteger((int)session.id()));
            session.lastUsedMs_$eq(now);
            this.sessions().put(BoxesRunTime.boxToInteger((int)session.id()), session);
            int oldSize = session.cachedSize();
            if (oldSize != -1) {
                EvictableKey oldEvictableKey = session.evictableKey();
                this.evictableByPrivileged().remove(oldEvictableKey);
                this.evictableByAll().remove(oldEvictableKey);
                this.numPartitions_$eq(this.numPartitions() - (long)oldSize);
            }
            session.cachedSize_$eq(session.size());
            EvictableKey newEvictableKey = session.evictableKey();
            if (!session.privileged() || now - session.creationMs() > this.evictionMs()) {
                this.evictableByPrivileged().put(newEvictableKey, session);
            }
            if (!session.privileged() && now - session.creationMs() > this.evictionMs()) {
                this.evictableByAll().put(newEvictableKey, session);
            }
            this.numPartitions_$eq(this.numPartitions() + (long)session.cachedSize());
        }
        this.sessionsSize_$eq(this.sessions().size());
    }

    public final /* synthetic */ int kafka$server$FetchSessionCache$$$anonfun$new$1() {
        return this.size();
    }

    public final /* synthetic */ long kafka$server$FetchSessionCache$$$anonfun$new$2() {
        return this.totalPartitions();
    }

    private final boolean evictEntry$1(EvictableKey key, TreeMap map) {
        Map.Entry evictableEntry = map.firstEntry();
        if (evictableEntry == null) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No evictable entries found.");
            return false;
        }
        if (key.compareTo((EvictableKey)evictableEntry.getKey()) < 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Can't evict ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).toString());
            return false;
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Evicting ").append(evictableEntry.getKey()).append(" with ").append(key.toString()).append(".").toString());
        this.remove((FetchSession)evictableEntry.getValue());
        this.evictionsMeter().mark();
        this.activeSessionEvictionsMeter().mark();
        return true;
    }

    public FetchSessionCache(int maxEntries, long evictionMs) {
        this.maxEntries = maxEntries;
        this.evictionMs = evictionMs;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.numPartitions = 0L;
        this.sessions = new LinkedHashMap();
        this.sessionsSize = 0;
        this.evictableByAll = new TreeMap();
        this.evictableByPrivileged = new TreeMap();
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS());
        this.metricsGroup().newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_SESSIONS(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final int value() {
                return this.$outer.kafka$server$FetchSessionCache$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED());
        this.metricsGroup().newGauge(FetchSession$.MODULE$.NUM_INCREMENTAL_FETCH_PARTITIONS_CACHED(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ FetchSessionCache $outer;

            public final long value() {
                return this.$outer.kafka$server$FetchSessionCache$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC());
        this.evictionsMeter = this.metricsGroup().newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, Collections.emptyMap());
        this.metricsGroup().removeMetric(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC());
        this.activeSessionEvictionsMeter = this.metricsGroup().newMeter(FetchSession$.MODULE$.INCREMENTAL_FETCH_SESSIONS_ACTIVE_SESSION_EVICTIONS_PER_SEC(), FetchSession$.MODULE$.EVICTIONS(), TimeUnit.SECONDS, Collections.emptyMap());
    }
}

