/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u000e\u001d\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0006\u0004%I!\f\u0005\tw\u0001\u0011\t\u0011)A\u0005]!AA\b\u0001BC\u0002\u0013%Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003?\u0011!\u0011\u0005A!b\u0001\n\u0013\u0019\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011!\u0003!Q1A\u0005\n%C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u0006%\u0002!\ta\u0015\u0005\u00063\u0002!\tE\u0017\u0005\u0006O\u0002!\t\u0005\u001b\u0004\u0005i\u0002!Q\u000f\u0003\u0006\u0002\u00041\u0011)\u0019!C\u0001\u0003\u000bA\u0011\"a\u0002\r\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0015\u0005%AB!b\u0001\n\u0003\tY\u0001\u0003\u0006\u0002\u00141\u0011\t\u0011)A\u0005\u0003\u001bAaA\u0015\u0007\u0005\u0002\u0005U\u0001bCA\u0010\u0019\u0001\u0007\t\u0019!C\u0001\u0003CA1\"a\u0014\r\u0001\u0004\u0005\r\u0011\"\u0001\u0002R!Y\u0011q\u000b\u0007A\u0002\u0003\u0005\u000b\u0015BA\u0012\u0011\u001d\tI\u0006\u0004C!\u00037Bq!!\u0018\r\t\u0003\ny\u0006C\u0004\u0002b1!\t%a\u0019\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0002\u0018\u0013:\u001c'/Z7f]R\fGNR3uG\"\u001cuN\u001c;fqRT!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0004\u0001\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#AB!osJ+g\r\u0005\u0002*U5\tA$\u0003\u0002,9\taa)\u001a;dQ\u000e{g\u000e^3yi\u0006!A/[7f+\u0005q\u0003CA\u0018:\u001b\u0005\u0001$BA\u00193\u0003\u0015)H/\u001b7t\u0015\t\u0019D'\u0001\u0004d_6lwN\u001c\u0006\u0003?UR!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO&\u0011!\b\r\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\u0007sKF,Xm\u001d;Fa>\u001c\u0007.F\u0001?!\t\u0019s(\u0003\u0002AI\t\u0019\u0011J\u001c;\u0002\u001bI,\u0017/^3ti\u0016\u0003xn\u00195!\u0003\u001d\u0019Xm]:j_:,\u0012\u0001\u0012\t\u0003S\u0015K!A\u0012\u000f\u0003\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\u0002\u0011M,7o]5p]\u0002\n!\u0002^8qS\u000et\u0015-\\3t+\u0005Q\u0005CA&O\u001d\tIC*\u0003\u0002N9\u0005aa)\u001a;dQN+7o]5p]&\u0011q\n\u0015\u0002\u000f)>\u0003\u0016jQ0O\u00036+u,T!Q\u0015\tiE$A\u0006u_BL7MT1nKN\u0004\u0013A\u0002\u001fj]&$h\bF\u0003U+Z;\u0006\f\u0005\u0002*\u0001!)A&\u0003a\u0001]!)A(\u0003a\u0001}!)!)\u0003a\u0001\t\")\u0001*\u0003a\u0001\u0015\u0006qq-\u001a;GKR\u001c\u0007n\u00144gg\u0016$HCA.b!\r\u0019CLX\u0005\u0003;\u0012\u0012aa\u00149uS>t\u0007CA\u0012`\u0013\t\u0001GE\u0001\u0003M_:<\u0007\"\u00022\u000b\u0001\u0004\u0019\u0017A\u0001;q!\t!W-D\u00013\u0013\t1'G\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0003S2\u0004\"a\t6\n\u0005-$#\u0001B+oSRDQ!\\\u0006A\u00029\f1AZ;o!\u0015\u0019snY9j\u0013\t\u0001HEA\u0005Gk:\u001cG/[8oeA\u0011\u0011F]\u0005\u0003gr\u0011a\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007.T3uC\u0012\fG/\u0019\u0002\u0012!\u0006\u0014H/\u001b;j_:LE/\u001a:bi>\u00148c\u0001\u0007w}B\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0005Y\u0006twMC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uD(AB(cU\u0016\u001cG\u000f\u0005\u0002L\u007f&\u0019\u0011\u0011\u0001)\u0003\u001bI+5\u000bU0N\u0003B{\u0016\nV#S\u0003\u0011IG/\u001a:\u0016\u0003y\fQ!\u001b;fe\u0002\nQ%\u001e9eCR,g)\u001a;dQ\u000e{g\u000e^3yi\u0006sGMU3n_Z,WK\\:fY\u0016\u001cG/\u001a3\u0016\u0005\u00055\u0001cA\u0012\u0002\u0010%\u0019\u0011\u0011\u0003\u0013\u0003\u000f\t{w\u000e\\3b]\u00061S\u000f\u001d3bi\u00164U\r^2i\u0007>tG/\u001a=u\u0003:$'+Z7pm\u0016,fn]3mK\u000e$X\r\u001a\u0011\u0015\r\u0005]\u00111DA\u000f!\r\tI\u0002D\u0007\u0002\u0001!1\u00111A\tA\u0002yDq!!\u0003\u0012\u0001\u0004\ti!A\u0006oKb$X\t\\3nK:$XCAA\u0012!\u001d\t)#!\u000ed\u0003wqA!a\n\u000209!\u0011\u0011FA\u0016\u001b\u0005Q\u0018bAA\u0017u\u0006!Q\u000f^5m\u0013\u0011\t\t$a\r\u0002\u00075\u000b\u0007OC\u0002\u0002.iLA!a\u000e\u0002:\t)QI\u001c;ss*!\u0011\u0011GA\u001a!\u0011\ti$!\u0013\u000f\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u00113\u0003\u001diWm]:bO\u0016LA!a\u0012\u0002B\u0005\tb)\u001a;dQJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005-\u0013Q\n\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u0005\u001d\u0013\u0011I\u0001\u0010]\u0016DH/\u00127f[\u0016tGo\u0018\u0013fcR\u0019\u0011.a\u0015\t\u0013\u0005U3#!AA\u0002\u0005\r\u0012a\u0001=%c\u0005aa.\u001a=u\u000b2,W.\u001a8uA\u00059\u0001.Y:OKb$HCAA\u0007\u0003\u0011qW\r\u001f;\u0015\u0005\u0005\r\u0012A\u0002:f[>4X\r\u0006\u0002\u0002fA\u00191%a\u001a\n\u0007\u0005%DEA\u0004O_RD\u0017N\\4\u0002\u001f\u001d,GOU3ta>t7/Z*ju\u0016$RAPA8\u0003sBq!!\u001d\u0019\u0001\u0004\t\u0019(A\u0004va\u0012\fG/Z:\u0011\u0007-\u000b)(C\u0002\u0002xA\u0013\u0001BU#T!~k\u0015\t\u0015\u0005\b\u0003wB\u0002\u0019AA?\u0003%1XM]:j_:LE\rE\u0002$\u0003\u007fJ1!!!%\u0005\u0015\u0019\u0006n\u001c:u\u0003u)\b\u000fZ1uK\u0006sGmR3oKJ\fG/\u001a*fgB|gn]3ECR\fG\u0003BAD\u0003'\u0003B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b\u0013\u0014\u0001\u0003:fcV,7\u000f^:\n\t\u0005E\u00151\u0012\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\t\u000f\u0005E\u0014\u00041\u0001\u0002t\u0005!r-\u001a;UQJ|G\u000f\u001e7fIJ+7\u000f]8og\u0016$B!a\"\u0002\u001a\"1\u00111\u0014\u000eA\u0002y\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final int requestEpoch;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private final Map<Uuid, String> topicNames;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private int requestEpoch() {
        return this.requestEpoch;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    private Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(partition -> {
                if (this.kafka$server$IncrementalFetchContext$$session().usesTopicIds()) {
                    partition.maybeResolveUnknownName(this.topicNames());
                }
                fun.apply((Object)new TopicIdPartition(partition.topicId(), partition.partition(), partition.topic()), partition);
            });
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), updates);
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.requestEpoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, int requestEpoch, FetchSession session, Map<Uuid, String> topicNames) {
        this.time = time;
        this.requestEpoch = requestEpoch;
        this.kafka$server$IncrementalFetchContext$$session = session;
        this.topicNames = topicNames;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        public Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> nextElement() {
            return this.nextElement;
        }

        public void nextElement_$eq(Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.iter().next();
                TopicIdPartition topicPart = element.getKey();
                FetchResponseData.PartitionData respData = element.getValue();
                IncrementalPartitionFetchMetadata cachedPart = (IncrementalPartitionFetchMetadata)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected() || FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) <= 0) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicIdPartition, FetchResponseData.PartitionData> element = this.nextElement();
            this.nextElement_$eq(null);
            return var1_1;
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicIdPartition, FetchResponseData.PartitionData>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

