/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.DefaultRequestLogger;
import kafka.server.KafkaConfig;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.RequestLogger;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u000f\u001f\u0001\rB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u00037\u0011!q\u0005A!b\u0001\n\u0003y\u0005\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011u\u0003!Q1A\u0005\u0002yC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tU\u0002\u0011)\u0019!C\u0001W\"A!\u000f\u0001B\u0001B\u0003%A\u000e\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003u\u0011!9\bA!A!\u0002\u0013A\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\n\u0003C\u0001!\u0019!C\u0005\u0003GA\u0001\"!\f\u0001A\u0003%\u0011Q\u0005\u0005\n\u0003_\u0001!\u0019!C\u0005\u0003cA\u0001\"!\u000f\u0001A\u0003%\u00111\u0007\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"!\u0012\u0001A\u0003%\u0011q\b\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0005\u0003\u0013B\u0011\"!\u0015\u0001\u0001\u0004%I!a\u0015\t\u0011\u0005}\u0003\u0001)Q\u0005\u0003\u0017Bq!!\u001b\u0001\t\u0003\tY\u0007\u0003\u0005\u0002n\u0001!\tAHA8\u0011\u001d\t)\b\u0001C\u0005\u0003WBq!a\u001e\u0001\t\u0003\tY\u0007C\u0004\u0002z\u0001!\t!a\u001b\t\u000f\u0005m\u0004\u0001\"\u0001\u0002l\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u0011q\u0004I\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001I1z\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0015j\u0013B\u0001\u0018'\u0005!\u0011VO\u001c8bE2,\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a!\u0003\u0015)H/\u001b7t\u0013\t!\u0014GA\u0004M_\u001e<\u0017N\\4\u0002\u0005%$\u0007CA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$aA%oi\u000611m\u001c8gS\u001e\u0004\"AP \u000e\u0003yI!\u0001\u0011\u0010\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\nG2,8\u000f^3s\u0013\u0012\u0004\"a\u0011&\u000f\u0005\u0011C\u0005CA#9\u001b\u00051%BA$#\u0003\u0019a$o\\8u}%\u0011\u0011\nO\u0001\u0007!J,G-\u001a4\n\u0005-c%AB*ue&twM\u0003\u0002Jq\u0005A!M]8lKJLE-\u0001\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014X#\u0001)\u0011\u0005ESV\"\u0001*\u000b\u0005M#\u0016\u0001B2pe\u0016T!!\u0016,\u0002\u000f5,GO]5dg*\u0011q\u000bW\u0001\u0007s\u0006lW.\u001a:\u000b\u0003e\u000b1aY8n\u0013\tY&KA\u0003NKR,'/A\nbO\u001e\u0014XmZ1uK&#G.Z'fi\u0016\u0014\b%A\nu_R\fG\u000eS1oI2,'\u000f\u00165sK\u0006$7/F\u0001`!\t\u0001w-D\u0001b\u0015\t\u00117-\u0001\u0004bi>l\u0017n\u0019\u0006\u0003I\u0016\f!bY8oGV\u0014(/\u001a8u\u0015\t1\u0007&\u0001\u0003vi&d\u0017B\u00015b\u00055\tEo\\7jG&sG/Z4fe\u0006!Bo\u001c;bY\"\u000bg\u000e\u001a7feRC'/Z1eg\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001m!\ti\u0007/D\u0001o\u0015\ty\u0007%A\u0004oKR<xN]6\n\u0005Et'A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005!\u0011\r]5t!\tqT/\u0003\u0002w=\t\t\u0012\t]5SKF,Xm\u001d;IC:$G.\u001a:\u0002\tQLW.\u001a\t\u0004s\u0006\u0015Q\"\u0001>\u000b\u0005IZ(B\u0001?~\u0003\u0019\u0019w.\\7p]*\u0011\u0011E \u0006\u0004\u007f\u0006\u0005\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u0004\u0005\u0019qN]4\n\u0007\u0005\u001d!P\u0001\u0003US6,\u0017A\u0002\u001fj]&$h\b\u0006\u000b\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001c\u0005u\u0011q\u0004\t\u0003}\u0001AQ!N\u0007A\u0002YBQ\u0001P\u0007A\u0002uBQ!Q\u0007A\u0002\tCQ!T\u0007A\u0002YBQAT\u0007A\u0002ACQ!X\u0007A\u0002}CQA[\u0007A\u00021DQa]\u0007A\u0002QDQa^\u0007A\u0002a\f\u0001c\u001d5vi\u0012|wO\\\"p[BdW\r^3\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003Si\u0011aY\u0005\u0004\u0003W\u0019'AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u0012g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016\u0004\u0013\u0001\u0004:fcV,7\u000f\u001e'pG\u0006dWCAA\u001a!\rq\u0014QG\u0005\u0004\u0003oq\"\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017!\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007%A\u0007sKF,Xm\u001d;M_\u001e<WM]\u000b\u0003\u0003\u007f\u00012APA!\u0013\r\t\u0019E\b\u0002\u000e%\u0016\fX/Z:u\u0019><w-\u001a:\u0002\u001dI,\u0017/^3ti2{wmZ3sA\u000591\u000f^8qa\u0016$WCAA&!\r9\u0014QJ\u0005\u0004\u0003\u001fB$a\u0002\"p_2,\u0017M\\\u0001\fgR|\u0007\u000f]3e?\u0012*\u0017\u000f\u0006\u0003\u0002V\u0005m\u0003cA\u001c\u0002X%\u0019\u0011\u0011\f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003;*\u0012\u0011!a\u0001\u0003\u0017\n1\u0001\u001f\u00132\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003f\u0001\f\u0002dA\u0019q'!\u001a\n\u0007\u0005\u001d\u0004H\u0001\u0005w_2\fG/\u001b7f\u0003\r\u0011XO\u001c\u000b\u0003\u0003+\nA\u0001]8mYR!\u0011QKA9\u0011\u0019\t\u0019\b\u0007a\u0001m\u0005IA/[7f_V$Xj]\u0001\u0011G>l\u0007\u000f\\3uKNCW\u000f\u001e3po:\fAa\u001d;pa\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\\\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private final RequestLogger requestLogger;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private RequestLogger requestLogger() {
        return this.requestLogger;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
            this.stop();
            return;
        }
        if (req instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)req;
            try {
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        this.apis.handle(request, this.requestLogger(), this.requestLocal());
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                }
            }
            finally {
                request.releaseBuffer();
            }
            return;
        }
        if (req == null) {
            return;
        }
        throw new MatchError((Object)req);
    }

    private void completeShutdown() {
        this.requestLocal().close();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, KafkaConfig config, String clusterId, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.requestLogger = new DefaultRequestLogger(config, clusterId);
        this.stopped = false;
    }
}

