/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.client.ZKClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KafkaServer$ {
    public static KafkaServer$ MODULE$;
    private final long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    private final AtomicLong externalShutdownInitiations;
    private final Logger logger;

    static {
        new KafkaServer$();
    }

    public Time $lessinit$greater$default$2() {
        return Time.SYSTEM;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$4() {
        return false;
    }

    public void augmentWithKafkaConfig(Map<String, Object> logProps, KafkaConfig kafkaConfig) {
        if (kafkaConfig != null) {
            logProps.put("confluent.schema.registry.max.cache.size", kafkaConfig.getInt("confluent.schema.registry.max.cache.size"));
            logProps.put("confluent.schema.registry.max.retries", kafkaConfig.getInt("confluent.schema.registry.max.retries"));
            logProps.put("confluent.schema.registry.retries.wait.ms", kafkaConfig.getInt("confluent.schema.registry.retries.wait.ms"));
            logProps.put("confluent.missing.id.query.range", kafkaConfig.getInt("confluent.missing.id.query.range"));
            logProps.put("confluent.missing.id.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.id.cache.ttl.sec"));
            logProps.put("confluent.missing.schema.cache.ttl.sec", kafkaConfig.getLong("confluent.missing.schema.cache.ttl.sec"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZKClientConfig zkClientConfigFromKafkaConfig(KafkaConfig config, boolean forceZkSslClientEnable) {
        void var3_3;
        ZKClientConfig clientConfig = new ZKClientConfig();
        if (config.zkSslClientEnable() || forceZkSslClientEnable) {
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "true");
            config.zkClientCnxnSocketClassName().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), x$1);
                return BoxedUnit.UNIT;
            });
            config.zkSslKeyStoreLocation().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp(), x$2);
                return BoxedUnit.UNIT;
            });
            config.zkSslKeyStorePassword().foreach((Function1 & Serializable & scala.Serializable)x -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp(), x.value());
                return BoxedUnit.UNIT;
            });
            config.zkSslKeyStoreType().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp(), x$3);
                return BoxedUnit.UNIT;
            });
            config.zkSslTrustStoreLocation().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp(), x$4);
                return BoxedUnit.UNIT;
            });
            config.zkSslTrustStorePassword().foreach((Function1 & Serializable & scala.Serializable)x -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp(), x.value());
                return BoxedUnit.UNIT;
            });
            config.zkSslTrustStoreType().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp(), x$5);
                return BoxedUnit.UNIT;
            });
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslProtocolProp(), config.ZkSslProtocol());
            config.ZkSslEnabledProtocols().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp(), x$6);
                return BoxedUnit.UNIT;
            });
            config.ZkSslCipherSuites().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCipherSuitesProp(), x$7);
                return BoxedUnit.UNIT;
            });
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp(), config.ZkSslEndpointIdentificationAlgorithm());
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslCrlEnableProp(), Boolean.toString(config.ZkSslCrlEnable()));
            KafkaConfig$.MODULE$.setZooKeeperClientProperty(clientConfig, KafkaConfig$.MODULE$.ZkSslOcspEnableProp(), Boolean.toString(config.ZkSslOcspEnable()));
        }
        if (!JaasUtils.isZkSaslEnabled()) {
            clientConfig.setProperty("zookeeper.sasl.client", "false");
        }
        return var3_3;
    }

    public boolean zkClientConfigFromKafkaConfig$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Thread initiateShutdown() {
        void daemon_runnable;
        long previousInitiations = this.externalShutdownInitiations().getAndAdd(1L);
        Runnable runnable = () -> {
            MODULE$.logger().warn("Initiating externally-requested shutdown by calling Exit (there were {} externally-initiated shutdowns previously)", (Object)BoxesRunTime.boxToLong((long)previousInitiations));
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        };
        String daemon_name = new StringBuilder(18).append("external-shutdown-").append(previousInitiations).toString();
        KafkaThread kafkaThread = new KafkaThread(daemon_name, (Runnable)daemon_runnable, true);
        kafkaThread.start();
        return kafkaThread;
    }

    public long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS() {
        return this.MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    }

    public AtomicLong externalShutdownInitiations() {
        return this.externalShutdownInitiations;
    }

    public Logger logger() {
        return this.logger;
    }

    private KafkaServer$() {
        MODULE$ = this;
        this.MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS = 120000L;
        this.externalShutdownInitiations = new AtomicLong(0L);
        this.logger = LoggerFactory.getLogger((String)"KafkaServer");
    }
}

