/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FollowerThrottler;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.RequestBuilder;
import kafka.server.TierMaterializationRequirements;
import kafka.server.TierOffsetInfo;
import kafka.server.TierOffsetInfo$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"IQ\t\u0001BC\u0002\u0013\u0005qD\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005\u000f\"I1\u000b\u0001BC\u0002\u0013\u0005q\u0004\u0016\u0005\t1\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011%\u0004!\u0011!Q\u0001\n)DQ\u0001\u001e\u0001\u0005\u0002UD\u0011\"!\u0001\u0001\u0001\u0004%\t\"a\u0001\t\u0013\u0005U\u0001\u00011A\u0005\u0012\u0005]\u0001\u0002CA\u0012\u0001\u0001\u0006K!!\u0002\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u001a\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003k\u0001A\u0011IA\u001c\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a \u0001\t\u0003\n\t\tC\u0004\u0002\u0018\u0002!\t%!'\t\u000f\u0005}\u0005\u0001\"\u0011\u0002\"\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBA[\u0001\u0011%\u0011q\u0017\u0005\b\u0003\u001b\u0004A\u0011AAh\u0011\u001d\u0011i\u0001\u0001C!\u0005\u001fAqA!\b\u0001\t\u0003\u0012y\u0002C\u0004\u0003F\u0001!\tEa\u0012\u0003)I+Wn\u001c;f\u0019\u0016\fG-\u001a:F]\u0012\u0004v.\u001b8u\u0015\t\u0001\u0013%\u0001\u0004tKJ4XM\u001d\u0006\u0002E\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001&W=\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005y\u0012B\u0001\u0018 \u00059aU-\u00193fe\u0016sG\rU8j]R\u0004\"\u0001M\u001a\u000e\u0003ER!AM\u0011\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$a\u0002'pO\u001eLgnZ\u0001\nY><\u0007K]3gSb\u0004\"a\u000e \u000f\u0005ab\u0004CA\u001d(\u001b\u0005Q$BA\u001e$\u0003\u0019a$o\\8u}%\u0011QhJ\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>O\u0005q!\r\\8dW&twmU3oI\u0016\u0014\bC\u0001\u0017D\u0013\t!uD\u0001\u0007CY>\u001c7.\u001b8h'\u0016tG-A\ngKR\u001c\u0007nU3tg&|g\u000eS1oI2,'/F\u0001H!\tA\u0005+D\u0001J\u0015\tQ5*A\u0004dY&,g\u000e^:\u000b\u0005\tb%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!U%\u0003'\u0019+Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0002)\u0019,Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:!\u00039\u0011X-];fgR\u0014U/\u001b7eKJ,\u0012!\u0016\t\u0003YYK!aV\u0010\u0003\u001dI+\u0017/^3ti\n+\u0018\u000e\u001c3fe\u0006y!/Z9vKN$()^5mI\u0016\u0014\b%A\u0005uQJ|G\u000f\u001e7feB\u0011AfW\u0005\u00039~\u0011\u0011CR8mY><XM\u001d+ie>$H\u000f\\3s\u00031\u0011'o\\6fe\u000e{gNZ5h!\tas,\u0003\u0002a?\tY1*\u00194lC\u000e{gNZ5h\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\"\u0001L2\n\u0005\u0011|\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0006cV|G/\u0019\t\u0003Y\u001dL!\u0001[\u0010\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u0002/5,G/\u00193bi\u00064VM]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\bc\u0001\u0014l[&\u0011An\n\u0002\n\rVt7\r^5p]B\u0002\"A\u001c:\u000e\u0003=T!\u0001]9\u0002\r\r|W.\\8o\u0015\t\u00013*\u0003\u0002t_\nyQ*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\u0004=S:LGO\u0010\u000b\u000bm^D\u0018P_>}{z|\bC\u0001\u0017\u0001\u0011\u0015)D\u00021\u00017\u0011\u0015\tE\u00021\u0001C\u0011\u0015)E\u00021\u0001H\u0011\u0015\u0019F\u00021\u0001V\u0011\u0015IF\u00021\u0001[\u0011\u0015iF\u00021\u0001_\u0011\u0015\tG\u00021\u0001c\u0011\u0015)G\u00021\u0001g\u0011\u0015IG\u00021\u0001k\u0003%1W\r^2i'&TX-\u0006\u0002\u0002\u0006A!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011\u0001\u00027b]\u001eT!!a\u0004\u0002\t)\fg/Y\u0005\u0005\u0003'\tIAA\u0004J]R,w-\u001a:\u0002\u001b\u0019,Go\u00195TSj,w\fJ3r)\u0011\tI\"a\b\u0011\u0007\u0019\nY\"C\u0002\u0002\u001e\u001d\u0012A!\u00168ji\"I\u0011\u0011\u0005\b\u0002\u0002\u0003\u0007\u0011QA\u0001\u0004q\u0012\n\u0014A\u00034fi\u000eD7+\u001b>fA\u0005a\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$WCAA\u0015!\r1\u00131F\u0005\u0004\u0003[9#a\u0002\"p_2,\u0017M\\\u0001\u000eS:LG/[1uK\u000ecwn]3\u0015\u0005\u0005e\u0011!B2m_N,\u0017A\u00042s_.,'/\u00128e!>Lg\u000e\u001e\u000b\u0003\u0003s\u0001B!a\u000f\u0002B5\u0011\u0011Q\b\u0006\u0004\u0003\u007f\t\u0013aB2mkN$XM]\u0005\u0005\u0003\u0007\niD\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002\u000b\u0019,Go\u00195\u0015\t\u0005%\u0013q\r\t\t\u0003\u0017\n\t&!\u0016\u0002`5\u0011\u0011Q\n\u0006\u0004\u0003\u001f:\u0013AC2pY2,7\r^5p]&!\u00111KA'\u0005\ri\u0015\r\u001d\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u0011\u0001oS\u0005\u0005\u0003;\nIF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u0005\u00141M\u0007\u0002\u0001%\u0019\u0011QM\u0017\u0003\u0013\u0019+Go\u00195ECR\f\u0007bBA5)\u0001\u0007\u00111N\u0001\rM\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0005\u0003[\nIH\u0004\u0003\u0002p\u0005UTBAA9\u0015\u0011\t\u0019(!\u0017\u0002\u0011I,\u0017/^3tiNLA!a\u001e\u0002r\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u00111PA?\u0005\u001d\u0011U/\u001b7eKJTA!a\u001e\u0002r\u0005\u0019b-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fiR1\u00111QAE\u0003\u001b\u00032A\\AC\u0013\r\t9i\u001c\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u001d\tY)\u0006a\u0001\u0003+\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0010V\u0001\r!!%\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\t\u0004M\u0005M\u0015bAAKO\t\u0019\u0011J\u001c;\u0002#\u0019,Go\u00195MCR,7\u000f^(gMN,G\u000f\u0006\u0004\u0002\u0004\u0006m\u0015Q\u0014\u0005\b\u0003\u00173\u0002\u0019AA+\u0011\u001d\tyI\u0006a\u0001\u0003#\u000baDZ3uG\"$\u0016.\u001a:NCR,'/[1mSj\fG/[8o)\u0006\u0014x-\u001a;\u0015\r\u0005\r\u0016\u0011VAV!\ra\u0013QU\u0005\u0004\u0003O{\"A\u0004+jKJ|eMZ:fi&sgm\u001c\u0005\b\u0003\u0017;\u0002\u0019AA+\u0011\u001d\tyi\u0006a\u0001\u0003#\u000b\u0001DZ3uG\",\u0015M\u001d7jKN$Hj\\2bY>3gm]3u)\u0019\t\u0019)!-\u00024\"9\u00111\u0012\rA\u0002\u0005U\u0003bBAH1\u0001\u0007\u0011\u0011S\u0001\fM\u0016$8\r[(gMN,G\u000f\u0006\u0005\u0002:\u0006}\u0016\u0011YAb!\u001d1\u00131XAI\u0003GK1!!0(\u0005\u0019!V\u000f\u001d7fe!9\u00111R\rA\u0002\u0005U\u0003bBAH3\u0001\u0007\u0011\u0011\u0013\u0005\b\u0003\u000bL\u0002\u0019AAd\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002'\u0003\u0013L1!a3(\u0005\u0011auN\\4\u00025\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t\u0003NT\u0015M^1\u0015\t\u0005E'\u0011\u0001\t\t\u0003'\fI.!\u0016\u0002\\6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fi!\u0001\u0003vi&d\u0017\u0002BA*\u0003+\u0004B!!8\u0002|:!\u0011q\\A{\u001d\u0011\t\t/!=\u000f\t\u0005\r\u0018q\u001e\b\u0005\u0003K\fiO\u0004\u0003\u0002h\u0006-hbA\u001d\u0002j&\tq*\u0003\u0002N\u001d&\u0011!\u0005T\u0005\u0003a.KA!a=\u0002Z\u00059Q.Z:tC\u001e,\u0017\u0002BA|\u0003s\f\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC*!\u00111_A-\u0013\u0011\ti0a@\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi*!\u0011q_A}\u0011\u001d\u0011\u0019A\u0007a\u0001\u0005\u000b\t!\u0002]1si&$\u0018n\u001c8t!!\t\u0019.!7\u0002V\t\u001d\u0001\u0003BA1\u0005\u0013I1Aa\u0003.\u0005%)\u0005o\\2i\t\u0006$\u0018-\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0005#\u0011I\u0002\u0005\u0005\u0002L\u0005E\u0013Q\u000bB\n!\u0011\u0011)\"a?\u000f\t\t]\u0011Q_\u0007\u0003\u0003sDqAa\u0001\u001c\u0001\u0004\u0011Y\u0002\u0005\u0005\u0002L\u0005E\u0013Q\u000bB\u0004\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0005C\u0011Y\u0004\u0005\u0004\u0003$\t%\"q\u0006\b\u0004Y\t\u0015\u0012b\u0001B\u0014?\u0005)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0017\u0002\u0002B\u0016\u0005[\u0011ACU3tk2$x+\u001b;i!\u0006\u0014H/\u001b;j_:\u001c(b\u0001B\u0014?A)aE!\r\u00036%\u0019!1G\u0014\u0003\r=\u0003H/[8o!\u0011\u0011\u0019Ca\u000e\n\t\te\"Q\u0006\u0002\r%\u0016\u0004H.[2b\r\u0016$8\r\u001b\u0005\b\u0005\u0007a\u0002\u0019\u0001B\u001f!!\tY%!\u0015\u0002V\t}\u0002c\u0001\u0017\u0003B%\u0019!1I\u0010\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002\u001f%\u001c(+Z1es\u001a{'OR3uG\"$B!!\u000b\u0003J!9!1J\u000fA\u0002\u0005U\u0013A\u0001;q\u0001")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final RequestBuilder requestBuilder;
    private final FollowerThrottler throttler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public RequestBuilder requestBuilder() {
        return this.requestBuilder;
    }

    public Integer fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize_$eq(Integer x$1) {
        this.fetchSize = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return ((MetadataVersion)this.metadataVersionSupplier.apply()).isTruncationOnFetchSupported();
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        FetchResponse fetchResponse = (FetchResponse)clientResponse2.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse2.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return scala.collection.Map$.MODULE$.empty();
        }
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse2.requestHeader().apiVersion())).asScala();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_6;
        void var8_7;
        TierOffsetInfo tierOffsetInfo;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
                if (tuple2 == null) break block4;
                int epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = (TierOffsetInfo)tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var8_7.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for earliest timestamp fetch");
        }
        return new OffsetAndEpoch((long)var6_6, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        void var4_4;
        void var6_6;
        void var8_7;
        TierOffsetInfo tierOffsetInfo;
        block5: {
            Tuple2<Object, TierOffsetInfo> tuple2;
            block4: {
                tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
                if (tuple2 == null) break block4;
                int epoch = tuple2._1$mcI$sp();
                tierOffsetInfo = (TierOffsetInfo)tuple2._2();
                if (tierOffsetInfo != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        long localLogStartOffset = tierOffsetInfo.localLogStartOffset();
        Option<TierMaterializationRequirements> tierRestorePoint = tierOffsetInfo.tierRestorePoint();
        if (var8_7.isDefined()) {
            throw new IllegalStateException("Tier restore point returned for latest timestamp fetch");
        }
        return new OffsetAndEpoch((long)var6_6, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TierOffsetInfo fetchTierMaterializationTarget(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig.confluentConfig().tierFeature())) {
            void var4_4;
            Tuple2<Object, TierOffsetInfo> tuple2 = this.fetchOffset(topicPartition, currentLeaderEpoch, -10000L);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TierOffsetInfo tierOffsetInfo = (TierOffsetInfo)tuple2._2();
            return var4_4;
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        throw new UnsupportedOperationException("Fetching earliest local offset is not supported in Remote Leader Endpoint.");
    }

    private Tuple2<Object, TierOffsetInfo> fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long timestamp) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(timestamp)));
        ListOffsetsRequest.Builder listOffsetRequest = this.requestBuilder().buildListOffsetRequest(topic);
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)listOffsetRequest).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$3))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$4))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (Errors.NONE.equals(errors)) {
        } else {
            throw errors.exception();
        }
        Tuple2 tuple2 = metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV2) ? (responsePartition.followerRestorePointObjectId() != null && !responsePartition.followerRestorePointObjectId().equals((Object)Uuid.ZERO_UUID) ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(responsePartition.offset(), CoreUtils$.MODULE$.toJavaUUID(responsePartition.followerRestorePointObjectId()), responsePartition.followerRestorePointEpoch())) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(responsePartition.offset()))) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)responsePartition.leaderEpoch()), (Object)TierOffsetInfo$.MODULE$.apply(Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0))));
        return tuple2;
    }

    public java.util.Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsetsAsJava(java.util.Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.fetchEpochEndOffsets((Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition>)((Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(partitions).asScala()))).asJava();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return scala.collection.Map$.MODULE$.empty();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchEpochEndOffsets$2(topics, topicPartition, epochData));
        Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        OffsetsForLeaderEpochRequest.Builder epochRequest = this.requestBuilder().buildOffsetsForLeaderEpochRequest(topics);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responseBody.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)offsetForLeaderTopicResult -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopicResult.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }, Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition tp = (TopicPartition)x0$1._1();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Map partitionsWithError = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        boolean lowDiskThrottle = this.throttler.shouldThrottleDueToLowDisk(this.quota);
        boolean isQuotaExceeded = this.quota.isQuotaExceeded();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && this.isReadyForFetch((TopicPartition)topicPartition)) {
                if (lowDiskThrottle || $this.throttler.shouldThrottle(isQuotaExceeded, $this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                    $this.throttler.markReplicaThrottle($this.replicaManager);
                    return BoxedUnit.UNIT;
                }
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$5 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$5))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), (Object)Errors.KAFKA_STORAGE_ERROR));
                }
            }
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        Some fetchRequestOpt = fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty() ? None$.MODULE$ : new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), this.requestBuilder().buildFetchRequest(fetchData)));
        return new AbstractFetcherThread.ResultWithPartitions<Some>(fetchRequestOpt, (Map<TopicPartition, Errors>)partitionsWithError);
    }

    @Override
    public boolean isReadyForFetch(TopicPartition tp) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$3) {
        String string = x$3.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$4) {
        return x$4.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochEndOffsets$2(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$5) {
        return BoxesRunTime.boxToInteger((int)x$5);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, RequestBuilder requestBuilder, FollowerThrottler throttler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.requestBuilder = requestBuilder;
        this.throttler = throttler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

