/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.metrics.LinuxCpuMetricsCollector$;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.server.KafkaConfig;
import kafka.utils.ProcessUtils;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.slf4j.Logger;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Ordering;

public final class Server$ {
    public static Server$ MODULE$;
    private final String MetricsPrefix;
    private final String ClusterIdLabel;
    private final String BrokerIdLabel;
    private final String NodeIdLabel;
    private final String CellIdLabel;
    private final String ProcessRoleLabel;

    static {
        new Server$();
    }

    public String MetricsPrefix() {
        return this.MetricsPrefix;
    }

    public String ClusterIdLabel() {
        return this.ClusterIdLabel;
    }

    public String BrokerIdLabel() {
        return this.BrokerIdLabel;
    }

    public String NodeIdLabel() {
        return this.NodeIdLabel;
    }

    public String CellIdLabel() {
        return this.CellIdLabel;
    }

    public String ProcessRoleLabel() {
        return this.ProcessRoleLabel;
    }

    public Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(config, clusterId);
        return this.buildMetrics(config, time, metricsContext);
    }

    public void maybeRegisterLinuxMetrics(KafkaConfig config, Time time, Logger logger) {
        new LinuxIoMetricsCollector("/proc", time, logger).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        new LinuxCpuMetricsCollector("/proc", time, (Option<Object>)OptionConverters.RichOptionalLong$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalLong(ProcessUtils.PID)), logger, LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$5(), LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$6()).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        if (Predef$.MODULE$.Boolean2boolean(config.confluentConfig().confluentInternalMetricsEnable())) {
            new LinuxDiskMetricsCollector(config, "/proc", time, logger).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        }
    }

    private Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        MetricConfig metricConfig = this.buildMetricsConfig(config);
        return new Metrics(metricConfig, new ArrayList(), time, true, (MetricsContext)metricsContext);
    }

    public MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.ClusterIdLabel(), clusterId);
        if (config.usesSelfManagedQuorum()) {
            contextLabels.put(this.NodeIdLabel(), Integer.toString(config.nodeId()));
        } else {
            contextLabels.put(this.BrokerIdLabel(), Integer.toString(config.brokerId()));
        }
        if (config.cellsImplicitCreation()) {
            contextLabels.put(this.CellIdLabel(), Integer.toString(Cell.getImplicitBrokerCellId((int)config.brokerId(), (int)config.cellDefaultSize())));
        }
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        contextLabels.put("resource.type", "kafka");
        contextLabels.put("resource.version", AppInfoParser.getVersion());
        contextLabels.put("resource.commit.id", AppInfoParser.getCommitId());
        if (config.processRoles().nonEmpty()) {
            String roles = ((TraversableOnce)((SetLike)config.processRoles().map((Function1 & Serializable & scala.Serializable)role -> role.toString(), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
            contextLabels.put(this.ProcessRoleLabel(), roles);
        }
        return new KafkaMetricsContext(this.MetricsPrefix(), contextLabels);
    }

    private Server$() {
        MODULE$ = this;
        this.MetricsPrefix = "kafka.server";
        this.ClusterIdLabel = "kafka.cluster.id";
        this.BrokerIdLabel = "kafka.broker.id";
        this.NodeIdLabel = "kafka.node.id";
        this.CellIdLabel = "kafka.cell.id";
        this.ProcessRoleLabel = "kafka.process.roles";
    }
}

