/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import kafka.common.TenantHelpers;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r]c\u0001B)S\u0001]C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%\t!\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005M\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003n\u0011!\t\bA!b\u0001\n\u0003\u0011\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u0015\u0005\u0005\u0001A!b\u0001\n\u0013\t\u0019\u0001\u0003\u0006\u0002\u0012\u0001\u0011\t\u0011)A\u0005\u0003\u000bA!\"a\u0005\u0001\u0005\u000b\u0007I\u0011AA\u000b\u0011)\t9\u0007\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003S\u0002!Q1A\u0005\u0002\u0005-\u0004BCA:\u0001\t\u0005\t\u0015!\u0003\u0002n!Q\u0011Q\u000f\u0001\u0003\u0006\u0004%\t!a\u001e\t\u0015\u00055\u0005A!A!\u0002\u0013\tI\b\u0003\u0006\u0002\u0010\u0002\u0011)\u0019!C\u0001\u0003#C!\"a(\u0001\u0005\u0003\u0005\u000b\u0011BAJ\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GC\u0011\"a.\u0001\u0005\u0004%I!!/\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003wC\u0011\"a1\u0001\u0001\u0004%I!!2\t\u0013\u00055\u0007\u00011A\u0005\n\u0005=\u0007\u0002CAn\u0001\u0001\u0006K!a2\t\u0013\u0005u\u0007\u00011A\u0005\n\u0005\u0015\u0007\"CAp\u0001\u0001\u0007I\u0011BAq\u0011!\t)\u000f\u0001Q!\n\u0005\u001d\u0007\"CAt\u0001\u0001\u0007I\u0011BAc\u0011%\tI\u000f\u0001a\u0001\n\u0013\tY\u000f\u0003\u0005\u0002p\u0002\u0001\u000b\u0015BAd\u0011!\t\t\u0010\u0001b\u0001\n\u0003)\u0007bBAz\u0001\u0001\u0006IA\u001a\u0005\t\u0003k\u0004\u0001\u0019!C\u0001K\"I\u0011q\u001f\u0001A\u0002\u0013\u0005\u0011\u0011 \u0005\b\u0003{\u0004\u0001\u0015)\u0003g\u0011%\ty\u0010\u0001b\u0001\n\u0003\u0011\t\u0001\u0003\u0005\u0003\n\u0001\u0001\u000b\u0011\u0002B\u0002\u0011%\tY\u0001\u0001a\u0001\n\u0003\t\u0019\u0001C\u0005\u0003\f\u0001\u0001\r\u0011\"\u0001\u0003\u000e!A!\u0011\u0003\u0001!B\u0013\t)\u0001C\u0006\u0003\u001c\u0001\u0001\r\u00111A\u0005\u0002\tu\u0001b\u0003B\u001a\u0001\u0001\u0007\t\u0019!C\u0001\u0005kA1B!\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003 !Y!Q\b\u0001A\u0002\u0003\u0007I\u0011\u0001B \u0011-\u0011Y\u0005\u0001a\u0001\u0002\u0004%\tA!\u0014\t\u0017\tE\u0003\u00011A\u0001B\u0003&!\u0011\t\u0005\f\u0005+\u0002\u0001\u0019!a\u0001\n\u0003\u00119\u0006C\u0006\u0003h\u0001\u0001\r\u00111A\u0005\u0002\t%\u0004b\u0003B7\u0001\u0001\u0007\t\u0011)Q\u0005\u00053B1B!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003t!Y!1\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001BC\u0011-\u0011I\t\u0001a\u0001\u0002\u0003\u0006KA!\u001e\t\u0013\t5\u0005A1A\u0005\u0002\t=\u0005\u0002\u0003BW\u0001\u0001\u0006IA!%\t\u0017\t=\u0006\u00011AA\u0002\u0013\u0005!\u0011\u0017\u0005\f\u0005\u007f\u0003\u0001\u0019!a\u0001\n\u0003\u0011\t\rC\u0006\u0003F\u0002\u0001\r\u0011!Q!\n\tM\u0006b\u0003Be\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0017D1Ba5\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003V\"Y!\u0011\u001c\u0001A\u0002\u0003\u0005\u000b\u0015\u0002Bg\u0011%\u0011i\u000e\u0001b\u0001\n\u0003\u0011y\u000e\u0003\u0005\u0003x\u0002\u0001\u000b\u0011\u0002Bq\u0011-\u0011I\u0010\u0001a\u0001\u0002\u0004%\tAa?\t\u0017\rU\u0001\u00011AA\u0002\u0013\u00051q\u0003\u0005\f\u00077\u0001\u0001\u0019!A!B\u0013\u0011i\u0010C\u0004\u0004\u001e\u0001!Iaa\b\t\u000f\r\u0015\u0002\u0001\"\u0001\u0004(!91\u0011\u0006\u0001\u0005\u0002\r-\u0002bBB\u0017\u0001\u0011\u000511\u0006\u0005\b\u0007_\u0001A\u0011AB\u0016\u0011\u001d\u0019\t\u0004\u0001C\u0001\u0007WAqaa\r\u0001\t\u0003\u0019)\u0004C\u0004\u0004D\u0001!\ta!\u000e\t\u000f\r\u0015\u0003\u0001\"\u0001\u00046!91q\t\u0001\u0005\u0002\rU\u0002bBB%\u0001\u0011\u00051Q\u0007\u0005\b\u0007\u0017\u0002A\u0011AB\u001b\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007kAqaa\u0014\u0001\t\u0013\u0019Y\u0003C\u0004\u0004R\u0001!\taa\u000b\t\u000f\rM\u0003\u0001\"\u0003\u0004,!91Q\u000b\u0001\u0005\u0002\r-\"\u0001D*iCJ,GmU3sm\u0016\u0014(BA*U\u0003\u0019\u0019XM\u001d<fe*\tQ+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Af\f\u0005\u0002Z96\t!LC\u0001\\\u0003\u0015\u00198-\u00197b\u0013\ti&L\u0001\u0004B]f\u0014VM\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003CR\u000bQ!\u001e;jYNL!a\u00191\u0003\u000f1{wmZ5oO\u0006\u00112\u000f[1sK\u0012\u001cVM\u001d<fe\u000e{gNZ5h+\u00051\u0007CA4i\u001b\u0005\u0011\u0016BA5S\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002'MD\u0017M]3e'\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0011\u0002\u00135,G/\u0019)s_B\u001cX#A7\u0011\u0005\u001dt\u0017BA8S\u00059iU\r^1Qe>\u0004XM\u001d;jKN\f!\"\\3uCB\u0013x\u000e]:!\u0003\u0011!\u0018.\\3\u0016\u0003M\u0004\"\u0001^?\u000e\u0003UT!!\u0019<\u000b\u0005]D\u0018AB2p[6|gN\u0003\u0002Vs*\u0011!p_\u0001\u0007CB\f7\r[3\u000b\u0003q\f1a\u001c:h\u0013\tqXO\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013\u0001C0nKR\u0014\u0018nY:\u0016\u0005\u0005\u0015\u0001\u0003BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-a/A\u0004nKR\u0014\u0018nY:\n\t\u0005=\u0011\u0011\u0002\u0002\b\u001b\u0016$(/[2t\u0003%yV.\u001a;sS\u000e\u001c\b%\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005]\u0001CBA\r\u0003O\tY#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003C\t\u0019#\u0001\u0003vi&d'BAA\u0013\u0003\u0011Q\u0017M^1\n\t\u0005%\u00121\u0004\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA\u0017\u0003_\t\u0019$a\u0010\u000e\u0005\u0005}\u0011\u0002BA\u0019\u0003?\u00111!T1q!\u0011\t)$a\u000f\u000e\u0005\u0005]\"\u0002BA\u001d\u0003G\tA\u0001\\1oO&!\u0011QHA\u001c\u0005\u001dIe\u000e^3hKJ\u0004B!!\u0011\u0002b9!\u00111IA.\u001d\u0011\t)%a\u0016\u000f\t\u0005\u001d\u0013Q\u000b\b\u0005\u0003\u0013\n\u0019F\u0004\u0003\u0002L\u0005ESBAA'\u0015\r\tyEV\u0001\u0007yI|w\u000e\u001e \n\u0003qL!A_>\n\u0005UK\u0018bAA-q\u0006!!/\u00194u\u0013\u0011\ti&a\u0018\u0002\u0015I\u000bg\r^\"p]\u001aLwMC\u0002\u0002ZaLA!a\u0019\u0002f\tY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\u0011\ti&a\u0018\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n1CZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef,\"!!\u001c\u0011\u0007\u001d\fy'C\u0002\u0002rI\u00131CR1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef\fACZ1vYRD\u0015M\u001c3mKJ4\u0015m\u0019;pef\u0004\u0013aE7vYRLG+\u001a8b]RlU\r^1eCR\fWCAA=!\u0015I\u00161PA@\u0013\r\tiH\u0017\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005\u0005\u0015\u0011R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006YQ.\u001e7uSR,g.\u00198u\u0015\t\u0019\u00060\u0003\u0003\u0002\f\u0006\r%aE'vYRLG+\u001a8b]RlU\r^1eCR\f\u0017\u0001F7vYRLG+\u001a8b]RlU\r^1eCR\f\u0007%\u0001\u0007d_:4\u0017nZ*dQ\u0016l\u0017-\u0006\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001ab\f\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003;\u000b9JA\tLC\u001a\\\u0017mQ8oM&<7k\u00195f[\u0006\fQbY8oM&<7k\u00195f[\u0006\u0004\u0013A\u0002\u001fj]&$h\b\u0006\n\u0002&\u0006\u001d\u0016\u0011VAV\u0003[\u000by+!-\u00024\u0006U\u0006CA4\u0001\u0011\u0015!\u0017\u00031\u0001g\u0011\u0015Y\u0017\u00031\u0001n\u0011\u0015\t\u0018\u00031\u0001t\u0011\u001d\t\t!\u0005a\u0001\u0003\u000bAq!a\u0005\u0012\u0001\u0004\t9\u0002C\u0004\u0002jE\u0001\r!!\u001c\t\u000f\u0005U\u0014\u00031\u0001\u0002z!9\u0011qR\tA\u0002\u0005M\u0015A\u00037pO\u000e{g\u000e^3yiV\u0011\u00111\u0018\t\u0004i\u0006u\u0016bAA`k\nQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\bgR\f'\u000f^3e+\t\t9\rE\u0002Z\u0003\u0013L1!a3[\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;beR,Gm\u0018\u0013fcR!\u0011\u0011[Al!\rI\u00161[\u0005\u0004\u0003+T&\u0001B+oSRD\u0011\"!7\u0016\u0003\u0003\u0005\r!a2\u0002\u0007a$\u0013'\u0001\u0005ti\u0006\u0014H/\u001a3!\u00031)8/\u001a3Cs\n\u0013xn[3s\u0003A)8/\u001a3Cs\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0003\u0002R\u0006\r\b\"CAm1\u0005\u0005\t\u0019AAd\u00035)8/\u001a3Cs\n\u0013xn[3sA\u0005\u0001Ro]3e\u0005f\u001cuN\u001c;s_2dWM]\u0001\u0015kN,GMQ=D_:$(o\u001c7mKJ|F%Z9\u0015\t\u0005E\u0017Q\u001e\u0005\n\u00033\\\u0012\u0011!a\u0001\u0003\u000f\f\u0011#^:fI\nK8i\u001c8ue>dG.\u001a:!\u00031\u0011'o\\6fe\u000e{gNZ5h\u00035\u0011'o\\6fe\u000e{gNZ5hA\u0005\u00012m\u001c8ue>dG.\u001a:D_:4\u0017nZ\u0001\u0015G>tGO]8mY\u0016\u00148i\u001c8gS\u001e|F%Z9\u0015\t\u0005E\u00171 \u0005\t\u00033\u0004\u0013\u0011!a\u0001M\u0006\t2m\u001c8ue>dG.\u001a:D_:4\u0017n\u001a\u0011\u000215,G/\u00193bi\u0006,en\u0019:zaR|'OR1di>\u0014\u00180\u0006\u0002\u0003\u0004A!\u0011Q\u0013B\u0003\u0013\u0011\u00119!a&\u000315+G/\u00193bi\u0006,en\u0019:zaR|'OR1di>\u0014\u00180A\rnKR\fG-\u0019;b\u000b:\u001c'/\u001f9u_J4\u0015m\u0019;pef\u0004\u0013aC7fiJL7m]0%KF$B!!5\u0003\u0010!I\u0011\u0011\\\u0013\u0002\u0002\u0003\u0007\u0011QA\u0001\t[\u0016$(/[2tA!\u001aaE!\u0006\u0011\u0007e\u00139\"C\u0002\u0003\u001ai\u0013\u0001B^8mCRLG.Z\u0001\fe\u00064G/T1oC\u001e,'/\u0006\u0002\u0003 A1!\u0011\u0005B\u0013\u0005Si!Aa\t\u000b\u0007\u0005eC+\u0003\u0003\u0003(\t\r\"\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s!\u0011\u0011YCa\f\u000e\u0005\t5\"bA<\u0002\b&!!\u0011\u0007B\u0017\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]\u0006y!/\u00194u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002R\n]\u0002\"CAmQ\u0005\u0005\t\u0019\u0001B\u0010\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!Q\rI#QC\u0001\u000eEJ|7.\u001a:NKR\u0014\u0018nY:\u0016\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u000fj!A!\u0012\u000b\u0007\u0005e%+\u0003\u0003\u0003J\t\u0015#a\u0005\"s_.,'oU3sm\u0016\u0014X*\u001a;sS\u000e\u001c\u0018!\u00052s_.,'/T3ue&\u001c7o\u0018\u0013fcR!\u0011\u0011\u001bB(\u0011%\tInKA\u0001\u0002\u0004\u0011\t%\u0001\bce>\\WM]'fiJL7m\u001d\u0011)\u00071\u0012)\"A\fd_:$(o\u001c7mKJ\u001cVM\u001d<fe6+GO]5dgV\u0011!\u0011\f\t\u0005\u00057\u0012\u0019'\u0004\u0002\u0003^)!\u00111\u0002B0\u0015\r\u0011\t\u0007_\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002B3\u0005;\u0012\u0011dQ8oiJ|G\u000e\\3s\u001b\u0016$\u0018\rZ1uC6+GO]5dg\u0006Y2m\u001c8ue>dG.\u001a:TKJ4XM]'fiJL7m]0%KF$B!!5\u0003l!I\u0011\u0011\u001c\u0018\u0002\u0002\u0003\u0007!\u0011L\u0001\u0019G>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\u0004\u0003fA\u0018\u0003\u0016\u00051An\\1eKJ,\"A!\u001e\u0011\t\t]$qP\u0007\u0003\u0005sRAA!\u001d\u0003|)\u0019!Q\u0010=\u0002\u000b%l\u0017mZ3\n\t\t\u0005%\u0011\u0010\u0002\u000f\u001b\u0016$\u0018\rZ1uC2{\u0017\rZ3s\u0003)aw.\u00193fe~#S-\u001d\u000b\u0005\u0003#\u00149\tC\u0005\u0002ZF\n\t\u00111\u0001\u0003v\u00059An\\1eKJ\u0004\u0003f\u0001\u001a\u0003\u0016\u000592O\\1qg\"|Go\u001d#jg\u0006\u0014G.\u001a3SK\u0006\u001cxN\\\u000b\u0003\u0005#\u0003bAa%\u0003\u001a\nuUB\u0001BK\u0015\u0011\u00119*a\u0007\u0002\r\u0005$x.\\5d\u0013\u0011\u0011YJ!&\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004BAa(\u0003(:!!\u0011\u0015BR!\r\tYEW\u0005\u0004\u0005KS\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003*\n-&AB*ue&twMC\u0002\u0003&j\u000b\u0001d\u001d8baNDw\u000e^:ESN\f'\r\\3e%\u0016\f7o\u001c8!\u0003=\u0019h.\u00199tQ>$X)\\5ui\u0016\u0014XC\u0001BZ!\u0011\u0011)La/\u000e\u0005\t]&\u0002\u0002B]\u0005w\n\u0011\u0002];cY&\u001c\b.\u001a:\n\t\tu&q\u0017\u0002\u0010':\f\u0007o\u001d5pi\u0016k\u0017\u000e\u001e;fe\u0006\u00192O\\1qg\"|G/R7jiR,'o\u0018\u0013fcR!\u0011\u0011\u001bBb\u0011%\tINNA\u0001\u0002\u0004\u0011\u0019,\u0001\tt]\u0006\u00048\u000f[8u\u000b6LG\u000f^3sA!\u001aqG!\u0006\u0002#Mt\u0017\r]:i_R<UM\\3sCR|'/\u0006\u0002\u0003NB!!Q\u0017Bh\u0013\u0011\u0011\tNa.\u0003#Ms\u0017\r]:i_R<UM\\3sCR|'/A\u000bt]\u0006\u00048\u000f[8u\u000f\u0016tWM]1u_J|F%Z9\u0015\t\u0005E'q\u001b\u0005\n\u00033L\u0014\u0011!a\u0001\u0005\u001b\f!c\u001d8baNDw\u000e^$f]\u0016\u0014\u0018\r^8sA!\u001a!H!\u0006\u0002%QLWM](cU\u0016\u001cGo\u0015;pe\u0016|\u0005\u000f^\u000b\u0003\u0005C\u0004b!!\f\u0003d\n\u001d\u0018\u0002\u0002Bs\u0003?\u0011\u0001b\u00149uS>t\u0017\r\u001c\t\u0005\u0005S\u0014\u00190\u0004\u0002\u0003l*!!Q\u001eBx\u0003\u0015\u0019Ho\u001c:f\u0015\r\u0011\t\u0010V\u0001\u0005i&,'/\u0003\u0003\u0003v\n-(a\u0004+jKJ|%M[3diN#xN]3\u0002'QLWM](cU\u0016\u001cGo\u0015;pe\u0016|\u0005\u000f\u001e\u0011\u0002!!$H\u000f]*feZ,'OQ5oI\u0016\u0014XC\u0001B\u007f!\u0011\u0011yp!\u0005\u000e\u0005\r\u0005!bA*\u0004\u0004)!1QAB\u0004\u0003\u0011AG\u000f\u001e9\u000b\u0007U\u001bIA\u0003\u0003\u0004\f\r5\u0011!C2p]\u001adW/\u001a8u\u0015\t\u0019y!\u0001\u0002j_&!11CB\u0001\u0005UY\u0015MZ6b\u0011R$\boU3sm\u0016\u0014()\u001b8eKJ\fA\u0003\u001b;uaN+'O^3s\u0005&tG-\u001a:`I\u0015\fH\u0003BAi\u00073A\u0011\"!7?\u0003\u0003\u0005\rA!@\u0002#!$H\u000f]*feZ,'OQ5oI\u0016\u0014\b%\u0001\u0006d_BL8i\u001c8gS\u001e$2AZB\u0011\u0011\u0019\u0019\u0019\u0003\u0011a\u0001M\u000611m\u001c8gS\u001e\fa![:Vg\u0016$GCAAd\u00039\u0019H/\u0019:u\r>\u0014(I]8lKJ$\"!!5\u0002%M$\u0018M\u001d;G_J\u001cuN\u001c;s_2dWM]\u0001\u000egR|\u0007OR8s\u0005J|7.\u001a:\u0002#M$x\u000e\u001d$pe\u000e{g\u000e\u001e:pY2,'/A\fsC\u001a$X*\u00198bO\u0016\u0014h)Y;mi\"\u000bg\u000e\u001a7feV\u00111q\u0007\t\u0005\u0007s\u0019y$\u0004\u0002\u0004<)!1QHAD\u0003\u00151\u0017-\u001e7u\u0013\u0011\u0019\tea\u000f\u0003\u0019\u0019\u000bW\u000f\u001c;IC:$G.\u001a:\u000255,G/\u00193bi\u0006du.\u00193fe\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002;\r|g\u000e\u001e:pY2,'o\u0015;beR,\bOR1vYRD\u0015M\u001c3mKJ\fQ%\u001b8ji&\fGN\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\rT8bI\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002C\u0019\fG/\u00197Rk>\u0014X/\\\"p]R\u0014x\u000e\u001c7fe\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002I9|gNR1uC2\fVo\u001c:v[\u000e{g\u000e\u001e:pY2,'OR1vYRD\u0015M\u001c3mKJ\fa$\\3uC\u0012\fG/\u0019)vE2L7\u000f[5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002\u000bM$\u0018M\u001d;\u0002'\u0015t7/\u001e:f\u001d>$(+\u00194u\u0019\u0016\fG-\u001a:\u0002\tM$x\u000e]\u0001\u0015S:LG\u000f\u0013;uaN+'O^3s\u0005&tG-\u001a:")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaProperties metaProps;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final KafkaConfigSchema configSchema;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private KafkaConfig controllerConfig;
    private final MetadataEncryptorFactory metadataEncryptorFactory;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private KafkaHttpServerBinder httpServerBinder;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaProperties metaProps() {
        return this.metaProps;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public void controllerConfig_$eq(KafkaConfig x$1) {
        this.controllerConfig = x$1;
    }

    public MetadataEncryptorFactory metadataEncryptorFactory() {
        return this.metadataEncryptorFactory;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public Optional<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public KafkaHttpServerBinder httpServerBinder() {
        return this.httpServerBinder;
    }

    public void httpServerBinder_$eq(KafkaHttpServerBinder x$1) {
        this.httpServerBinder = x$1;
    }

    private KafkaConfig copyConfig(KafkaConfig config) {
        return new KafkaConfig(config.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$, (Option<String>)new Some((Object)config.brokerSessionUuid()));
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
        }
    }

    public FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$1)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$4)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                    x$6.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                    x$7.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$8)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                    x$9.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                this.brokerMetrics_$eq(BrokerServerMetrics$.MODULE$.apply(this.metrics(), this.time()));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            KafkaRaftManager _raftManager = (KafkaRaftManager)Option$.MODULE$.apply(this.raftManager()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new KafkaRaftManager(this.metaProps(), this.sharedServerConfig(), new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), (Option<String>)new Some((Object)new StringBuilder(11).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-raft").toString()), this.controllerQuorumVotersFuture(), this.raftManagerFaultHandler(), this.tierObjectStoreOpt()));
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            Function<String, String> nameToTenantCallback = this.multiTenantMetadata().isDefined() ? TenantHelpers.NAME_TO_TENANT_CALLBACK : TenantHelpers.NAME_TO_NULL_CALLBACK;
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.metaProps().nodeId()).setTime(this.time()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetadataEncryptorFactory(this.metadataEncryptorFactory()).setNameToTenantCallback(nameToTenantCallback);
            if (this.brokerMetrics() != null) {
                loaderBuilder.setMetadataLoaderMetrics((MetadataLoaderMetrics)this.brokerMetrics());
            }
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.metaProps().nodeId()).setRaftClient(_raftManager.client()).setConfigSchema(this.configSchema()).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.metaProps().nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix(new StringBuilder(7).append("kafka-").append(this.sharedServerConfig().nodeId()).append("-").toString()).build());
            _raftManager.register(this.loader());
            try {
                this.loader().installPublishers(Collections.singletonList(this.snapshotGenerator()));
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            this.initHttpServerBinder();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.stop();
            return;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable & scala.Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.loader_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.raftManager_$eq(null);
        }
        if (this.tierObjectStoreOpt().isPresent()) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.tierObjectStoreOpt().get().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.controllerServerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerServerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.controllerServerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
        this.httpServerBinder_$eq(null);
        this.started_$eq(false);
    }

    public synchronized void initHttpServerBinder() {
        if (this.httpServerBinder() == null) {
            this.httpServerBinder_$eq(new KafkaHttpServerBinder());
        }
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$1) {
        return x$1.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$4) {
        return x$4.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$8) {
        return x$8.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> _raftManager.shutdown(), $this, CoreUtils$.MODULE$.swallow$default$3());
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaProperties metaProps, Time time, Metrics _metrics, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory, Option<MultiTenantMetadata> multiTenantMetadata, KafkaConfigSchema configSchema) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaProps = metaProps;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        this.multiTenantMetadata = multiTenantMetadata;
        this.configSchema = configSchema;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = this.copyConfig(sharedServerConfig);
        this.controllerConfig = this.copyConfig(sharedServerConfig);
        this.metadataEncryptorFactory = new MetadataEncryptorFactory(sharedServerConfig.originals());
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
        this.tierObjectStoreOpt = TierObjectStoreUtils.maybeCreateTierObjectStore(this.copyConfig(sharedServerConfig), metaProps.clusterId(), this.metrics(), time);
    }
}

