/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.google.common.util.concurrent.AtomicDouble;
import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.availability.FileChannelWrapper;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.StorageProbe$;
import kafka.server.StorageProbe$LogDirMetrics$;
import kafka.server.StorageProbeLatencyAggregator;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r}v!\u00021b\u0011\u00031g!\u00025b\u0011\u0003I\u0007\"\u00029\u0002\t\u0003\t\bb\u0002:\u0002\u0005\u0004%\ta\u001d\u0005\b\u0003\u0013\t\u0001\u0015!\u0003u\u0011%\tY!AI\u0001\n\u0003\tiAB\u0003iC\u0002\tI\u0003\u0003\u0006\u0002J\u0019\u0011)\u0019!C\u0005\u0003\u0017B!\"a\u0015\u0007\u0005\u0003\u0005\u000b\u0011BA'\u0011)\t)F\u0002BC\u0002\u0013%\u0011q\u000b\u0005\u000b\u0003c2!\u0011!Q\u0001\n\u0005e\u0003BCA:\r\t\u0015\r\u0011\"\u0003\u0002v!Q\u0011q\u000f\u0004\u0003\u0002\u0003\u0006I!!\u0005\t\rA4A\u0011AA=\u0011%\t\u0019I\u0002b\u0001\n\u0013\t)\t\u0003\u0005\u0002\u000e\u001a\u0001\u000b\u0011BAD\u0011%\tyI\u0002b\u0001\n\u0013\t\t\nC\u0004\u0002\u0014\u001a\u0001\u000b\u0011\u0002?\t\u0013\u0005UeA1A\u0005\n\u0005E\u0005bBAL\r\u0001\u0006I\u0001 \u0005\n\u000333!\u0019!C\u0005\u0003#Cq!a'\u0007A\u0003%A\u0010C\u0005\u0002\u001e\u001a\u0011\r\u0011\"\u0003\u0002\u0012\"9\u0011q\u0014\u0004!\u0002\u0013a\b\"CAQ\r\t\u0007I\u0011BAI\u0011\u001d\t\u0019K\u0002Q\u0001\nqD\u0011\"!*\u0007\u0005\u0004%I!a*\t\u0011\u0005uf\u0001)A\u0005\u0003SC\u0011\"a0\u0007\u0005\u0004%I!!1\t\u0011\u0005%g\u0001)A\u0005\u0003\u0007D\u0011\"a3\u0007\u0005\u0004%I!!4\t\u0011\u0005\u0015h\u0001)A\u0005\u0003\u001fD\u0011\"a:\u0007\u0005\u0004%I!a*\t\u0011\u0005%h\u0001)A\u0005\u0003SC\u0011\"a;\u0007\u0005\u0004%I!!<\t\u0011\u0005Uh\u0001)A\u0005\u0003_D1\"a>\u0007\u0001\u0004\u0005\r\u0011\"\u0003\u0002z\"Y!\u0011\u0001\u0004A\u0002\u0003\u0007I\u0011\u0002B\u0002\u0011-\u0011yA\u0002a\u0001\u0002\u0003\u0006K!a?\t\u0013\tEa\u00011A\u0005\n\tM\u0001\"CB\u0007\r\u0001\u0007I\u0011BB\b\u0011!\u0019\u0019B\u0002Q!\n\tU\u0001\"CB\u000b\r\t\u0007I\u0011BB\f\u0011!\u0019)C\u0002Q\u0001\n\re\u0001\"CB\u0014\r\t\u0007I\u0011BAC\u0011!\u0019IC\u0002Q\u0001\n\u0005\u001d\u0005\"CB\u0016\r\u0001\u0007I\u0011BB\u0017\u0011%\u0019yC\u0002a\u0001\n\u0013\u0019\t\u0004\u0003\u0005\u00046\u0019\u0001\u000b\u0015\u0002B>\u0011\u001d\u0019yD\u0002C\u0001\u0007\u0003Bqaa\u0011\u0007\t\u0003\u0019\t\u0005C\u0004\u0004F\u0019!\taa\u0012\t\u000f\rUc\u0001\"\u0001\u0004X!91q\f\u0004\u0005\u0002\r\u0005\u0003bBB5\r\u0011\u00051\u0011\t\u0005\b\u0007W2A\u0011IB7\u0011\u001d\u0019\u0019H\u0002C!\u0007kBqaa\u001f\u0007\t\u0003\u001aiH\u0002\u0004\u00032\u0019\u0001%1\u0007\u0005\u000b\u0005\u0003R$Q3A\u0005\u0002\t\r\u0003B\u0003B*u\tE\t\u0015!\u0003\u0003F!Q!Q\u000b\u001e\u0003\u0016\u0004%\t!a*\t\u0015\t]#H!E!\u0002\u0013\tI\u000b\u0003\u0006\u0003Zi\u0012)\u001a!C\u0001\u00057B!Ba\u001c;\u0005#\u0005\u000b\u0011\u0002B/\u0011)\u0011\tH\u000fBK\u0002\u0013\u0005!1\u000f\u0005\u000b\u0005\u0003S$\u0011#Q\u0001\n\tU\u0004B\u0003BBu\tU\r\u0011\"\u0001\u0003\u0006\"Q!q\u0012\u001e\u0003\u0012\u0003\u0006IAa\"\t\u0015\tE%H!f\u0001\n\u0003\u0011\u0019\b\u0003\u0006\u0003\u0014j\u0012\t\u0012)A\u0005\u0005kB!B!&;\u0005+\u0007I\u0011\u0001B:\u0011)\u00119J\u000fB\tB\u0003%!Q\u000f\u0005\u0007aj\"\tA!'\t\u0013\t%&(!A\u0005\u0002\t-\u0006\"\u0003B^uE\u0005I\u0011\u0001B_\u0011%\u0011\tMOI\u0001\n\u0003\u0011\u0019\rC\u0005\u0003Hj\n\n\u0011\"\u0001\u0003J\"I!Q\u001a\u001e\u0012\u0002\u0013\u0005!q\u001a\u0005\n\u0005'T\u0014\u0013!C\u0001\u0005+D\u0011B!7;#\u0003%\tAa4\t\u0013\tm'(%A\u0005\u0002\t=\u0007\"\u0003Bou\u0005\u0005I\u0011IAI\u0011%\u0011yNOA\u0001\n\u0003\t)\tC\u0005\u0003bj\n\t\u0011\"\u0001\u0003d\"I!Q\u001e\u001e\u0002\u0002\u0013\u0005#q\u001e\u0005\n\u0005sT\u0014\u0011!C\u0001\u0005wD\u0011Ba@;\u0003\u0003%\te!\u0001\t\u0013\r\r!(!A\u0005B\r\u0015\u0001\"CB\u0004u\u0005\u0005I\u0011IB\u0005\u000f%\u0019)IBA\u0001\u0012\u0003\u00199IB\u0005\u00032\u0019\t\t\u0011#\u0001\u0004\n\"1\u0001o\u0017C\u0001\u0007/C\u0011ba\u0001\\\u0003\u0003%)e!\u0002\t\u0013\re5,!A\u0005\u0002\u000em\u0005\"CBV7\u0006\u0005I\u0011QBW\u00031\u0019Fo\u001c:bO\u0016\u0004&o\u001c2f\u0015\t\u00117-\u0001\u0004tKJ4XM\u001d\u0006\u0002I\u0006)1.\u00194lC\u000e\u0001\u0001CA4\u0002\u001b\u0005\t'\u0001D*u_J\fw-\u001a)s_\n,7CA\u0001k!\tYg.D\u0001m\u0015\u0005i\u0017!B:dC2\f\u0017BA8m\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AZ\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\u0005!\bcA;{y6\taO\u0003\u0002xq\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003s2\f!bY8mY\u0016\u001cG/[8o\u0013\tYhOA\u0002TKR\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u0005!A.\u00198h\u0015\t\t\u0019!\u0001\u0003kCZ\f\u0017bAA\u0004}\n11\u000b\u001e:j]\u001e\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000fI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005=!\u0006BA\t\u0003/\u00012a[A\n\u0013\r\t)\u0002\u001c\u0002\b\u0005>|G.Z1oW\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0012Y\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0012Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,7#\u0003\u0004\u0002,\u0005E\u0012qGA\"!\ri\u0018QF\u0005\u0004\u0003_q(AB(cU\u0016\u001cG\u000fE\u0002~\u0003gI1!!\u000e\u007f\u0005!\u0011VO\u001c8bE2,\u0007\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005u2-A\u0003vi&d7/\u0003\u0003\u0002B\u0005m\"a\u0002'pO\u001eLgn\u001a\t\u0004O\u0006\u0015\u0013bAA$C\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\faaY8oM&<WCAA'!\r9\u0017qJ\u0005\u0004\u0003#\n'aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0003uS6,WCAA-!\u0011\tY&!\u001c\u000e\u0005\u0005u#\u0002BA\u001f\u0003?RA!!\u0019\u0002d\u000511m\\7n_:T1\u0001ZA3\u0015\u0011\t9'!\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY'A\u0002pe\u001eLA!a\u001c\u0002^\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003-\u0019H/\u0019:u)\"\u0014X-\u00193\u0016\u0005\u0005E\u0011\u0001D:uCJ$H\u000b\u001b:fC\u0012\u0004C\u0003CA>\u0003{\ny(!!\u0011\u0005\u001d4\u0001bBA%\u001b\u0001\u0007\u0011Q\n\u0005\b\u0003+j\u0001\u0019AA-\u0011%\t\u0019(\u0004I\u0001\u0002\u0004\t\t\"A\u0004wKJ\u001c\u0018n\u001c8\u0016\u0005\u0005\u001d\u0005cA6\u0002\n&\u0019\u00111\u00127\u0003\u0007%sG/\u0001\u0005wKJ\u001c\u0018n\u001c8!\u0003Ea\u0017\r^3oGflU\r\u001e:jG:\u000bW.Z\u000b\u0002y\u0006\u0011B.\u0019;f]\u000eLX*\u001a;sS\u000et\u0015-\\3!\u0003Y\u0019WO\u001d:f]R<&/\u001b;f\u001b\u0016$(/[2OC6,\u0017aF2veJ,g\u000e^,sSR,W*\u001a;sS\u000et\u0015-\\3!\u0003!b\u0017m\u001d;Tk\u000e\u001cWm]:gk2\u0004&o\u001c2f/&tGm\\<fI\u00063x-T3ue&\u001cg*Y7f\u0003%b\u0017m\u001d;Tk\u000e\u001cWm]:gk2\u0004&o\u001c2f/&tGm\\<fI\u00063x-T3ue&\u001cg*Y7fA\u0005AC.Y:u'V\u001c7-Z:tMVd\u0007K]8cK^Kg\u000eZ8xK\u0012l\u0015\r_'fiJL7MT1nK\u0006IC.Y:u'V\u001c7-Z:tMVd\u0007K]8cK^Kg\u000eZ8xK\u0012l\u0015\r_'fiJL7MT1nK\u0002\n!d\u001d7po^\u0013\u0018\u000e^3D_VtG/\u001a:NKR\u0014\u0018n\u0019(b[\u0016\f1d\u001d7po^\u0013\u0018\u000e^3D_VtG/\u001a:NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013!\u00048v[Ncwn^,sSR,7/\u0006\u0002\u0002*B!\u00111VA]\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016AB1u_6L7M\u0003\u0003\u00024\u0006U\u0016AC2p]\u000e,(O]3oi*!\u0011qWA\u0001\u0003\u0011)H/\u001b7\n\t\u0005m\u0016Q\u0016\u0002\u000b\u0003R|W.[2M_:<\u0017A\u00048v[Ncwn^,sSR,7\u000fI\u0001\u0012Y\u0006\u001cHOR5wK2\u000bG/\u001a8dS\u0016\u001cXCAAb!\r9\u0017QY\u0005\u0004\u0003\u000f\f'!H*u_J\fw-\u001a)s_\n,G*\u0019;f]\u000eL\u0018iZ4sK\u001e\fGo\u001c:\u0002%1\f7\u000f\u001e$jm\u0016d\u0015\r^3oG&,7\u000fI\u0001\u0013o&tGm\\<Bm\u001ed\u0015\r^3oG&,7/\u0006\u0002\u0002PB!\u0011\u0011[Aq\u001b\t\t\u0019N\u0003\u0003\u00024\u0006U'\u0002BA\\\u0003/TA!!\u0019\u0002Z*!\u00111\\Ao\u0003\u00199wn\\4mK*\u0011\u0011q\\\u0001\u0004G>l\u0017\u0002BAr\u0003'\u0014A\"\u0011;p[&\u001cGi\\;cY\u0016\f1c^5oI><\u0018I^4MCR,gnY5fg\u0002\n!c^5oI><X*\u0019=MCR,gnY5fg\u0006\u0019r/\u001b8e_^l\u0015\r\u001f'bi\u0016t7-[3tA\u0005a1\u000f[;uI><hN\u00127bOV\u0011\u0011q\u001e\t\u0005\u0003W\u000b\t0\u0003\u0003\u0002t\u00065&!D!u_6L7MQ8pY\u0016\fg.A\u0007tQV$Hm\\<o\r2\fw\rI\u0001\u0007i\"\u0014X-\u00193\u0016\u0005\u0005m\b\u0003BA.\u0003{LA!a@\u0002^\tY1*\u00194lCRC'/Z1e\u0003)!\bN]3bI~#S-\u001d\u000b\u0005\u0005\u000b\u0011Y\u0001E\u0002l\u0005\u000fI1A!\u0003m\u0005\u0011)f.\u001b;\t\u0013\t5Q%!AA\u0002\u0005m\u0018a\u0001=%c\u00059A\u000f\u001b:fC\u0012\u0004\u0013aB7fiJL7m]\u000b\u0003\u0005+\u0001bAa\u0006\u0003(\t5b\u0002\u0002B\r\u0005GqAAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0004\u0005?)\u0017A\u0002\u001fs_>$h(C\u0001n\u0013\r\u0011)\u0003\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011ICa\u000b\u0003\t1K7\u000f\u001e\u0006\u0004\u0005Ka\u0007c\u0001B\u0018u5\taAA\u0007M_\u001e$\u0015N]'fiJL7m]\n\u0007u)\u0014)Da\u000f\u0011\u0007-\u00149$C\u0002\u0003:1\u0014q\u0001\u0015:pIV\u001cG\u000fE\u0002l\u0005{I1Aa\u0010m\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011q\u0017-\\3\u0016\u0005\t\u0015\u0003\u0003\u0002B$\u0005\u001frAA!\u0013\u0003LA\u0019!1\u00047\n\u0007\t5C.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\u0011\tFC\u0002\u0003N1\fQA\\1nK\u0002\nQcY;se\u0016tGo\u0016:ji\u0016\u001cF/\u0019:uK\u0012l5/\u0001\fdkJ\u0014XM\u001c;Xe&$Xm\u0015;beR,G-T:!\u0003%A\u0017n\u001d;pOJ\fW.\u0006\u0002\u0003^A!!q\fB6\u001b\t\u0011\tG\u0003\u0003\u0003d\t\u0015\u0014\u0001B2pe\u0016TAA!\u0005\u0003h)!!\u0011NAo\u0003\u0019I\u0018-\\7fe&!!Q\u000eB1\u0005%A\u0015n\u001d;pOJ\fW.\u0001\u0006iSN$xn\u001a:b[\u0002\n\u0011\u0002[3beR\u0014W-\u0019;\u0016\u0005\tU\u0004C\u0002B0\u0005o\u0012Y(\u0003\u0003\u0003z\t\u0005$!B$bk\u001e,\u0007cA6\u0003~%\u0019!q\u00107\u0003\t1{gnZ\u0001\u000bQ\u0016\f'\u000f\u001e2fCR\u0004\u0013A\u00057bi\u0016t7-_,j]\u0012|w/\u001a3Bm\u001e,\"Aa\"\u0011\r\t}#q\u000fBE!\rY'1R\u0005\u0004\u0005\u001bc'A\u0002#pk\ndW-A\nmCR,gnY=XS:$wn^3e\u0003Z<\u0007%\u0001\nmCR,gnY=XS:$wn^3e\u001b\u0006D\u0018a\u00057bi\u0016t7-_,j]\u0012|w/\u001a3NCb\u0004\u0013AD:m_^<&/\u001b;f\u0007>,h\u000e^\u0001\u0010g2|wo\u0016:ji\u0016\u001cu.\u001e8uAQ\u0001\"Q\u0006BN\u0005;\u0013yJ!)\u0003$\n\u0015&q\u0015\u0005\b\u0005\u0003J\u0005\u0019\u0001B#\u0011\u001d\u0011)&\u0013a\u0001\u0003SCqA!\u0017J\u0001\u0004\u0011i\u0006C\u0004\u0003r%\u0003\rA!\u001e\t\u000f\t\r\u0015\n1\u0001\u0003\b\"9!\u0011S%A\u0002\tU\u0004b\u0002BK\u0013\u0002\u0007!QO\u0001\u0005G>\u0004\u0018\u0010\u0006\t\u0003.\t5&q\u0016BY\u0005g\u0013)La.\u0003:\"I!\u0011\t&\u0011\u0002\u0003\u0007!Q\t\u0005\n\u0005+R\u0005\u0013!a\u0001\u0003SC\u0011B!\u0017K!\u0003\u0005\rA!\u0018\t\u0013\tE$\n%AA\u0002\tU\u0004\"\u0003BB\u0015B\u0005\t\u0019\u0001BD\u0011%\u0011\tJ\u0013I\u0001\u0002\u0004\u0011)\bC\u0005\u0003\u0016*\u0003\n\u00111\u0001\u0003v\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B`U\u0011\u0011)%a\u0006\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0019\u0016\u0005\u0003S\u000b9\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t-'\u0006\u0002B/\u0003/\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003R*\"!QOA\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"Aa6+\t\t\u001d\u0015qC\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005K\u0014Y\u000fE\u0002l\u0005OL1A!;m\u0005\r\te.\u001f\u0005\n\u0005\u001b!\u0016\u0011!a\u0001\u0003\u000f\u000bq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005c\u0004bAa=\u0003v\n\u0015X\"\u0001=\n\u0007\t]\bP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\t\u0005{D\u0011B!\u0004W\u0003\u0003\u0005\rA!:\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\"\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001`\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E11\u0002\u0005\n\u0005\u001bI\u0016\u0011!a\u0001\u0005K\f1\"\\3ue&\u001c7o\u0018\u0013fcR!!QAB\t\u0011%\u0011i\u0001KA\u0001\u0002\u0004\u0011)\"\u0001\u0005nKR\u0014\u0018nY:!\u00031iW\r\u001e:jGN<%o\\;q+\t\u0019I\u0002\u0005\u0003\u0004\u001c\r\u0005RBAB\u000f\u0015\u0011\u0011\tba\b\u000b\u0007\t\f\u0019'\u0003\u0003\u0004$\ru!!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0001d\u001e:ji\u0016$\u0016.\\3XCJtG\u000b\u001b:fg\"|G\u000eZ't\u0003e9(/\u001b;f)&lWmV1s]RC'/Z:i_2$Wj\u001d\u0011\u0002)Mdwn^,sSR,G\u000b\u001b:fg\"|G\u000eZ't+\t\u0011Y(\u0001\rtY><xK]5uKRC'/Z:i_2$Wj]0%KF$BA!\u0002\u00044!I!QB\u0018\u0002\u0002\u0003\u0007!1P\u0001\u0016g2|wo\u0016:ji\u0016$\u0006N]3tQ>dG-T:!Q\r\u00014\u0011\b\t\u0004W\u000em\u0012bAB\u001fY\nAao\u001c7bi&dW-A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\t\u0015\u0011\u0001C:ikR$wn\u001e8\u0002\u000fA\f\u0017\u0010\\8bIR\u00111\u0011\n\t\u0005\u0007\u0017\u001a\t&\u0004\u0002\u0004N)!1qJA\u0001\u0003\rq\u0017n\\\u0005\u0005\u0007'\u001aiE\u0001\u0006CsR,')\u001e4gKJ\fQ\u0001\u001d:pE\u0016$\"a!\u0017\u0011\u0011\t\u001d31\fB#\u0005wJAa!\u0018\u0003R\t\u0019Q*\u00199\u0002\u0007I,h\u000eK\u00026\u0007G\u00022!`B3\u0013\r\u00199G \u0002\t\u001fZ,'O]5eK\u0006I3/\u001a;MCN$8+^2dKN\u001ch-\u001e7Qe>\u0014WmV5oI><X\rZ!hOJ,w-\u0019;j_:\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0004pA1!qIB9\u0005\u000bJ1a\u001fB)\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0003\u0006\r]\u0004bBB=q\u0001\u0007\u0011QJ\u0001\n]\u0016<8i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1!QAB@\u0007\u0007Cqa!!:\u0001\u0004\ti%A\u0005pY\u0012\u001cuN\u001c4jO\"91\u0011P\u001dA\u0002\u00055\u0013!\u0004'pO\u0012K'/T3ue&\u001c7\u000fE\u0002\u00030m\u001bRaWBF\u0005w\u0001Bc!$\u0004\u0014\n\u0015\u0013\u0011\u0016B/\u0005k\u00129I!\u001e\u0003v\t5RBABH\u0015\r\u0019\t\n\\\u0001\beVtG/[7f\u0013\u0011\u0019)ja$\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tw\u0007\u0006\u0002\u0004\b\u0006)\u0011\r\u001d9msR\u0001\"QFBO\u0007?\u001b\tka)\u0004&\u000e\u001d6\u0011\u0016\u0005\b\u0005\u0003r\u0006\u0019\u0001B#\u0011\u001d\u0011)F\u0018a\u0001\u0003SCqA!\u0017_\u0001\u0004\u0011i\u0006C\u0004\u0003ry\u0003\rA!\u001e\t\u000f\t\re\f1\u0001\u0003\b\"9!\u0011\u00130A\u0002\tU\u0004b\u0002BK=\u0002\u0007!QO\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019yka/\u0011\u000b-\u001c\tl!.\n\u0007\rMFN\u0001\u0004PaRLwN\u001c\t\u0012W\u000e]&QIAU\u0005;\u0012)Ha\"\u0003v\tU\u0014bAB]Y\n1A+\u001e9mK^B\u0011b!0`\u0003\u0003\u0005\rA!\f\u0002\u0007a$\u0003\u0007")
public class StorageProbe
implements Runnable,
Logging,
BrokerReconfigurable {
    private volatile StorageProbe$LogDirMetrics$ LogDirMetrics$module;
    private final KafkaConfig config;
    private final Time time;
    private final boolean startThread;
    private final int version;
    private final String latencyMetricName;
    private final String currentWriteMetricName;
    private final String lastSuccessfulProbeWindowedAvgMetricName;
    private final String lastSuccessfulProbeWindowedMaxMetricName;
    private final String slowWriteCounterMetricName;
    private final AtomicLong numSlowWrites;
    private final StorageProbeLatencyAggregator lastFiveLatencies;
    private final AtomicDouble windowAvgLatencies;
    private final AtomicLong windowMaxLatencies;
    private final AtomicBoolean shutdownFlag;
    private KafkaThread thread;
    private List<LogDirMetrics> metrics;
    private final KafkaMetricsGroup metricsGroup;
    private final int writeTimeWarnThresholdMs;
    private volatile long slowWriteThresholdMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return StorageProbe$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> ReconfigurableConfigs() {
        return StorageProbe$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public StorageProbe$LogDirMetrics$ LogDirMetrics() {
        if (this.LogDirMetrics$module == null) {
            this.LogDirMetrics$lzycompute$1();
        }
        return this.LogDirMetrics$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private Time time() {
        return this.time;
    }

    private boolean startThread() {
        return this.startThread;
    }

    private int version() {
        return this.version;
    }

    private String latencyMetricName() {
        return this.latencyMetricName;
    }

    private String currentWriteMetricName() {
        return this.currentWriteMetricName;
    }

    private String lastSuccessfulProbeWindowedAvgMetricName() {
        return this.lastSuccessfulProbeWindowedAvgMetricName;
    }

    private String lastSuccessfulProbeWindowedMaxMetricName() {
        return this.lastSuccessfulProbeWindowedMaxMetricName;
    }

    private String slowWriteCounterMetricName() {
        return this.slowWriteCounterMetricName;
    }

    private AtomicLong numSlowWrites() {
        return this.numSlowWrites;
    }

    private StorageProbeLatencyAggregator lastFiveLatencies() {
        return this.lastFiveLatencies;
    }

    private AtomicDouble windowAvgLatencies() {
        return this.windowAvgLatencies;
    }

    private AtomicLong windowMaxLatencies() {
        return this.windowMaxLatencies;
    }

    private AtomicBoolean shutdownFlag() {
        return this.shutdownFlag;
    }

    private KafkaThread thread() {
        return this.thread;
    }

    private void thread_$eq(KafkaThread x$1) {
        this.thread = x$1;
    }

    private List<LogDirMetrics> metrics() {
        return this.metrics;
    }

    private void metrics_$eq(List<LogDirMetrics> x$1) {
        this.metrics = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private int writeTimeWarnThresholdMs() {
        return this.writeTimeWarnThresholdMs;
    }

    private long slowWriteThresholdMs() {
        return this.slowWriteThresholdMs;
    }

    private void slowWriteThresholdMs_$eq(long x$1) {
        this.slowWriteThresholdMs = x$1;
    }

    public void startup() {
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics_$eq((List<LogDirMetrics>)((TraversableOnce)this.config().logDirs().map((Function1 & Serializable & scala.Serializable)logDir -> {
                scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), logDir)}));
                AtomicLong currentWriteTimeStartedMs = new AtomicLong(-1L);
                return new LogDirMetrics(this, (String)logDir, currentWriteTimeStartedMs, this.metricsGroup().newHistogram(this.latencyMetricName(), true, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.currentWriteMetricName(), (Gauge)new Gauge<Object>(this, currentWriteTimeStartedMs){
                    private final /* synthetic */ StorageProbe $outer;
                    private final AtomicLong currentWriteTimeStartedMs$1;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$2(this.currentWriteTimeStartedMs$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentWriteTimeStartedMs$1 = currentWriteTimeStartedMs$1;
                    }
                }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.lastSuccessfulProbeWindowedAvgMetricName(), (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ StorageProbe $outer;

                    public final double value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$3();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.lastSuccessfulProbeWindowedMaxMetricName(), (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ StorageProbe $outer;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$4();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava()), (Gauge<Object>)this.metricsGroup().newGauge(this.slowWriteCounterMetricName(), (Gauge)new Gauge<Object>(this){
                    private final /* synthetic */ StorageProbe $outer;

                    public final long value() {
                        return this.$outer.kafka$server$StorageProbe$$$anonfun$startup$5();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava()));
            }, Seq$.MODULE$.canBuildFrom())).toList());
            String nonDaemon_name = "StorageProbe";
            this.thread_$eq(new KafkaThread(nonDaemon_name, (Runnable)this, false));
            if (this.startThread()) {
                this.thread().start();
                return;
            }
        }
    }

    public void shutdown() {
        this.shutdownFlag().set(true);
        if (Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()) > 0L) {
            this.metrics().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                StorageProbe.$anonfun$shutdown$1(this, logDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ByteBuffer payload() {
        return ByteBuffer.wrap(new StringBuilder(1).append(this.version()).append(",").append(this.time().milliseconds()).toString().getBytes(StandardCharsets.UTF_8));
    }

    public scala.collection.immutable.Map<String, Object> probe() {
        return ((TraversableOnce)this.metrics().map((Function1 & Serializable & scala.Serializable)logDir -> {
            try {
                Tuple2 tuple2;
                Path path = Paths.get(logDir.name(), "storage.probe");
                ByteBuffer payloadBytes = this.payload();
                logDir.currentWriteStartedMs().set(this.time().hiResClockMs());
                FileChannel fc = FileChannelWrapper.open((Path)path, (OpenOption[])new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE});
                try {
                    FileChannelWrapper.truncate((FileChannel)fc, (long)0L);
                    long startMs = this.time().hiResClockMs();
                    FileChannelWrapper.write((FileChannel)fc, (ByteBuffer)payloadBytes);
                    FileChannelWrapper.force((FileChannel)fc, (boolean)true);
                    long tookMs = this.time().hiResClockMs() - startMs;
                    this.lastFiveLatencies().enqueue(tookMs);
                    if (tookMs >= (long)this.writeTimeWarnThresholdMs()) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("slow storage probe write detected (>=").append(this.writeTimeWarnThresholdMs()).append("ms). Flush took ").append(tookMs).append("ms").toString());
                    }
                    if (tookMs >= this.slowWriteThresholdMs()) {
                        this.numSlowWrites().incrementAndGet();
                    } else {
                        this.numSlowWrites().set(0L);
                    }
                    this.setLastSuccessfulProbeWindowedAggregation();
                    logDir.histogram().update(tookMs);
                    tuple2 = new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)tookMs));
                }
                finally {
                    logDir.currentWriteStartedMs().set(-1L);
                    FileChannelWrapper.close((FileChannel)fc);
                }
                return tuple2;
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed writing storage probe data to logdir ").append(logDir.name()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                return new Tuple2((Object)logDir.name(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public void run() {
        ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.BACKGROUND_THREAD);
        do {
            ThreadCountersManager.wrapIO(() -> this.probe());
            Thread.sleep(Predef$.MODULE$.Long2long(this.config().confluentConfig().storageProbePeriodMs()));
        } while (!this.shutdownFlag().get());
    }

    public void setLastSuccessfulProbeWindowedAggregation() {
        if (this.lastFiveLatencies().isEmpty()) {
            this.windowAvgLatencies().set(0.0);
            this.windowMaxLatencies().set(0L);
            return;
        }
        this.windowAvgLatencies().set(this.lastFiveLatencies().avg());
        this.windowMaxLatencies().set(this.lastFiveLatencies().max());
    }

    public Set<String> reconfigurableConfigs() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.StorageProbeSlowWriteThresholdMsProp()}));
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Long l = oldConfig.confluentConfig().storageProbeSlowWriteThresholdMs();
        Long l2 = newConfig.confluentConfig().storageProbeSlowWriteThresholdMs();
        if (l == null ? l2 != null : !((Object)l).equals(l2)) {
            this.slowWriteThresholdMs_$eq(Predef$.MODULE$.Long2long(newConfig.confluentConfig().storageProbeSlowWriteThresholdMs()));
        }
    }

    private final void LogDirMetrics$lzycompute$1() {
        synchronized (this) {
            if (this.LogDirMetrics$module == null) {
                this.LogDirMetrics$module = new StorageProbe$LogDirMetrics$(this);
            }
            return;
        }
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$2(AtomicLong currentWriteTimeStartedMs$1) {
        long startedMs = currentWriteTimeStartedMs$1.get();
        if (startedMs == -1L) {
            return 0L;
        }
        return this.time().hiResClockMs() - startedMs;
    }

    public final /* synthetic */ double kafka$server$StorageProbe$$$anonfun$startup$3() {
        return this.windowAvgLatencies().get();
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$4() {
        return this.windowMaxLatencies().get();
    }

    public final /* synthetic */ long kafka$server$StorageProbe$$$anonfun$startup$5() {
        return this.numSlowWrites().get();
    }

    public static final /* synthetic */ void $anonfun$shutdown$1(StorageProbe $this, LogDirMetrics logDir) {
        scala.collection.immutable.Map tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logdir"), (Object)logDir.name())}));
        $this.metricsGroup().removeMetric($this.latencyMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.currentWriteMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.lastSuccessfulProbeWindowedAvgMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.lastSuccessfulProbeWindowedMaxMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
        $this.metricsGroup().removeMetric($this.slowWriteCounterMetricName(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)tags).asJava());
    }

    public StorageProbe(KafkaConfig config, Time time, boolean startThread) {
        this.config = config;
        this.time = time;
        this.startThread = startThread;
        Logging.$init$(this);
        this.version = 0;
        this.latencyMetricName = "StorageProbeLatencyMs";
        this.currentWriteMetricName = "CurrentWriteDurationMs";
        this.lastSuccessfulProbeWindowedAvgMetricName = "LastSuccessfulProbeWindowedAvgMs";
        this.lastSuccessfulProbeWindowedMaxMetricName = "LastSuccessfulProbeWindowedMaxMs";
        this.slowWriteCounterMetricName = "SlowWriteCounter";
        this.numSlowWrites = new AtomicLong(0L);
        this.lastFiveLatencies = new StorageProbeLatencyAggregator(5);
        this.windowAvgLatencies = new AtomicDouble(0.0);
        this.windowMaxLatencies = new AtomicLong(0L);
        this.shutdownFlag = new AtomicBoolean(false);
        this.metrics = Nil$.MODULE$;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.writeTimeWarnThresholdMs = 5000;
        this.slowWriteThresholdMs = 5000L;
    }

    public class LogDirMetrics
    implements Product,
    scala.Serializable {
        private final String name;
        private final AtomicLong currentWriteStartedMs;
        private final Histogram histogram;
        private final Gauge<Object> heartbeat;
        private final Gauge<Object> latencyWindowedAvg;
        private final Gauge<Object> latencyWindowedMax;
        private final Gauge<Object> slowWriteCount;
        public final /* synthetic */ StorageProbe $outer;

        public String name() {
            return this.name;
        }

        public AtomicLong currentWriteStartedMs() {
            return this.currentWriteStartedMs;
        }

        public Histogram histogram() {
            return this.histogram;
        }

        public Gauge<Object> heartbeat() {
            return this.heartbeat;
        }

        public Gauge<Object> latencyWindowedAvg() {
            return this.latencyWindowedAvg;
        }

        public Gauge<Object> latencyWindowedMax() {
            return this.latencyWindowedMax;
        }

        public Gauge<Object> slowWriteCount() {
            return this.slowWriteCount;
        }

        public LogDirMetrics copy(String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat, Gauge<Object> latencyWindowedAvg, Gauge<Object> latencyWindowedMax, Gauge<Object> slowWriteCount) {
            return new LogDirMetrics(this.kafka$server$StorageProbe$LogDirMetrics$$$outer(), name, currentWriteStartedMs, histogram, heartbeat, latencyWindowedAvg, latencyWindowedMax, slowWriteCount);
        }

        public String copy$default$1() {
            return this.name();
        }

        public AtomicLong copy$default$2() {
            return this.currentWriteStartedMs();
        }

        public Histogram copy$default$3() {
            return this.histogram();
        }

        public Gauge<Object> copy$default$4() {
            return this.heartbeat();
        }

        public Gauge<Object> copy$default$5() {
            return this.latencyWindowedAvg();
        }

        public Gauge<Object> copy$default$6() {
            return this.latencyWindowedMax();
        }

        public Gauge<Object> copy$default$7() {
            return this.slowWriteCount();
        }

        public String productPrefix() {
            return "LogDirMetrics";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.currentWriteStartedMs();
                }
                case 2: {
                    return this.histogram();
                }
                case 3: {
                    return this.heartbeat();
                }
                case 4: {
                    return this.latencyWindowedAvg();
                }
                case 5: {
                    return this.latencyWindowedMax();
                }
                case 6: {
                    return this.slowWriteCount();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LogDirMetrics;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof LogDirMetrics)) return false;
            if (((LogDirMetrics)x$1).kafka$server$StorageProbe$LogDirMetrics$$$outer() != this.kafka$server$StorageProbe$LogDirMetrics$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LogDirMetrics logDirMetrics = (LogDirMetrics)x$1;
            String string = this.name();
            String string2 = logDirMetrics.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equalsNumNum((Number)this.currentWriteStartedMs(), (Number)logDirMetrics.currentWriteStartedMs())) return false;
            Histogram histogram = this.histogram();
            Histogram histogram2 = logDirMetrics.histogram();
            if (histogram == null) {
                if (histogram2 != null) {
                    return false;
                }
            } else if (!histogram.equals(histogram2)) return false;
            Gauge<Object> gauge = this.heartbeat();
            Gauge<Object> gauge2 = logDirMetrics.heartbeat();
            if (gauge == null) {
                if (gauge2 != null) {
                    return false;
                }
            } else if (!gauge.equals(gauge2)) return false;
            Gauge<Object> gauge3 = this.latencyWindowedAvg();
            Gauge<Object> gauge4 = logDirMetrics.latencyWindowedAvg();
            if (gauge3 == null) {
                if (gauge4 != null) {
                    return false;
                }
            } else if (!gauge3.equals(gauge4)) return false;
            Gauge<Object> gauge5 = this.latencyWindowedMax();
            Gauge<Object> gauge6 = logDirMetrics.latencyWindowedMax();
            if (gauge5 == null) {
                if (gauge6 != null) {
                    return false;
                }
            } else if (!gauge5.equals(gauge6)) return false;
            Gauge<Object> gauge7 = this.slowWriteCount();
            Gauge<Object> gauge8 = logDirMetrics.slowWriteCount();
            if (gauge7 == null) {
                if (gauge8 != null) {
                    return false;
                }
            } else if (!gauge7.equals(gauge8)) return false;
            if (!logDirMetrics.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ StorageProbe kafka$server$StorageProbe$LogDirMetrics$$$outer() {
            return this.$outer;
        }

        public LogDirMetrics(StorageProbe $outer, String name, AtomicLong currentWriteStartedMs, Histogram histogram, Gauge<Object> heartbeat, Gauge<Object> latencyWindowedAvg, Gauge<Object> latencyWindowedMax, Gauge<Object> slowWriteCount) {
            this.name = name;
            this.currentWriteStartedMs = currentWriteStartedMs;
            this.histogram = histogram;
            this.heartbeat = heartbeat;
            this.latencyWindowedAvg = latencyWindowedAvg;
            this.latencyWindowedMax = latencyWindowedMax;
            this.slowWriteCount = slowWriteCount;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

