/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import kafka.server.link.ClusterLinkAutoMirroring$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.SourceCluster$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListMirrorsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewMirrorTopic;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u001c9\u0001}B\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003Q\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0001/\t\u0011A\u0004!\u0011!Q\u0001\nuC\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\u0006k\u0002!\tA\u001e\u0005\b{\u0002\u0001\r\u0011\"\u0003\u007f\u0011%\t)\u0001\u0001a\u0001\n\u0013\t9\u0001C\u0004\u0002\u0014\u0001\u0001\u000b\u0015B@\t\u0013\u0005U\u0001A1A\u0005\n\u0005]\u0001\u0002CA \u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0005\u0003A1A\u0005\n\u0005]\u0001\u0002CA\"\u0001\u0001\u0006I!!\u0007\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u0005\u001d\u0003\"CA(\u0001\u0001\u0007I\u0011BA)\u0011!\t)\u0006\u0001Q!\n\u0005%\u0003\"CA,\u0001\t\u0007I\u0011BA-\u0011\u001d\tY\u0006\u0001Q\u0001\n\rD\u0011\"!\u0018\u0001\u0005\u0004%\t!a\u0012\t\u0011\u0005}\u0003\u0001)A\u0005\u0003\u0013B\u0011\"!\u0019\u0001\u0001\u0004%I!a\u0019\t\u0013\u0005-\u0004\u00011A\u0005\n\u00055\u0004\u0002CA9\u0001\u0001\u0006K!!\u001a\t\u0017\u0005M\u0004\u00011AA\u0002\u0013%\u00111\r\u0005\f\u0003k\u0002\u0001\u0019!a\u0001\n\u0013\t9\bC\u0006\u0002|\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0004bBA?\u0001\u0011E\u0013q\u0010\u0005\b\u0003\u0003\u0003A\u0011BA@\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u007fBq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u0014\u0002!I!!&\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\tY\u000e\u0001C\u0005\u0003;Dq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e!9!q\u0002\u0001\u0005\n\tE\u0001\u0002\u0003B\n\u0001\u0011\u0005\u0001(a\u0006\t\u0011\tU\u0001\u0001\"\u00019\u0003/A\u0001Ba\u0006\u0001\t\u0003A\u00141M\u0004\b\u00053A\u0004\u0012\u0001B\u000e\r\u00199\u0004\b#\u0001\u0003\u001e!1Q\u000f\rC\u0001\u0005KA\u0011Ba\n1\u0005\u0004%\tA!\u000b\t\u0011\te\u0002\u0007)A\u0005\u0005WA\u0011Ba\u000f1\u0005\u0004%\tA!\u0010\t\u0011\t-\u0003\u0007)A\u0005\u0005\u007fAqA!\u00141\t\u0003\u0011yE\u0001\rDYV\u001cH/\u001a:MS:\\\u0017)\u001e;p\u001b&\u0014(o\u001c:j]\u001eT!!\u000f\u001e\u0002\t1Lgn\u001b\u0006\u0003wq\naa]3sm\u0016\u0014(\"A\u001f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0011\t\u0003\u0003\u0016s!AQ\"\u000e\u0003aJ!\u0001\u0012\u001d\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t1uI\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002Eq\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012A\u0013\t\u0003\u0005.K!\u0001\u0014\u001d\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0003A\u0003\"AQ)\n\u0005IC$AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003!a\u0017N\\6ECR\f\u0007C\u0001,Z\u001b\u00059&B\u0001-=\u0003\tQ8.\u0003\u0002[/\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-\u0001\teKN$\u0018\tZ7j]\u001a\u000b7\r^8ssV\tQ\fE\u0002_C\u000el\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\n\rVt7\r^5p]B\u0002\"\u0001\u001a8\u000e\u0003\u0015T!AZ4\u0002\u000b\u0005$W.\u001b8\u000b\u0005!L\u0017aB2mS\u0016tGo\u001d\u0006\u0003{)T!a\u001b7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0017aA8sO&\u0011q.\u001a\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003E!Wm\u001d;BI6LgNR1di>\u0014\u0018\u0010I\u0001\b[\u0016$(/[2t!\t\u00115/\u0003\u0002uq\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003\u0019a\u0014N\\5u}Q1q\u000f_={wr\u0004\"A\u0011\u0001\t\u000b!K\u0001\u0019\u0001&\t\u000b9K\u0001\u0019\u0001)\t\u000bQK\u0001\u0019A+\t\u000bmK\u0001\u0019A/\t\u000bEL\u0001\u0019\u0001:\u0002\r\r|gNZ5h+\u0005y\bc\u0001\"\u0002\u0002%\u0019\u00111\u0001\u001d\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!!\u0003\u0002\u0010A\u0019a,a\u0003\n\u0007\u00055qL\u0001\u0003V]&$\b\u0002CA\t\u0017\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002\u00195L'O]8s)>\u0004\u0018nY:\u0016\u0005\u0005e\u0001CBA\u000e\u0003K\tI#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u001diW\u000f^1cY\u0016T1!a\t`\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\tiBA\u0002TKR\u0004B!a\u000b\u0002:9!\u0011QFA\u001b!\r\tycX\u0007\u0003\u0003cQ1!a\r?\u0003\u0019a$o\\8u}%\u0019\u0011qG0\u0002\rA\u0013X\rZ3g\u0013\u0011\tY$!\u0010\u0003\rM#(/\u001b8h\u0015\r\t9dX\u0001\u000e[&\u0014(o\u001c:U_BL7m\u001d\u0011\u0002+\r|gN\u001a7jGRLgn\u001a#fgR$v\u000e]5dg\u000612m\u001c8gY&\u001cG/\u001b8h\t\u0016\u001cH\u000fV8qS\u000e\u001c\b%\u0001\tuCN\\7oT;ugR\fg\u000eZ5oOV\u0011\u0011\u0011\n\t\u0004=\u0006-\u0013bAA'?\n\u0019\u0011J\u001c;\u0002)Q\f7o[:PkR\u001cH/\u00198eS:<w\fJ3r)\u0011\tI!a\u0015\t\u0013\u0005E!#!AA\u0002\u0005%\u0013!\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8hA\u0005IA-Z:u\u0003\u0012l\u0017N\\\u000b\u0002G\u0006QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u00021\r\u0013V)\u0011+F?R{\u0005+S\"T?\n\u000bEk\u0011%`'&SV)A\rD%\u0016\u000bE+R0U\u001fBK5iU0C\u0003R\u001b\u0005jX*J5\u0016\u0003\u0013aC5oSRL\u0017\r\\5{K\u0012,\"!!\u001a\u0011\u0007y\u000b9'C\u0002\u0002j}\u0013qAQ8pY\u0016\fg.A\bj]&$\u0018.\u00197ju\u0016$w\fJ3r)\u0011\tI!a\u001c\t\u0013\u0005E\u0011$!AA\u0002\u0005\u0015\u0014\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013\u0001G:i_VdGMR5mi\u0016\u0014X*\u001b:s_J$v\u000e]5dg\u0006a2\u000f[8vY\u00124\u0015\u000e\u001c;fe6K'O]8s)>\u0004\u0018nY:`I\u0015\fH\u0003BA\u0005\u0003sB\u0011\"!\u0005\u001d\u0003\u0003\u0005\r!!\u001a\u00023MDw.\u001e7e\r&dG/\u001a:NSJ\u0014xN\u001d+pa&\u001c7\u000fI\u0001\u0004eVtGCAA3\u0003]Ig.\u001b;jC2L'0Z!oI\u0006+Ho\\'jeJ|'/\u0001\u0006bkR|W*\u001b:s_J\fa\u0003[1oI2,G*[:u'>,(oY3U_BL7m\u001d\u000b\u0005\u0003K\nI\tC\u0004\u0002\f\u0006\u0002\r!!$\u0002\rI,7/\u001e7u!\r!\u0017qR\u0005\u0004\u0003#+'\u0001\u0005'jgR$v\u000e]5dgJ+7/\u001e7u\u0003qA\u0017M\u001c3mK2K7\u000f^*pkJ\u001cW-T5se>\u0014Hk\u001c9jGN$b!!\u001a\u0002\u0018\u0006}\u0005bBAME\u0001\u0007\u00111T\u0001\u0007i>\u0004\u0018nY:\u0011\r\u0005-\u0012QTA\u0015\u0013\u0011\t9#!\u0010\t\u000f\u0005\u0005&\u00051\u0001\u0002$\u0006\tB.[:u\u001b&\u0014(o\u001c:t\rV$XO]3\u0011\r\u0005\u0015\u00161VAX\u001b\t\t9KC\u0002\u0002*&\faaY8n[>t\u0017\u0002BAW\u0003O\u00131bS1gW\u00064U\u000f^;sKB1\u0011\u0011WA^\u0003Si!!a-\u000b\t\u0005U\u0016qW\u0001\u0005kRLGN\u0003\u0002\u0002:\u0006!!.\u0019<b\u0013\u0011\ti,a-\u0003\u0015\r{G\u000e\\3di&|g.\u0001\u000biC:$G.\u001a$jYR,'/\u001a3U_BL7m\u001d\u000b\u0005\u0003K\n\u0019\rC\u0004\u0002F\u000e\u0002\r!a'\u0002\u001d\u0019LG\u000e^3sK\u0012$v\u000e]5dg\u0006!\u0002.\u00198eY\u0016d\u0015n\u001d;EKN$Hk\u001c9jGN$b!!\u001a\u0002L\u00065\u0007bBAFI\u0001\u0007\u0011Q\u0012\u0005\b\u0003\u000b$\u0003\u0019AAN\u000311\u0017\u000e\u001c;feR{\u0007/[2t)\u0011\tY*a5\t\u000f\u0005eU\u00051\u0001\u0002\u001c\u0006a1M]3bi\u0016$v\u000e]5dgR!\u0011QMAm\u0011\u001d\tIJ\na\u0001\u00037\u000b\u0001D]3n_Z,7k\\;sG\u0016l\u0015N\u001d:peR{\u0007/[2t)\u0019\tY*a8\u0002b\"9\u0011\u0011T\u0014A\u0002\u0005m\u0005bBA\u000bO\u0001\u0007\u00111T\u0001\u0018Q\u0006tG\r\\3CCR\u001c\u0007n\u0011:fCR,Gk\u001c9jGN$B!!\u001a\u0002h\"9\u0011\u0011\u001e\u0015A\u0002\u0005-\u0018!\u0004;pa&\u001cG*[:uS:<7\u000f\u0005\u0005\u00022\u00065\u0018\u0011FAy\u0013\u0011\ty/a-\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002&\u0006-\u00161\u001f\t\u0005\u0003k\fY0\u0004\u0002\u0002x*!\u0011\u0011`A\\\u0003\u0011a\u0017M\\4\n\t\u0005u\u0018q\u001f\u0002\u0005->LG-\u0001\u0010bI\u0012l\u0015N\u001d:pe\u0016$Gk\u001c9jG\u0006sG\rT8h/\u0006\u0014h.\u001b8hgR1\u0011\u0011\u0002B\u0002\u0005\u000fAqA!\u0002*\u0001\u0004\tI#A\u0003u_BL7\rC\u0004\u0003\n%\u0002\r!!=\u0002\r\u0019,H/\u001e:f\u0003=\tG\u000e\u001c'j].,G\rV8qS\u000e\u001cHCAAN\u0003-\u0012XmY8sI\u001a\u000b\u0017\u000e\\3e!J,g-\u001b=fI\u0006+Ho\\'jeJ|'o\u0011:fCR,W*\u001a;sS\u000e\u001cHCAA\u0005\u0003=9W\r^'jeJ|'\u000fV8qS\u000e\u001c\u0018\u0001G4fi\u000e{gN\u001a7jGRLgn\u001a#fgR$v\u000e]5dg\u0006qq-\u001a;J]&$\u0018.\u00197ju\u0016$\u0017\u0001G\"mkN$XM\u001d'j].\fU\u000f^8NSJ\u0014xN]5oOB\u0011!\tM\n\u0004a\t}\u0001c\u00010\u0003\"%\u0019!1E0\u0003\r\u0005s\u0017PU3g)\t\u0011Y\"\u0001\rbI\u0012LG/[8oC2Le\u000e^3s]\u0006dGk\u001c9jGN,\"Aa\u000b\u0011\r\t5\"1\u0007B\u001b\u001b\t\u0011yC\u0003\u0003\u00032\u0005\u0005\u0012!C5n[V$\u0018M\u00197f\u0013\u0011\t9Ca\f\u0011\t\u0005U(qG\u0005\u0005\u0003w\t90A\rbI\u0012LG/[8oC2Le\u000e^3s]\u0006dGk\u001c9jGN\u0004\u0013AH1eI&$\u0018n\u001c8bY&sG/\u001a:oC2$v\u000e]5d!\u0006$H/\u001a:o+\t\u0011y\u0004\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\u0011\u0011)%a-\u0002\u000bI,w-\u001a=\n\t\t%#1\t\u0002\b!\u0006$H/\u001a:o\u0003}\tG\rZ5uS>t\u0017\r\\%oi\u0016\u0014h.\u00197U_BL7\rU1ui\u0016\u0014h\u000eI\u0001\fM&dG/\u001a:U_BL7\r\u0006\u0005\u0002f\tE#q\fB2\u0011\u001d\u0011\u0019F\u000ea\u0001\u0005+\nqB\\1nKN$v\u000eT5ti&twm\u001d\t\t\u00037\u00119&!\u000b\u0003Z%!\u0011q^A\u000f!\r!'1L\u0005\u0004\u0005;*'\u0001\u0004+pa&\u001cG*[:uS:<\u0007b\u0002B1m\u0001\u0007\u0011\u0011J\u0001\naJ,g-\u001b=MK:DqA!\u00027\u0001\u0004\tI\u0003")
public class ClusterLinkAutoMirroring
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private final scala.collection.mutable.Set<String> mirrorTopics;
    private final scala.collection.mutable.Set<String> conflictingDestTopics;
    private int tasksOutstanding;
    private final ConfluentAdmin destAdmin;
    private final int CREATE_TOPICS_BATCH_SIZE;
    private boolean initialized;
    private boolean shouldFilterMirrorTopics;

    public static boolean filterTopic(scala.collection.mutable.Map<String, TopicListing> map, int n, String string) {
        return ClusterLinkAutoMirroring$.MODULE$.filterTopic(map, n, string);
    }

    public static Pattern additionalInternalTopicPattern() {
        return ClusterLinkAutoMirroring$.MODULE$.additionalInternalTopicPattern();
    }

    public static scala.collection.immutable.Set<String> additionalInternalTopics() {
        return ClusterLinkAutoMirroring$.MODULE$.additionalInternalTopics();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private scala.collection.mutable.Set<String> mirrorTopics() {
        return this.mirrorTopics;
    }

    private scala.collection.mutable.Set<String> conflictingDestTopics() {
        return this.conflictingDestTopics;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    public int CREATE_TOPICS_BATCH_SIZE() {
        return this.CREATE_TOPICS_BATCH_SIZE;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private boolean shouldFilterMirrorTopics() {
        return this.shouldFilterMirrorTopics;
    }

    private void shouldFilterMirrorTopics_$eq(boolean x$1) {
        this.shouldFilterMirrorTopics = x$1;
    }

    @Override
    public boolean run() {
        if (!this.initialized()) {
            return this.initializeAndAutoMirror();
        }
        return this.autoMirror();
    }

    private boolean initializeAndAutoMirror() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Initializing auto-mirroring ").append($this.linkData.linkId()).toString());
        if (this.config().clusterLinkPrefix().isEmpty() || ((String)this.config().clusterLinkPrefix().get()).isEmpty()) {
            this.shouldFilterMirrorTopics_$eq(false);
            this.initialized_$eq(true);
            this.autoMirror();
        } else {
            KafkaFuture listMirrorsFuture = this.clientManager().getAdmin().listMirrors(new ListMirrorsOptions()).result();
            this.scheduleWhenComplete(listMirrorsFuture, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                this.shouldFilterMirrorTopics_$eq(SourceCluster$.MODULE$.canContainMirrorTopics($this.metrics, (KafkaFuture<Collection<String>>)listMirrorsFuture));
                this.initialized_$eq(true);
                this.autoMirror();
                return this.tasksOutstanding() == 0;
            });
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean autoMirror() {
        this.mirrorTopics().clear();
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().autoMirroringEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().topicFilters().isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()).append(" is true but no topic filters are specified. No topics will be mirrored.").toString());
            } else {
                this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to list topics from source cluster");
                ListTopicsResult listTopicsResult = this.clientManager().getAdmin().listTopics();
                this.scheduleWhenComplete(listTopicsResult.namesToListings(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListSourceTopics(listTopicsResult));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            }
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleListSourceTopics(ListTopicsResult result) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            ObjectRef filteredTopics = ObjectRef.create((Object)((scala.collection.immutable.Set)this.filterTopics((scala.collection.immutable.Set<String>)((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)result.names().get()).asScala()).toSet()).$minus$minus(this.allLinkedTopics())));
            Map namesToListings = (Map)result.namesToListings().get();
            int prefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).length() + ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).length();
            ((scala.collection.immutable.Set)filteredTopics.elem).foreach((Function1 & Serializable & scala.Serializable)topicName -> {
                ClusterLinkAutoMirroring.$anonfun$handleListSourceTopics$3(this, namesToListings, prefixLength, filteredTopics, topicName);
                return BoxedUnit.UNIT;
            });
            if (!this.shouldFilterMirrorTopics()) {
                this.handleFilteredTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics.elem));
            } else {
                KafkaFuture listMirrorsFuture = this.clientManager().getAdmin().listMirrors(new ListMirrorsOptions()).result();
                this.scheduleWhenComplete(listMirrorsFuture, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListSourceMirrorTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)filteredTopics$1.elem), (KafkaFuture<Collection<String>>)listMirrorsFuture));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            }
        }
        catch (ExecutionException ex) {
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof AuthorizationException) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("Unable to list topics on the source cluster. Please enable DESCRIBE ACLs on the source cluster to proceed. ").append(ex.getCause()).toString());
            }
            if (throwable != null) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("Unable to list topics on the source cluster due to unexpected exception. Topics will not be mirrored. ").append(ex).toString());
            }
            throw new MatchError(null);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("Unable to list topics on the source cluster due to unexpected exception. Topics will not be mirrored. ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromSourceFailedSensor().record();
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleListSourceMirrorTopics(scala.collection.immutable.Set<String> topics, KafkaFuture<Collection<String>> listMirrorsFuture) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            scala.collection.immutable.Set<String> filteredTopics = this.removeSourceMirrorTopics(topics, (scala.collection.immutable.Set<String>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)listMirrorsFuture.get()).asScala()).toSet());
            this.handleFilteredTopics(filteredTopics);
        }
        catch (ExecutionException ex) {
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof AuthorizationException) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Unable to list mirrors on the source cluster. Please enable Describe:Cluster ACLs on the source cluster to proceed. ").append(ex.getCause()).toString());
            }
            if (throwable != null) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Unable to list mirrors on the source cluster due to unexpected exception. Topics will not be mirrored. ").append(ex).toString());
            }
            throw new MatchError(null);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("Unable to list mirrors on the source cluster due to unexpected exception. Topics will not be mirrored. ").append(ex).toString());
            this.metrics.autoMirrorListMirrorsFromSourceFailedSensor().record();
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleFilteredTopics(scala.collection.immutable.Set<String> filteredTopics) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Will attempt to mirror following topics on destination cluster: ").append(filteredTopics).toString());
        if (((TraversableOnce)this.conflictingDestTopics().intersect(filteredTopics)).nonEmpty()) {
            ListTopicsResult listTopicsResult = this.destAdmin().listTopics();
            this.scheduleWhenComplete(listTopicsResult.namesToListings(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleListDestTopics(listTopicsResult, filteredTopics));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        } else {
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.createTopics(filteredTopics);
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleListDestTopics(ListTopicsResult result, scala.collection.immutable.Set<String> filteredTopics) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        try {
            java.util.Set destTopics = (java.util.Set)result.names().get();
            if (this.conflictingDestTopics().nonEmpty()) {
                this.conflictingDestTopics().clear();
            }
            this.conflictingDestTopics().$plus$plus$eq((TraversableOnce)((GenSetLike)CollectionConverters$.MODULE$.asScalaSetConverter(destTopics).asScala()).intersect(filteredTopics));
            if (this.conflictingDestTopics().nonEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Found following conflicting topics on destination: ").append(this.conflictingDestTopics()).toString());
            }
            this.conflictingDestTopics().foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ClusterLinkAutoMirroring.$anonfun$handleListDestTopics$2(this, topic);
                return BoxedUnit.UNIT;
            });
            scala.collection.immutable.Set topicsToCreate = (scala.collection.immutable.Set)filteredTopics.$minus$minus(this.conflictingDestTopics());
            this.createTopics((scala.collection.immutable.Set<String>)topicsToCreate);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Unable to list topics on destination cluster to check for conflicting topics. ").append(ex).toString());
            this.metrics.autoMirrorListTopicsFromDestinationFailedSensor().record();
            this.createTopics(filteredTopics);
        }
        return this.tasksOutstanding() == 0;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<String> filterTopics(scala.collection.immutable.Set<String> topics) {
        void var4_4;
        void var3_3;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Filtering source topics ").append(topics).append(" to match topic filters JSON").toString());
        Tuple2<scala.collection.immutable.Set<String>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterTopics(topics, this.config().topicFilters(), this.linkData.tenantPrefix(), this.config().clusterLinkPrefix());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        void filtered2 = var3_3;
        var4_4.foreach((Function1 & Serializable & scala.Serializable)unusedFilter -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(197).append("The filter ").append(unusedFilter).append(" does not match any source topic. This filter may not be ").append("required or the topics it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return BoxedUnit.UNIT;
        });
        return filtered2;
    }

    private boolean createTopics(scala.collection.immutable.Set<String> topics) {
        int clusterLinkPrefixLength = ((String)this.config().clusterLinkPrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).length();
        int tenantPrefixLength = ((String)this.linkData.tenantPrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).length();
        ((scala.collection.immutable.Set)topics.map((Function1 & Serializable & scala.Serializable)topic -> {
            String mirrorTopicName = clusterLinkPrefixLength > 0 ? new StringBuilder(0).append(topic.substring(0, tenantPrefixLength)).append(topic.substring(tenantPrefixLength + clusterLinkPrefixLength)).toString() : topic;
            return new NewTopic(topic, Optional.empty(), Optional.empty()).mirror(Optional.of(new NewMirrorTopic($this.linkData.linkName(), mirrorTopicName)));
        }, Set$.MODULE$.canBuildFrom())).grouped(this.CREATE_TOPICS_BATCH_SIZE()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            ClusterLinkAutoMirroring.$anonfun$createTopics$4(this, batch);
            return BoxedUnit.UNIT;
        });
        return this.tasksOutstanding() == 0;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<String> removeSourceMirrorTopics(scala.collection.immutable.Set<String> topics, scala.collection.immutable.Set<String> mirrorTopics) {
        void var3_3;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Mirror topics at source ").append(mirrorTopics).toString());
        scala.collection.immutable.Set filteredTopics = (scala.collection.immutable.Set)topics.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkAutoMirroring.$anonfun$removeSourceMirrorTopics$2(mirrorTopics, x$2)));
        scala.collection.immutable.Set filteredOutTopics = (scala.collection.immutable.Set)topics.$minus$minus((GenTraversableOnce)filteredTopics);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Filtering out ").append(filteredOutTopics).append(" because they are mirror topics at the source cluster").toString());
        if (filteredOutTopics.nonEmpty()) {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record((double)filteredOutTopics.size());
        } else {
            this.metrics.prefixedAutoMirrorTopicFilteredSensor().record(0.0);
        }
        return var3_3;
    }

    private boolean handleBatchCreateTopics(Map<String, KafkaFuture<Void>> topicListings) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        topicListings.forEach((topic, future) -> this.addMirroredTopicAndLogWarnings((String)topic, (KafkaFuture<Void>)future));
        return this.tasksOutstanding() == 0;
    }

    private void addMirroredTopicAndLogWarnings(String topic, KafkaFuture<Void> future) {
        try {
            future.get();
            this.mirrorTopics().$plus$eq((Object)topic);
            this.metrics.autoMirrorCreateSensor().record();
            if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()))) {
                this.metrics.prefixedAutoMirrorCreateSensor().record();
            }
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof TopicExistsException) {
                this.conflictingDestTopics().add((Object)topic);
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("Topic ").append(topic).append(" already exists on destination cluster. Will not mirror source").append(" topic. ").append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                return;
            }
            if (throwable instanceof AuthorizationException) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unable to create topic ").append(topic).append(". Please allow CREATE access on destination cluster to proceed. ").append(ex.getCause()).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                return;
            }
            if (throwable != null) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unable to create topic ").append(topic).append(" on destination cluster. ").append(ex).toString());
                this.metrics.autoMirrorCreateFailedSensor().record();
                this.recordFailedPrefixedAutoMirrorCreateMetrics();
                return;
            }
            throw new MatchError(null);
        }
        catch (Throwable ex) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Unable to create topic ").append(topic).append(" on destination cluster. ").append(ex).toString());
            this.metrics.autoMirrorCreateFailedSensor().record();
            this.recordFailedPrefixedAutoMirrorCreateMetrics();
        }
    }

    private scala.collection.immutable.Set<String> allLinkedTopics() {
        return this.metadataManager().mirrorTopicStatesFromMetadataCache(this.linkData.linkId()).keySet().toSet();
    }

    private void recordFailedPrefixedAutoMirrorCreateMetrics() {
        if (!this.config().clusterLinkPrefix().forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isEmpty()))) {
            this.metrics.prefixedAutoMirrorCreateFailedSensor().record();
        }
    }

    public scala.collection.mutable.Set<String> getMirrorTopics() {
        return this.mirrorTopics();
    }

    public scala.collection.mutable.Set<String> getConflictingDestTopics() {
        return this.conflictingDestTopics();
    }

    public boolean getInitialized() {
        return this.initialized();
    }

    public static final /* synthetic */ void $anonfun$handleListSourceTopics$3(ClusterLinkAutoMirroring $this, Map namesToListings$1, int prefixLength$1, ObjectRef filteredTopics$1, String topicName) {
        if (ClusterLinkAutoMirroring$.MODULE$.filterTopic((scala.collection.mutable.Map<String, TopicListing>)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(namesToListings$1).asScala()), prefixLength$1, topicName)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Internal or Confluent topic ").append(topicName).append(" will not be mirrored.").toString());
            filteredTopics$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)filteredTopics$1.elem).$minus((Object)topicName);
        }
    }

    public static final /* synthetic */ void $anonfun$handleListDestTopics$2(ClusterLinkAutoMirroring $this, String topic) {
        $this.metrics.autoMirrorCreateFailedSensor().record();
        $this.recordFailedPrefixedAutoMirrorCreateMetrics();
    }

    public static final /* synthetic */ void $anonfun$createTopics$4(ClusterLinkAutoMirroring $this, scala.collection.immutable.Set batch) {
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Creating following topics on destination cluster: ").append(batch).toString());
        CreateTopicsResult result = $this.destAdmin().createTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)batch).asJava());
        $this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> $this.handleBatchCreateTopics(result.values()));
        $this.tasksOutstanding_$eq($this.tasksOutstanding() + 1);
    }

    public static final /* synthetic */ boolean $anonfun$removeSourceMirrorTopics$2(scala.collection.immutable.Set mirrorTopics$1, String x$2) {
        return !mirrorTopics$1.contains((Object)x$2);
    }

    public ClusterLinkAutoMirroring(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkAutoMirroring", (int)Predef$.MODULE$.Long2long(clientManager.currentConfig().metadataMaxAgeMs()));
        this.config = clientManager.currentConfig();
        this.mirrorTopics = scala.collection.mutable.Set$.MODULE$.empty();
        this.conflictingDestTopics = scala.collection.mutable.Set$.MODULE$.empty();
        this.tasksOutstanding = 0;
        this.destAdmin = (ConfluentAdmin)destAdminFactory.apply();
        this.CREATE_TOPICS_BATCH_SIZE = 100;
        this.initialized = false;
    }
}

