/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.jdk.CollectionConverters$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

public final class ClusterLinkClearLinkReference$
implements Logging {
    public static ClusterLinkClearLinkReference$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkClearLinkReference$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int $lessinit$greater$default$8() {
        return 100;
    }

    public int $lessinit$greater$default$9() {
        return 5000;
    }

    public int $lessinit$greater$default$10() {
        return 1000;
    }

    public boolean shouldClearLinkReference(Uuid linkId, ClusterLinkMetadataManager manager) {
        boolean bl;
        if (manager instanceof ClusterLinkMetadataManagerWithKRaftSupport) {
            bl = false;
        } else if (manager instanceof ClusterLinkMetadataManagerWithZkSupport) {
            Option<ClusterLinkData> cld = manager.getClusterLinkData(linkId);
            bl = cld.isDefined() && ((ClusterLinkData)cld.get()).isDeleted();
        } else {
            if (manager != null) {
                throw new IllegalStateException("Unsupported type of ClusterLinkMetadataManager");
            }
            throw new MatchError(null);
        }
        return bl;
    }

    public boolean handleDeleteAclsResult(DeleteAclsResult deleteAclsResult) {
        BooleanRef success = BooleanRef.create((boolean)true);
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkClearLinkReference$.$anonfun$handleDeleteAclsResult$1(success, x0$1);
            return BoxedUnit.UNIT;
        });
        return success.elem;
    }

    public Tuple2<Object, Object> handleCreateAclsResult(CreateAclsResult createAclsResult) {
        BooleanRef success = BooleanRef.create((boolean)true);
        ExcessiveLoggingHandler excessiveLoggingHandler = new ExcessiveLoggingHandler();
        IntRef aclsFailedToCreateCount = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclsResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            if (x0$1 != null) {
                try {
                    object = ((KafkaFuture)x0$1._2()).get();
                }
                catch (Throwable e) {
                    ++aclsFailedToCreateCount$1.elem;
                    excessiveLoggingHandler.handle(e, MODULE$, "Encountered error while clearing link id from ACLs");
                    success$2.elem = false;
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            Object object2 = object;
            return object2;
        });
        if (aclsFailedToCreateCount.elem > 0 && this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkClearLinkReference$.$anonfun$handleCreateAclsResult$2(aclsFailedToCreateCount, excessiveLoggingHandler)));
        }
        return new Tuple2.mcZI.sp(success.elem, aclsFailedToCreateCount.elem);
    }

    public static final /* synthetic */ String $anonfun$handleDeleteAclsResult$3(DeleteAclsResult.FilterResult aclBindingDeleteResult$1) {
        return new StringBuilder(64).append("Encountered the following exception while trying to delete ACL: ").append((Object)aclBindingDeleteResult$1.exception()).toString();
    }

    public static final /* synthetic */ void $anonfun$handleDeleteAclsResult$2(BooleanRef success$1, DeleteAclsResult.FilterResult aclBindingDeleteResult) {
        if (aclBindingDeleteResult.exception() != null) {
            ClusterLinkClearLinkReference$ clusterLinkClearLinkReference$ = MODULE$;
            if (clusterLinkClearLinkReference$ == null) {
                throw null;
            }
            ClusterLinkClearLinkReference$ warn_this = clusterLinkClearLinkReference$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(ClusterLinkClearLinkReference$.$anonfun$handleDeleteAclsResult$3(aclBindingDeleteResult)));
            }
            success$1.elem = false;
        }
    }

    public static final /* synthetic */ String $anonfun$handleDeleteAclsResult$4() {
        return "Encountered error while clearing link id from ACLs";
    }

    public static final /* synthetic */ void $anonfun$handleDeleteAclsResult$1(BooleanRef success$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                List filters = ((DeleteAclsResult.FilterResults)((KafkaFuture)x0$1._2()).get()).values();
                ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(filters).asScala()).foreach((Function1 & Serializable & scala.Serializable)aclBindingDeleteResult -> {
                    ClusterLinkClearLinkReference$.$anonfun$handleDeleteAclsResult$2(success$1, aclBindingDeleteResult);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable e) {
                ClusterLinkClearLinkReference$ clusterLinkClearLinkReference$ = MODULE$;
                if (clusterLinkClearLinkReference$ == null) {
                    throw null;
                }
                ClusterLinkClearLinkReference$ warn_this = clusterLinkClearLinkReference$;
                if (warn_this.logger().underlying().isWarnEnabled()) {
                    warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(ClusterLinkClearLinkReference$.$anonfun$handleDeleteAclsResult$4()), e);
                }
                success$1.elem = false;
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$handleCreateAclsResult$2(IntRef aclsFailedToCreateCount$1, ExcessiveLoggingHandler excessiveLoggingHandler$1) {
        return new StringBuilder(103).append("Failed to clear the link id in ").append(aclsFailedToCreateCount$1.elem).append(" ACLs. Did not log the errors for ").append(excessiveLoggingHandler$1.ignoredWarnLogCount()).append(" of them to prevent excessive logging.").toString();
    }

    private ClusterLinkClearLinkReference$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

