/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import kafka.server.link.AuthenticationErrorUnavailableLinkReason$;
import kafka.server.link.BootstrapTcpConnectionFailedUnavailableLinkReason$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason$;
import kafka.server.link.TimeoutUnavailableLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnknownUnavailableLinkReason$;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClusterLinkConnectionChecker$
implements Logging {
    public static ClusterLinkConnectionChecker$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkConnectionChecker$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Option<ClusterLinkConnectionCheckerResult> checkAll(Admin admin, ClusterLinkConfig config) {
        DescribeClusterResult describeClusterResult = this.doBasicDescribeCluster(admin);
        return this.check(describeClusterResult, config);
    }

    public Option<ClusterLinkConnectionCheckerResult> check(DescribeClusterResult describeClusterResult, ClusterLinkConfig config) {
        try {
            describeClusterResult.clusterId().get();
            return Option$.MODULE$.empty();
        }
        catch (Throwable ex) {
            ApiException apiException = ClusterLinkUtils$.MODULE$.apiException(ex, "Basic describeCluster check failed");
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$check$1(ex, apiException)));
            }
            if (apiException instanceof AuthenticationException) {
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, AuthenticationErrorUnavailableLinkReason$.MODULE$));
            }
            if (apiException instanceof AuthorizationException) {
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, InvalidBootstrapInternalEndpointUnavailableLinkReason$.MODULE$));
            }
            UnavailableLinkReason reason = this.checkBasicNetworking(config);
            if (reason.equals(UnknownUnavailableLinkReason$.MODULE$) && apiException instanceof TimeoutException) {
                return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, TimeoutUnavailableLinkReason$.MODULE$));
            }
            return Option$.MODULE$.apply((Object)new ClusterLinkConnectionCheckerResult(ex, reason));
        }
    }

    public DescribeClusterResult doBasicDescribeCluster(Admin admin) {
        return admin.describeCluster(new DescribeClusterOptions());
    }

    /*
     * WARNING - void declaration
     */
    private UnavailableLinkReason checkBasicNetworking(ClusterLinkConfig config) {
        void var4_4;
        void var3_3;
        Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> tuple2 = this.checkAddresses(config);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option dnsErr = (Option)tuple2._1();
        List validatedAddresses = (List)tuple2._2();
        void dnsErr2 = var3_3;
        void validatedAddresses2 = var4_4;
        return (UnavailableLinkReason)dnsErr2.getOrElse(() -> ClusterLinkConnectionChecker$.$anonfun$checkBasicNetworking$1((List)validatedAddresses2));
    }

    public Option<UnavailableLinkReason> checkTcpConnection(List<InetSocketAddress> validatedAddresses) {
        try {
            this.tryTcpConnectionToBootstrapServers(validatedAddresses);
            return None$.MODULE$;
        }
        catch (ConnectException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$1(ex)));
            }
            return Option$.MODULE$.apply((Object)BootstrapTcpConnectionFailedUnavailableLinkReason$.MODULE$);
        }
        catch (SocketTimeoutException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$2(ex)));
            }
            return Option$.MODULE$.apply((Object)BootstrapTcpConnectionFailedUnavailableLinkReason$.MODULE$);
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkTcpConnection$3(ex)));
            }
            return Option$.MODULE$.apply((Object)UnknownUnavailableLinkReason$.MODULE$);
        }
    }

    public Tuple2<Option<UnavailableLinkReason>, List<InetSocketAddress>> checkAddresses(ClusterLinkConfig config) {
        List list;
        List bootstrapServers = config.getList("bootstrap.servers");
        String dnsLookupConfig = config.getString("client.dns.lookup");
        ClientDnsLookup dnsLookup = dnsLookupConfig == null ? ClientDnsLookup.USE_ALL_DNS_IPS : ClientDnsLookup.forConfig((String)dnsLookupConfig);
        ArrayList invalidAddresses = new ArrayList();
        try {
            list = ClientUtils.parseAndValidateAddresses((List)bootstrapServers, (ClientDnsLookup)dnsLookup);
        }
        catch (ConfigException ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$1(ex)));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)UnresolvableBootstrapUnavailableLinkReason$.MODULE$), null);
        }
        catch (Throwable ex) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$2(ex)));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)UnknownUnavailableLinkReason$.MODULE$), null);
        }
        List validatedAddresses = list;
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(validatedAddresses).asScala()).foreach((Function1 & Serializable & scala.Serializable)inetSocketAddress -> {
            if (ClusterLinkUtils$.MODULE$.isInternalNetworkOrPort((InetSocketAddress)inetSocketAddress)) {
                return BoxesRunTime.boxToBoolean((boolean)invalidAddresses.add(inetSocketAddress));
            }
            return BoxedUnit.UNIT;
        });
        if (!invalidAddresses.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkConnectionChecker$.$anonfun$checkAddresses$4(invalidAddresses)));
            }
            return new Tuple2((Object)Option$.MODULE$.apply((Object)InvalidBootstrapInternalEndpointUnavailableLinkReason$.MODULE$), null);
        }
        return new Tuple2((Object)None$.MODULE$, (Object)validatedAddresses);
    }

    private void tryTcpConnectionToBootstrapServers(List<InetSocketAddress> validatedAddresses) {
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(validatedAddresses).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            ClusterLinkConnectionChecker$.$anonfun$tryTcpConnectionToBootstrapServers$2(endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public int tcpConnectionTimeoutsMs() {
        return 5000;
    }

    public static final /* synthetic */ String $anonfun$check$1(Throwable ex$1, ApiException apiException$1) {
        return new StringBuilder(67).append("Failed to contact remote cluster with exception ").append(ex$1).append(" and api exception ").append((Object)apiException$1).toString();
    }

    public static final /* synthetic */ UnavailableLinkReason $anonfun$checkBasicNetworking$1(List validatedAddresses$1) {
        return (UnavailableLinkReason)MODULE$.checkTcpConnection(validatedAddresses$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> UnknownUnavailableLinkReason$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$1(ConnectException ex$2) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$2).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$2(SocketTimeoutException ex$3) {
        return new StringBuilder(30).append("Failed to connect to endpoint ").append(ex$3).toString();
    }

    public static final /* synthetic */ String $anonfun$checkTcpConnection$3(Throwable ex$4) {
        return new StringBuilder(53).append("Failed to connect to endpoint with unknown exception ").append(ex$4).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$1(ConfigException ex$5) {
        return new StringBuilder(23).append("Failed to validate DNS ").append((Object)ex$5).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$2(Throwable ex$6) {
        return new StringBuilder(49).append("Failed to validate DNS with an unknown exception ").append(ex$6).toString();
    }

    public static final /* synthetic */ String $anonfun$checkAddresses$4(ArrayList invalidAddresses$1) {
        return new StringBuilder(95).append("Invalid bootstrap addresses or ports that cannot be used for cluster links on Confluent Cloud: ").append(invalidAddresses$1).toString();
    }

    public static final /* synthetic */ void $anonfun$tryTcpConnectionToBootstrapServers$2(InetSocketAddress endpoint) {
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(endpoint, MODULE$.tcpConnectionTimeoutsMs());
        }
    }

    private ClusterLinkConnectionChecker$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

