/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFailed;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkStopMirrorTopic;
import kafka.server.link.ClusterLinkStopMirrorTopic$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LocalClusterLinkAdminClient;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MirrorTopicDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u000b\u0017\u0001uA\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d)\u0005A1A\u0005\n\u0019CaA\u0013\u0001!\u0002\u00139\u0005bB&\u0001\u0005\u0004%I\u0001\u0014\u0005\u00073\u0002\u0001\u000b\u0011B'\t\u000fi\u0003!\u0019!C\u00057\"1q\f\u0001Q\u0001\nqCQ\u0001\u0019\u0001\u0005B\u0005DQ!\u001c\u0001\u0005B9Dq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA*\u0001\u0011%\u0011Q\f\u0005\b\u0003C\u0002A\u0011BA2\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\u0012ad\u00117vgR,'\u000fT5oW\u000e{wN\u001d3j]\u0006$xN\u001d'jgR,g.\u001a:\u000b\u0005]A\u0012\u0001\u00027j].T!!\u0007\u000e\u0002\rM,'O^3s\u0015\u0005Y\u0012!B6bM.\f7\u0001A\n\u0005\u0001y1c\u0006\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005!A.\u00198h\u0015\u0005\u0019\u0013\u0001\u00026bm\u0006L!!\n\u0011\u0003\r=\u0013'.Z2u!\t93F\u0004\u0002)S5\ta#\u0003\u0002+-\u0005\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0013\taSFA\fMS:\\7i\\8sI&t\u0017\r^8s\u0019&\u001cH/\u001a8fe*\u0011!F\u0006\t\u0003_Ij\u0011\u0001\r\u0006\u0003ci\tQ!\u001e;jYNL!a\r\u0019\u0003\u000f1{wmZ5oO\u0006YA.\u001b8l\u001b\u0006t\u0017mZ3s+\u00051\u0004C\u0001\u00158\u0013\tAdC\u0001\nDYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\u0018\u0001\u00047j].l\u0015M\\1hKJ\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0003q\u0002\"\u0001K\u001f\n\u0005y2\"AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Q\u0019!i\u0011#\u0011\u0005!\u0002\u0001\"\u0002\u001b\u0006\u0001\u00041\u0004\"\u0002\u001e\u0006\u0001\u0004a\u0014!C:dQ\u0016$W\u000f\\3s+\u00059\u0005C\u0001\u0015I\u0013\tIeC\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013AE6sC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012!\u0014\t\u0004\u001dF\u001bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r=\u0003H/[8o!\t!v+D\u0001V\u0015\t1\u0006$\u0001\u0005nKR\fG-\u0019;b\u0013\tAVK\u0001\nL%\u00064G/T3uC\u0012\fG/Y\"bG\",\u0017aE6sC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013a\u00045bg.\u0013\u0016M\u001a;TkB\u0004xN\u001d;\u0016\u0003q\u0003\"AT/\n\u0005y{%a\u0002\"p_2,\u0017M\\\u0001\u0011Q\u0006\u001c8JU1giN+\b\u000f]8si\u0002\nAA\\1nKR\t!\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003K>k\u0011A\u001a\u0006\u0003Or\ta\u0001\u0010:p_Rt\u0014BA5P\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%|\u0015\u0001E8o\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f)\u0015y'o`A\u0005!\tq\u0005/\u0003\u0002r\u001f\n!QK\\5u\u0011\u0015\u0019X\u00021\u0001u\u00035iW\r^1eCR\fG)\u001a7uCB\u0011Q/`\u0007\u0002m*\u0011q\u000f_\u0001\u0006S6\fw-\u001a\u0006\u00037eT!A_>\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0018aA8sO&\u0011aP\u001e\u0002\u000e\u001b\u0016$\u0018\rZ1uC\u0012+G\u000e^1\t\u000f\u0005\u0005Q\u00021\u0001\u0002\u0004\u0005\u0001b.Z<NKR\fG-\u0019;b\u00136\fw-\u001a\t\u0004k\u0006\u0015\u0011bAA\u0004m\niQ*\u001a;bI\u0006$\u0018-S7bO\u0016Dq!a\u0003\u000e\u0001\u0004\ti!\u0001\u0005nC:Lg-Z:u!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nm\u00061An\\1eKJLA!a\u0006\u0002\u0012\tqAj\\1eKJl\u0015M\\5gKN$\u0018\u0001E8o+B$\u0017\r^3NKR\fG-\u0019;b)\ry\u0017Q\u0004\u0005\b\u0003?q\u0001\u0019AA\u0011\u0003i\u0001XM\u001c3j]\u001e\u001cFo\u001c9qK\u0012l\u0015N\u001d:peR{\u0007/[2t!\u0011\u0019\u00171\u00052\n\u0007\u0005\u0015BNA\u0002TKR\f\u0001e\u001c8DYV\u001cH/\u001a:MS:\\7i\\8sI&t\u0017\r^8s\u000b2,7\r^5p]R\u0019q.a\u000b\t\u000f\u00055r\u00021\u0001\u00020\u0005)A.\u001b8lgB)1-a\t\u00022A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028i\t!A_6\n\t\u0005m\u0012Q\u0007\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006\u0019sN\\\"mkN$XM\u001d'j].\u001cun\u001c:eS:\fGo\u001c:SKNLwM\\1uS>tGcA8\u0002B!9\u00111\t\tA\u0002\u0005\u0015\u0013!\u00037j].LEmU3u!\u0015\u0019\u00171EA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'q\u000611m\\7n_:LA!!\u0015\u0002L\t!Q+^5e\u0003}\u0019\u0007.Z2l\u001b&\u0014(o\u001c:Ti\u0006$X-\u00118e\u000bb,7-\u001e;f)\u0006\u001c8n\u001d\u000b\u0006_\u0006]\u0013\u0011\f\u0005\u0007/E\u0001\r!!\r\t\r\u0005m\u0013\u00031\u0001u\u0003\u0015!W\r\u001c;b)\ry\u0017q\f\u0005\u0007/I\u0001\r!!\r\u0002S\rDWmY6JM6K'O]8s'R\fG/Z\"iC:<W\r\u001a+p!\u0016tG-\u001b8h'R|\u0007\u000f]3e)\ra\u0016Q\r\u0005\b\u00037\u001a\u0002\u0019AA4!\r)\u0018\u0011N\u0005\u0004\u0003W2(A\u0003+pa&\u001cG)\u001a7uC\u0006\t\"/\u001e8Ti>\u0004X*\u001b:s_J$\u0016m]6\u0015\u000b=\f\t(!\u001e\t\u000f\u0005MD\u00031\u0001\u0002H\u00051A.\u001b8l\u0013\u0012Da!a\u001e\u0015\u0001\u0004\u0011\u0017!\u0003;pa&\u001cg*Y7f\u0001")
public class ClusterLinkCoordinatorListener
implements ClusterLinkFactory.LinkCoordinatorListener,
Logging {
    private final ClusterLinkManager linkManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkScheduler scheduler;
    private final Option<KRaftMetadataCache> kraftMetadataCache;
    private final boolean hasKRaftSupport;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private Option<KRaftMetadataCache> kraftMetadataCache() {
        return this.kraftMetadataCache;
    }

    private boolean hasKRaftSupport() {
        return this.hasKRaftSupport;
    }

    public String name() {
        return "ClusterLinkCoordinatorListener";
    }

    public void onMetadataUpdate(MetadataDelta metadataDelta, MetadataImage newMetadataImage, LoaderManifest manifest) {
        this.scheduler().scheduleOnce("scheduleChangesForDeltaByClusterLinkLeaders", () -> this.metadataManager().getClusterLinksWithOwnedLinkCoordinator().foreach((Function1 & Serializable & scala.Serializable)cld -> {
            this.checkMirrorStateAndExecuteTasks(cld, metadataDelta);
            return BoxedUnit.UNIT;
        }));
    }

    @Override
    public void onUpdateMetadata(Set<String> pendingStoppedMirrorTopics) {
        if (!this.metadataManager().isLinkCoordinatorEnabled()) {
            return;
        }
        this.metadataManager().mirrorTopicStatesFromMetadataCache(pendingStoppedMirrorTopics).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkCoordinatorListener.$anonfun$onUpdateMetadata$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)this.linkManager().listClusterLinks().flatMap((Function1 & Serializable & scala.Serializable)link -> Option$.MODULE$.option2Iterable(this.linkManager().destClientManager(link.linkId())), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.processMirrorStateChanges();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onClusterLinkCoordinatorElection(Set<ClusterLinkData> links) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("link coordinator elected for links: ").append(links.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.linkName(), Set$.MODULE$.canBuildFrom())).toString());
        links.foreach((Function1 & Serializable & scala.Serializable)cld -> {
            ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorElection$3(this, cld);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onClusterLinkCoordinatorResignation(Set<Uuid> linkIdSet) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("link coordinator resigned for links: ").append(linkIdSet).toString());
        linkIdSet.foreach((Function1 & Serializable & scala.Serializable)linkId -> {
            ClusterLinkCoordinatorListener.$anonfun$onClusterLinkCoordinatorResignation$2(this, linkId);
            return BoxedUnit.UNIT;
        });
    }

    private void checkMirrorStateAndExecuteTasks(ClusterLinkData link, MetadataDelta delta) {
        if (delta.topicsDelta() != null && !delta.topicsDelta().changedTopics().isEmpty()) {
            delta.topicsDelta().changedTopics().values().stream().filter(topicDelta -> topicDelta.mirrorTopicDelta().changed() && OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((MirrorTopicDelta.Changed)topicDelta.mirrorTopicDelta()).newValue())).exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkMirrorStateAndExecuteTasks$2(link, x$5))) && this.checkIfMirrorStateChangedToPendingStopped((TopicDelta)topicDelta)).forEach(topicDelta -> this.runStopMirrorTask(link.linkId(), topicDelta.name()));
            this.linkManager().destClientManager(link.linkId()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.processMirrorStateChanges();
                return BoxedUnit.UNIT;
            });
        }
    }

    private void checkMirrorStateAndExecuteTasks(ClusterLinkData link) {
        if (this.metadataManager().isLinkCoordinatorEnabled()) {
            ((MapLike)this.metadataManager().mirrorTopicStatesFromMetadataCache(link.linkId()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkMirrorStateAndExecuteTasks$5(x0$1)))).keys().foreach((Function1 & Serializable & scala.Serializable)topic -> {
                this.runStopMirrorTask(link.linkId(), topic);
                return BoxedUnit.UNIT;
            });
            this.linkManager().destClientManager(link.linkId()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.processMirrorStateChanges();
                return BoxedUnit.UNIT;
            });
        }
    }

    private boolean checkIfMirrorStateChangedToPendingStopped(TopicDelta delta) {
        Option newMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.latestMirrorTopicState()));
        Option prevMirrorState = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(delta.image().mirrorTopic()));
        return newMirrorState.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)(bl = x$8 instanceof MirrorTopic.PendingStoppedMirrorTopic ? prevMirrorState.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkCoordinatorListener.$anonfun$checkIfMirrorStateChangedToPendingStopped$2(x$9))) : false)));
    }

    private void runStopMirrorTask(Uuid linkId, String topicName) {
        Option<ClusterLinkFactory.ClientManager> option = this.linkManager().clientManager(linkId);
        if (option instanceof Some) {
            ClusterLinkFactory.ClientManager clientManager = (ClusterLinkFactory.ClientManager)((Some)option).value();
            if (clientManager instanceof ClusterLinkDestClientManager) {
                ClusterLinkDestClientManager clusterLinkDestClientManager = (ClusterLinkDestClientManager)clientManager;
                ConfluentAdmin destAdmin = (ConfluentAdmin)clusterLinkDestClientManager.destAdminFactory().apply();
                new ClusterLinkStopMirrorTopic(topicName, clusterLinkDestClientManager, (Function0<ConfluentAdmin>)(Function0 & Serializable & scala.Serializable)() -> destAdmin, new LocalClusterLinkAdminClient(destAdmin), ClusterLinkStopMirrorTopic$.MODULE$.$lessinit$greater$default$5()).startup();
                return;
            }
            if (clientManager instanceof ClusterLinkFailed.ClientManager) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Cannot start 'stop topic mirror' task, cluster link '").append(linkId).append("' is in a failed state").toString());
                return;
            }
            throw new IllegalStateException(new StringBuilder(28).append("Unhandled link manager type ").append(clientManager).toString());
        }
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Unable to resolve client manager for link ID '").append(linkId).append("'. Cluster link may have ").append("been deleted or the managers are not initialized.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$onUpdateMetadata$1(ClusterLinkCoordinatorListener $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            if ($this.metadataManager().isLinkCoordinator(state.linkName())) {
                $this.runStopMirrorTask(state.linkId(), topic);
                return;
            }
        } else {
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorElection$3(ClusterLinkCoordinatorListener $this, ClusterLinkData cld) {
        try {
            if (cld.isDeleted()) {
                if ($this.hasKRaftSupport()) {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Found link ").append(cld.linkName()).append(" marked for deletion in KRaft mode").toString());
                    throw new IllegalStateException(new StringBuilder(45).append("Found link ").append(cld.linkName()).append(" marked for deletion in KRaft mode").toString());
                }
            } else {
                $this.checkMirrorStateAndExecuteTasks(cld);
                $this.linkManager().connectionManager(cld.linkId()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.onLinkMetadataPartitionLeaderChange();
                    return BoxedUnit.UNIT;
                });
                return;
            }
            $this.linkManager().processClusterLinkChanges(cld.linkId(), new Properties(), $this.linkManager().processClusterLinkChanges$default$3());
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Unable to process link coordinator change for link ").append(cld.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
        }
    }

    public static final /* synthetic */ void $anonfun$onClusterLinkCoordinatorResignation$2(ClusterLinkCoordinatorListener $this, Uuid linkId) {
        try {
            $this.linkManager().connectionManager(linkId).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.onLinkMetadataPartitionLeaderChange();
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable ex) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Unable to process link coordinator change for link ").append(linkId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkMirrorStateAndExecuteTasks$2(ClusterLinkData link$1, MirrorTopic x$5) {
        Uuid uuid = x$5.linkId();
        Uuid uuid2 = link$1.linkId();
        return !(uuid != null ? !uuid.equals(uuid2) : uuid2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkMirrorStateAndExecuteTasks$5(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicLinkState topicLinkState = ((ClusterLinkTopicState)x0$1._2()).state();
        TopicLinkPendingStoppedMirror$ topicLinkPendingStoppedMirror$ = TopicLinkPendingStoppedMirror$.MODULE$;
        boolean bl = !(topicLinkState != null ? !topicLinkState.equals(topicLinkPendingStoppedMirror$) : topicLinkPendingStoppedMirror$ != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$checkIfMirrorStateChangedToPendingStopped$2(MirrorTopic x$9) {
        MirrorTopic.State state = x$9.mirrorState();
        MirrorTopic.State state2 = MirrorTopic.State.PENDING_STOPPED;
        return state == null ? state2 != null : !state.equals(state2);
    }

    public ClusterLinkCoordinatorListener(ClusterLinkManager linkManager, ClusterLinkMetadataManager metadataManager) {
        None$ none$;
        this.linkManager = linkManager;
        this.metadataManager = metadataManager;
        Logging.$init$(this);
        this.scheduler = linkManager.scheduler();
        MetadataCache metadataCache = metadataManager.metadataCache();
        if (metadataCache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)metadataCache;
            none$ = new Some((Object)kRaftMetadataCache);
        } else {
            none$ = None$.MODULE$;
        }
        this.kraftMetadataCache = none$;
        this.hasKRaftSupport = this.kraftMetadataCache().nonEmpty();
    }
}

