/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStatus;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetrics$;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ClusterLinkSensorFactory;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.FetcherRemoveReason;
import kafka.server.link.UnavailableLinkReason;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r]s!\u0002!B\u0011\u0003Ae!\u0002&B\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019f\u0001\u0002+\u0002\u0001UCQAU\u0002\u0005\u0002\tDQ!Z\u0002\u0005\u0002\u0019DQA[\u0002\u0005\u0002\u0019Daa[\u0002\u0005\u0002\u0005c\u0007\u0002CA\u0006\u0007\u0011\u0005\u0011)!\u0004\t\u0011\u0005E2\u0001\"\u0001B\u0003gAq!!\u0017\u0004\t\u0003\te\rC\u0004\u0002\\\r!\t!!\u0018\t\u000f\u0005}3\u0001\"\u0001\u0002b\u00191\u0011qT\u0001\u0001\u0003CCaAU\u0007\u0005\u0002\u0005\u001d\u0006bBAV\u001b\u0011%\u0011Q\u0016\u0005\u0006K6!\tA\u001a\u0005\u0006U6!\tA\u001a\u0005\bW6!\t!QA`\u0011!\t)-\u0004C\u0001\u0003\u0006\u001d\u0007\u0002CAf\u001b\u0011\u0005\u0011)!4\t\u000f\u0005mS\u0002\"\u0001\u0002^!9\u0011\u0011[\u0007\u0005\u0002\u0005M\u0007bBAz\u001b\u0011\u0005\u0011Q\u001f\u0005\b\u0005\u001biA\u0011\u0001B\b\r\u0019\u0011\t#\u0001\u0001\u0003$!Q!\u0011G\r\u0003\u0006\u0004%\tAa\r\t\u0015\t\u0005\u0013D!A!\u0002\u0013\u0011)\u0004\u0003\u0006\u0003De\u0011)\u0019!C\u0001\u0005\u000bB\u0011Ba\u0012\u001a\u0005\u0003\u0005\u000b\u0011\u0002>\t\rIKB\u0011\u0001B%\u0011\u001d\tY+\u0007C\u0005\u0003[CQ!Z\r\u0005B\u0019Dqa[\r\u0005B\u0005\u0013\t\u0006C\u0003k3\u0011\u0005c\rC\u0004\u0002\\e!\t%!\u0018\t\u000f\t]\u0013\u0004\"\u0011\u0003Z!9!\u0011M\r\u0005B\t\r\u0004b\u0002BE3\u0011\u0005#1\u0012\u0005\b\u0005OKB\u0011\tBU\u0011\u001d\u0011y-\u0007C!\u0005#4aAa6\u0002\u0001\te\u0007B\u0003BqS\t\u0015\r\u0011\"\u0001\u0003F!I!1]\u0015\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0005KL#Q1A\u0005\u0002\t\u001d\bB\u0003BzS\t\u0005\t\u0015!\u0003\u0003j\"Q!Q_\u0015\u0003\u0002\u0003\u0006IAa>\t\u0015\u0005E\u0013F!A!\u0002\u0013\u0011I\u0010\u0003\u0004SS\u0011\u0005!q \u0005\n\u0007\u0017I#\u0019!C\u0001\u0007\u001bA\u0001ba\u0004*A\u0003%!q\u001f\u0005\n\u0007#I#\u0019!C\u0005\u0007'A\u0001b!\u0007*A\u0003%1Q\u0003\u0005\n\u00077I#\u0019!C\u0005\u0007;A\u0001b!\u000b*A\u0003%1q\u0004\u0005\n\u0007WI#\u0019!C\u0001\u0007[A\u0001b!\u000e*A\u0003%1q\u0006\u0005\n\u0007oI#\u0019!C\u0001\u0007sA\u0001b!\u0011*A\u0003%11\b\u0005\f\u0007\u0007J\u0003\u0019!a\u0001\n\u0003\u0019)\u0005C\u0006\u0004N%\u0002\r\u00111A\u0005\u0002\r=\u0003bCB+S\u0001\u0007\t\u0011)Q\u0005\u0007\u000fBQ!Z\u0015\u0005B\u0019DQA[\u0015\u0005B\u0019\f\u0011c\u00117vgR,'\u000fT5oW\u001a\u000b\u0017\u000e\\3e\u0015\t\u00115)\u0001\u0003mS:\\'B\u0001#F\u0003\u0019\u0019XM\u001d<fe*\ta)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005%\u000bQ\"A!\u0003#\rcWo\u001d;fe2Kgn\u001b$bS2,Gm\u0005\u0002\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001%\u0003\u001d\u0019+Go\u00195fe6\u000bg.Y4feN!1\u0001\u0014,]!\t9&L\u0004\u0002J1&\u0011\u0011,Q\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002U7*\u0011\u0011,\u0011\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?\u0016\u000bQ!\u001e;jYNL!!\u00190\u0003\u000f1{wmZ5oOR\t1\r\u0005\u0002e\u00075\t\u0011!A\u0004ti\u0006\u0014H/\u001e9\u0015\u0003\u001d\u0004\"!\u00145\n\u0005%t%\u0001B+oSR\f\u0001b\u001d5vi\u0012|wO\\\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\rF\u0002h[JDQA\\\u0004A\u0002=\f\u0011B\\3x\u0007>tg-[4\u0011\u0005%\u0003\u0018BA9B\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0005\u0006g\u001e\u0001\r\u0001^\u0001\fkB$\u0017\r^3e\u0017\u0016L8\u000fE\u0002vqjl\u0011A\u001e\u0006\u0003o:\u000b!bY8mY\u0016\u001cG/[8o\u0013\tIhOA\u0002TKR\u00042a_A\u0003\u001d\ra\u0018\u0011\u0001\t\u0003{:k\u0011A \u0006\u0003\u007f\u001e\u000ba\u0001\u0010:p_Rt\u0014bAA\u0002\u001d\u00061\u0001K]3eK\u001aLA!a\u0002\u0002\n\t11\u000b\u001e:j]\u001eT1!a\u0001O\u0003u\tG\r\u001a'j].,GMR3uG\",'OR8s!\u0006\u0014H/\u001b;j_:\u001cHcA4\u0002\u0010!9\u0011\u0011\u0003\u0005A\u0002\u0005M\u0011A\u00039beRLG/[8ogB1\u0011QCA\u0010\u0003KqA!a\u0006\u0002\u001c9\u0019Q0!\u0007\n\u0003=K1!!\bO\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\t\u0002$\tA\u0011\n^3sC\ndWMC\u0002\u0002\u001e9\u0003B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W)\u0015aB2mkN$XM]\u0005\u0005\u0003_\tICA\u0005QCJ$\u0018\u000e^5p]\u0006\u0001#/Z7pm\u0016d\u0015N\\6fI\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)\u00159\u0017QGA(\u0011\u001d\t\t\"\u0003a\u0001\u0003o\u0001B!\u001e=\u0002:A!\u00111HA&\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AB2p[6|gNC\u0002G\u0003\u0007RA!!\u0012\u0002H\u00051\u0011\r]1dQ\u0016T!!!\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002N\u0005u\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003#J\u0001\u0019AA*\u0003\u0019\u0011X-Y:p]B\u0019\u0011*!\u0016\n\u0007\u0005]\u0013IA\nGKR\u001c\u0007.\u001a:SK6|g/\u001a*fCN|g.\u0001\u000etQV$Hm\\<o\u0013\u0012dWMR3uG\",'\u000f\u00165sK\u0006$7/A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u000b\u0002_\u0006!\u0002/\u0019:uSRLwN\\'jeJ|'o\u0015;bi\u0016$\u0002\"a\u0019\u0002~\u0005\u0005\u00151\u0013\t\u0006\u001b\u0006\u0015\u0014\u0011N\u0005\u0004\u0003Or%AB(qi&|g\u000e\u0005\u0003\u0002l\u0005]d\u0002BA7\u0003gj!!a\u001c\u000b\t\u0005E\u0014QH\u0001\be\u0016\u0004H.[2b\u0013\u0011\t)(a\u001c\u0002\u001bI+\u0007\u000f\\5dCN#\u0018\r^;t\u0013\u0011\tI(a\u001f\u0003\u00155K'O]8s\u0013:4wN\u0003\u0003\u0002v\u0005=\u0004bBA@\u0019\u0001\u0007\u0011\u0011H\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\u0019\t\u0004a\u0001\u0003\u000b\u000bQ\u0003]3sg&\u001cH/\u001a8u\u001b&\u0014(o\u001c:Ti\u0006$X\r\u0005\u0003\u0002\b\u00065e\u0002BA6\u0003\u0013KA!a#\u0002|\u0005QQ*\u001b:s_JLeNZ8\n\t\u0005=\u0015\u0011\u0013\u0002\u0006'R\fG/\u001a\u0006\u0005\u0003\u0017\u000bY\bC\u0004\u0002\u00162\u0001\r!a&\u0002+Ut\u0017M^1jY\u0006\u0014G.\u001a'j].\u0014V-Y:p]B)Q*!\u001a\u0002\u001aB\u0019\u0011*a'\n\u0007\u0005u\u0015IA\u000bV]\u00064\u0018-\u001b7bE2,G*\u001b8l%\u0016\f7o\u001c8\u0003\u001b\rc\u0017.\u001a8u\u001b\u0006t\u0017mZ3s'\u0015iA*a)]!\r9\u0016QU\u0005\u0004\u0003?[FCAAU!\t!W\"A\u0005fq\u000e,\u0007\u000f^5p]R\u0011\u0011q\u0016\t\u0005\u0003c\u000bY,\u0004\u0002\u00024*!\u0011QWA\\\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0016\u0001\u00026bm\u0006LA!!0\u00024\n)\u0012\n\u001c7fO\u0006d7\u000b^1uK\u0016C8-\u001a9uS>tG#B4\u0002B\u0006\r\u0007\"\u00028\u0013\u0001\u0004y\u0007\"B:\u0013\u0001\u0004!\u0018!C1eIR{\u0007/[2t)\r9\u0017\u0011\u001a\u0005\u0007\u0003\u000b\u001c\u0002\u0019\u0001;\u0002\u0019I,Wn\u001c<f)>\u0004\u0018nY:\u0015\u0007\u001d\fy\r\u0003\u0004\u0002LR\u0001\r\u0001^\u0001\u0015M\u0016$8\r\u001b+pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\r\u0005U\u00171^Ax!\u0019\t9.!9\u0002f6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.\u0001\u0006d_:\u001cWO\u001d:f]RTA!a8\u00028\u0006!Q\u000f^5m\u0013\u0011\t\u0019/!7\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002N\u0003OL1!!;O\u0005\rIe\u000e\u001e\u0005\u0007\u0003[4\u0002\u0019\u0001>\u0002\u000bQ|\u0007/[2\t\u000f\u0005Eh\u00031\u0001\u0002f\u0006IA/[7f_V$Xj]\u0001\u000fM\u0016$8\r\u001b+pa&\u001c\u0017J\u001c4p)!\t90a@\u0003\u0002\t\r\u0001CBAl\u0003C\fI\u0010E\u0002J\u0003wL1!!@B\u0005Q\u0019E.^:uKJd\u0015N\\6U_BL7-\u00138g_\"1\u0011Q^\fA\u0002iDq!!=\u0018\u0001\u0004\t)\u000fC\u0004\u0003\u0006]\u0001\rAa\u0002\u0002\u001fM$\u0018M\u001d;PM\u001a\u001cX\r^*qK\u000e\u00042!\u0014B\u0005\u0013\r\u0011YA\u0014\u0002\u0005\u0019>tw-A\u0007sKBd\u0017nY1Ti\u0006$Xo\u001d\u000b\u0005\u0005#\u0011y\u0002E\u0004v\u0005'\tIDa\u0006\n\u0007\tUaOA\u0002NCB\u0004b!a6\u0002b\ne\u0001\u0003BA\u0014\u00057IAA!\b\u0002*\ty\u0001+\u0019:uSRLwN\\*uCR,8\u000fC\u0004\u0002\u0012a\u0001\r!a\u000e\u0003#\r{gN\\3di&|g.T1oC\u001e,'o\u0005\u0004\u001a\u0019\n\u0015\"1\u0006\t\u0004/\n\u001d\u0012b\u0001B\u00157\nA\u0012J\u001c2pk:$7i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007]\u0013i#C\u0002\u00030m\u0013\u0011dT;uE>,h\u000eZ\"p]:,7\r^5p]6\u000bg.Y4fe\u0006AA.\u001b8l\t\u0006$\u0018-\u0006\u0002\u00036A!!q\u0007B\u001f\u001b\t\u0011IDC\u0002\u0003<\u0015\u000b!A_6\n\t\t}\"\u0011\b\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\u0014Y>\u001c\u0017\r\u001c'pO&\u001c\u0017\r\\\"mkN$XM]\u000b\u0002u\u0006!Bn\\2bY2{w-[2bY\u000ecWo\u001d;fe\u0002\"bAa\u0013\u0003N\t=\u0003C\u00013\u001a\u0011\u001d\u0011\tD\ba\u0001\u0005kAaAa\u0011\u001f\u0001\u0004QH#B4\u0003T\tU\u0003\"\u00028\"\u0001\u0004y\u0007\"B:\"\u0001\u0004!\u0018\u0001\u00047j].\u001cE.^:uKJ\u001cXC\u0001B.!\u0011)(Q\f>\n\u0007\t}cOA\u0002TKF\f\u0011#\u001a8bE2,7\t\\;ti\u0016\u0014H*\u001b8l)\u00159'Q\rB8\u0011\u001d\u00119'\na\u0001\u0005S\nQB\\3uo>\u00148n\u00117jK:$\bcA%\u0003l%\u0019!QN!\u00031\rcWo\u001d;fe2Kgn\u001b(fi^|'o[\"mS\u0016tG\u000fC\u0004\u0003r\u0015\u0002\rAa\u001d\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004R!TA3\u0005k\u0002BAa\u001e\u0003\u00066\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(A\u0005j]R,'O\\1mg*!!q\u0010BA\u0003\u0015\tG-\\5o\u0015\u0011\u0011\u0019)!\u0011\u0002\u000f\rd\u0017.\u001a8ug&!!q\u0011B=\u0005Q\tE-\\5o\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006A\u0002O]8dKN\u001c(+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\u000b\u001d\u0014iI!(\t\u000f\t=e\u00051\u0001\u0003\u0012\u000691\r[1o]\u0016d\u0007\u0003\u0002BJ\u00053k!A!&\u000b\t\t]\u0015QH\u0001\b]\u0016$xo\u001c:l\u0013\u0011\u0011YJ!&\u0003\u0019-\u000bgm[1DQ\u0006tg.\u001a7\t\u000f\t}e\u00051\u0001\u0003\"\u0006Y!/\u001a<feN,gj\u001c3f!\u0011\u0011\u0019Ja)\n\t\t\u0015&Q\u0013\u0002\f%\u00164XM]:f\u001d>$W-\u0001\u000ej]&$\u0018.\u0019;f%\u00164XM]:f\u0007>tg.Z2uS>t7\u000f\u0006\u0004\u0003,\nU&Q\u0019\t\u0006k\nu#Q\u0016\t\u0007\u0003/\f\tOa,\u0011\t\u0005E&\u0011W\u0005\u0005\u0005g\u000b\u0019L\u0001\u0003W_&$\u0007b\u0002B\\O\u0001\u0007!\u0011X\u0001\u001aS:LG/[1uK\u000e{gN\\3di&|gNU3rk\u0016\u001cH\u000f\u0005\u0003\u0003<\n\u0005WB\u0001B_\u0015\u0011\u0011y,!\u0010\u0002\u0011I,\u0017/^3tiNLAAa1\u0003>\n\t\u0013J\\5uS\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogJ+\u0017/^3ti\"9!qY\u0014A\u0002\t%\u0017A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0005w\u0013Y-\u0003\u0003\u0003N\nu&A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010^\u0001\u0014_:\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0006O\nM'Q\u001b\u0005\b\u0005\u001fC\u0003\u0019\u0001BI\u0011\u001d\u0011y\n\u000ba\u0001\u0005C\u0013\u0001DR1jY\u0016$7\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t'\u0011ICJa7\u0011\u0007]\u0013i.C\u0002\u0003`n\u00131\u0002T5oW6+GO]5dg\u0006AA.\u001b8l\u001d\u0006lW-A\u0005mS:\\g*Y7fA\u00059Q.\u001a;sS\u000e\u001cXC\u0001Bu!\u0011\u0011YOa<\u000e\u0005\t5(\u0002\u0002Bs\u0003{IAA!=\u0003n\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0019Q,g.\u00198u!J,g-\u001b=\u0011\t5\u000b)G\u001f\t\u0004\u0013\nm\u0018b\u0001B\u007f\u0003\n\u0001b)Y5mK\u0012d\u0015N\\6SK\u0006\u001cxN\u001c\u000b\u000b\u0007\u0003\u0019\u0019a!\u0002\u0004\b\r%\u0001C\u00013*\u0011\u0019\u0011\t\u000f\ra\u0001u\"9!Q\u001d\u0019A\u0002\t%\bb\u0002B{a\u0001\u0007!q\u001f\u0005\b\u0003#\u0002\u0004\u0019\u0001B}\u0003\u0019!XM\\1oiV\u0011!q_\u0001\bi\u0016t\u0017M\u001c;!\u0003I)h\u000e\u001d:fM&DX\r\u001a'j].t\u0015-\\3\u0016\u0005\rU\u0001\u0003BAY\u0007/IA!a\u0002\u00024\u0006\u0019RO\u001c9sK\u001aL\u00070\u001a3MS:\\g*Y7fA\u0005!A/Y4t+\t\u0019y\u0002E\u0004\u0004\"\r\u001d2Q\u0003>\u000e\u0005\r\r\"bAB\u0013m\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005+\u0019\u0019#A\u0003uC\u001e\u001c\b%A\rgC&dW\r\u001a'j].\u001cu.\u001e8u\u001b\u0016$(/[2OC6,WCAB\u0018!\u0011\tYd!\r\n\t\rM\u0012Q\b\u0002\u000b\u001b\u0016$(/[2OC6,\u0017A\u00074bS2,G\rT5oW\u000e{WO\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013a\u00024bGR|'/_\u000b\u0003\u0007w\u00012!SB\u001f\u0013\r\u0019y$\u0011\u0002\u0019\u00072,8\u000f^3s\u0019&t7nU3og>\u0014h)Y2u_JL\u0018\u0001\u00034bGR|'/\u001f\u0011\u0002=1Lgn\u001b$bS2,(/\u001a*fiJL\u0018\t\u001e;f[B$8oU3og>\u0014XCAB$!\u0011\u0011Yo!\u0013\n\t\r-#Q\u001e\u0002\u0007'\u0016t7o\u001c:\u0002E1Lgn\u001b$bS2,(/\u001a*fiJL\u0018\t\u001e;f[B$8oU3og>\u0014x\fJ3r)\r97\u0011\u000b\u0005\n\u0007'b\u0014\u0011!a\u0001\u0007\u000f\n1\u0001\u001f\u00132\u0003}a\u0017N\\6GC&dWO]3SKR\u0014\u00180\u0011;uK6\u0004Ho]*f]N|'\u000f\t")
public final class ClusterLinkFailed {

    public static class ClientManager
    implements ClusterLinkFactory.ClientManager,
    Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ClientManager.onAvailabilityChange$(this, isAvailable);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up failed client manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down failed client manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        public void addTopics(Set<String> addTopics) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Adding topics ").append(addTopics).append(" for failed client manager").toString());
        }

        public void removeTopics(Set<String> removeTopics) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Removing topics ").append(removeTopics).append(" for failed client manager").toString());
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        public CompletableFuture<Object> fetchTopicPartitions(String topic, int timeoutMs) {
            throw this.exception();
        }

        public CompletableFuture<ClusterLinkTopicInfo> fetchTopicInfo(String topic, int timeoutMs, long startOffsetSpec) {
            throw new InvalidClusterLinkException("Cluster link is in failed state.");
        }

        public Map<TopicPartition, CompletableFuture<PartitionStatus>> replicaStatus(Set<TopicPartition> partitions) {
            throw this.exception();
        }

        public ClientManager() {
            ClusterLinkFactory.ClientManager.$init$(this);
            Logging.$init$(this);
        }
    }

    public static class ConnectionManager
    implements ClusterLinkFactory.InboundConnectionManager,
    ClusterLinkFactory.OutboundConnectionManager {
        private final ClusterLinkData linkData;
        private final String localLogicalCluster;

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.ConnectionManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public boolean active() {
            return ClusterLinkFactory.ConnectionManager.active$(this);
        }

        @Override
        public void onControllerChange(boolean isActive) {
            ClusterLinkFactory.ConnectionManager.onControllerChange$(this, isActive);
        }

        @Override
        public void onLinkMetadataPartitionLeaderChange() {
            ClusterLinkFactory.ConnectionManager.onLinkMetadataPartitionLeaderChange$(this);
        }

        @Override
        public int persistentConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.persistentConnectionCount$(this);
        }

        @Override
        public int reverseConnectionCount() {
            return ClusterLinkFactory.ConnectionManager.reverseConnectionCount$(this);
        }

        @Override
        public boolean isLinkCoordinator() {
            return ClusterLinkFactory.ConnectionManager.isLinkCoordinator$(this);
        }

        @Override
        public Option<Object> linkCoordinatorId() {
            return ClusterLinkFactory.ConnectionManager.linkCoordinatorId$(this);
        }

        @Override
        public ClusterLinkData linkData() {
            return this.linkData;
        }

        @Override
        public String localLogicalCluster() {
            return this.localLogicalCluster;
        }

        private IllegalStateException exception() {
            return new IllegalStateException("Cluster link managers failed to initialize, cannot proceed.");
        }

        @Override
        public void startup() {
            throw this.exception();
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void shutdown() {
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public Seq<String> linkClusters() {
            return (Seq)new .colon.colon((Object)this.localLogicalCluster(), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.linkData().clusterId()), Seq$.MODULE$.canBuildFrom());
        }

        @Override
        public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
            throw this.exception();
        }

        @Override
        public void processReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection is no longer required");
        }

        @Override
        public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
            throw new NetworkException("Cluster link has failed, connection cannot be created");
        }

        public void onReverseConnection(KafkaChannel channel, ReverseNode reverseNode) {
            throw new NetworkException("Cluster link has failed, connection not required any more");
        }

        public ConnectionManager(ClusterLinkData linkData, String localLogicalCluster) {
            this.linkData = linkData;
            this.localLogicalCluster = localLogicalCluster;
            ClusterLinkFactory.ConnectionManager.$init$(this);
        }
    }

    public static class FailedClusterLinkMetrics
    implements ClusterLinkFactory.LinkMetrics {
        private final String linkName;
        private final Metrics metrics;
        private final Option<String> tenant;
        private final String unprefixedLinkName;
        private final scala.collection.immutable.Map<String, String> tags;
        private final MetricName failedLinkCountMetricName;
        private final ClusterLinkSensorFactory factory;
        private Sensor linkFailureRetryAttemptsSensor;

        public String linkName() {
            return this.linkName;
        }

        public Metrics metrics() {
            return this.metrics;
        }

        public Option<String> tenant() {
            return this.tenant;
        }

        private String unprefixedLinkName() {
            return this.unprefixedLinkName;
        }

        private scala.collection.immutable.Map<String, String> tags() {
            return this.tags;
        }

        public MetricName failedLinkCountMetricName() {
            return this.failedLinkCountMetricName;
        }

        public ClusterLinkSensorFactory factory() {
            return this.factory;
        }

        public Sensor linkFailureRetryAttemptsSensor() {
            return this.linkFailureRetryAttemptsSensor;
        }

        public void linkFailureRetryAttemptsSensor_$eq(Sensor x$1) {
            this.linkFailureRetryAttemptsSensor = x$1;
        }

        @Override
        public void startup() {
            this.metrics().addMetric(this.failedLinkCountMetricName(), (x$1, x$2) -> 1.0);
            this.linkFailureRetryAttemptsSensor_$eq(this.factory().createSensorForTotalAndRateMetrics((Option<String>)new Some((Object)this.linkName()), (Option<Sensor>)None$.MODULE$, "link-failure-retry-attempts", "link failure retry attempts", this.factory().createSensorForTotalAndRateMetrics$default$5()));
        }

        @Override
        public void shutdown() {
            this.metrics().removeMetric(this.failedLinkCountMetricName());
        }

        public FailedClusterLinkMetrics(String linkName, Metrics metrics, Option<String> tenantPrefix2, FailedLinkReason reason) {
            this.linkName = linkName;
            this.metrics = metrics;
            this.tenant = tenantPrefix2.map((Function1 & Serializable & scala.Serializable)tenantPrefix -> ClusterLinkUtils$.MODULE$.logicalCluster((String)tenantPrefix));
            this.unprefixedLinkName = (String)this.tenant().map((Function1 & Serializable & scala.Serializable)t -> this.linkName().substring(t.length() + 1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.linkName());
            this.tags = ((TraversableOnce)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"link-name"), (Object)this.unprefixedLinkName())), (List)new .colon.colon((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason.name())), (List)new .colon.colon((Object)this.tenant().map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"tenant"), t)), (List)Nil$.MODULE$))).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).toMap(Predef$.MODULE$.$conforms());
            this.failedLinkCountMetricName = new MetricName("broker-failed-link-count", ClusterLinkMetrics$.MODULE$.metricsGroup(), "Number of failed cluster links at the broker.", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.tags()).asJava());
            this.factory = new ClusterLinkSensorFactory(metrics, this.tags());
        }
    }

    public static class FetcherManager
    implements ClusterLinkFactory.FetcherManager,
    Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        @Override
        public void onAvailabilityChange(boolean isAvailable) {
            ClusterLinkFactory.FetcherManager.onAvailabilityChange$(this, isAvailable);
        }

        @Override
        public void maybeNotifyReadyForFetch(Partition partition) {
            ClusterLinkFactory.FetcherManager.maybeNotifyReadyForFetch$(this, partition);
        }

        @Override
        public int fetcherThreadCount() {
            return ClusterLinkFactory.FetcherManager.fetcherThreadCount$(this);
        }

        @Override
        public int throttledPartitionCount() {
            return ClusterLinkFactory.FetcherManager.throttledPartitionCount$(this);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public void startup() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up failed fetcher manager");
        }

        @Override
        public void shutdown() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down failed fetcher manager");
        }

        @Override
        public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        }

        @Override
        public void addLinkedFetcherForPartitions(Iterable<Partition> partitions) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Adding linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void removeLinkedFetcherForPartitions(Set<TopicPartition> partitions, FetcherRemoveReason reason) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Removing linked fetcher for partitions ").append(partitions).append(" for failed fetcher manager").toString());
        }

        @Override
        public void shutdownIdleFetcherThreads() {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down idle fetcher threads for failed fetcher manager");
        }

        @Override
        public ClusterLinkConfig currentConfig() {
            return null;
        }

        @Override
        public Option<ReplicaStatus.MirrorInfo> partitionMirrorState(TopicPartition topicPartition, ReplicaStatus.MirrorInfo.State persistentMirrorState, Option<UnavailableLinkReason> unavailableLinkReason) {
            return new Some((Object)new ReplicaStatus.MirrorInfo(ReplicaStatus.MirrorInfo.State.LINK_FAILED, -1L, -1L));
        }

        public FetcherManager() {
            ClusterLinkFactory.FetcherManager.$init$(this);
            Logging.$init$(this);
        }
    }
}

