/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.catalog.ZKMetadataCollector;
import kafka.controller.KafkaController;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ReplicaManager;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager$;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011%d!B.]\u0003\u0003\u0019\u0007\u0002\u00039\u0001\u0005\u000b\u0007I\u0011B9\t\u0011Y\u0004!\u0011!Q\u0001\nID\u0001b\u001e\u0001\u0003\u0006\u0004%I\u0001\u001f\u0005\t{\u0002\u0011\t\u0011)A\u0005s\"Aa\u0010\u0001BC\u0002\u0013\u0005q\u0010\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0003A!\"!\u0003\u0001\u0005\u000b\u0007I\u0011AA\u0006\u0011)\t\u0019\u0002\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u001c\u0001\t\u0005\t\u0015!\u0003\u0002:!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003\"CA-\u0001\t\u0007I\u0011CA.\u0011!\t\u0019\b\u0001Q\u0001\n\u0005u\u0003bCA;\u0001\u0001\u0007\t\u0019!C\t\u0003oB1\"!\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002|!Y\u0011q\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA\u000f\u0011%\tI\t\u0001b\u0001\n\u0013\tY\t\u0003\u0005\u0002\u001e\u0002\u0001\u000b\u0011BAG\u0011%\ty\n\u0001b\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAR\u0011%\tY\f\u0001b\u0001\n\u0013\ti\f\u0003\u0005\u0002F\u0002\u0001\u000b\u0011BA`\u0011-\t9\r\u0001a\u0001\u0002\u0004%I!!3\t\u0017\u0005-\u0007\u00011AA\u0002\u0013%\u0011Q\u001a\u0005\f\u0003#\u0004\u0001\u0019!A!B\u0013\t\u0019\fC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\"I\u0011Q\u001c\u0001A\u0002\u0013%\u0011q\u001c\u0005\t\u0003G\u0004\u0001\u0015)\u0003\u0002X\"I\u0011Q\u001d\u0001A\u0002\u0013%\u0011q\u001d\u0005\n\u0003_\u0004\u0001\u0019!C\u0005\u0003cD\u0001\"!>\u0001A\u0003&\u0011\u0011\u001e\u0005\n\u0003o\u0004\u0001\u0019!C\u0005\u0003sD\u0011Ba\u0004\u0001\u0001\u0004%IA!\u0005\t\u0011\tU\u0001\u0001)Q\u0005\u0003wD\u0011Ba\u0006\u0001\u0005\u0004%\t\"!3\t\u0011\te\u0001\u0001)A\u0005\u0003gCqAa\u0007\u0001\t\u000b\u0011i\u0002C\u0004\u0003 \u0001!IA!\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003\u001e!9!\u0011\u0006\u0001\u0005\n\t-\u0002b\u0002B\u001a\u0001\u0011%!Q\u0004\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011i\u0004\u0001C\u0005\u0005\u007fAqA!\u0016\u0001\t\u0003\u00119\u0006C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!q\u000e\u0001\u0005\n\tE\u0004b\u0002B<\u0001\u0011\u0015!\u0011\u0010\u0005\b\u0005\u0003\u0003AQ\u0001BB\u0011\u001d\u0011I\t\u0001C\u0005\u0005\u0017CqA!%\u0001\t\u0003\u0011\u0019\nC\u0004\u0003\u0018\u0002!\tA!'\t\u000f\tm\u0006\u0001\"\u0002\u0003\u001e!9!Q\u0018\u0001\u0005\u0006\t}\u0006b\u0002Bc\u0001\u0019\u0005!q\u0019\u0005\b\u00057\u0004a\u0011\u0001Bo\u0011\u001d\u0011\t\u0010\u0001D\u0001\u0005gDqA!=\u0001\r\u0003\u00119\u0010C\u0004\u0003r\u00021\taa\u0001\t\u000f\r\u0015\u0001A\"\u0001\u0004\b!91Q\u0001\u0001\u0007\u0002\r-\u0001bBB\u0003\u0001\u0019\u000511\u0001\u0005\b\u0007\u001f\u0001a\u0011AB\t\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+Aqa!\u0007\u0001\t\u0003\u0019Y\u0002C\u0004\u0004*\u0001!\taa\u000b\t\u000f\r=\u0002A\"\u0001\u00042!91Q\u0007\u0001\u0007\u0002\r]\u0002bBB\u001e\u0001\u0019\u00051Q\b\u0005\b\u0007\u0003\u0002a\u0011AB\"\u0011\u001d\u0019\t\u0005\u0001D\u0001\u0007\u0013Bqa!\u0014\u0001\r\u0003\u0019y\u0005C\u0004\u0004Z\u00011\taa\u0017\t\u000f\r\u0015\u0004A\"\u0001\u0004h!911\u000e\u0001\u0007\u0002\r5\u0004bBB;\u0001\u0019\u00051q\u000f\u0005\b\u0007\u000b\u0003a\u0011ABD\u0011\u001d\u0019y\t\u0001D\u0001\u0007#Cqa!&\u0001\r\u0003\u00199\nC\u0004\u0004,\u00021\ta!,\t\u0013\r\u0005\u0007!%A\u0005\u0002\r\r\u0007bBBm\u0001\u0019\u000511\u001c\u0005\b\t\u000b\u0001a\u0011\u0001C\u0004\u0011\u001d!Y\u0001\u0001C\u0003\t\u001bAq\u0001b\u0005\u0001\r\u0003!)\u0002C\u0004\u0005,\u00011\t!!6\b\u000f\u00115B\f#\u0001\u00050\u001911\f\u0018E\u0001\tcAq!a\u0012Y\t\u0003!\u0019\u0004C\u0004\u00056a#\t\u0001b\u000e\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u000b\u0005us\u0016\u0001\u00027j].T!a\u00181\u0002\rM,'O^3s\u0015\u0005\t\u0017!B6bM.\f7\u0001A\n\u0004\u0001\u0011T\u0007CA3i\u001b\u00051'\"A4\u0002\u000bM\u001c\u0017\r\\1\n\u0005%4'AB!osJ+g\r\u0005\u0002l]6\tAN\u0003\u0002nA\u0006)Q\u000f^5mg&\u0011q\u000e\u001c\u0002\b\u0019><w-\u001b8h\u00031\u0011'o\\6fe\u000e{gNZ5h+\u0005\u0011\bCA:u\u001b\u0005q\u0016BA;_\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001b\t\u0014xn[3s\u0007>tg-[4!\u0003%\u00198\r[3ek2,'/F\u0001z!\tQ80D\u0001]\u0013\taHL\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-\u0006\u0002\u0002\u0002A\u00191/a\u0001\n\u0007\u0005\u0015aLA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003a\u0019wN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u000b\u0003\u0003\u001b\u00012a]A\b\u0013\r\t\tB\u0018\u0002!\u0005J|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/A\rd_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\u0004\u0013!\u00057pG\u0006d\u0017\tZ7j]\u001a\u000b7\r^8ssB)Q-!\u0007\u0002\u001e%\u0019\u00111\u00044\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003BA\u0010\u0003gi!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0005\u0003O\tI#A\u0004dY&,g\u000e^:\u000b\u0007\u0005\fYC\u0003\u0003\u0002.\u0005=\u0012AB1qC\u000eDWM\u0003\u0002\u00022\u0005\u0019qN]4\n\t\u0005U\u0012\u0011\u0005\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u000bg\u0016\u0014h/\u001a:J]\u001a|\u0007\u0003BA\u001e\u0003\u0007j!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(bA0\u0002*%!\u0011QIA\u001f\u0005Q\tU\u000f\u001e5pe&TXM]*feZ,'/\u00138g_\u00061A(\u001b8jiz\"b\"a\u0013\u0002N\u0005=\u0013\u0011KA*\u0003+\n9\u0006\u0005\u0002{\u0001!)\u0001o\u0003a\u0001e\")qo\u0003a\u0001s\"1ap\u0003a\u0001\u0003\u0003Aq!!\u0003\f\u0001\u0004\ti\u0001C\u0004\u0002\u0016-\u0001\r!a\u0006\t\u000f\u0005]2\u00021\u0001\u0002:\u0005iQ.\u001a;bI\u0006$\u0018\rV8qS\u000e,\"!!\u0018\u0011\t\u0005}\u0013Q\u000e\b\u0005\u0003C\nI\u0007E\u0002\u0002d\u0019l!!!\u001a\u000b\u0007\u0005\u001d$-\u0001\u0004=e>|GOP\u0005\u0004\u0003W2\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002p\u0005E$AB*ue&twMC\u0002\u0002l\u0019\fa\"\\3uC\u0012\fG/\u0019+pa&\u001c\u0007%A\u0005eKN$\u0018\tZ7j]V\u0011\u0011QD\u0001\u000eI\u0016\u001cH/\u00113nS:|F%Z9\u0015\t\u0005u\u00141\u0011\t\u0004K\u0006}\u0014bAAAM\n!QK\\5u\u0011%\t)iDA\u0001\u0002\u0004\ti\"A\u0002yIE\n!\u0002Z3ti\u0006#W.\u001b8!\u0003\u0011awnY6\u0016\u0005\u00055\u0005\u0003BAH\u00033k!!!%\u000b\t\u0005M\u0015QS\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0018\u0006!!.\u0019<b\u0013\u0011\tY*!%\u0003\r=\u0013'.Z2u\u0003\u0015awnY6!\u0003=ywO\\3e!\u0006\u0014H/\u001b;j_:\u001cXCAAR!\u0019\t)+a,\u000246\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0004nkR\f'\r\\3\u000b\u0007\u00055f-\u0001\u0006d_2dWm\u0019;j_:LA!!-\u0002(\n\u00191+\u001a;\u0011\u0007\u0015\f),C\u0002\u00028\u001a\u00141!\u00138u\u0003AywO\\3e!\u0006\u0014H/\u001b;j_:\u001c\b%A\nqCJ$\u0018\u000e^5p]R{W\t]8dQ6\u000b\u0007/\u0006\u0002\u0002@BA\u0011QUAa\u0003g\u000b\u0019,\u0003\u0003\u0002D\u0006\u001d&aA'ba\u0006!\u0002/\u0019:uSRLwN\u001c+p\u000bB|7\r['ba\u0002\nQC\\;n\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7/\u0006\u0002\u00024\u0006Ib.^7NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\ti(a4\t\u0013\u0005\u0015\u0005$!AA\u0002\u0005M\u0016A\u00068v[6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0017%t\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0003/\u00042!ZAm\u0013\r\tYN\u001a\u0002\b\u0005>|G.Z1o\u0003=Ig.\u001b;jC2L'0\u001a3`I\u0015\fH\u0003BA?\u0003CD\u0011\"!\"\u001c\u0003\u0003\u0005\r!a6\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\u0002\u00159,XNU3ue&,7/\u0006\u0002\u0002jB\u0019Q-a;\n\u0007\u00055hM\u0001\u0003M_:<\u0017A\u00048v[J+GO]5fg~#S-\u001d\u000b\u0005\u0003{\n\u0019\u0010C\u0005\u0002\u0006z\t\t\u00111\u0001\u0002j\u0006Ya.^7SKR\u0014\u0018.Z:!\u0003YiW\r^1eCR\f\u0017*\\1hK2K7\u000f^3oKJ\u001cXCAA~!\u0019\t)+!@\u0003\u0002%!\u0011q`AT\u0005\u0019\u0011UO\u001a4feB!!1\u0001B\u0005\u001d\rQ(QA\u0005\u0004\u0005\u000fa\u0016AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefLAAa\u0003\u0003\u000e\t9B*\u001b8l\u0007>|'\u000fZ5oCR|'\u000fT5ti\u0016tWM\u001d\u0006\u0004\u0005\u000fa\u0016AG7fi\u0006$\u0017\r^1J[\u0006<W\rT5ti\u0016tWM]:`I\u0015\fH\u0003BA?\u0005'A\u0011\"!\"\"\u0003\u0003\u0005\r!a?\u0002/5,G/\u00193bi\u0006LU.Y4f\u0019&\u001cH/\u001a8feN\u0004\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000fI\u0001\bgR\f'\u000f^;q)\t\ti(A\bti\u0006\u0014H/\u001e9J]R,'O\\1m)\u0011\tiHa\t\t\u000f\t\u0015b\u00051\u0001\u0002j\u00069A-\u001a7bs6\u001b\u0018!\t7p_.,\b/\u00118e\u001b\u0006L(-Z\"sK\u0006$X-T3uC\u0012\fG/\u0019+pa&\u001c\u0017AH4fi6+G/\u00193bi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u+\t\u0011i\u0003E\u0003f\u0005_\t\u0019,C\u0002\u00032\u0019\u0014aa\u00149uS>t\u0017aE2sK\u0006$X-T3uC\u0012\fG/\u0019+pa&\u001c\u0017!G5oSRL\u0017\r\\5{K6+G/\u00193bi\u0006l\u0015M\\1hKJ$B!! \u0003:!9!1\b\u0016A\u0002\u0005M\u0016A\u00049beRLG/[8o\u0007>,h\u000e^\u0001\u001eO\u0016$8\t\\;ti\u0016\u0014H*\u001b8lg\u001a{'\u000fU1si&$\u0018n\u001c8JIR!!\u0011\tB)!\u0019\tyFa\u0011\u0003F%!\u0011\u0011WA9!\u0011\u00119E!\u0014\u000e\u0005\t%#b\u0001B&A\u0006\u0011!p[\u0005\u0005\u0005\u001f\u0012IEA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011\u001d\u0011\u0019f\u000ba\u0001\u0003g\u000b1\u0002]1si&$\u0018n\u001c8JI\u00069s-\u001a;DYV\u001cH/\u001a:MS:\\7oV5uQ>;h.\u001a3MS:\\7i\\8sI&t\u0017\r^8s)\t\u0011\t%A\u000bmS:\\g*Y7f)>\u0004\u0016M\u001d;ji&|g.\u00133\u0015\t\u0005M&Q\f\u0005\b\u0005?j\u0003\u0019AA/\u0003!a\u0017N\\6OC6,\u0017aE7fi\u0006$\u0017\r^1U_BL7mQ8oM&<WC\u0001B3!!\u00119G!\u001c\u0002^\u0005uSB\u0001B5\u0015\u0011\u0011Y'!&\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0007\u0014I'\u0001\nm_\u001e,%O]8sg>sg)Y5mkJ,G\u0003BA?\u0005gBqA!\u001e0\u0001\u0004\ti&A\u0002tiJ\f!b\u001c8FY\u0016\u001cG/[8o)\u0019\tiHa\u001f\u0003~!9!1\u000b\u0019A\u0002\u0005M\u0006b\u0002B@a\u0001\u0007\u00111W\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007.A\u0007p]J+7/[4oCRLwN\u001c\u000b\u0007\u0003{\u0012)Ia\"\t\u000f\tM\u0013\u00071\u0001\u00024\"9!qP\u0019A\u0002\t5\u0012!G7bs\n,W\u000b\u001d3bi\u0016\u0004\u0016M\u001d;ji&|g.\u00129pG\"$b!a6\u0003\u000e\n=\u0005b\u0002B*e\u0001\u0007\u00111\u0017\u0005\b\u0005\u007f\u0012\u0004\u0019\u0001B\u0017\u0003EI7\u000fT5oW\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0005\u0003/\u0014)\nC\u0004\u0003`M\u0002\r!!\u0018\u0002\u001f1Lgn[\"p_J$\u0017N\\1u_J$bAa'\u0003*\n-\u0006#B3\u00030\tu\u0005\u0003\u0002BP\u0005Kk!A!)\u000b\t\t\r\u0016\u0011F\u0001\u0007G>lWn\u001c8\n\t\t\u001d&\u0011\u0015\u0002\u0005\u001d>$W\rC\u0004\u0003`Q\u0002\r!!\u0018\t\u000f\t5F\u00071\u0001\u00030\u0006aA.[:uK:,'OT1nKB!!\u0011\u0017B\\\u001b\t\u0011\u0019L\u0003\u0003\u00036\n\u0005\u0016a\u00028fi^|'o[\u0005\u0005\u0005s\u0013\u0019L\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\u0005tQV$Hm\\<o\u0003!\u0011XmZ5ti\u0016\u0014H\u0003BA?\u0005\u0003DqAa17\u0001\u0004\u0011\t!\u0001\u0005mSN$XM\\3s\u0003-i\u0017N\u001d:peR{\u0007/[2\u0015\t\t%'q\u001b\t\u0006K\n=\"1\u001a\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*!!\u0011[A\u0015\u0003!iW\r^1eCR\f\u0017\u0002\u0002Bk\u0005\u001f\u00141\"T5se>\u0014Hk\u001c9jG\"9!\u0011\\\u001cA\u0002\u0005u\u0013!\u0002;pa&\u001c\u0017AI7jeJ|'\u000fV8qS\u000e\u001cF/\u0019;fg\u001a\u0013x.\\'fi\u0006$\u0017\r^1Ti>\u0014X\r\u0006\u0003\u0003`\n-\b\u0003\u0003Bq\u0005G\fiF!:\u000e\u0005\u0005-\u0016\u0002BAb\u0003W\u00032A\u001fBt\u0013\r\u0011I\u000f\u0018\u0002\u0016\u00072,8\u000f^3s\u0019&t7\u000eV8qS\u000e\u001cF/\u0019;f\u0011\u001d\u0011i\u000f\u000fa\u0001\u0005_\fa\u0001^8qS\u000e\u001c\bCBA0\u0005\u0007\ni&\u0001\u0012nSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN4%o\\7NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0005?\u0014)\u0010C\u0004\u0003nf\u0002\rAa<\u0015\t\t}'\u0011 \u0005\b\u0005wT\u0004\u0019\u0001B\u007f\u0003\u0019a\u0017N\\6JIB!!q\u0014B\u0000\u0013\u0011\u0019\tA!)\u0003\tU+\u0018\u000e\u001a\u000b\u0003\u0005?\fa%\\5se>\u0014Hk\u001c9jGN#\u0018\r^3t\rJ|WnQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u)\u0011\u0011yn!\u0003\t\u000f\t5H\b1\u0001\u0003pR!!q\\B\u0007\u0011\u001d\u0011Y0\u0010a\u0001\u0005{\fQcZ3u\u00032dGk\u001c9jGNLen\u00117vgR,'\u000f\u0006\u0002\u0003p\u0006ia.^7QCJ$\u0018\u000e^5p]N$BA!\f\u0004\u0018!9!\u0011\u001c!A\u0002\u0005u\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0015\t\ru1Q\u0005\t\u0007\u0003?\u0012\u0019ea\b\u0011\t\t}5\u0011E\u0005\u0005\u0007G\u0011\tK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\r\u001d\u0012\t1\u0001\u0002^\u0005IAo\u001c9jG:\u000bW.Z\u0001\tQ\u0006\u001cHk\u001c9jGR!\u0011q[B\u0017\u0011\u001d\u0011IN\u0011a\u0001\u0003;\n!$[:U_BL7-U;fk\u0016$W\u000b\u001d$pe\u0012+G.\u001a;j_:$B!a6\u00044!9!\u0011\\\"A\u0002\u0005u\u0013aF3ogV\u0014Xm\u00117vgR,'\u000fT5oW\u0016C\u0018n\u001d;t)\u0011\tih!\u000f\t\u000f\tmH\t1\u0001\u0003~\u0006\t2\r\\;ti\u0016\u0014H*\u001b8l\u000bbL7\u000f^:\u0015\t\u0005]7q\b\u0005\b\u0005w,\u0005\u0019\u0001B\u007f\u0003I9W\r^\"mkN$XM\u001d'j].$\u0015\r^1\u0015\t\r\u00153q\t\t\u0006K\n=\"Q\t\u0005\b\u0005w4\u0005\u0019\u0001B\u007f)\u0011\u0019)ea\u0013\t\u000f\t}s\t1\u0001\u0002^\u0005Ir-\u001a;DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004&o\u001c9t)\u0011\u0019\tfa\u0016\u0011\t\t\u001d41K\u0005\u0005\u0007+\u0012IG\u0001\u0006Qe>\u0004XM\u001d;jKNDqAa?I\u0001\u0004\u0011i0\u0001\u000bhKR\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u000b\u0005\u0007;\u001a\u0019\u0007E\u0002{\u0007?J1a!\u0019]\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0005\b\u0005wL\u0005\u0019\u0001B\u007f\u000399W\r\u001e+pa&\u001c7i\u001c8gS\u001e$Ba!\u0015\u0004j!9!\u0011\u001c&A\u0002\u0005u\u0013aG1mi\u0016\u00148\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4[\u001d>$W\r\u0006\u0004\u0002~\r=4\u0011\u000f\u0005\b\u0005w\\\u0005\u0019\u0001B\u007f\u0011\u001d\u0019\u0019h\u0013a\u0001\u0007#\nQ\u0001\u001d:paN\f\u0001%\\1zE\u0016\u0014V-\u001a8def\u0004Ho\u00117vgR,'\u000fT5oW\u000e{gNZ5hgR!\u0011QPB=\u0011\u001d\u0019Y\b\u0014a\u0001\u0007{\n\u0011cY8oM&<GK]1og\u001a|'/\\3s!\u001d)7qPB)\u0007\u0007K1a!!g\u0005%1UO\\2uS>t\u0017\u0007E\u0003f\u0005_\u0019\t&\u0001\fde\u0016\fG/Z\"mkN$XM\u001d'j].Tfj\u001c3f)\u0019\tih!#\u0004\u000e\"911R'A\u0002\t\u0015\u0013aD2mkN$XM\u001d'j].$\u0015\r^1\t\u000f\rMT\n1\u0001\u0004R\u0005\u00192/\u001a;DYV\u001cH/\u001a:MS:\\'LT8eKR!\u0011QPBJ\u0011\u001d\u0019YI\u0014a\u0001\u0005\u000b\nqcZ3u\u00032dG*\u001b8lg\u001a\u0013x.\\'fi\u0006$\u0017\r^1\u0015\u0005\re\u0005CBBN\u0007K\u0013)E\u0004\u0003\u0004\u001e\u000e\u0005f\u0002BA2\u0007?K\u0011aZ\u0005\u0004\u0007G3\u0017a\u00029bG.\fw-Z\u0005\u0005\u0007O\u001bIKA\u0002TKFT1aa)g\u0003U\tG\u000e^3s\u001b&\u0014(o\u001c:U_BL7m\u0015;bi\u0016$\"\"! \u00040\u000eE6\u0011XB_\u0011\u001d\u0011I\u000e\u0015a\u0001\u0003;Bqaa-Q\u0001\u0004\u0019),\u0001\u0007ti\u0006$X-\u00169eCR,'\u000fE\u0004f\u0007\u007f\u0012)oa.\u0011\u000b\u0015\u0014yC!:\t\u000f\rm\u0006\u000b1\u0001\u0002X\u0006aa/\u00197jI\u0006$Xm\u00148ms\"I1q\u0018)\u0011\u0002\u0003\u0007\u0011q[\u0001\u0010M\u0006LG.\u00134O_Rl\u0015N\u001d:pe\u0006y\u0012\r\u001c;fe6K'O]8s)>\u0004\u0018nY*uCR,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u0015'\u0006BAl\u0007\u000f\\#a!3\u0011\t\r-7Q[\u0007\u0003\u0007\u001bTAaa4\u0004R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007'4\u0017AC1o]>$\u0018\r^5p]&!1q[Bg\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\7\u000f\u0006\u0003\u0004^\u000eU\bCBBp\u0007K\u001cI/\u0004\u0002\u0004b*!11\u001dB5\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0007O\u001c\tOA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004Baa;\u0004r6\u00111Q\u001e\u0006\u0005\u0007_\u0014\t+\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019\u0019p!<\u00035\r\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7n\u001d*fgB|gn]3\t\u000f\r](\u000b1\u0001\u0004z\u0006i2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6t%\u0016\fX/Z:u\t\u0006$\u0018\r\u0005\u0003\u0004|\u0012\u0005QBAB\u007f\u0015\u0011\u0019yP!)\u0002\u000f5,7o]1hK&!A1AB\u007f\u0005u\u0019%/Z1uK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;ECR\f\u0017A\u00063fY\u0016$Xm\u00117vgR,'\u000fT5oWjsu\u000eZ3\u0015\t\u0005uD\u0011\u0002\u0005\b\u0005w\u001c\u0006\u0019\u0001B\u007f\u00039I7O\u0011:pW\u0016\u0014xJ\u001c7j]\u0016$B!a6\u0005\u0010!9A\u0011\u0003+A\u0002\u0005M\u0016\u0001\u00032s_.,'/\u00133\u0002\u001fM$x\u000e]'jeJ|'\u000fV8qS\u000e$b\u0001b\u0006\u0005$\u0011\u0015\u0002C\u0002BP\t3!i\"\u0003\u0003\u0005\u001c\t\u0005&aC&bM.\fg)\u001e;ve\u0016\u0004B!a$\u0005 %!A\u0011EAI\u0005\u00111v.\u001b3\t\u000f\teW\u000b1\u0001\u0002^!9AqE+A\u0002\u0011%\u0012!\u00047pO\u0016sGm\u00144gg\u0016$8\u000f\u0005\u0004\u0004\u001c\u000e\u0015\u0016\u0011^\u0001\u0019SNd\u0015N\\6D_>\u0014H-\u001b8bi>\u0014XI\\1cY\u0016$\u0017AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\bC\u0001>Y'\tAF\r\u0006\u0002\u00050\u0005\u00013M]3bi\u0016\u001cE.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s)I\tY\u0005\"\u000f\u0005<\u0011uBq\tC%\t\u0017\"i\u0005b\u0016\t\u000bAT\u0006\u0019\u0001:\t\u000b]T\u0006\u0019A=\t\u000f\u0011}\"\f1\u0001\u0005B\u0005yQ.\u001a;bI\u0006$\u0018mU;qa>\u0014H\u000fE\u0002t\t\u0007J1\u0001\"\u0012_\u0005=iU\r^1eCR\f7+\u001e9q_J$\bbBA\u00055\u0002\u0007\u0011Q\u0002\u0005\b\u0003+Q\u0006\u0019AA\f\u0011\u001d\t9D\u0017a\u0001\u0003sAq\u0001b\u0014[\u0001\u0004!\t&\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007M$\u0019&C\u0002\u0005Vy\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0004\u0005Zi\u0003\r\u0001b\u0017\u0002'i\\W*\u001a;bI\u0006$\u0018mQ8mY\u0016\u001cGo\u001c:\u0011\u000b\u0015\u0014y\u0003\"\u0018\u0011\t\u0011}CQM\u0007\u0003\tCR1\u0001b\u0019a\u0003\u001d\u0019\u0017\r^1m_\u001eLA\u0001b\u001a\u0005b\t\u0019\"lS'fi\u0006$\u0017\r^1D_2dWm\u0019;pe\u0002")
public abstract class ClusterLinkMetadataManager
implements Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkScheduler scheduler;
    private final MetadataCache metadataCache;
    private final BrokerToControllerChannelManager controllerChannelManager;
    private final Function0<Admin> localAdminFactory;
    private final String metadataTopic;
    private Admin destAdmin;
    private final Object lock;
    private final Set<Object> ownedPartitions;
    private final scala.collection.mutable.Map<Object, Object> partitionToEpochMap;
    private int numMetadataPartitions;
    private boolean initialized;
    private long numRetries;
    private Buffer<ClusterLinkFactory.LinkCoordinatorListener> metadataImageListeners;
    private final int requestTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static ClusterLinkMetadataManager createClusterLinkMetadataManager(KafkaConfig kafkaConfig, ClusterLinkScheduler clusterLinkScheduler, MetadataSupport metadataSupport, BrokerToControllerChannelManager brokerToControllerChannelManager, Function0<Admin> function0, AuthorizerServerInfo authorizerServerInfo, ReplicaManager replicaManager, Option<ZKMetadataCollector> option) {
        ClusterLinkMetadataManager clusterLinkMetadataManager;
        if (ClusterLinkMetadataManager$.MODULE$ == null) {
            throw null;
        }
        if (metadataSupport instanceof ZkSupport) {
            ZkSupport zkSupport = (ZkSupport)metadataSupport;
            KafkaController createClusterLinkMetadataManager_controller = zkSupport.controller();
            KafkaZkClient createClusterLinkMetadataManager_zkClient = zkSupport.zkClient();
            ZkMetadataCache createClusterLinkMetadataManager_metadataCache = zkSupport.metadataCache();
            clusterLinkMetadataManager = new ClusterLinkMetadataManagerWithZkSupport(kafkaConfig, clusterLinkScheduler, createClusterLinkMetadataManager_metadataCache, brokerToControllerChannelManager, createClusterLinkMetadataManager_controller, createClusterLinkMetadataManager_zkClient, function0, replicaManager, authorizerServerInfo, option);
        } else if (metadataSupport instanceof RaftSupport) {
            KRaftMetadataCache createClusterLinkMetadataManager_metadataCache = ((RaftSupport)metadataSupport).metadataCache();
            clusterLinkMetadataManager = new ClusterLinkMetadataManagerWithKRaftSupport(kafkaConfig, clusterLinkScheduler, createClusterLinkMetadataManager_metadataCache, brokerToControllerChannelManager, function0, authorizerServerInfo);
        } else {
            throw new MatchError((Object)metadataSupport);
        }
        return clusterLinkMetadataManager;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public BrokerToControllerChannelManager controllerChannelManager() {
        return this.controllerChannelManager;
    }

    public String metadataTopic() {
        return this.metadataTopic;
    }

    public Admin destAdmin() {
        return this.destAdmin;
    }

    public void destAdmin_$eq(Admin x$1) {
        this.destAdmin = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private Set<Object> ownedPartitions() {
        return this.ownedPartitions;
    }

    private scala.collection.mutable.Map<Object, Object> partitionToEpochMap() {
        return this.partitionToEpochMap;
    }

    private int numMetadataPartitions() {
        return this.numMetadataPartitions;
    }

    private void numMetadataPartitions_$eq(int x$1) {
        this.numMetadataPartitions = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private long numRetries() {
        return this.numRetries;
    }

    private void numRetries_$eq(long x$1) {
        this.numRetries = x$1;
    }

    private Buffer<ClusterLinkFactory.LinkCoordinatorListener> metadataImageListeners() {
        return this.metadataImageListeners;
    }

    private void metadataImageListeners_$eq(Buffer<ClusterLinkFactory.LinkCoordinatorListener> x$1) {
        this.metadataImageListeners = x$1;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public final void startup() {
        if (Predef$.MODULE$.Boolean2boolean(this.brokerConfig().clusterLinkMetadataTopicEnable()) || this.metadataCache() instanceof KRaftMetadataCache) {
            this.startupInternal(0L);
        }
    }

    private void startupInternal(long delayMs) {
        if (this.destAdmin() == null) {
            this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
        }
        this.scheduler().scheduleOnce("lookupClusterLinkMetadataTopic", () -> this.lookupAndMaybeCreateMetadataTopic(), delayMs);
    }

    private void lookupAndMaybeCreateMetadataTopic() {
        Option<Object> numPartitions = this.getMetadataTopicPartitionCount();
        if (numPartitions.nonEmpty()) {
            if (!BoxesRunTime.equals((Object)numPartitions.get(), (Object)this.brokerConfig().clusterLinkMetadataTopicPartitions())) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Found internal metadata topic with different number of partitions(").append(numPartitions.get()).append(") than in the config(").append(this.brokerConfig().clusterLinkMetadataTopicPartitions()).toString());
            }
            this.initializeMetadataManager(BoxesRunTime.unboxToInt((Object)numPartitions.get()));
            return;
        }
        this.createMetadataTopic();
    }

    private Option<Object> getMetadataTopicPartitionCount() {
        return this.metadataCache().numPartitions(this.metadataTopic());
    }

    private void createMetadataTopic() {
        NewTopic topic = new NewTopic(this.metadataTopic(), Predef$.MODULE$.Integer2int(this.brokerConfig().clusterLinkMetadataTopicPartitions()), Predef$.MODULE$.Short2short(this.brokerConfig().clusterLinkMetadataTopicReplicationFactor()));
        topic.configs(this.metadataTopicConfig());
        CreateTopicsResult createResult = this.destAdmin().createTopics(Collections.singletonList(topic));
        this.scheduler().scheduleWhenComplete("createClusterLinkMetadataTopicResponse", createResult.all(), () -> {
            Long retryDelayMs = this.brokerConfig().clusterLinkMetadataTopicCreateRetryDelayMs();
            try {
                this.initializeMetadataManager(Predef$.MODULE$.Integer2int((Integer)createResult.numPartitions(this.metadataTopic()).get()));
                this.numRetries_$eq(0L);
                return;
            }
            catch (ExecutionException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof TopicExistsException) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cluster link metadata topic creation failed as it is already created.");
                    retryDelayMs = Predef$.MODULE$.long2Long(0L);
                } else if (throwable instanceof TopicAuthorizationException) {
                    TopicAuthorizationException topicAuthorizationException = (TopicAuthorizationException)throwable;
                    this.logErrorsOnFailure(new StringBuilder(54).append("Unable to create cluster link metadata topic due to ").append(topicAuthorizationException).append(": ").append(ex.getMessage()).toString());
                } else if (throwable != null) {
                    this.logErrorsOnFailure(new StringBuilder(45).append("Cluster link metadata topic creation failed: ").append(throwable).toString());
                } else {
                    throw new MatchError(null);
                }
                this.startupInternal(Predef$.MODULE$.Long2long(retryDelayMs));
                return;
            }
            catch (Throwable e) {
                this.logErrorsOnFailure(new StringBuilder(45).append("Cluster link metadata topic creation failed: ").append(e).toString());
                this.startupInternal(Predef$.MODULE$.Long2long(retryDelayMs));
                return;
            }
        });
    }

    private void initializeMetadataManager(int partitionCount) {
        Object object = this.lock();
        synchronized (object) {
            this.numMetadataPartitions_$eq(partitionCount);
            this.initialized_$eq(true);
        }
        scala.collection.immutable.Set<ClusterLinkData> links = this.getClusterLinksWithOwnedLinkCoordinator();
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.onClusterLinkCoordinatorElection((scala.collection.immutable.Set<ClusterLinkData>)links);
            return BoxedUnit.UNIT;
        });
    }

    private scala.collection.immutable.Set<ClusterLinkData> getClusterLinksForPartitionId(int partitionId) {
        block8: {
            Object object = this.lock();
            synchronized (object) {
                scala.collection.immutable.Set set;
                block7: {
                    if (!this.initialized()) {
                        set = Predef$.MODULE$.Set().empty();
                        break block7;
                    }
                    break block8;
                }
                return set;
            }
        }
        Seq<ClusterLinkData> links = this.getAllLinksFromMetadata();
        Object object = this.lock();
        synchronized (object) {
            scala.collection.immutable.Set set = ((TraversableOnce)links.filter((Function1 & Serializable & scala.Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManager.$anonfun$getClusterLinksForPartitionId$1(this, partitionId, cld)))).toSet();
            return set;
        }
    }

    public scala.collection.immutable.Set<ClusterLinkData> getClusterLinksWithOwnedLinkCoordinator() {
        return ((TraversableOnce)this.getAllLinksFromMetadata().filter((Function1 & Serializable & scala.Serializable)cld -> BoxesRunTime.boxToBoolean((boolean)this.isLinkCoordinator(cld.linkName())))).toSet();
    }

    private int linkNameToPartitionId(String linkName) {
        if (!this.initialized()) {
            return -1;
        }
        return Utils.toPositive((int)Utils.murmur2((byte[])linkName.getBytes())) % this.numMetadataPartitions();
    }

    /*
     * WARNING - void declaration
     */
    private java.util.Map<String, String> metadataTopicConfig() {
        void var1_1;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", this.brokerConfig().clusterLinkMetadataTopicMinInSyncReplicas().toString());
        return var1_1;
    }

    private void logErrorsOnFailure(String str) {
        this.numRetries_$eq(this.numRetries() + 1L);
        if (this.numRetries() <= 10L) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> str);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> str);
    }

    public final void onElection(int partitionId, int leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)))) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Elected as link coordinator for links with metadata topic partition ").append(partitionId).append(" at").append(" epoch ").append(leaderEpoch).toString());
                bl2 = this.ownedPartitions().add((Object)BoxesRunTime.boxToInteger((int)partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        scala.collection.immutable.Set links = bl ? this.getClusterLinksForPartitionId(partitionId) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.onClusterLinkCoordinatorElection((scala.collection.immutable.Set<ClusterLinkData>)links);
            return BoxedUnit.UNIT;
        });
    }

    public final void onResignation(int partitionId, Option<Object> leaderEpoch) {
        boolean bl;
        Object object = this.lock();
        synchronized (object) {
            boolean bl2;
            if (this.maybeUpdatePartitionEpoch(partitionId, leaderEpoch)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Resigned as link coordinator for links with metadata topic partition ").append(partitionId).append(" ").append("at epoch ").append(leaderEpoch).toString());
                bl2 = this.ownedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)partitionId));
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        scala.collection.immutable.Set linkIds = bl ? (scala.collection.immutable.Set)this.getClusterLinksForPartitionId(partitionId).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.linkId(), Set$.MODULE$.canBuildFrom()) : Predef$.MODULE$.Set().empty();
        this.metadataImageListeners().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.onClusterLinkCoordinatorResignation((scala.collection.immutable.Set<Uuid>)linkIds);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean maybeUpdatePartitionEpoch(int partitionId, Option<Object> leaderEpoch) {
        if (leaderEpoch.isEmpty()) {
            return true;
        }
        int newLeaderEpoch = BoxesRunTime.unboxToInt((Object)leaderEpoch.get());
        boolean bl = false;
        Option option = this.partitionToEpochMap().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            bl = true;
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            if (newLeaderEpoch > epoch) {
                this.partitionToEpochMap().put((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)newLeaderEpoch));
                return true;
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.partitionToEpochMap().put((Object)BoxesRunTime.boxToInteger((int)partitionId), (Object)BoxesRunTime.boxToInteger((int)newLeaderEpoch));
            return true;
        }
        if (!bl) throw new MatchError((Object)option);
        return false;
    }

    public boolean isLinkCoordinator(String linkName) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl;
            block4: {
                if (!this.initialized()) {
                    bl = false;
                    break block4;
                }
                boolean bl2 = this.ownedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)this.linkNameToPartitionId(linkName)));
                return bl2;
            }
            return bl;
        }
    }

    public Option<Node> linkCoordinator(String linkName, ListenerName listenerName) {
        Object object = this.lock();
        synchronized (object) {
            None$ none$;
            block4: {
                if (!this.initialized()) {
                    none$ = None$.MODULE$;
                    break block4;
                }
                Option<Node> option = this.metadataCache().getPartitionLeaderEndpoint(this.metadataTopic(), this.linkNameToPartitionId(linkName), listenerName);
                return option;
            }
            return none$;
        }
    }

    public final void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            this.initialized_$eq(false);
            this.partitionToEpochMap().clear();
            this.ownedPartitions().clear();
            this.numMetadataPartitions_$eq(-1);
            return;
        }
    }

    public final void register(ClusterLinkFactory.LinkCoordinatorListener listener) {
        this.metadataImageListeners_$eq((Buffer<ClusterLinkFactory.LinkCoordinatorListener>)this.metadataImageListeners().$plus$eq((Object)listener));
    }

    public abstract Option<MirrorTopic> mirrorTopic(String var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache();

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(scala.collection.immutable.Set<String> var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid var1);

    public abstract Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext();

    public abstract scala.collection.immutable.Set<String> getAllTopicsInCluster();

    public Option<Object> numPartitions(String topic) {
        return this.metadataCache().numPartitions(topic);
    }

    public scala.collection.immutable.Set<TopicPartition> topicPartitions(String topicName) {
        return this.metadataCache().getTopicPartitions(topicName).toSet();
    }

    public boolean hasTopic(String topic) {
        return this.metadataCache().contains(topic);
    }

    public abstract boolean isTopicQueuedUpForDeletion(String var1);

    public abstract void ensureClusterLinkExists(Uuid var1);

    public abstract boolean clusterLinkExists(Uuid var1);

    public abstract Option<ClusterLinkData> getClusterLinkData(Uuid var1);

    public abstract Option<ClusterLinkData> getClusterLinkData(String var1);

    public abstract Properties getClusterLinkConfigProps(Uuid var1);

    public abstract ClusterLinkConfig getClusterLinkConfig(Uuid var1);

    public abstract Properties getTopicConfig(String var1);

    public abstract void alterClusterLinkConfigZNode(Uuid var1, Properties var2);

    public abstract void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> var1);

    public abstract void createClusterLinkZNode(ClusterLinkData var1, Properties var2);

    public abstract void setClusterLinkZNode(ClusterLinkData var1);

    public abstract Seq<ClusterLinkData> getAllLinksFromMetadata();

    public abstract void alterMirrorTopicState(String var1, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> var2, boolean var3, boolean var4);

    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    public abstract CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData var1);

    public abstract void deleteClusterLinkZNode(Uuid var1);

    public final boolean isBrokerOnline(int brokerId) {
        return this.metadataCache().hasAliveBroker(brokerId);
    }

    public abstract KafkaFuture<Void> stopMirrorTopic(String var1, Seq<Object> var2);

    public abstract boolean isLinkCoordinatorEnabled();

    public static final /* synthetic */ boolean $anonfun$getClusterLinksForPartitionId$1(ClusterLinkMetadataManager $this, int partitionId$1, ClusterLinkData cld) {
        return $this.linkNameToPartitionId(cld.linkName()) == partitionId$1;
    }

    public ClusterLinkMetadataManager(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, MetadataCache metadataCache, BrokerToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.brokerConfig = brokerConfig;
        this.scheduler = scheduler;
        this.metadataCache = metadataCache;
        this.controllerChannelManager = controllerChannelManager;
        this.localAdminFactory = localAdminFactory;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[ClusterLinkMetadataManager-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        this.metadataTopic = "_confluent-link-metadata";
        this.lock = new Object();
        this.ownedPartitions = (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionToEpochMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.initialized = false;
        this.numRetries = 0L;
        this.metadataImageListeners = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.requestTimeoutMs = Predef$.MODULE$.Integer2int(new AdminClientConfig(ConfluentConfigs.clientConfigsForEndpoint((AbstractConfig)brokerConfig, (Endpoint)serverInfo.interBrokerEndpoint())).getInt("request.timeout.ms"));
    }
}

