/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkControllerRequestCompletionHandler;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.AlterMirrorTopicsRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterMirrorTopicsRequest;
import org.apache.kafka.common.requests.AlterMirrorTopicsResponse;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.ClusterLink;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.immutable.ImmutableMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tmg\u0001B\u0015+\u0001EB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Iq\b\u0001B\u0001B\u0003%\u0001I\u0012\u0005\n\u000f\u0002\u0011\t\u0011)A\u0005\u0011.C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\tA\u0002\u0011\t\u0011)A\u0005C\")\u0001\u000e\u0001C\u0001S\")\u0011\u000f\u0001C!e\"9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\t\u0001\u0011%\u00111\u0007\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\ti\u0005\u0001C!\u0003\u001fBq!!\u0014\u0001\t\u0003\n\u0019\u0006C\u0004\u0002N\u0001!\t%a\u0016\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011\u0011\f\u0001\u0005B\u0005}\u0003bBA-\u0001\u0011\u0005\u0013q\u000b\u0005\b\u0003G\u0002A\u0011IA3\u0011\u001d\t9\u0007\u0001C!\u0003SBq!a\u001d\u0001\t\u0003\n)\bC\u0004\u0002\u0000\u0001!\t%!!\t\u000f\u0005\u0015\u0005\u0001\"\u0011\u0002\b\"9\u0011Q\u0011\u0001\u0005\u0002\u0005e\u0005bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003k\u0003A\u0011IA\\\u0011\u001d\t\t\r\u0001C!\u0003\u0007Dq!a2\u0001\t\u0003\nI\rC\u0004\u0002R\u0002!\t%a5\t\u000f\u0005\u0005\b\u0001\"\u0011\u0002d\"9\u00111\u001e\u0001\u0005B\u00055\bbBAy\u0001\u0011\u0005\u00131\u001f\u0005\n\u0005\u000f\u0001\u0011\u0013!C\u0001\u0005\u0013AqAa\b\u0001\t\u0003\u0012\t\u0003C\u0004\u0003&\u0001!IAa\n\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!9!Q\u0010\u0001\u0005B\t}\u0004b\u0002BS\u0001\u0011\u0005#q\u0015\u0005\b\u0005w\u0003A\u0011\tB_\u0011\u001d\u0011i\r\u0001C!\u0005\u001fDQB!5\u0001!\u0003\r\t\u0011!C\u0005\u0005'4%AK\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014x+\u001b;i\u0017J\u000bg\r^*vaB|'\u000f\u001e\u0006\u0003W1\nA\u0001\\5oW*\u0011QFL\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001eA\u00111\u0007N\u0007\u0002U%\u0011QG\u000b\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003qej\u0011\u0001L\u0005\u0003u1\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u0003guJ!A\u0010\u0016\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u00035iW\r^1eCR\f7)Y2iKB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tL\u0001\t[\u0016$\u0018\rZ1uC&\u0011QI\u0011\u0002\u0013\u0017J\u000bg\r^'fi\u0006$\u0017\r^1DC\u000eDW-\u0003\u0002@i\u0005A2m\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u0011\u0005aJ\u0015B\u0001&-\u0005\u0001\u0012%o\\6feR{7i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\n\u0005\u001d#\u0014!\u00057pG\u0006d\u0017\tZ7j]\u001a\u000b7\r^8ssB\u0019a*U*\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013\u0011BR;oGRLwN\u001c\u0019\u0011\u0005QsV\"A+\u000b\u0005Y;\u0016!B1e[&t'B\u0001-Z\u0003\u001d\u0019G.[3oiNT!a\f.\u000b\u0005mc\u0016AB1qC\u000eDWMC\u0001^\u0003\ry'oZ\u0005\u0003?V\u0013Q!\u00113nS:\f!b]3sm\u0016\u0014\u0018J\u001c4p!\t\u0011g-D\u0001d\u0015\t!W-\u0001\u0006bkRDwN]5{KJT!!L-\n\u0005\u001d\u001c'\u0001F!vi\"|'/\u001b>feN+'O^3s\u0013:4w.\u0001\u0004=S:LGO\u0010\u000b\bU.dWN\\8q!\t\u0019\u0004\u0001C\u00037\u000f\u0001\u0007q\u0007C\u0003<\u000f\u0001\u0007A\bC\u0003@\u000f\u0001\u0007\u0001\tC\u0003H\u000f\u0001\u0007\u0001\nC\u0003M\u000f\u0001\u0007Q\nC\u0003a\u000f\u0001\u0007\u0011-A\u0006nSJ\u0014xN\u001d+pa&\u001cGCA:|!\rqEO^\u0005\u0003k>\u0013aa\u00149uS>t\u0007CA<z\u001b\u0005A(BA\"Z\u0013\tQ\bPA\u0006NSJ\u0014xN\u001d+pa&\u001c\u0007\"\u0002?\t\u0001\u0004i\u0018!\u0002;pa&\u001c\u0007c\u0001@\u0002\f9\u0019q0a\u0002\u0011\u0007\u0005\u0005q*\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\tIaT\u0001\u0007!J,G-\u001a4\n\t\u00055\u0011q\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005%q*A\tnSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN$B!!\u0006\u0002(A9\u0011qCA\u000f{\u0006\u0005RBAA\r\u0015\r\tYbT\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0010\u00033\u00111!T1q!\r\u0019\u00141E\u0005\u0004\u0003KQ#!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a\u0005\b\u0003SI\u0001\u0019AA\u0016\u0003%!x\u000e]5dg>\u0003H\u000f\u0005\u0003Oi\u00065\u0002\u0003\u0002@\u00020uLA!!\r\u0002\u0010\t\u00191+\u001a;\u0015\t\u0005U\u0011Q\u0007\u0005\b\u0003oQ\u0001\u0019AA\u001d\u0003\u0019a\u0017N\\6JIB!\u00111HA!\u001b\t\tiDC\u0002\u0002@e\u000baaY8n[>t\u0017\u0002BA\"\u0003{\u0011A!V;jI\u0006\u0011S.\u001b:s_J$v\u000e]5d'R\fG/Z:Ge>lW*\u001a;bI\u0006$\u0018m\u0015;pe\u0016$B!!\u0006\u0002J!9\u00111J\u0006A\u0002\u00055\u0012A\u0002;pa&\u001c7/\u0001\u0012nSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN4%o\\7NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0003+\t\t\u0006C\u0004\u000281\u0001\r!!\u000f\u0015\t\u0005U\u0011Q\u000b\u0005\b\u0003\u0017j\u0001\u0019AA\u0017)\t\t)\"\u0001\u0014nSJ\u0014xN\u001d+pa&\u001c7\u000b^1uKN4%o\\7D_:$(o\u001c7mKJ\u001cuN\u001c;fqR$B!!\u0006\u0002^!9\u0011qG\bA\u0002\u0005eB\u0003BA\u000b\u0003CBq!a\u0013\u0011\u0001\u0004\ti#A\u000bhKR\fE\u000e\u001c+pa&\u001c7/\u00138DYV\u001cH/\u001a:\u0015\u0005\u00055\u0012AG5t)>\u0004\u0018nY)vKV,G-\u00169G_J$U\r\\3uS>tG\u0003BA6\u0003c\u00022ATA7\u0013\r\tyg\u0014\u0002\b\u0005>|G.Z1o\u0011\u0015a8\u00031\u0001~\u0003])gn];sK\u000ecWo\u001d;fe2Kgn[#ySN$8\u000f\u0006\u0003\u0002x\u0005u\u0004c\u0001(\u0002z%\u0019\u00111P(\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003o!\u0002\u0019AA\u001d\u0003E\u0019G.^:uKJd\u0015N\\6Fq&\u001cHo\u001d\u000b\u0005\u0003W\n\u0019\tC\u0004\u00028U\u0001\r!!\u000f\u0002%\u001d,Go\u00117vgR,'\u000fT5oW\u0012\u000bG/\u0019\u000b\u0005\u0003\u0013\u000b9\n\u0005\u0003Oi\u0006-\u0005\u0003BAG\u0003'k!!a$\u000b\u0007\u0005Ee&\u0001\u0002{W&!\u0011QSAH\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0007bBA\u001c-\u0001\u0007\u0011\u0011\b\u000b\u0005\u0003\u0013\u000bY\n\u0003\u0004\u0002\u001e^\u0001\r!`\u0001\tY&t7NT1nK\u0006Ir-\u001a;DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001e\u0004&o\u001c9t)\u0011\t\u0019+a-\u0011\t\u0005\u0015\u0016qV\u0007\u0003\u0003OSA!!+\u0002,\u0006!Q\u000f^5m\u0015\t\ti+\u0001\u0003kCZ\f\u0017\u0002BAY\u0003O\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t9\u0004\u0007a\u0001\u0003s\tAcZ3u\u00072,8\u000f^3s\u0019&t7nQ8oM&<G\u0003BA]\u0003\u007f\u00032aMA^\u0013\r\tiL\u000b\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0007bBA\u001c3\u0001\u0007\u0011\u0011H\u0001\u000fO\u0016$Hk\u001c9jG\u000e{gNZ5h)\u0011\t\u0019+!2\t\u000bqT\u0002\u0019A?\u00027\u0005dG/\u001a:DYV\u001cH/\u001a:MS:\\7i\u001c8gS\u001eTfj\u001c3f)\u0019\t9(a3\u0002N\"9\u0011qG\u000eA\u0002\u0005e\u0002bBAh7\u0001\u0007\u00111U\u0001\u0006aJ|\u0007o]\u0001![\u0006L(-\u001a*fK:\u001c'/\u001f9u\u00072,8\u000f^3s\u0019&t7nQ8oM&<7\u000f\u0006\u0003\u0002x\u0005U\u0007bBAl9\u0001\u0007\u0011\u0011\\\u0001\u0012G>tg-[4Ue\u0006t7OZ8s[\u0016\u0014\bc\u0002(\u0002\\\u0006\r\u0016q\\\u0005\u0004\u0003;|%!\u0003$v]\u000e$\u0018n\u001c82!\u0011qE/a)\u0002-\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7N\u0017(pI\u0016$b!a\u001e\u0002f\u0006%\bbBAt;\u0001\u0007\u00111R\u0001\u0010G2,8\u000f^3s\u0019&t7\u000eR1uC\"9\u0011qZ\u000fA\u0002\u0005\r\u0016aE:fi\u000ecWo\u001d;fe2Kgn\u001b.O_\u0012,G\u0003BA<\u0003_Dq!a:\u001f\u0001\u0004\tY)A\u000bbYR,'/T5se>\u0014Hk\u001c9jGN#\u0018\r^3\u0015\u0015\u0005]\u0014Q_A|\u0003\u007f\u0014\u0019\u0001C\u0003}?\u0001\u0007Q\u0010C\u0004\u0002z~\u0001\r!a?\u0002\u0019M$\u0018\r^3Va\u0012\fG/\u001a:\u0011\u000f9\u000bY.!\t\u0002~B!a\n^A\u0011\u0011\u001d\u0011\ta\ba\u0001\u0003W\nAB^1mS\u0012\fG/Z(oYfD\u0011B!\u0002 !\u0003\u0005\r!a\u001b\u0002\u001f\u0019\f\u0017\u000e\\%g\u001d>$X*\u001b:s_J\fq$\u00197uKJl\u0015N\u001d:peR{\u0007/[2Ti\u0006$X\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YA\u000b\u0003\u0002l\t51F\u0001B\b!\u0011\u0011\tBa\u0007\u000e\u0005\tM!\u0002\u0002B\u000b\u0005/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\teq*\u0001\u0006b]:|G/\u0019;j_:LAA!\b\u0003\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002-\u0011,G.\u001a;f\u00072,8\u000f^3s\u0019&t7N\u0017(pI\u0016$B!a\u001e\u0003$!9\u0011qG\u0011A\u0002\u0005e\u0012\u0001E1mi\u0016\u0014X*\u001b:s_J$v\u000e]5d)\u0019\u0011ICa\u000f\u0003>A1\u00111\bB\u0016\u0005_IAA!\f\u0002>\tY1*\u00194lC\u001a+H/\u001e:f!\u0011\u0011\tDa\u000e\u000e\u0005\tM\"\u0002\u0002B\u001b\u0003W\u000bA\u0001\\1oO&!!\u0011\bB\u001a\u0005\u00111v.\u001b3\t\u000bq\u0014\u0003\u0019A?\t\u000f\t}\"\u00051\u0001\u0002\"\u0005\u0001R.\u001b:s_J$v\u000e]5d'R\fG/Z\u0001\u001cg\u0016tG-\u00117uKJl\u0015N\u001d:peR{\u0007/[2SKF,Xm\u001d;\u0015\r\u0005]$Q\tB7\u0011\u001d\u0011)c\ta\u0001\u0005\u000f\u0002BA!\u0013\u0003h9!!1\nB1\u001d\u0011\u0011iE!\u0018\u000f\t\t=#1\f\b\u0005\u0005#\u0012IF\u0004\u0003\u0003T\t]c\u0002BA\u0001\u0005+J\u0011!X\u0005\u00037rK!a\f.\n\u0007\u0005}\u0012,\u0003\u0003\u0003`\u0005u\u0012aB7fgN\fw-Z\u0005\u0005\u0005G\u0012)'\u0001\u000fBYR,'/T5se>\u0014Hk\u001c9jGN\u0014V-];fgR$\u0015\r^1\u000b\t\t}\u0013QH\u0005\u0005\u0005S\u0012YG\u0001\tBYR,'/T5se>\u0014Hk\u001c9jG*!!1\rB3\u0011\u001d\u0011yg\ta\u0001\u0005c\naA]3tk2$\bC\u0002B:\u0005s\u0012y#\u0004\u0002\u0003v)!!qOA\u001f\u0003%Ig\u000e^3s]\u0006d7/\u0003\u0003\u0003|\tU$aD&bM.\fg)\u001e;ve\u0016LU\u000e\u001d7\u0002%\r\u0014X-\u0019;f\u00072,8\u000f^3s\u0019&t7n\u001d\u000b\u0005\u0005\u0003\u0013I\n\u0005\u0004\u0003\u0004\n%%QR\u0007\u0003\u0005\u000bSAAa\"\u0002(\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\t-%Q\u0011\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003\u0002BH\u0005+k!A!%\u000b\t\tM\u0015QH\u0001\te\u0016\fX/Z:ug&!!q\u0013BI\u0005i\u0019%/Z1uK\u000ecWo\u001d;fe2Kgn[:SKN\u0004xN\\:f\u0011\u001d\u0011Y\n\na\u0001\u0005;\u000bQd\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+\u0017/^3ti\u0012\u000bG/\u0019\t\u0005\u0005?\u0013\t+\u0004\u0002\u0003f%!!1\u0015B3\u0005u\u0019%/Z1uK\u000ecWo\u001d;fe2Kgn[:SKF,Xm\u001d;ECR\f\u0017aF4fi\u0006cG\u000eT5oWN4%o\\7NKR\fG-\u0019;b)\t\u0011I\u000b\u0005\u0004\u0003,\nU\u00161\u0012\b\u0005\u0005[\u0013\tL\u0004\u0003\u0002\u0002\t=\u0016\"\u0001)\n\u0007\tMv*A\u0004qC\u000e\\\u0017mZ3\n\t\t]&\u0011\u0018\u0002\u0004'\u0016\f(b\u0001BZ\u001f\u0006y1\u000f^8q\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0004\u0003*\t}&\u0011\u0019\u0005\u0006y\u001a\u0002\r! \u0005\b\u0005\u00074\u0003\u0019\u0001Bc\u00035awnZ#oI>3gm]3ugB1!1\u0016B[\u0005\u000f\u00042A\u0014Be\u0013\r\u0011Ym\u0014\u0002\u0005\u0019>tw-\u0001\rjg2Kgn[\"p_J$\u0017N\\1u_J,e.\u00192mK\u0012,\"!a\u001b\u0002'M,\b/\u001a:%[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\tU\u0007c\u0001\u001d\u0003X&\u0019!\u0011\u001c\u0017\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0001")
public class ClusterLinkMetadataManagerWithKRaftSupport
extends ClusterLinkMetadataManager {
    private final Function0<Admin> localAdminFactory;

    private /* synthetic */ MetadataCache super$metadataCache() {
        return super.metadataCache();
    }

    @Override
    public Option<MirrorTopic> mirrorTopic(String topic) {
        return Option$.MODULE$.apply((Object)((KRaftMetadataCache)super.metadataCache()).currentImage().topics().getTopic(topic)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.mirrorTopic())));
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Option<Set<String>> topicsOpt) {
        Set set;
        MetadataImage image = ((KRaftMetadataCache)super.metadataCache()).currentImage();
        if (topicsOpt instanceof Some) {
            set = (Set)((Set)((Some)topicsOpt).value()).map((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.apply((Object)image.topics().getTopic(topic)).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$2.mirrorTopic()))), Set$.MODULE$.canBuildFrom());
        } else if (None$.MODULE$.equals(topicsOpt)) {
            set = ((TraversableOnce)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)image.topics().topicsByName()).asScala()).values().map((Function1 & Serializable & scala.Serializable)x$3 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$3.mirrorTopic())), Iterable$.MODULE$.canBuildFrom())).toSet();
        } else {
            throw new MatchError(topicsOpt);
        }
        return ((TraversableOnce)((SetLike)set.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isDefined()))).map((Function1 & Serializable & scala.Serializable)stateOpt -> {
            MirrorTopic state = (MirrorTopic)stateOpt.get();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.topicName()), (Object)ClusterLinkTopicState$.MODULE$.apply(state));
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, ClusterLinkTopicState> mirrorTopicStates(Uuid linkId) {
        ImmutableMap mirrorTopics = ((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByLinkId(linkId);
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)mirrorTopics).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$mirrorTopicStates$6(x$5)))).map((Function1 & Serializable & scala.Serializable)entry -> {
            ClusterLinkTopicState state = ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)((TopicImage)entry._2()).mirrorTopic().get());
            return new Tuple2((Object)((TopicImage)entry._2()).name(), (Object)state);
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataStore(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromMetadataCache() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Uuid linkId) {
        return this.mirrorTopicStates(linkId);
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext(Set<String> topics) {
        return this.mirrorTopicStates((Option<Set<String>>)new Some(topics));
    }

    @Override
    public Map<String, ClusterLinkTopicState> mirrorTopicStatesFromControllerContext() {
        return this.mirrorTopicStates((Option<Set<String>>)None$.MODULE$);
    }

    @Override
    public Set<String> getAllTopicsInCluster() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(((KRaftMetadataCache)super.metadataCache()).currentImage().topics().topicsByName().keySet()).asScala()).toSet();
    }

    @Override
    public boolean isTopicQueuedUpForDeletion(String topic) {
        return false;
    }

    @Override
    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    @Override
    public boolean clusterLinkExists(Uuid linkId) {
        return ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById().containsKey(linkId);
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(Uuid linkId) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById();
        if (clusterLinks.containsKey(linkId)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkId);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), linkId, (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<ClusterLinkData> getClusterLinkData(String linkName) {
        java.util.Map clusterLinks = ((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksByName();
        if (clusterLinks.containsKey(linkName)) {
            ClusterLink clusterLink = (ClusterLink)clusterLinks.get(linkName);
            return new Some((Object)new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false));
        }
        return None$.MODULE$;
    }

    @Override
    public Properties getClusterLinkConfigProps(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString()));
    }

    @Override
    public ClusterLinkConfig getClusterLinkConfig(Uuid linkId) {
        return ClusterLinkConfig$.MODULE$.create(this.getClusterLinkConfigProps(linkId), false);
    }

    @Override
    public Properties getTopicConfig(String topic) {
        return ((KRaftMetadataCache)super.metadataCache()).config(new ConfigResource(ConfigResource.Type.TOPIC, topic));
    }

    @Override
    public void alterClusterLinkConfigZNode(Uuid linkId, Properties props) {
        throw new IllegalStateException("Altering link configs in the ZNode is not supported in KRaft mode.");
    }

    @Override
    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        scala.collection.mutable.Map clusterLinks = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala();
        HashMap alterConfigRequestMap = new HashMap(clusterLinks.size());
        clusterLinks.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var4_13;
            if (x0$1 == null) throw new MatchError(null);
            Uuid linkId = (Uuid)x0$1._1();
            ClusterLink clusterLink = (ClusterLink)x0$1._2();
            ConfigResource configResourceLinkId = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkId.toString());
            Option newEncodedProps = (Option)configTransformer.apply((Object)((KRaftMetadataCache)this.super$metadataCache()).config(configResourceLinkId));
            if (newEncodedProps instanceof Some) {
                Properties props = (Properties)((Some)newEncodedProps).value();
                HashSet newConfigs = new HashSet();
                ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new AlterConfigOp(new ConfigEntry((String)entry._1(), (String)entry._2()), AlterConfigOp.OpType.SET))));
                ConfigResource configResourceLinkName = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, clusterLink.linkName());
                HashSet hashSet = alterConfigRequestMap.put(configResourceLinkName, newConfigs);
                return var4_13;
            } else {
                if (!None$.MODULE$.equals(newEncodedProps)) throw new MatchError((Object)newEncodedProps);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return var4_13;
        });
        if (!alterConfigRequestMap.isEmpty()) {
            if (this.destAdmin() == null) {
                this.destAdmin_$eq((Admin)this.localAdminFactory.apply());
            }
            this.destAdmin().incrementalAlterConfigs(alterConfigRequestMap).all().get();
        }
    }

    @Override
    public void createClusterLinkZNode(ClusterLinkData clusterLinkData, Properties props) {
        throw new IllegalStateException("Creating a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void setClusterLinkZNode(ClusterLinkData clusterLinkData) {
        throw new IllegalStateException("Setting a cluster link ZNode is not supported in KRaft mode.");
    }

    @Override
    public void alterMirrorTopicState(String topic, Function1<ClusterLinkTopicState, Option<ClusterLinkTopicState>> stateUpdater, boolean validateOnly, boolean failIfNotMirror) {
        Option currentState = this.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (currentState.isEmpty() && failIfNotMirror) {
            throw new InvalidRequestException(new StringBuilder(28).append("Topic ").append(topic).append(" is not a mirror topic").toString());
        }
        currentState.foreach((Function1 & Serializable & scala.Serializable)state -> {
            ((Option)stateUpdater.apply(state)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable & scala.Serializable)newState -> {
                if (!validateOnly) {
                    try {
                        return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState).get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void deleteClusterLinkZNode(Uuid linkId) {
        throw new IllegalStateException("Deleting a cluster link ZNode is not supported in KRaft mode.");
    }

    private KafkaFuture<Void> alterMirrorTopic(String topic, ClusterLinkTopicState mirrorTopicState) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic);
        KafkaFutureImpl result = new KafkaFutureImpl();
        if (mirrorTopicState instanceof ClusterLinkTopicState.Mirror) {
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.MIRROR.stateName());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PausedMirror) {
            ClusterLinkTopicState.PausedMirror pausedMirror = (ClusterLinkTopicState.PausedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PAUSED.stateName()).setLinkLevelPause(pausedMirror.linkLevel()).setTopicLevelPause(pausedMirror.topicLevel()).setMirrorTopicError(pausedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.FailedMirror) {
            ClusterLinkTopicState.FailedMirror failedMirror = (ClusterLinkTopicState.FailedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.FAILED.stateName()).setMirrorTopicError(failedMirror.mirrorTopicError().code());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.PendingStoppedMirror) {
            ClusterLinkTopicState.PendingStoppedMirror pendingStoppedMirror = (ClusterLinkTopicState.PendingStoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.PENDING_STOPPED.stateName()).setPromoted(pendingStoppedMirror.synchronize());
        } else if (mirrorTopicState instanceof ClusterLinkTopicState.StoppedMirror) {
            ClusterLinkTopicState.StoppedMirror stoppedMirror = (ClusterLinkTopicState.StoppedMirror)mirrorTopicState;
            alterMirrorTopic.setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)stoppedMirror.logEndOffsets().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
        } else {
            if (mirrorTopicState instanceof ClusterLinkTopicState.PendingMirror) {
                throw new UnsupportedVersionException("Cannot convert to a PendingMirror");
            }
            if (mirrorTopicState instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
                throw new UnsupportedVersionException("Cannot convert to a PendingSynchronizeMirror");
            }
            throw new MatchError((Object)mirrorTopicState);
        }
        alterMirrorTopic.setMirrorStartOffsets((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)mirrorTopicState.mirrorStartOffsets().map((Function1 & Serializable & scala.Serializable)x -> ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopic$2(BoxesRunTime.unboxToLong((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava());
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean alterMirrorTopicState$default$4() {
        return true;
    }

    private void sendAlterMirrorTopicRequest(AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic, KafkaFutureImpl<Void> result) {
        AlterMirrorTopicsRequest.Builder builder = new AlterMirrorTopicsRequest.Builder(alterMirrorTopic, false, this.requestTimeoutMs());
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, alterMirrorTopic, result){
            private final AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic$1;
            private final KafkaFutureImpl result$1;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent($anon$1.$anonfun$handleResponse$1()));
                }
                ((AlterMirrorTopicsResponse)response).complete(Collections.singletonMap(this.alterMirrorTopic$1.topic(), this.result$1));
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent($anon$1.$anonfun$onFailure$1()), $anon$1.$anonfun$onFailure$2(ex));
                }
                this.result$1.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$1() {
                return "Received response for alterMirrorTopicRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$1() {
                return "alterMirrorTopic request failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$2(Throwable ex$1) {
                return ex$1;
            }
            {
                this.alterMirrorTopic$1 = alterMirrorTopic$1;
                this.result$1 = result$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleResponse$1(), $anonfun$onFailure$1(), $anonfun$onFailure$2(java.lang.Throwable )}, serializedLambda);
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)builder, requestHandler);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<CreateClusterLinksResponse> createClusterLinks(CreateClusterLinksRequestData createClusterLinksRequestData) {
        void var2_2;
        CompletableFuture result = new CompletableFuture();
        CreateClusterLinksRequest.Builder requestBuilder = new CreateClusterLinksRequest.Builder(createClusterLinksRequestData);
        ClusterLinkControllerRequestCompletionHandler requestHandler = new ClusterLinkControllerRequestCompletionHandler(null, result){
            private final CompletableFuture result$2;

            public void handleResponse(AbstractResponse response) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent($anon$2.$anonfun$handleResponse$2()));
                }
                this.result$2.complete((CreateClusterLinksResponse)response);
            }

            public void onFailure(Throwable ex) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(this.msgWithLogIdent($anon$2.$anonfun$onFailure$3()), $anon$2.$anonfun$onFailure$4(ex));
                }
                this.result$2.completeExceptionally(ex);
            }

            public static final /* synthetic */ String $anonfun$handleResponse$2() {
                return "Received response for createClusterLinksRequest";
            }

            public static final /* synthetic */ String $anonfun$onFailure$3() {
                return "createClusterLinksRequest failed with exception";
            }

            public static final /* synthetic */ Throwable $anonfun$onFailure$4(Throwable ex$2) {
                return ex$2;
            }
            {
                this.result$2 = result$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleResponse$2(), $anonfun$onFailure$3(), $anonfun$onFailure$4(java.lang.Throwable )}, serializedLambda);
            }
        };
        super.controllerChannelManager().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder, requestHandler);
        return var2_2;
    }

    @Override
    public Seq<ClusterLinkData> getAllLinksFromMetadata() {
        return ((TraversableOnce)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(((KRaftMetadataCache)super.metadataCache()).currentImage().clusterLinks().linksById()).asScala()).values().map((Function1 & Serializable & scala.Serializable)clusterLink -> new ClusterLinkData(clusterLink.linkName(), clusterLink.linkId(), (Option<String>)new Some((Object)clusterLink.remoteClusterId()), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(clusterLink.tenantPrefix())), false), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @Override
    public KafkaFuture<Void> stopMirrorTopic(String topic, Seq<Object> logEndOffsets) {
        AlterMirrorTopicsRequestData.AlterMirrorTopic alterMirrorTopic = new AlterMirrorTopicsRequestData.AlterMirrorTopic().setTopic(topic).setMirrorTopicState(MirrorTopic.State.STOPPED.stateName()).setStoppedLogEndOffsets((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)logEndOffsets.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToLong((Object)x$1), Seq$.MODULE$.canBuildFrom())).asJava());
        KafkaFutureImpl result = new KafkaFutureImpl();
        this.sendAlterMirrorTopicRequest(alterMirrorTopic, (KafkaFutureImpl<Void>)result);
        return result;
    }

    @Override
    public boolean isLinkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$mirrorTopicStates$6(Tuple2 x$5) {
        return ((TopicImage)x$5._2()).mirrorTopic().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$alterMirrorTopicState$2(ClusterLinkTopicState x$6) {
        return x$6 != null;
    }

    public static final /* synthetic */ void $anonfun$alterMirrorTopicState$1(ClusterLinkMetadataManagerWithKRaftSupport $this, Function1 stateUpdater$1, boolean validateOnly$1, String topic$1, ClusterLinkTopicState state) {
        ((Option)stateUpdater$1.apply((Object)state)).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkMetadataManagerWithKRaftSupport.$anonfun$alterMirrorTopicState$2(x$6))).foreach((Function1 & Serializable & scala.Serializable)newState -> {
            if (!validateOnly) {
                try {
                    return this.alterMirrorTopic(topic, (ClusterLinkTopicState)newState).get();
                }
                catch (ExecutionException executionException) {
                    throw executionException.getCause();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Long $anonfun$alterMirrorTopic$2(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public ClusterLinkMetadataManagerWithKRaftSupport(KafkaConfig brokerConfig, ClusterLinkScheduler scheduler, KRaftMetadataCache metadataCache, BrokerToControllerChannelManager controllerChannelManager, Function0<Admin> localAdminFactory, AuthorizerServerInfo serverInfo) {
        this.localAdminFactory = localAdminFactory;
        super(brokerConfig, scheduler, metadataCache, controllerChannelManager, localAdminFactory, serverInfo);
    }
}

