/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkType;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class ClusterLinkMetrics$ {
    public static ClusterLinkMetrics$ MODULE$;
    private final String metricsGroup;

    static {
        new ClusterLinkMetrics$();
    }

    public String metricsGroup() {
        return this.metricsGroup;
    }

    public String throttleTimeSensorName(String linkName) {
        return new StringBuilder(29).append("linked-fetcher-throttle-time-").append(linkName).toString();
    }

    public String unavailabilitySensorName(String linkName) {
        return new StringBuilder(17).append("link-unavailable-").append(linkName).toString();
    }

    public String kafka$server$link$ClusterLinkMetrics$$linkCountDescription(ClusterLinkConfig.LinkMode linkMode) {
        String string;
        if (ClusterLinkConfig.LinkMode.DESTINATION.equals(linkMode)) {
            string = "Number of destination links for this cluster.";
        } else if (ClusterLinkConfig.LinkMode.SOURCE.equals(linkMode)) {
            string = "Number of source links for this cluster.";
        } else if (ClusterLinkConfig.LinkMode.BIDIRECTIONAL.equals(linkMode)) {
            string = "Number of bidirectional links for this cluster.";
        } else {
            throw new IllegalArgumentException(new StringBuilder(30).append("Unsupported cluster link mode ").append(linkMode).toString());
        }
        return string;
    }

    public String kafka$server$link$ClusterLinkMetrics$$controllerReverseConnectionDescription(ConnectionMode connectionMode) {
        String string;
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode)) {
            string = "Number of persistent reverse connections for this link from the remote cluster to this broker.";
        } else if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode)) {
            string = "Number of persistent reverse connections for this link from this broker to the remote link coordinator.";
        } else {
            throw new IllegalArgumentException(new StringBuilder(41).append("Unsupported cluster link connection mode ").append(connectionMode).toString());
        }
        return string;
    }

    public String kafka$server$link$ClusterLinkMetrics$$reverseConnectionDescription(ConnectionMode connectionMode) {
        String string;
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode)) {
            string = "Total number of reverse connections for this link from remote brokers to this broker.";
        } else if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode)) {
            string = "Total number of reverse connections for this link from this broker to remote brokers.";
        } else {
            throw new IllegalArgumentException(new StringBuilder(28).append("Unsupported connection mode ").append(connectionMode).toString());
        }
        return string;
    }

    public Map<String, String> linkModeTag(ClusterLinkConfig.LinkMode linkMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)linkMode.lowerCaseName())}));
    }

    public Map<String, String> linkTypeTag(LinkType linkType) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployed-link-type"), (Object)linkType.lowerCaseName())}));
    }

    public Map<String, String> connectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection-mode"), (Object)connectionMode.lowerCaseName())}));
    }

    public Map<String, String> stateTag(String state) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)state)}));
    }

    public Map<String, String> reasonTag(String reason) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason)}));
    }

    private ClusterLinkMetrics$() {
        MODULE$ = this;
        this.metricsGroup = "cluster-link-metrics";
    }
}

