/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import java.util.Collections;
import java.util.Set;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkCCloudToCCloudChannelBuilder;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0010!\u0001\u001dB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A1\n\u0001B\u0001B\u0003%A\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001B\u001e\u0001\u0003\u0002\u0003\u0006Ia\u001e\u0005\ty\u0002\u0011)\u0019!C\u0001{\"Aa\u0010\u0001B\u0001B\u0003%A\n\u0003\u0005\u0000\u0001\t\u0005\t\u0015!\u0003M\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011%\t)\u0003\u0001b\u0001\n\u0013\t9\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0015\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004\u0003\u0005\u0002B\u0001\u0001\u000b\u0011BA\u001b\u0011%\t\u0019\u0005\u0001b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA$\u0011%\ty\u0005\u0001b\u0001\n\u0003\t\t\u0006\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA*\u0011\u001d\tY\u0006\u0001C\u0005\u0003;B\u0001\"a\u0018\u0001\t\u0003\u0001\u0013\u0011\r\u0005\b\u0003S\u0002A\u0011IA6\u0011\u001d\tI\n\u0001C!\u00037Cq!a)\u0001\t\u0003\n)\u000bC\u0004\u00024\u0002!\t%!.\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011\u0011\u001a\u0001\u0005\u0002\u0005\u001d\u0007bBAf\u0001\u0011E\u0011Q\u001a\u0002\u0019\u00072,8\u000f^3s\u0019&t7NT3uo>\u00148n\u00117jK:$(BA\u0011#\u0003\u0011a\u0017N\\6\u000b\u0005\r\"\u0013AB:feZ,'OC\u0001&\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u00151wA\u0011\u0011FL\u0007\u0002U)\u00111\u0006L\u0001\u0005Y\u0006twMC\u0001.\u0003\u0011Q\u0017M^1\n\u0005=R#AB(cU\u0016\u001cG\u000f\u0005\u00022s5\t!G\u0003\u00024i\u000511m\\7n_:T!!J\u001b\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0005\u0003uI\u0012aBU3d_:4\u0017nZ;sC\ndW\r\u0005\u0002=\u007f5\tQH\u0003\u0002?I\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u00031\u0011'o\\6fe\u000e{gNZ5h!\t\u0019E)D\u0001#\u0013\t)%EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!E2mkN$XM\u001d'j].\u001cuN\u001c4jOB\u0011\u0001*S\u0007\u0002A%\u0011!\n\t\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0017A\u0006;ie>$H\u000f\\3US6,7+\u001a8t_Jt\u0015-\\3\u0011\u000553fB\u0001(U!\ty%+D\u0001Q\u0015\t\tf%\u0001\u0004=e>|GO\u0010\u0006\u0002'\u0006)1oY1mC&\u0011QKU\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V%\u0006AQ.\u001a;bI\u0006$\u0018\rE\u0002\\9zk\u0011AU\u0005\u0003;J\u0013aa\u00149uS>t\u0007C\u0001%`\u0013\t\u0001\u0007EA\nDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-A\bnKR\fG-\u0019;b+B$\u0017\r^3s!\rYFl\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003MR\nqa\u00197jK:$8/\u0003\u0002iK\nyQ*\u001a;bI\u0006$\u0018-\u00169eCR,'/A\u0004nKR\u0014\u0018nY:\u0011\u0005-lW\"\u00017\u000b\u0005%\u0014\u0014B\u00018m\u0005\u001diU\r\u001e:jGN\f!\"\\3ue&\u001cG+Y4t!\u0011\tH\u000f\u0014'\u000e\u0003IT!a\u001d*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002ve\n\u0019Q*\u00199\u0002\tQLW.\u001a\t\u0003qjl\u0011!\u001f\u0006\u0003}IJ!a_=\u0003\tQKW.Z\u0001\tG2LWM\u001c;JIV\tA*A\u0005dY&,g\u000e^%eA\u0005Q1\r\\5f]R$\u0016\u0010]3\u0002\u00151|wmQ8oi\u0016DH\u000fE\u0002y\u0003\u000bI1!a\u0002z\u0005)aunZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u00151\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019\u0003\u0005\u0002I\u0001!)\u0011)\u0004a\u0001\u0005\")a)\u0004a\u0001\u000f\")1*\u0004a\u0001\u0019\")\u0011,\u0004a\u00015\")\u0011-\u0004a\u0001E\")\u0011.\u0004a\u0001U\")q.\u0004a\u0001a\")a/\u0004a\u0001o\")A0\u0004a\u0001\u0019\")q0\u0004a\u0001\u0019\"9\u0011\u0011A\u0007A\u0002\u0005\r\u0011A\u0005;ie>$H\u000f\\3US6,7+\u001a8t_J,\"!!\u000b\u0011\u0007-\fY#C\u0002\u0002.1\u0014aaU3og>\u0014\u0018a\u0005;ie>$H\u000f\\3US6,7+\u001a8t_J\u0004\u0013AD2iC:tW\r\u001c\"vS2$WM]\u000b\u0003\u0003k\u0001B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003w\u0011\u0014a\u00028fi^|'o[\u0005\u0005\u0003\u007f\tID\u0001\bDQ\u0006tg.\u001a7Ck&dG-\u001a:\u0002\u001f\rD\u0017M\u001c8fY\n+\u0018\u000e\u001c3fe\u0002\n\u0001b]3mK\u000e$xN]\u000b\u0003\u0003\u000f\u0002B!a\u000e\u0002J%!\u00111JA\u001d\u0005!\u0019V\r\\3di>\u0014\u0018!C:fY\u0016\u001cGo\u001c:!\u00035qW\r^<pe.\u001cE.[3oiV\u0011\u00111\u000b\t\u0004I\u0006U\u0013bAA,K\nY1*\u00194lC\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\nAc\u0019:fCR,7\t[1o]\u0016d')^5mI\u0016\u0014HCAA\u001b\u0003II7o\u00117pk\u0012$vn\u00117pk\u0012d\u0015N\\6\u0015\u0005\u0005\r\u0004cA.\u0002f%\u0019\u0011q\r*\u0003\u000f\t{w\u000e\\3b]\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\u0005\u0003[\n\u0019\bE\u0002\\\u0003_J1!!\u001dS\u0005\u0011)f.\u001b;\t\u000f\u0005U\u0004\u00041\u0001\u0002x\u000591m\u001c8gS\u001e\u001c\b\u0007BA=\u0003\u000f\u0003r!a\u001f\u0002\u00022\u000b\u0019)\u0004\u0002\u0002~)\u0019\u0011q\u0010\u0017\u0002\tU$\u0018\u000e\\\u0005\u0004k\u0006u\u0004\u0003BAC\u0003\u000fc\u0001\u0001\u0002\u0007\u0002\n\u0006M\u0014\u0011!A\u0001\u0006\u0003\tYIA\u0002`IE\nB!!$\u0002\u0014B\u00191,a$\n\u0007\u0005E%KA\u0004O_RD\u0017N\\4\u0011\u0007m\u000b)*C\u0002\u0002\u0018J\u00131!\u00118z\u0003U\u0011XmY8oM&<WO]1cY\u0016\u001cuN\u001c4jON$\"!!(\u0011\u000b\u0005m\u0014q\u0014'\n\t\u0005\u0005\u0016Q\u0010\u0002\u0004'\u0016$\u0018a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\u0011\ti'a*\t\u000f\u0005U$\u00041\u0001\u0002*B\"\u00111VAX!\u001d\tY(!!M\u0003[\u0003B!!\"\u00020\u0012a\u0011\u0011WAT\u0003\u0003\u0005\tQ!\u0001\u0002\f\n\u0019q\f\n\u001a\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u000b\u0005\u0003[\n9\fC\u0004\u0002:n\u0001\r!a/\u0002\u00159,woQ8oM&<7\u000f\r\u0003\u0002>\u0006\u0005\u0007cBA>\u0003\u0003c\u0015q\u0018\t\u0005\u0003\u000b\u000b\t\r\u0002\u0007\u0002D\u0006]\u0016\u0011!A\u0001\u0006\u0003\tYIA\u0002`IM\nQ\"\u001b8ji&\fG/Z\"m_N,GCAA7\u0003\u0015\u0019Gn\\:f\u0003M\u0019'/Z1uK:+Go^8sW\u000ec\u0017.\u001a8u)\u0011\t\u0019&a4\t\u000f\u0005\rc\u00041\u0001\u0002H\u0001")
public class ClusterLinkNetworkClient
implements Reconfigurable,
Logging {
    private final KafkaConfig brokerConfig;
    private final ClusterLinkConfig clusterLinkConfig;
    private final Option<ClusterLinkMetadata> metadata;
    private final Option<MetadataUpdater> metadataUpdater;
    private final Time time;
    private final String clientId;
    private final LogContext logContext;
    private final Sensor throttleTimeSensor;
    private final ChannelBuilder channelBuilder;
    private final Selector selector;
    private final KafkaClient networkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String clientId() {
        return this.clientId;
    }

    private Sensor throttleTimeSensor() {
        return this.throttleTimeSensor;
    }

    private ChannelBuilder channelBuilder() {
        return this.channelBuilder;
    }

    private Selector selector() {
        return this.selector;
    }

    public KafkaClient networkClient() {
        return this.networkClient;
    }

    private ChannelBuilder createChannelBuilder() {
        ChannelBuilder channelBuilder;
        boolean bl = this.isCloudToCloudLink();
        if (bl) {
            channelBuilder = new ClusterLinkCCloudToCCloudChannelBuilder(this.brokerConfig, this.clusterLinkConfig).clientChannelBuilder(this.time, this.logContext);
        } else if (!bl) {
            channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)this.clusterLinkConfig.securityProtocol(), (JaasContext.Type)JaasContext.Type.CLIENT, (AbstractConfig)this.clusterLinkConfig, null, (String)this.clusterLinkConfig.saslMechanism(), (Time)this.time, (boolean)true, (LogContext)this.logContext);
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return channelBuilder;
    }

    public boolean isCloudToCloudLink() {
        return !this.brokerConfig.trafficNetworkId().isEmpty() && ClusterLinkUtils$.MODULE$.isOutboundBootstrapCCloudHost(this.brokerConfig, this.clusterLinkConfig);
    }

    public void configure(java.util.Map<String, ?> configs) {
    }

    public Set<String> reconfigurableConfigs() {
        ChannelBuilder channelBuilder = this.channelBuilder();
        Set set = channelBuilder instanceof Reconfigurable ? ((Reconfigurable)channelBuilder).reconfigurableConfigs() : Collections.emptySet();
        return set;
    }

    public void validateReconfiguration(java.util.Map<String, ?> configs) {
        ChannelBuilder channelBuilder = this.channelBuilder();
        if (channelBuilder instanceof Reconfigurable) {
            ((Reconfigurable)channelBuilder).validateReconfiguration(configs);
            return;
        }
    }

    public void reconfigure(java.util.Map<String, ?> newConfigs) {
        ChannelBuilder channelBuilder = this.channelBuilder();
        if (channelBuilder instanceof Reconfigurable) {
            ((Reconfigurable)channelBuilder).reconfigure(newConfigs);
            return;
        }
    }

    public void initiateClose() {
        this.networkClient().initiateClose();
    }

    public void close() {
        this.networkClient().close();
    }

    public KafkaClient createNetworkClient(Selector selector) {
        return new NetworkClient((MetadataUpdater)this.metadataUpdater.orNull(Predef$.MODULE$.$conforms()), (Metadata)this.metadata.orNull(Predef$.MODULE$.$conforms()), (Selectable)selector, this.clientId(), 1, Predef$.MODULE$.Long2long(this.clusterLinkConfig.reconnectBackoffMs()), Predef$.MODULE$.Long2long(this.clusterLinkConfig.reconnectBackoffMaxMs()), -1, Predef$.MODULE$.Integer2int(this.clusterLinkConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig.requestTimeoutMs()), this.clusterLinkConfig.connectionSetupTimeoutMs(), this.clusterLinkConfig.connectionSetupTimeoutMaxMs(), this.time, true, new ApiVersions(), this.throttleTimeSensor(), this.logContext);
    }

    public ClusterLinkNetworkClient(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig, String throttleTimeSensorName, Option<ClusterLinkMetadata> metadata, Option<MetadataUpdater> metadataUpdater, Metrics metrics, Map<String, String> metricTags, Time time, String clientId, String clientType, LogContext logContext) {
        this.brokerConfig = brokerConfig;
        this.clusterLinkConfig = clusterLinkConfig;
        this.metadata = metadata;
        this.metadataUpdater = metadataUpdater;
        this.time = time;
        this.clientId = clientId;
        this.logContext = logContext;
        Logging.$init$(this);
        this.throttleTimeSensor = metrics.sensor(throttleTimeSensorName);
        this.channelBuilder = this.createChannelBuilder();
        this.selector = new Selector(-1, Predef$.MODULE$.Long2long(clusterLinkConfig.connectionsMaxIdleMs()), metrics, time, new StringBuilder(13).append("cluster-link-").append(clientType).toString(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(metricTags).asJava(), false, this.channelBuilder(), logContext);
        this.networkClient = this.createNetworkClient(this.selector());
    }
}

