/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.RemoteNetworkClient;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u001e=\u0001\rC\u0011B\u0015\u0001\u0003\u0002\u0003\u0006IaU-\t\u0011i\u0003!\u0011!Q\u0001\nmC\u0011B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u00187\t\u00115\u0004!\u0011!Q\u0001\n9D\u0001\" \u0001\u0003\u0002\u0003\u0006IA \u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001BCA\u0006\u0001\t\u0005\t\u0015!\u0003\u0002\u000e!Q\u0011\u0011\u0004\u0001\u0003\u0002\u0003\u0006I!a\u0007\t\u0015\u0005\r\u0002A!A!\u0002\u0013\t)\u0003\u0003\u0006\u00024\u0001\u0011\t\u0011)A\u0005\u0003kA!\"!\u0012\u0001\u0005\u0003\u0005\u000b\u0011BA$\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fB\u0011\"!\u001b\u0001\u0005\u0004%I!a\u001b\t\u0011\u0005u\u0004\u0001)A\u0005\u0003[B\u0011\"a \u0001\u0005\u0004%I!!!\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003\u0007C\u0011\"!*\u0001\u0005\u0004%I!!!\t\u0011\u0005\u001d\u0006\u0001)A\u0005\u0003\u0007C1\"!+\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002,\"Y\u0011Q\u0017\u0001A\u0002\u0003\u0007I\u0011BA\\\u0011-\t\u0019\r\u0001a\u0001\u0002\u0003\u0006K!!,\t\u0017\u00055\u0007\u00011AA\u0002\u0013%\u0011q\u001a\u0005\f\u0003/\u0004\u0001\u0019!a\u0001\n\u0013\tI\u000eC\u0006\u0002^\u0002\u0001\r\u0011!Q!\n\u0005E\u0007bCAq\u0001\u0001\u0007\t\u0019!C\u0005\u0003GD1\"!=\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002t\"Y\u0011q\u001f\u0001A\u0002\u0003\u0005\u000b\u0015BAs\u0011%\tY\u0010\u0001a\u0001\n\u0013\ti\u0010C\u0005\u0003\b\u0001\u0001\r\u0011\"\u0003\u0003\n!A!Q\u0002\u0001!B\u0013\ty\u0010C\u0004\u0003\u0012\u0001!\tEa\u0005\t\u0011\tU\u0001\u0001\"\u0011=\u0005/AqA!\f\u0001\t\u0003\u0012\u0019\u0002C\u0004\u00030\u0001!\tE!\r\t\u000f\t5\u0003\u0001\"\u0011\u0003P!9!\u0011\u0012\u0001\u0005B\t-\u0005b\u0002BQ\u0001\u0011%!1\u0015\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011\u001d\u0011I\u000e\u0001C\u0005\u00057DqAa9\u0001\t\u0003\u0012)\u000fC\u0004\u0003r\u0002!\tEa=\t\u000f\te\b\u0001\"\u0011\u0003\u0014!9!1 \u0001\u0005\n\tM\u0001b\u0002B\u007f\u0001\u0011E#1\u0003\u0005\b\u0005\u007f\u0004A\u0011\u000bB\n\u0011!\u0019\t\u0001\u0001C\u0001y\r\r\u0001\u0002CB\u0003\u0001\u0011\u0005Aha\u0002\t\u000f\r%\u0001\u0001\"\u0003\u0004\f!91\u0011\u0003\u0001\u0005\n\rM\u0001bBB\u000e\u0001\u0011%!1\u0003\u0005\b\u00077\u0001A\u0011BB\u000f\u0011\u001d\u0019\t\u0003\u0001C\u0005\u0005'Aqaa\t\u0001\t\u0013\u0011\u0019\u0002C\u0004\u0004&\u0001!IAa\u0005\t\u000f\r\u001d\u0002\u0001\"\u0003\u0004*!91q\b\u0001\u0005\u0012\r\u0005\u0003bBB$\u0001\u0011\u00053\u0011\n\u0005\b\u0007\u0017\u0002A\u0011IB%\u0005\u0011\u001aE.^:uKJd\u0015N\\6PkR\u0014w.\u001e8e\u0007>tg.Z2uS>tW*\u00198bO\u0016\u0014(BA\u001f?\u0003\u0011a\u0017N\\6\u000b\u0005}\u0002\u0015AB:feZ,'OC\u0001B\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001#I\u001fB\u0011QIR\u0007\u0002y%\u0011q\t\u0010\u0002\u001d\u00072,8\u000f^3s\u0019&t7nQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s!\tIEJ\u0004\u0002F\u0015&\u00111\nP\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002N\u001d\nIr*\u001e;c_VtGmQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0015\tYE\b\u0005\u0002F!&\u0011\u0011\u000b\u0010\u0002\u0014\u0007>|'\u000fZ5oCR|'\u000fT5ti\u0016tWM]\u0001\tY&t7\u000eR1uCB\u0011AkV\u0007\u0002+*\u0011a\u000bQ\u0001\u0003u.L!\u0001W+\u0003\u001f\rcWo\u001d;fe2Kgn\u001b#bi\u0006L!A\u0015$\u0002\u001b%t\u0017\u000e^5bY\u000e{gNZ5h!\t)E,\u0003\u0002^y\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002'1|7-\u00197M_\u001eL7-\u00197DYV\u001cH/\u001a:\u0011\u0005\u0001LgBA1h!\t\u0011W-D\u0001d\u0015\t!')\u0001\u0004=e>|GO\u0010\u0006\u0002M\u0006)1oY1mC&\u0011\u0001.Z\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002iK&\u0011aLR\u0001\u0012G2LWM\u001c;J]R,'oY3qi>\u0014\bcA8qe6\tQ-\u0003\u0002rK\n1q\n\u001d;j_:\u0004\"a]>\u000e\u0003QT!!\u001e<\u0002\u000f\rd\u0017.\u001a8ug*\u0011\u0011i\u001e\u0006\u0003qf\fa!\u00199bG\",'\"\u0001>\u0002\u0007=\u0014x-\u0003\u0002}i\n\t2\t\\5f]RLe\u000e^3sG\u0016\u0004Ho\u001c:\u0002\u000f5,GO]5dgB\u0011Qi`\u0005\u0004\u0003\u0003a$AE\"mkN$XM\u001d'j].lU\r\u001e:jGN\fq\"\\3uC\u0012\fG/Y'b]\u0006<WM\u001d\t\u0004\u000b\u0006\u001d\u0011bAA\u0005y\tQ2\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006a1o\\2lKR\u001cVM\u001d<feB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014\u0001\u000bqA\\3uo>\u00148.\u0003\u0003\u0002\u0018\u0005E!\u0001D*pG.,GoU3sm\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007\u0003BA\u000f\u0003?i\u0011AP\u0005\u0004\u0003Cq$aC&bM.\f7i\u001c8gS\u001e\f!b]3sm\u0016\u0014\u0018J\u001c4p!\u0011\t9#a\f\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\t!\"Y;uQ>\u0014\u0018N_3s\u0015\tyd/\u0003\u0003\u00022\u0005%\"\u0001F!vi\"|'/\u001b>feN+'O^3s\u0013:4w.\u0001\u0003uS6,\u0007\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0006kRLGn\u001d\u0006\u0004\u0003\u007f1\u0018AB2p[6|g.\u0003\u0003\u0002D\u0005e\"\u0001\u0002+j[\u0016\f\u0001$\u001a8bE2,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t!\ry\u0017\u0011J\u0005\u0004\u0003\u0017*'a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u00151\u0005E\u00131KA+\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\n9\u0007\u0005\u0002F\u0001!)!\u000b\u0004a\u0001'\")!\f\u0004a\u00017\")a\f\u0004a\u0001?\")Q\u000e\u0004a\u0001]\")Q\u0010\u0004a\u0001}\"9\u00111\u0001\u0007A\u0002\u0005\u0015\u0001bBA\u0006\u0019\u0001\u0007\u0011Q\u0002\u0005\b\u00033a\u0001\u0019AA\u000e\u0011\u001d\t\u0019\u0003\u0004a\u0001\u0003KAq!a\r\r\u0001\u0004\t)\u0004C\u0004\u0002F1\u0001\r!a\u0012\u0002)\r|gN\\3di&|g.\u00169eCR,Gj\\2l+\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0003o\nAA[1wC&!\u00111PA9\u0005\u0019y%M[3di\u0006)2m\u001c8oK\u000e$\u0018n\u001c8Va\u0012\fG/\u001a'pG.\u0004\u0013!\u00069feNL7\u000f^3oi\u000e{gN\\3di&|gn]\u000b\u0003\u0003\u0007\u0003\u0002\"!\"\u0002\u0010\u0006M\u0015\u0011T\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u00055\u0015QO\u0001\u0005kRLG.\u0003\u0003\u0002\u0012\u0006\u001d%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0019q.!&\n\u0007\u0005]UMA\u0002J]R\u0004B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0005\u0003'\ti$\u0003\u0003\u0002\"\u0006u%A\u0004*fm\u0016\u00148/Z\"iC:tW\r\\\u0001\u0017a\u0016\u00148/[:uK:$8i\u001c8oK\u000e$\u0018n\u001c8tA\u0005A\u0012m\u0019;jm\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u00023\u0005\u001cG/\u001b<f%\u00164XM]:f\u0007>tg.Z2uS>t7\u000fI\u0001\u0015Y&t7\u000eT5ti\u0016tWM]#oIB|\u0017N\u001c;\u0016\u0005\u00055\u0006\u0003BAX\u0003ck!!!\u0010\n\t\u0005M\u0016Q\b\u0002\t\u000b:$\u0007o\\5oi\u0006AB.\u001b8l\u0019&\u001cH/\u001a8fe\u0016sG\r]8j]R|F%Z9\u0015\t\u0005e\u0016q\u0018\t\u0004_\u0006m\u0016bAA_K\n!QK\\5u\u0011%\t\t\rFA\u0001\u0002\u0004\ti+A\u0002yIE\nQ\u0003\\5oW2K7\u000f^3oKJ,e\u000e\u001a9pS:$\b\u0005K\u0002\u0016\u0003\u000f\u00042a\\Ae\u0013\r\tY-\u001a\u0002\tm>d\u0017\r^5mK\u0006\u0001B.\u001b8l\u0019&\u001cH/\u001a8fe:\u000bW.Z\u000b\u0003\u0003#\u0004B!a'\u0002T&!\u0011Q[AO\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003Qa\u0017N\\6MSN$XM\\3s\u001d\u0006lWm\u0018\u0013fcR!\u0011\u0011XAn\u0011%\t\tmFA\u0001\u0002\u0004\t\t.A\tmS:\\G*[:uK:,'OT1nK\u0002B3\u0001GAd\u0003)awnY1m\u0003\u0012l\u0017N\\\u000b\u0003\u0003K\u0004B!a:\u0002n6\u0011\u0011\u0011\u001e\u0006\u0004\u0003W$\u0018!B1e[&t\u0017\u0002BAx\u0003S\u0014abQ8oM2,XM\u001c;BI6Lg.\u0001\bm_\u000e\fG.\u00113nS:|F%Z9\u0015\t\u0005e\u0016Q\u001f\u0005\n\u0003\u0003T\u0012\u0011!a\u0001\u0003K\f1\u0002\\8dC2\fE-\\5oA!\u001a1$a2\u0002'I,Wn\u001c;f\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0016\u0005\u0005}\b\u0003B8q\u0005\u0003\u00012!\u0012B\u0002\u0013\r\u0011)\u0001\u0010\u0002\u0014%\u0016lw\u000e^3OKR<xN]6DY&,g\u000e^\u0001\u0018e\u0016lw\u000e^3OKR<xN]6DY&,g\u000e^0%KF$B!!/\u0003\f!I\u0011\u0011Y\u000f\u0002\u0002\u0003\u0007\u0011q`\u0001\u0015e\u0016lw\u000e^3OKR<xN]6DY&,g\u000e\u001e\u0011)\u0007y\t9-A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005e\u0016a\u0003:fG>tg-[4ve\u0016$b!!/\u0003\u001a\tu\u0001B\u0002B\u000eA\u0001\u00071,A\u0005oK^\u001cuN\u001c4jO\"9!q\u0004\u0011A\u0002\t\u0005\u0012aC;qI\u0006$X\rZ&fsN\u0004RAa\t\u0003*}k!A!\n\u000b\u0007\t\u001dR-\u0001\u0006d_2dWm\u0019;j_:LAAa\u000b\u0003&\t\u00191+\u001a;\u0002\u0011MDW\u000f\u001e3po:\f\u0011#\u001a8bE2,7\t\\;ti\u0016\u0014H*\u001b8l)\u0019\tILa\r\u0003>!9!Q\u0007\u0012A\u0002\t]\u0012!\u00048fi^|'o[\"mS\u0016tG\u000fE\u0002F\u0005sI1Aa\u000f=\u0005a\u0019E.^:uKJd\u0015N\\6OKR<xN]6DY&,g\u000e\u001e\u0005\b\u0003\u0007\u0011\u0003\u0019\u0001B !\u0011y\u0007O!\u0011\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bRAAa\u0012\u0002j\u0006I\u0011N\u001c;fe:\fGn]\u0005\u0005\u0005\u0017\u0012)E\u0001\u000bBI6Lg.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u001bS:LG/[1uKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d\u000b\u0007\u0005#\u0012yGa \u0011\r\tM#Q\fB2\u001d\u0011\u0011)F!\u0017\u000f\u0007\t\u00149&C\u0001g\u0013\r\u0011Y&Z\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yF!\u0019\u0003\u0007M+\u0017OC\u0002\u0003\\\u0015\u0004b!!\"\u0003f\t%\u0014\u0002\u0002B4\u0003\u000f\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f!\u0011\tyGa\u001b\n\t\t5\u0014\u0011\u000f\u0002\u0005->LG\rC\u0004\u0003r\r\u0002\rAa\u001d\u00023%t\u0017\u000e^5bi\u0016\u001cuN\u001c8fGRLwN\u001c*fcV,7\u000f\u001e\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011PA\u001f\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002B?\u0005o\u0012\u0011%\u00138ji&\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]N\u0014V-];fgRDqA!!$\u0001\u0004\u0011\u0019)\u0001\bsKF,Xm\u001d;D_:$X\r\u001f;\u0011\t\tU$QQ\u0005\u0005\u0005\u000f\u00139H\u0001\bSKF,Xm\u001d;D_:$X\r\u001f;\u0002'=t'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8\u0015\r\u0005e&Q\u0012BL\u0011\u001d\u0011y\t\na\u0001\u0005#\u000bqa\u00195b]:,G\u000e\u0005\u0003\u0002\u001c\nM\u0015\u0002\u0002BK\u0003;\u0013AbS1gW\u0006\u001c\u0005.\u00198oK2DqA!'%\u0001\u0004\u0011Y*A\u0006sKZ,'o]3O_\u0012,\u0007\u0003BAN\u0005;KAAa(\u0002\u001e\nY!+\u001a<feN,gj\u001c3f\u0003EygnQ8o]\u0016\u001cG/[8o\u00072|7/\u001a\u000b\u000b\u0003s\u0013)Ka*\u0003:\nu\u0006b\u0002BHK\u0001\u0007!\u0011\u0013\u0005\b\u0005S+\u0003\u0019\u0001BV\u0003%\u0011X-];fgRLE\r\u0005\u0004\u0003.\n=&1W\u0007\u0003\u0003\u0017KAA!-\u0002\f\nAq\n\u001d;j_:\fG\u000e\u0005\u0003\u0002p\tU\u0016\u0002\u0002B\\\u0003c\u0012q!\u00138uK\u001e,'\u000fC\u0004\u0003<\u0016\u0002\r!a%\u0002\u001dI,Wn\u001c;f\u0005J|7.\u001a:JI\"9!qX\u0013A\u0002\u0005\u001d\u0013AG;qI\u0006$X-T3uC\u0012\fG/Y%g!\u0016\u00148/[:uK:$\u0018A\u00064pe^\f'\u000f\u001a+p'>,(oY3Ce>\\WM]:\u0015\r\u0005e&Q\u0019Bk\u0011\u001d\u00119M\na\u0001\u0005\u0013\f1B]3rk\u0016\u001cH\u000fR1uCB!!1\u001aBi\u001b\t\u0011iM\u0003\u0003\u0003P\u0006u\u0012aB7fgN\fw-Z\u0005\u0005\u0005'\u0014iMA\u0013J]&$\u0018.\u0019;f%\u00164XM]:f\u0007>tg.Z2uS>t7OU3rk\u0016\u001cH\u000fR1uC\"9!q\u001b\u0014A\u0002\tE\u0013a\u00024viV\u0014Xm]\u0001\u0019GJ,\u0017\r^3SKZ,'o]3D_:tWm\u0019;j_:\u001cH\u0003CA]\u0005;\u0014yN!9\t\u000f\t\u001dw\u00051\u0001\u0003J\"9!\u0011Q\u0014A\u0002\t\r\u0005b\u0002BlO\u0001\u0007!\u0011K\u0001\u001b_:tUm\u001e*f[>$X\rT5oW\u000e{wN\u001d3j]\u0006$xN\u001d\u000b\u0005\u0003s\u00139\u000fC\u0004\u0003j\"\u0002\rAa;\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\t\u0005\u0003_\u0013i/\u0003\u0003\u0003p\u0006u\"\u0001\u0002(pI\u0016\f!c\u001c8D_:$(o\u001c7mKJ\u001c\u0005.\u00198hKR!\u0011\u0011\u0018B{\u0011\u001d\u001190\u000ba\u0001\u0003\u000f\n\u0001\"[:BGRLg/Z\u0001$_:d\u0015N\\6NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u000eC\u0017M\\4f\u0003ui\u0017-\u001f2f!J|7-Z:t\u0007>|'\u000fZ5oCR|'o\u00115b]\u001e,\u0017aG2m_N,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8BI6Lg.\u0001\u000fde\u0016\fG/\u001a*fm\u0016\u00148/Z\"p]:,7\r^5p]\u0006#W.\u001b8\u0002#\r\u0014X-\u0019;f%\u0016lw\u000e^3BI6Lg\u000e\u0006\u0002\u0003\u0002\u0005\u00012M]3bi\u0016dunY1m\u0003\u0012l\u0017N\u001c\u000b\u0003\u0003K\f!#\u001e9eCR,G*\u001b8l\u0019&\u001cH/\u001a8feR!\u0011\u0011XB\u0007\u0011\u0019\u0019y\u0001\ra\u00017\u000611m\u001c8gS\u001e\fAB]3wKJ\u001c\u0018\r\u001c#bi\u0006,\"a!\u0006\u0011\t\t-7qC\u0005\u0005\u00073\u0011iM\u0001\u000fSKZ,'o]3D_:tWm\u0019;j_:\u0014V-];fgR$\u0015\r^1\u0002?5\f\u0017PY3De\u0016\fG/\u001a)feNL7\u000f^3oi\u000e{gN\\3di&|g\u000e\u0006\u0003\u0002:\u000e}\u0001b\u0002Bug\u0001\u0007!1^\u0001\u0016e\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;f\u0003i\u0019Gn\\:f!\u0016\u00148/[:uK:$8i\u001c8oK\u000e$\u0018n\u001c8t\u0003u\u0019Gn\\:f\u0003\u000e$\u0018N^3SKZ,'o]3D_:tWm\u0019;j_:\u001c\u0018\u0001E:pG.,Go\u00115b]:,GnS3z)\u0011\t\u0019ja\u000b\t\u000f\r5r\u00071\u0001\u00040\u0005i1o\\2lKR\u001c\u0005.\u00198oK2\u0004Ba!\r\u0004<5\u001111\u0007\u0006\u0005\u0007k\u00199$\u0001\u0005dQ\u0006tg.\u001a7t\u0015\u0011\u0019I$!\u001e\u0002\u00079Lw.\u0003\u0003\u0004>\rM\"!D*pG.,Go\u00115b]:,G.A\ndY>\u001cXMU3wKJ\u001cXm\u00115b]:,G\u000e\u0006\u0003\u0002H\r\r\u0003bBB#q\u0001\u0007\u0011\u0011T\u0001\u000fe\u00164XM]:f\u0007\"\fgN\\3m\u0003e\u0001XM]:jgR,g\u000e^\"p]:,7\r^5p]\u000e{WO\u001c;\u0016\u0005\u0005M\u0015A\u0006:fm\u0016\u00148/Z\"p]:,7\r^5p]\u000e{WO\u001c;")
public class ClusterLinkOutboundConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.OutboundConnectionManager,
CoordinatorListener {
    private final ClusterLinkConfig initialConfig;
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkMetadataManager metadataManager;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final Time time;
    private final boolean enableReverseConnections;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, ReverseChannel> persistentConnections;
    private final ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, ReverseChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        ConnectionMode connectionMode = this.initialConfig.connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null)) {
            throw new IllegalStateException("Outbound connection manager created in inbound connection mode");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains((Object)ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1 & Serializable & scala.Serializable)configName -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.closeActiveReverseConnections();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            ((NetworkClient)kafkaClient).enableClusterLinkRequests(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull(Predef$.MODULE$.$conforms()), null);
            return;
        }
    }

    @Override
    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Initiate or forward reverse connection request: ").append(initiateConnectionRequest).toString());
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)List$.MODULE$.fill(connData.entries().size(), (Function0 & Serializable & scala.Serializable)() -> new CompletableFuture());
        try {
            String string = connData.sourceClusterId();
            String string2 = super.localLogicalCluster();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidRequestException(new StringBuilder(67).append("Initiate reverse request for cluster ").append(connData.sourceClusterId()).append(" sent to wrong source cluster ").append(super.localLogicalCluster()).toString());
            }
            if (connData.forwardToBroker()) {
                this.forwardToSourceBrokers(connData, (Seq<CompletableFuture<Void>>)futures);
            } else {
                this.createReverseConnections(connData, requestContext, (Seq<CompletableFuture<Void>>)futures);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failing reverse connection request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            futures.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.completeExceptionally(e)));
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Destination has successfully reversed channel ").append(channel2).append(" with requestId ").append(requestId).append(" remoteBrokerId ").append(remoteBrokerId).toString());
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.isLinkCoordinator()) {
            String errorMessage = new StringBuilder(88).append("Discarding persistent reverse connection since broker ").append(this.brokerConfig.brokerId()).append(" is no longer the link coordinator").toString();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.onConnectionClose((KafkaChannel)channel, reverseNode.requestId(), reverseNode.remoteBrokerId(), true));
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger((int)this.socketChannelKey(socketChannel)), reverseChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteBrokerId))).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$onReverseConnection$4(x$2)))) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Ignoring persistent connection because a connection already exists for ").append(remoteBrokerId).toString());
                    throw new IllegalStateException(new StringBuilder(41).append("A persistent connection is available for ").append(remoteBrokerId).toString());
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger((int)remoteBrokerId), reverseChannel);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Created persistent connection to ").append(remoteBrokerId).append(", channel=").append(channel2).toString());
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        this.metrics.deprecatedReverseConnectionCreatedSensor().record();
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Added reverse connection ").append(channel2).append(" to source socket server, requestId=").append(requestId).toString());
    }

    private void onConnectionClose(KafkaChannel channel, Optional<Integer> requestId, int remoteBrokerId, boolean updateMetadataIfPersistent) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Reverse channel ").append(channel).append(" has been disconnected").toString());
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)this.socketChannelKey(channel.socketChannel()))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
                this.metrics.deprecatedReverseConnectionClosedSensor().record();
            }
            if (!requestId.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger((int)remoteBrokerId)) != null) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Removed persistent connection for ").append(remoteBrokerId).append(" because channel ").append(channel.id()).append(" was closed").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (updateMetadataIfPersistent && bl) {
            this.requestMetadataUpdate();
        }
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Forward initiate reverse connection request from source link coordinator to source brokers: ").append(requestData).toString());
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((TraversableOnce)((TraversableLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(requestData.entries()).asScala()).zip(futures, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
            CompletableFuture future = (CompletableFuture)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId())), (Object)future);
            return tuple2;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(requestData.entries()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sourceBrokerId())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Create reverse connections from source brokers to destination brokers: ").append(requestData).toString());
        ((IterableLike)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(requestData.entries()).asScala()).zip(futures, Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            if (x0$1 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                CompletableFuture future = (CompletableFuture)x0$1._2();
                try {
                    if (entry.initiateRequestId() == -1 && Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)entry.targetBrokerId()))).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$createReverseConnections$4(x$4)))) {
                        object = BoxesRunTime.boxToBoolean((boolean)future.complete(null));
                    } else if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Create reverse connection from source broker to destination broker: ").append(entry).toString());
                        ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, requestContext$1.principalSerde, requestContext$1.authenticationContext, $this.time.milliseconds());
                        object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                            Void v = x0$2;
                            Throwable e = x1$1;
                            if (e != null) {
                                $this.metrics.outboundReverseConnectionFailedSensor().record();
                                $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                                networkClient.requestClusterLinkMetadataUpdate();
                                future.completeExceptionally(e);
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to reverse connection for ").append(reverseNode).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                                return;
                            }
                            future.complete(v);
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Completed connection reversal for ").append(reverseNode).toString());
                        });
                    } else {
                        object = BoxesRunTime.boxToBoolean((boolean)future.completeExceptionally(new InvalidRequestException(new StringBuilder(49).append("Incorrect source broker id, expected ").append($this.brokerConfig.brokerId()).append(", requested ").append(entry.sourceBrokerId()).toString())));
                    }
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to reverse connection for request ").append(requestData).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    object = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError(null);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
    }

    @Override
    public void onNewRemoteLinkCoordinator(Node coordinator) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Process remote metadata: isLocalCoordinator=").append(this.isLinkCoordinator()).append(" remoteCoordinator=").append(coordinator).toString());
        if (!this.enableReverseConnections) {
            return;
        }
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Process local controller change, isActiveController=").append(isActive).toString());
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Process metadata partition leader change");
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            boolean isCoordinator = this.isLinkCoordinator();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Process link coordinator change isLocalCoordinator=").append(isCoordinator).toString());
            if (this.enableReverseConnections) {
                if (!isCoordinator) {
                    this.closePersistentConnections();
                } else {
                    this.maybeCreatePersistentConnection();
                }
                return;
            }
            return;
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.remoteNetworkClient().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        if (!this.enableReverseConnections) {
            return;
        }
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq((Option<RemoteNetworkClient>)new Some((Object)this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServers(), (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(this.brokerConfig, config, (Option<ClusterLinkConnectionManager>)None$.MODULE$, metadata, this.metrics.metrics(), "connection-metadata", this.time);
        metadataRefreshThread.addCoordinatorListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableClusterLinkReverseConnectionAdmin(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull(Predef$.MODULE$.$conforms()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Creating local admin for reverse connections from source cluster on listener ").append(this.linkListenerEndpoint()).toString());
        Map<String, Object> adminConfigs = config.localLinkClientConfigs(this.brokerConfig, this.linkListenerEndpoint(), super.linkData().tenantPrefix().nonEmpty());
        adminConfigs.put("client.id", new StringBuilder(38).append("cluster-link-").append(super.linkData().linkName()).append("-local-source-conn-admin-").append(this.brokerConfig.brokerId()).toString());
        return (ConfluentAdmin)Admin.create(adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        this.linkListenerEndpoint_$eq(this.serverInfo.endpoints().stream().filter(x$6 -> {
            Optional optional = x$6.listenerName();
            Optional<String> optional2 = Optional.of(config.localListenerName());
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException(new StringBuilder(19).append("Listener ").append(config.localListenerName()).append(" not found").toString())));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.isLinkCoordinator()) {
            this.remoteNetworkClient().foreach((Function1 & Serializable & scala.Serializable)client -> {
                ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$1(this, client);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void maybeCreatePersistentConnection(Node coordinator) {
        if (!Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)coordinator.id()))).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$3(x$7)))) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Creating persistent connection to remote link coordinator ").append(coordinator).toString());
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(super.linkData().linkId().getMostSignificantBits(), super.linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(super.localLogicalCluster()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException("Remote cluster id not known");
            })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId(this.brokerConfig.brokerId()).setTargetBrokerId(coordinator.id())));
            CompletableFuture future = new CompletableFuture();
            this.forwardToSourceBrokers(requestData, (Seq<CompletableFuture<Void>>)new .colon.colon(future, (List)Nil$.MODULE$));
            future.whenComplete((x0$1, x1$1) -> {
                Throwable e = x1$1;
                if (e != null) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create persistent reverse connection", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.requestMetadataUpdate();
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Successfully created persistent connection to ").append(coordinator).append("  for ").append(requestData).toString());
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Not creating persistent connection, remoteController=").append(coordinator).append(", persistentConnections=").append(this.persistentConnections()).toString());
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)ClusterLinkOutboundConnectionManager.$anonfun$requestMetadataUpdate$1(x$8)));
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing persistent connections");
            ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.persistentConnections()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$2(this, x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing active reverse connections");
            ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.activeReverseConnections()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$2(this, x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public boolean closeReverseChannel(ReverseChannel reverseChannel) {
        if (!reverseChannel.maybeClose()) {
            SocketChannel socketChannel = reverseChannel.socketChannel();
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("Runnable to close reverse channel '").append(reverseChannel).append("' not set. Channel may not have been added to SocketServer yet, closing socket channel.").toString());
                reverseChannel.socketChannel().close();
            }
            catch (Exception e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Failed to close socket channel ").append(socketChannel).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Close initiated for reverse channel '").append(reverseChannel).append("', the channel will be closed by SocketServer.").toString());
        return false;
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    public static final /* synthetic */ boolean $anonfun$onReverseConnection$4(ReverseChannel x$2) {
        return x$2.socketChannel().isConnected();
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException(new StringBuilder(39).append("Source broker with id ").append(brokerId$1).append(" is not available").toString());
        return ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkOutboundConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Buffer entries = (Buffer)x0$2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.metadataManager.isBrokerOnline(brokerId)) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(entries).asJava());
                ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId)).forEach((x0$3, x1$1) -> {
                    Integer requestId = x0$3;
                    x1$1.whenComplete((x0$4, x1$2) -> {
                        Void v = x0$4;
                        Throwable e = x1$2;
                        if (e != null) {
                            ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(requestId)))).completeExceptionally(e);
                            $this.metrics.outboundReverseConnectionFailedSensor().record();
                            $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Connection reversal request to local broker failed for requestId=").append(requestId).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                            return;
                        }
                        ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(requestId)))).complete(v);
                        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Completed initiate reversal request for requestId=").append(requestId).toString());
                    });
                });
                return;
            }
            entries.foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createReverseConnections$4(ReverseChannel x$4) {
        return x$4.socketChannel().isConnected();
    }

    public static final /* synthetic */ void $anonfun$maybeCreatePersistentConnection$1(ClusterLinkOutboundConnectionManager $this, RemoteNetworkClient client) {
        Option<Node> option = client.metadataRefreshThread().remoteLinkCoordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            $this.maybeCreatePersistentConnection(coordinator);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Remote coordinator not known, request metadata");
            $this.requestMetadataUpdate();
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$maybeCreatePersistentConnection$3(ReverseChannel x$7) {
        return x$7.socketChannel().isConnected();
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$8) {
        return x$8.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public static final /* synthetic */ boolean $anonfun$closePersistentConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
        boolean bl = $this.closeReverseChannel(reverseChannel);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closePersistentConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeActiveReverseConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
        boolean bl = $this.closeReverseChannel(reverseChannel);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeActiveReverseConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public ClusterLinkOutboundConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, ClusterLinkMetadataManager metadataManager, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, Time time, boolean enableReverseConnections) {
        this.initialConfig = initialConfig;
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.metadataManager = metadataManager;
        this.socketServer = socketServer;
        this.brokerConfig = brokerConfig;
        this.serverInfo = serverInfo;
        this.time = time;
        this.enableReverseConnections = enableReverseConnections;
        super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics, brokerConfig);
        CoordinatorListener.$init$(this);
        this.connectionUpdateLock = new Object();
        this.persistentConnections = new ConcurrentHashMap();
        this.activeReverseConnections = new ConcurrentHashMap();
        this.remoteNetworkClient = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(48).append("[ClusterLinkOutboundConnectionManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        if (enableReverseConnections) {
            this.updateLinkListener(initialConfig);
        }
    }
}

