/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.server.link.AclBindingFilterTransformer;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015f\u0001\u0002\u001d:\u0001\u0001C\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0017\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003R\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003{\u0011!q\bA!b\u0001\n\u0003y\bBCA\u0004\u0001\t\u0005\t\u0015!\u0003\u0002\u0002!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011%\t9\u0003\u0001a\u0001\n\u0013\tI\u0003\u0003\u0005\u00026\u0001\u0001\u000b\u0015BA\u0011\u0011%\t9\u0004\u0001b\u0001\n\u0013\tI\u0004\u0003\u0005\u0002H\u0001\u0001\u000b\u0011BA\u001e\u0011%\tI\u0005\u0001b\u0001\n\u0013\tY\u0005\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA'\u0011%\t)\u0007\u0001b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA5\u0011%\tY\b\u0001a\u0001\n\u0013\ti\bC\u0005\u0002\u0006\u0002\u0001\r\u0011\"\u0003\u0002\b\"A\u00111\u0012\u0001!B\u0013\ty\b\u0003\u0005\u0002\u000e\u0002\u0001\r\u0011\"\u0003\u0000\u0011%\ty\t\u0001a\u0001\n\u0013\t\t\n\u0003\u0005\u0002\u0016\u0002\u0001\u000b\u0015BA\u0001\u0011%\t9\n\u0001a\u0001\n\u0013\ti\bC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002\u001c\"A\u0011q\u0014\u0001!B\u0013\ty\bC\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\"9\u0011Q\u0015\u0001!\u0002\u00131\u0007bBAT\u0001\u0011E\u0013\u0011\u0016\u0005\b\u0003W\u0003A\u0011BAW\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!a5\u0001\t\u0013\t)\u000eC\u0004\u0002\\\u0002!I!!8\t\u000f\u0005\u001d\b\u0001\"\u0003\u0002j\"9!1\u0001\u0001\u0005\n\t\u0015\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005W\u0001A\u0011\u0002B\u0017\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sA\u0001Ba\u0011\u0001\t\u0003I$Q\t\u0005\b\u0005/\u0002A\u0011\u0002B-\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqA!\u001d\u0001\t\u0003\ti\bC\u0004\u0003t\u0001!\tA!\u001e\t\u0011\tm\u0004\u0001\"\u0001:\u0003{BaA! \u0001\t\u0003yx!\u0003B@s\u0005\u0005\t\u0012\u0001BA\r!A\u0014(!A\t\u0002\t\r\u0005bBA\u0005k\u0011\u0005!1\u0012\u0005\n\u0005\u001b+\u0014\u0013!C\u0001\u0005\u001f\u00131c\u00117vgR,'\u000fT5oWNKhnY!dYNT!AO\u001e\u0002\t1Lgn\u001b\u0006\u0003yu\naa]3sm\u0016\u0014(\"\u0001 \u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0011\t\u0003\u0005\u001as!a\u0011#\u000e\u0003eJ!!R\u001d\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t9\u0005J\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002Fs\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012a\u0013\t\u0003\u00072K!!T\u001d\u00039\rcWo\u001d;fe2Kgn\u001b#fgR\u001cE.[3oi6\u000bg.Y4fe\u0006q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013\u0001\u00037j].$\u0015\r^1\u0016\u0003E\u0003\"AU+\u000e\u0003MS!\u0001V\u001f\u0002\u0005i\\\u0017B\u0001,T\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014X#\u0001.\u0011\u0005\r[\u0016B\u0001/:\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u0003AiW\r^1eCR\fW*\u00198bO\u0016\u0014\b%\u0001\teKN$\u0018\tZ7j]\u001a\u000b7\r^8ssV\t\u0001\rE\u0002bI\u001al\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\n\rVt7\r^5p]B\u0002\"aZ9\u000e\u0003!T!!\u001b6\u0002\u000b\u0005$W.\u001b8\u000b\u0005-d\u0017aB2mS\u0016tGo\u001d\u0006\u0003}5T!A\\8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0018aA8sO&\u0011!\u000f\u001b\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003E!Wm\u001d;BI6LgNR1di>\u0014\u0018\u0010I\u0001\b[\u0016$(/[2t!\t\u0019e/\u0003\u0002xs\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003m\t7\r\u001c\"j]\u0012Lgn\u001a$jYR,'\u000f\u0016:b]N4wN]7feV\t!\u0010\u0005\u0002Dw&\u0011A0\u000f\u0002\u001c\u0003\u000ed')\u001b8eS:<g)\u001b7uKJ$&/\u00198tM>\u0014X.\u001a:\u00029\u0005\u001cGNQ5oI&twMR5mi\u0016\u0014HK]1og\u001a|'/\\3sA\u0005\u0001\u0013m\u00197GS2$XM],ji\"\u0014Vm]8ve\u000e,\u0017\n\u001a)sS:\u001c\u0017\u000e]1m+\t\t\t\u0001E\u0002b\u0003\u0007I1!!\u0002c\u0005\u001d\u0011un\u001c7fC:\f\u0011%Y2m\r&dG/\u001a:XSRD'+Z:pkJ\u001cW-\u00133Qe&t7-\u001b9bY\u0002\na\u0001P5oSRtD\u0003EA\u0007\u0003\u001f\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e!\t\u0019\u0005\u0001C\u0003J\u001d\u0001\u00071\nC\u0003P\u001d\u0001\u0007\u0011\u000bC\u0003Y\u001d\u0001\u0007!\fC\u0003_\u001d\u0001\u0007\u0001\rC\u0003u\u001d\u0001\u0007Q\u000fC\u0003y\u001d\u0001\u0007!\u0010\u0003\u0005\u007f\u001dA\u0005\t\u0019AA\u0001\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011\u0011\u0005\t\u0004\u0007\u0006\r\u0012bAA\u0013s\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002,\u0005E\u0002cA1\u0002.%\u0019\u0011q\u00062\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003g\u0001\u0012\u0011!a\u0001\u0003C\t1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\na\u0001\\5oW&#WCAA\u001e!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!Y\u000611m\\7n_:LA!!\u0012\u0002@\t!Q+^5e\u0003\u001da\u0017N\\6JI\u0002\n\u0001\u0002\\5oW:\u000bW.Z\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002^9!\u0011\u0011KA-!\r\t\u0019FY\u0007\u0003\u0003+R1!a\u0016@\u0003\u0019a$o\\8u}%\u0019\u00111\f2\u0002\rA\u0013X\rZ3g\u0013\u0011\ty&!\u0019\u0003\rM#(/\u001b8h\u0015\r\tYFY\u0001\nY&t7NT1nK\u0002\nA\"Y2m\u0019&t7.\u00133TKR,\"!!\u001b\u0011\r\u0005-\u0014QOA\u001e\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001B;uS2T!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niGA\u0002TKR\fQ\"Y2m\u0019&t7.\u00133TKR\u0004\u0013\u0001\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h+\t\ty\bE\u0002b\u0003\u0003K1!a!c\u0005\rIe\u000e^\u0001\u0015i\u0006\u001c8n](viN$\u0018M\u001c3j]\u001e|F%Z9\u0015\t\u0005-\u0012\u0011\u0012\u0005\n\u0003gI\u0012\u0011!a\u0001\u0003\u007f\n\u0011\u0003^1tWN|U\u000f^:uC:$\u0017N\\4!\u0003-Ig.\u001b;jC2L'0\u001a3\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$B!a\u000b\u0002\u0014\"I\u00111\u0007\u000f\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\rS:LG/[1mSj,G\rI\u0001\u001e]Vl7+Z2ve&$\u0018\u0010R5tC\ndW\rZ#yG\u0016\u0004H/[8og\u0006\tc.^7TK\u000e,(/\u001b;z\t&\u001c\u0018M\u00197fI\u0016C8-\u001a9uS>t7o\u0018\u0013fcR!\u00111FAO\u0011%\t\u0019dHA\u0001\u0002\u0004\ty(\u0001\u0010ok6\u001cVmY;sSRLH)[:bE2,G-\u0012=dKB$\u0018n\u001c8tA\u0005IA-Z:u\u0003\u0012l\u0017N\\\u000b\u0002M\u0006QA-Z:u\u0003\u0012l\u0017N\u001c\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0002\u0002\u0005I\u0011M\\=GS2$XM\u001d\u000b\u0003\u0003_\u0003B!!-\u000286\u0011\u00111\u0017\u0006\u0005\u0003k\u000by$A\u0002bG2LA!!/\u00024\n\u0001\u0012i\u00197CS:$\u0017N\\4GS2$XM]\u0001\u000bS:LG/[1mSj,G\u0003BA\u0016\u0003\u007fCq!!1&\u0001\u0004\t\u0019-A\u0007bG24\u0015\u000e\u001c;fe2K7\u000f\u001e\t\u0007\u0003\u000b\fy-a,\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\fq!\\;uC\ndWMC\u0002\u0002N\n\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t.a2\u0003\r\t+hMZ3s\u0003)a\u0017N\\6GS2$XM\u001d\u000b\u0005\u0003_\u000b9\u000eC\u0004\u0002Z\u001a\u0002\r!a,\u0002\u0013\u0005\u001cGNR5mi\u0016\u0014\u0018a\u00027j].\f5\r\u001c\u000b\u0005\u0003?\f)\u000f\u0005\u0003\u00022\u0006\u0005\u0018\u0002BAr\u0003g\u0013!\"Q2m\u0005&tG-\u001b8h\u0011\u001d\t)l\na\u0001\u0003?\f\u0011dY;se\u0016tG\u000fR3ti\u0006\u001bGn],ji\"d\u0015N\\6JIR1\u00111^Ax\u0005\u0003\u0001b!a\u0014\u0002n\u0006}\u0017\u0002BA<\u0003CBq!!=)\u0001\u0004\t\u00190\u0001\u0003bkRD\u0007\u0003BA{\u0003{l!!a>\u000b\t\u0005e\u00181`\u0001\u000bCV$\bn\u001c:ju\u0016\u0014(B\u0001\u001fm\u0013\u0011\ty0a>\u0003\u0015\u0005+H\u000f[8sSj,'\u000fC\u0004\u0002B\"\u0002\r!a1\u0002%!\fg\u000e\u001a7f\t\u0016\u001c8M]5cK\u0006\u001bGn\u001d\u000b\u0007\u0003\u0003\u00119Aa\u0004\t\u000f\u0005\u0005\u0017\u00061\u0001\u0003\nA1\u0011Q\u0019B\u0006\u0003_KAA!\u0004\u0002H\nQA*[:u\u0005V4g-\u001a:\t\u000f\tE\u0011\u00061\u0001\u0003\u0014\u0005Qa-\u001e;ve\u0016d\u0015n\u001d;\u0011\r\u0005\u0015'1\u0002B\u000b!\u0019\tiDa\u0006\u0003\u001c%!!\u0011DA \u0005-Y\u0015MZ6b\rV$XO]3\u0011\r\u0005-$QDAp\u0013\u0011\u0011y\"!\u001c\u0003\u0015\r{G\u000e\\3di&|g.\u0001\u0006va\u0012\fG/Z!dYN$b!!\u0001\u0003&\t\u001d\u0002bBAaU\u0001\u0007!\u0011\u0002\u0005\b\u0005SQ\u0003\u0019AAv\u0003)\u0019x.\u001e:dK\u0006\u001bGn]\u0001\u0019C\u0012$G\u000b[3o\t\u0016dW\r^3BG2\u001chi\u001c:J]&$HCBA\u0016\u0005_\u0011\u0019\u0004C\u0004\u00032-\u0002\r!a;\u0002\u0019\u0005\u001cGn\u001d+p\u0007J,\u0017\r^3\t\u000f\tU2\u00061\u0001\u0002l\u0006a\u0011m\u00197t)>$U\r\\3uK\u0006\tB-\u001a7fi\u0016$\u0006.\u001a8BI\u0012\f5\r\\:\u0015\u0011\u0005-\"1\bB\u001f\u0005\u007fAqA!\r-\u0001\u0004\tY\u000fC\u0004\u000361\u0002\r!a;\t\u000f\t\u0005C\u00061\u0001\u0002\u0002\u0005\tR\u000f\u001d3bi\u0016Le.\u001b;jC2L'0\u001a3\u0002+!\fg\u000e\u001a7f\u0003\u000edG)\u001a7fi\u0016\u0014Vm];miR1\u0011\u0011\u0001B$\u0005#BqA!\u0013.\u0001\u0004\u0011Y%\u0001\teK2,G/Z!dYN\u0014Vm];miB\u0019qM!\u0014\n\u0007\t=\u0003N\u0001\tEK2,G/Z!dYN\u0014Vm];mi\"9!1K\u0017A\u0002\tU\u0013AE2sK\u0006$X-Q2mg\u000e\u000bG\u000e\u001c2bG.\u0004B!\u00193\u0002,\u0005Q1M]3bi\u0016\f5\r\\:\u0015\r\u0005-\"1\fB/\u0011\u001d\u0011\tD\fa\u0001\u0003WDqAa\u0018/\u0001\u0004\u0011)&\u0001\u0005dC2d')Y2l\u0003UA\u0017M\u001c3mK\u0006\u001bGn\u0011:fCR,'+Z:vYR$b!!\u0001\u0003f\t=\u0004b\u0002B4_\u0001\u0007!\u0011N\u0001\u0011GJ,\u0017\r^3BG2\u001c(+Z:vYR\u00042a\u001aB6\u0013\r\u0011i\u0007\u001b\u0002\u0011\u0007J,\u0017\r^3BG2\u001c(+Z:vYRDqAa\u00180\u0001\u0004\u0011)&A\fdkJ\u0014XM\u001c;UCN\\7oT;ugR\fg\u000eZ5oO\u0006\tB/Y:lg>+Ho\u001d;b]\u0012LgnZ0\u0015\t\u0005-\"q\u000f\u0005\b\u0005s\n\u0004\u0019AA@\u0003\u0005!\u0018\u0001J2veJ,g\u000e\u001e(v[N+7-\u001e:jif$\u0015n]1cY\u0016$W\t_2faRLwN\\:\u0002\u001b%\u001c\u0018J\\5uS\u0006d\u0017N_3e\u0003M\u0019E.^:uKJd\u0015N\\6Ts:\u001c\u0017i\u00197t!\t\u0019UgE\u00026\u0005\u000b\u00032!\u0019BD\u0013\r\u0011II\u0019\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u0005\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'\u0006\u0002\u0003\u0012*\"\u0011\u0011\u0001BJW\t\u0011)\n\u0005\u0003\u0003\u0018\n\u0005VB\u0001BM\u0015\u0011\u0011YJ!(\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BPE\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r&\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ClusterLinkSyncAcls
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private final AclBindingFilterTransformer aclBindingFilterTransformer;
    private final boolean aclFilterWithResourceIdPrincipal;
    private ClusterLinkConfig config;
    private final Uuid linkId;
    private final String linkName;
    private final Set<Uuid> aclLinkIdSet;
    private int tasksOutstanding;
    private boolean initialized;
    private int numSecurityDisabledExceptions;
    private final ConfluentAdmin destAdmin;

    public static boolean $lessinit$greater$default$7() {
        return ClusterLinkSyncAcls$.MODULE$.$lessinit$greater$default$7();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkData linkData() {
        return this.linkData;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    public AclBindingFilterTransformer aclBindingFilterTransformer() {
        return this.aclBindingFilterTransformer;
    }

    public boolean aclFilterWithResourceIdPrincipal() {
        return this.aclFilterWithResourceIdPrincipal;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private Uuid linkId() {
        return this.linkId;
    }

    private String linkName() {
        return this.linkName;
    }

    private Set<Uuid> aclLinkIdSet() {
        return this.aclLinkIdSet;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private int numSecurityDisabledExceptions() {
        return this.numSecurityDisabledExceptions;
    }

    private void numSecurityDisabledExceptions_$eq(int x$1) {
        this.numSecurityDisabledExceptions = x$1;
    }

    private ConfluentAdmin destAdmin() {
        return this.destAdmin;
    }

    @Override
    public boolean run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.clientManager().linkData().linkName()) && this.config().aclSyncEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Number of outstanding tasks was not 0 at the beginning of run. Resetting to 0 and continuing on.");
                this.tasksOutstanding_$eq(0);
            }
            if (this.config().aclFilters().isEmpty()) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(108).append(this.linkName()).append(": ACL migration is enabled ").append("but acl.filters is not set. Please set acl.filters to proceed with ACL migration.").toString());
            } else {
                AclFiltersJson aclFilterJson = (AclFiltersJson)this.config().aclFilters().get();
                ListBuffer<AclBindingFilter> aclFilterList = AclJson$.MODULE$.toAclBindingFilters(aclFilterJson);
                if (!this.initialized()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Not initialized for ").append(this.linkId()).append(". Starting initialization process.").toString());
                    this.initialize((Buffer<AclBindingFilter>)aclFilterList);
                    if (!this.initialized()) {
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Still not initialized for ").append(this.linkId()).append(".").toString());
                        if (this.tasksOutstanding() == 0) {
                            throw new IllegalStateException(new StringBuilder(64).append("Task is not initialized for ").append(this.linkId()).append(" but there are no outstanding tasks.").toString());
                        }
                        return false;
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Now initialized for ").append(this.linkId()).append(".").toString());
                }
                ListBuffer describeAclsFutureList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                aclFilterList.foreach((Function1 & Serializable & scala.Serializable)aclFilter -> {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to retrieve ACLs from source cluster");
                    return describeAclsFutureList.$plus$eq((Object)this.clientManager().getAdmin().describeAcls(aclFilter));
                });
                if (describeAclsFutureList.nonEmpty()) {
                    ListBuffer futureList = (ListBuffer)describeAclsFutureList.map((Function1 & Serializable & scala.Serializable)result -> result.values(), ListBuffer$.MODULE$.canBuildFrom());
                    KafkaFuture future = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futureList.toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
                    this.scheduleWhenComplete(future, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.handleDescribeAcls(aclFilterList, (ListBuffer<KafkaFuture<Collection<AclBinding>>>)futureList));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                }
            }
        }
        return this.tasksOutstanding() == 0;
    }

    private AclBindingFilter anyFilter() {
        if (this.aclFilterWithResourceIdPrincipal()) {
            return new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(MultiTenantPrincipal.WILDCARD_USERV2_PRINCIPAL.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        }
        return AclBindingFilter.ANY;
    }

    private void initialize(Buffer<AclBindingFilter> aclFilterList) {
        if (this.clientManager().getAuthorizer().isDefined()) {
            Authorizer auth = (Authorizer)this.clientManager().getAuthorizer().get();
            scala.collection.immutable.Set<AclBinding> linkAcls = this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)((Buffer)Buffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{this.anyFilter()}))));
            scala.collection.immutable.Set<AclBinding> matchingAcls = this.currentDestAclsWithLinkId(auth, aclFilterList);
            scala.collection.immutable.Set notMatchingLinkAclsToDelete = (scala.collection.immutable.Set)linkAcls.diff(matchingAcls);
            scala.collection.immutable.Set localAclsToCreate = (scala.collection.immutable.Set)notMatchingLinkAclsToDelete.map((Function1 & Serializable & scala.Serializable)acl -> {
                AccessControlEntry ace = acl.entry();
                AccessControlEntry linkAce = new AccessControlEntry(ace.principal(), ace.host(), ace.operation(), ace.permissionType());
                return new AclBinding(acl.pattern(), linkAce);
            }, Set$.MODULE$.canBuildFrom());
            this.addThenDeleteAclsForInit((scala.collection.immutable.Set<AclBinding>)localAclsToCreate, (scala.collection.immutable.Set<AclBinding>)notMatchingLinkAclsToDelete);
        }
    }

    private AclBindingFilter linkFilter(AclBindingFilter aclFilter) {
        AccessControlEntryFilter ace = aclFilter.entryFilter();
        AccessControlEntryFilter linkFilter = new AccessControlEntryFilter(ace.principal(), ace.host(), ace.operation(), ace.permissionType(), this.aclLinkIdSet());
        return new AclBindingFilter(aclFilter.patternFilter(), linkFilter);
    }

    private AclBinding linkAcl(AclBinding acl) {
        Collection collection = acl.entry().clusterLinkIds();
        Set<Uuid> set = this.aclLinkIdSet();
        if (!(collection != null ? !((Object)collection).equals(set) : set != null)) {
            return acl;
        }
        return SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, this.aclLinkIdSet());
    }

    private scala.collection.immutable.Set<AclBinding> currentDestAclsWithLinkId(Authorizer auth, Buffer<AclBindingFilter> aclFilterList) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)aclFilterList.map((Function1 & Serializable & scala.Serializable)aclFilter -> this.linkFilter((AclBindingFilter)aclFilter), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)filter -> {
            AclBindingFilter transformedFilter = this.aclBindingFilterTransformer().transform((AclBindingFilter)filter);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Transformed filter from ").append(filter).append(" to ").append(transformedFilter).toString());
            return (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(auth.acls(transformedFilter)).asScala();
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)acl -> this.linkAcl((AclBinding)acl), Buffer$.MODULE$.canBuildFrom())).toSet();
    }

    private boolean handleDescribeAcls(ListBuffer<AclBindingFilter> aclFilterList, ListBuffer<KafkaFuture<Collection<AclBinding>>> futureList) {
        Object object = new Object();
        try {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            scala.collection.immutable.Set sourceAcls = ((TraversableForwarder)futureList.flatMap((Function1 & Serializable & scala.Serializable)future -> {
                try {
                    return (Iterable)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)future.get()).asScala()).map((Function1 & Serializable & scala.Serializable)acl -> this.linkAcl((AclBinding)acl), scala.collection.Iterable$.MODULE$.canBuildFrom());
                }
                catch (ExecutionException e) {
                    $this.metrics.describeAclsFromSourceFailedSensor().record();
                    Throwable throwable = e.getCause();
                    if (throwable instanceof SecurityDisabledException) {
                        if (this.numSecurityDisabledExceptions() == 0) {
                            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Unable to retrieve ACLs on source cluster because no authorizer is configured on the ").append("source cluster. Please configure authorizer to proceed with ACL migration. Encountered exception ").append(e).toString());
                        } else {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(182).append("Unable to retrieve ACLs on source cluster because no authorizer is configured on the ").append("source cluster. Please configure authorizer to proceed with ACL migration. Encountered exception ").append(e).toString());
                        }
                        this.numSecurityDisabledExceptions_$eq(this.numSecurityDisabledExceptions() + 1);
                        throw new NonLocalReturnControl.mcZ.sp(object, true);
                    }
                    if (throwable instanceof AuthorizationException) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(151).append("Unable to retrieve ACLs on source cluster due to authorization failure. ").append("Please enable DESCRIBE ACLs on the source cluster to proceed with ACL migration").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else if (throwable != null) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to retrieve ACLs on source cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    } else {
                        throw new MatchError(null);
                    }
                    this.numSecurityDisabledExceptions_$eq(0);
                    throw e;
                }
                catch (Throwable e) {
                    $this.metrics.describeAclsFromSourceFailedSensor().record();
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to retrieve ACLs on source cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.numSecurityDisabledExceptions_$eq(0);
                    throw e;
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).toSet();
            return this.updateAcls(aclFilterList, (scala.collection.immutable.Set<AclBinding>)sourceAcls);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean updateAcls(ListBuffer<AclBindingFilter> aclFilterList, scala.collection.immutable.Set<AclBinding> sourceAcls) {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Result of describeAcls on source cluster for ").append(this.linkId()).append(": ").append(sourceAcls).toString());
        this.clientManager().getAuthorizer().foreach((Function1 & Serializable & scala.Serializable)auth -> {
            ClusterLinkSyncAcls.$anonfun$updateAcls$2(this, aclFilterList, sourceAcls, auth);
            return BoxedUnit.UNIT;
        });
        this.numSecurityDisabledExceptions_$eq(0);
        return this.tasksOutstanding() == 0;
    }

    private void addThenDeleteAclsForInit(scala.collection.immutable.Set<AclBinding> aclsToCreate, scala.collection.immutable.Set<AclBinding> aclsToDelete) {
        JFunction0.mcV.sp & Serializable & scala.Serializable createAcls_callBack = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.deleteThenAddAcls((scala.collection.immutable.Set<AclBinding>)Predef$.MODULE$.Set().empty(), aclsToDelete, true);
        if (aclsToCreate.nonEmpty()) {
            try {
                List createAcls_aclsToCreateList = aclsToCreate.toList();
                CreateAclsResult createAcls_createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)createAcls_aclsToCreateList).asJava());
                Map createAcls_values = createAcls_createAclResult.values();
                scala.collection.mutable.Iterable createAcls_createAclsResultFutures = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAcls_values).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (KafkaFuture)x$2._2(), Iterable$.MODULE$.canBuildFrom());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAcls_createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ClusterLinkSyncAcls.$anonfun$createAcls$2(this, createAcls_createAclResult, (Function0)createAcls_callBack)));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return;
            }
            catch (Throwable createAcls_e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to create ACLs on destination cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> createAcls_e);
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                return;
            }
        }
        this.deleteThenAddAcls((scala.collection.immutable.Set<AclBinding>)Predef$.MODULE$.Set().empty(), aclsToDelete, true);
    }

    private void deleteThenAddAcls(scala.collection.immutable.Set<AclBinding> aclsToCreate, scala.collection.immutable.Set<AclBinding> aclsToDelete, boolean updateInitialized) {
        JFunction0.mcV.sp & Serializable & scala.Serializable createAclsCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JFunction0.mcV.sp & Serializable & scala.Serializable createAcls_callBack = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                if (updateInitialized) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updating initialized to true for ").append(this.linkId()).toString());
                    this.initialized_$eq(true);
                }
            };
            if (aclsToCreate.nonEmpty()) {
                try {
                    List createAcls_aclsToCreateList = aclsToCreate.toList();
                    CreateAclsResult createAcls_createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)createAcls_aclsToCreateList).asJava());
                    Map createAcls_values = createAcls_createAclResult.values();
                    scala.collection.mutable.Iterable createAcls_createAclsResultFutures = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAcls_values).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (KafkaFuture)x$2._2(), Iterable$.MODULE$.canBuildFrom());
                    this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAcls_createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ClusterLinkSyncAcls.$anonfun$createAcls$2(this, createAcls_createAclResult, (Function0)createAcls_callBack)));
                    this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                    return;
                }
                catch (Throwable createAcls_e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to create ACLs on destination cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> createAcls_e);
                    $this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                    return;
                }
            }
            ClusterLinkSyncAcls.$anonfun$deleteThenAddAcls$2(this, updateInitialized);
        };
        if (aclsToDelete.nonEmpty()) {
            try {
                List deleteAclsFilterList = ((TraversableOnce)aclsToDelete.map((Function1 & Serializable & scala.Serializable)acl -> acl.toFilter(), Set$.MODULE$.canBuildFrom())).toList();
                DeleteAclsResult deleteAclsResult = this.destAdmin().deleteAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)deleteAclsFilterList).asJava());
                scala.collection.mutable.Iterable deleteAclsResultFutures = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (KafkaFuture)x$1._2(), Iterable$.MODULE$.canBuildFrom());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ClusterLinkSyncAcls.$anonfun$deleteThenAddAcls$6(this, deleteAclsResult, (Function0)createAclsCallback)));
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return;
            }
            catch (Throwable e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to delete ACLs on destination cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.metrics.aclsDeleteFailedSensor().record((double)aclsToDelete.size());
                return;
            }
        }
        ClusterLinkSyncAcls.$anonfun$deleteThenAddAcls$1(this, aclsToCreate, updateInitialized);
    }

    public boolean handleAclDeleteResult(DeleteAclsResult deleteAclsResult, Function0<BoxedUnit> createAclsCallback) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        BooleanRef err = BooleanRef.create((boolean)false);
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(deleteAclsResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkSyncAcls.$anonfun$handleAclDeleteResult$1(this, err, x0$1);
            return BoxedUnit.UNIT;
        });
        if (err.elem) {
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append("Failed to delete ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            return true;
        }
        createAclsCallback.apply$mcV$sp();
        return this.tasksOutstanding() == 0;
    }

    private void createAcls(scala.collection.immutable.Set<AclBinding> aclsToCreate, Function0<BoxedUnit> callBack) {
        if (aclsToCreate.nonEmpty()) {
            try {
                List aclsToCreateList = aclsToCreate.toList();
                CreateAclsResult createAclResult = this.destAdmin().createAcls((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)aclsToCreateList).asJava());
                Map values = createAclResult.values();
                scala.collection.mutable.Iterable createAclsResultFutures = (scala.collection.mutable.Iterable)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(values).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> (KafkaFuture)x$2._2(), Iterable$.MODULE$.canBuildFrom());
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    boolean bl;
                    this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                    ExcessiveLoggingHandler handleAclCreateResult_excessiveLoggingHandler = new ExcessiveLoggingHandler();
                    IntRef handleAclCreateResult_aclsFailedToCreateCount = IntRef.create((int)0);
                    ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        ClusterLinkSyncAcls.$anonfun$handleAclCreateResult$1(this, handleAclCreateResult_aclsFailedToCreateCount, handleAclCreateResult_excessiveLoggingHandler, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    if (handleAclCreateResult_aclsFailedToCreateCount.elem > 0) {
                        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to create ").append(aclsFailedToCreateCount$1.elem).append(" ACLs. Did not log the errors for ").append(handleAclCreateResult_excessiveLoggingHandler.ignoredWarnLogCount()).append(" ").append("of them to prevent excessive logging.").toString());
                        if (this.tasksOutstanding() != 0) {
                            throw new IllegalStateException(new StringBuilder(42).append("Failed to create ACLs but there are still ").append(this.tasksOutstanding()).toString());
                        }
                        bl = true;
                    } else {
                        callBack.apply$mcV$sp();
                        bl = this.tasksOutstanding() == 0;
                    }
                    return bl;
                });
                this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
                return;
            }
            catch (Throwable e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to create ACLs on destination cluster", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> createAcls_e);
                this.metrics.aclsAddFailedSensor().record((double)aclsToCreate.size());
                return;
            }
        }
        callBack.apply$mcV$sp();
    }

    private boolean handleAclCreateResult(CreateAclsResult createAclsResult, Function0<BoxedUnit> callBack) {
        this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
        ExcessiveLoggingHandler excessiveLoggingHandler = new ExcessiveLoggingHandler();
        IntRef aclsFailedToCreateCount = IntRef.create((int)0);
        ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(createAclsResult.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkSyncAcls.$anonfun$handleAclCreateResult$1(this, handleAclCreateResult_aclsFailedToCreateCount, handleAclCreateResult_excessiveLoggingHandler, x0$1);
            return BoxedUnit.UNIT;
        });
        if (aclsFailedToCreateCount.elem > 0) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(89).append("Failed to create ").append(aclsFailedToCreateCount$1.elem).append(" ACLs. Did not log the errors for ").append(handleAclCreateResult_excessiveLoggingHandler.ignoredWarnLogCount()).append(" ").append("of them to prevent excessive logging.").toString());
            if (this.tasksOutstanding() != 0) {
                throw new IllegalStateException(new StringBuilder(42).append("Failed to create ACLs but there are still ").append(this.tasksOutstanding()).toString());
            }
            return true;
        }
        callBack.apply$mcV$sp();
        return this.tasksOutstanding() == 0;
    }

    public int currentTasksOutstanding() {
        return this.tasksOutstanding();
    }

    public void tasksOutstanding_(int t) {
        this.tasksOutstanding_$eq(t);
    }

    public int currentNumSecurityDisabledExceptions() {
        return this.numSecurityDisabledExceptions();
    }

    public boolean isInitialized() {
        return this.initialized();
    }

    public static final /* synthetic */ void $anonfun$updateAcls$2(ClusterLinkSyncAcls $this, ListBuffer aclFilterList$2, scala.collection.immutable.Set sourceAcls$1, Authorizer auth) {
        scala.collection.immutable.Set<AclBinding> currentDestAcls = $this.currentDestAclsWithLinkId(auth, (Buffer<AclBindingFilter>)aclFilterList$2);
        scala.collection.immutable.Set deletedAcls = (scala.collection.immutable.Set)currentDestAcls.diff((GenSet)sourceAcls$1);
        scala.collection.immutable.Set addedAcls = (scala.collection.immutable.Set)sourceAcls$1.diff(currentDestAcls);
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Removing following ACLs on destination cluster: ").append(deletedAcls).toString());
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Adding following ACLs on destination cluster: ").append(addedAcls).toString());
        $this.deleteThenAddAcls((scala.collection.immutable.Set<AclBinding>)addedAcls, (scala.collection.immutable.Set<AclBinding>)deletedAcls, false);
    }

    public static final /* synthetic */ boolean $anonfun$deleteThenAddAcls$6(ClusterLinkSyncAcls $this, DeleteAclsResult deleteAclsResult$1, Function0 createAclsCallback$1) {
        return $this.handleAclDeleteResult(deleteAclsResult$1, (Function0<BoxedUnit>)createAclsCallback$1);
    }

    public static final /* synthetic */ void $anonfun$handleAclDeleteResult$2(ClusterLinkSyncAcls $this, BooleanRef err$1, DeleteAclsResult.FilterResult aclBindingDeleteResult) {
        if (aclBindingDeleteResult.exception() != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Encountered the following exception while trying to delete ACL: ").append((Object)aclBindingDeleteResult.exception()).toString());
            $this.metrics.aclsDeleteFailedSensor().record();
            err$1.elem = true;
            return;
        }
        $this.metrics.aclsDeletedSensor().record();
    }

    public static final /* synthetic */ void $anonfun$handleAclDeleteResult$1(ClusterLinkSyncAcls $this, BooleanRef err$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                java.util.List filters = ((DeleteAclsResult.FilterResults)((KafkaFuture)x0$1._2()).get()).values();
                ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(filters).asScala()).foreach((Function1 & Serializable & scala.Serializable)aclBindingDeleteResult -> {
                    ClusterLinkSyncAcls.$anonfun$handleAclDeleteResult$2($this, err$1, aclBindingDeleteResult);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected error encountered while trying to delete ACL", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                $this.metrics.aclsDeleteFailedSensor().record();
                err$1.elem = true;
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$handleAclCreateResult$1(ClusterLinkSyncAcls $this, IntRef aclsFailedToCreateCount$1, ExcessiveLoggingHandler excessiveLoggingHandler$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            try {
                ((KafkaFuture)x0$1._2()).get();
                $this.metrics.aclsAddedSensor().record();
                return;
            }
            catch (Throwable throwable) {
                $this.metrics.aclsAddFailedSensor().record();
                ++aclsFailedToCreateCount$1.elem;
                excessiveLoggingHandler$1.handle(throwable, $this, "Unexpected error encountered while trying to create ACL");
                return;
            }
        }
        throw new MatchError(null);
    }

    public ClusterLinkSyncAcls(ClusterLinkDestClientManager clientManager, ClusterLinkData linkData, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics, AclBindingFilterTransformer aclBindingFilterTransformer, boolean aclFilterWithResourceIdPrincipal) {
        this.clientManager = clientManager;
        this.linkData = linkData;
        this.metadataManager = metadataManager;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        this.aclBindingFilterTransformer = aclBindingFilterTransformer;
        this.aclFilterWithResourceIdPrincipal = aclFilterWithResourceIdPrincipal;
        super(clientManager.scheduler(), "ClusterLinkSyncAcls", Predef$.MODULE$.Integer2int(clientManager.currentConfig().aclSyncMs()));
        this.logIdent_$eq(new StringBuilder(23).append("[ClusterLinkSyncAcls-").append(linkData.linkName()).append("] ").toString());
        this.config = clientManager.currentConfig();
        this.linkId = linkData.linkId();
        this.linkName = linkData.linkName();
        this.aclLinkIdSet = Collections.singleton(this.linkId());
        this.tasksOutstanding = 0;
        this.initialized = false;
        this.numSecurityDisabledExceptions = 0;
        this.destAdmin = (ConfluentAdmin)destAdminFactory.apply();
    }
}

