/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncOffsets$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.CommittedOffsetTopicPartition;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.LocalMirrorTopic;
import kafka.server.link.MatchedGroup;
import kafka.server.link.RegularTopic;
import kafka.server.link.RemoteLinkMetadata;
import kafka.server.link.RemoteMirrorTopic;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicType$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]x!\u0002\u001b6\u0011\u0003ad!\u0002 6\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005b\u0002%\u0002\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0006\u0001\u000b\u0011\u0002&\t\u000f9\u000b!\u0019!C\u0001\u001f\"1Q,\u0001Q\u0001\nACqAX\u0001C\u0002\u0013\u0005q\f\u0003\u0004d\u0003\u0001\u0006I\u0001Y\u0003\u0005I\u0006\u0001QMB\u0003?k\u0001\t\u0019\u0002\u0003\u0006\u0002$)\u0011)\u0019!C\u0001\u0003KA!\"!\f\u000b\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011)\tyC\u0003BC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003sQ!\u0011!Q\u0001\n\u0005M\u0002BCA\u001e\u0015\t\u0005\t\u0015!\u0003\u0002>!Q\u0011\u0011\n\u0006\u0003\u0006\u0004%\t!a\u0013\t\u0015\u0005e#B!A!\u0002\u0013\ti\u0005\u0003\u0006\u0002\\)\u0011\t\u0011)A\u0005\u0003;BaA\u0012\u0006\u0005\u0002\u0005\r\u0004\"CA9\u0015\u0001\u0007I\u0011BA:\u0011%\tYH\u0003a\u0001\n\u0013\ti\b\u0003\u0005\u0002\n*\u0001\u000b\u0015BA;\u0011!\tYI\u0003a\u0001\n\u0013I\u0005\"CAG\u0015\u0001\u0007I\u0011BAH\u0011\u001d\t\u0019J\u0003Q!\n)C\u0011\"!&\u000b\u0001\u0004%I!a&\t\u0013\u0005\u0015&\u00021A\u0005\n\u0005\u001d\u0006\u0002CAV\u0015\u0001\u0006K!!'\t\u0013\u00055&B1A\u0005\n\u0005=\u0006\u0002CA\\\u0015\u0001\u0006I!!-\t\u000f\u0005e&\u0002\"\u0015\u0002<\"9\u00111\u0019\u0006\u0005\n\u0005m\u0006bBAc\u0015\u0011%\u00111\u0018\u0005\b\u0003\u000fTA\u0011BAe\u0011\u001d\t\u0019O\u0003C\u0005\u0003KDq!!=\u000b\t\u0013\t\u0019\u0010C\u0004\u0003\b)!IA!\u0003\t\u000f\tu!\u0002\"\u0003\u0003 !9!1\u0005\u0006\u0005\n\t\u0015\u0002b\u0002B\u0018\u0015\u0011%!\u0011\u0007\u0005\b\u0005wQA\u0011\u0002B\u001f\u0011\u001d\u0011YG\u0003C\u0005\u0005[BqAa\"\u000b\t\u0013\u0011I\tC\u0004\u0003\u001c*!IA!(\t\u000f\t\u0015&\u0002\"\u0003\u0003(\"9!q\u0017\u0006\u0005\n\te\u0006b\u0002Ba\u0015\u0011%!1\u0019\u0005\b\u0005;TA\u0011\u0002Bp\u0011\u001d\u0011\tO\u0003C\u0005\u0005?DqAa\t\u000b\t#\u0011\u0019\u000fC\u0004\u0003t*!IA!>\u0002-\rcWo\u001d;fe2Kgn[*z]\u000e|eMZ:fiNT!AN\u001c\u0002\t1Lgn\u001b\u0006\u0003qe\naa]3sm\u0016\u0014(\"\u0001\u001e\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q(A\u0007\u0002k\t12\t\\;ti\u0016\u0014H*\u001b8l'ft7m\u00144gg\u0016$8o\u0005\u0002\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001f\u0002A1K7\u000f^\"p]N,X.\u001a:He>,\bo\u00144gg\u0016$()\u0019;dQNK'0Z\u000b\u0002\u0015B\u0011\u0011iS\u0005\u0003\u0019\n\u00131!\u00138u\u0003\u0005b\u0015n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,GOQ1uG\"\u001c\u0016N_3!\u0003ma\u0015n\u001d;PM\u001a\u001cX\r^:G_J\fE\u000e\u001c)beRLG/[8ogV\t\u0001\u000b\u0005\u0002R76\t!K\u0003\u0002T)\u0006)\u0011\rZ7j]*\u0011QKV\u0001\bG2LWM\u001c;t\u0015\tQtK\u0003\u0002Y3\u00061\u0011\r]1dQ\u0016T\u0011AW\u0001\u0004_J<\u0017B\u0001/S\u0005qa\u0015n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go]*qK\u000e\fA\u0004T5ti>3gm]3ug\u001a{'/\u00117m!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\nMSN$xJ\u001a4tKR\u001cx\n\u001d;j_:\u001cX#\u00011\u0011\u0005E\u000b\u0017B\u00012S\u0005}a\u0015n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go](qi&|gn]\u0001\u0014\u0019&\u001cHo\u00144gg\u0016$8o\u00149uS>t7\u000f\t\u0002\u000e\u001f\u001a47/\u001a;GkR,(/Z:\u0011\t\u0019l\u0007o\u001d\b\u0003O.\u0004\"\u0001\u001b\"\u000e\u0003%T!A[\u001e\u0002\rq\u0012xn\u001c;?\u0013\ta')\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u00141!T1q\u0015\ta'\t\u0005\u0002>c&\u0011!/\u000e\u0002\r\u001b\u0006$8\r[3e\u000fJ|W\u000f\u001d\t\u0004i^LX\"A;\u000b\u0005Y4\u0016AB2p[6|g.\u0003\u0002yk\nY1*\u00194lC\u001a+H/\u001e:f!\u0019Qx0!\u0001\u0002\b5\t1P\u0003\u0002}{\u0006!Q\u000f^5m\u0015\u0005q\u0018\u0001\u00026bm\u0006L!A\\>\u0011\u0007Q\f\u0019!C\u0002\u0002\u0006U\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti\u0001V\u0001\tG>t7/^7fe&!\u0011\u0011CA\u0006\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/Y\n\u0004\u0015\u0005U\u0001\u0003BA\f\u0003;q1!PA\r\u0013\r\tY\"N\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\t\u0005}\u0011\u0011\u0005\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0004\u00037)\u0014!D2mS\u0016tG/T1oC\u001e,'/\u0006\u0002\u0002(A\u0019Q(!\u000b\n\u0007\u0005-RG\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u00024A\u0019Q(!\u000e\n\u0007\u0005]RG\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005AA.\u001b8l\t\u0006$\u0018\r\u0005\u0003\u0002@\u0005\u0015SBAA!\u0015\r\t\u0019%O\u0001\u0003u.LA!a\u0012\u0002B\ty1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-\u0001\teKN$\u0018\tZ7j]\u001a\u000b7\r^8ssV\u0011\u0011Q\n\t\u0006\u0003\u0006=\u00131K\u0005\u0004\u0003#\u0012%!\u0003$v]\u000e$\u0018n\u001c81!\r\t\u0016QK\u0005\u0004\u0003/\u0012&AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0012I\u0016\u001cH/\u00113nS:4\u0015m\u0019;pef\u0004\u0013aB7fiJL7m\u001d\t\u0004{\u0005}\u0013bAA1k\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t)1\t)'a\u001a\u0002j\u0005-\u0014QNA8!\ti$\u0002C\u0004\u0002$M\u0001\r!a\n\t\u000f\u0005=2\u00031\u0001\u00024!9\u00111H\nA\u0002\u0005u\u0002bBA%'\u0001\u0007\u0011Q\n\u0005\b\u00037\u001a\u0002\u0019AA/\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u000f\t\u0004{\u0005]\u0014bAA=k\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\u0005\u0015\u0005cA!\u0002\u0002&\u0019\u00111\u0011\"\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000f+\u0012\u0011!a\u0001\u0003k\n1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0001\u0003^1tWN|U\u000f^:uC:$\u0017N\\4\u0002)Q\f7o[:PkR\u001cH/\u00198eS:<w\fJ3r)\u0011\ty(!%\t\u0011\u0005\u001d\u0005$!AA\u0002)\u000b\u0011\u0003^1tWN|U\u000f^:uC:$\u0017N\\4!\u0003I\u0011X-\\8uK2Kgn['fi\u0006$\u0017\r^1\u0016\u0005\u0005e\u0005#B!\u0002\u001c\u0006}\u0015bAAO\u0005\n1q\n\u001d;j_:\u00042!PAQ\u0013\r\t\u0019+\u000e\u0002\u0013%\u0016lw\u000e^3MS:\\W*\u001a;bI\u0006$\u0018-\u0001\fsK6|G/\u001a'j].lU\r^1eCR\fw\fJ3r)\u0011\ty(!+\t\u0013\u0005\u001d5$!AA\u0002\u0005e\u0015a\u0005:f[>$X\rT5oW6+G/\u00193bi\u0006\u0004\u0013A\u00063fg\u000e\u0014\u0018NY3NSJ\u0014xN]:PaRLwN\\:\u0016\u0005\u0005E\u0006cA)\u00024&\u0019\u0011Q\u0017*\u0003-\u0011+7o\u0019:jE\u0016l\u0015N\u001d:peN|\u0005\u000f^5p]N\fq\u0003Z3tGJL'-Z'jeJ|'o](qi&|gn\u001d\u0011\u0002\u0007I,h\u000e\u0006\u0002\u0002>B\u0019\u0011)a0\n\u0007\u0005\u0005'IA\u0004C_>dW-\u00198\u0002\u0017MLhnY(gMN,Go]\u0001/iJL\u0018J\\5uS\u0006d\u0017N_3SK6|G/Z'jeJ|'oU=oG&tw-\u00118e'ft7m\u00144gg\u0016$8/\u0001\u0011uefLe.\u001b;jC2L'0\u001a*f[>$X-T5se>\u00148+\u001f8dS:<GCBA@\u0003\u0017\fI\u000eC\u0004\u0002N\n\u0002\r!a4\u0002\u0011I,7o\\;sG\u0016\u0004B!!5\u0002V6\u0011\u00111\u001b\u0006\u0004\u0003c*\u0018\u0002BAl\u0003'\u0014abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0002\\\n\u0002\r!!8\u0002\rI,7/\u001e7u!\r\t\u0016q\\\u0005\u0004\u0003C\u0014&!\u0006#fg\u000e\u0014\u0018NY3D_:4\u0017nZ:SKN,H\u000e^\u0001\u001fQ\u0006tG\r\\3MSN$8i\u001c8tk6,'o\u0012:pkB\u001c(+Z:vYR$B!!0\u0002h\"9\u0011\u0011^\u0012A\u0002\u0005-\u0018\u0001\u00077jgR\u001cuN\\:v[\u0016\u0014xI]8vaN\u0014Vm];miB\u0019\u0011+!<\n\u0007\u0005=(K\u0001\rMSN$8i\u001c8tk6,'o\u0012:pkB\u001c(+Z:vYR\fACZ5mi\u0016\u00148i\u001c8tk6,'o\u0012:pkB\u001cH\u0003BA{\u0003w\u0004BAZA|a&\u0019\u0011\u0011`8\u0003\u0007M+G\u000fC\u0004\u0002~\u0012\u0002\r!a@\u0002\r\u001d\u0014x.\u001e9t!\u00151\u0017q\u001fB\u0001!\r1'1A\u0005\u0004\u0005\u000by'AB*ue&tw-\u0001\u000fmSN$H)Z:u\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\t\t-!1\u0004\t\u0004\u0005\u001bIab\u0001B\b\u00019!!\u0011\u0003B\r\u001d\u0011\u0011\u0019Ba\u0006\u000f\u0007!\u0014)\"C\u0001;\u0013\tA\u0014(\u0003\u00027o!9\u0011Q`\u0013A\u0002\u0005U\u0018A\b7jgR\u001cv.\u001e:dK\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;t)\u0011\u0011YA!\t\t\u000f\u0005uh\u00051\u0001\u0002v\u0006AB.[:u\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:\u0015\u0011\t-!q\u0005B\u0015\u0005WAq!!@(\u0001\u0004\t)\u0010\u0003\u0004TO\u0001\u0007\u00111\u000b\u0005\b\u0005[9\u0003\u0019AA_\u0003!I7oU8ve\u000e,\u0017A\u00075b]\u0012dWmU8ve\u000e,\u0017I\u001c3EKN$xJ\u001a4tKR\u001cHCBA_\u0005g\u00119\u0004C\u0004\u00036!\u0002\rAa\u0003\u0002'M|WO]2f\u001f\u001a47/\u001a;GkR,(/Z:\t\u000f\te\u0002\u00061\u0001\u0003\f\u0005\tB-Z:u\u001f\u001a47/\u001a;GkR,(/Z:\u0002a5\f\u0007\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eV8D_6l\u0017\u000e\u001e;fI>3gm]3u)>\u0004\u0018n\u0019)beRLG/[8o)\u0019\u0011yD!\u0013\u0003RA1a-\u001cB\u0001\u0005\u0003\u0002bAZ7\u0003D\u0005\u001d\u0001cA\u001f\u0003F%\u0019!qI\u001b\u0003;\r{W.\\5ui\u0016$wJ\u001a4tKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\u0013*\u0001\u0004\u0011i%A\u0007t_V\u00148-Z(gMN,Go\u001d\t\u0006M6\u0004(q\n\t\u0007M6\f\t!a\u0002\t\u000f\u0005U\u0015\u00061\u0001\u0003TA9\u0011I!\u0016\u0003Z\t%\u0014b\u0001B,\u0005\n1A+\u001e9mKJ\u0002bAZ7\u0003\u0002\tm\u0003\u0003\u0002B/\u0005Gr1!\u0015B0\u0013\r\u0011\tGU\u0001\u0017\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]&!!Q\rB4\u0005\u0015\u0019F/\u0019;f\u0015\r\u0011\tG\u0015\t\u0006\u0003\u0006m%\u0011A\u0001\u0016Q\u0006tG\r\\3EKN\u001c'/\u001b2f\u001b&\u0014(o\u001c:t))\tiLa\u001c\u0003r\tU$1\u0011\u0005\b\u0005\u0017R\u0003\u0019\u0001B'\u0011\u001d\u0011\u0019H\u000ba\u0001\u0005\u001b\n1\u0002Z3ti>3gm]3ug\"9!q\u000f\u0016A\u0002\te\u0014!\u00063fg\u000e\u0014\u0018NY3NSJ\u0014xN]:GkR,(/\u001a\t\u0007M6\u0014\tAa\u001f\u0011\tQ<(Q\u0010\t\u0004#\n}\u0014b\u0001BA%\n1R*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0003\u0006*\u0002\rA!\u001b\u0002\u0019I,Wn\u001c;f!J,g-\u001b=\u0002?Q|7i\\7nSR$X\rZ(gMN,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0006\u0003D\t-%q\u0012BJ\u00053CaA!$,\u0001\u0004\u0001\u0018!B4s_V\u0004\bb\u0002BIW\u0001\u0007\u0011\u0011A\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\u0011)j\u000ba\u0001\u0005/\u000baC]3n_R,W*\u001b:s_J$v\u000e]5d'R\fG/\u001a\t\u0006\u0003\u0006m%1\f\u0005\b\u0005\u000b[\u0003\u0019\u0001B5\u00035\u0019w.\\7ji>3gm]3ugR1\u0011Q\u0018BP\u0005CCqAa\u0013-\u0001\u0004\u0011y\u0004C\u0004\u0003t1\u0002\rAa)\u0011\r\u0019l'\u0011\u0001B(\u0003!B\u0017M\u001c3mK\u0012+7\u000f^5oCRLwN\\\"mkN$XM]\"p[6LG\u000f^3e\u001f\u001a47/\u001a;t)\u0019\tiL!+\u00036\"9!1V\u0017A\u0002\t5\u0016!D2p[6LGOU3tk2$8\u000f\u0005\u0004g[\n\u0005!q\u0016\t\u0004#\nE\u0016b\u0001BZ%\ny\u0012\t\u001c;fe\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;t%\u0016\u001cX\u000f\u001c;\t\u000f\t-S\u00061\u0001\u0003@\u00059qN\u001a4tKR\u001cHC\u0002B(\u0005w\u0013y\f\u0003\u0004\u0003>:\u0002\ra]\u0001\u0007MV$XO]3\t\u000f\t5b\u00061\u0001\u0002>\u0006\trN\u001a4tKR4U\r^2i\r\u0006LG.\u001a3\u0015\r\u0005}$Q\u0019Bd\u0011\u001d\u0011ic\fa\u0001\u0003{CqA!30\u0001\u0004\u0011Y-A\u0001f!\u0011\u0011iMa6\u000f\t\t='1\u001b\b\u0004Q\nE\u0017\"A\"\n\u0007\tU')A\u0004qC\u000e\\\u0017mZ3\n\t\te'1\u001c\u0002\n)\"\u0014xn^1cY\u0016T1A!6C\u0003-\u0019x.\u001e:dK\u0006#W.\u001b8\u0016\u0005\u0005M\u0013!\u00033fgR\fE-\\5o)\u0019\u0011)Oa;\u0003nB\u0019\u0011Ka:\n\u0007\t%(K\u0001\u0010MSN$8i\u001c8tk6,'o\u0012:pkB|eMZ:fiN\u0014Vm];mi\"11K\ra\u0001\u0003'BqAa<3\u0001\u0004\u0011\t0\u0001\u0006he>,\bo\u00159fGN\u0004RA_@\u0003\u0002A\u000b\u0001eY8oM&<WO]3e)>Len\u00197vI\u0016\u0014V-\\8uK6K'O]8sgV\u0011\u0011Q\u0018")
public class ClusterLinkSyncOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final Function0<ConfluentAdmin> destAdminFactory;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private int tasksOutstanding;
    private Option<RemoteLinkMetadata> remoteLinkMetadata;
    private final DescribeMirrorsOptions describeMirrorsOptions;

    public static ListConsumerGroupOffsetsOptions ListOffsetsOptions() {
        return ClusterLinkSyncOffsets$.MODULE$.ListOffsetsOptions();
    }

    public static ListConsumerGroupOffsetsSpec ListOffsetsForAllPartitions() {
        return ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions();
    }

    public static int ListConsumerGroupOffsetBatchSize() {
        return ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    public Function0<ConfluentAdmin> destAdminFactory() {
        return this.destAdminFactory;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private Option<RemoteLinkMetadata> remoteLinkMetadata() {
        return this.remoteLinkMetadata;
    }

    private void remoteLinkMetadata_$eq(Option<RemoteLinkMetadata> x$1) {
        this.remoteLinkMetadata = x$1;
    }

    private DescribeMirrorsOptions describeMirrorsOptions() {
        return this.describeMirrorsOptions;
    }

    @Override
    public boolean run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().consumerOffsetSyncEnable()) {
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Number of outstanding tasks was ").append(this.tasksOutstanding()).append(" at the beginning of run. Resetting to 0 and continuing on.").toString());
                this.tasksOutstanding_$eq(0);
            }
            if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isEmpty()) {
                this.tryInitializeRemoteMirrorSyncingAndSyncOffsets();
            } else {
                this.syncOffsets();
            }
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean syncOffsets() {
        if (this.config().consumerGroupFilters().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is true but no consumer group filters are specified. No consumer offsets will be migrated.").toString());
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to retrieve consumer groups from source cluster");
            ListConsumerGroupsResult listConsumerGroupsResult = this.sourceAdmin().listConsumerGroups();
            this.scheduleWhenComplete(listConsumerGroupsResult.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleListConsumerGroupsResult(listConsumerGroupsResult);
            });
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean tryInitializeRemoteMirrorSyncingAndSyncOffsets() {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkData.linkName());
        DescribeConfigsResult result = this.sourceAdmin().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava(), new DescribeConfigsOptions());
        this.scheduleWhenComplete(result.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            this.tryInitializeRemoteMirrorSyncing(resource, result);
            return this.syncOffsets();
        });
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return this.tasksOutstanding() == 0;
    }

    private void tryInitializeRemoteMirrorSyncing(ConfigResource resource, DescribeConfigsResult result) {
        Some some;
        KafkaFuture configFuture = (KafkaFuture)result.values().get(resource);
        if (configFuture == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Failed to find link ").append(this.linkData.linkName()).append(" in the response.").toString());
        }
        try {
            some = new Some(configFuture.get());
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof ApiException)) {
                throw throwable;
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Failed to find link on the remote cluster for bi-directional link ").append($this.linkData.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> executionException);
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        some.foreach((Function1 & Serializable & scala.Serializable)linkConfig -> {
            ClusterLinkSyncOffsets.$anonfun$tryInitializeRemoteMirrorSyncing$3(this, linkConfig);
            return BoxedUnit.UNIT;
        });
    }

    private boolean handleListConsumerGroupsResult(ListConsumerGroupsResult listConsumerGroupsResult) {
        boolean bl;
        try {
            scala.collection.immutable.Set<MatchedGroup> filteredGroups = this.filterConsumerGroups((scala.collection.immutable.Set<String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)listConsumerGroupsResult.all().get()).asScala()).map((Function1 & Serializable & scala.Serializable)result -> result.groupId(), Iterable$.MODULE$.canBuildFrom())).toSet());
            scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures = this.listDestConsumerGroupOffsets(filteredGroups);
            scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures = this.listSourceConsumerGroupOffsets(filteredGroups);
            if (!sourceOffsetFutures.nonEmpty()) {
                return true;
            }
            Iterable futures = (Iterable)sourceOffsetFutures.values().$plus$plus((GenTraversableOnce)destOffsetFutures.values(), Iterable$.MODULE$.canBuildFrom());
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleSourceAndDestOffsets(sourceOffsetFutures, destOffsetFutures);
            });
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            bl = false;
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to list consumer group offsets. Offsets will not be migrated.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.metrics.listConsumerGroupsFromSourceFailedSensor().record();
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<MatchedGroup> filterConsumerGroups(scala.collection.immutable.Set<String> groups) {
        void var5_5;
        void var4_4;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Filtering consumer groups ").append(groups).append(" to match consumer group JSON").toString());
        Option<String> clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPrefixConsumerGroupEnable()) ? this.config().clusterLinkPrefix() : None$.MODULE$;
        Tuple2<scala.collection.immutable.Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.config().consumerGroupFilters(), this.linkData.tenantPrefix(), clusterLinkPrefix, this.config().linkMode());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        void filtered2 = var4_4;
        var5_5.foreach((Function1 & Serializable & scala.Serializable)unusedFilter -> {
            ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$2(this, unusedFilter);
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$4((scala.collection.immutable.Set)filtered2)));
        return filtered2;
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listDestConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.destAdmin(), false);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listSourceConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.sourceAdmin(), true);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups, ConfluentAdmin admin, boolean isSource) {
        String targetCluster = isSource ? "source" : "destination";
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Listing consumer group offsets on ").append(targetCluster).append(" cluster for following consumer groups: ").append(groups).toString());
        scala.collection.mutable.Map groupFutures = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            groups.grouped(ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$2(this, targetCluster, admin, groupFutures, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            this.offsetFetchFailed(isSource, ex);
        }
        return groupFutures.toMap(Predef$.MODULE$.$conforms());
    }

    private boolean handleSourceAndDestOffsets(scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures) {
        scala.collection.immutable.Map sourceOffsets = (scala.collection.immutable.Map)sourceOffsetFutures.map((Function1 & Serializable & scala.Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(keyVal._1()), this.offsets((KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)keyVal._2()), true)), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map destOffsets = (scala.collection.immutable.Map)destOffsetFutures.map((Function1 & Serializable & scala.Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(keyVal._1()), this.offsets((KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)keyVal._2()), false)), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isDefined()) {
            Option<String> remotePrefix = ((RemoteLinkMetadata)this.remoteLinkMetadata().get()).remotePrefix();
            scala.collection.immutable.Set topics = (scala.collection.immutable.Set)((scala.collection.immutable.MapLike)sourceOffsets.flatMap((Function1 & Serializable & scala.Serializable)x$5 -> (scala.collection.immutable.Map)x$5._2(), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).keySet().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topic(), Set$.MODULE$.canBuildFrom());
            DescribeMirrorsResult describeMirrorsResult = this.sourceAdmin().describeMirrors((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)topics).asJava(), this.describeMirrorsOptions());
            this.scheduleWhenComplete(describeMirrorsResult.all(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleDescribeMirrors((scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)sourceOffsets, (scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)destOffsets, (scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(describeMirrorsResult.result()).asScala()).toMap(Predef$.MODULE$.$conforms()), remotePrefix);
            });
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        } else {
            this.commitOffsets(this.mapTopicPartitionToCommittedOffsetTopicPartition((scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)sourceOffsets, (Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)None$.MODULE$)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)destOffsets.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((MatchedGroup)kv._1()).name(), kv._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
        }
        return this.tasksOutstanding() == 0;
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> mapTopicPartitionToCommittedOffsetTopicPartition(scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>> remoteLinkMetadata) {
        return (scala.collection.immutable.Map)sourceOffsets.map((Function1 & Serializable & scala.Serializable)groupToTopicPartitionToOffsetMetadata -> {
            scala.collection.immutable.Map mappedTopicPartitionAndOffsetMetadataMap = (scala.collection.immutable.Map)((TraversableLike)groupToTopicPartitionToOffsetMetadata._2()).map((Function1 & Serializable & scala.Serializable)topicPartitionToOffsetMetadata -> {
                TopicPartition topicPartition = (TopicPartition)topicPartitionToOffsetMetadata._1();
                String sourceTopicName = topicPartition.topic();
                return new Tuple2((Object)this.toCommittedOffsetTopicPartition((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1(), topicPartition, (Option<MirrorTopicDescription.State>)((MapLike)remoteLinkMetadata._1()).get((Object)sourceTopicName), (Option<String>)((Option)remoteLinkMetadata._2())), topicPartitionToOffsetMetadata._2());
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return new Tuple2((Object)((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1()).name(), (Object)mappedTopicPartitionAndOffsetMetadataMap);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    private boolean handleDescribeMirrors(scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets, scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>> describeMirrorsFuture, Option<String> remotePrefix) {
        scala.collection.immutable.Map remoteMirrors = (scala.collection.immutable.Map)((scala.collection.immutable.Map)describeMirrorsFuture.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MirrorTopicDescription mirrorTopicDescription;
            String topic;
            if (x0$1 != null) {
                topic = (String)x0$1._1();
                try {
                    mirrorTopicDescription = (MirrorTopicDescription)((KafkaFuture)x0$1._2()).get();
                }
                catch (Throwable throwable) {
                    ExecutionException executionException;
                    if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof ApiException)) {
                        throw throwable;
                    }
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get remote mirror.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> executionException);
                    mirrorTopicDescription = null;
                }
            } else {
                throw new MatchError(null);
            }
            MirrorTopicDescription desc = mirrorTopicDescription;
            Iterable iterable = desc != null ? Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)desc))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Iterable iterable;
            if (x0$2 != null) {
                String topic = (String)x0$2._1();
                MirrorTopicDescription desc = (MirrorTopicDescription)x0$2._2();
                if (desc.linkName().equals($this.linkData.linkName()) && desc.clusterLinkId().equals((Object)$this.linkData.linkId())) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)desc.state())));
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Filtering out ").append(topic).append(" from a different link ").append(desc.linkName()).append(" ").append(desc.clusterLinkId()).append(".").toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError(null);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return this.commitOffsets(this.mapTopicPartitionToCommittedOffsetTopicPartition(sourceOffsets, (Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>)new Tuple2((Object)remoteMirrors, remotePrefix)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)destOffsets.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((MatchedGroup)kv._1()).name(), kv._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
    }

    private CommittedOffsetTopicPartition toCommittedOffsetTopicPartition(MatchedGroup group, TopicPartition topicPartition, Option<MirrorTopicDescription.State> remoteMirrorTopicState, Option<String> remotePrefix) {
        boolean isRemoteMirror = remoteMirrorTopicState.isDefined();
        Option localMirrorTopicsState = this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicPartition.topic()})))).get((Object)topicPartition.topic());
        boolean isLocalMirror = localMirrorTopicsState.isDefined();
        if (isRemoteMirror && isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, (Option<TopicLinkState>)new Some((Object)((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, (Option<TopicLinkState>)new Some((Object)((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isRemoteMirror) {
            return new RemoteMirrorTopic(topicPartition, (MirrorTopicDescription.State)remoteMirrorTopicState.get(), this.linkData, this.config().clusterLinkPrefix(), remotePrefix, group);
        }
        return new RegularTopic(topicPartition);
    }

    private boolean commitOffsets(scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets) {
        scala.collection.immutable.Map commitResults = (scala.collection.immutable.Map)sourceOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            if (x0$1 != null) {
                scala.collection.immutable.Map map;
                String consumerGroup = (String)x0$1._1();
                scala.collection.immutable.Map offsetMetadata = (scala.collection.immutable.Map)x0$1._2();
                Option option = destOffsets.get((Object)consumerGroup);
                if (option instanceof Some) {
                    map = (scala.collection.immutable.Map)((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    map = Predef$.MODULE$.Map().empty();
                } else {
                    throw new MatchError((Object)option);
                }
                scala.collection.immutable.Map offsetsToCommit = (scala.collection.immutable.Map)offsetMetadata.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$commitOffsets$2(this, consumerGroup, map, x0$2)));
                if (offsetsToCommit.nonEmpty()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Committing offsets on destination cluster for consumer group ").append(consumerGroup).append(": ").append(offsetsToCommit).toString());
                    scala.collection.immutable.Map offsetAndMetadataToCommit = (scala.collection.immutable.Map)offsetsToCommit.map((Function1 & Serializable & scala.Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((CommittedOffsetTopicPartition)keyVal._1()).destTopic()), keyVal._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)consumerGroup), (Object)this.destAdmin().alterConsumerGroupOffsets(consumerGroup, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetAndMetadataToCommit).asJava()))));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError(null);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (commitResults.nonEmpty()) {
            this.handleDestinationClusterCommittedOffsets((scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult>)commitResults, sourceOffsets);
        }
        return this.tasksOutstanding() == 0;
    }

    private boolean handleDestinationClusterCommittedOffsets(scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> commitResults, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets) {
        KafkaFuture allCommitFutures = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((TraversableOnce)commitResults.values().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.all(), Iterable$.MODULE$.canBuildFrom())).toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(allCommitFutures, (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            commitResults.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ClusterLinkSyncOffsets.$anonfun$handleDestinationClusterCommittedOffsets$3(this, sourceOffsets, x0$1);
                return BoxedUnit.UNIT;
            });
            return this.tasksOutstanding() == 0;
        });
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return this.tasksOutstanding() == 0;
    }

    private scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets(KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>> future, boolean isSource) {
        try {
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)future.get()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e._1()), e._2()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (ExecutionException ex) {
            this.offsetFetchFailed(isSource, ex);
            return Predef$.MODULE$.Map().empty();
        }
    }

    private void offsetFetchFailed(boolean isSource, Throwable e) {
        if (isSource) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to list consumer group offsets on source cluster. Offsets will not be migrated.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.metrics.listConsumerGroupOffsetsFromSourceFailedSensor().record();
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to list consumer group offsets on destination cluster. All available source offsets will be committed.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        this.metrics.listConsumerGroupOffsetsFromDestinationFailedSensor().record();
    }

    private ConfluentAdmin sourceAdmin() {
        return this.clientManager().getAdmin();
    }

    private ConfluentAdmin destAdmin() {
        return (ConfluentAdmin)this.destAdminFactory().apply();
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(ConfluentAdmin admin, java.util.Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        return admin.listConsumerGroupOffsets(groupSpecs, ClusterLinkSyncOffsets$.MODULE$.ListOffsetsOptions());
    }

    private boolean configuredToIncludeRemoteMirrors() {
        return this.config().linkMode().equals((Object)ClusterLinkConfig.LinkMode.BIDIRECTIONAL) && this.config().consumerGroupFilters().exists((Function1 & Serializable & scala.Serializable)groupFiltersJson -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$1(this, groupFiltersJson)));
    }

    public static final /* synthetic */ boolean $anonfun$tryInitializeRemoteMirrorSyncing$5(String x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$tryInitializeRemoteMirrorSyncing$6(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$tryInitializeRemoteMirrorSyncing$3(ClusterLinkSyncOffsets $this, Config linkConfig) {
        ConfigEntry prefix = linkConfig.get(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp());
        Option remotePrefix = Option$.MODULE$.apply((Object)prefix).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.value()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$tryInitializeRemoteMirrorSyncing$5(x$2))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$tryInitializeRemoteMirrorSyncing$6(x$3)));
        $this.remoteLinkMetadata_$eq((Option<RemoteLinkMetadata>)new Some((Object)new RemoteLinkMetadata((Option<String>)remotePrefix)));
    }

    public static final /* synthetic */ void $anonfun$filterConsumerGroups$2(ClusterLinkSyncOffsets $this, ClusterLinkFilterInfo unusedFilter) {
        String string = unusedFilter.configuredFilter().filterType();
        String string2 = "EXCLUDE";
        if (string == null || !string.equals(string2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(199).append("The filter ").append(unusedFilter).append(" does not match any consumer group. This filter may not be ").append("required or the groups it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$filterConsumerGroups$4(scala.collection.immutable.Set filtered$1) {
        return new StringBuilder(26).append("Filtered consumer groups: ").append(filtered$1).toString();
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$5(ListConsumerGroupOffsetsResult result$2, scala.collection.mutable.Map groupFutures$1, MatchedGroup group) {
        Option$.MODULE$.apply((Object)result$2.partitionsToOffsetAndMetadata(group.name())).foreach((Function1 & Serializable & scala.Serializable)offsets -> (scala.collection.mutable.Map)groupFutures$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), offsets)));
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$2(ClusterLinkSyncOffsets $this, String targetCluster$1, ConfluentAdmin admin$1, scala.collection.mutable.Map groupFutures$1, scala.collection.immutable.Set batch) {
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Listing consumer group offsets on ").append(targetCluster$1).append(" cluster for following consumer groups: ").append(batch).toString());
        java.util.Map groupMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)g -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)g.name()), (Object)ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        ListConsumerGroupOffsetsResult result = $this.listConsumerGroupOffsets(admin$1, groupMap);
        batch.foreach((Function1 & Serializable & scala.Serializable)group -> {
            ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$5(result, groupFutures$1, group);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$commitOffsets$3(CommittedOffsetTopicPartition tp$1, String reason$1) {
        return new StringBuilder(36).append("Not committing offsets for ").append(tp$1).append(" because ").append(reason$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$5(OffsetAndMetadata sourceOffset$1, OffsetAndMetadata destOffset) {
        return destOffset.offset() == sourceOffset$1.offset();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$commitOffsets$2(ClusterLinkSyncOffsets $this, String consumerGroup$1, scala.collection.immutable.Map destTopicPartition$1, Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            void var8_7;
            CommittedOffsetTopicPartition tp = (CommittedOffsetTopicPartition)x0$2._1();
            OffsetAndMetadata sourceOffset = (OffsetAndMetadata)x0$2._2();
            Tuple2<Object, String> tuple2 = tp.shouldSync();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            boolean shouldSync = tuple2._1$mcZ$sp();
            String reason = (String)tuple2._2();
            if (var8_7 == false) {
                void var9_8;
                $this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ClusterLinkSyncOffsets.$anonfun$commitOffsets$3(tp, (String)var9_8)));
                bl = false;
            } else if (sourceOffset == null) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not committing offsets for ").append(tp).append(" since no committed offset exists on the source cluster for ").append(consumerGroup$1).toString());
                bl = false;
            } else if (destTopicPartition$1.get((Object)tp.destTopic()).exists((Function1 & Serializable & scala.Serializable)destOffset -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$commitOffsets$5(sourceOffset, destOffset)))) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Not committing offsets for ").append(tp).append(" since offset=").append(sourceOffset).append(" is already committed on the destination.").toString());
                bl = false;
            } else {
                bl = true;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$handleDestinationClusterCommittedOffsets$4(ClusterLinkSyncOffsets $this, String group$2, Tuple2 keyVal) {
        if (((CommittedOffsetTopicPartition)keyVal._1()).shouldSync()._1$mcZ$sp()) {
            $this.metrics.consumerOffsetCommitSensor().record();
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Committed offsets on destination cluster for consumer group ").append(group$2).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$handleDestinationClusterCommittedOffsets$3(ClusterLinkSyncOffsets $this, scala.collection.immutable.Map sourceOffsets$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String group = (String)x0$1._1();
            try {
                ((AlterConsumerGroupOffsetsResult)x0$1._2()).all().get();
                ((IterableLike)sourceOffsets$2.apply((Object)group)).foreach((Function1 & Serializable & scala.Serializable)keyVal -> {
                    ClusterLinkSyncOffsets.$anonfun$handleDestinationClusterCommittedOffsets$4($this, group, keyVal);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof GroupAuthorizationException) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(277).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster, due to authorization issues.").append(" Please add READ ACLs for the consumer group. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal.").toString());
                    $this.metrics.consumerOffsetCommitFailedSensor().record();
                    return;
                }
                if (throwable instanceof TopicAuthorizationException) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(284).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster, due to authorization issues.").append(" Please add READ ACLs for the topics being migrated. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal.").toString());
                    $this.metrics.consumerOffsetCommitFailedSensor().record();
                    return;
                }
                if (throwable != null) {
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                    $this.metrics.consumerOffsetCommitFailedSensor().record();
                    return;
                }
                throw new MatchError(null);
            }
            catch (Throwable ex) {
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster.").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                $this.metrics.consumerOffsetCommitFailedSensor().record();
                return;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$2(ClusterLinkSyncOffsets $this, GroupClusterLinkFilter filter) {
        return FilterType$.MODULE$.fromString(filter.filterType()).contains((Object)FilterType$.MODULE$.INCLUDE()) && filter.effectiveTopicTypes($this.config().linkMode()).contains((Object)TopicType$.MODULE$.REMOTE_MIRROR());
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$1(ClusterLinkSyncOffsets $this, GroupFilterJson groupFiltersJson) {
        return groupFiltersJson.filters().exists((Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$2($this, filter)));
    }

    public ClusterLinkSyncOffsets(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, Function0<ConfluentAdmin> destAdminFactory, ClusterLinkMetrics metrics) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.destAdminFactory = destAdminFactory;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkSyncOffsets", Predef$.MODULE$.Integer2int(clientManager.currentConfig().consumerOffsetSyncMs()));
        this.config = clientManager.currentConfig();
        this.tasksOutstanding = 0;
        this.remoteLinkMetadata = None$.MODULE$;
        this.describeMirrorsOptions = new DescribeMirrorsOptions().linkNames(Collections.singleton(linkData.linkName())).states(Collections.singleton(MirrorTopicDescription.State.ACTIVE.name()));
    }
}

