/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeBoolean$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ClusterLinkTopicState$ {
    public static ClusterLinkTopicState$ MODULE$;

    static {
        new ClusterLinkTopicState$();
    }

    public String toJsonString(ClusterLinkTopicState state) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.state().name()), CollectionConverters$.MODULE$.mapAsJavaMapConverter(state.toMap()).asJava())}))).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkTopicState fromJsonString(String json) {
        Product product;
        Option<JsonValue> option = Json$.MODULE$.parseFull(json);
        if (option instanceof Some) {
            void var9_9;
            void var8_8;
            void var7_6;
            JsonObject jsonObj = ((JsonValue)((Some)option).value()).asJsonObject();
            List entries = (List)((TraversableLike)TopicLinkState$.MODULE$.states().map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), jsonObj.get(key.name())), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$2(x$2)));
            if (entries.size() != 1) {
                throw new IllegalStateException("Invalid cluster link topic state(s)");
            }
            Tuple2 tuple2 = (Tuple2)entries.head();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicLinkState k = (TopicLinkState)tuple2._1();
            JsonObject jsonObject = ((JsonValue)((Option)tuple2._2()).get()).asJsonObject();
            void key2 = var7_6;
            JsonObject jsonOpt = jsonObject;
            void key3 = var8_8;
            void jsonOpt2 = var9_9;
            if (TopicLinkMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq mirrorStartOffsets = (Seq)jsonOpt2.get("mirror_start_offsets").map((Function1 & Serializable & scala.Serializable)x$6 -> (Seq)x$6.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                product = new ClusterLinkTopicState.Mirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), timeMs, (Seq<Object>)mirrorStartOffsets);
            } else if (TopicLinkPausedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean linkLevel = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("link_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean topicLevel = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("topic_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean wasFailed = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("was_failed").to(DecodeJson$DecodeBoolean$.MODULE$));
                MirrorTopicError error = this.mirrorTopicError((JsonObject)jsonOpt2, wasFailed);
                Seq mirrorStartOffsets = (Seq)jsonOpt2.get("mirror_start_offsets").map((Function1 & Serializable & scala.Serializable)x$7 -> (Seq)x$7.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                product = new ClusterLinkTopicState.PausedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), linkLevel, topicLevel, wasFailed, error, timeMs, (Seq<Object>)mirrorStartOffsets);
            } else if (TopicLinkFailedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                MirrorTopicError error = this.mirrorTopicError((JsonObject)jsonOpt2, true);
                product = new ClusterLinkTopicState.FailedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), error, timeMs);
            } else if (TopicLinkPendingStoppedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean synchronize = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("synchronize").to(DecodeJson$DecodeBoolean$.MODULE$));
                product = new ClusterLinkTopicState.PendingStoppedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), synchronize, timeMs);
            } else if (TopicLinkStoppedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq logEndOffsets = (Seq)jsonOpt2.apply("log_end_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                product = new ClusterLinkTopicState.StoppedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), (Seq<Object>)logEndOffsets, timeMs);
            } else if (TopicLinkPendingMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                product = new ClusterLinkTopicState.PendingMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), timeMs);
            } else if (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                String nextState = jsonOpt2.apply("next_state").to(DecodeJson$DecodeString$.MODULE$);
                product = new ClusterLinkTopicState.PendingSynchronizeMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), nextState, timeMs);
            } else {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                product = new ClusterLinkTopicState.FailedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, timeMs);
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(26).append("Invalid topic state JSON: ").append(json).toString());
            }
            throw new MatchError(option);
        }
        return product;
    }

    public Option<Tuple2<String, String>> sourceTopicIdOption(Uuid sourceTopicId) {
        Uuid uuid = sourceTopicId;
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (!(uuid != null ? !uuid.equals(uuid2) : uuid2 != null)) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source_topic_id"), (Object)sourceTopicId.toString()));
    }

    public MirrorTopicError mirrorTopicError(JsonObject jsonOpt, boolean failed) {
        return MirrorTopicError.forCode((short)((short)BoxesRunTime.unboxToInt((Object)jsonOpt.get("mirror_topic_error").map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)ClusterLinkTopicState$.$anonfun$mirrorTopicError$1(x$8))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MirrorTopicError.NOT_SET.code()))), (boolean)failed);
    }

    public ClusterLinkTopicState apply(MirrorTopic mirrorTopic) {
        Product product;
        String linkName = mirrorTopic.linkName();
        MirrorTopic.State state = mirrorTopic.mirrorState();
        if (MirrorTopic.State.MIRROR.equals(state)) {
            Nil$ mirrorStartOffsets = mirrorTopic.mirrorStartOffsets() != null ? (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopic.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9), Buffer$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            product = new ClusterLinkTopicState.Mirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), mirrorTopic.timeMs(), (Seq<Object>)mirrorStartOffsets);
        } else if (MirrorTopic.State.PAUSED.equals(state)) {
            MirrorTopic.PausedMirrorTopic pausedMirror = (MirrorTopic.PausedMirrorTopic)mirrorTopic;
            Nil$ mirrorStartOffsets = pausedMirror.mirrorStartOffsets() != null ? (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pausedMirror.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10), Buffer$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            MirrorTopic.State state2 = pausedMirror.prevToPausedState();
            MirrorTopic.State state3 = MirrorTopic.State.FAILED;
            boolean wasFailed = !(state2 != null ? !state2.equals(state3) : state3 != null);
            product = new ClusterLinkTopicState.PausedMirror(linkName, mirrorTopic.linkId(), pausedMirror.sourceTopicId(), pausedMirror.linkLevel(), pausedMirror.topicLevel(), wasFailed, MirrorTopicError.errorOrDefault((MirrorTopicError)pausedMirror.mirrorTopicError(), (boolean)wasFailed), pausedMirror.timeMs(), (Seq<Object>)mirrorStartOffsets);
        } else if (MirrorTopic.State.PENDING_STOPPED.equals(state)) {
            MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirror = (MirrorTopic.PendingStoppedMirrorTopic)mirrorTopic;
            product = new ClusterLinkTopicState.PendingStoppedMirror(linkName, mirrorTopic.linkId(), pendingStoppedMirror.sourceTopicId(), pendingStoppedMirror.promoted(), pendingStoppedMirror.timeMs());
        } else if (MirrorTopic.State.STOPPED.equals(state)) {
            MirrorTopic.StoppedMirrorTopic stoppedMirror = (MirrorTopic.StoppedMirrorTopic)mirrorTopic;
            Nil$ stoppedLogEndOffsets = stoppedMirror.offsets() != null ? (Seq)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(stoppedMirror.offsets()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$11)), List$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            product = new ClusterLinkTopicState.StoppedMirror(linkName, mirrorTopic.linkId(), stoppedMirror.sourceTopicId(), (Seq<Object>)stoppedLogEndOffsets, stoppedMirror.timeMs());
        } else if (MirrorTopic.State.FAILED.equals(state)) {
            product = new ClusterLinkTopicState.FailedMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.errorOrDefault((MirrorTopicError)mirrorTopic.mirrorTopicError(), (boolean)true), mirrorTopic.timeMs());
        } else if (MirrorTopic.State.PENDING_MIRROR.equals(state)) {
            product = new ClusterLinkTopicState.PendingMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), mirrorTopic.timeMs());
        } else if (MirrorTopic.State.PENDING_SYNCHRONIZE.equals(state)) {
            MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeMirror = (MirrorTopic.PendingSynchronizeMirrorTopic)mirrorTopic;
            product = new ClusterLinkTopicState.PendingSynchronizeMirror(linkName, mirrorTopic.linkId(), pendingSynchronizeMirror.sourceTopicId(), pendingSynchronizeMirror.nextState().stateName(), pendingSynchronizeMirror.timeMs());
        } else {
            product = new ClusterLinkTopicState.FailedMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, mirrorTopic.timeMs());
        }
        return product;
    }

    public Option<ClusterLinkTopicState> fromMirrorTopicState(UpdateMetadataRequest.MirrorTopicState mirrorTopicState) {
        return Option$.MODULE$.apply((Object)mirrorTopicState).flatMap((Function1 & Serializable & scala.Serializable)state -> {
            try {
                Some some;
                TopicLinkState topicLinkState = TopicLinkState$.MODULE$.fromString(state.state());
                if (TopicLinkMirror$.MODULE$.equals(topicLinkState)) {
                    some = new Some((Object)new ClusterLinkTopicState.Mirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.timeMs(), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12), Buffer$.MODULE$.canBuildFrom()))));
                } else if (TopicLinkPausedMirror$.MODULE$.equals(topicLinkState)) {
                    String string = mirrorTopicState.previousState();
                    String string2 = TopicLinkFailedMirror$.MODULE$.name();
                    boolean wasFailed = !(string != null ? !string.equals(string2) : string2 != null);
                    some = new Some((Object)new ClusterLinkTopicState.PausedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.linkLevelPause(), mirrorTopicState.topicLevelPause(), wasFailed, MirrorTopicError.forCode((short)mirrorTopicState.mirrorTopicError(), (boolean)wasFailed), mirrorTopicState.timeMs(), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13), Buffer$.MODULE$.canBuildFrom()))));
                } else {
                    some = TopicLinkFailedMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.FailedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), MirrorTopicError.forCode((short)mirrorTopicState.mirrorTopicError(), (boolean)true), mirrorTopicState.timeMs())) : (TopicLinkPendingStoppedMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.PendingStoppedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.promoted(), mirrorTopicState.timeMs())) : (TopicLinkStoppedMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.StoppedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), (Seq<Object>)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.stoppedLogEndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromMirrorTopicState$4(x$14)), Buffer$.MODULE$.canBuildFrom())).toSeq(), mirrorTopicState.timeMs())) : (TopicLinkPendingMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.PendingMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.timeMs())) : (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.PendingSynchronizeMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.nextState(), mirrorTopicState.timeMs())) : new Some((Object)new ClusterLinkTopicState.FailedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, mirrorTopicState.timeMs()))))));
                }
                return some;
            }
            catch (Throwable throwable) {
                return None$.MODULE$;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$2(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    private static final void validateVersion$1(int expectedVersion, int actualVersion) {
        if (expectedVersion != actualVersion) {
            throw new IllegalStateException(new StringBuilder(40).append("Unexpected version '").append(expectedVersion).append("', actual version '").append(actualVersion).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    private static final Uuid sourceTopicId$1(JsonObject jsonOpt$1) {
        return (Uuid)jsonOpt$1.get("source_topic_id").map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.to(DecodeJson$DecodeString$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$4(x$5))).map((Function1 & Serializable & scala.Serializable)x$1 -> Uuid.fromString((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ int $anonfun$mirrorTopicError$1(JsonValue x$8) {
        return BoxesRunTime.unboxToInt((Object)x$8.to(DecodeJson$DecodeInt$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromMirrorTopicState$4(Long x$14) {
        return BoxesRunTime.unboxToLong((Object)x$14);
    }

    private ClusterLinkTopicState$() {
        MODULE$ = this;
    }
}

