/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$Mirror$;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.RetriableReconfigurationUnavailableLinkReason$;
import kafka.server.link.TopicFilterJson;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason$;
import kafka.utils.ConfluentUtils;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ClusterLinkUtils$
implements Logging {
    public static ClusterLinkUtils$ MODULE$;
    private final Set<Object> ConfluentCloudInternalPorts;
    private final int MaxCreateClusterLinksTimeoutMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterLinkUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Set<Object> ConfluentCloudInternalPorts() {
        return this.ConfluentCloudInternalPorts;
    }

    private int MaxCreateClusterLinksTimeoutMs() {
        return this.MaxCreateClusterLinksTimeoutMs;
    }

    public void validateLinkName(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    public Option<InvalidRequestException> checkTimeoutMs(int timeoutMs) {
        if (timeoutMs > this.MaxCreateClusterLinksTimeoutMs()) {
            return new Some((Object)new InvalidRequestException(String.format("Timeout of %d(ms) is above maximum allowed of %d(ms).", new Integer(timeoutMs), new Integer(this.MaxCreateClusterLinksTimeoutMs()))));
        }
        return None$.MODULE$;
    }

    public String logicalCluster(String tenantPrefix) {
        return tenantPrefix.substring(0, tenantPrefix.length() - 1);
    }

    public void overrideLinkConfigsForCompatibility(Properties config) {
        MirrorTopicConfigSyncRules$.MODULE$.decorateTopicConfigSyncRules(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic(CreateTopicsRequestData.CreatableTopic topic, Option<Uuid> linkId, Properties configs, boolean validateOnly, Option<ClusterLinkConfig> linkConfig, Option<CompletableFuture<ClusterLinkTopicInfo>> topicInfo, String tenantPrefix) {
        Option mirrorTopic = Option$.MODULE$.apply((Object)topic.mirrorTopic());
        Option option = Option$.MODULE$.apply((Object)topic.linkName());
        if (option instanceof Some) {
            String linkName = (String)((Some)option).value();
            this.validateLinkName(linkName);
            if (mirrorTopic instanceof Some) {
                String unprefixedSourceTopicName;
                String mt = (String)((Some)mirrorTopic).value();
                String withoutTenantPrefixTopicName = topic.name().substring(tenantPrefix.length());
                Option clusterLinkPrefix = linkConfig.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.clusterLinkPrefix());
                clusterLinkPrefix.foreach((Function1 & Serializable & scala.Serializable)linkPrefix -> {
                    ClusterLinkUtils$.$anonfun$resolveCreateTopic$2(withoutTenantPrefixTopicName, linkPrefix);
                    return BoxedUnit.UNIT;
                });
                int clusterLinkPrefixLength = ((String)clusterLinkPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).length();
                String unprefixedTopicName = withoutTenantPrefixTopicName.substring(clusterLinkPrefixLength);
                String string = unprefixedSourceTopicName = mt.substring(tenantPrefix.length());
                if (string == null ? unprefixedTopicName != null : !string.equals(unprefixedTopicName)) {
                    String expectedMirrorName = new StringBuilder(0).append((String)clusterLinkPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(unprefixedSourceTopicName).toString();
                    if (!clusterLinkPrefix.isDefined()) throw new UnsupportedVersionException(new StringBuilder(70).append("Topic renaming for mirroring not yet supported. Expected mirror name: ").append(expectedMirrorName).toString());
                    throw new UnsupportedVersionException(new StringBuilder(100).append("Renaming the topic suffix, after the prefix, for mirroring not yet supported. Expected mirror name: ").append(expectedMirrorName).toString());
                }
            } else {
                if (!None$.MODULE$.equals(mirrorTopic)) throw new MatchError((Object)mirrorTopic);
                throw new InvalidRequestException("Mirror topic not set.");
            }
            if (topic.numPartitions() != -1) {
                throw new InvalidRequestException("Cannot specify both mirror topic and number of partitions.");
            }
            if (!topic.assignments().isEmpty()) {
                throw new InvalidRequestException("Cannot specify both mirror topic and partition assignments.");
            }
            if (linkId.isEmpty()) {
                throw new ClusterLinkNotFoundException(new StringBuilder(41).append("Cluster link with name '").append(topic.linkName()).append("' does not exist.").toString());
            }
            if (linkConfig instanceof Some) {
                ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic;
                MirrorTopicConfigSyncRules topicConfigSyncRules = ((ClusterLinkConfig)((Object)((Some)linkConfig).value())).topicConfigSyncRules();
                topicConfigSyncRules.validateMirrorPropsForTopicCreation(topic.name(), configs);
                if (topicInfo instanceof Some) {
                    ClusterLinkTopicInfo clusterLinkTopicInfo;
                    CompletableFuture ti = (CompletableFuture)((Some)topicInfo).value();
                    try {
                        if (!ti.isDone()) {
                            throw new IllegalStateException("Mirror information must have been resolved.");
                        }
                        clusterLinkTopicInfo = (ClusterLinkTopicInfo)ti.get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (TimeoutException e) {
                        if (!this.logger().underlying().isErrorEnabled()) throw new TimeoutException(new StringBuilder(64).append("Timed out while fetching topic information over cluster link '").append(linkName).append("'.").toString(), (Throwable)e);
                        this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$resolveCreateTopic$5()), (Throwable)e);
                        throw new TimeoutException(new StringBuilder(64).append("Timed out while fetching topic information over cluster link '").append(linkName).append("'.").toString(), (Throwable)e);
                    }
                    ClusterLinkTopicInfo info = clusterLinkTopicInfo;
                    if (!info.description().authorizedOperations().contains(AclOperation.READ)) {
                        throw new TopicAuthorizationException("Mirror topic creation requires READ access on the source topic.");
                    }
                    Properties newConfigs = new MirrorTopicConfigsDelegate(configs, info.config(), topicConfigSyncRules).initMirrorProps(topic.name());
                    Uuid x$2 = (Uuid)linkId.get();
                    Uuid x$3 = info.description().topicId();
                    Seq<Object> x$4 = info.mirrorStartOffsets();
                    long x$5 = ClusterLinkTopicState$Mirror$.MODULE$.apply$default$4();
                    resolveCreateTopic = new ClusterLinkUtils.ResolveCreateTopic(newConfigs, (Option<ClusterLinkTopicState>)new Some((Object)new ClusterLinkTopicState.Mirror(linkName, x$2, x$3, x$5, x$4)), info.description().partitions().size());
                    return resolveCreateTopic;
                }
                if (!None$.MODULE$.equals(topicInfo)) throw new MatchError(topicInfo);
                if (!validateOnly) {
                    throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
                }
                resolveCreateTopic = new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
                return resolveCreateTopic;
            }
            if (!None$.MODULE$.equals(linkConfig)) throw new MatchError(linkConfig);
            throw new InvalidRequestException(new StringBuilder(62).append("Cannot create mirror topic, cluster link ").append(linkName).append(" is in a FAILED state").toString());
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        if (!mirrorTopic.nonEmpty()) return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
        throw new InvalidRequestException("Cannot create mirror topic, cluster link name not specified.");
    }

    public String resolveCreateTopic$default$7() {
        return "";
    }

    public void validateCreatePartitions(String topic, int numPartitions, boolean validateOnly, Option<CompletableFuture<Object>> partitions) {
        if (partitions instanceof Some) {
            int n;
            CompletableFuture parts = (CompletableFuture)((Some)partitions).value();
            try {
                if (!parts.isDone()) {
                    throw new IllegalStateException("Mirror partitions must have been resolved.");
                }
                n = BoxesRunTime.unboxToInt(parts.get());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Timed out while fetching topic partitions over cluster link.");
            }
            int mirrorNumPartitions = n;
            if (mirrorNumPartitions < numPartitions) {
                throw new InvalidPartitionsException(new StringBuilder(76).append("Cannot set '").append(numPartitions).append("' partitions for topic '").append(topic).append("', ").append("exceeds linked topic's '").append(mirrorNumPartitions).append("' partitions.").toString());
            }
        } else if (None$.MODULE$.equals(partitions)) {
            if (!validateOnly) {
                throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
            }
        } else {
            throw new MatchError(partitions);
        }
    }

    public Seq<ClusterLinkFilterInfo> clusterLinkTopicFilters(Option<TopicFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return (Seq)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.filters()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix)), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<GroupClusterLinkFilterInfo> clusterLinkGroupFilters(Option<GroupFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        return (Seq)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.filters()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).map((Function1 & Serializable & scala.Serializable)filter -> {
            ClusterLinkFilterInfo clFilter = MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix));
            return new GroupClusterLinkFilterInfo(clFilter, filter.effectiveTopicTypes(linkMode));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private String tenantAndClusterLinkPrefix(Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return new StringBuilder(0).append((String)tenantPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(clusterLinkPrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
    }

    /*
     * Unable to fully structure code
     */
    private ClusterLinkFilterInfo clusterLinkFilter(ClusterLinkFilter filter, String prefix) {
        block4: {
            block6: {
                block5: {
                    patternType = SecurityUtils.patternType((String)filter.patternType());
                    if (!new StringOps(Predef$.MODULE$.augmentString(prefix)).nonEmpty()) break block4;
                    if (!PatternType.LITERAL.equals(patternType)) break block5;
                    v0 = filter.name();
                    var5_4 = "*";
                    if (v0 == null || !v0.equals(var5_4)) ** GOTO lbl-1000
                    v1 = patternType;
                    var6_5 = PatternType.LITERAL;
                    if (!(v1 != null ? v1.equals(var6_5) == false : var6_5 != null)) {
                        v2 = new ClusterLinkFilterInfo(prefix, PatternType.PREFIXED, filter.filterType(), filter);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
                    }
                    var3_6 = v2;
                    break block6;
                }
                if (PatternType.PREFIXED.equals(patternType)) {
                    var3_6 = new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
                } else {
                    throw new IllegalStateException(new StringBuilder(24).append("Unexpected pattern type ").append(filter.patternType()).toString());
                }
            }
            return var3_6;
        }
        return new ClusterLinkFilterInfo(filter.name(), patternType, filter.filterType(), filter);
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props, Option<AlterConfigPolicy> policy) {
        Properties properties;
        if (policy instanceof Some) {
            Properties properties2;
            AlterConfigPolicy pol = (AlterConfigPolicy)((Some)policy).value();
            Map configs = Utils.propsToStringMap((Properties)props);
            if (pol instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)pol;
                Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                properties2 = Utils.mkProperties(newConfigs);
            } else {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                pol.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
                properties2 = props;
            }
            properties = properties2;
        } else if (None$.MODULE$.equals(policy)) {
            properties = props;
        } else {
            throw new MatchError(policy);
        }
        return properties;
    }

    public boolean canHandleClusterLinkRequests(MetadataSupport metadataSupport) {
        boolean bl;
        if (metadataSupport instanceof ZkSupport) {
            bl = ((ZkSupport)metadataSupport).controller().isActive();
        } else if (metadataSupport instanceof RaftSupport) {
            bl = true;
        } else {
            throw new MatchError((Object)metadataSupport);
        }
        return bl;
    }

    public void validateMirrorTopicConfig(String topic, Set<String> configKeys, ClusterLinkFactory.LinkManager clusterLinkManager, boolean isIncremental) {
        clusterLinkManager.clusterLinkMetadataManager().foreach((Function1 & Serializable & scala.Serializable)metadataManager -> {
            ClusterLinkUtils$.$anonfun$validateMirrorTopicConfig$1(topic, isIncremental, clusterLinkManager, configKeys, metadataManager);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ApiException apiException(Throwable throwable, String message) {
        var6_3 = throwable instanceof ExecutionException != false ? true : throwable instanceof CompletionException != false;
        var5_4 = var6_3 != false ? throwable.getCause() : throwable;
        v0 = err = Errors.forException((Throwable)var5_4);
        var9_6 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v0 == null ? var9_6 != null : v0.equals(var9_6) == false)) ** GOTO lbl-1000
        v1 = err.message();
        var10_7 = var5_4.getMessage();
        if (!(v1 != null ? v1.equals(var10_7) == false : var10_7 != null)) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            rootCause = var5_4;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            v2 = rootCause == var5_4 ? var5_4.getMessage() : new StringBuilder(14).append(var5_4.getMessage()).append(", root cause: ").append(rootCause).toString();
        }
        errMessage = v2;
        apiError = ObjectRef.create((Object)new ApiError(err, errMessage));
        v3 = ((ApiError)apiError.elem).error();
        var13_11 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v3 != null ? v3.equals(var13_11) == false : var13_11 != null) && var5_4 instanceof AuthenticationException) {
            apiError.elem = new ApiError(Errors.INVALID_CONFIG, var5_4.getMessage());
        }
        errorMessage = new StringBuilder(15).append(message).append(" due to error: ").append(((ApiError)apiError.elem).messageWithFallback()).toString();
        v4 = ((ApiError)apiError.elem).error();
        var15_13 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v4 != null ? v4.equals(var15_13) == false : var15_13 != null)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$apiException$1(errorMessage)), ClusterLinkUtils$.$anonfun$apiException$2(var5_4));
            }
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$apiException$3(errorMessage)), ClusterLinkUtils$.$anonfun$apiException$4(var5_4));
        }
        if (((ApiError)apiError.elem).exception() instanceof InvalidClusterLinkException) {
            if (var5_4 instanceof InvalidClusterLinkException) {
                var16_14 = (InvalidClusterLinkException)var5_4;
                var4_15 /* !! */  = new InvalidClusterLinkException(var16_14.clusterLinkError(), var16_14.linkErrorMessage(), errorMessage);
            } else {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(this.msgWithLogIdent(ClusterLinkUtils$.$anonfun$apiException$5(apiError, var5_4)));
                }
                var4_15 /* !! */  = ((ApiError)apiError.elem).error().exception(errorMessage);
            }
            var3_16 = var4_15 /* !! */ ;
        } else {
            var3_16 = ((ApiError)apiError.elem).error().exception(errorMessage);
        }
        return var3_16;
    }

    public Tuple2<Set<String>, Seq<ClusterLinkFilterInfo>> doFilterTopics(Set<String> toFilter, Option<TopicFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        Seq<ClusterLinkFilterInfo> filters = this.clusterLinkTopicFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix);
        return this.doFilterTopics(toFilter, filters);
    }

    public Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> doFilterGroups(Set<String> toFilter, Option<GroupFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        Seq<GroupClusterLinkFilterInfo> filters = this.clusterLinkGroupFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix, linkMode);
        return this.doFilterGroups(toFilter, filters);
    }

    public Tuple2<Set<String>, Seq<ClusterLinkFilterInfo>> doFilterTopics(Set<String> toFilter, Seq<ClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set filtered = (Set)toFilter.filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterTopics$1(filters, usedFilters, item)));
        return new Tuple2((Object)filtered, filters.diff((GenSeq)usedFilters));
    }

    public Tuple2<Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> doFilterGroups(Set<String> groups, Seq<GroupClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set filtered = (Set)groups.flatMap((Function1 & Serializable & scala.Serializable)group -> {
            Seq matchedFilters = (Seq)filters.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$2(group, x$7)));
            if (matchedFilters.isEmpty()) {
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            usedFilters.$plus$plus$eq((TraversableOnce)matchedFilters.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.filterInfo(), Seq$.MODULE$.canBuildFrom()));
            Set includeTopicTypes = ((TraversableOnce)((Seq)matchedFilters.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$4(x$9)))).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> x$10.topicTypes(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set excludeTopicTypes = ((TraversableOnce)((Seq)matchedFilters.filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$6(x$11)))).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> x$12.topicTypes(), Seq$.MODULE$.canBuildFrom())).toSet();
            Set topicTypes = (Set)includeTopicTypes.diff((GenSet)excludeTopicTypes);
            if (!topicTypes.isEmpty()) {
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new MatchedGroup((String)group, (Set<Enumeration.Value>)topicTypes)));
            }
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, Set$.MODULE$.canBuildFrom());
        return new Tuple2((Object)filtered, ((SeqLike)filters.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.filterInfo(), Seq$.MODULE$.canBuildFrom())).diff((GenSeq)usedFilters));
    }

    public ClusterLinkConfig.LinkMode doFilterGroups$default$5() {
        return ClusterLinkConfig.LinkMode.DESTINATION;
    }

    public boolean isInternalNetworkOrPort(InetSocketAddress socketAddress) {
        return this.ConfluentCloudInternalPorts().contains((Object)BoxesRunTime.boxToInteger((int)socketAddress.getPort())) && (socketAddress.getAddress().isSiteLocalAddress() || socketAddress.getAddress().isLoopbackAddress());
    }

    public boolean isOutboundBootstrapCCloudHost(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig) {
        return this.isOutboundBootstrapCCloudHost(brokerConfig.values(), clusterLinkConfig);
    }

    public boolean isOutboundBootstrapCCloudHost(Map<String, ?> brokerConfigs, ClusterLinkConfig clusterLinkConfig) {
        return this.isOutboundBootstrapCCloudHost(brokerConfigs, clusterLinkConfig.connectionMode(), clusterLinkConfig.bootstrapServers());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOutboundBootstrapCCloudHost(Map<String, ?> brokerConfigs, ConnectionMode connectionMode, List<String> bootstrapServers) {
        Option firstHost = ((TraversableLike)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(bootstrapServers).asScala()).filter((Function1 & Serializable & scala.Serializable)bootstrap -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$isOutboundBootstrapCCloudHost$1(bootstrap)))).map((Function1 & Serializable & scala.Serializable)bootstrap -> Utils.getHost((String)bootstrap), Buffer$.MODULE$.canBuildFrom())).headOption();
        if (firstHost instanceof Some) {
            String host = (String)((Some)firstHost).value();
            ConnectionMode connectionMode2 = connectionMode;
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            if (connectionMode2 == null) {
                if (connectionMode$Outbound$ != null) {
                    return false;
                }
            } else if (!connectionMode2.equals(connectionMode$Outbound$)) return false;
            if (host == null) return false;
            if (!ConfluentUtils.hasCCloudHostPattern(brokerConfigs, host)) return false;
            return true;
        }
        if (!None$.MODULE$.equals(firstHost)) throw new MatchError((Object)firstHost);
        return false;
    }

    public boolean isRetriableFailure(Throwable cause) {
        boolean bl;
        if (cause instanceof RetriableException) {
            return true;
        }
        if (cause instanceof ConfigException) {
            String namingMessage = cause.getMessage();
            if (namingMessage == null) {
                return false;
            }
            bl = namingMessage.startsWith("No resolvable bootstrap urls");
        } else {
            bl = false;
        }
        return bl;
    }

    public OffsetSpec toOffsetSpec(long timestamp, OffsetSpec defaultSpec) {
        OffsetSpec offsetSpec;
        if (Long.MIN_VALUE == timestamp) {
            offsetSpec = defaultSpec;
        } else if (timestamp >= 0L) {
            offsetSpec = OffsetSpec.forTimestamp((long)timestamp);
        } else if (-2L == timestamp) {
            offsetSpec = OffsetSpec.earliest();
        } else if (-1L == timestamp) {
            offsetSpec = OffsetSpec.latest();
        } else {
            if (-3L == timestamp) {
                throw new InvalidConfigurationException("Mirroring from max timestamp is not supported.");
            }
            throw new InvalidConfigurationException(new StringBuilder(46).append("Unsupported start offset spec for mirroring: ").append(timestamp).append(".").toString());
        }
        return offsetSpec;
    }

    public Option<UnavailableLinkReason> retriableExceptionToUnavailablereason(Throwable ex) {
        Object object = ex instanceof ConfigException ? new Some((Object)UnresolvableBootstrapUnavailableLinkReason$.MODULE$) : (ex instanceof RetriableException ? new Some((Object)RetriableReconfigurationUnavailableLinkReason$.MODULE$) : None$.MODULE$);
        return object;
    }

    public static final /* synthetic */ void $anonfun$resolveCreateTopic$2(String withoutTenantPrefixTopicName$1, String linkPrefix) {
        if (!withoutTenantPrefixTopicName$1.startsWith(linkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Mirror topic name should start with cluster link prefix ").append(linkPrefix).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$resolveCreateTopic$5() {
        return "Received timeout exception while fetching topic information over cluster link";
    }

    public static final /* synthetic */ void $anonfun$validateMirrorTopicConfig$1(String topic$1, boolean isIncremental$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, Set configKeys$1, ClusterLinkMetadataManager metadataManager) {
        Option clusterLinkTopicState;
        if (metadataManager.hasTopic(topic$1) && (clusterLinkTopicState = metadataManager.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})))).get((Object)topic$1)).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.mirrorIsEstablished()))) {
            if (!isIncremental$1) {
                throw new InvalidRequestException(new StringBuilder(72).append("Non-incremental configuration updates for mirror topic '").append(topic$1).append("' are disallowed").toString());
            }
            Uuid linkId = ((ClusterLinkTopicState)clusterLinkTopicState.get()).linkId();
            if (clusterLinkManager$1.linkConfig(linkId).isEmpty()) {
                throw new ClusterLinkNotFoundException(new StringBuilder(71).append("The cluster link with ID ").append(linkId).append(" does not exist, or is temporarily unavailable").toString());
            }
            ((ClusterLinkConfig)((Object)clusterLinkManager$1.linkConfig(linkId).get())).topicConfigSyncRules().validateMirrorPropsForTopicAlteration(topic$1, (Set<String>)configKeys$1);
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$apiException$1(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$2(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$3(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$5(ObjectRef apiError$1, Throwable e$2) {
        return new StringBuilder(88).append((Object)((ApiError)apiError$1.elem).exception()).append(" is an instance of ClusterLinkAvailabilityException but ").append(e$2).append(" is not which should not happen.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterTopics$1(Seq filters$1, Buffer usedFilters$1, String item) {
        Seq matchedFilters = (Seq)filters$1.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.matchesIncludeOrExclude(item)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq((TraversableOnce)matchedFilters);
        return matchedFilters.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isInclude()));
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$2(String group$1, GroupClusterLinkFilterInfo x$7) {
        return x$7.filterInfo().matchesIncludeOrExclude(group$1);
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$4(GroupClusterLinkFilterInfo x$9) {
        return x$9.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$6(GroupClusterLinkFilterInfo x$11) {
        return !x$11.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$isOutboundBootstrapCCloudHost$1(String bootstrap) {
        return bootstrap != null && !bootstrap.isEmpty();
    }

    private ClusterLinkUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ConfluentCloudInternalPorts = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{9071, 9072, 9073, 9074, 9075, 9076, 9080, 8090}));
        this.MaxCreateClusterLinksTimeoutMs = 300000;
    }
}

