/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.security.CredentialProvider;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.ScramMechanism;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ScramDelta;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.ScramCredentialData;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.ConfluentStandardAcl;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\r\u0015q!\u0002\u0017.\u0011\u0003!d!\u0002\u001c.\u0011\u00039\u0004\"\u0002#\u0002\t\u0003)\u0005\"\u0002$\u0002\t\u00039\u0005\"B7\u0002\t\u0003qg!\u0002\u001c.\u0001\u0005\r\u0002\"CA!\u000b\t\u0005\t\u0015!\u0003Y\u0011)\t\u0019%\u0002B\u0001B\u0003%\u0011Q\t\u0005\u000b\u0003\u001b*!\u0011!Q\u0001\n\u0005=\u0003BCA+\u000b\t\u0005\t\u0015!\u0003\u0002X!Q\u0011QL\u0003\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u0005\u0015TA!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002x\u0015\u0011\t\u0011)A\u0005\u0003sB!\"a\"\u0006\u0005\u0003\u0007I\u0011AAE\u0011)\t\t*\u0002BA\u0002\u0013\u0005\u00111\u0013\u0005\u000b\u0003?+!\u0011!Q!\n\u0005-\u0005BCAQ\u000b\t\u0005\t\u0015!\u0003\u0002$\"Q\u0011\u0011V\u0003\u0003\u0002\u0003\u0006I!a+\t\u0015\u0005EVA!b\u0001\n\u0013\t\u0019\f\u0003\u0006\u0002F\u0016\u0011\t\u0011)A\u0005\u0003kC!\"a2\u0006\u0005\u0003\u0005\u000b\u0011BAe\u0011)\t).\u0002B\u0001B\u0003%\u0011q\u001b\u0005\u000b\u0003G,!\u0011!Q\u0001\n\u0005]\u0007BCAs\u000b\t\u0005\t\u0015!\u0003\u0002h\"Q!qA\u0003\u0003\u0002\u0003\u0006IA!\u0003\t\u0015\t]QA!A!\u0002\u0013\u0011I\u0002\u0003\u0006\u0003(\u0015\u0011\t\u0011)A\u0005\u0005SA!Ba\u000e\u0006\u0005\u0003\u0005\u000b\u0011\u0002B\u001d\u0011\u0019!U\u0001\"\u0001\u0003H!Aq0\u0002b\u0001\n\u0003\u0011\t\b\u0003\u0005\u0003t\u0015\u0001\u000b\u0011BA\u0001\u0011%\u0011)(\u0002a\u0001\n\u0003\u00119\bC\u0005\u0003\u0000\u0015\u0001\r\u0011\"\u0001\u0003\u0002\"A!QQ\u0003!B\u0013\u0011I\bC\u0005\u0003\b\u0016\u0011\r\u0011\"\u0001\u0003\n\"A!\u0011U\u0003!\u0002\u0013\u0011Y\tC\u0004\u0003$\u0016!\tE!*\t\u000f\t\u001dV\u0001\"\u0011\u0003*\"9!qX\u0003\u0005\n\t\u0005\u0007b\u0002Bi\u000b\u0011\u0005!1\u001b\u0005\b\u0005?,A\u0011\u0001Bq\u0011\u001d\u0011I0\u0002C\u0005\u0005wDqA!@\u0006\t\u0013\u0011y\u0010C\u0004\u0004\u0004\u0015!\tEa?\u0002/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014(B\u0001\u00180\u0003!iW\r^1eCR\f'B\u0001\u00192\u0003\u0019\u0019XM\u001d<fe*\t!'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005U\nQ\"A\u0017\u0003/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u00148cA\u00019}A\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\t1\u0011I\\=SK\u001a\u0004\"a\u0010\"\u000e\u0003\u0001S!!Q\u0019\u0002\u000bU$\u0018\u000e\\:\n\u0005\r\u0003%a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\nQbZ3u)>\u0004\u0018n\u0019#fYR\fG\u0003\u0002%WG\"\u00042!O%L\u0013\tQ%H\u0001\u0004PaRLwN\u001c\t\u0003\u0019Rk\u0011!\u0014\u0006\u0003\u001d>\u000bQ![7bO\u0016T!A\r)\u000b\u0005E\u0013\u0016AB1qC\u000eDWMC\u0001T\u0003\ry'oZ\u0005\u0003+6\u0013!\u0002V8qS\u000e$U\r\u001c;b\u0011\u001596\u00011\u0001Y\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0002ZA:\u0011!L\u0018\t\u00037jj\u0011\u0001\u0018\u0006\u0003;N\na\u0001\u0010:p_Rt\u0014BA0;\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}S\u0004\"\u00023\u0004\u0001\u0004)\u0017\u0001\u00038fo&k\u0017mZ3\u0011\u000513\u0017BA4N\u00055iU\r^1eCR\f\u0017*\\1hK\")\u0011n\u0001a\u0001U\u0006)A-\u001a7uCB\u0011Aj[\u0005\u0003Y6\u0013Q\"T3uC\u0012\fG/\u0019#fYR\f\u0017a\u00054j]\u0012\u001cFO]1z!\u0006\u0014H/\u001b;j_:\u001cHCB8\u007f\u0003\u000f\t\t\u0002E\u0002qkbt!!]:\u000f\u0005m\u0013\u0018\"A\u001e\n\u0005QT\u0014a\u00029bG.\fw-Z\u0005\u0003m^\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003ij\u0002\"!\u001f?\u000e\u0003iT!a_(\u0002\r\r|W.\\8o\u0013\ti(P\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\r}$\u0001\u0019AA\u0001\u0003!\u0011'o\\6fe&#\u0007cA\u001d\u0002\u0004%\u0019\u0011Q\u0001\u001e\u0003\u0007%sG\u000fC\u0004\u0002\n\u0011\u0001\r!a\u0003\u0002\u001d9,w\u000fV8qS\u000e\u001c\u0018*\\1hKB\u0019A*!\u0004\n\u0007\u0005=QJA\u0006U_BL7m]%nC\u001e,\u0007bBA\n\t\u0001\u0007\u0011QC\u0001\u0005Y><7\u000f\u0005\u0003qk\u0006]\u0001\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u\u0011'A\u0002m_\u001eLA!!\t\u0002\u001c\tY\u0011IY:ue\u0006\u001cG\u000fT8h'\u0019)\u0011QEA\u001b}A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012\u0001\u00027b]\u001eT!!a\f\u0002\t)\fg/Y\u0005\u0005\u0003g\tIC\u0001\u0004PE*,7\r\u001e\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H'\u0002\u0013A,(\r\\5tQ\u0016\u0014\u0018\u0002BA \u0003s\u0011\u0011#T3uC\u0012\fG/\u0019)vE2L7\u000f[3s\u0003%\u0019G.^:uKJLE-\u0001\u0003d_:4\u0007\u0003BA$\u0003\u0013j\u0011aL\u0005\u0004\u0003\u0017z#aC&bM.\f7i\u001c8gS\u001e\fQ\"\\3uC\u0012\fG/Y\"bG\",\u0007cA\u001b\u0002R%\u0019\u00111K\u0017\u0003%-\u0013\u0016M\u001a;NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000bY><W*\u00198bO\u0016\u0014\b\u0003BA\r\u00033JA!a\u0017\u0002\u001c\tQAj\\4NC:\fw-\u001a:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011qIA1\u0013\r\t\u0019g\f\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0007\u0005Et*A\u0006d_>\u0014H-\u001b8bi>\u0014\u0018\u0002BA;\u0003W\u0012\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\u0002\u001dQDhnQ8pe\u0012Lg.\u0019;peB!\u00111PAB\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T1!!\u001d2\u0013\u0011\t))! \u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\fa\u0003Z=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]\u000b\u0003\u0003\u0017\u00032!NAG\u0013\r\ty)\f\u0002\u0017\tft\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe\u0006QB-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'o\u0018\u0013fcR!\u0011QSAN!\rI\u0014qS\u0005\u0004\u00033S$\u0001B+oSRD\u0011\"!(\u000f\u0003\u0003\u0005\r!a#\u0002\u0007a$\u0013'A\fes:\fW.[2D_:4\u0017n\u001a)vE2L7\u000f[3sA\u0005YB-\u001f8b[&\u001c7\t\\5f]R\fVo\u001c;b!V\u0014G.[:iKJ\u00042!NAS\u0013\r\t9+\f\u0002\u001c\tft\u0017-\\5d\u00072LWM\u001c;Rk>$\u0018\rU;cY&\u001c\b.\u001a:\u0002\u001dM\u001c'/Y7Qk\nd\u0017n\u001d5feB\u0019Q'!,\n\u0007\u0005=VF\u0001\bTGJ\fW\u000eU;cY&\u001c\b.\u001a:\u0002\u0017}\u000bW\u000f\u001e5pe&TXM]\u000b\u0003\u0003k\u0003B!O%\u00028B!\u0011\u0011XAa\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016AC1vi\"|'/\u001b>fe*\u0011\u0001gT\u0005\u0005\u0003\u0007\fYL\u0001\u0006BkRDwN]5{KJ\fAbX1vi\"|'/\u001b>fe\u0002\n!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feB!\u00111ZAi\u001b\t\tiMC\u0002\u0002PF\n\u0001b]3dkJLG/_\u0005\u0005\u0003'\fiM\u0001\nDe\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\u0018!\u00054bi\u0006dg)Y;mi\"\u000bg\u000e\u001a7feB!\u0011\u0011\\Ap\u001b\t\tYN\u0003\u0003\u0002^\u0006}\u0016!\u00024bk2$\u0018\u0002BAq\u00037\u0014ABR1vYRD\u0015M\u001c3mKJ\fa$\\3uC\u0012\fG/\u0019)vE2L7\u000f[5oO\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\t\u0005s%\u000bI\u000f\u0005\u0003\u0002l\n\u0005a\u0002BAw\u0003wtA!a<\u0002x:!\u0011\u0011_A{\u001d\rY\u00161_\u0005\u0002e%\u0011\u0001'M\u0005\u0004\u0003s|\u0013\u0001\u00027j].LA!!@\u0002\u0000\u0006\u00112\t\\;ti\u0016\u0014H*\u001b8l\r\u0006\u001cGo\u001c:z\u0015\r\tIpL\u0005\u0005\u0005\u0007\u0011)AA\u0006MS:\\W*\u00198bO\u0016\u0014(\u0002BA\u007f\u0003\u007f\f\u0011\u0003^5fe\u0016$7i\\8sI&t\u0017\r^8s!\u0011I\u0014Ja\u0003\u0011\t\t5!1C\u0007\u0003\u0005\u001fQ1A!\u00052\u0003\u0011!\u0018.\u001a:\n\t\tU!q\u0002\u0002!)&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'/\u0001\u0016cC\u000e\\W\u000f](cU\u0016\u001cG\u000fT5gK\u000eL8\r\\3NC:\fw-\u001a:D_>\u0014H-\u001b8bi>\u0014x\n\u001d;\u0011\teJ%1\u0004\t\u0005\u0005;\u0011\u0019#\u0004\u0002\u0003 )!!\u0011\u0005B\b\u0003U\u0011\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016LAA!\n\u0003 \t9#)Y2lkB|%M[3di2Kg-Z2zG2,W*\u00198bO\u0016\u00148i\\8sI&t\u0017\r^8s\u0003}!\u0018.\u001a:U_BL7m\u00158baNDw\u000e^\"p_J$\u0017N\\1u_J|\u0005\u000f\u001e\t\u0005s%\u0013Y\u0003\u0005\u0003\u0003.\tMRB\u0001B\u0018\u0015\u0011\u0011\tDa\u0004\u0002\u0011Mt\u0017\r]:i_RLAA!\u000e\u00030\taB+[3s)>\u0004\u0018nY*oCB\u001c\bn\u001c;D_>\u0014H-\u001b8bi>\u0014\u0018aE9v_R\f7i\\8sI&t\u0017\r^8s\u001fB$\b\u0003B\u001dJ\u0005w\u0001BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0005\u0003\n\t)A\u0003rk>$\u0018-\u0003\u0003\u0003F\t}\"\u0001E)v_R\f7i\\8sI&t\u0017\r^8s)!\u0012IEa\u0013\u0003N\t=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\\tu#q\fB1\u0005G\u0012)Ga\u001a\u0003j\t-$Q\u000eB8!\t)T\u0001\u0003\u0004\u0002Bq\u0001\r\u0001\u0017\u0005\b\u0003\u0007b\u0002\u0019AA#\u0011\u001d\ti\u0005\ba\u0001\u0003\u001fBq!!\u0016\u001d\u0001\u0004\t9\u0006C\u0004\u0002^q\u0001\r!a\u0018\t\u000f\u0005\u0015D\u00041\u0001\u0002h!9\u0011q\u000f\u000fA\u0002\u0005e\u0004bBAD9\u0001\u0007\u00111\u0012\u0005\b\u0003Cc\u0002\u0019AAR\u0011\u001d\tI\u000b\ba\u0001\u0003WCq!!-\u001d\u0001\u0004\t)\fC\u0004\u0002Hr\u0001\r!!3\t\u000f\u0005UG\u00041\u0001\u0002X\"9\u00111\u001d\u000fA\u0002\u0005]\u0007bBAs9\u0001\u0007\u0011q\u001d\u0005\b\u0005\u000fa\u0002\u0019\u0001B\u0005\u0011\u001d\u00119\u0002\ba\u0001\u00053AqAa\n\u001d\u0001\u0004\u0011I\u0003C\u0004\u00038q\u0001\rA!\u000f\u0016\u0005\u0005\u0005\u0011!\u00032s_.,'/\u00133!\u00035yf-\u001b:tiB+(\r\\5tQV\u0011!\u0011\u0010\t\u0004s\tm\u0014b\u0001B?u\t9!i\\8mK\u0006t\u0017!E0gSJ\u001cH\u000fU;cY&\u001c\bn\u0018\u0013fcR!\u0011Q\u0013BB\u0011%\ti\nIA\u0001\u0002\u0004\u0011I(\u0001\b`M&\u00148\u000f\u001e)vE2L7\u000f\u001b\u0011\u0002%\u0019L'o\u001d;Qk\nd\u0017n\u001d5GkR,(/Z\u000b\u0003\u0005\u0017\u0003bA!$\u0003\u0018\nmUB\u0001BH\u0015\u0011\u0011\tJa%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0003\u0016\u00065\u0012\u0001B;uS2LAA!'\u0003\u0010\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\t\u0005\u001d\"QT\u0005\u0005\u0005?\u000bIC\u0001\u0003W_&$\u0017a\u00054jeN$\b+\u001e2mSNDg)\u001e;ve\u0016\u0004\u0013\u0001\u00028b[\u0016$\u0012\u0001W\u0001\u0011_:lU\r^1eCR\fW\u000b\u001d3bi\u0016$\u0002\"!&\u0003,\n5&q\u0016\u0005\u0006S\u0016\u0002\rA\u001b\u0005\u0006I\u0016\u0002\r!\u001a\u0005\b\u0005c+\u0003\u0019\u0001BZ\u0003!i\u0017M\\5gKN$\b\u0003\u0002B[\u0005wk!Aa.\u000b\u0007\teV*\u0001\u0004m_\u0006$WM]\u0005\u0005\u0005{\u00139L\u0001\bM_\u0006$WM]'b]&4Wm\u001d;\u0002\u001bQ|w\n\u001d;j_:\fG.\u00138u)\u0011\u0011\u0019Ma3\u0011\t\t\u0015'qY\u0007\u0003\u0005'KAA!3\u0003\u0014\nYq\n\u001d;j_:\fG.\u00138u\u0011\u001d\u0011iM\na\u0001\u0005\u001f\faa\u001c9uS>t\u0007\u0003B\u001dJ\u0003\u0003\tQE]3m_\u0006$W\u000b\u001d3bi\u0016$g)\u001b7fg^KG\u000f[8vi\u000e{gNZ5h\u0007\"\fgnZ3\u0015\t\u0005U%Q\u001b\u0005\b\u0005/<\u0003\u0019\u0001Bm\u0003\u0015\u0001(o\u001c9t!\u0011\u0011)Ma7\n\t\tu'1\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!E;qI\u0006$XmQ8pe\u0012Lg.\u0019;peRa\u0011Q\u0013Br\u0005K\u00149O!;\u0003t\")a\n\u000ba\u0001K\")\u0011\u000e\u000ba\u0001U\")q\u000b\u000ba\u00011\"9!1\u001e\u0015A\u0002\t5\u0018\u0001C3mK\u000e$\u0018n\u001c8\u0011\u0013e\u0012y/!\u0001\u0002\u0002\u0005U\u0015b\u0001Byu\tIa)\u001e8di&|gN\r\u0005\b\u0005kD\u0003\u0019\u0001B|\u0003-\u0011Xm]5h]\u0006$\u0018n\u001c8\u0011\u0013e\u0012y/!\u0001\u0003P\u0006U\u0015AE5oSRL\u0017\r\\5{K6\u000bg.Y4feN$\"!!&\u0002A\u0019Lg.[:i\u0013:LG/[1mSjLgn\u001a*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0005\u0003+\u001b\t\u0001C\u0003eU\u0001\u0007Q-A\u0003dY>\u001cX\r")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig conf;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final Option<Authorizer> _authorizer;
    private final CredentialProvider credentialProvider;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final Option<ClusterLinkFactory.LinkManager> clusterLinkManager;
    private final Option<TierDeletedPartitionsCoordinator> tieredCoordinator;
    private final Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt;
    private final Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt;
    private final Option<QuotaCoordinator> quotaCoordinatorOpt;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int n, TopicsImage topicsImage, Iterable<AbstractLog> iterable) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(n, topicsImage, iterable);
    }

    public static Option<TopicDelta> getTopicDelta(String string, MetadataImage metadataImage, MetadataDelta metadataDelta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(string, metadataImage, metadataDelta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable & scala.Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$4(this, highestOffsetAndEpoch, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tieredCoordinator.foreach((Function1 & Serializable & scala.Serializable)tieredCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$1) -> tieredCoord.handleImmigration(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$2) -> {
                                tieredCoord.handleEmigration(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(64).append("Error updating ").append("tiered storage coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.quotaCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)quotaCoordinator -> {
                            this.updateCoordinator(newImage, delta, "_confluent-quotas", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> quotaCoordinator.onElection(quotaTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(quotaTopicPartitionId, coordinatorEpoch) -> {
                                quotaCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)quotaTopicPartitionId), (Option<Object>)coordinatorEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating ").append("quota coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.backupObjectLifecycleManagerCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)backupObjectLifecycleManagerCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$3) -> backupObjectLifecycleManagerCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$4) -> {
                                backupObjectLifecycleManagerCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(81).append("Error updating ").append("backup object lifecycle manager coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.tierTopicSnapshotCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)tierSnapshotCoord -> {
                            this.updateCoordinator(newImage, delta, "_confluent-tier-state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, x$5) -> tierSnapshotCoord.onElection(partitionId), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, x$6) -> {
                                tierSnapshotCoord.onResignation(BoxesRunTime.unboxToInt((Object)partitionId));
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(69).append("Error updating ").append("tier topic snapshot coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        $this.clusterLinkManager.foreach((Function1 & Serializable & scala.Serializable)manager -> {
                            this.updateCoordinator(newImage, delta, "_confluent-link-metadata", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(partitionId, leaderEpoch) -> manager.onMetadataPartitionLeaderElection(partitionId, leaderEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionId, leaderEpoch) -> {
                                manager.onMetadataPartitionLeaderResignation(BoxesRunTime.unboxToInt((Object)partitionId), (Option<Object>)leaderEpoch);
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(58).append("Error updating ").append("cluster link manager with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deletedTopicPartitions).asJava(), RequestLocal$.MODULE$.NoCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                Option$.MODULE$.apply((Object)delta.scramDelta()).foreach((Function1 & Serializable & scala.Serializable)scramDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$29(this, scramDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable & scala.Serializable)aclsDelta -> {
                    BoxedUnit boxedUnit;
                    Authorizer authorizer;
                    Option<Authorizer> option = this._authorizer();
                    if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
                        Object object;
                        ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
                        if (aclsDelta.isSnapshotDelta()) {
                            try {
                                clusterMetadataAuthorizer.loadSnapshot(newImage.acls().acls());
                                object = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                object = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(37).append("Error loading ").append("authorizer snapshot in ").append(deltaName).toString(), t);
                            }
                        } else {
                            try {
                                aclsDelta.changes().entrySet().forEach(e -> {
                                    if (((Optional)e.getValue()).isPresent()) {
                                        clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (ConfluentStandardAcl)((Optional)e.getValue()).get());
                                        return;
                                    }
                                    clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
                                });
                                object = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                object = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(36).append("Error loading ").append("authorizer changes in ").append(deltaName).toString(), t);
                            }
                        }
                        boxedUnit = object;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        OptionalInt optionalInt;
        if (option instanceof Some) {
            optionalInt = OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        } else if (None$.MODULE$.equals(option)) {
            optionalInt = OptionalInt.empty();
        } else {
            throw new MatchError(option);
        }
        return optionalInt;
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
            if (topicsDelta.topicWasDeleted(topicName)) {
                topicsDelta.image().getTopic(topicName).partitions().entrySet().forEach(entry -> {
                    if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                        resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    }
                });
            }
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable & scala.Serializable)topicDelta -> {
            LocalReplicaChanges $anonfun$updateCoordinator$3_changes = topicDelta.localChanges(this.brokerId());
            $anonfun$updateCoordinator$3_changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
            $anonfun$updateCoordinator$3_changes.leaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
            $anonfun$updateCoordinator$3_changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics((Option<String>)None$.MODULE$));
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.clusterLinkManager.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.startup();
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ClusterLinkManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.offsetsTopicPartitions()))));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
        }
        try {
            this.quotaCoordinatorOpt.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("_confluent-quotas").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.conf.confluentConfig().quotasTopicPartitions()))));
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting QuotaCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        try {
            Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
            if (strayPartitions.nonEmpty()) {
                this.replicaManager.deleteStrayReplicas(strayPartitions);
            }
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error deleting stray partitions during startup", t);
        }
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally(new TimeoutException());
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$4(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString()));
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$29(BrokerMetadataPublisher $this, ScramDelta scramDelta) {
        scramDelta.changes().forEach((x0$1, x1$1) -> {
            ScramMechanism mechanism = x0$1;
            x1$1.forEach((x0$2, x1$2) -> {
                String userName = x0$2;
                Optional change = x1$2;
                if (change.isPresent()) {
                    $this.credentialProvider.updateCredential(mechanism, userName, ((ScramCredentialData)change.get()).toCredential(mechanism));
                    return;
                }
                $this.credentialProvider.removeCredentials(mechanism, userName);
            });
        });
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                    resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.conf.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(String clusterId, KafkaConfig conf, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, Option<Authorizer> _authorizer, CredentialProvider credentialProvider, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler, Option<ClusterLinkFactory.LinkManager> clusterLinkManager, Option<TierDeletedPartitionsCoordinator> tieredCoordinator, Option<BackupObjectLifecycleManagerCoordinator> backupObjectLifecycleManagerCoordinatorOpt, Option<TierTopicSnapshotCoordinator> tierTopicSnapshotCoordinatorOpt, Option<QuotaCoordinator> quotaCoordinatorOpt) {
        this.conf = conf;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this._authorizer = _authorizer;
        this.credentialProvider = credentialProvider;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        this.clusterLinkManager = clusterLinkManager;
        this.tieredCoordinator = tieredCoordinator;
        this.backupObjectLifecycleManagerCoordinatorOpt = backupObjectLifecycleManagerCoordinatorOpt;
        this.tierTopicSnapshotCoordinatorOpt = tierTopicSnapshotCoordinatorOpt;
        this.quotaCoordinatorOpt = quotaCoordinatorOpt;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(conf.nodeId()).append("] ").toString());
        this.brokerId = conf.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

