/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import io.confluent.kafka.availability.FilesWrapper;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.log.AbstractLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.HostedPartition;
import kafka.server.HostedPartition$None$;
import kafka.server.HostedPartition$Offline$;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.InProgressDeletion$;
import kafka.tier.MaterializationComplete$;
import kafka.tier.TierDeletedPartitionsCoordinator$;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMd\u0001\u0002$H\u00011C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tY\u0002\u0011\t\u0011)A\u0005[\"A\u0001\u000f\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003y\u0011!Y\bA!A!\u0002\u0013a\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005\u0005\u0001A!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0005\u00037A!\"!\u000b\u0001\u0005\u0003\u0005\u000b\u0011BA\u0016\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003B\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0017\t\u0011\u0005E\u0004\u0001)A\u0005\u00037B\u0011\"a\u001d\u0001\u0005\u0004%I!!\u001e\t\u0011\u0005u\u0004\u0001)A\u0005\u0003oB\u0011\"a \u0001\u0005\u0004%I!!!\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u0007C1\"a$\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012\"Y\u0011\u0011\u0014\u0001A\u0002\u0003\u0007I\u0011BAN\u0011-\t9\u000b\u0001a\u0001\u0002\u0003\u0006K!a%\t\u0013\u0005%\u0006\u00011A\u0005\n\u0005-\u0006\"CAW\u0001\u0001\u0007I\u0011BAX\u0011\u001d\t\u0019\f\u0001Q!\naD\u0011\"!.\u0001\u0001\u0004%I!a.\t\u0013\u0005e\u0006\u00011A\u0005\n\u0005m\u0006bBA`\u0001\u0001\u0006K\u0001 \u0005\u000b\u0003\u0003\u0004!\u0019!C\u0001\u000f\u0006\r\u0007\u0002CAn\u0001\u0001\u0006I!!2\t\u0017\u0005u\u0007\u00011AA\u0002\u0013%\u0011q\u001c\u0005\f\u0005\u0017\u0001\u0001\u0019!a\u0001\n\u0013\u0011i\u0001C\u0006\u0002t\u0002\u0001\r\u0011!Q!\n\u0005\u0005\b\"\u0003B\r\u0001\u0001\u0007I\u0011\u0002B\u000e\u0011%\u0011\u0019\u0003\u0001a\u0001\n\u0013\u0011)\u0003\u0003\u0005\u0003*\u0001\u0001\u000b\u0015\u0002B\u000f\u0011%\u0011i\u0003\u0001b\u0001\n\u0013\u0011y\u0003\u0003\u0005\u0003>\u0001\u0001\u000b\u0011\u0002B\u0019\u0011\u001d\u0011y\u0004\u0001C!\u0005\u0003BqAa\u0013\u0001\t\u0003\u0012i\u0005C\u0004\u0003Z\u0001!\tEa\u0017\t\u000f\t\r\u0004\u0001\"\u0001\u0003f!9!q\r\u0001\u0005\u0002\t%\u0004b\u0002B8\u0001\u0011\u0005!\u0011\u000f\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011Y\b\u0001C\u0001\u0005KBqA! \u0001\t\u0013\u0011y\bC\u0005\u0003\u0006\u0002\t\n\u0011\"\u0003\u0003\b\"9!Q\u0014\u0001\u0005\n\t\u0015\u0004\u0002\u0003BP\u0001\u0011\u0005qI!\u001a\t\u0011\t\u0005\u0006\u0001\"\u0001H\u0005KBqAa)\u0001\t\u0013\u0011)\u0007C\u0004\u0003&\u0002!IA!\u001a\t\u0011\t\u001d\u0006\u0001\"\u0001H\u0005SC\u0001B!5\u0001\t\u00039%Q\r\u0005\t\u0005'\u0004A\u0011A$\u0003f!A!Q\u001b\u0001\u0005\u0002\u001d\u0013)\u0007\u0003\u0005\u0003X\u0002!\ta\u0012Bm\u0011!\u0011I\u0010\u0001C\u0001\u000f\nm\b\u0002CB\u0004\u0001\u0011\u0005qi!\u0003\t\u0011\rM\u0001\u0001\"\u0001H\u0007+A\u0001B!\u0017\u0001\t\u0003951\u0004\u0005\b\u0007C\u0001A\u0011BB\u0012\u0011\u001d\u0019Y\u0003\u0001C\u0005\u0007[Aqa!\u000e\u0001\t\u0013\u00199dB\u0004\u0004D\u001dC\ta!\u0012\u0007\r\u0019;\u0005\u0012AB$\u0011\u001d\ty\u0004\u0011C\u0001\u0007\u0013B\u0011ba\u0013A\u0005\u0004%\ta!\u0014\t\u0011\re\u0003\t)A\u0005\u0007\u001fBqaa\u0017A\t\u0003\u0019i\u0006C\u0005\u0004n\u0001\u000b\n\u0011\"\u0001\u0004p\t\u0001C+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0015\tA\u0015*\u0001\u0003uS\u0016\u0014(\"\u0001&\u0002\u000b-\fgm[1\u0004\u0001M!\u0001!T*Z!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0019\te.\u001f*fMB\u0011AkV\u0007\u0002+*\u0011a+S\u0001\u0006kRLGn]\u0005\u00031V\u0013q\u0001T8hO&tw\r\u0005\u0002[;6\t1L\u0003\u0002]\u0013\u000611/\u001a:wKJL!AX.\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002bU6\t!M\u0003\u0002dI\u0006!Q\u000f^5m\u0015\taVM\u0003\u0002KM*\u0011q\r[\u0001\u0007CB\f7\r[3\u000b\u0003%\f1a\u001c:h\u0013\tY'MA\u0005TG\",G-\u001e7fe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001.o\u0013\ty7L\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\u0005\u0002sk6\t1O\u0003\u0002u\u000f\u0006)Ao\u001c9jG&\u0011ao\u001d\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018!E5oSRL\u0017\r\\%oi\u0016\u0014h/\u00197NgB\u0011a*_\u0005\u0003u>\u0013A\u0001T8oO\u0006q\u0012N\\5uS\u0006dW*\u0019=J]B\u0014xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u001d\t\u0003\u001dvL!A`(\u0003\u0007%sG/\u0001\tj]&$\u0018.\u00197CC\u000e\\wN\u001a4Ng\u0006iA/[3s\u001d\u0006lWm\u001d9bG\u0016\u0004B!!\u0002\u0002\u00149!\u0011qAA\b!\r\tIaT\u0007\u0003\u0003\u0017Q1!!\u0004L\u0003\u0019a$o\\8u}%\u0019\u0011\u0011C(\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\tbT\u0001\u0005i&lW\r\u0005\u0003\u0002\u001e\u0005\u0015RBAA\u0010\u0015\r1\u0016\u0011\u0005\u0006\u0004\u0003G)\u0017AB2p[6|g.\u0003\u0003\u0002(\u0005}!\u0001\u0002+j[\u0016\fA\u0003^5fe>\u0013'.Z2u\u000f\u000e\u001bV\u000f\u001d9mS\u0016\u0014\b#\u0002(\u0002.\u0005E\u0012bAA\u0018\u001f\n1q\n\u001d;j_:\u0004RATA\u001a\u0003oI1!!\u000eP\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0003\u0002:\u0005mR\"A$\n\u0007\u0005urI\u0001\u000eUS\u0016\u0014xJ\u00196fGR<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGR|'/\u0001\u0004=S:LGO\u0010\u000b\u0015\u0003\u0007\n)%a\u0012\u0002J\u0005-\u0013QJA(\u0003#\n\u0019&!\u0016\u0011\u0007\u0005e\u0002\u0001C\u0003`\u0015\u0001\u0007\u0001\rC\u0003m\u0015\u0001\u0007Q\u000eC\u0003q\u0015\u0001\u0007\u0011\u000fC\u0003x\u0015\u0001\u0007\u0001\u0010C\u0003|\u0015\u0001\u0007A\u0010C\u0003\u0000\u0015\u0001\u0007\u0001\u0010C\u0004\u0002\u0002)\u0001\r!a\u0001\t\u000f\u0005e!\u00021\u0001\u0002\u001c!I\u0011\u0011\u0006\u0006\u0011\u0002\u0003\u0007\u00111F\u0001\u0010Y\u0006\u001cH\u000fS3beR\u0014W-\u0019;NgV\u0011\u00111\f\t\u0005\u0003;\ni'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u0019\tGo\\7jG*!\u0011QMA4\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004G\u0006%$BAA6\u0003\u0011Q\u0017M^1\n\t\u0005=\u0014q\f\u0002\u000b\u0003R|W.[2M_:<\u0017\u0001\u00057bgRDU-\u0019:uE\u0016\fG/T:!\u00031I7/\u00138X_J\\Gj\\8q+\t\t9\b\u0005\u0003\u0002^\u0005e\u0014\u0002BA>\u0003?\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017!D5t\u0013:<vN]6M_>\u0004\b%A\u0007uS\u0016\u0014Hk\u001c9jG:\u000bW.Z\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000bI'\u0001\u0003mC:<\u0017\u0002BA\u000b\u0003\u000f\u000ba\u0002^5feR{\u0007/[2OC6,\u0007%\u0001\u0005mSN$XM\\3s+\t\t\u0019\n\u0005\u0003\u0002:\u0005U\u0015bAAL\u000f\nyB)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:DQ\u0006tw-\u001a'jgR,g.\u001a:\u0002\u00191L7\u000f^3oKJ|F%Z9\u0015\t\u0005u\u00151\u0015\t\u0004\u001d\u0006}\u0015bAAQ\u001f\n!QK\\5u\u0011%\t)KEA\u0001\u0002\u0004\t\u0019*A\u0002yIE\n\u0011\u0002\\5ti\u0016tWM\u001d\u0011\u000271\f7\u000f\u001e#fY\u0016$X\r\u001a)beRLG/[8o\u0007\",7m['t+\u0005A\u0018a\b7bgR$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn\u00115fG.l5o\u0018\u0013fcR!\u0011QTAY\u0011!\t)+FA\u0001\u0002\u0004A\u0018\u0001\b7bgR$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn\u00115fG.l5\u000fI\u0001\u000e]Vl\u0017J\u001c)s_\u001e\u0014Xm]:\u0016\u0003q\f\u0011C\\;n\u0013:\u0004&o\\4sKN\u001cx\fJ3r)\u0011\ti*!0\t\u0011\u0005\u0015\u0006$!AA\u0002q\faB\\;n\u0013:\u0004&o\\4sKN\u001c\b%\u0001\u000bj[6LwM]1uK\u0012\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u000b\u0004r!a2\u0002Rr\f).\u0004\u0002\u0002J*!\u00111ZAg\u0003\u001diW\u000f^1cY\u0016T1!a4P\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003'\fIMA\u0002NCB\u0004B!!\u000f\u0002X&\u0019\u0011\u0011\\$\u00039%kW.[4sCR,G\rV5feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)\u0012.\\7jOJ\fG/\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013aD2p_J$\u0017N\\1u_J$\u0016m]6\u0016\u0005\u0005\u0005\b\u0007BAr\u0003_\u0004b!!:\u0002h\u0006-XBAA2\u0013\u0011\tI/a\u0019\u0003\u001fM\u001b\u0007.\u001a3vY\u0016$g)\u001e;ve\u0016\u0004B!!<\u0002p2\u0001AaCAy=\u0005\u0005\t\u0011!B\u0001\u0003{\u00141a\u0018\u00132\u0003A\u0019wn\u001c:eS:\fGo\u001c:UCN\\\u0007\u0005K\u0002\u001f\u0003o\u00042ATA}\u0013\r\tYp\u0014\u0002\tm>d\u0017\r^5mKF!\u0011q B\u0003!\rq%\u0011A\u0005\u0004\u0005\u0007y%a\u0002(pi\"Lgn\u001a\t\u0004\u001d\n\u001d\u0011b\u0001B\u0005\u001f\n\u0019\u0011I\\=\u0002'\r|wN\u001d3j]\u0006$xN\u001d+bg.|F%Z9\u0015\t\u0005u%q\u0002\u0005\n\u0003Kk\u0012\u0011!a\u0001\u0005#\u0001DAa\u0005\u0003\u0018A1\u0011Q]At\u0005+\u0001B!!<\u0003\u0018\u0011a\u0011\u0011\u001fB\b\u0003\u0003\u0005\tQ!\u0001\u0002~\u000611m\u001c8gS\u001e,\"A!\b\u0011\t\u0005e\"qD\u0005\u0004\u0005C9%AB\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!!(\u0003(!I\u0011Q\u0015\u0011\u0002\u0002\u0003\u0007!QD\u0001\bG>tg-[4!Q\r\t\u0013q_\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0005c\u0001BAa\r\u0003:5\u0011!Q\u0007\u0006\u0004\u0005o!\u0017aB7fiJL7m]\u0005\u0005\u0005w\u0011)DA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkB\fQ\"\\3ue&\u001c7o\u0012:pkB\u0004\u0013!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0005\u0007\u0002bA!\u0012\u0003H\u0005\rQBAAg\u0013\u0011\u0011I%!4\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011Q\u0014B(\u0011\u001d\u0011\t&\na\u0001\u0005'\n\u0011B\\3x\u0007>tg-[4\u0011\u0007i\u0013)&C\u0002\u0003Xm\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\tiJ!\u0018\u0003b!9!q\f\u0014A\u0002\tM\u0013!C8mI\u000e{gNZ5h\u0011\u001d\u0011\tF\na\u0001\u0005'\nqa\u001d;beR,\b\u000f\u0006\u0002\u0002\u001e\u0006\t\u0002.\u00198eY\u0016LU.\\5he\u0006$\u0018n\u001c8\u0015\t\u0005u%1\u000e\u0005\u0007\u0005[B\u0003\u0019\u0001?\u0002)QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\%e\u0003AA\u0017M\u001c3mK\u0016k\u0017n\u001a:bi&|g\u000e\u0006\u0003\u0002\u001e\nM\u0004B\u0002B7S\u0001\u0007A0\u0001\tsK\u001eL7\u000f^3s\u0019&\u001cH/\u001a8feR!\u0011Q\u0014B=\u0011\u001d\tyI\u000ba\u0001\u0003'\u000b\u0001b\u001d5vi\u0012|wO\\\u0001\u0011gR\f'\u000f^\"p_J$\u0017N\\1u_J$B!!(\u0003\u0002\"A!1\u0011\u0017\u0011\u0002\u0003\u0007A0A\u0003eK2\f\u00170\u0001\u000eti\u0006\u0014HoQ8pe\u0012Lg.\u0019;pe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\n*\u001aAPa#,\u0005\t5\u0005\u0003\u0002BH\u00053k!A!%\u000b\t\tM%QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa&P\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00057\u0013\tJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqb\u001d;pa\u000e{wN\u001d3j]\u0006$xN]\u0001\nQ\u0016\f'\u000f\u001e2fCR\fa\u0001Z8X_J\\\u0017!\u00064j]\u0012$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0010[\u0006\\W\r\u0016:b]NLG/[8og\u0006A2m\u001c7mK\u000e$H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0011\t-&Q\u0018Be\u0005\u001b\u0004bA\u0014BWq\nE\u0016b\u0001BX\u001f\n1A+\u001e9mKJ\u0002BAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0005o\u000bI'A\u0002oS>LAAa/\u00036\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\t}6\u00071\u0001\u0003B\u0006\u0011B/[3s)>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011\u0019M!2\u000e\u0005\u0005\u0005\u0012\u0002\u0002Bd\u0003C\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0003LN\u0002\r\u0001_\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0003PN\u0002\rA!-\u0002\u001f\u0005dGn\\2bi\u0016$')\u001e4gKJ\f\u0001D];o\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_J$\u0016m]6t\u0003ei\u0017-\u001f2f\u0005\u0016<\u0017N\\'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u0002%5\f\u0017PY3CK\u001eLg\u000eR3mKRLwN\\\u0001\u0010iJ\f7m[%oSRdU-\u00193feRA\u0011Q\u0014Bn\u0005;\u00149\u000f\u0003\u0004\u0003n]\u0002\r\u0001 \u0005\b\u0005?<\u0004\u0019\u0001Bq\u00031qWm\u001e)beRLG/[8o!\u0011\tIDa9\n\u0007\t\u0015xI\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9!\u0011^\u001cA\u0002\t-\u0018!G2sK\u0006$\u0018n\u001c8PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195PaR\u0004RATA\u0017\u0005[\u0004BAa<\u0003v6\u0011!\u0011\u001f\u0006\u0004\u0005g,\u0017\u0001\u0002:bMRLAAa>\u0003r\nqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0017a\b;sC\u000e\\\u0007K]3J]&$\u0018.\u0019;f!\u0006\u0014H/\u001b;j_:$U\r\\3uKRA\u0011Q\u0014B\u007f\u0005\u007f\u001c\u0019\u0001\u0003\u0004\u0003na\u0002\r\u0001 \u0005\b\u0007\u0003A\u0004\u0019\u0001Bq\u0003A!W\r\\3uK\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0004\u0006a\u0002\r\u0001_\u0001\ni&lWm\u001d;b[B\fA\u0004\u001e:bG.Le.\u001b;jCR,\u0007+\u0019:uSRLwN\u001c#fY\u0016$X\r\u0006\u0005\u0002\u001e\u000e-1QBB\b\u0011\u0019\u0011i'\u000fa\u0001y\"91\u0011A\u001dA\u0002\t\u0005\bBBB\ts\u0001\u0007\u00010\u0001\u0004pM\u001a\u001cX\r^\u0001\u001diJ\f7m[\"p[BdW\r^3QCJ$\u0018\u000e^5p]\u0012+G.\u001a;f)\u0019\tija\u0006\u0004\u001a!1!Q\u000e\u001eA\u0002qDqa!\u0001;\u0001\u0004\u0011\t\u000f\u0006\u0003\u0002\u001e\u000eu\u0001bBB\u0010w\u0001\u0007!QD\u0001\u000faJ|\u0007o\\:fI\u000e{gNZ5h\u0003E)\b\u000fZ1uKN#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0007\u0003;\u001b)ca\n\t\r\t5D\b1\u0001}\u0011\u0019\u0019I\u0003\u0010a\u0001q\u0006qa.Z<Ti\u0006\u0014Ho\u00144gg\u0016$\u0018a\b;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i!>\u001c\u0018\u000e^5p]V\u00111q\u0006\t\t\u0005\u000b\u001a\tD!1\u00044%!\u00111[Ag!\u0011q\u0015Q\u0006=\u0002!\r\fgnY3m\u0013:\u0004&o\\4sKN\u001cH\u0003BAO\u0007sAqaa\u000f?\u0001\u0004\u0019i$\u0001\nj]B\u0013xn\u001a:fgN$U\r\\3uS>t\u0007\u0003BA\u001d\u0007\u007fI1a!\u0011H\u0005IIe\u000e\u0015:pOJ,7o\u001d#fY\u0016$\u0018n\u001c8\u0002AQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0004\u0003s\u00015C\u0001!N)\t\u0019)%A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\r=\u0003CBB)\u0007/\n\u0019)\u0004\u0002\u0004T)!1QKAg\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003J\rM\u0013A\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002\u0017Mt\u0017\r]:i_R$\u0015N\u001d\u000b\u0005\u0007?\u001aY\u0007\u0005\u0003\u0004b\r\u001dTBAB2\u0015\u0011\u0019)G!.\u0002\t\u0019LG.Z\u0005\u0005\u0007S\u001a\u0019G\u0001\u0003QCRD\u0007\"\u00027E\u0001\u0004i\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0004r)\"\u00111\u0006BF\u0001")
public class TierDeletedPartitionsCoordinator
implements Logging,
BrokerReconfigurable {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TierTopicConsumer tierTopicConsumer;
    public final Time kafka$tier$TierDeletedPartitionsCoordinator$$time;
    private final Option<Function0<TierObjectGarbageCollector>> tierObjectGCSupplier;
    private final AtomicLong kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs;
    private final AtomicBoolean isInWorkLoop;
    private final String tierTopicName;
    private DeletedPartitionsChangeListener listener;
    private long lastDeletedPartitionCheckMs;
    private int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    private final scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions;
    private volatile ScheduledFuture<?> coordinatorTask;
    private volatile Config config;
    private final KafkaMetricsGroup metricsGroup;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<Function0<TierObjectGarbageCollector>> $lessinit$greater$default$9() {
        return TierDeletedPartitionsCoordinator$.MODULE$.$lessinit$greater$default$9();
    }

    public static Path snapshotDir(ReplicaManager replicaManager) {
        return TierDeletedPartitionsCoordinator$.MODULE$.snapshotDir(replicaManager);
    }

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicLong kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs;
    }

    private AtomicBoolean isInWorkLoop() {
        return this.isInWorkLoop;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private DeletedPartitionsChangeListener listener() {
        return this.listener;
    }

    private void listener_$eq(DeletedPartitionsChangeListener x$1) {
        this.listener = x$1;
    }

    private long lastDeletedPartitionCheckMs() {
        return this.lastDeletedPartitionCheckMs;
    }

    private void lastDeletedPartitionCheckMs_$eq(long x$1) {
        this.lastDeletedPartitionCheckMs = x$1;
    }

    public int kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() {
        return this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress;
    }

    private void kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(int x$1) {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = x$1;
    }

    public scala.collection.mutable.Map<Object, ImmigratedTierTopicPartition> immigratedPartitions() {
        return this.immigratedPartitions;
    }

    private ScheduledFuture<?> coordinatorTask() {
        return this.coordinatorTask;
    }

    private void coordinatorTask_$eq(ScheduledFuture<?> x$1) {
        this.coordinatorTask = x$1;
    }

    private Config config() {
        return this.config;
    }

    private void config_$eq(Config x$1) {
        this.config = x$1;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierDeletedPartitionsCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Config proposedConfigs = new Config(Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicDeleteCheckIntervalMs()), Predef$.MODULE$.Integer2int(newConfig.confluentConfig().tierTopicDeleteMaxInprogressPartitions()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicDeleteBackoffMs()));
        this.reconfigure(proposedConfigs);
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Starting up TierDeletedPartitionCoordinator with config=").append(this.config()).toString());
        this.startCoordinator(100);
    }

    public void handleImmigration(int tierTopicPartitionId) {
        synchronized (this) {
            Option tierObjectGarbageCollectorOpt = this.tierObjectGCSupplier.map((Function1 & Serializable & scala.Serializable)x$2 -> (TierObjectGarbageCollector)x$2.apply());
            ImmigratedTierTopicPartition cfr_ignored_0 = (ImmigratedTierTopicPartition)this.immigratedPartitions().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Function0 & Serializable & scala.Serializable)() -> new ImmigratedTierTopicPartition((Option<TierObjectGarbageCollector>)tierObjectGarbageCollectorOpt));
            return;
        }
    }

    public synchronized void handleEmigration(int tierTopicPartitionId) {
        this.immigratedPartitions().remove((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)emigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$1(this, emigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void registerListener(DeletedPartitionsChangeListener listener) {
        this.listener_$eq(listener);
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down TierDeletedPartitionCoordinator.");
        this.stopCoordinator();
        this.removeMetrics$1();
    }

    private void startCoordinator(int delay) {
        if (this.coordinatorTask() != null) {
            throw new IllegalStateException("Attempt to start a duplicate coordinator");
        }
        this.coordinatorTask_$eq(this.scheduler.schedule("tier-deleted-partition-task", () -> this.doWork(), (long)delay, Math.min(60000L, this.config().intervalMs())));
    }

    private int startCoordinator$default$1() {
        return 0;
    }

    private void stopCoordinator() {
        if (this.coordinatorTask() != null) {
            this.coordinatorTask().cancel(false);
            this.coordinatorTask_$eq(null);
        }
    }

    public void heartbeat() {
        this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs().set(this.kafka$tier$TierDeletedPartitionsCoordinator$$time.milliseconds());
    }

    public void doWork() {
        block8: {
            block7: {
                try {
                    try {
                        if (!this.isInWorkLoop().compareAndSet(false, true)) {
                            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Work loop is already running; backing off");
                            break block7;
                        }
                        this.heartbeat();
                        long now = this.kafka$tier$TierDeletedPartitionsCoordinator$$time.hiResClockMs();
                        if (this.lastDeletedPartitionCheckMs() == 0L || now - this.lastDeletedPartitionCheckMs() >= this.config().intervalMs()) {
                            this.findDeletedPartitions();
                            this.runGarbageCollectorTasks();
                            this.lastDeletedPartitionCheckMs_$eq(now);
                        }
                        this.makeTransitions();
                    }
                    catch (Exception e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caught exception in work loop", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    }
                    break block8;
                }
                finally {
                    this.isInWorkLoop().set(false);
                }
            }
            return;
        }
    }

    private void findDeletedPartitions() {
        ObjectRef allocatedBuffer = ObjectRef.create((Object)ByteBuffer.allocate(10000));
        this.tierTopicPartitionsWithPosition().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$findDeletedPartitions$1(this, allocatedBuffer, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void makeTransitions() {
        this.maybeBeginMaterialization();
        this.maybeBeginDeletion();
    }

    public Tuple2<Object, ByteBuffer> collectDeletedPartitions(TopicPartition tierTopicPartition, long startOffset, ByteBuffer allocatedBuffer) {
        Tuple2 tuple2;
        ByteBuffer buffer = allocatedBuffer;
        HostedPartition hostedPartition = this.replicaManager.getPartition(tierTopicPartition);
        if (hostedPartition instanceof HostedPartition.Online) {
            AbstractLog log = ((HostedPartition.Online)hostedPartition).partition().localLogOrException();
            long lastOffset = log.highWatermark();
            LongRef currentOffset = LongRef.create((long)startOffset);
            while (currentOffset.elem < lastOffset) {
                MemoryRecords memoryRecords;
                if (!this.immigratedPartitions().contains((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition.partition()))) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append(tierTopicPartition).append(" no longer hosted on this broker, stopping materialization from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
                }
                AbstractFetchDataInfo abstractFetchDataInfo = log.read(currentOffset.elem, buffer.capacity(), FetchIsolation.HIGH_WATERMARK, true, false);
                if (!(abstractFetchDataInfo instanceof FetchDataInfo)) {
                    throw new IllegalStateException(new StringBuilder(44).append("Unexpected tiered segment for tier topic in ").append(tierTopicPartition).toString());
                }
                FetchDataInfo fetchDataInfo = (FetchDataInfo)abstractFetchDataInfo;
                Records records = fetchDataInfo.records;
                if (records instanceof MemoryRecords) {
                    memoryRecords = (MemoryRecords)records;
                } else if (records instanceof FileRecords) {
                    FileRecords fileRecords = (FileRecords)records;
                    buffer.clear();
                    if (buffer.capacity() < fileRecords.sizeInBytes()) {
                        buffer = ByteBuffer.allocate(fileRecords.sizeInBytes());
                    }
                    fileRecords.readInto(buffer, 0);
                    memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                } else {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unexpected record type ").append(records).toString());
                }
                ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(memoryRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$2(this, tierTopicPartition, currentOffset, batch);
                    return BoxedUnit.UNIT;
                });
                lastOffset = Math.min(lastOffset, log.highWatermark());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Processed messages in ").append(tierTopicPartition).append(" from offset ").append(startOffset).append(" to ").append(currentOffset$1.elem).toString());
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)currentOffset.elem), (Object)buffer);
        } else {
            boolean bl = HostedPartition$None$.MODULE$.equals(hostedPartition) ? true : (HostedPartition$Offline$.MODULE$.equals(hostedPartition) ? true : true);
            if (bl) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)startOffset), (Object)buffer);
            } else {
                throw new MatchError((Object)hostedPartition);
            }
        }
        return tuple2;
    }

    public synchronized void runGarbageCollectorTasks() {
        this.immigratedPartitions().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            TierDeletedPartitionsCoordinator.$anonfun$runGarbageCollectorTasks$1(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void maybeBeginMaterialization() {
        Iterator immigratedPartitionIt = this.immigratedPartitions().iterator();
        scala.collection.mutable.Map newDeletions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (this.capacity$1() > 0 && immigratedPartitionIt.hasNext()) {
            Tuple2 tuple2 = (Tuple2)immigratedPartitionIt.next();
            if (tuple2 != null) {
                int tierTopicPartitionId = tuple2._1$mcI$sp();
                ImmigratedTierTopicPartition partitionState = (ImmigratedTierTopicPartition)tuple2._2();
                if (!partitionState.inProgressDeletions().isEmpty()) continue;
                scala.collection.mutable.Map<TopicIdPartition, Object> pendingDeletions = partitionState.pendingDeletions();
                ((TraversableOnce)pendingDeletions.take(this.capacity$1())).toList().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$1(this, tierTopicPartitionId, partitionState, newDeletions, pendingDeletions, x0$1);
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            throw new MatchError(null);
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Beginning tier partition state materialization for ").append(newDeletions.map((Function1 & Serializable & scala.Serializable)x$5 -> (TopicIdPartition)x$5._1(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toString());
        newDeletions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginMaterialization$4(this, x0$2);
            return BoxedUnit.UNIT;
        });
        this.tierTopicConsumer.register((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(newDeletions).asJava());
    }

    public synchronized void maybeBeginDeletion() {
        this.immigratedPartitions().values().foreach((Function1 & Serializable & scala.Serializable)immigratedPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$1(this, immigratedPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitLeader(int tierTopicPartitionId, TopicIdPartition newPartition, Option<OffsetAndEpoch> creationOffsetAndEpochOpt) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitLeader$1(this, newPartition, creationOffsetAndEpochOpt, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackPreInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long timestamp) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackPreInitiatePartitionDelete$1(this, deletedPartition, timestamp, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackInitiatePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition, long offset) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitiatePartitionDelete$1(this, deletedPartition, offset, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void trackCompletePartitionDelete(int tierTopicPartitionId, TopicIdPartition deletedPartition) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)immigratedTierTopicPartition -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$1(this, deletedPartition, immigratedTierTopicPartition);
            return BoxedUnit.UNIT;
        });
    }

    public void reconfigure(Config proposedConfig) {
        Config currentConfig;
        Config config = currentConfig = this.config();
        if (config == null ? proposedConfig != null : !((Object)config).equals(proposedConfig)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Reconfiguring from ").append(currentConfig).append(" to ").append(proposedConfig).toString());
            long oldIntervalMs = currentConfig.intervalMs();
            long newIntervalMs = proposedConfig.intervalMs();
            this.config_$eq(proposedConfig);
            if (oldIntervalMs != newIntervalMs) {
                this.stopCoordinator();
                this.startCoordinator(this.startCoordinator$default$1());
                return;
            }
        }
    }

    private synchronized void updateStartOffset(int tierTopicPartitionId, long newStartOffset) {
        this.immigratedPartitions().get((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId)).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.lastReadOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)newStartOffset)));
            return BoxedUnit.UNIT;
        });
    }

    private synchronized Map<TopicPartition, Option<Object>> tierTopicPartitionsWithPosition() {
        return ((TraversableOnce)this.immigratedPartitions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.tierTopicName(), tierTopicPartitionId)), immigratedPartition.lastReadOffset());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private void cancelInProgress(InProgressDeletion inProgressDeletion) {
        this.listener().stopPartitionDeletion(inProgressDeletion.topicIdPartition());
        inProgressDeletion.stopMaterialization();
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq(this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() - 1);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Cancelling segment deletion for ").append(inProgressDeletion.topicIdPartition()).append(" on partition emigration").toString());
        $this.cancelInProgress(inProgressDeletion);
    }

    public static final /* synthetic */ void $anonfun$handleEmigration$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition emigratedPartition) {
        emigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable & scala.Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$handleEmigration$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    private final void removeMetrics$1() {
        this.metricsGroup().removeMetric("TierNumInProgressPartitionDeletions");
        this.metricsGroup().removeMetric("TierNumQueuedPartitionDeletions");
        this.metricsGroup().removeMetric("HeartbeatMs");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$findDeletedPartitions$1(TierDeletedPartitionsCoordinator $this, ObjectRef allocatedBuffer$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void var8_7;
            void var6_6;
            Option startOffsetOpt;
            TopicPartition tierTopicPartition = (TopicPartition)x0$1._1();
            Tuple2<Object, ByteBuffer> tuple2 = $this.collectDeletedPartitions(tierTopicPartition, BoxesRunTime.unboxToLong((Object)(startOffsetOpt = (Option)x0$1._2()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), (ByteBuffer)allocatedBuffer$1.elem);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long endOffset = tuple2._1$mcJ$sp();
            ByteBuffer buffer = (ByteBuffer)tuple2._2();
            $this.updateStartOffset(tierTopicPartition.partition(), (long)var6_6);
            allocatedBuffer$1.elem = var8_7;
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$4(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record$1, AbstractTierMetadata x0$1) {
        if (x0$1 instanceof TierTopicInitLeader) {
            TierTopicInitLeader tierTopicInitLeader = (TierTopicInitLeader)x0$1;
            $this.trackInitLeader(tierTopicPartition$1.partition(), tierTopicInitLeader.topicIdPartition(), (Option<OffsetAndEpoch>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(tierTopicInitLeader.partitionCreationOffsetAndEpoch())));
            return;
        }
        if (x0$1 instanceof TierPartitionDeletePreInitiate) {
            TierPartitionDeletePreInitiate tierPartitionDeletePreInitiate = (TierPartitionDeletePreInitiate)x0$1;
            $this.trackPreInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeletePreInitiate.topicIdPartition(), record$1.timestamp());
            return;
        }
        if (x0$1 instanceof TierPartitionDeleteInitiate) {
            TierPartitionDeleteInitiate tierPartitionDeleteInitiate = (TierPartitionDeleteInitiate)x0$1;
            $this.trackInitiatePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteInitiate.topicIdPartition(), record$1.offset());
            return;
        }
        if (x0$1 instanceof TierPartitionDeleteComplete) {
            TierPartitionDeleteComplete tierPartitionDeleteComplete = (TierPartitionDeleteComplete)x0$1;
            $this.trackCompletePartitionDelete(tierTopicPartition$1.partition(), tierPartitionDeleteComplete.topicIdPartition());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$3(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, Record record) {
        OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(AbstractTierMetadata.deserialize(record.key(), record.value(), record.timestamp()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$4($this, tierTopicPartition$1, record, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$collectDeletedPartitions$2(TierDeletedPartitionsCoordinator $this, TopicPartition tierTopicPartition$1, LongRef currentOffset$1, MutableRecordBatch batch) {
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TierDeletedPartitionsCoordinator.$anonfun$collectDeletedPartitions$3($this, tierTopicPartition$1, record);
            return BoxedUnit.UNIT;
        });
        currentOffset$1.elem = batch.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$runGarbageCollectorTasks$2(TierDeletedPartitionsCoordinator $this, TierObjectGarbageCollector garbageCollector) {
        garbageCollector.maybePreInitiatePartitionDeletion();
        garbageCollector.maybeDeletePartitions($this.config().deleteBackoffMs());
    }

    public static final /* synthetic */ void $anonfun$runGarbageCollectorTasks$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition x$4) {
        x$4.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$runGarbageCollectorTasks$2($this, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    private final int capacity$1() {
        return this.config().maxInprogressPartitions() - this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$1(TierDeletedPartitionsCoordinator $this, int tierTopicPartitionId$1, ImmigratedTierTopicPartition partitionState$1, scala.collection.mutable.Map newDeletions$1, scala.collection.mutable.Map pendingDeletions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicIdPartition partitionToDelete = (TopicIdPartition)x0$1._1();
            long deleteInitiateOffset = x0$1._2$mcJ$sp();
            TierTopicConsumer x$4 = $this.tierTopicConsumer;
            ReplicaManager x$5 = $this.replicaManager;
            Scheduler x$6 = $this.scheduler;
            Time x$7 = $this.kafka$tier$TierDeletedPartitionsCoordinator$$time;
            scala.collection.mutable.Map<UUID, TierObjectStore.ObjectMetadata> x$8 = InProgressDeletion$.MODULE$.$lessinit$greater$default$5();
            TierPartitionStatus x$9 = InProgressDeletion$.MODULE$.$lessinit$greater$default$6();
            DeletionState x$10 = InProgressDeletion$.MODULE$.$lessinit$greater$default$7();
            InProgressDeletion inProgressDeletion = new InProgressDeletion(tierTopicPartitionId$1, partitionToDelete, deleteInitiateOffset, x$4, x$8, x$9, x$10, x$5, x$6, x$7);
            partitionState$1.inProgressDeletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete), (Object)inProgressDeletion));
            newDeletions$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionToDelete), (Object)inProgressDeletion));
            pendingDeletions$1.remove((Object)partitionToDelete);
            $this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress_$eq($this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress() + 1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginMaterialization$4(TierDeletedPartitionsCoordinator $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicIdPartition partitionId = (TopicIdPartition)x0$2._1();
            $this.tierTopicConsumer.deregister(partitionId);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$2(TierDeletedPartitionsCoordinator $this, InProgressDeletion inProgressDeletion) {
        DeletionState deletionState = inProgressDeletion.deletionState();
        if (MaterializationComplete$.MODULE$.equals(deletionState)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Beginning segment deletion for ").append(inProgressDeletion.topicIdPartition()).toString());
            inProgressDeletion.awaitDeleteComplete();
            $this.listener().initiatePartitionDeletion(inProgressDeletion.topicIdPartition(), inProgressDeletion.allTieredObjects());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeBeginDeletion$1(TierDeletedPartitionsCoordinator $this, ImmigratedTierTopicPartition immigratedPartition) {
        immigratedPartition.inProgressDeletions().values().foreach((Function1 & Serializable & scala.Serializable)inProgressDeletion -> {
            TierDeletedPartitionsCoordinator.$anonfun$maybeBeginDeletion$2($this, inProgressDeletion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackInitLeader$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition newPartition$1, Option creationOffsetAndEpochOpt$1, TierObjectGarbageCollector garbageCollector) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Processing InitLeader for ").append(newPartition$1).toString());
        if (creationOffsetAndEpochOpt$1.isEmpty()) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(178).append("Init leader metadata for ").append(newPartition$1).append(" is ignored because topic creation OffsetAndEpoch is missing. ").append("It is possible that this event was generated before the cluster was upgraded to KRaft mode.").toString());
            return;
        }
        garbageCollector.addTopicPartition(newPartition$1, (OffsetAndEpoch)creationOffsetAndEpochOpt$1.get());
    }

    public static final /* synthetic */ void $anonfun$trackInitLeader$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition newPartition$1, Option creationOffsetAndEpochOpt$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackInitLeader$2($this, newPartition$1, creationOffsetAndEpochOpt$1, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackPreInitiatePartitionDelete$2(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$1, long timestamp$1, TierObjectGarbageCollector garbageCollector) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Processing PreInitiateDelete for ").append(deletedPartition$1).toString());
        garbageCollector.onPartitionDeletePreInitiate(deletedPartition$1, timestamp$1);
    }

    public static final /* synthetic */ void $anonfun$trackPreInitiatePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$1, long timestamp$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackPreInitiatePartitionDelete$2($this, deletedPartition$1, timestamp$1, garbageCollector);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackInitiatePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$2, long offset$1, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Processing InitiateDelete for ").append(deletedPartition$2).append(" at offset ").append(offset$1).toString());
        if (!immigratedTierTopicPartition.inProgressDeletions().contains((Object)deletedPartition$2)) {
            immigratedTierTopicPartition.pendingDeletions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition$2), (Object)BoxesRunTime.boxToLong((long)offset$1)));
        }
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            garbageCollector.onPartitionDeleteInitiate(deletedPartition$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$3(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$3, InProgressDeletion inProgress) {
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Completed deleting segments for ").append(deletedPartition$3).toString());
        $this.cancelInProgress(inProgress);
    }

    public static final /* synthetic */ void $anonfun$trackCompletePartitionDelete$1(TierDeletedPartitionsCoordinator $this, TopicIdPartition deletedPartition$3, ImmigratedTierTopicPartition immigratedTierTopicPartition) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Processing CompleteDelete for ").append(deletedPartition$3).toString());
        immigratedTierTopicPartition.pendingDeletions().$minus$eq((Object)deletedPartition$3);
        immigratedTierTopicPartition.inProgressDeletions().remove((Object)deletedPartition$3).foreach((Function1 & Serializable & scala.Serializable)inProgress -> {
            TierDeletedPartitionsCoordinator.$anonfun$trackCompletePartitionDelete$3($this, deletedPartition$3, inProgress);
            return BoxedUnit.UNIT;
        });
        immigratedTierTopicPartition.tierObjectGarbageCollectorOpt().foreach((Function1 & Serializable & scala.Serializable)garbageCollector -> {
            garbageCollector.onPartitionDeleteComplete(deletedPartition$3);
            return BoxedUnit.UNIT;
        });
    }

    public TierDeletedPartitionsCoordinator(Scheduler scheduler, ReplicaManager replicaManager, TierTopicConsumer tierTopicConsumer, long initialIntervalMs, int initialMaxInprogressPartitions, long initialBackoffMs, String tierNamespace, Time time, Option<Function0<TierObjectGarbageCollector>> tierObjectGCSupplier) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.tierTopicConsumer = tierTopicConsumer;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$time = time;
        this.tierObjectGCSupplier = tierObjectGCSupplier;
        Logging.$init$(this);
        this.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs = new AtomicLong(time.milliseconds());
        this.isInWorkLoop = new AtomicBoolean(false);
        this.tierTopicName = TierTopic.topicName(tierNamespace);
        this.lastDeletedPartitionCheckMs = 0L;
        this.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress = 0;
        this.immigratedPartitions = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.config = new Config(initialIntervalMs, initialMaxInprogressPartitions, initialBackoffMs);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        if (FilesWrapper.exists((Path)TierDeletedPartitionsCoordinator$.MODULE$.snapshotDir(replicaManager), (LinkOption[])new LinkOption[0])) {
            Utils.delete((File)TierDeletedPartitionsCoordinator$.MODULE$.snapshotDir(replicaManager).toFile());
        }
        this.metricsGroup().newGauge("TierNumInProgressPartitionDeletions", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$numInProgress();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge("TierNumQueuedPartitionDeletions", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.immigratedPartitions().values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            }

            public static final /* synthetic */ long $anonfun$value$1(ImmigratedTierTopicPartition x$1) {
                return x$1.pendingDeletions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.ImmigratedTierTopicPartition )}, serializedLambda);
            }
        });
        this.metricsGroup().newGauge("HeartbeatMs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierDeletedPartitionsCoordinator $outer;

            public synchronized long value() {
                return this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$time.milliseconds() - this.$outer.kafka$tier$TierDeletedPartitionsCoordinator$$lastHeartbeatMs().get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

