/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Supplier;
import kafka.cluster.Partition;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.backupObjectLifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.backupObjectLifecycle.LifecycleManager;
import kafka.tier.backupObjectLifecycle.LifecycleManagerConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\u000f\u001e\u0001\u0011B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\tw\u0001\u0011\t\u0011)A\u0005y!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00036\u0001\u0005\u0003\u0005\u000b\u0011B6\t\u0011I\u0004!\u0011!Q\u0001\nMD\u0001b\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u000b\u0003\u0013\u0001!\u0011!Q\u0001\n\u0005-\u0001bBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\n\u0003_\u0001\u0001\u0019!C\u0005\u0003cA\u0011\"a\u000f\u0001\u0001\u0004%I!!\u0010\t\u0011\u0005%\u0003\u0001)Q\u0005\u0003gAq!a\u0013\u0001\t\u0003\t\t\u0004C\u0004\u0002N\u0001!\t%a\u0014\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u000b;q!a\"\u001e\u0011\u0003\tII\u0002\u0004\u001d;!\u0005\u00111\u0012\u0005\b\u0003+1B\u0011AAG\u0011%\tyI\u0006b\u0001\n\u0003\t\t\n\u0003\u0005\u0002\u0014Z\u0001\u000b\u0011BA<\u0011%\t)J\u0006b\u0001\n\u0003\t9\n\u0003\u0005\u0002(Z\u0001\u000b\u0011BAM\u0005\u001d\u0012\u0015mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016l\u0015M\\1hKJ\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005yy\u0012!\u00062bG.,\bo\u00142kK\u000e$H*\u001b4fGf\u001cG.\u001a\u0006\u0003A\u0005\nA\u0001^5fe*\t!%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001)3&\r\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051zS\"A\u0017\u000b\u00059\n\u0013!B;uS2\u001c\u0018B\u0001\u0019.\u0005\u001daunZ4j]\u001e\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u0011\u0002\rM,'O^3s\u0013\t14G\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.Z\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\t\u0011\u0014(\u0003\u0002;g\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw\r\u0005\u00023{%\u0011ah\r\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0005dYV\u001cH/\u001a:JIB\u0011\u0011\t\u0013\b\u0003\u0005\u001a\u0003\"aQ\u0014\u000e\u0003\u0011S!!R\u0012\u0002\rq\u0012xn\u001c;?\u0013\t9u%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$(\u0003\u0001Jg\u000e^3s\u0005J|7.\u001a:DY&,g\u000e^\"p]\u001aLwm]*vaBd\u0017.\u001a:\u0011\u00075#f+D\u0001O\u0015\ty\u0005+\u0001\u0005gk:\u001cG/[8o\u0015\t\t&+\u0001\u0003vi&d'\"A*\u0002\t)\fg/Y\u0005\u0003+:\u0013\u0001bU;qa2LWM\u001d\t\u0005/b\u0003%,D\u0001Q\u0013\tI\u0006KA\u0002NCB\u0004\"a\u00170\u000e\u0003qS!!\u0018*\u0002\t1\fgnZ\u0005\u0003?r\u0013aa\u00142kK\u000e$\u0018A\u0005;jKJ|%M[3diN#xN]3PaR\u00042A\n2e\u0013\t\u0019wE\u0001\u0004PaRLwN\u001c\t\u0003K\"l\u0011A\u001a\u0006\u0003O~\tQa\u001d;pe\u0016L!!\u001b4\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5feR{\u0007/[2NC:\fw-\u001a:PaR\u00042A\n2m!\ti\u0007/D\u0001o\u0015\tyw$A\u0003u_BL7-\u0003\u0002r]\n\u0001B+[3s)>\u0004\u0018nY'b]\u0006<WM]\u0001\u0016S:$XM\u001d8bY\u0006#W.\u001b8TkB\u0004H.[3s!\riE\u000b\u001e\t\u0003eUL!A^\u001a\u0003\u001b%sG/\u001a:oC2\fE-\\5o\u0003\u0011!\u0018.\\3\u0011\u0007e\f)!D\u0001{\u0015\tq3P\u0003\u0002}{\u000611m\\7n_:T!A\t@\u000b\u0007}\f\t!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0007\t1a\u001c:h\u0013\r\t9A\u001f\u0002\u0005)&lW-A\u0004nKR\u0014\u0018nY:\u0011\t\u00055\u0011\u0011C\u0007\u0003\u0003\u001fQ1!!\u0003|\u0013\u0011\t\u0019\"a\u0004\u0003\u000f5+GO]5dg\u00061A(\u001b8jiz\"B#!\u0007\u0002\u001e\u0005}\u0011\u0011EA\u0012\u0003K\t9#!\u000b\u0002,\u00055\u0002cAA\u000e\u00015\tQ\u0004C\u00038\u0015\u0001\u0007\u0001\bC\u0003<\u0015\u0001\u0007A\bC\u0003@\u0015\u0001\u0007\u0001\tC\u0003L\u0015\u0001\u0007A\nC\u0003a\u0015\u0001\u0007\u0011\rC\u0003k\u0015\u0001\u00071\u000eC\u0003s\u0015\u0001\u00071\u000fC\u0003x\u0015\u0001\u0007\u0001\u0010C\u0004\u0002\n)\u0001\r!a\u0003\u0002/}\u001bWo\u001d;p[2Kg-Z2zG2,W*\u00198bO\u0016\u0014XCAA\u001a!\u00111#-!\u000e\u0011\t\u0005m\u0011qG\u0005\u0004\u0003si\"\u0001\u0005'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s\u0003my6-^:u_6d\u0015NZ3ds\u000edW-T1oC\u001e,'o\u0018\u0013fcR!\u0011qHA#!\r1\u0013\u0011I\u0005\u0004\u0003\u0007:#\u0001B+oSRD\u0011\"a\u0012\r\u0003\u0003\u0005\r!a\r\u0002\u0007a$\u0013'\u0001\r`GV\u001cHo\\7MS\u001a,7-_2mK6\u000bg.Y4fe\u0002\nacY;ti>lG*\u001b4fGf\u001cG.Z'b]\u0006<WM]\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\t\t\u0006E\u0003\u0002T\u0005e\u0003)\u0004\u0002\u0002V)\u0019\u0011qK\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\\\u0005U#aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0005\u0003\u007f\t\t\u0007\u0003\u0004\u0002dA\u0001\r\u0001P\u0001\n]\u0016<8i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR1\u0011qHA5\u0003[Ba!a\u001b\u0012\u0001\u0004a\u0014!C8mI\u000e{gNZ5h\u0011\u0019\t\u0019'\u0005a\u0001y\u0005QqN\\#mK\u000e$\u0018n\u001c8\u0015\t\u0005}\u00121\u000f\u0005\b\u0003k\u0012\u0002\u0019AA<\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u0007\u0019\nI(C\u0002\u0002|\u001d\u00121!\u00138u\u00035ygNU3tS\u001et\u0017\r^5p]R!\u0011qHAA\u0011\u001d\t)h\u0005a\u0001\u0003o\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u007f\tqEQ1dWV\u0004xJ\u00196fGRd\u0015NZ3ds\u000edW-T1oC\u001e,'oQ8pe\u0012Lg.\u0019;peB\u0019\u00111\u0004\f\u0014\u0005Y)CCAAE\u0003Y\u0002\u0016I\u0015+J)&{ej\u0018+P?\u000e{u\fT(D\u0003R+uLQ!D\u0017V\u0003vl\u0014\"K\u000b\u000e#v\fT%G\u000b\u000eK6\tT#`\u001b\u0006s\u0015iR#S+\t\t9(A\u001cQ\u0003J#\u0016\nV%P\u001d~#vjX\"P?2{5)\u0011+F?\n\u000b5iS+Q?>\u0013%*R\"U?2Ke)R\"Z\u00072+u,T!O\u0003\u001e+%\u000bI\u0001\u0016%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\tI\n\u0005\u0004\u0002\u001c\u0006\u0005\u00161U\u0007\u0003\u0003;SA!a(\u0002V\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u00037\ni\nE\u0002\\\u0003KK!!\u0013/\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u0002\u0002")
public class BackupObjectLifecycleManagerCoordinator
implements Logging,
BrokerReconfigurable {
    private final ReplicaManager replicaManager;
    private final KafkaConfig config;
    private final String clusterId;
    private final Supplier<Map<String, Object>> interBrokerClientConfigsSupplier;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final Time time;
    private final Metrics metrics;
    private Option<LifecycleManager> _customLifecycleManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return BackupObjectLifecycleManagerCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    public static int PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() {
        return BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<LifecycleManager> _customLifecycleManager() {
        return this._customLifecycleManager;
    }

    private void _customLifecycleManager_$eq(Option<LifecycleManager> x$1) {
        this._customLifecycleManager = x$1;
    }

    public Option<LifecycleManager> customLifecycleManager() {
        return this._customLifecycleManager();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return BackupObjectLifecycleManagerCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Integer2int(newConfig.confluentConfig().customLifecycleManagerFrequencyInHours()) < 0) {
            throw new ConfigException(new StringBuilder(29).append(KafkaConfig$.MODULE$.CustomLifecycleManagerFrequencyInHoursProp()).append(" should not be less than zero").toString());
        }
        if (Predef$.MODULE$.Integer2int(newConfig.confluentConfig().clmMaxBackupInDays()) < 0) {
            throw new ConfigException(new StringBuilder(48).append(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp()).append(" must have a value greater than or equal to zero").toString());
        }
        if (Predef$.MODULE$.Integer2int(newConfig.confluentConfig().clmMinDelayInMinutes()) < 10) {
            throw new ConfigException(new StringBuilder(20).append(KafkaConfig$.MODULE$.CLMMinDelayInMinutesProp()).append(" must be at least 10").toString());
        }
        if (Predef$.MODULE$.Integer2int(newConfig.confluentConfig().clmThreadPoolSize()) < 1) {
            throw new ConfigException(new StringBuilder(19).append(KafkaConfig$.MODULE$.CLMThreadPoolSizeProp()).append(" must be at least 1").toString());
        }
        LifecycleManagerConfig.parseRetentionToBackupConfig(newConfig.confluentConfig().clmTopicRetentionInDaysToBackupInDays());
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Boolean oldCustomLifecycleManagerEnabled = oldConfig.confluentConfig().customLifecycleManagerEnabled();
        Boolean newCustomLifecycleManagerEnabled = newConfig.confluentConfig().customLifecycleManagerEnabled();
        if (!Predef$.MODULE$.Boolean2boolean(oldCustomLifecycleManagerEnabled) && Predef$.MODULE$.Boolean2boolean(newCustomLifecycleManagerEnabled)) {
            boolean bl;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append(KafkaConfig$.MODULE$.CustomLifecycleManagerEnabledProp()).append(" has been enabled").toString());
            TopicPartition tp = new TopicPartition("_confluent-tier-state", BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
            Either<Errors, Partition> either = this.replicaManager.getPartitionOrError(tp);
            if (either instanceof Right) {
                bl = ((Partition)((Right)either).value()).isLeader();
            } else if (either instanceof Left) {
                bl = false;
            } else {
                throw new MatchError(either);
            }
            if (bl) {
                this.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
            }
        }
        if (Predef$.MODULE$.Boolean2boolean(oldCustomLifecycleManagerEnabled) && !Predef$.MODULE$.Boolean2boolean(newCustomLifecycleManagerEnabled)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append(KafkaConfig$.MODULE$.CustomLifecycleManagerEnabledProp()).append(" has been disabled").toString());
            this.shutdown();
        }
    }

    public void onElection(int partitionId) {
        if (partitionId == BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() && this._customLifecycleManager().isEmpty() && Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().tierFeature()) && Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().customLifecycleManagerEnabled())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Starting an instance of backup object lifecycle manager at broker ").append($this.config.brokerId()).toString());
            this._customLifecycleManager_$eq((Option<LifecycleManager>)new Some((Object)new LifecycleManager((TierObjectStore)this.tierObjectStoreOpt.get(), new LifecycleManagerConfig(this.config, this.clusterId, this.interBrokerClientConfigsSupplier, this.internalAdminSupplier), () -> Predef$.MODULE$.boolean2Boolean($this.tierTopicManagerOpt.isDefined() && ((TierTopicManager)$this.tierTopicManagerOpt.get()).isReadyForWrites()), () -> $this.config.confluentConfig().customLifecycleManagerEnabled(), this.time, this.metrics)));
            ((Thread)this._customLifecycleManager().get()).start();
            return;
        }
    }

    public void onResignation(int partitionId) {
        if (partitionId == BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER()) {
            this.shutdown();
        }
    }

    public void shutdown() {
        if (this._customLifecycleManager().isDefined()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Shutting down the instance of backup object lifecycle manager at broker ").append($this.config.brokerId()).toString());
            ((LifecycleManager)((Object)this._customLifecycleManager().get())).shutdown();
            this._customLifecycleManager_$eq((Option<LifecycleManager>)None$.MODULE$);
        }
    }

    public BackupObjectLifecycleManagerCoordinator(ReplicaManager replicaManager, KafkaConfig config, String clusterId, Supplier<Map<String, Object>> interBrokerClientConfigsSupplier, Option<TierObjectStore> tierObjectStoreOpt, Option<TierTopicManager> tierTopicManagerOpt, Supplier<InternalAdmin> internalAdminSupplier, Time time, Metrics metrics) {
        this.replicaManager = replicaManager;
        this.config = config;
        this.clusterId = clusterId;
        this.interBrokerClientConfigsSupplier = interBrokerClientConfigsSupplier;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.tierTopicManagerOpt = tierTopicManagerOpt;
        this.internalAdminSupplier = internalAdminSupplier;
        this.time = time;
        this.metrics = metrics;
        Logging.$init$(this);
        this._customLifecycleManager = None$.MODULE$;
    }
}

