/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator$;
import kafka.tier.snapshot.TierTopicSnapshotManager;
import kafka.tier.store.TierObjectStore;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005]v!B\u0011#\u0011\u0003Ic!B\u0016#\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004\u0002C\u001b\u0002\u0005\u0004%\tA\t\u001c\t\ri\n\u0001\u0015!\u00038\u0011\u001dY\u0014A1A\u0005\u0002qBaaS\u0001!\u0002\u0013id\u0001B\u0016#\u00011C\u0001\"W\u0004\u0003\u0002\u0003\u0006IA\u0017\u0005\t;\u001e\u0011\t\u0011)A\u0005\u0011\"Aal\u0002B\u0001B\u0003%q\f\u0003\u0005t\u000f\t\u0005\t\u0015!\u0003u\u0011!9xA!A!\u0002\u0013A\bBCA\u0002\u000f\t\u0005\t\u0015!\u0003\u0002\u0006!Q\u0011QD\u0004\u0003\u0002\u0003\u0006I!a\b\t\rM:A\u0011AA\u0015\u0011%\tYd\u0002a\u0001\n\u0013\ti\u0004C\u0005\u0002H\u001d\u0001\r\u0011\"\u0003\u0002J!A\u0011QK\u0004!B\u0013\ty\u0004C\u0005\u0002X\u001d\u0011\r\u0011\"\u0003\u0002Z!9\u00111L\u0004!\u0002\u0013i\u0007\u0002CA/\u000f\u0011\u0005!%!\u0010\t\u000f\u0005}s\u0001\"\u0001\u0002b!9\u0011qM\u0004\u0005\n\u0005%\u0004bBA7\u000f\u0011\u0005\u0011q\u000e\u0005\b\u0003g:A\u0011AA;\u0011\u001d\t9h\u0002C!\u0003sBq!!\"\b\t\u0003\n9\tC\u0004\u0002\u000e\u001e!\t%a$\t\u0011\u0005]u\u0001\"\u0001#\u00033C\u0001\"a(\b\u0005\u0004%IA\u000e\u0005\b\u0003C;\u0001\u0015!\u00038\u0011\u001d\t\u0019k\u0002C\u0005\u0003K\u000bA\u0004V5feR{\u0007/[2T]\u0006\u00048\u000f[8u\u0007>|'\u000fZ5oCR|'O\u0003\u0002$I\u0005A1O\\1qg\"|GO\u0003\u0002&M\u0005!A/[3s\u0015\u00059\u0013!B6bM.\f7\u0001\u0001\t\u0003U\u0005i\u0011A\t\u0002\u001d)&,'\u000fV8qS\u000e\u001cf.\u00199tQ>$8i\\8sI&t\u0017\r^8s'\t\tQ\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\na\u0003U!S)&#\u0016j\u0014(`)>{6iT0M\u001f\u000e\u000bE+R\u000b\u0002oA\u0011a\u0006O\u0005\u0003s=\u00121!\u00138u\u0003]\u0001\u0016I\u0015+J)&{ej\u0018+P?\u000e{u\fT(D\u0003R+\u0005%A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0003u\u00022AP#I\u001d\ty4\t\u0005\u0002A_5\t\u0011I\u0003\u0002CQ\u00051AH]8pizJ!\u0001R\u0018\u0002\rA\u0013X\rZ3g\u0013\t1uIA\u0002TKRT!\u0001R\u0018\u0011\u0005yJ\u0015B\u0001&H\u0005\u0019\u0019FO]5oO\u00061\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\be\u0005\u0003\b[5\u001b\u0006C\u0001(R\u001b\u0005y%B\u0001)'\u0003\u0015)H/\u001b7t\u0013\t\u0011vJA\u0004M_\u001e<\u0017N\\4\u0011\u0005Q;V\"A+\u000b\u0005Y3\u0013AB:feZ,'/\u0003\u0002Y+\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\faaY8oM&<\u0007C\u0001+\\\u0013\taVKA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!C2mkN$XM]%e\u0003aIg\u000e^3s\u0005J|7.\u001a:DY&,g\u000e^\"p]\u001aLwm\u001d\t\u0004A\u001eLW\"A1\u000b\u0005\t\u001c\u0017\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0005\u0011,\u0017\u0001B;uS2T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iC\nA1+\u001e9qY&,'\u000f\u0005\u0003kW\"kW\"A2\n\u00051\u001c'aA'baB\u0011a.]\u0007\u0002_*\u0011\u0001/Z\u0001\u0005Y\u0006tw-\u0003\u0002s_\n1qJ\u00196fGR\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002Uk&\u0011a/\u0016\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0011\u00079J80\u0003\u0002{_\t1q\n\u001d;j_:\u0004\"\u0001`@\u000e\u0003uT!A \u0013\u0002\u000bM$xN]3\n\u0007\u0005\u0005QPA\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0003\u0011!\u0018.\\3\u0011\t\u0005\u001d\u0011\u0011D\u0007\u0003\u0003\u0013Q1\u0001UA\u0006\u0015\u0011\ti!a\u0004\u0002\r\r|W.\\8o\u0015\r9\u0013\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003/\t1a\u001c:h\u0013\u0011\tY\"!\u0003\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t\t#!\n\u000e\u0005\u0005\r\"\u0002BA\u000f\u0003\u0017IA!a\n\u0002$\t9Q*\u001a;sS\u000e\u001cH\u0003EA\u0016\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d!\tQs\u0001C\u0003Z\u001f\u0001\u0007!\fC\u0003^\u001f\u0001\u0007\u0001\nC\u0003_\u001f\u0001\u0007q\fC\u0003t\u001f\u0001\u0007A\u000fC\u0003x\u001f\u0001\u0007\u0001\u0010C\u0004\u0002\u0004=\u0001\r!!\u0002\t\u000f\u0005uq\u00021\u0001\u0002 \u0005Ir\f^5feR{\u0007/[2T]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3s+\t\ty\u0004\u0005\u0003/s\u0006\u0005\u0003c\u0001\u0016\u0002D%\u0019\u0011Q\t\u0012\u00031QKWM\u001d+pa&\u001c7K\\1qg\"|G/T1oC\u001e,'/A\u000f`i&,'\u000fV8qS\u000e\u001cf.\u00199tQ>$X*\u00198bO\u0016\u0014x\fJ3r)\u0011\tY%!\u0015\u0011\u00079\ni%C\u0002\u0002P=\u0012A!\u00168ji\"I\u00111K\t\u0002\u0002\u0003\u0007\u0011qH\u0001\u0004q\u0012\n\u0014AG0uS\u0016\u0014Hk\u001c9jGNs\u0017\r]:i_Rl\u0015M\\1hKJ\u0004\u0013\u0001\u00027pG.,\u0012!\\\u0001\u0006Y>\u001c7\u000eI\u0001\u0019i&,'\u000fV8qS\u000e\u001cf.\u00199tQ>$X*\u00198bO\u0016\u0014\u0018AC8o\u000b2,7\r^5p]R!\u00111JA2\u0011\u0019\t)G\u0006a\u0001o\u0005Y\u0001/\u0019:uSRLwN\\%e\u0003\u001d\u0019H/\u0019:ukB$B!a\u0013\u0002l!1\u0011QM\fA\u0002]\nQb\u001c8SKNLwM\\1uS>tG\u0003BA&\u0003cBa!!\u001a\u0019\u0001\u00049\u0014\u0001C:ikR$wn\u001e8\u0015\u0005\u0005-\u0013!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0003\u0003w\u0002R!! \u0002\u0004\"k!!a \u000b\u0007\u0005\u0005u&\u0001\u0006d_2dWm\u0019;j_:L1ARA@\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002L\u0005%\u0005BBAF7\u0001\u0007!,A\u0005oK^\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\tY%!%\u0002\u0016\"1\u00111\u0013\u000fA\u0002i\u000b\u0011b\u001c7e\u0007>tg-[4\t\r\u0005-E\u00041\u0001[\u0003eawnY1m%\u0016\u0004H.[2b\u000bB|7\r[%g\u0019\u0016\fG-\u001a:\u0015\u0007]\nY\n\u0003\u0004\u0002\u001ev\u0001\raN\u0001\na\u0006\u0014H/\u001b;j_:\f\u0011$T!Y?B\u000b%\u000bV%U\u0013>suLR#U\u0007\"{&)\u0017+F'\u0006QR*\u0011-`!\u0006\u0013F+\u0013+J\u001f:{f)\u0012+D\u0011~\u0013\u0015\fV#TA\u0005iq-\u001a;Qe>\u0004XM\u001d;jKN$\u0002\"a*\u0002.\u0006=\u0016\u0011\u0017\t\u0004U\u0006%\u0016bAAVG\nQ\u0001K]8qKJ$\u0018.Z:\t\u000be\u0003\u0003\u0019\u0001.\t\u000bu\u0003\u0003\u0019\u0001%\t\ry\u0003\u0003\u0019AAZ!\u0011\u0001w-!.\u0011\t)\\\u0007*\f")
public class TierTopicSnapshotCoordinator
implements Logging,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final String clusterId;
    private final Supplier<Map<String, Object>> interBrokerClientConfigs;
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Time time;
    private final Metrics metrics;
    private Option<TierTopicSnapshotManager> _tierTopicSnapshotManager;
    private final Object lock;
    private final int MAX_PARTITION_FETCH_BYTES;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static scala.collection.immutable.Set<String> ReconfigurableConfigs() {
        return TierTopicSnapshotCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Option<TierTopicSnapshotManager> _tierTopicSnapshotManager() {
        return this._tierTopicSnapshotManager;
    }

    private void _tierTopicSnapshotManager_$eq(Option<TierTopicSnapshotManager> x$1) {
        this._tierTopicSnapshotManager = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    public Option<TierTopicSnapshotManager> tierTopicSnapshotManager() {
        return this._tierTopicSnapshotManager();
    }

    public void onElection(int partitionId) {
        if (partitionId == TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE() && BoxesRunTime.equals((Object)this.config.confluentConfig().tierFeature(), (Object)BoxesRunTime.boxToBoolean((boolean)true)) && BoxesRunTime.equals((Object)this.config.confluentConfig().tierTopicSnapshotsEnable(), (Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            this.startup(partitionId);
        }
    }

    private void startup(int partitionId) {
        Object object = this.lock();
        synchronized (object) {
            int epoch = this.localReplicaEpochIfLeader(partitionId);
            if (this._tierTopicSnapshotManager().isEmpty() && epoch != -1) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Starting the instance of tier topic snapshot manager(broker: ").append($this.config.brokerId()).append(", epoch: ").append(epoch).append(")").toString());
                this._tierTopicSnapshotManager_$eq((Option<TierTopicSnapshotManager>)new Some((Object)new TierTopicSnapshotManager((Consumer<byte[], byte[]>)new KafkaConsumer(this.getProperties(this.config, this.clusterId, this.interBrokerClientConfigs)), (TierObjectStore)this.tierObjectStoreOpt.get(), Predef$.MODULE$.int2Integer(epoch), this.config.confluentConfig().tierMetadataNumPartitions(), this.config.confluentConfig().tierTopicSnapshotsIntervalMs(), this.config.confluentConfig().tierTopicSnapshotsMaxRecordsPerSnapshot(), this.config.confluentConfig().tierTopicSnapshotsRetentionHours(), this.time, this.metrics)));
                this._tierTopicSnapshotManager().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.start();
                    return BoxedUnit.UNIT;
                });
            } else if (this._tierTopicSnapshotManager().isDefined()) {
                this.liftedTree1$1(epoch);
            }
            return;
        }
    }

    public void onResignation(int partitionId) {
        if (partitionId == TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE()) {
            this.shutdown();
        }
    }

    public void shutdown() {
        Object object = this.lock();
        synchronized (object) {
            if (this._tierTopicSnapshotManager().isDefined()) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Shutting down the instance of tier topic snapshot manager(broker: ").append($this.config.brokerId()).append(")").toString());
                this._tierTopicSnapshotManager().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.shutdown();
                    return BoxedUnit.UNIT;
                });
                this._tierTopicSnapshotManager_$eq((Option<TierTopicSnapshotManager>)None$.MODULE$);
            }
            return;
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierTopicSnapshotCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().tierTopicSnapshotsIntervalMs()) < Defaults$.MODULE$.TierTopicSnapshotsMinIntervalMs()) {
            throw new ConfigException(new StringBuilder(44).append(KafkaConfig$.MODULE$.TierTopicSnapshotsIntervalMsProp()).append(" should be at least ").append(Defaults$.MODULE$.TierTopicSnapshotsMinIntervalMs()).append(", ").append("but provided value is ").append(newConfig.confluentConfig().tierTopicSnapshotsIntervalMs()).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Boolean oldCoordinatorEnabled = oldConfig.confluentConfig().tierTopicSnapshotsEnable();
        Long oldIntervalMs = oldConfig.confluentConfig().tierTopicSnapshotsIntervalMs();
        Boolean newCoordinatorEnabled = newConfig.confluentConfig().tierTopicSnapshotsEnable();
        Long newIntervalMs = newConfig.confluentConfig().tierTopicSnapshotsIntervalMs();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(136).append("TierTopicSnapshotCoordinator dynamically being reconfigured with ").append("old config (enable: ").append(oldCoordinatorEnabled).append(", intervalMs = ").append(oldIntervalMs).append(")").append("new config (enable: ").append(newCoordinatorEnabled).append(", intervalMs = ").append(newIntervalMs).toString());
        if (!Predef$.MODULE$.Boolean2boolean(oldCoordinatorEnabled) && Predef$.MODULE$.Boolean2boolean(newCoordinatorEnabled)) {
            this.onElection(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
            return;
        }
        if (Predef$.MODULE$.Boolean2boolean(oldCoordinatorEnabled) && !Predef$.MODULE$.Boolean2boolean(newCoordinatorEnabled)) {
            this.onResignation(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
            return;
        }
        if (Predef$.MODULE$.Boolean2boolean(oldCoordinatorEnabled) && Predef$.MODULE$.Boolean2boolean(newCoordinatorEnabled)) {
            Long l = oldIntervalMs;
            if (l == null ? newIntervalMs != null : !((Object)l).equals(newIntervalMs)) {
                this.onResignation(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
                this.onElection(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
                return;
            }
        }
    }

    public int localReplicaEpochIfLeader(int partition) {
        int n;
        TopicPartition tp = new TopicPartition("_confluent-tier-state", partition);
        Either<Errors, Partition> either = this.replicaManager.getPartitionOrError(tp);
        if (either instanceof Left) {
            n = -1;
        } else if (either instanceof Right) {
            Option<AbstractLog> option = ((Partition)((Right)either).value()).leaderLogIfLocal();
            int n2 = option instanceof Some ? BoxesRunTime.unboxToInt((Object)((AbstractLog)((Some)option).value()).latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)) : -1;
            n = n2;
        } else {
            throw new MatchError(either);
        }
        return n;
    }

    private int MAX_PARTITION_FETCH_BYTES() {
        return this.MAX_PARTITION_FETCH_BYTES;
    }

    private Properties getProperties(KafkaConfig config, String clusterId, Supplier<Map<String, Object>> interBrokerClientConfigs) {
        String SEPARATOR = "-";
        Properties properties = new Properties();
        properties.putAll(interBrokerClientConfigs.get());
        properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("client.id", TierTopicSnapshotCoordinator.clientId$1(clusterId, Predef$.MODULE$.int2Integer(config.brokerId()), SEPARATOR));
        properties.put("group.id", TierTopicSnapshotCoordinator.groupId$1(clusterId, SEPARATOR));
        properties.put("max.partition.fetch.bytes", Integer.toString(this.MAX_PARTITION_FETCH_BYTES()));
        properties.put("enable.auto.commit", Boolean.toString(false));
        properties.remove("metric.reporters");
        return properties;
    }

    private final /* synthetic */ void liftedTree1$1(int epoch$1) {
        try {
            if (Predef$.MODULE$.Integer2int(((TierTopicSnapshotManager)this._tierTopicSnapshotManager().get()).leaderEpoch()) < epoch$1) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Re-Starting the instance of tier topic snapshot manager(broker: ").append($this.config.brokerId()).append(", epoch: ").append(epoch$1).append(")").toString());
                this._tierTopicSnapshotManager().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.shutdown();
                    return BoxedUnit.UNIT;
                });
                this._tierTopicSnapshotManager_$eq((Option<TierTopicSnapshotManager>)new Some((Object)new TierTopicSnapshotManager((Consumer<byte[], byte[]>)new KafkaConsumer(this.getProperties(this.config, this.clusterId, this.interBrokerClientConfigs)), (TierObjectStore)this.tierObjectStoreOpt.get(), Predef$.MODULE$.int2Integer(epoch$1), this.config.confluentConfig().tierMetadataNumPartitions(), this.config.confluentConfig().tierTopicSnapshotsIntervalMs(), this.config.confluentConfig().tierTopicSnapshotsMaxRecordsPerSnapshot(), this.config.confluentConfig().tierTopicSnapshotsRetentionHours(), this.time, this.metrics)));
                this._tierTopicSnapshotManager().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                    x$3.start();
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (Exception e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Unable to migrate existing TierTopicSnapshotManager to epoch ").append(epoch$1).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
    }

    private static final String clientId$1(String clusterId, Integer brokerId, String SEPARATOR$1) {
        return String.join((CharSequence)SEPARATOR$1, "consumer", clusterId, brokerId.toString(), "TierTopicSnapshotManager");
    }

    private static final String groupId$1(String clusterId, String SEPARATOR$1) {
        return String.join((CharSequence)SEPARATOR$1, clusterId, "TierTopicSnapshotManager");
    }

    public TierTopicSnapshotCoordinator(KafkaConfig config, String clusterId, Supplier<Map<String, Object>> interBrokerClientConfigs, ReplicaManager replicaManager, Option<TierObjectStore> tierObjectStoreOpt, Time time, Metrics metrics) {
        this.config = config;
        this.clusterId = clusterId;
        this.interBrokerClientConfigs = interBrokerClientConfigs;
        this.replicaManager = replicaManager;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.time = time;
        this.metrics = metrics;
        Logging.$init$(this);
        this._tierTopicSnapshotManager = None$.MODULE$;
        this.lock = new Object();
        this.MAX_PARTITION_FETCH_BYTES = 0x100000;
    }
}

