/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.Objects;

public final class CompactStats {
    private final long bytesRead;
    private final long bytesWritten;
    private final long dirtyBytesRead;
    public static final CompactStats EMPTY = new CompactStats(0L, 0L, 0L);

    public CompactStats(long bytesRead, long bytesWritten, long dirtyBytesRead) {
        this.bytesRead = bytesRead;
        this.bytesWritten = bytesWritten;
        this.dirtyBytesRead = dirtyBytesRead;
    }

    public CompactStats(kafka.tier.serdes.CompactStats stats) {
        this(stats.bytesRead(), stats.bytesWritten(), stats.dirtyBytesRead());
    }

    public CompactStats accumulate(CompactStats other) {
        return new CompactStats(this.bytesRead + other.bytesRead(), this.bytesWritten + other.bytesWritten(), this.dirtyBytesRead + other.dirtyBytesRead());
    }

    public long bytesRead() {
        return this.bytesRead;
    }

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public long dirtyBytesRead() {
        return this.dirtyBytesRead;
    }

    public double retainRatio() {
        if (this.bytesRead <= 0L) {
            return -1.0;
        }
        return (double)this.bytesWritten / (double)this.bytesRead;
    }

    public double reduceRatio() {
        if (this.dirtyBytesRead <= 0L) {
            return -1.0;
        }
        return (double)(this.bytesRead - this.bytesWritten) / (double)this.dirtyBytesRead;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactStats that = (CompactStats)o;
        return this.bytesRead == that.bytesRead && this.bytesWritten == that.bytesWritten && this.dirtyBytesRead == that.dirtyBytesRead;
    }

    public int hashCode() {
        return Objects.hash(this.bytesRead, this.bytesWritten, this.dirtyBytesRead);
    }

    public String toString() {
        return "CompactStats(bytesRead=" + this.bytesRead + ", bytesWritten=" + this.bytesWritten + ", dirtyBytesRead=" + this.dirtyBytesRead + ')';
    }

    public String toJson() {
        return "{\"bytesRead\": " + this.bytesRead + ", \"bytesWritten\": " + this.bytesWritten + ", \"dirtyBytesRead\": " + this.dirtyBytesRead + "}";
    }
}

