/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.SnapshotTasksConfig;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.ArchiverTaskQueue;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.tasks.compaction.CompactionTaskQueue;
import kafka.tier.tasks.compaction.TierLogCleanerManager;
import kafka.tier.tasks.delete.TierDeletionManager;
import kafka.tier.tasks.snapshot.MetadataSnapshotTaskQueue;
import kafka.tier.tasks.snapshot.TierMetadataSnapshotManager;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.HeartbeatingShutdownableThread;
import kafka.utils.HeartbeatingShutdownableThread$;
import kafka.utils.Logging;
import kafka.utils.ThreadsCpuMeter;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rea\u0001\u0002!B\u0001!C\u0001\u0002\u0017\u0001\u0003\u0002\u0004%\t!\u0017\u0005\t=\u0002\u0011\t\u0019!C\u0001?\"A\u0001\u000e\u0001B\u0001B\u0003&!\f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011!\t\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011i\u0004!\u0011!Q\u0001\nmD!\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\ty\u0004\u0001C)\u0003\u0003B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0017\t\u0011\u0005-\u0004\u0001)A\u0005\u0003;B\u0011\"!\u001c\u0001\u0001\u0004%I!a\u001c\t\u0013\u0005]\u0004\u00011A\u0005\n\u0005e\u0004\u0002CA?\u0001\u0001\u0006K!!\u001d\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0005\u0002CAH\u0001\u0001\u0006I!a!\t\u0013\u0005E\u0005A1A\u0005\n\u0005M\u0005\u0002CAU\u0001\u0001\u0006I!!&\t\u0013\u0005-\u0006A1A\u0005\n\u00055\u0006\u0002CA`\u0001\u0001\u0006I!a,\t\u0013\u0005\u0005\u0007\u00011A\u0005\n\u0005\r\u0007\"CAi\u0001\u0001\u0007I\u0011BAj\u0011!\t9\u000e\u0001Q!\n\u0005\u0015\u0007BCAm\u0001\t\u0007I\u0011A\"\u0002\u0014\"A\u00111\u001c\u0001!\u0002\u0013\t)\n\u0003\u0006\u0002^\u0002\u0011\r\u0011\"\u0001D\u0003'C\u0001\"a8\u0001A\u0003%\u0011Q\u0013\u0005\n\u0003C\u0004!\u0019!C\u0005\u0003GD\u0001\"a<\u0001A\u0003%\u0011Q\u001d\u0005\n\u0003c\u0004!\u0019!C\u0005\u0003gD\u0001B!\u0001\u0001A\u0003%\u0011Q\u001f\u0005\n\u0005\u0007\u0001!\u0019!C\u0005\u0005\u000bA\u0001Ba\u0005\u0001A\u0003%!q\u0001\u0005\u000b\u0005+\u0001!\u0019!C\u0001\u0007\n]\u0001\u0002\u0003B\u0014\u0001\u0001\u0006IA!\u0007\t\u0015\t%\u0002A1A\u0005\u0002\r\u0013Y\u0003\u0003\u0005\u0003<\u0001\u0001\u000b\u0011\u0002B\u0017\u0011%\u0011i\u0004\u0001b\u0001\n\u0013\u0011y\u0004\u0003\u0005\u0003X\u0001\u0001\u000b\u0011\u0002B!\u0011%\u00119\u0007\u0001b\u0001\n\u0013\u0011I\u0007\u0003\u0005\u0003r\u0001\u0001\u000b\u0011\u0002B6\u0011%\u0011\u0019\b\u0001b\u0001\n\u0013\u0011)\b\u0003\u0005\u0003\u000e\u0002\u0001\u000b\u0011\u0002B<\u0011\u001d\u0011y\t\u0001C!\u0005#CqAa%\u0001\t\u0003\u0011\t\nC\u0004\u0003\u0016\u0002!\tE!%\t\u000f\t]\u0005\u0001\"\u0001\u0003\u001a\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BW\u0001\u0011\u0005!q\u0016\u0005\b\u0005s\u0003A\u0011\tB^\u0011\u001d\u0011)\r\u0001C!\u0005\u000fDqAa5\u0001\t\u0003\u0012)\u000e\u0003\u0005\u0003T\u0002!\ta\u0011Bo\u000f\u001d\u0011\u0019/\u0011E\u0001\u0005K4a\u0001Q!\t\u0002\t\u001d\bbBA\u0016s\u0011\u0005!q\u001e\u0005\n\u0005cL$\u0019!C\u0003\u0005gD\u0001Ba?:A\u00035!Q\u001f\u0005\n\u0005{L$\u0019!C\u0001\u0005wC\u0001Ba@:A\u0003%!Q\u0018\u0005\n\u0007\u0003I\u0014\u0013!C\u0001\u0007\u0007\u0011\u0011\u0002V5feR\u000b7o[:\u000b\u0005\t\u001b\u0015!\u0002;bg.\u001c(B\u0001#F\u0003\u0011!\u0018.\u001a:\u000b\u0003\u0019\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0013>\u0013\u0006C\u0001&N\u001b\u0005Y%B\u0001'F\u0003\u0015)H/\u001b7t\u0013\tq5J\u0001\u0010IK\u0006\u0014HOY3bi&twm\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIB\u0011!\nU\u0005\u0003#.\u0013q\u0001T8hO&tw\r\u0005\u0002T-6\tAK\u0003\u0002V\u000b\u000611/\u001a:wKJL!a\u0016+\u0003)\t\u0013xn[3s%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0003\u0019\u0019wN\u001c4jOV\t!\f\u0005\u0002\\96\t\u0011)\u0003\u0002^\u0003\nyA+[3s)\u0006\u001c8n]\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$\"\u0001\u00194\u0011\u0005\u0005$W\"\u00012\u000b\u0003\r\fQa]2bY\u0006L!!\u001a2\u0003\tUs\u0017\u000e\u001e\u0005\bO\n\t\t\u00111\u0001[\u0003\rAH%M\u0001\bG>tg-[4!Q\t\u0019!\u000e\u0005\u0002bW&\u0011AN\u0019\u0002\tm>d\u0017\r^5mK\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bCA*p\u0013\t\u0001HK\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002%QLWM\u001d*fa2L7-Y'b]\u0006<WM\u001d\t\u0003gRl\u0011aQ\u0005\u0003k\u000e\u0013!\u0003V5feJ+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0001C/[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s!\t\u0019\b0\u0003\u0002z\u0007\n\u0001C+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0003E!\u0018.\u001a:U_BL7-\u00119qK:$WM\u001d\t\u0003y~l\u0011! \u0006\u0003}\u000e\u000bQ\u0001^8qS\u000eL1!!\u0001~\u0005E!\u0016.\u001a:U_BL7-\u00119qK:$WM]\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKB!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\r\u000bQa\u001d;pe\u0016LA!a\u0004\u0002\n\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0001\u0003uS6,\u0007\u0003BA\u000b\u0003Oi!!a\u0006\u000b\u00071\u000bIB\u0003\u0003\u0002\u001c\u0005u\u0011AB2p[6|gNC\u0002G\u0003?QA!!\t\u0002$\u00051\u0011\r]1dQ\u0016T!!!\n\u0002\u0007=\u0014x-\u0003\u0003\u0002*\u0005]!\u0001\u0002+j[\u0016\fa\u0001P5oSRtD\u0003EA\u0018\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f!\tY\u0006\u0001C\u0003Y\u0015\u0001\u0007!\fC\u0003n\u0015\u0001\u0007a\u000eC\u0003r\u0015\u0001\u0007!\u000fC\u0003w\u0015\u0001\u0007q\u000fC\u0003{\u0015\u0001\u00071\u0010C\u0004\u0002\u0004)\u0001\r!!\u0002\t\u0013\u0005E!\u0002%AA\u0002\u0005M\u0011A\u00037pO\u001e,'OT1nKV\u0011\u00111\t\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003cAA%E6\u0011\u00111\n\u0006\u0004\u0003\u001b:\u0015A\u0002\u001fs_>$h(C\u0002\u0002R\t\fa\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)E\u0006aQ.\u001a;sS\u000e\u001cxI]8vaV\u0011\u0011Q\f\t\u0005\u0003?\n9'\u0004\u0002\u0002b)!\u00111MA3\u0003\u001diW\r\u001e:jGNT1!VA\u000f\u0013\u0011\tI'!\u0019\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0013Y\u0006\u001cH\u000fT1h!JLg\u000e\u001e+j[\u0016l5/\u0006\u0002\u0002rA\u0019\u0011-a\u001d\n\u0007\u0005U$M\u0001\u0003M_:<\u0017A\u00067bgRd\u0015m\u001a)sS:$H+[7f\u001bN|F%Z9\u0015\u0007\u0001\fY\b\u0003\u0005h\u001f\u0005\u0005\t\u0019AA9\u0003Ma\u0017m\u001d;MC\u001e\u0004&/\u001b8u)&lW-T:!\u0003\r\u0019G\u000f_\u000b\u0003\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u001b\u0015a\u00024fi\u000eDWM]\u0005\u0005\u0003\u001b\u000b9IA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0003dib\u0004\u0013aF1sG\"Lg/\u001a#fY\u0016$\u0018n\u001c8Fq\u0016\u001cW\u000f^8s+\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0015VBAAM\u0015\u0011\tY*!(\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002 \u0006\u0005\u0016\u0001B;uS2T!!a)\u0002\t)\fg/Y\u0005\u0005\u0003O\u000bIJA\bFq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003a\t'o\u00195jm\u0016$U\r\\3uS>tW\t_3dkR|'\u000fI\u0001\u000fG2,\u0017M\\3s)\"\u0014X-\u00193t+\t\ty\u000b\u0005\u0004\u00022\u0006m\u0016\u0011O\u0007\u0003\u0003gSA!!.\u00028\u00069Q.\u001e;bE2,'bAA]E\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00161\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\bdY\u0016\fg.\u001a:UQJ,\u0017\rZ:!\u0003Y!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:\u001c\u0005/^'fi\u0016\u0014XCAAc!\u0015\t\u0017qYAf\u0013\r\tIM\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007)\u000bi-C\u0002\u0002P.\u0013q\u0002\u00165sK\u0006$7o\u00119v\u001b\u0016$XM]\u0001\u001bi&,'oQ8na\u0006\u001cG/[8o\u0007B,X*\u001a;fe~#S-\u001d\u000b\u0004A\u0006U\u0007\u0002C4\u0019\u0003\u0003\u0005\r!!2\u0002/QLWM]\"p[B\f7\r^5p]\u000e\u0003X/T3uKJ\u0004\u0013\u0001E2mK\u0006t\u0017N\\4Fq\u0016\u001cW\u000f^8s\u0003E\u0019G.Z1oS:<W\t_3dkR|'\u000fI\u0001\u0011g:\f\u0007o\u001d5pi\u0016CXmY;u_J\f\u0011c\u001d8baNDw\u000e^#yK\u000e,Ho\u001c:!\u0003M\t'o\u00195jm\u0016$U\r\\3uS>t\u0007k\\8m+\t\t)\u000f\u0005\u0003\u0002h\u0006-XBAAu\u0015\r\tYJY\u0005\u0005\u0003[\fIO\u0001\rFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\fA#\u0019:dQ&4X\rR3mKRLwN\u001c)p_2\u0004\u0013\u0001\u0004;jKJ\f%o\u00195jm\u0016\u0014XCAA{!\u0011\t90!@\u000e\u0005\u0005e(bAA~\u0003\u00069\u0011M]2iSZ,\u0017\u0002BA\u0000\u0003s\u0014A\u0002V5fe\u0006\u00138\r[5wKJ\fQ\u0002^5fe\u0006\u00138\r[5wKJ\u0004\u0013a\u0005;jKJ$U\r\\3uS>tW*\u00198bO\u0016\u0014XC\u0001B\u0004!\u0011\u0011IAa\u0004\u000e\u0005\t-!b\u0001B\u0007\u0003\u00061A-\u001a7fi\u0016LAA!\u0005\u0003\f\t\u0019B+[3s\t\u0016dW\r^5p]6\u000bg.Y4fe\u0006!B/[3s\t\u0016dW\r^5p]6\u000bg.Y4fe\u0002\nQ\u0003^5fe2{wm\u00117fC:,'/T1oC\u001e,'/\u0006\u0002\u0003\u001aA)\u0011-a2\u0003\u001cA!!Q\u0004B\u0012\u001b\t\u0011yBC\u0002\u0003\"\u0005\u000b!bY8na\u0006\u001cG/[8o\u0013\u0011\u0011)Ca\b\u0003+QKWM\u001d'pO\u000ecW-\u00198fe6\u000bg.Y4fe\u00061B/[3s\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b%A\u000euS\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00158baNDw\u000e^'b]\u0006<WM]\u000b\u0003\u0005[\u0001R!YAd\u0005_\u0001BA!\r\u000385\u0011!1\u0007\u0006\u0004\u0005k\t\u0015\u0001C:oCB\u001c\bn\u001c;\n\t\te\"1\u0007\u0002\u001c)&,'/T3uC\u0012\fG/Y*oCB\u001c\bn\u001c;NC:\fw-\u001a:\u00029QLWM]'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3sA\u0005qA/[3s)\u0006\u001c8.U;fk\u0016\u001cXC\u0001B!!\u0019\t\tLa\u0011\u0003H%!!QIAZ\u0005)a\u0015n\u001d;Ck\u001a4WM\u001d\u0019\u0005\u0005\u0013\u0012\u0019\u0006E\u0003\\\u0005\u0017\u0012y%C\u0002\u0003N\u0005\u0013Q\u0002V5feR\u000b7o[)vKV,\u0007\u0003\u0002B)\u0005'b\u0001\u0001B\u0006\u0003V%\n\t\u0011!A\u0003\u0002\te#aA0%c\u0005yA/[3s)\u0006\u001c8.U;fk\u0016\u001c\b%\u0005\u0003\u0003\\\t\u0005\u0004cA1\u0003^%\u0019!q\f2\u0003\u000f9{G\u000f[5oOB\u0019\u0011Ma\u0019\n\u0007\t\u0015$MA\u0002B]f\fQb\u00195b]\u001e,W*\u00198bO\u0016\u0014XC\u0001B6!\rY&QN\u0005\u0004\u0005_\n%!D\"iC:<W-T1oC\u001e,'/\u0001\bdQ\u0006tw-Z'b]\u0006<WM\u001d\u0011\u0002\u001f\rL8\r\\3US6,W*\u001a;sS\u000e,\"Aa\u001e\u0011\t\te$\u0011R\u0007\u0003\u0005wRAA! \u0003\u0000\u0005!1m\u001c:f\u0015\u0011\t\u0019G!!\u000b\t\t\r%QQ\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\t\u001d\u0015aA2p[&!!1\u0012B>\u0005\u0015iU\r^3s\u0003A\u0019\u0017p\u00197f)&lW-T3ue&\u001c\u0007%\u0001\u0004e_^{'o\u001b\u000b\u0002A\u0006YR.Y=cK2{w\rV5fe\u0006\u00138\r[5wKJd\u0015mZ%oM>\f\u0001b\u001d5vi\u0012|wO\\\u0001\u0012CJ\u001c\u0007.\u001b<feR\u000b7o[)vKV,WC\u0001BN!\u0011\t9P!(\n\t\t}\u0015\u0011 \u0002\u0012\u0003J\u001c\u0007.\u001b<feR\u000b7o[)vKV,\u0017aE2p[B\f7\r^5p]R\u000b7o[)vKV,WC\u0001BS!\u0015\t\u0017q\u0019BT!\u0011\u0011iB!+\n\t\t-&q\u0004\u0002\u0014\u0007>l\u0007/Y2uS>tG+Y:l#V,W/Z\u0001\u001a[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R$\u0016m]6Rk\u0016,X-\u0006\u0002\u00032B)\u0011-a2\u00034B!!\u0011\u0007B[\u0013\u0011\u00119La\r\u000335+G/\u00193bi\u0006\u001cf.\u00199tQ>$H+Y:l#V,W/Z\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011i\f\u0005\u0004\u0003@\n\u0005\u00171I\u0007\u0003\u0003oKAAa1\u00028\n\u00191+\u001a;\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tGc\u00011\u0003J\"9!1Z\u001bA\u0002\t5\u0017!\u00038fo\u000e{gNZ5h!\r\u0019&qZ\u0005\u0004\u0005#$&aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR)\u0001Ma6\u0003\\\"9!\u0011\u001c\u001cA\u0002\t5\u0017!C8mI\u000e{gNZ5h\u0011\u001d\u0011YM\u000ea\u0001\u0005\u001b$R\u0001\u0019Bp\u0005CDaA!78\u0001\u0004Q\u0006B\u0002Bfo\u0001\u0007!,A\u0005US\u0016\u0014H+Y:lgB\u00111,O\n\u0004s\t%\bcA1\u0003l&\u0019!Q\u001e2\u0003\r\u0005s\u0017PU3g)\t\u0011)/A\nQ\u000bJKu\nR%D?2{ui\u0018'B\u000f~k5+\u0006\u0002\u0003vB\u0019\u0011Ma>\n\u0007\te(MA\u0002J]R\fA\u0003U#S\u0013>#\u0015jQ0M\u001f\u001e{F*Q$`\u001bN\u0003\u0013!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"a!\u0002+\t\u0005M1qA\u0016\u0003\u0007\u0013\u0001Baa\u0003\u0004\u00165\u00111Q\u0002\u0006\u0005\u0007\u001f\u0019\t\"A\u0005v]\u000eDWmY6fI*\u001911\u00032\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0018\r5!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class TierTasks
extends HeartbeatingShutdownableThread
implements Logging,
BrokerReconfigurable {
    private volatile TierTasksConfig config;
    private final TierTopicAppender tierTopicAppender;
    private final Time time;
    private final KafkaMetricsGroup metricsGroup;
    private long lastLagPrintTimeMs;
    private final CancellationContext ctx;
    private final ExecutorService archiveDeletionExecutor;
    private final ArrayBuffer<Object> kafka$tier$tasks$TierTasks$$cleanerThreads;
    private Option<ThreadsCpuMeter> kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    private final ExecutorService cleaningExecutor;
    private final ExecutorService snapshotExecutor;
    private final ExecutionContextExecutor archiveDeletionPool;
    private final TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver;
    private final TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager;
    private final Option<TierLogCleanerManager> tierLogCleanerManager;
    private final Option<TierMetadataSnapshotManager> tierMetadataSnapshotManager;
    private final ListBuffer<TierTaskQueue<?>> tierTaskQueues;
    private final ChangeManager changeManager;
    private final Meter cycleTimeMetric;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return TierTasks$.MODULE$.$lessinit$greater$default$7();
    }

    public static Set<String> ReconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    public static int PERIODIC_LOG_LAG_MS() {
        return TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public TierTasksConfig config() {
        return this.config;
    }

    public void config_$eq(TierTasksConfig x$1) {
        this.config = x$1;
    }

    @Override
    public String loggerName() {
        return TierTasks.class.getName();
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private long lastLagPrintTimeMs() {
        return this.lastLagPrintTimeMs;
    }

    private void lastLagPrintTimeMs_$eq(long x$1) {
        this.lastLagPrintTimeMs = x$1;
    }

    private CancellationContext ctx() {
        return this.ctx;
    }

    private ExecutorService archiveDeletionExecutor() {
        return this.archiveDeletionExecutor;
    }

    public ArrayBuffer<Object> kafka$tier$tasks$TierTasks$$cleanerThreads() {
        return this.kafka$tier$tasks$TierTasks$$cleanerThreads;
    }

    private Option<ThreadsCpuMeter> kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter() {
        return this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter;
    }

    public void kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq(Option<ThreadsCpuMeter> x$1) {
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = x$1;
    }

    public ExecutorService cleaningExecutor() {
        return this.cleaningExecutor;
    }

    public ExecutorService snapshotExecutor() {
        return this.snapshotExecutor;
    }

    private ExecutionContextExecutor archiveDeletionPool() {
        return this.archiveDeletionPool;
    }

    public TierArchiver kafka$tier$tasks$TierTasks$$tierArchiver() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver;
    }

    public TierDeletionManager kafka$tier$tasks$TierTasks$$tierDeletionManager() {
        return this.kafka$tier$tasks$TierTasks$$tierDeletionManager;
    }

    public Option<TierLogCleanerManager> tierLogCleanerManager() {
        return this.tierLogCleanerManager;
    }

    public Option<TierMetadataSnapshotManager> tierMetadataSnapshotManager() {
        return this.tierMetadataSnapshotManager;
    }

    private ListBuffer<TierTaskQueue<?>> tierTaskQueues() {
        return this.tierTaskQueues;
    }

    private ChangeManager changeManager() {
        return this.changeManager;
    }

    private Meter cycleTimeMetric() {
        return this.cycleTimeMetric;
    }

    public void doWork() {
        if (!this.tierTopicAppender.isReadyForWrites()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "TierTopicAppender is not ready. Backing off.");
            while (!this.tierTopicAppender.isReadyForWrites() && this.isRunning()) {
                this.pause(this.config().updateIntervalMs(), TimeUnit.MILLISECONDS);
            }
            if (!this.isRunning()) {
                return;
            }
        }
        this.cycleTimeMetric().mark();
        this.changeManager().process();
        this.tierLogCleanerManager().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.doWork());
        this.kafka$tier$tasks$TierTasks$$tierArchiver().doWork();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().doWork();
        this.tierMetadataSnapshotManager().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.doWork());
        this.maybeLogTierArchiverLagInfo();
        if (this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().taskCount() == 0 && this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().taskCount() == 0 && BoxesRunTime.unboxToInt((Object)this.tierLogCleanerManager().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)TierTasks.$anonfun$doWork$4(x$10))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) == 0 && BoxesRunTime.unboxToInt((Object)this.tierMetadataSnapshotManager().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)TierTasks.$anonfun$doWork$6(x$11))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) == 0) {
            this.changeManager().processAtLeastOne();
            return;
        }
        this.time.sleep((long)this.config().updateIntervalMs());
    }

    public void maybeLogTierArchiverLagInfo() {
        long currentTime = this.time.milliseconds();
        if (currentTime > this.lastLagPrintTimeMs() + (long)TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS()) {
            this.kafka$tier$tasks$TierTasks$$tierArchiver().logPartitionLagInfo(currentTime);
            this.lastLagPrintTimeMs_$eq(currentTime);
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
        this.initiateShutdown();
        this.ctx().cancel();
        this.changeManager().close();
        this.kafka$tier$tasks$TierTasks$$tierArchiver().shutdown();
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager().shutdown();
        this.tierLogCleanerManager().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.tierMetadataSnapshotManager().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
            x$13.shutdown();
            return BoxedUnit.UNIT;
        });
        this.archiveDeletionExecutor().shutdown();
        this.archiveDeletionExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.cleaningExecutor().shutdown();
        this.cleaningExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.snapshotExecutor().shutdown();
        this.snapshotExecutor().awaitTermination(30L, TimeUnit.SECONDS);
        this.awaitShutdown();
    }

    public ArchiverTaskQueue archiverTaskQueue() {
        return this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue();
    }

    public Option<CompactionTaskQueue> compactionTaskQueue() {
        return this.tierLogCleanerManager().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.taskQueue());
    }

    public Option<MetadataSnapshotTaskQueue> metadataSnapshotTaskQueue() {
        return this.tierMetadataSnapshotManager().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.taskQueue());
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return TierTasks$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        if (newTierTasksConfig.numCleanerThreads() < 1) {
            throw new ConfigException("Tier cleaner threads should be at least 1");
        }
        if (newTierTasksConfig.numCleanerThreads() < this.config().numCleanerThreads() / 2) {
            throw new ConfigException(new StringBuilder(75).append("Tier cleaner threads cannot be reduced to less than half the current value ").append(this.config().numCleanerThreads()).toString());
        }
        if (newTierTasksConfig.numCleanerThreads() > this.config().numCleanerThreads() * 2) {
            throw new ConfigException(new StringBuilder(79).append("Tier cleaner threads cannot be increased to more than double the current value ").append(this.config().numCleanerThreads()).toString());
        }
        if (newTierTasksConfig.snapshotTaskConfig().exists((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)TierTasks.$anonfun$validateReconfiguration$1(c)))) {
            throw new ConfigException(new StringBuilder(36).append(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsRetentionDaysProp()).append(" must have a value of at least ").append(Defaults$.MODULE$.TierPartitionStateMetadataSnapshotsMinRetentionDays()).append(" days").toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        TierTasksConfig oldTierTasksConfig = this.config();
        TierTasksConfig newTierTasksConfig = TierTasksConfig$.MODULE$.apply(newConfig);
        this.reconfigure(oldTierTasksConfig, newTierTasksConfig);
    }

    public void reconfigure(TierTasksConfig oldConfig, TierTasksConfig newConfig) {
        this.config_$eq(newConfig);
        this.tierLogCleanerManager().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.updateConfig(newConfig);
            return BoxedUnit.UNIT;
        });
        if (newConfig.numCleanerThreads() != oldConfig.numCleanerThreads()) {
            ThreadPoolExecutor cleaningThreadPool = (ThreadPoolExecutor)this.cleaningExecutor();
            cleaningThreadPool.setMaximumPoolSize(newConfig.numCleanerThreads());
            cleaningThreadPool.setCorePoolSize(newConfig.numCleanerThreads());
        }
    }

    public final /* synthetic */ double kafka$tier$tasks$TierTasks$$$anonfun$new$2() {
        return BoxesRunTime.unboxToDouble((Object)this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2.computeCpuUtilizationPercent())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)) * (double)100;
    }

    public static final /* synthetic */ void $anonfun$new$1(TierTasks $this, TierLogCleanerManager x$1) {
        x$1.logCleanerMetrics().setCompactionCpuUtilizationPercentGauge(new Gauge<Object>($this){
            private final /* synthetic */ TierTasks $outer;

            public final double value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$$anonfun$new$2();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static final /* synthetic */ int $anonfun$doWork$4(TierLogCleanerManager x$10) {
        return x$10.taskQueue().taskCount();
    }

    public static final /* synthetic */ int $anonfun$doWork$6(TierMetadataSnapshotManager x$11) {
        return x$11.taskQueue().taskCount();
    }

    public static final /* synthetic */ boolean $anonfun$validateReconfiguration$1(SnapshotTasksConfig c) {
        return c.retentionDays().apply$mcI$sp() < Defaults$.MODULE$.TierPartitionStateMetadataSnapshotsMinRetentionDays();
    }

    public TierTasks(TierTasksConfig config, ReplicaManager replicaManager, TierReplicaManager tierReplicaManager, TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, Time time) {
        None$ none$;
        None$ none$2;
        this.config = config;
        this.tierTopicAppender = tierTopicAppender;
        this.time = time;
        super("tier-tasks", HeartbeatingShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.lastLagPrintTimeMs = time.milliseconds();
        this.ctx = CancellationContext.newContext();
        this.archiveDeletionExecutor = Executors.newFixedThreadPool(this.config().numArchiverThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(9).append("TierTask-").append(newThreadNum).toString();
                return new KafkaThread(nonDaemon_name, r, false);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.kafka$tier$tasks$TierTasks$$cleanerThreads = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter = None$.MODULE$;
        this.cleaningExecutor = Executors.newFixedThreadPool(this.config().numCleanerThreads(), new ThreadFactory(this){
            private final AtomicInteger threadNum;
            private final /* synthetic */ TierTasks $outer;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(19).append("TierCompactionTask-").append(newThreadNum).toString();
                KafkaThread kafkaThread = new KafkaThread(nonDaemon_name, r, false);
                this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{kafkaThread.getId()}));
                this.$outer.kafka$tier$tasks$TierTasks$$tierCompactionCpuMeter_$eq((Option<ThreadsCpuMeter>)new Some((Object)new ThreadsCpuMeter((Seq<Object>)this.$outer.kafka$tier$tasks$TierTasks$$cleanerThreads().toSeq())));
                return kafkaThread;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.snapshotExecutor = Executors.newFixedThreadPool(this.config().numSnapshotThreads(), new ThreadFactory(null){
            private final AtomicInteger threadNum;

            private AtomicInteger threadNum() {
                return this.threadNum;
            }

            public Thread newThread(Runnable r) {
                int newThreadNum = this.threadNum().incrementAndGet();
                String nonDaemon_name = new StringBuilder(17).append("TierSnapshotTask-").append(newThreadNum).toString();
                return new KafkaThread(nonDaemon_name, r, false);
            }
            {
                this.threadNum = new AtomicInteger(-1);
            }
        });
        this.archiveDeletionPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.archiveDeletionExecutor());
        this.kafka$tier$tasks$TierTasks$$tierArchiver = new TierArchiver(this.config(), replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, time, (ExecutionContext)this.archiveDeletionPool());
        this.kafka$tier$tasks$TierTasks$$tierDeletionManager = new TierDeletionManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)this.archiveDeletionPool());
        if (this.config().tierCleanerFeatureEnable()) {
            ExecutionContextExecutor cleaningPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.cleaningExecutor());
            none$2 = new Some((Object)new TierLogCleanerManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)cleaningPool));
        } else {
            none$2 = None$.MODULE$;
        }
        this.tierLogCleanerManager = none$2;
        this.tierLogCleanerManager().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            TierTasks.$anonfun$new$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        if (this.config().snapshotTaskConfig().isDefined()) {
            ExecutionContextExecutor snapshotPool = ExecutionContext$.MODULE$.fromExecutor((Executor)this.snapshotExecutor());
            none$ = new Some((Object)new TierMetadataSnapshotManager(replicaManager, tierTopicAppender, tierObjectStore, this.ctx().subContext(), Integer.MAX_VALUE, this.config(), time, (ExecutionContext)snapshotPool));
        } else {
            none$ = None$.MODULE$;
        }
        this.tierMetadataSnapshotManager = none$;
        this.tierTaskQueues = new ListBuffer();
        this.tierTaskQueues().$plus$plus$eq((TraversableOnce)((TraversableLike)new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue(), (List)new .colon.colon((Object)this.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue(), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.tierLogCleanerManager().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.taskQueue())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.tierMetadataSnapshotManager().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.taskQueue())), Seq$.MODULE$.canBuildFrom()));
        this.changeManager = new ChangeManager(this.ctx().subContext(), this.tierTaskQueues().toSeq(), time);
        this.metricsGroup().removeMetric("HeartbeatMs");
        this.metricsGroup().newGauge("HeartbeatMs", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public synchronized long value() {
                return System.currentTimeMillis() - this.$outer.lastHeartbeatMs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().removeMetric("CyclesPerSec");
        this.cycleTimeMetric = this.metricsGroup().newMeter("CyclesPerSec", "tier tasks cycles per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("NumPartitionsInError");
        this.metricsGroup().newGauge("NumPartitionsInError", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount() + this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount() + BoxesRunTime.unboxToInt((Object)this.$outer.tierLogCleanerManager().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)$anon$5.$anonfun$value$1(x$5))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$1(TierLogCleanerManager x$5) {
                return x$5.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(kafka.tier.tasks.compaction.TierLogCleanerManager ), $anonfun$value$2()}, serializedLambda);
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringArchival");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringArchival", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierArchiver().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringDeletion");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringDeletion", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return this.$outer.kafka$tier$tasks$TierTasks$$tierDeletionManager().taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringCompaction");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringCompaction", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return BoxesRunTime.unboxToInt((Object)this.$outer.tierLogCleanerManager().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)$anon$8.$anonfun$value$3(x$6))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$3(TierLogCleanerManager x$6) {
                return x$6.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(kafka.tier.tasks.compaction.TierLogCleanerManager ), $anonfun$value$4()}, serializedLambda);
            }
        }, Collections.emptyMap());
        this.metricsGroup().removeMetric("NumPartitionsInErrorDuringMetadataSnapshot");
        this.metricsGroup().newGauge("NumPartitionsInErrorDuringMetadataSnapshot", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierTasks $outer;

            public int value() {
                return BoxesRunTime.unboxToInt((Object)this.$outer.tierMetadataSnapshotManager().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)$anon$9.$anonfun$value$5(x$7))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            }

            public static final /* synthetic */ int $anonfun$value$5(TierMetadataSnapshotManager x$7) {
                return x$7.taskQueue().errorPartitionCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$5$adapted(kafka.tier.tasks.snapshot.TierMetadataSnapshotManager ), $anonfun$value$6()}, serializedLambda);
            }
        }, Collections.emptyMap());
        tierReplicaManager.addListener(this.changeManager());
        tierDeletedPartitionsCoordinator.registerListener(this.changeManager());
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }
}

