/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import java.io.Serializable;
import kafka.log.CleanerStats;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.OffsetMapSupplier;
import kafka.tier.tasks.compaction.TierCompactionMetrics;
import kafka.tier.tasks.compaction.TierLogToClean;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4Aa\u0003\u0007\u0001+!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0003A!A!\u0002\u0013i\u0003\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u00071\u0002!\tFD-\t\r\u001d\u0004A\u0011\u000b\bi\u0011\u0019!\b\u0001\"\u0015\u000fk\n\u00192i\\7qC\u000e$\u0018n\u001c8UCN\\\u0017+^3vK*\u0011QBD\u0001\u000bG>l\u0007/Y2uS>t'BA\b\u0011\u0003\u0015!\u0018m]6t\u0015\t\t\"#\u0001\u0003uS\u0016\u0014(\"A\n\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0006\t\u0004/aQR\"\u0001\b\n\u0005eq!!\u0004+jKJ$\u0016m]6Rk\u0016,X\r\u0005\u0002\u001c95\tA\"\u0003\u0002\u001e\u0019\tq1i\\7qC\u000e$\u0018n\u001c8UCN\\\u0017aA2uqB\u0011\u0001eI\u0007\u0002C)\u0011!\u0005E\u0001\bM\u0016$8\r[3s\u0013\t!\u0013EA\nDC:\u001cW\r\u001c7bi&|gnQ8oi\u0016DH/\u0001\u0005nCb$\u0016m]6t!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\rIe\u000e^\u0001\u0005i&lW\r\u0005\u0002/q5\tqF\u0003\u00021c\u0005)Q\u000f^5mg*\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u0005M!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!O\u0018\u0003\tQKW.Z\u0001\u000bY><Gk\\\"mK\u0006t\u0007#B\u0014=5y\n\u0015BA\u001f)\u0005%1UO\\2uS>t'\u0007\u0005\u0002(\u007f%\u0011\u0001\t\u000b\u0002\u0005\u0019>tw\rE\u0002(\u0005\u0012K!a\u0011\u0015\u0003\r=\u0003H/[8o!\tYR)\u0003\u0002G\u0019\tqA+[3s\u0019><Gk\\\"mK\u0006t\u0017!E8gMN,G/T1q'V\u0004\b\u000f\\5feB\u00111$S\u0005\u0003\u00152\u0011\u0011c\u00144gg\u0016$X*\u00199TkB\u0004H.[3s\u0003U!\u0018.\u001a:D_6\u0004\u0018m\u0019;j_:lU\r\u001e:jGN\u0004\"aG'\n\u00059c!!\u0006+jKJ\u001cu.\u001c9bGRLwN\\'fiJL7m]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fE\u00136\u000bV+W/B\u00111\u0004\u0001\u0005\u0006=\u001d\u0001\ra\b\u0005\u0006K\u001d\u0001\rA\n\u0005\u0006Y\u001d\u0001\r!\f\u0005\u0006u\u001d\u0001\ra\u000f\u0005\u0006\u000f\u001e\u0001\r\u0001\u0013\u0005\u0006\u0017\u001e\u0001\r\u0001T\u0001\ng>\u0014H\u000fV1tWN$\"A\u00174\u0011\u0007m\u001b'D\u0004\u0002]C:\u0011Q\fY\u0007\u0002=*\u0011q\fF\u0001\u0007yI|w\u000e\u001e \n\u0003%J!A\u0019\u0015\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\u0005\u0019&\u001cHO\u0003\u0002cQ!)q\u0002\u0003a\u00015\u00069a.Z<UCN\\Gc\u0001\u000ej_\")!.\u0003a\u0001W\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003Y6l\u0011\u0001E\u0005\u0003]B\u0011\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000bAL\u0001\u0019A9\u0002\u00115,G/\u00193bi\u0006\u0004\"a\u0006:\n\u0005Mt!aE*uCJ$8\t[1oO\u0016lU\r^1eCR\f\u0017AC7bsB\u0013xnY3tgR\u0011a/\u001f\t\u0003O]L!\u0001\u001f\u0015\u0003\u000f\t{w\u000e\\3b]\")\u0001O\u0003a\u0001uB\u0011qc_\u0005\u0003y:\u0011ab\u00115b]\u001e,W*\u001a;bI\u0006$\u0018\r")
public class CompactionTaskQueue
extends TierTaskQueue<CompactionTask> {
    private final CancellationContext ctx;
    private final Time time;
    private final Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean;
    private final OffsetMapSupplier offsetMapSupplier;
    private final TierCompactionMetrics tierCompactionMetrics;

    @Override
    public List<CompactionTask> sortTasks(List<CompactionTask> tasks) {
        long now = this.time.milliseconds();
        List updated = (List)tasks.map((Function1 & Serializable & scala.Serializable)task -> new Tuple2(task, $this.logToClean.apply(task, (Object)BoxesRunTime.boxToLong((long)now))), List$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Ordering between task tier log to cleans: ").append(updated).toString());
        return (List)((List)((SeqLike)((List)updated.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CompactionTaskQueue.$anonfun$sortTasks$3(x0$1)))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            CompactionTask task = (CompactionTask)x0$2._1();
            Option toCleanOpt = (Option)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)task, toCleanOpt.get());
            return tuple2;
        }, List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> {
            void var1_1;
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TierLogToClean toClean = (TierLogToClean)x0$3._2();
            return var1_1;
        }, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            void var1_1;
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            CompactionTask task = (CompactionTask)x0$4._1();
            return var1_1;
        }, List$.MODULE$.canBuildFrom());
    }

    @Override
    public CompactionTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
        if (!(metadata instanceof StartLeadership)) {
            throw new IllegalStateException(new StringBuilder(18).append("Unexpected change ").append(metadata).toString());
        }
        StartLeadership startLeadership = (StartLeadership)metadata;
        CompactionTask compactionTask = new CompactionTask(this.ctx.subContext(), topicIdPartition, this.offsetMapSupplier, new CompactionTask.CleanLog(startLeadership.leaderEpoch(), (Option<CleanerStats>)None$.MODULE$), this.tierCompactionMetrics, this.time);
        return compactionTask;
    }

    @Override
    public boolean mayProcess(ChangeMetadata metadata) {
        boolean bl = metadata instanceof LeadershipChange;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$sortTasks$3(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        CompactionTask task = (CompactionTask)x0$1._1();
        boolean bl = ((Option)x0$1._2()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.cleanable(task.taskCreationTime())));
        return bl;
    }

    public CompactionTaskQueue(CancellationContext ctx, int maxTasks, Time time, Function2<CompactionTask, Object, Option<TierLogToClean>> logToClean, OffsetMapSupplier offsetMapSupplier, TierCompactionMetrics tierCompactionMetrics) {
        this.ctx = ctx;
        this.time = time;
        this.logToClean = logToClean;
        this.offsetMapSupplier = offsetMapSupplier;
        this.tierCompactionMetrics = tierCompactionMetrics;
        super(ctx, maxTasks, time);
    }
}

