/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierObjectStoreFactory;
import kafka.utils.CoreUtils;
import kafka.utils.checksum.CheckedFileIO;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;

public class DownloadTieredObject {
    private static final String LOG_DIR = "log.dir";
    private static final String LOG_DIR_DOC = "Fully qualified path for log directory where tier state file is located. For example, /mnt/data/data0/logs/lkc-pgngzy_tier_soak_large_topic-0";
    private static final String OBJECT_ID = "object";
    private static final String OBJECT_ID_DOC = "Base64 encoded id of the object to download";
    private static final String FILE_TYPE = "type";
    private static final String FILE_TYPE_DOC = "File type of the object to download. It could be: SEGMENT, OFFSET_INDEX, TIMESTAMP_INDEX, TRANSACTION_INDEX, PRODUCER_STATE, or EPOCH_STATE";
    private static final String DEST_PATH = "dest";
    private static final String DEST_PATH_DOC = "Destination file path";
    private static final String DEFAULT_KAFKA_PROPS_FILE = "/mnt/config/kafka.properties";
    private static final List<String> OBJECT_STORE_REQUIRED_PROPERTIES = Arrays.asList(KafkaConfig.TierMetadataNamespaceProp(), KafkaConfig.TierBackendProp(), KafkaConfig.TierS3RegionProp(), KafkaConfig.TierS3BucketProp(), KafkaConfig.TierS3PrefixProp(), KafkaConfig.TierS3AssumeRoleArnProp(), KafkaConfig.TierS3CredFilePathProp(), KafkaConfig.TierGcsRegionProp(), KafkaConfig.TierGcsBucketProp(), KafkaConfig.TierGcsPrefixProp(), KafkaConfig.TierGcsCredFilePathProp(), KafkaConfig.TierGcsWriteChunkSizeProp(), KafkaConfig.TierAzureBlockBlobContainerProp(), KafkaConfig.TierAzureBlockBlobCredFilePathProp(), KafkaConfig.TierAzureBlockBlobEndpointProp(), KafkaConfig.TierAzureBlockBlobPrefixProp(), KafkaConfig.TierAzureBlockBlobAutoAbortThresholdBytesProp());

    public static void main(String[] args) throws Exception {
        System.out.println();
        System.out.println("!!! WARN !!!");
        System.out.println("!!! DO NOT copy downloaded objects out of cluster broker node. !!!");
        System.out.println("!!! DELETE the downloaded objects after investigation. !!!");
        System.out.println();
        System.out.println("Received cmdline args: " + Arrays.toString(args));
        ArgumentParser cliParser = DownloadTieredObject.createArgumentParser();
        Namespace res = cliParser.parseArgs(args);
        String logDir = res.getString(LOG_DIR).trim();
        String strObjectId = res.getString(OBJECT_ID);
        UUID objectId = CoreUtils.uuidFromBase64(strObjectId);
        String strFileType = res.getString(FILE_TYPE);
        TierObjectStore.FileType fileType = TierObjectStore.FileType.valueOf(strFileType);
        String destPath = res.getString(DEST_PATH);
        String objectStoreConfigFile = res.getString("tier.config").trim();
        TierObjectStore objectStore = DownloadTieredObject.objectStore(objectStoreConfigFile);
        TierObjectStore.ObjectMetadata objectMetadata = DownloadTieredObject.getObjectMetadata(logDir, objectId);
        DownloadTieredObject.downloadObject(objectStore, objectMetadata, fileType, destPath);
    }

    private static ArgumentParser createArgumentParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)DownloadTieredObject.class.getName()).defaultHelp(true).description("Download a tiered object");
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(LOG_DIR)}).dest(LOG_DIR).type(String.class).required(true).help(LOG_DIR_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(OBJECT_ID)}).dest(OBJECT_ID).type(String.class).required(true).help(OBJECT_ID_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(FILE_TYPE)}).dest(FILE_TYPE).type(String.class).required(true).help(FILE_TYPE_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument(DEST_PATH)}).dest(DEST_PATH).type(String.class).required(true).help(DEST_PATH_DOC);
        parser.addArgument(new String[]{RecoveryUtils.makeArgument("tier.config")}).dest("tier.config").type(String.class).required(false).setDefault((Object)DEFAULT_KAFKA_PROPS_FILE).help("The path to a configuration file containing the required properties");
        return parser;
    }

    private static TierObjectStore getObjectStore(Properties props) {
        TierObjectStore.Backend backend = TierObjectStore.Backend.valueOf(props.getProperty(KafkaConfig.TierBackendProp()));
        TierObjectStoreConfig config = TierObjectStoreUtils.generateBackendConfig(backend, props);
        return TierObjectStoreFactory.getObjectStoreInstance(Time.SYSTEM, backend, config);
    }

    private static TierObjectStore objectStore(String objectStoreConfigFile) throws IOException {
        Properties props;
        try {
            props = Utils.loadProps((String)objectStoreConfigFile, OBJECT_STORE_REQUIRED_PROPERTIES);
        }
        catch (IOException e) {
            System.err.println("Exception while loading object store properties from file: " + objectStoreConfigFile);
            throw e;
        }
        TierObjectStore objectStore = DownloadTieredObject.getObjectStore(props);
        System.out.println("Successfully created an instance to object store. Backend: " + objectStore.getBackend().getName());
        return objectStore;
    }

    private static TierObjectStore.ObjectMetadata getObjectMetadata(String logDir, UUID objectId) throws IOException {
        File dir = new File(logDir);
        TopicPartition topicPartition = MergedLog.parseTopicPartitionName(dir);
        System.out.println("TopicPartition: " + topicPartition);
        Optional<File> tierStateFile = Arrays.stream(dir.listFiles()).filter(f -> f.isFile() && MergedLog.isTierStateFile(f)).findFirst();
        if (!tierStateFile.isPresent()) {
            throw new IllegalArgumentException("No Tier state file found at the log directory: " + logDir);
        }
        return DownloadTieredObject.getObjectMetadata(topicPartition, tierStateFile.get(), objectId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static TierObjectStore.ObjectMetadata getObjectMetadata(TopicPartition topicPartition, File tierStateFile, UUID objectId) throws IOException {
        try (CheckedFileIO fileChannel = CheckedFileIO.open(tierStateFile.toPath(), StandardOpenOption.READ);){
            TierObjectMetadata metadata;
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                throw new IllegalArgumentException("Empty header at the tier state file: " + tierStateFile.getAbsolutePath());
            }
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, fileChannel);
            if (!iteratorOpt.isPresent()) {
                throw new IllegalArgumentException("Empty tier state file: " + tierStateFile.getAbsolutePath());
            }
            do {
                if (!iteratorOpt.get().hasNext()) throw new IllegalArgumentException("Object id " + CoreUtils.uuidToBase64(objectId) + " not found in tier state file: " + tierStateFile.getAbsolutePath());
            } while (!(metadata = (TierObjectMetadata)iteratorOpt.get().next()).objectId().equals(objectId));
            TierObjectStore.ObjectMetadata objectMetadata = new TierObjectStore.ObjectMetadata(metadata.topicIdPartition(), metadata.objectId(), metadata.tierEpoch(), metadata.baseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), metadata.opaqueData());
            return objectMetadata;
        }
        catch (IOException e) {
            System.err.println("IO Exception while reading tier state file: " + tierStateFile.getAbsolutePath());
            throw e;
        }
    }

    private static void downloadObject(TierObjectStore objectStore, TierObjectStore.ObjectMetadata objectMetadata, TierObjectStore.FileType fileType, String destFilePath) throws Exception {
        try (TierObjectStoreResponse response = objectStore.getObject(objectMetadata, fileType);){
            InputStream stream = response.getInputStream();
            Path outFile = Paths.get(destFilePath, new String[0]);
            Files.copy(stream, outFile, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("Successfully copied the blob " + objectMetadata.toPath("", fileType) + " to " + outFile);
        }
        catch (Exception ex) {
            System.err.println("Exception while downloading object " + objectMetadata.toPath("", fileType));
            throw ex;
        }
    }
}

