/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.quota.QuotaStateManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\ru!B,Y\u0011\u0003if!B0Y\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007\u0002C5\u0002\u0005\u0004%\t\u0001\u00176\t\rM\f\u0001\u0015!\u0003l\u0011\u0015!\u0018\u0001\"\u0001v\u0011\u001d\t\t\"\u0001C\u0005\u0003'Aq!!\n\u0002\t\u0013\t9\u0003C\u0004\u0002,\u0005!I!!\f\t\u0011\u0005E\u0012\u0001\"\u0001Y\u0003gA\u0001\"!!\u0002\t\u0003A\u00161\u0011\u0004\u000b\u00037\f\u0001\u0013aI\u00015\u0006u\u0007bBAq\u0017\u0019\u0005\u00111\u001d\u0004\u0007\u0005O\tAA!\u000b\t\u0015\t]RB!A!\u0002\u0013\u0011I\u0004\u0003\u0006\u0003F5\u0011\t\u0011)A\u0005\u0005\u000fBaaZ\u0007\u0005\u0002\t%\u0003bBAq\u001b\u0011\u0005#\u0011\u000b\u0005\b\u00057\nA\u0011\u0002B/\u0011\u001d\u0011I)\u0001C\u0005\u0005\u00173a!a%\u0002\u0001\u0005U\u0005BB4\u0015\t\u0003\t9\nC\u0005\u0002\u001aR\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011Q\u0015\u000b!\u0002\u0013\ti\nC\u0005\u0002(R\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011\u0011\u0016\u000b!\u0002\u0013\ti\nC\u0005\u0002,R\u0011\r\u0011\"\u0001\u0002\u001c\"A\u0011Q\u0016\u000b!\u0002\u0013\ti\nC\u0004\u00020R!\t!!-\t\u000f\u0005uF\u0003\"\u0001\u0002@\"9\u0011\u0011\u001a\u000b\u0005\u0002\u0005-\u0007bBAl)\u0011\u0005\u0011\u0011\u001c\u0004\u0007\u0005G\u000bAA!*\t\r\u001d\u0004C\u0011\u0001BU\u0011\u001d\t\t\u000f\tC!\u0005[3aA!.\u0002\t\t]\u0006BB4$\t\u0003\u0011I\fC\u0004\u0002b\u000e\"\tE!0\u0007\r\t\u0005\u0017\u0001\u0002Bb\u0011\u00199g\u0005\"\u0001\u0003F\"9\u0011\u0011\u001d\u0014\u0005B\t%gA\u0002Bg\u0003\u0011\u0011y\r\u0003\u0004hS\u0011\u0005!\u0011\u001b\u0005\n\u0005+L#\u0019!C\u0001\u0005/D\u0001B!:*A\u0003%!\u0011\u001c\u0005\b\u0003CLC\u0011\tBt\r\u0019\u0011Y/\u0001\u0003\u0003n\"A!P\fB\u0001B\u0003%1\u0010\u0003\u0004h]\u0011\u0005!q \u0005\n\u0007\u000bq#\u0019!C\u0001\u0007\u000fA\u0001b!\u0006/A\u0003%1\u0011\u0002\u0005\n\u0007/q#\u0019!C\u0001\u0007\u000fA\u0001b!\u0007/A\u0003%1\u0011\u0002\u0005\n\u00077q#\u0019!C\u0001\u0007\u000fA\u0001b!\b/A\u0003%1\u0011\u0002\u0005\n\u0007?q#\u0019!C\u0001\u0007CA\u0001b!\u000b/A\u0003%11\u0005\u0005\n\u0007Wq#\u0019!C\u0001\u0007[A\u0001ba\u000e/A\u0003%1q\u0006\u0005\n\u0007sq#\u0019!C\u0001\u0007[A\u0001ba\u000f/A\u0003%1q\u0006\u0005\n\u0007{q#\u0019!C\u0001\u0007\u000fA\u0001ba\u0010/A\u0003%1\u0011\u0002\u0005\n\u0007\u0003r#\u0019!C\u0001\u0007\u0007B\u0001ba\u0012/A\u0003%1Q\t\u0005\n\u0007\u0013r#\u0019!C\u0001\u0007\u0007B\u0001ba\u0013/A\u0003%1Q\t\u0005\n\u0007\u001br#\u0019!C\u0001\u0007\u000fA\u0001ba\u0014/A\u0003%1\u0011\u0002\u0005\n\u0007#r#\u0019!C\u0001\u0007\u000fA\u0001ba\u0015/A\u0003%1\u0011\u0002\u0005\n\u0007+r#\u0019!C\u0001\u0007\u000fA\u0001ba\u0016/A\u0003%1\u0011\u0002\u0005\n\u00073r#\u0019!C\u0001\u0007\u000fA\u0001ba\u0017/A\u0003%1\u0011\u0002\u0005\n\u0007;r#\u0019!C\u0001\u0007\u000fA\u0001ba\u0018/A\u0003%1\u0011\u0002\u0005\b\u0007CrC\u0011AB2\u0011)\u0019)H\fEC\u0002\u0013\u00051q\u000f\u0005\u000b\u0005\u0007s\u0003R1A\u0005\u0002\r]\u0004B\u0003B6]!\u0015\r\u0011\"\u0001\u0004x!Q\u00111\t\u0018\t\u0006\u0004%\taa\u001e\t\u0015\u0005eb\u0006#b\u0001\n\u0003\u00199\b\u0003\u0006\u0004z9B)\u0019!C\u0001\u0007wB!\"!\u001f/\u0011\u000b\u0007I\u0011AB@\u0011)\u00119I\fEC\u0002\u0013\u00051q\u0010\u0005\b\u0007\u0003sC\u0011AAm\u0003=!U/\u001c9M_\u001e\u001cVmZ7f]R\u001c(BA-[\u0003\u0015!xn\u001c7t\u0015\u0005Y\u0016!B6bM.\f7\u0001\u0001\t\u0003=\u0006i\u0011\u0001\u0017\u0002\u0010\tVl\u0007\u000fT8h'\u0016<W.\u001a8ugN\u0011\u0011!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0016\u0001\u0004*fG>\u0014H-\u00138eK:$X#A6\u0011\u00051\fX\"A7\u000b\u00059|\u0017\u0001\u00027b]\u001eT\u0011\u0001]\u0001\u0005U\u00064\u0018-\u0003\u0002s[\n11\u000b\u001e:j]\u001e\fQBU3d_J$\u0017J\u001c3f]R\u0004\u0013\u0001B7bS:$\"A^=\u0011\u0005\t<\u0018B\u0001=d\u0005\u0011)f.\u001b;\t\u000bi,\u0001\u0019A>\u0002\t\u0005\u0014xm\u001d\t\u0004Ert\u0018BA?d\u0005\u0015\t%O]1z!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004\rl!!!\u0002\u000b\u0007\u0005\u001dA,\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017\u0019\u0017A\u0002)sK\u0012,g-C\u0002s\u0003\u001fQ1!a\u0003d\u00035!W/\u001c9US\u0016\u00148\u000b^1uKR\u0019a/!\u0006\t\u000f\u0005]a\u00011\u0001\u0002\u001a\u0005!a-\u001b7f!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010_\u0006\u0011\u0011n\\\u0005\u0005\u0003G\tiB\u0001\u0003GS2,\u0017\u0001\u00043v[B$\u0006P\\%oI\u0016DHc\u0001<\u0002*!9\u0011qC\u0004A\u0002\u0005e\u0011A\u00063v[B\u0004&o\u001c3vG\u0016\u0014\u0018\nZ*oCB\u001c\bn\u001c;\u0015\u0007Y\fy\u0003C\u0004\u0002\u0018!\u0001\r!!\u0007\u0002\u0013\u0011,X\u000e]%oI\u0016DHc\u0003<\u00026\u0005]\u0012\u0011IA#\u0003oBq!a\u0006\n\u0001\u0004\tI\u0002C\u0004\u0002:%\u0001\r!a\u000f\u0002\u001f%tG-\u001a=TC:LG/_(oYf\u00042AYA\u001f\u0013\r\tyd\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019%\u0003a\u0001\u0003w\t!B^3sS\u001aLxJ\u001c7z\u0011\u001d\t9%\u0003a\u0001\u0003\u0013\n!$\\5t\u001b\u0006$8\r[3t\r>\u0014\u0018J\u001c3fq\u001aKG.Z:NCB\u0004r!a\u0013\u0002Vy\fI&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u001diW\u000f^1cY\u0016T1!a\u0015d\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003/\niEA\u0002NCB\u0004b!a\u0017\u0002f\u0005-d\u0002BA/\u0003CrA!a\u0001\u0002`%\tA-C\u0002\u0002d\r\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002h\u0005%$\u0001\u0002'jgRT1!a\u0019d!\u001d\u0011\u0017QNA9\u0003cJ1!a\u001cd\u0005\u0019!V\u000f\u001d7feA\u0019!-a\u001d\n\u0007\u0005U4M\u0001\u0003M_:<\u0007bBA=\u0013\u0001\u0007\u00111P\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f!\r\u0011\u0017QP\u0005\u0004\u0003\u007f\u001a'aA%oi\u0006iA-^7q)&lW-\u00138eKb$\u0012B^AC\u0003\u000f\u000bI)a#\t\u000f\u0005]!\u00021\u0001\u0002\u001a!9\u0011\u0011\b\u0006A\u0002\u0005m\u0002bBA\"\u0015\u0001\u0007\u00111\b\u0005\b\u0003\u001bS\u0001\u0019AAH\u0003M!\u0018.\\3J]\u0012,\u0007\u0010R;na\u0016\u0013(o\u001c:t!\r\t\t\nF\u0007\u0002\u0003\t\u0019B+[7f\u0013:$W\r\u001f#v[B,%O]8sgN\u0011A#\u0019\u000b\u0003\u0003\u001f\u000ba$\\5t\u001b\u0006$8\r[3t\r>\u0014H+[7f\u0013:$W\r\u001f$jY\u0016\u001cX*\u00199\u0016\u0005\u0005u\u0005cBA&\u0003+r\u0018q\u0014\t\u0007\u0003\u0017\n\t+a\u001b\n\t\u0005\r\u0016Q\n\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/A\u0010nSNl\u0015\r^2iKN4uN\u001d+j[\u0016Le\u000eZ3y\r&dWm]'ba\u0002\n1c\\;u\u001f\u001a|%\u000fZ3s)&lWm\u001d;b[B\fAc\\;u\u001f\u001a|%\u000fZ3s)&lWm\u001d;b[B\u0004\u0013!F:iC2dwn^(gMN,GOT8u\r>,h\u000eZ\u0001\u0017g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8eA\u00059\"/Z2pe\u0012l\u0015n]7bi\u000eDG+[7f\u0013:$W\r\u001f\u000b\bm\u0006M\u0016QWA]\u0011\u001d\t9\u0002\ba\u0001\u00033Aq!a.\u001d\u0001\u0004\t\t(\u0001\bj]\u0012,\u0007\u0010V5nKN$\u0018-\u001c9\t\u000f\u0005mF\u00041\u0001\u0002r\u0005aAn\\4US6,7\u000f^1na\u0006q\"/Z2pe\u0012|U\u000f^(g\u001fJ$WM]%oI\u0016DH+[7fgR\fW\u000e\u001d\u000b\bm\u0006\u0005\u00171YAc\u0011\u001d\t9\"\ba\u0001\u00033Aq!a.\u001e\u0001\u0004\t\t\bC\u0004\u0002Hv\u0001\r!!\u001d\u0002%A\u0014XM^%oI\u0016DH+[7fgR\fW\u000e]\u0001\u001ce\u0016\u001cwN\u001d3TQ\u0006dGn\\<PM\u001a\u001cX\r\u001e(pi\u001a{WO\u001c3\u0015\u000fY\fi-a4\u0002T\"9\u0011q\u0003\u0010A\u0002\u0005e\u0001bBAi=\u0001\u0007\u0011\u0011O\u0001\fS:$W\r_(gMN,G\u000fC\u0004\u0002Vz\u0001\r!!\u001d\u0002\u00131|wm\u00144gg\u0016$\u0018a\u00039sS:$XI\u001d:peN$\u0012A\u001e\u0002\u000e\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0016\r\u0005}\u0017\u0011\u001fB\u0004'\tY\u0011-A\u0003qCJ\u001cX\r\u0006\u0003\u0002f\n-\u0001c\u00022\u0002n\u0005\u001d(1\u0001\t\u0006E\u0006%\u0018Q^\u0005\u0004\u0003W\u001c'AB(qi&|g\u000e\u0005\u0003\u0002p\u0006EH\u0002\u0001\u0003\b\u0003g\\!\u0019AA{\u0005\u0005Y\u0015\u0003BA|\u0003{\u00042AYA}\u0013\r\tYp\u0019\u0002\b\u001d>$\b.\u001b8h!\r\u0011\u0017q`\u0005\u0004\u0005\u0003\u0019'aA!osB)!-!;\u0003\u0006A!\u0011q\u001eB\u0004\t\u001d\u0011Ia\u0003b\u0001\u0003k\u0014\u0011A\u0016\u0005\b\u0005\u001ba\u0001\u0019\u0001B\b\u0003\u0019\u0011XmY8sIB!!\u0011\u0003B\u0012\u001b\t\u0011\u0019B\u0003\u0003\u0003\u000e\tU!\u0002\u0002B\f\u00053\taaY8n[>t'bA.\u0003\u001c)!!Q\u0004B\u0010\u0003\u0019\t\u0007/Y2iK*\u0011!\u0011E\u0001\u0004_J<\u0017\u0002\u0002B\u0013\u0005'\u0011aAU3d_J$'\u0001\u0006#fG>$WM]'fgN\fw-\u001a)beN,'/\u0006\u0004\u0003,\tE\"QG\n\u0005\u001b\u0005\u0014i\u0003E\u0004\u0002\u0012.\u0011yCa\r\u0011\t\u0005=(\u0011\u0007\u0003\b\u0003gl!\u0019AA{!\u0011\tyO!\u000e\u0005\u000f\t%QB1\u0001\u0002v\u0006Q1.Z=EK\u000e|G-\u001a:\u0011\r\tm\"\u0011\tB\u0018\u001b\t\u0011iDC\u0002\u0003@i\u000b!b]3sS\u0006d\u0017N_3s\u0013\u0011\u0011\u0019E!\u0010\u0003\u000f\u0011+7m\u001c3fe\u0006aa/\u00197vK\u0012+7m\u001c3feB1!1\bB!\u0005g!bAa\u0013\u0003N\t=\u0003cBAI\u001b\t=\"1\u0007\u0005\b\u0005o\u0001\u0002\u0019\u0001B\u001d\u0011\u001d\u0011)\u0005\u0005a\u0001\u0005\u000f\"BAa\u0015\u0003ZA9!-!\u001c\u0003V\t]\u0003#\u00022\u0002j\n=\u0002#\u00022\u0002j\nM\u0002b\u0002B\u0007#\u0001\u0007!qB\u0001\bIVl\u0007\u000fT8h)=1(q\fB1\u0005K\u0012IG!\u001c\u0003\u0002\n\u0015\u0005bBA\f%\u0001\u0007\u0011\u0011\u0004\u0005\b\u0005G\u0012\u0002\u0019AA\u001e\u00035\u0001(/\u001b8u\u0007>tG/\u001a8ug\"9!q\r\nA\u0002\u0005%\u0013!\t8p]\u000e{gn]3dkRLg/\u001a)bSJ\u001chi\u001c:M_\u001e4\u0015\u000e\\3t\u001b\u0006\u0004\bb\u0002B6%\u0001\u0007\u00111H\u0001\u0010SN$U-\u001a9Ji\u0016\u0014\u0018\r^5p]\"9!q\u000e\nA\u0002\tE\u0014A\u00029beN,'\u000f\r\u0004\u0003t\t]$Q\u0010\t\b\u0003#[!Q\u000fB>!\u0011\tyOa\u001e\u0005\u0019\te$QNA\u0001\u0002\u0003\u0015\t!!>\u0003\u0007}#\u0013\u0007\u0005\u0003\u0002p\nuD\u0001\u0004B@\u0005[\n\t\u0011!A\u0003\u0002\u0005U(aA0%e!9!1\u0011\nA\u0002\u0005m\u0012AE:lSB\u0014VmY8sI6+G/\u00193bi\u0006DqAa\"\u0013\u0001\u0004\tY(\u0001\u0005nCb\u0014\u0015\u0010^3t\u0003=\u0001(/\u001b8u\u0005\u0006$8\r\u001b'fm\u0016dG#\u0002<\u0003\u000e\n}\u0005b\u0002BH'\u0001\u0007!\u0011S\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0005'\u0013IJ\u0004\u0003\u0003\u0012\tU\u0015\u0002\u0002BL\u0005'\t!CR5mK2{w-\u00138qkR\u001cFO]3b[&!!1\u0014BO\u0005Y1\u0015\u000e\\3DQ\u0006tg.\u001a7SK\u000e|'\u000f\u001a\"bi\u000eD'\u0002\u0002BL\u0005'AqA!)\u0014\u0001\u0004\t\t(A\tbG\u000e,X.\u001e7bi&4XMQ=uKN\u0014Ac\u00144gg\u0016$8/T3tg\u0006<W\rU1sg\u0016\u00148\u0003\u0002\u0011b\u0005O\u0003R!!%\f}z$\"Aa+\u0011\u0007\u0005E\u0005\u0005\u0006\u0003\u00030\nM\u0006c\u00022\u0002n\tE&\u0011\u0017\t\u0005E\u0006%h\u0010C\u0004\u0003\u000e\t\u0002\rAa\u0004\u00037Q\u0013\u0018M\\:bGRLwN\u001c'pO6+7o]1hKB\u000b'o]3s'\u0011\u0019\u0013Ma*\u0015\u0005\tm\u0006cAAIGQ!!q\u0016B`\u0011\u001d\u0011i!\na\u0001\u0005\u001f\u00111#U;pi\u0006\u001cX*Z:tC\u001e,\u0007+\u0019:tKJ\u001cBAJ1\u0003(R\u0011!q\u0019\t\u0004\u0003#3C\u0003\u0002BX\u0005\u0017DqA!\u0004)\u0001\u0004\u0011yAA\u0010DYV\u001cH/\u001a:NKR\fG-\u0019;b\u0019><W*Z:tC\u001e,\u0007+\u0019:tKJ\u001cB!K1\u0003(R\u0011!1\u001b\t\u0004\u0003#K\u0013aE7fi\u0006$\u0017\r^1SK\u000e|'\u000fZ*fe\u0012,WC\u0001Bm!\u0011\u0011YN!9\u000e\u0005\tu'\u0002\u0002Bp\u00053\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0005G\u0014iNA\nNKR\fG-\u0019;b%\u0016\u001cwN\u001d3TKJ$W-\u0001\u000bnKR\fG-\u0019;b%\u0016\u001cwN\u001d3TKJ$W\r\t\u000b\u0005\u0005_\u0013I\u000fC\u0004\u0003\u000e5\u0002\rAa\u0004\u0003-\u0011+X\u000e\u001d'pON+w-\\3oiN|\u0005\u000f^5p]N\u001c2A\fBx!\u0011\u0011\tPa?\u000e\u0005\tM(\u0002\u0002B{\u0005o\fA!\u001e;jY*!!\u0011 B\r\u0003\u0019\u0019XM\u001d<fe&!!Q Bz\u0005U\u0019u.\\7b]\u0012$UMZ1vYR|\u0005\u000f^5p]N$Ba!\u0001\u0004\u0004A\u0019\u0011\u0011\u0013\u0018\t\u000bi\u0004\u0004\u0019A>\u0002\u0011A\u0014\u0018N\u001c;PaR,\"a!\u0003\u0011\t\r-1\u0011C\u0007\u0003\u0007\u001bQ!aa\u0004\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0003\u0004\u0014\r5!!E(qi&|gn\u00159fG\n+\u0018\u000e\u001c3fe\u0006I\u0001O]5oi>\u0003H\u000fI\u0001\nm\u0016\u0014\u0018NZ=PaR\f!B^3sS\u001aLx\n\u001d;!\u00039Ig\u000eZ3y'\u0006t\u0017\u000e^=PaR\fq\"\u001b8eKb\u001c\u0016M\\5us>\u0003H\u000fI\u0001\tM&dWm](qiV\u001111\u0005\t\u0006\u0007\u0017\u0019)C`\u0005\u0005\u0007O\u0019iAA\u000eBe\u001e,X.\u001a8u\u0003\u000e\u001cW\r\u001d;j]\u001e|\u0005\u000f^5p]N\u0003XmY\u0001\nM&dWm](qi\u0002\n\u0011#\\1y\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\t\u0019y\u0003\u0005\u0004\u0004\f\r\u00152\u0011\u0007\t\u0004Y\u000eM\u0012bAB\u001b[\n9\u0011J\u001c;fO\u0016\u0014\u0018AE7bq6+7o]1hKNK'0Z(qi\u0002\n1\"\\1y\u0005f$Xm](qi\u0006aQ.\u0019=CsR,7o\u00149uA\u0005\u0001B-Z3q\u0013R,'/\u0019;j_:|\u0005\u000f^\u0001\u0012I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\u0004\u0013a\u0004<bYV,G)Z2pI\u0016\u0014x\n\u001d;\u0016\u0005\r\u0015\u0003#BB\u0006\u0007KY\u0017\u0001\u0005<bYV,G)Z2pI\u0016\u0014x\n\u001d;!\u00035YW-\u001f#fG>$WM](qi\u0006q1.Z=EK\u000e|G-\u001a:PaR\u0004\u0013AC8gMN,Go](qi\u0006YqN\u001a4tKR\u001cx\n\u001d;!\u0003E!(/\u00198tC\u000e$\u0018n\u001c8M_\u001e|\u0005\u000f^\u0001\u0013iJ\fgn]1di&|g\u000eT8h\u001fB$\b%\u0001\ndYV\u001cH/\u001a:NKR\fG-\u0019;b\u001fB$\u0018aE2mkN$XM]'fi\u0006$\u0017\r^1PaR\u0004\u0013!F:lSB\u0014VmY8sI6+G/\u00193bi\u0006|\u0005\u000f^\u0001\u0017g.L\u0007OU3d_J$W*\u001a;bI\u0006$\u0018m\u00149uA\u0005I\u0011/^8uCN|\u0005\u000f^\u0001\u000bcV|G/Y:PaR\u0004\u0013!D7fgN\fw-\u001a)beN,'/\u0006\u0002\u0004fA21qMB6\u0007c\u0002r!!%\f\u0007S\u001ay\u0007\u0005\u0003\u0002p\u000e-DaCB7\u001b\u0006\u0005\t\u0011!B\u0001\u0003k\u00141a\u0018\u00134!\u0011\tyo!\u001d\u0005\u0017\rMT*!A\u0001\u0002\u000b\u0005\u0011Q\u001f\u0002\u0004?\u0012\"\u0014AE:i_VdG\r\u0015:j]R$\u0015\r^1M_\u001e,\"!a\u000f\u0002\u000b\u0019LG.Z:\u0016\u0005\ru\u0004c\u00012}WV\u0011\u00111P\u0001\nG\",7m[!sON\u0004")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    private static class ClusterMetadataLogMessageParser
    implements MessageParser<String, String> {
        private final MetadataRecordSerde metadataRecordSerde = new MetadataRecordSerde();

        public MetadataRecordSerde metadataRecordSerde() {
            return this.metadataRecordSerde;
        }

        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            String string;
            try {
                ApiMessageAndVersion messageAndVersion = this.metadataRecordSerde().read((Readable)new ByteBufferAccessor(record.value()), record.valueSize());
                ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
                json.set("type", (JsonNode)new TextNode(MetadataRecordType.fromId((short)messageAndVersion.message().apiKey()).toString()));
                json.set("version", (JsonNode)new IntNode((int)messageAndVersion.version()));
                json.set("data", MetadataJsonConverters.writeJson((ApiMessage)messageAndVersion.message(), (short)messageAndVersion.version()));
                string = json.toString();
            }
            catch (Throwable e) {
                string = new StringBuilder(21).append("Error at ").append(record.offset()).append(", skipping. ").append(e.getMessage()).toString();
            }
            String output = string;
            return new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)output));
        }
    }

    private static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record) {
            None$ key;
            Object object = key = record.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.key()))) : None$.MODULE$;
            if (!record.hasValue()) {
                return new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record.value())));
            return new Tuple2((Object)key, (Object)payload);
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    private static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private boolean shouldPrintDataLog;
        private boolean skipRecordMetadata;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private int maxBytes;
        private final OptionSpecBuilder printOpt;
        private final OptionSpecBuilder verifyOpt;
        private final OptionSpecBuilder indexSanityOpt;
        private final ArgumentAcceptingOptionSpec<String> filesOpt;
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt;
        private final ArgumentAcceptingOptionSpec<Integer> maxBytesOpt;
        private final OptionSpecBuilder deepIterationOpt;
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt;
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt;
        private final OptionSpecBuilder offsetsOpt;
        private final OptionSpecBuilder transactionLogOpt;
        private final OptionSpecBuilder clusterMetadataOpt;
        private final OptionSpecBuilder skipRecordMetadataOpt;
        private final OptionSpecBuilder quotasOpt;
        private volatile byte bitmap$0;

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxBytesOpt() {
            return this.maxBytesOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public OptionSpecBuilder clusterMetadataOpt() {
            return this.clusterMetadataOpt;
        }

        public OptionSpecBuilder skipRecordMetadataOpt() {
            return this.skipRecordMetadataOpt;
        }

        public OptionSpecBuilder quotasOpt() {
            return this.quotasOpt;
        }

        public MessageParser<?, ?> messageParser() {
            if (this.options.has((OptionSpec)this.offsetsOpt())) {
                return new OffsetsMessageParser();
            }
            if (this.options.has((OptionSpec)this.transactionLogOpt())) {
                return new TransactionLogMessageParser();
            }
            if (this.options.has((OptionSpec)this.clusterMetadataOpt())) {
                return new ClusterMetadataLogMessageParser();
            }
            if (this.options.has((OptionSpec)this.quotasOpt())) {
                return new QuotasMessageParser();
            }
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options.valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options.valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            return new DecoderMessageParser(keyDecoder, valueDecoder);
        }

        private boolean shouldPrintDataLog$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options.has((OptionSpec)this.printOpt()) || this.options.has((OptionSpec)this.offsetsOpt()) || this.options.has((OptionSpec)this.transactionLogOpt()) || this.options.has((OptionSpec)this.clusterMetadataOpt()) || this.options.has((OptionSpec)this.quotasOpt()) || this.options.has(this.valueDecoderOpt()) || this.options.has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.shouldPrintDataLog;
        }

        public boolean shouldPrintDataLog() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.shouldPrintDataLog$lzycompute();
            }
            return this.shouldPrintDataLog;
        }

        private boolean skipRecordMetadata$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.skipRecordMetadata = this.options.has((OptionSpec)this.skipRecordMetadataOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.skipRecordMetadata;
        }

        public boolean skipRecordMetadata() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.skipRecordMetadata$lzycompute();
            }
            return this.skipRecordMetadata;
        }

        private boolean isDeepIteration$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.isDeepIteration = this.options.has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
            }
            return this.isDeepIteration;
        }

        public boolean isDeepIteration() {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                return this.isDeepIteration$lzycompute();
            }
            return this.isDeepIteration;
        }

        private boolean verifyOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.verifyOnly = this.options.has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
            }
            return this.verifyOnly;
        }

        public boolean verifyOnly() {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                return this.verifyOnly$lzycompute();
            }
            return this.verifyOnly;
        }

        private boolean indexSanityOnly$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.indexSanityOnly = this.options.has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
            }
            return this.indexSanityOnly;
        }

        public boolean indexSanityOnly() {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                return this.indexSanityOnly$lzycompute();
            }
            return this.indexSanityOnly;
        }

        private String[] files$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.files = ((String)this.options.valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
            }
            return this.files;
        }

        public String[] files() {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                return this.files$lzycompute();
            }
            return this.files;
        }

        private int maxMessageSize$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x40) == 0) {
                    this.maxMessageSize = (Integer)this.options.valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
                }
            }
            return this.maxMessageSize;
        }

        public int maxMessageSize() {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                return this.maxMessageSize$lzycompute();
            }
            return this.maxMessageSize;
        }

        private int maxBytes$lzycompute() {
            synchronized (this) {
                if ((byte)(this.bitmap$0 & 0x80) == 0) {
                    this.maxBytes = (Integer)this.options.valueOf(this.maxBytesOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
                }
            }
            return this.maxBytes;
        }

        public int maxBytes() {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                return this.maxBytes$lzycompute();
            }
            return this.maxBytes;
        }

        public void checkArgs() {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.filesOpt()});
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args);
            this.printOpt = this.parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
            this.verifyOpt = this.parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
            this.indexSanityOpt = this.parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
            this.filesOpt = this.parser.accepts("files", "REQUIRED: The comma separated list of files to be dumped. The supported file types include log files, index files, time index files, transaction index files, producer snapshots and tier state files.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
            this.maxMessageSizeOpt = this.parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
            this.maxBytesOpt = this.parser.accepts("max-bytes", "Limit the amount of total batches read in bytes avoiding reading the whole .log file(s).").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), (Object[])new Integer[0]);
            this.deepIterationOpt = this.parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
            this.valueDecoderOpt = this.parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
            this.keyDecoderOpt = this.parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
            this.offsetsOpt = this.parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
            this.transactionLogOpt = this.parser.accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
            this.clusterMetadataOpt = this.parser.accepts("cluster-metadata-decoder", "if set, log data will be parsed as cluster metadata records.");
            this.skipRecordMetadataOpt = this.parser.accepts("skip-record-metadata", "whether to skip printing metadata for each record.");
            this.quotasOpt = this.parser.accepts("quotas-decoder", "if set, log data will be parsed as quotas data from the _confluent-quotas topic");
            this.options = this.parser.parse(args);
        }
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    private static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    private static class QuotasMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return QuotaStateManager$.MODULE$.formatRecordKeyAndValue(record);
        }
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (misMatchesSeq.isEmpty()) {
                this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
            }
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (outOfOrderSeq.isEmpty()) {
                this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq);
            }
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer());
            if (shallowOffsetNotFoundSeq.isEmpty()) {
                this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq);
            }
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$1(x0$1);
                return BoxedUnit.UNIT;
            });
            this.outOfOrderTimestamp().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$3(x0$2);
                return BoxedUnit.UNIT;
            });
            this.shallowOffsetNotFound().values().foreach((Function1 & Serializable & scala.Serializable)listOfShallowOffsetNotFound -> {
                TimeIndexDumpErrors.$anonfun$printErrors$5(listOfShallowOffsetNotFound);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$printErrors$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                String fileName = (String)x0$1._1();
                ArrayBuffer listOfMismatches = (ArrayBuffer)x0$1._2();
                System.err.println(new StringBuilder(29).append("Found timestamp mismatch in :").append(fileName).toString());
                listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$3(Tuple2 x0$2) {
            if (x0$2 != null) {
                String fileName = (String)x0$2._1();
                ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)x0$2._2();
                System.err.println(new StringBuilder(33).append("Found out of order timestamp in :").append(fileName).toString());
                outOfOrderTimestamps.foreach((Function1 & Serializable & scala.Serializable)m -> {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                    return BoxedUnit.UNIT;
                });
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$6(Tuple2 x0$3) {
            if (x0$3 != null) {
                long indexedOffset = x0$3._1$mcJ$sp();
                long logOffset = x0$3._2$mcJ$sp();
                System.err.println(new StringBuilder(36).append("Indexed offset: ").append(indexedOffset).append(", found log offset: ").append(logOffset).toString());
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printErrors$5(ArrayBuffer listOfShallowOffsetNotFound) {
            System.err.println("The following indexed offsets are not found in the log.");
            listOfShallowOffsetNotFound.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TimeIndexDumpErrors.$anonfun$printErrors$6(x0$3);
                return BoxedUnit.UNIT;
            });
        }
    }

    private static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record);
        }
    }
}

