/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcherBlockingSend;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\u000b\u0016\tiA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\u0005\u0004!\u0011!Q\u0001\nuC\u0001B\u0019\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tG\u0002\u0011\t\u0011)A\u0005;\"AA\r\u0001B\u0001B\u0003%Q\f\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u000bI\u0004A\u0011A:\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\b\u0001\u0001\u0006I!!\u0003\t\u0013\u0005E\u0001A1A\u0005\n\u0005M\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\u0006\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\tq!+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(B\u0001\f\u0018\u0003\u0015!xn\u001c7t\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0004\u0001mA\u0003C\u0001\u000f'\u001b\u0005i\"B\u0001\u0010 \u0003\u0011)H/\u001b7\u000b\u0005\u0001\n\u0013AB:feZ,'O\u0003\u0002\u0019E)\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0013\t9SD\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007CA\u0015-\u001b\u0005Q#BA\u0016\u0018\u0003\u0015)H/\u001b7t\u0013\ti#FA\u0004M_\u001e<\u0017N\\4\u0002\t9\fW.\u001a\t\u0003aer!!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0005QJ\u0012A\u0002\u001fs_>$hHC\u00017\u0003\u0015\u00198-\u00197b\u0013\tAT'\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d6\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tq\u0014)D\u0001@\u0015\t\u0001\u0015%\u0001\u0004d_6lwN\\\u0005\u0003\u0005~\u0012AAT8eK\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0002F\u00156s!A\u0012%\u000f\u0005I:\u0015\"\u0001\u001c\n\u0005%+\u0014a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003\u0013V\u0002\"A\u0010(\n\u0005={$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\ti>\u0004\u0018nY%egB!\u0001GU\u0018U\u0013\t\u00196HA\u0002NCB\u0004\"AP+\n\u0005Y{$\u0001B+vS\u0012\fQB]3qY&\u001c\u0017MQ;gM\u0016\u0014\bCA-[\u001b\u0005)\u0012BA.\u0016\u00055\u0011V\r\u001d7jG\u0006\u0014UO\u001a4fe\u0006i1o\\2lKR$\u0016.\\3pkR\u0004\"AX0\u000e\u0003UJ!\u0001Y\u001b\u0003\u0007%sG/\u0001\tt_\u000e\\W\r\u001e\"vM\u001a,'oU5{K\u0006Ia-\u001a;dQNK'0Z\u0001\b[\u0006Dx+Y5u\u0003!i\u0017N\u001c\"zi\u0016\u001c\u0018A\u00043p-\u0016\u0014\u0018NZ5dCRLwN\u001c\t\u0003=\u001eL!\u0001[\u001b\u0003\u000f\t{w\u000e\\3b]\u0006q1m\u001c8tk6,'oQ8oM&<\u0007CA6p\u001b\u0005a'B\u0001\u0010n\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001\u001d7\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005gKR\u001c\u0007.\u001a:JI\u00061A(\u001b8jiz\"\u0002\u0003^;wobL(p\u001f?~}~\f\t!a\u0001\u0011\u0005e\u0003\u0001\"\u0002\u0018\u000f\u0001\u0004y\u0003\"\u0002\u001f\u000f\u0001\u0004i\u0004\"B\"\u000f\u0001\u0004!\u0005\"\u0002)\u000f\u0001\u0004\t\u0006\"B,\u000f\u0001\u0004A\u0006\"\u0002/\u000f\u0001\u0004i\u0006\"B1\u000f\u0001\u0004i\u0006\"\u00022\u000f\u0001\u0004i\u0006\"B2\u000f\u0001\u0004i\u0006\"\u00023\u000f\u0001\u0004i\u0006\"B3\u000f\u0001\u00041\u0007\"B5\u000f\u0001\u0004Q\u0007\"B9\u000f\u0001\u0004i\u0016!\u00044fi\u000eDWI\u001c3q_&tG/\u0006\u0002\u0002\nA\u0019\u0011,a\u0003\n\u0007\u00055QC\u0001\u000eSKBd\u0017nY1GKR\u001c\u0007.\u001a:CY>\u001c7.\u001b8h'\u0016tG-\u0001\bgKR\u001c\u0007.\u00128ea>Lg\u000e\u001e\u0011\u0002\u0015Q|\u0007/[2OC6,7/\u0006\u0002\u0002\u0016A1\u0011qCA\u0011)>j!!!\u0007\u000b\t\u0005m\u0011QD\u0001\nS6lW\u000f^1cY\u0016T1!a\b6\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004'\u0006e\u0011a\u0003;pa&\u001cg*Y7fg\u0002\na\u0001Z8X_J\\GCAA\u0015!\rq\u00161F\u0005\u0004\u0003[)$\u0001B+oSR\u0004")
public class ReplicaFetcher
extends ShutdownableThread
implements Logging {
    private final Node sourceBroker;
    private final Iterable<TopicPartition> topicPartitions;
    private final Map<String, Uuid> topicIds;
    private final ReplicaBuffer replicaBuffer;
    private final int fetchSize;
    private final int maxWait;
    private final int minBytes;
    private final boolean doVerification;
    private final ReplicaFetcherBlockingSend fetchEndpoint;
    private final Map<Uuid, String> topicNames;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReplicaFetcherBlockingSend fetchEndpoint() {
        return this.fetchEndpoint;
    }

    private Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block7: {
            block6: {
                fetcherBarrier = this.replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.replicaBuffer.getVerificationBarrier();
                LinkedHashMap requestMap = new LinkedHashMap();
                this.topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> requestMap.put(topicPartition, new FetchRequest.PartitionData((Uuid)$this.topicIds.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), $this.replicaBuffer.getOffset((TopicPartition)topicPartition), 0L, $this.fetchSize, Optional.empty())));
                FetchRequest.Builder fetchRequestBuilder = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)-2, (long)-1L, (int)this.maxWait, (int)this.minBytes, requestMap);
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Issuing fetch request ");
                FetchResponse fetchResponse = null;
                try {
                    fetchResponse = (FetchResponse)this.fetchEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequestBuilder).responseBody();
                }
                finally {
                    if (fetchResponse != null) {
                    }
                    break block6;
                }
                fetchResponse.responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topicNames()).asJava(), ApiKeys.FETCH.latestVersion()).forEach((tp, partitionData) -> $this.replicaBuffer.addFetchedData((TopicPartition)tp, $this.sourceBroker.id(), (FetchResponseData.PartitionData)partitionData));
                break block7;
            }
            this.topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                this.replicaBuffer.addFetchedData(topicAndPartition, this.sourceBroker.id(), FetchResponse.partitionResponse((int)topicAndPartition.partition(), (Errors)Errors.NONE));
                return BoxedUnit.UNIT;
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done fetching");
        fetcherBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ready for verification");
        if (this.doVerification) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Do verification");
            this.replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            this.replicaBuffer.createNewFetcherBarrier();
            this.replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Created new barrier");
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Done verification");
    }

    public ReplicaFetcher(String name, Node sourceBroker, Iterable<TopicPartition> topicPartitions, Map<String, Uuid> topicIds, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification, Properties consumerConfig, int fetcherId) {
        this.sourceBroker = sourceBroker;
        this.topicPartitions = topicPartitions;
        this.topicIds = topicIds;
        this.replicaBuffer = replicaBuffer;
        this.fetchSize = fetchSize;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.doVerification = doVerification;
        super(name);
        Logging.$init$(this);
        this.logIdent_$eq(this.logPrefix);
        this.fetchEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, new ConsumerConfig(consumerConfig), new Metrics(), Time.SYSTEM, fetcherId, new StringBuilder(16).append("broker-").append(-2).append("-fetcher-").append(fetcherId).toString());
        this.topicNames = (Map)topicIds.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.swap(), Map$.MODULE$.canBuildFrom());
    }
}

