/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.OptionalLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    public static final OptionalLong PID = ProcessUtils.currentPid();

    private static OptionalLong currentPid() {
        try {
            Class<?> clazz = Class.forName("java.lang.ProcessHandle");
            MethodHandle currentMethod = MethodHandles.publicLookup().findStatic(clazz, "current", MethodType.methodType(clazz));
            Object processHandle = currentMethod.invoke();
            MethodHandle pidMethod = MethodHandles.publicLookup().findVirtual(clazz, "pid", MethodType.methodType(Long.TYPE));
            return OptionalLong.of(pidMethod.invoke(processHandle));
        }
        catch (ReflectiveOperationException | UnsupportedOperationException e) {
            log.debug("Could not determine process id", (Throwable)e);
            return OptionalLong.empty();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

