/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BrokerHealthZNode$ {
    public static BrokerHealthZNode$ MODULE$;

    static {
        new BrokerHealthZNode$();
    }

    public String path() {
        return "/leadership_priority";
    }

    public byte[] encode(Map<Object, Set<DegradedBrokerComponent>> brokerHealthInfo) {
        return Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"brokers"), CollectionConverters$.MODULE$.asJavaIterableConverter((Iterable)brokerHealthInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int brokerId = x0$1._1$mcI$sp();
            Set degradedBrokerComponents = (Set)x0$1._2();
            java.util.Map map = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)brokerId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reasons"), CollectionConverters$.MODULE$.seqAsJavaListConverter(((SetLike)degradedBrokerComponents.map((Function1 & Serializable & scala.Serializable)degradedBrokerComponent -> degradedBrokerComponent.reason(), Set$.MODULE$.canBuildFrom())).toSeq()).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"degradedBrokerHealthStates"), CollectionConverters$.MODULE$.seqAsJavaListConverter(((SetLike)degradedBrokerComponents.map((Function1 & Serializable & scala.Serializable)degradedBrokerComponent -> (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)degradedBrokerComponent.reason()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)BoxesRunTime.boxToByte((byte)degradedBrokerComponent.brokerComponent().id()))}))).asJava(), Set$.MODULE$.canBuildFrom())).toSeq()).asJava())}))).asJava();
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<Object, Set<DegradedBrokerComponent>> decode(byte[] bytes) {
        if (bytes == null) {
            return Map$.MODULE$.empty();
        }
        Either<JsonProcessingException, JsonValue> either = Json$.MODULE$.tryParseBytes(bytes);
        if (either instanceof Right) {
            Map map;
            JsonObject brokerHealthInfo = ((JsonValue)((Right)either).value()).asJsonObject();
            int version = BoxesRunTime.unboxToInt((Object)brokerHealthInfo.apply("version").to(DecodeJson$DecodeInt$.MODULE$));
            if (version == 0) {
                map = (Map)brokerHealthInfo.get("brokers").map((Function1 & Serializable & scala.Serializable)brokers -> brokers.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.asJsonObject()).map((Function1 & Serializable & scala.Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(broker.apply("id").to(DecodeJson$DecodeInt$.MODULE$)), MODULE$.decodeReasons((JsonObject)broker))).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
                return map;
            } else {
                if (version < 1) throw new IllegalArgumentException(new StringBuilder(25).append("Valid version not found: ").append(version).toString());
                map = (Map)brokerHealthInfo.get("brokers").map((Function1 & Serializable & scala.Serializable)brokers -> brokers.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.asJsonObject()).map((Function1 & Serializable & scala.Serializable)broker -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(broker.apply("id").to(DecodeJson$DecodeInt$.MODULE$)), broker.apply("degradedBrokerHealthStates").asJsonArray() == null || broker.apply("degradedBrokerHealthStates").asJsonArray().iterator().isEmpty() ? MODULE$.decodeReasons((JsonObject)broker) : MODULE$.decodeDegradedBrokerHealthStates((JsonObject)broker))).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
            }
            return map;
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        JsonProcessingException e = (JsonProcessingException)((Left)either).value();
        throw new IllegalArgumentException(new StringBuilder(43).append("Failed to parse broker health information: ").append(new String(bytes, StandardCharsets.UTF_8)).toString(), (Throwable)e);
    }

    private Set<DegradedBrokerComponent> decodeReasons(JsonObject broker) {
        return broker.apply("reasons").asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)reason -> new DegradedBrokerComponent(reason.to(DecodeJson$DecodeString$.MODULE$), BrokerComponent.UNSPECIFIED.id())).toSet();
    }

    private Set<DegradedBrokerComponent> decodeDegradedBrokerHealthStates(JsonObject broker) {
        return broker.apply("degradedBrokerHealthStates").asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)record -> new DegradedBrokerComponent(record.asJsonObject().apply("reason").to(DecodeJson$DecodeString$.MODULE$), (byte)BoxesRunTime.unboxToInt((Object)record.asJsonObject().apply("component").to(DecodeJson$DecodeInt$.MODULE$)))).toSet();
    }

    private BrokerHealthZNode$() {
        MODULE$ = this;
    }
}

